import numpy
import pydrake.geometry
import pydrake.lcm
import pydrake.math
import pydrake.multibody.plant
import pydrake.systems.framework
import pydrake.systems.lcm
import pydrake.systems.sensors
from pydrake.common.cpp_template import MeshcatPoseSliders_ as MeshcatPoseSliders_
from pydrake.visualization._meldis import Meldis as Meldis
from pydrake.visualization._model_visualizer import ModelVisualizer as ModelVisualizer
from pydrake.visualization._plotting import plot_sublevelset_expression as plot_sublevelset_expression, plot_sublevelset_quadratic as plot_sublevelset_quadratic
from pydrake.visualization._triad import AddFrameTriadIllustration as AddFrameTriadIllustration
from pydrake.visualization._video import VideoWriter as VideoWriter
from typing import ClassVar, overload

class ColorizeDepthImage(pydrake.systems.framework.LeafSystem):
    invalid_color: pydrake.geometry.Rgba
    def __init__(self) -> None: ...
    @overload
    def Calc(self, arg0: pydrake.systems.sensors.ImageTPixelTypepkDepth32FU, arg1: pydrake.systems.sensors.ImageTPixelTypepkRgba8UU) -> None: ...
    @overload
    def Calc(self, arg0: pydrake.systems.sensors.ImageTPixelTypepkDepth16UU, arg1: pydrake.systems.sensors.ImageTPixelTypepkRgba8UU) -> None: ...

class ColorizeLabelImage(pydrake.systems.framework.LeafSystem):
    background_color: pydrake.geometry.Rgba
    def __init__(self) -> None: ...
    def Calc(self, arg0: pydrake.systems.sensors.ImageTPixelTypepkLabel16IU, arg1: pydrake.systems.sensors.ImageTPixelTypepkRgba8UU) -> None: ...

class ConcatenateImages(pydrake.systems.framework.LeafSystem):
    def __init__(self, rows: int = ..., cols: int = ...) -> None: ...
    def get_input_port(self, row: int, col: int) -> pydrake.systems.framework.InputPort: ...

class MeshcatPoseSliders(pydrake.systems.framework.LeafSystem):
    def __init__(self, meshcat: pydrake.geometry.Meshcat, initial_pose: pydrake.math.RigidTransform = ..., lower_limit: numpy.ndarray[numpy.float64[6, 1]] = ..., upper_limit: numpy.ndarray[numpy.float64[6, 1]] = ..., step: numpy.ndarray[numpy.float64[6, 1]] = ..., decrement_keycodes: list[str] = ..., increment_keycodes: list[str] = ..., prefix: str = ..., visible: numpy.ndarray[bool[6, 1]] = ...) -> None: ...
    def Delete(self) -> None: ...
    def Run(self, system: pydrake.systems.framework.System, context: pydrake.systems.framework.Context, timeout: float | None = ..., stop_button_keycode: str = ...) -> pydrake.math.RigidTransform: ...
    def SetPose(self, pose: pydrake.math.RigidTransform) -> None: ...

class MeshcatPoseSliders_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, meshcat: pydrake.geometry.Meshcat, initial_pose: pydrake.math.RigidTransform = ..., lower_limit: numpy.ndarray[numpy.float64[6, 1]] = ..., upper_limit: numpy.ndarray[numpy.float64[6, 1]] = ..., step: numpy.ndarray[numpy.float64[6, 1]] = ..., decrement_keycodes: list[str] = ..., increment_keycodes: list[str] = ..., prefix: str = ..., visible: numpy.ndarray[bool[6, 1]] = ...) -> None: ...
    def Delete(self) -> None: ...
    def Run(self, system: pydrake.systems.framework.System_TAutoDiffXdU, context: pydrake.systems.framework.Context_TAutoDiffXdU, timeout: float | None = ..., stop_button_keycode: str = ...) -> pydrake.math.RigidTransform: ...
    def SetPose(self, pose: pydrake.math.RigidTransform) -> None: ...

class VisualizationConfig:
    __fields__: ClassVar[tuple] = ...  # read-only
    default_illustration_color: pydrake.geometry.Rgba
    default_proximity_color: pydrake.geometry.Rgba
    delete_on_initialization_event: bool
    enable_alpha_sliders: bool
    enable_meshcat_creation: bool
    initial_proximity_alpha: float
    lcm_bus: str
    publish_contacts: bool
    publish_illustration: bool
    publish_inertia: bool
    publish_period: float
    publish_proximity: bool
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> VisualizationConfig: ...
    def __deepcopy__(self, arg0: dict) -> VisualizationConfig: ...

class _TemporaryName_N5drake13visualization18MeshcatPoseSlidersIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, meshcat: pydrake.geometry.Meshcat, initial_pose: pydrake.math.RigidTransform = ..., lower_limit: numpy.ndarray[numpy.float64[6, 1]] = ..., upper_limit: numpy.ndarray[numpy.float64[6, 1]] = ..., step: numpy.ndarray[numpy.float64[6, 1]] = ..., decrement_keycodes: list[str] = ..., increment_keycodes: list[str] = ..., prefix: str = ..., visible: numpy.ndarray[bool[6, 1]] = ...) -> None: ...
    def Delete(self) -> None: ...
    def Run(self, system: pydrake.systems.framework.System_TAutoDiffXdU, context: pydrake.systems.framework.Context_TAutoDiffXdU, timeout: float | None = ..., stop_button_keycode: str = ...) -> pydrake.math.RigidTransform: ...
    def SetPose(self, pose: pydrake.math.RigidTransform) -> None: ...

def AddDefaultVisualization(builder: pydrake.systems.framework.DiagramBuilder, meshcat: pydrake.geometry.Meshcat = ...) -> None: ...
def ApplyVisualizationConfig(config: VisualizationConfig, builder: pydrake.systems.framework.DiagramBuilder, lcm_buses: pydrake.systems.lcm.LcmBuses = ..., plant: pydrake.multibody.plant.MultibodyPlant = ..., scene_graph: pydrake.geometry.SceneGraph = ..., meshcat: pydrake.geometry.Meshcat = ..., lcm: pydrake.lcm.DrakeLcmInterface = ...) -> None: ...
