import flags
import numpy
import pydrake.autodiffutils
import pydrake.common
import pydrake.common.eigen_geometry
import pydrake.math
import pydrake.polynomial
import pydrake.symbolic
import scipy.sparse
from pydrake.common.cpp_template import BezierCurve_ as BezierCurve_, BsplineTrajectory_ as BsplineTrajectory_, CompositeTrajectory_ as CompositeTrajectory_, DerivativeTrajectory_ as DerivativeTrajectory_, DiscreteTimeTrajectory_ as DiscreteTimeTrajectory_, ExponentialPlusPiecewisePolynomial_ as ExponentialPlusPiecewisePolynomial_, FunctionHandleTrajectory_ as FunctionHandleTrajectory_, PathParameterizedTrajectory_ as PathParameterizedTrajectory_, PiecewisePolynomial_ as PiecewisePolynomial_, PiecewisePose_ as PiecewisePose_, PiecewiseQuaternionSlerp_ as PiecewiseQuaternionSlerp_, PiecewiseTrajectory_ as PiecewiseTrajectory_, StackedTrajectory_ as StackedTrajectory_, Trajectory_ as Trajectory_
from typing import Any, Callable, ClassVar, overload

__getattr__: Callable

class BezierCurve(Trajectory):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, start_time: float, end_time: float, control_points: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...
    @overload
    def AsLinearInControlPoints(self, derivative_order: int = ...) -> scipy.sparse.csc_matrix[numpy.float64]: ...
    @overload
    def AsLinearInControlPoints(self, n) -> Any: ...
    def BernsteinBasis(self, i: int, time: float, order: int | None = ...) -> float: ...
    def ElevateOrder(self) -> None: ...
    def GetExpression(self, time: pydrake.symbolic.Variable = ...) -> numpy.ndarray[object[m, 1]]: ...
    def control_points(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def order(self) -> int: ...
    def __copy__(self) -> BezierCurve: ...
    def __deepcopy__(self, arg0: dict) -> BezierCurve: ...

class BezierCurve_𝓣AutoDiffXd𝓤(Trajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, start_time: float, end_time: float, control_points: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    def BernsteinBasis(self, i: int, time: pydrake.autodiffutils.AutoDiffXd, order: int | None = ...) -> pydrake.autodiffutils.AutoDiffXd: ...
    def ElevateOrder(self) -> None: ...
    def GetExpression(self, time: pydrake.symbolic.Variable = ...) -> numpy.ndarray[object[m, 1]]: ...
    def control_points(self) -> numpy.ndarray[object[m, n]]: ...
    def order(self) -> int: ...
    def __copy__(self) -> BezierCurve_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> BezierCurve_TAutoDiffXdU: ...

class BezierCurve_𝓣Expression𝓤(Trajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, start_time: float, end_time: float, control_points: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    def BernsteinBasis(self, i: int, time: pydrake.symbolic.Expression, order: int | None = ...) -> pydrake.symbolic.Expression: ...
    def ElevateOrder(self) -> None: ...
    def GetExpression(self, time: pydrake.symbolic.Variable = ...) -> numpy.ndarray[object[m, 1]]: ...
    def control_points(self) -> numpy.ndarray[object[m, n]]: ...
    def order(self) -> int: ...
    def __copy__(self) -> BezierCurve_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> BezierCurve_TExpressionU: ...

class BsplineTrajectory(Trajectory):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, basis: pydrake.math.BsplineBasis, control_points: list[list[float]]) -> None: ...
    @overload
    def __init__(self, basis: pydrake.math.BsplineBasis, control_points: list[numpy.ndarray[numpy.float64[m, n]]]) -> None: ...
    @overload
    def AsLinearInControlPoints(self, derivative_order: int = ...) -> scipy.sparse.csc_matrix[numpy.float64]: ...
    @overload
    def AsLinearInControlPoints(self) -> Any: ...
    def CopyBlock(self, start_row: int, start_col: int, block_rows: int, block_cols: int) -> BsplineTrajectory: ...
    def CopyHead(self, n: int) -> BsplineTrajectory: ...
    def EvaluateLinearInControlPoints(self, parameter_value: float, derivative_order: int = ...) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def FinalValue(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def InitialValue(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def InsertKnots(self, additional_knots: list[float]) -> None: ...
    def basis(self) -> pydrake.math.BsplineBasis: ...
    def control_points(self) -> list[numpy.ndarray[numpy.float64[m, n]]]: ...
    def num_control_points(self) -> int: ...
    def __copy__(self) -> BsplineTrajectory: ...
    def __deepcopy__(self, arg0: dict) -> BsplineTrajectory: ...

class BsplineTrajectory_𝓣AutoDiffXd𝓤(Trajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, basis: pydrake.math.BsplineBasis_TAutoDiffXdU, control_points: list[list[pydrake.autodiffutils.AutoDiffXd]]) -> None: ...
    @overload
    def __init__(self, basis: pydrake.math.BsplineBasis_TAutoDiffXdU, control_points: list[numpy.ndarray[object[m, n]]]) -> None: ...
    def CopyBlock(self, start_row: int, start_col: int, block_rows: int, block_cols: int) -> BsplineTrajectory_TAutoDiffXdU: ...
    def CopyHead(self, n: int) -> BsplineTrajectory_TAutoDiffXdU: ...
    def EvaluateLinearInControlPoints(self, parameter_value: pydrake.autodiffutils.AutoDiffXd, derivative_order: int = ...) -> numpy.ndarray[object[m, 1]]: ...
    def FinalValue(self) -> numpy.ndarray[object[m, n]]: ...
    def InitialValue(self) -> numpy.ndarray[object[m, n]]: ...
    def InsertKnots(self, additional_knots: list[pydrake.autodiffutils.AutoDiffXd]) -> None: ...
    def basis(self) -> pydrake.math.BsplineBasis_TAutoDiffXdU: ...
    def control_points(self) -> list[numpy.ndarray[object[m, n]]]: ...
    def num_control_points(self) -> int: ...
    def __copy__(self) -> BsplineTrajectory_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> BsplineTrajectory_TAutoDiffXdU: ...

class BsplineTrajectory_𝓣Expression𝓤(Trajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, basis: pydrake.math.BsplineBasis_TExpressionU, control_points: list[list[pydrake.symbolic.Expression]]) -> None: ...
    @overload
    def __init__(self, basis: pydrake.math.BsplineBasis_TExpressionU, control_points: list[numpy.ndarray[object[m, n]]]) -> None: ...
    def CopyBlock(self, start_row: int, start_col: int, block_rows: int, block_cols: int) -> BsplineTrajectory_TExpressionU: ...
    def CopyHead(self, n: int) -> BsplineTrajectory_TExpressionU: ...
    def EvaluateLinearInControlPoints(self, parameter_value: pydrake.symbolic.Expression, derivative_order: int = ...) -> numpy.ndarray[object[m, 1]]: ...
    def FinalValue(self) -> numpy.ndarray[object[m, n]]: ...
    def InitialValue(self) -> numpy.ndarray[object[m, n]]: ...
    def InsertKnots(self, additional_knots: list[pydrake.symbolic.Expression]) -> None: ...
    def basis(self) -> pydrake.math.BsplineBasis_TExpressionU: ...
    def control_points(self) -> list[numpy.ndarray[object[m, n]]]: ...
    def num_control_points(self) -> int: ...
    def __copy__(self) -> BsplineTrajectory_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> BsplineTrajectory_TExpressionU: ...

class CompositeTrajectory(PiecewiseTrajectory):
    def __init__(self, segments: list[Trajectory]) -> None: ...
    @staticmethod
    def AlignAndConcatenate(segments: list[Trajectory]) -> CompositeTrajectory: ...
    def segment(self, segment_index: int) -> Trajectory: ...
    def __copy__(self) -> CompositeTrajectory: ...
    def __deepcopy__(self, arg0: dict) -> CompositeTrajectory: ...

class CompositeTrajectory_𝓣AutoDiffXd𝓤(PiecewiseTrajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, segments: list[Trajectory_TAutoDiffXdU]) -> None: ...
    @staticmethod
    def AlignAndConcatenate(segments: list[Trajectory_TAutoDiffXdU]) -> CompositeTrajectory_TAutoDiffXdU: ...
    def segment(self, segment_index: int) -> Trajectory_TAutoDiffXdU: ...
    def __copy__(self) -> CompositeTrajectory_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> CompositeTrajectory_TAutoDiffXdU: ...

class CompositeTrajectory_𝓣Expression𝓤(PiecewiseTrajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, segments: list[Trajectory_TExpressionU]) -> None: ...
    @staticmethod
    def AlignAndConcatenate(segments: list[Trajectory_TExpressionU]) -> CompositeTrajectory_TExpressionU: ...
    def segment(self, segment_index: int) -> Trajectory_TExpressionU: ...
    def __copy__(self) -> CompositeTrajectory_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> CompositeTrajectory_TExpressionU: ...

class DerivativeTrajectory(Trajectory):
    def __init__(self, nominal: Trajectory, derivative_order: int = ...) -> None: ...
    def __copy__(self) -> DerivativeTrajectory: ...
    def __deepcopy__(self, arg0: dict) -> DerivativeTrajectory: ...

class DerivativeTrajectory_𝓣AutoDiffXd𝓤(Trajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, nominal: Trajectory_TAutoDiffXdU, derivative_order: int = ...) -> None: ...
    def __copy__(self) -> DerivativeTrajectory_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> DerivativeTrajectory_TAutoDiffXdU: ...

class DerivativeTrajectory_𝓣Expression𝓤(Trajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, nominal: Trajectory_TExpressionU, derivative_order: int = ...) -> None: ...
    def __copy__(self) -> DerivativeTrajectory_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> DerivativeTrajectory_TExpressionU: ...

class DiscreteTimeTrajectory(Trajectory):
    def __init__(self, times: list[float], values: list[numpy.ndarray[numpy.float64[m, n]]], time_comparison_tolerance: float = ...) -> None: ...
    def ToZeroOrderHold(self) -> PiecewisePolynomial: ...
    def get_times(self) -> list[float]: ...
    def num_times(self) -> int: ...
    def time_comparison_tolerance(self) -> float: ...
    def __copy__(self) -> DiscreteTimeTrajectory: ...
    def __deepcopy__(self, arg0: dict) -> DiscreteTimeTrajectory: ...

class DiscreteTimeTrajectory_𝓣AutoDiffXd𝓤(Trajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, times: list[pydrake.autodiffutils.AutoDiffXd], values: list[numpy.ndarray[object[m, n]]], time_comparison_tolerance: float = ...) -> None: ...
    def ToZeroOrderHold(self) -> PiecewisePolynomial_TAutoDiffXdU: ...
    def get_times(self) -> list[pydrake.autodiffutils.AutoDiffXd]: ...
    def num_times(self) -> int: ...
    def time_comparison_tolerance(self) -> float: ...
    def __copy__(self) -> DiscreteTimeTrajectory_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> DiscreteTimeTrajectory_TAutoDiffXdU: ...

class DiscreteTimeTrajectory_𝓣Expression𝓤(Trajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, times: list[pydrake.symbolic.Expression], values: list[numpy.ndarray[object[m, n]]], time_comparison_tolerance: float = ...) -> None: ...
    def ToZeroOrderHold(self) -> PiecewisePolynomial_TExpressionU: ...
    def get_times(self) -> list[pydrake.symbolic.Expression]: ...
    def num_times(self) -> int: ...
    def time_comparison_tolerance(self) -> float: ...
    def __copy__(self) -> DiscreteTimeTrajectory_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> DiscreteTimeTrajectory_TExpressionU: ...

class ExponentialPlusPiecewisePolynomial(PiecewiseTrajectory):
    def __init__(self, K: numpy.ndarray[numpy.float64[m, n]], A: numpy.ndarray[numpy.float64[m, n]], alpha: numpy.ndarray[numpy.float64[m, n]], piecewise_polynomial_part: PiecewisePolynomial) -> None: ...
    def shiftRight(self, offset: float) -> None: ...
    def __copy__(self) -> ExponentialPlusPiecewisePolynomial: ...
    def __deepcopy__(self, arg0: dict) -> ExponentialPlusPiecewisePolynomial: ...

class FunctionHandleTrajectory(Trajectory):
    def __init__(self, func: Callable[[float], numpy.ndarray[numpy.float64[m, n]]], rows: int, cols: int = ..., start_time: float = ..., end_time: float = ...) -> None: ...
    def set_derivative(self, func: Callable[[float, int], numpy.ndarray[numpy.float64[m, n]]]) -> None: ...
    def __copy__(self) -> FunctionHandleTrajectory: ...
    def __deepcopy__(self, arg0: dict) -> FunctionHandleTrajectory: ...

class FunctionHandleTrajectory_𝓣AutoDiffXd𝓤(Trajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, func: Callable[[pydrake.autodiffutils.AutoDiffXd], numpy.ndarray[object[m, n]]], rows: int, cols: int = ..., start_time: float = ..., end_time: float = ...) -> None: ...
    def set_derivative(self, func: Callable[[pydrake.autodiffutils.AutoDiffXd, int], numpy.ndarray[object[m, n]]]) -> None: ...
    def __copy__(self) -> FunctionHandleTrajectory_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> FunctionHandleTrajectory_TAutoDiffXdU: ...

class FunctionHandleTrajectory_𝓣Expression𝓤(Trajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, func: Callable[[pydrake.symbolic.Expression], numpy.ndarray[object[m, n]]], rows: int, cols: int = ..., start_time: float = ..., end_time: float = ...) -> None: ...
    def set_derivative(self, func: Callable[[pydrake.symbolic.Expression, int], numpy.ndarray[object[m, n]]]) -> None: ...
    def __copy__(self) -> FunctionHandleTrajectory_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> FunctionHandleTrajectory_TExpressionU: ...

class PathParameterizedTrajectory(Trajectory):
    def __init__(self, path: Trajectory, time_scaling: Trajectory) -> None: ...
    def path(self) -> Trajectory: ...
    def time_scaling(self) -> Trajectory: ...
    def __copy__(self) -> PathParameterizedTrajectory: ...
    def __deepcopy__(self, arg0: dict) -> PathParameterizedTrajectory: ...

class PathParameterizedTrajectory_𝓣AutoDiffXd𝓤(Trajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, path: Trajectory_TAutoDiffXdU, time_scaling: Trajectory_TAutoDiffXdU) -> None: ...
    def path(self) -> Trajectory_TAutoDiffXdU: ...
    def time_scaling(self) -> Trajectory_TAutoDiffXdU: ...
    def __copy__(self) -> PathParameterizedTrajectory_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> PathParameterizedTrajectory_TAutoDiffXdU: ...

class PathParameterizedTrajectory_𝓣Expression𝓤(Trajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, path: Trajectory_TExpressionU, time_scaling: Trajectory_TExpressionU) -> None: ...
    def path(self) -> Trajectory_TExpressionU: ...
    def time_scaling(self) -> Trajectory_TExpressionU: ...
    def __copy__(self) -> PathParameterizedTrajectory_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> PathParameterizedTrajectory_TExpressionU: ...

class PiecewisePolynomial(PiecewiseTrajectory):
    __fields__: ClassVar[tuple] = ...  # read-only
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...
    @overload
    def __init__(self, arg0: list[numpy.ndarray[object[m, n]]], arg1: list[float]) -> None: ...
    @overload
    def __init__(self, arg0: list[pydrake.polynomial.Polynomial], arg1: list[float]) -> None: ...
    def AppendCubicHermiteSegment(self, time: float, sample: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], sample_dot: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...
    def AppendFirstOrderSegment(self, time: float, sample: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...
    def Block(self, start_row: int, start_col: int, block_rows: int, block_cols: int) -> PiecewisePolynomial: ...
    def ConcatenateInTime(self, other: PiecewisePolynomial) -> None: ...
    @overload
    @staticmethod
    def CubicHermite(breaks: list[float], samples: list[list[float]], samples_dot: list[list[float]]) -> PiecewisePolynomial: ...
    @overload
    @staticmethod
    def CubicHermite(breaks, samples, samples_dot) -> Any: ...
    @overload
    @staticmethod
    def CubicHermite(breaks: list[float], samples: list[numpy.ndarray[numpy.float64[m, n]]], samples_dot: list[numpy.ndarray[numpy.float64[m, n]]]) -> PiecewisePolynomial: ...
    @overload
    @staticmethod
    def CubicShapePreserving(breaks: list[float], samples: list[list[float]], zero_end_point_derivatives: bool = ...) -> PiecewisePolynomial: ...
    @overload
    @staticmethod
    def CubicShapePreserving(breaks: list[float], samples: list[numpy.ndarray[numpy.float64[m, n]]], zero_end_point_derivatives: bool = ...) -> PiecewisePolynomial: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[float], samples: list[list[float]], sample_dot_at_start: numpy.ndarray[numpy.float64[m, n]], sample_dot_at_end: numpy.ndarray[numpy.float64[m, n]]) -> PiecewisePolynomial: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives() -> Any: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[float], samples: list[numpy.ndarray[numpy.float64[m, n]]], sample_dot_at_start: numpy.ndarray[numpy.float64[m, n]], sample_dot_at_end: numpy.ndarray[numpy.float64[m, n]]) -> PiecewisePolynomial: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[float], samples: list[list[float]], periodic_end_condition: bool = ...) -> PiecewisePolynomial: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks, samples) -> Any: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[float], samples: list[numpy.ndarray[numpy.float64[m, n]]], periodic_end: bool) -> PiecewisePolynomial: ...
    @overload
    @staticmethod
    def FirstOrderHold(breaks: list[float], samples: list[list[float]]) -> PiecewisePolynomial: ...
    @overload
    @staticmethod
    def FirstOrderHold(breaks, samples) -> Any: ...
    @overload
    @staticmethod
    def FirstOrderHold(breaks: list[float], samples: list[numpy.ndarray[numpy.float64[m, n]]]) -> PiecewisePolynomial: ...
    @overload
    @staticmethod
    def LagrangeInterpolatingPolynomial(times: list[float], samples: list[list[float]]) -> PiecewisePolynomial: ...
    @overload
    @staticmethod
    def LagrangeInterpolatingPolynomial(times, samples) -> Any: ...
    @overload
    @staticmethod
    def LagrangeInterpolatingPolynomial(times: list[float], samples: list[numpy.ndarray[numpy.float64[m, n]]]) -> PiecewisePolynomial: ...
    def RemoveFinalSegment(self) -> None: ...
    def Reshape(self, rows: int, cols: int) -> None: ...
    def ReverseTime(self) -> None: ...
    def ScaleTime(self, scale: float) -> None: ...
    def Transpose(self) -> PiecewisePolynomial: ...
    @overload
    @staticmethod
    def ZeroOrderHold(breaks: list[float], samples: list[list[float]]) -> PiecewisePolynomial: ...
    @overload
    @staticmethod
    def ZeroOrderHold(breaks, samples) -> Any: ...
    @overload
    @staticmethod
    def ZeroOrderHold(breaks: list[float], samples: list[numpy.ndarray[numpy.float64[m, n]]]) -> PiecewisePolynomial: ...
    @overload
    def derivative(self, derivative_order: int = ...) -> PiecewisePolynomial: ...
    @overload
    def derivative(self) -> Any: ...
    def getPolynomial(self, segment_index: int, row: int = ..., col: int = ...) -> pydrake.polynomial.Polynomial: ...
    def getPolynomialMatrix(self, segment_index: int) -> numpy.ndarray[object[m, n]]: ...
    def getSegmentPolynomialDegree(self, segment_index: int, row: int = ..., col: int = ...) -> int: ...
    def isApprox(self, other: PiecewisePolynomial, tol: float, tol_type: pydrake.common.ToleranceType = ...) -> bool: ...
    def setPolynomialMatrixBlock(self, replacement: numpy.ndarray[object[m, n]], segment_index: int, row_start: int = ..., col_start: int = ...) -> None: ...
    def shiftRight(self, offset: float) -> None: ...
    def slice(self, start_segment_index: int, num_segments: int) -> PiecewisePolynomial: ...
    def __add__(self, arg0: PiecewisePolynomial) -> PiecewisePolynomial: ...
    def __copy__(self) -> PiecewisePolynomial: ...
    def __deepcopy__(self, arg0: dict) -> PiecewisePolynomial: ...
    def __getattr__(self, arg0: str) -> object: ...
    def __setattr__(self, arg0: str, arg1: object) -> None: ...

class PiecewisePolynomial_𝓣AutoDiffXd𝓤(PiecewiseTrajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    @overload
    def __init__(self, arg0: list[numpy.ndarray[object[m, n]]], arg1: list[pydrake.autodiffutils.AutoDiffXd]) -> None: ...
    @overload
    def __init__(self, arg0: list[pydrake.polynomial.Polynomial_TAutoDiffXdU], arg1: list[pydrake.autodiffutils.AutoDiffXd]) -> None: ...
    def AppendCubicHermiteSegment(self, time: pydrake.autodiffutils.AutoDiffXd, sample: numpy.ndarray[object[m, n], flags.f_contiguous], sample_dot: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    def AppendFirstOrderSegment(self, time: pydrake.autodiffutils.AutoDiffXd, sample: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    def Block(self, start_row: int, start_col: int, block_rows: int, block_cols: int) -> PiecewisePolynomial_TAutoDiffXdU: ...
    def ConcatenateInTime(self, other: PiecewisePolynomial_TAutoDiffXdU) -> None: ...
    @overload
    @staticmethod
    def CubicHermite(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[list[pydrake.autodiffutils.AutoDiffXd]], samples_dot: list[list[pydrake.autodiffutils.AutoDiffXd]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def CubicHermite(breaks, samples, samples_dot) -> Any: ...
    @overload
    @staticmethod
    def CubicHermite(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[numpy.ndarray[object[m, n]]], samples_dot: list[numpy.ndarray[object[m, n]]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def CubicShapePreserving(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[list[pydrake.autodiffutils.AutoDiffXd]], zero_end_point_derivatives: bool = ...) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def CubicShapePreserving(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[numpy.ndarray[object[m, n]]], zero_end_point_derivatives: bool = ...) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[list[pydrake.autodiffutils.AutoDiffXd]], sample_dot_at_start: numpy.ndarray[object[m, n]], sample_dot_at_end: numpy.ndarray[object[m, n]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives() -> Any: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[numpy.ndarray[object[m, n]]], sample_dot_at_start: numpy.ndarray[object[m, n]], sample_dot_at_end: numpy.ndarray[object[m, n]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[list[pydrake.autodiffutils.AutoDiffXd]], periodic_end_condition: bool = ...) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks, samples) -> Any: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[numpy.ndarray[object[m, n]]], periodic_end: bool) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def FirstOrderHold(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[list[pydrake.autodiffutils.AutoDiffXd]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def FirstOrderHold(breaks, samples) -> Any: ...
    @overload
    @staticmethod
    def FirstOrderHold(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[numpy.ndarray[object[m, n]]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def LagrangeInterpolatingPolynomial(times: list[pydrake.autodiffutils.AutoDiffXd], samples: list[list[pydrake.autodiffutils.AutoDiffXd]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def LagrangeInterpolatingPolynomial(times, samples) -> Any: ...
    @overload
    @staticmethod
    def LagrangeInterpolatingPolynomial(times: list[pydrake.autodiffutils.AutoDiffXd], samples: list[numpy.ndarray[object[m, n]]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    def RemoveFinalSegment(self) -> None: ...
    def Reshape(self, rows: int, cols: int) -> None: ...
    def ReverseTime(self) -> None: ...
    def ScaleTime(self, scale: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def Transpose(self) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def ZeroOrderHold(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[list[pydrake.autodiffutils.AutoDiffXd]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def ZeroOrderHold(breaks, samples) -> Any: ...
    @overload
    @staticmethod
    def ZeroOrderHold(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[numpy.ndarray[object[m, n]]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    def derivative(self, derivative_order: int = ...) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    def derivative(self) -> Any: ...
    def getPolynomial(self, segment_index: int, row: int = ..., col: int = ...) -> pydrake.polynomial.Polynomial_TAutoDiffXdU: ...
    def getPolynomialMatrix(self, segment_index: int) -> numpy.ndarray[object[m, n]]: ...
    def getSegmentPolynomialDegree(self, segment_index: int, row: int = ..., col: int = ...) -> int: ...
    def isApprox(self, other: PiecewisePolynomial_TAutoDiffXdU, tol: float, tol_type: pydrake.common.ToleranceType = ...) -> bool: ...
    def setPolynomialMatrixBlock(self, replacement: numpy.ndarray[object[m, n]], segment_index: int, row_start: int = ..., col_start: int = ...) -> None: ...
    def shiftRight(self, offset: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def slice(self, start_segment_index: int, num_segments: int) -> PiecewisePolynomial_TAutoDiffXdU: ...
    def __add__(self, arg0: PiecewisePolynomial_TAutoDiffXdU) -> PiecewisePolynomial_TAutoDiffXdU: ...
    def __copy__(self) -> PiecewisePolynomial_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> PiecewisePolynomial_TAutoDiffXdU: ...

class PiecewisePolynomial_𝓣Expression𝓤(PiecewiseTrajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    @overload
    def __init__(self, arg0: list[numpy.ndarray[object[m, n]]], arg1: list[pydrake.symbolic.Expression]) -> None: ...
    @overload
    def __init__(self, arg0: list[pydrake.polynomial.Polynomial_TExpressionU], arg1: list[pydrake.symbolic.Expression]) -> None: ...
    def AppendCubicHermiteSegment(self, time: pydrake.symbolic.Expression, sample: numpy.ndarray[object[m, n], flags.f_contiguous], sample_dot: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    def AppendFirstOrderSegment(self, time: pydrake.symbolic.Expression, sample: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    def Block(self, start_row: int, start_col: int, block_rows: int, block_cols: int) -> PiecewisePolynomial_TExpressionU: ...
    def ConcatenateInTime(self, other: PiecewisePolynomial_TExpressionU) -> None: ...
    @overload
    @staticmethod
    def CubicHermite(breaks: list[pydrake.symbolic.Expression], samples: list[list[pydrake.symbolic.Expression]], samples_dot: list[list[pydrake.symbolic.Expression]]) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def CubicHermite(breaks, samples, samples_dot) -> Any: ...
    @overload
    @staticmethod
    def CubicHermite(breaks: list[pydrake.symbolic.Expression], samples: list[numpy.ndarray[object[m, n]]], samples_dot: list[numpy.ndarray[object[m, n]]]) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def CubicShapePreserving(breaks: list[pydrake.symbolic.Expression], samples: list[list[pydrake.symbolic.Expression]], zero_end_point_derivatives: bool = ...) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def CubicShapePreserving(breaks: list[pydrake.symbolic.Expression], samples: list[numpy.ndarray[object[m, n]]], zero_end_point_derivatives: bool = ...) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[pydrake.symbolic.Expression], samples: list[list[pydrake.symbolic.Expression]], sample_dot_at_start: numpy.ndarray[object[m, n]], sample_dot_at_end: numpy.ndarray[object[m, n]]) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives() -> Any: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[pydrake.symbolic.Expression], samples: list[numpy.ndarray[object[m, n]]], sample_dot_at_start: numpy.ndarray[object[m, n]], sample_dot_at_end: numpy.ndarray[object[m, n]]) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[pydrake.symbolic.Expression], samples: list[list[pydrake.symbolic.Expression]], periodic_end_condition: bool = ...) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks, samples) -> Any: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[pydrake.symbolic.Expression], samples: list[numpy.ndarray[object[m, n]]], periodic_end: bool) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def FirstOrderHold(breaks: list[pydrake.symbolic.Expression], samples: list[list[pydrake.symbolic.Expression]]) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def FirstOrderHold(breaks, samples) -> Any: ...
    @overload
    @staticmethod
    def FirstOrderHold(breaks: list[pydrake.symbolic.Expression], samples: list[numpy.ndarray[object[m, n]]]) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def LagrangeInterpolatingPolynomial(times: list[pydrake.symbolic.Expression], samples: list[list[pydrake.symbolic.Expression]]) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def LagrangeInterpolatingPolynomial(times, samples) -> Any: ...
    @overload
    @staticmethod
    def LagrangeInterpolatingPolynomial(times: list[pydrake.symbolic.Expression], samples: list[numpy.ndarray[object[m, n]]]) -> PiecewisePolynomial_TExpressionU: ...
    def RemoveFinalSegment(self) -> None: ...
    def Reshape(self, rows: int, cols: int) -> None: ...
    def ReverseTime(self) -> None: ...
    def ScaleTime(self, scale: pydrake.symbolic.Expression) -> None: ...
    def Transpose(self) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def ZeroOrderHold(breaks: list[pydrake.symbolic.Expression], samples: list[list[pydrake.symbolic.Expression]]) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def ZeroOrderHold(breaks, samples) -> Any: ...
    @overload
    @staticmethod
    def ZeroOrderHold(breaks: list[pydrake.symbolic.Expression], samples: list[numpy.ndarray[object[m, n]]]) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    def derivative(self, derivative_order: int = ...) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    def derivative(self) -> Any: ...
    def getPolynomial(self, segment_index: int, row: int = ..., col: int = ...) -> pydrake.polynomial.Polynomial_TExpressionU: ...
    def getPolynomialMatrix(self, segment_index: int) -> numpy.ndarray[object[m, n]]: ...
    def getSegmentPolynomialDegree(self, segment_index: int, row: int = ..., col: int = ...) -> int: ...
    def isApprox(self, other: PiecewisePolynomial_TExpressionU, tol: float, tol_type: pydrake.common.ToleranceType = ...) -> bool: ...
    def setPolynomialMatrixBlock(self, replacement: numpy.ndarray[object[m, n]], segment_index: int, row_start: int = ..., col_start: int = ...) -> None: ...
    def shiftRight(self, offset: pydrake.symbolic.Expression) -> None: ...
    def slice(self, start_segment_index: int, num_segments: int) -> PiecewisePolynomial_TExpressionU: ...
    def __add__(self, arg0: PiecewisePolynomial_TExpressionU) -> PiecewisePolynomial_TExpressionU: ...
    def __copy__(self) -> PiecewisePolynomial_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> PiecewisePolynomial_TExpressionU: ...

class PiecewisePose(PiecewiseTrajectory):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, position_trajectory: PiecewisePolynomial, orientation_trajectory: PiecewiseQuaternionSlerp) -> None: ...
    def GetAcceleration(self, time: float) -> numpy.ndarray[numpy.float64[6, 1]]: ...
    def GetPose(self, time: float) -> pydrake.math.RigidTransform: ...
    def GetVelocity(self, time: float) -> numpy.ndarray[numpy.float64[6, 1]]: ...
    def IsApprox(self, other: PiecewisePose, tol: float) -> bool: ...
    @staticmethod
    def MakeCubicLinearWithEndLinearVelocity(times: list[float], poses: list[pydrake.math.RigidTransform], start_vel: numpy.ndarray[numpy.float64[3, 1]] = ..., end_vel: numpy.ndarray[numpy.float64[3, 1]] = ...) -> PiecewisePose: ...
    @staticmethod
    def MakeLinear(times: list[float], poses: list[pydrake.math.RigidTransform]) -> PiecewisePose: ...
    def get_orientation_trajectory(self) -> PiecewiseQuaternionSlerp: ...
    def get_position_trajectory(self) -> PiecewisePolynomial: ...
    def __copy__(self) -> PiecewisePose: ...
    def __deepcopy__(self, arg0: dict) -> PiecewisePose: ...

class PiecewisePose_𝓣AutoDiffXd𝓤(PiecewiseTrajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, position_trajectory: PiecewisePolynomial_TAutoDiffXdU, orientation_trajectory: PiecewiseQuaternionSlerp_TAutoDiffXdU) -> None: ...
    def GetAcceleration(self, time: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[6, 1]]: ...
    def GetPose(self, time: pydrake.autodiffutils.AutoDiffXd) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def GetVelocity(self, time: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[6, 1]]: ...
    def IsApprox(self, other: PiecewisePose_TAutoDiffXdU, tol: float) -> bool: ...
    @staticmethod
    def MakeCubicLinearWithEndLinearVelocity(times: list[pydrake.autodiffutils.AutoDiffXd], poses: list[pydrake.math.RigidTransform_TAutoDiffXdU], start_vel: numpy.ndarray[object[3, 1]] = ..., end_vel: numpy.ndarray[object[3, 1]] = ...) -> PiecewisePose_TAutoDiffXdU: ...
    @staticmethod
    def MakeLinear(times: list[pydrake.autodiffutils.AutoDiffXd], poses: list[pydrake.math.RigidTransform_TAutoDiffXdU]) -> PiecewisePose_TAutoDiffXdU: ...
    def get_orientation_trajectory(self) -> PiecewiseQuaternionSlerp_TAutoDiffXdU: ...
    def get_position_trajectory(self) -> PiecewisePolynomial_TAutoDiffXdU: ...
    def __copy__(self) -> PiecewisePose_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> PiecewisePose_TAutoDiffXdU: ...

class PiecewisePose_𝓣Expression𝓤(PiecewiseTrajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, position_trajectory: PiecewisePolynomial_TExpressionU, orientation_trajectory: PiecewiseQuaternionSlerp_TExpressionU) -> None: ...
    def GetAcceleration(self, time: pydrake.symbolic.Expression) -> numpy.ndarray[object[6, 1]]: ...
    def GetPose(self, time: pydrake.symbolic.Expression) -> pydrake.math.RigidTransform_TExpressionU: ...
    def GetVelocity(self, time: pydrake.symbolic.Expression) -> numpy.ndarray[object[6, 1]]: ...
    def IsApprox(self, other: PiecewisePose_TExpressionU, tol: float) -> bool: ...
    @staticmethod
    def MakeCubicLinearWithEndLinearVelocity(times: list[pydrake.symbolic.Expression], poses: list[pydrake.math.RigidTransform_TExpressionU], start_vel: numpy.ndarray[object[3, 1]] = ..., end_vel: numpy.ndarray[object[3, 1]] = ...) -> PiecewisePose_TExpressionU: ...
    @staticmethod
    def MakeLinear(times: list[pydrake.symbolic.Expression], poses: list[pydrake.math.RigidTransform_TExpressionU]) -> PiecewisePose_TExpressionU: ...
    def get_orientation_trajectory(self) -> PiecewiseQuaternionSlerp_TExpressionU: ...
    def get_position_trajectory(self) -> PiecewisePolynomial_TExpressionU: ...
    def __copy__(self) -> PiecewisePose_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> PiecewisePose_TExpressionU: ...

class PiecewiseQuaternionSlerp(PiecewiseTrajectory):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, breaks: list[float], quaternions: list[pydrake.common.eigen_geometry.Quaternion]) -> None: ...
    @overload
    def __init__(self, breaks: list[float], rotation_matrices: list[numpy.ndarray[numpy.float64[3, 3]]]) -> None: ...
    @overload
    def __init__(self, breaks: list[float], rotation_matrices: list[pydrake.math.RotationMatrix]) -> None: ...
    @overload
    def __init__(self, breaks: list[float], angle_axes: list[pydrake.common.eigen_geometry.AngleAxis]) -> None: ...
    @overload
    def Append(self, time: float, quaternion: pydrake.common.eigen_geometry.Quaternion) -> None: ...
    @overload
    def Append(self, time: float, rotation_matrix: pydrake.math.RotationMatrix) -> None: ...
    @overload
    def Append(self, time: float, angle_axis: pydrake.common.eigen_geometry.AngleAxis) -> None: ...
    def angular_acceleration(self, time: float) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def angular_velocity(self, time: float) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def orientation(self, time: float) -> pydrake.common.eigen_geometry.Quaternion: ...
    def __copy__(self) -> PiecewiseQuaternionSlerp: ...
    def __deepcopy__(self, arg0: dict) -> PiecewiseQuaternionSlerp: ...

class PiecewiseQuaternionSlerp_𝓣AutoDiffXd𝓤(PiecewiseTrajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, breaks: list[pydrake.autodiffutils.AutoDiffXd], quaternions: list[pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU]) -> None: ...
    @overload
    def __init__(self, breaks: list[pydrake.autodiffutils.AutoDiffXd], rotation_matrices: list[numpy.ndarray[object[3, 3]]]) -> None: ...
    @overload
    def __init__(self, breaks: list[pydrake.autodiffutils.AutoDiffXd], rotation_matrices: list[pydrake.math.RotationMatrix_TAutoDiffXdU]) -> None: ...
    @overload
    def __init__(self, breaks: list[pydrake.autodiffutils.AutoDiffXd], angle_axes: list[pydrake.common.eigen_geometry.AngleAxis_TAutoDiffXdU]) -> None: ...
    @overload
    def Append(self, time: pydrake.autodiffutils.AutoDiffXd, quaternion: pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU) -> None: ...
    @overload
    def Append(self, time: pydrake.autodiffutils.AutoDiffXd, rotation_matrix: pydrake.math.RotationMatrix_TAutoDiffXdU) -> None: ...
    @overload
    def Append(self, time: pydrake.autodiffutils.AutoDiffXd, angle_axis: pydrake.common.eigen_geometry.AngleAxis_TAutoDiffXdU) -> None: ...
    def angular_acceleration(self, time: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[3, 1]]: ...
    def angular_velocity(self, time: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[3, 1]]: ...
    def orientation(self, time: pydrake.autodiffutils.AutoDiffXd) -> pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU: ...
    def __copy__(self) -> PiecewiseQuaternionSlerp_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> PiecewiseQuaternionSlerp_TAutoDiffXdU: ...

class PiecewiseQuaternionSlerp_𝓣Expression𝓤(PiecewiseTrajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, breaks: list[pydrake.symbolic.Expression], quaternions: list[pydrake.common.eigen_geometry.Quaternion_TExpressionU]) -> None: ...
    @overload
    def __init__(self, breaks: list[pydrake.symbolic.Expression], rotation_matrices: list[numpy.ndarray[object[3, 3]]]) -> None: ...
    @overload
    def __init__(self, breaks: list[pydrake.symbolic.Expression], rotation_matrices: list[pydrake.math.RotationMatrix_TExpressionU]) -> None: ...
    @overload
    def __init__(self, breaks: list[pydrake.symbolic.Expression], angle_axes: list[pydrake.common.eigen_geometry.AngleAxis_TExpressionU]) -> None: ...
    @overload
    def Append(self, time: pydrake.symbolic.Expression, quaternion: pydrake.common.eigen_geometry.Quaternion_TExpressionU) -> None: ...
    @overload
    def Append(self, time: pydrake.symbolic.Expression, rotation_matrix: pydrake.math.RotationMatrix_TExpressionU) -> None: ...
    @overload
    def Append(self, time: pydrake.symbolic.Expression, angle_axis: pydrake.common.eigen_geometry.AngleAxis_TExpressionU) -> None: ...
    def angular_acceleration(self, time: pydrake.symbolic.Expression) -> numpy.ndarray[object[3, 1]]: ...
    def angular_velocity(self, time: pydrake.symbolic.Expression) -> numpy.ndarray[object[3, 1]]: ...
    def orientation(self, time: pydrake.symbolic.Expression) -> pydrake.common.eigen_geometry.Quaternion_TExpressionU: ...
    def __copy__(self) -> PiecewiseQuaternionSlerp_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> PiecewiseQuaternionSlerp_TExpressionU: ...

class PiecewiseTrajectory(Trajectory):
    def __init__(self, *args, **kwargs) -> None: ...
    def duration(self, segment_index: int) -> float: ...
    @overload
    def end_time(self, segment_index: int) -> float: ...
    @overload
    def end_time(self) -> float: ...
    def get_number_of_segments(self) -> int: ...
    def get_segment_index(self, t: float) -> int: ...
    def get_segment_times(self) -> list[float]: ...
    def is_time_in_range(self, t: float) -> bool: ...
    @overload
    def start_time(self, segment_index: int) -> float: ...
    @overload
    def start_time(self) -> float: ...

class PiecewiseTrajectory_𝓣AutoDiffXd𝓤(Trajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def duration(self, segment_index: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    @overload
    def end_time(self, segment_index: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    @overload
    def end_time(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_number_of_segments(self) -> int: ...
    def get_segment_index(self, t: pydrake.autodiffutils.AutoDiffXd) -> int: ...
    def get_segment_times(self) -> list[pydrake.autodiffutils.AutoDiffXd]: ...
    def is_time_in_range(self, t: pydrake.autodiffutils.AutoDiffXd) -> bool: ...
    @overload
    def start_time(self, segment_index: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    @overload
    def start_time(self) -> pydrake.autodiffutils.AutoDiffXd: ...

class PiecewiseTrajectory_𝓣Expression𝓤(Trajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def duration(self, segment_index: int) -> pydrake.symbolic.Expression: ...
    @overload
    def end_time(self, segment_index: int) -> pydrake.symbolic.Expression: ...
    @overload
    def end_time(self) -> pydrake.symbolic.Expression: ...
    def get_number_of_segments(self) -> int: ...
    def get_segment_index(self, t: pydrake.symbolic.Expression) -> int: ...
    def get_segment_times(self) -> list[pydrake.symbolic.Expression]: ...
    def is_time_in_range(self, t: pydrake.symbolic.Expression) -> pydrake.symbolic.Formula: ...
    @overload
    def start_time(self, segment_index: int) -> pydrake.symbolic.Expression: ...
    @overload
    def start_time(self) -> pydrake.symbolic.Expression: ...

class StackedTrajectory(Trajectory):
    def __init__(self, rowwise: bool = ...) -> None: ...
    def Append(self, arg0: Trajectory) -> None: ...
    def __copy__(self) -> StackedTrajectory: ...
    def __deepcopy__(self, arg0: dict) -> StackedTrajectory: ...

class StackedTrajectory_𝓣AutoDiffXd𝓤(Trajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, rowwise: bool = ...) -> None: ...
    def Append(self, arg0: Trajectory_TAutoDiffXdU) -> None: ...
    def __copy__(self) -> StackedTrajectory_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> StackedTrajectory_TAutoDiffXdU: ...

class StackedTrajectory_𝓣Expression𝓤(Trajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, rowwise: bool = ...) -> None: ...
    def Append(self, arg0: Trajectory_TExpressionU) -> None: ...
    def __copy__(self) -> StackedTrajectory_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> StackedTrajectory_TExpressionU: ...

class Trajectory:
    def __init__(self) -> None: ...
    def Clone(self) -> Trajectory: ...
    def EvalDerivative(self, t: float, derivative_order: int = ...) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def MakeDerivative(self, derivative_order: int = ...) -> Trajectory: ...
    def cols(self) -> int: ...
    def end_time(self) -> float: ...
    def has_derivative(self) -> bool: ...
    def rows(self) -> int: ...
    def start_time(self) -> float: ...
    def value(self, t: float) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def vector_values(self, t: list[float]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def __copy__(self) -> Trajectory: ...
    def __deepcopy__(self, arg0: dict) -> Trajectory: ...

class Trajectory_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def Clone(self) -> Trajectory_TAutoDiffXdU: ...
    def EvalDerivative(self, t: pydrake.autodiffutils.AutoDiffXd, derivative_order: int = ...) -> numpy.ndarray[object[m, n]]: ...
    def MakeDerivative(self, derivative_order: int = ...) -> Trajectory_TAutoDiffXdU: ...
    def cols(self) -> int: ...
    def end_time(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def has_derivative(self) -> bool: ...
    def rows(self) -> int: ...
    def start_time(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def value(self, t: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, n]]: ...
    def vector_values(self, t: list[pydrake.autodiffutils.AutoDiffXd]) -> numpy.ndarray[object[m, n]]: ...
    def __copy__(self) -> Trajectory_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> Trajectory_TAutoDiffXdU: ...

class Trajectory_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def Clone(self) -> Trajectory_TExpressionU: ...
    def EvalDerivative(self, t: pydrake.symbolic.Expression, derivative_order: int = ...) -> numpy.ndarray[object[m, n]]: ...
    def MakeDerivative(self, derivative_order: int = ...) -> Trajectory_TExpressionU: ...
    def cols(self) -> int: ...
    def end_time(self) -> pydrake.symbolic.Expression: ...
    def has_derivative(self) -> bool: ...
    def rows(self) -> int: ...
    def start_time(self) -> pydrake.symbolic.Expression: ...
    def value(self, t: pydrake.symbolic.Expression) -> numpy.ndarray[object[m, n]]: ...
    def vector_values(self, t: list[pydrake.symbolic.Expression]) -> numpy.ndarray[object[m, n]]: ...
    def __copy__(self) -> Trajectory_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> Trajectory_TExpressionU: ...

class _TemporaryName_N5drake12trajectories10TrajectoryIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def Clone(self) -> Trajectory_TAutoDiffXdU: ...
    def EvalDerivative(self, t: pydrake.autodiffutils.AutoDiffXd, derivative_order: int = ...) -> numpy.ndarray[object[m, n]]: ...
    def MakeDerivative(self, derivative_order: int = ...) -> Trajectory_TAutoDiffXdU: ...
    def cols(self) -> int: ...
    def end_time(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def has_derivative(self) -> bool: ...
    def rows(self) -> int: ...
    def start_time(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def value(self, t: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, n]]: ...
    def vector_values(self, t: list[pydrake.autodiffutils.AutoDiffXd]) -> numpy.ndarray[object[m, n]]: ...
    def __copy__(self) -> Trajectory_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> Trajectory_TAutoDiffXdU: ...

class _TemporaryName_N5drake12trajectories10TrajectoryINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def Clone(self) -> Trajectory_TExpressionU: ...
    def EvalDerivative(self, t: pydrake.symbolic.Expression, derivative_order: int = ...) -> numpy.ndarray[object[m, n]]: ...
    def MakeDerivative(self, derivative_order: int = ...) -> Trajectory_TExpressionU: ...
    def cols(self) -> int: ...
    def end_time(self) -> pydrake.symbolic.Expression: ...
    def has_derivative(self) -> bool: ...
    def rows(self) -> int: ...
    def start_time(self) -> pydrake.symbolic.Expression: ...
    def value(self, t: pydrake.symbolic.Expression) -> numpy.ndarray[object[m, n]]: ...
    def vector_values(self, t: list[pydrake.symbolic.Expression]) -> numpy.ndarray[object[m, n]]: ...
    def __copy__(self) -> Trajectory_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> Trajectory_TExpressionU: ...

class _TemporaryName_N5drake12trajectories11BezierCurveIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Trajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, start_time: float, end_time: float, control_points: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    def BernsteinBasis(self, i: int, time: pydrake.autodiffutils.AutoDiffXd, order: int | None = ...) -> pydrake.autodiffutils.AutoDiffXd: ...
    def ElevateOrder(self) -> None: ...
    def GetExpression(self, time: pydrake.symbolic.Variable = ...) -> numpy.ndarray[object[m, 1]]: ...
    def control_points(self) -> numpy.ndarray[object[m, n]]: ...
    def order(self) -> int: ...
    def __copy__(self) -> BezierCurve_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> BezierCurve_TAutoDiffXdU: ...

class _TemporaryName_N5drake12trajectories11BezierCurveINS_8symbolic10ExpressionEEE(Trajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, start_time: float, end_time: float, control_points: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    def BernsteinBasis(self, i: int, time: pydrake.symbolic.Expression, order: int | None = ...) -> pydrake.symbolic.Expression: ...
    def ElevateOrder(self) -> None: ...
    def GetExpression(self, time: pydrake.symbolic.Variable = ...) -> numpy.ndarray[object[m, 1]]: ...
    def control_points(self) -> numpy.ndarray[object[m, n]]: ...
    def order(self) -> int: ...
    def __copy__(self) -> BezierCurve_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> BezierCurve_TExpressionU: ...

class _TemporaryName_N5drake12trajectories13PiecewisePoseIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(PiecewiseTrajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, position_trajectory: PiecewisePolynomial_TAutoDiffXdU, orientation_trajectory: PiecewiseQuaternionSlerp_TAutoDiffXdU) -> None: ...
    def GetAcceleration(self, time: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[6, 1]]: ...
    def GetPose(self, time: pydrake.autodiffutils.AutoDiffXd) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def GetVelocity(self, time: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[6, 1]]: ...
    def IsApprox(self, other: PiecewisePose_TAutoDiffXdU, tol: float) -> bool: ...
    @staticmethod
    def MakeCubicLinearWithEndLinearVelocity(times: list[pydrake.autodiffutils.AutoDiffXd], poses: list[pydrake.math.RigidTransform_TAutoDiffXdU], start_vel: numpy.ndarray[object[3, 1]] = ..., end_vel: numpy.ndarray[object[3, 1]] = ...) -> PiecewisePose_TAutoDiffXdU: ...
    @staticmethod
    def MakeLinear(times: list[pydrake.autodiffutils.AutoDiffXd], poses: list[pydrake.math.RigidTransform_TAutoDiffXdU]) -> PiecewisePose_TAutoDiffXdU: ...
    def get_orientation_trajectory(self) -> PiecewiseQuaternionSlerp_TAutoDiffXdU: ...
    def get_position_trajectory(self) -> PiecewisePolynomial_TAutoDiffXdU: ...
    def __copy__(self) -> PiecewisePose_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> PiecewisePose_TAutoDiffXdU: ...

class _TemporaryName_N5drake12trajectories13PiecewisePoseINS_8symbolic10ExpressionEEE(PiecewiseTrajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, position_trajectory: PiecewisePolynomial_TExpressionU, orientation_trajectory: PiecewiseQuaternionSlerp_TExpressionU) -> None: ...
    def GetAcceleration(self, time: pydrake.symbolic.Expression) -> numpy.ndarray[object[6, 1]]: ...
    def GetPose(self, time: pydrake.symbolic.Expression) -> pydrake.math.RigidTransform_TExpressionU: ...
    def GetVelocity(self, time: pydrake.symbolic.Expression) -> numpy.ndarray[object[6, 1]]: ...
    def IsApprox(self, other: PiecewisePose_TExpressionU, tol: float) -> bool: ...
    @staticmethod
    def MakeCubicLinearWithEndLinearVelocity(times: list[pydrake.symbolic.Expression], poses: list[pydrake.math.RigidTransform_TExpressionU], start_vel: numpy.ndarray[object[3, 1]] = ..., end_vel: numpy.ndarray[object[3, 1]] = ...) -> PiecewisePose_TExpressionU: ...
    @staticmethod
    def MakeLinear(times: list[pydrake.symbolic.Expression], poses: list[pydrake.math.RigidTransform_TExpressionU]) -> PiecewisePose_TExpressionU: ...
    def get_orientation_trajectory(self) -> PiecewiseQuaternionSlerp_TExpressionU: ...
    def get_position_trajectory(self) -> PiecewisePolynomial_TExpressionU: ...
    def __copy__(self) -> PiecewisePose_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> PiecewisePose_TExpressionU: ...

class _TemporaryName_N5drake12trajectories17BsplineTrajectoryIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Trajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, basis: pydrake.math.BsplineBasis_TAutoDiffXdU, control_points: list[list[pydrake.autodiffutils.AutoDiffXd]]) -> None: ...
    @overload
    def __init__(self, basis: pydrake.math.BsplineBasis_TAutoDiffXdU, control_points: list[numpy.ndarray[object[m, n]]]) -> None: ...
    def CopyBlock(self, start_row: int, start_col: int, block_rows: int, block_cols: int) -> BsplineTrajectory_TAutoDiffXdU: ...
    def CopyHead(self, n: int) -> BsplineTrajectory_TAutoDiffXdU: ...
    def EvaluateLinearInControlPoints(self, parameter_value: pydrake.autodiffutils.AutoDiffXd, derivative_order: int = ...) -> numpy.ndarray[object[m, 1]]: ...
    def FinalValue(self) -> numpy.ndarray[object[m, n]]: ...
    def InitialValue(self) -> numpy.ndarray[object[m, n]]: ...
    def InsertKnots(self, additional_knots: list[pydrake.autodiffutils.AutoDiffXd]) -> None: ...
    def basis(self) -> pydrake.math.BsplineBasis_TAutoDiffXdU: ...
    def control_points(self) -> list[numpy.ndarray[object[m, n]]]: ...
    def num_control_points(self) -> int: ...
    def __copy__(self) -> BsplineTrajectory_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> BsplineTrajectory_TAutoDiffXdU: ...

class _TemporaryName_N5drake12trajectories17BsplineTrajectoryINS_8symbolic10ExpressionEEE(Trajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, basis: pydrake.math.BsplineBasis_TExpressionU, control_points: list[list[pydrake.symbolic.Expression]]) -> None: ...
    @overload
    def __init__(self, basis: pydrake.math.BsplineBasis_TExpressionU, control_points: list[numpy.ndarray[object[m, n]]]) -> None: ...
    def CopyBlock(self, start_row: int, start_col: int, block_rows: int, block_cols: int) -> BsplineTrajectory_TExpressionU: ...
    def CopyHead(self, n: int) -> BsplineTrajectory_TExpressionU: ...
    def EvaluateLinearInControlPoints(self, parameter_value: pydrake.symbolic.Expression, derivative_order: int = ...) -> numpy.ndarray[object[m, 1]]: ...
    def FinalValue(self) -> numpy.ndarray[object[m, n]]: ...
    def InitialValue(self) -> numpy.ndarray[object[m, n]]: ...
    def InsertKnots(self, additional_knots: list[pydrake.symbolic.Expression]) -> None: ...
    def basis(self) -> pydrake.math.BsplineBasis_TExpressionU: ...
    def control_points(self) -> list[numpy.ndarray[object[m, n]]]: ...
    def num_control_points(self) -> int: ...
    def __copy__(self) -> BsplineTrajectory_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> BsplineTrajectory_TExpressionU: ...

class _TemporaryName_N5drake12trajectories17StackedTrajectoryIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Trajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, rowwise: bool = ...) -> None: ...
    def Append(self, arg0: Trajectory_TAutoDiffXdU) -> None: ...
    def __copy__(self) -> StackedTrajectory_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> StackedTrajectory_TAutoDiffXdU: ...

class _TemporaryName_N5drake12trajectories17StackedTrajectoryINS_8symbolic10ExpressionEEE(Trajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, rowwise: bool = ...) -> None: ...
    def Append(self, arg0: Trajectory_TExpressionU) -> None: ...
    def __copy__(self) -> StackedTrajectory_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> StackedTrajectory_TExpressionU: ...

class _TemporaryName_N5drake12trajectories19CompositeTrajectoryIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(PiecewiseTrajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, segments: list[Trajectory_TAutoDiffXdU]) -> None: ...
    @staticmethod
    def AlignAndConcatenate(segments: list[Trajectory_TAutoDiffXdU]) -> CompositeTrajectory_TAutoDiffXdU: ...
    def segment(self, segment_index: int) -> Trajectory_TAutoDiffXdU: ...
    def __copy__(self) -> CompositeTrajectory_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> CompositeTrajectory_TAutoDiffXdU: ...

class _TemporaryName_N5drake12trajectories19CompositeTrajectoryINS_8symbolic10ExpressionEEE(PiecewiseTrajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, segments: list[Trajectory_TExpressionU]) -> None: ...
    @staticmethod
    def AlignAndConcatenate(segments: list[Trajectory_TExpressionU]) -> CompositeTrajectory_TExpressionU: ...
    def segment(self, segment_index: int) -> Trajectory_TExpressionU: ...
    def __copy__(self) -> CompositeTrajectory_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> CompositeTrajectory_TExpressionU: ...

class _TemporaryName_N5drake12trajectories19PiecewisePolynomialIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(PiecewiseTrajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    @overload
    def __init__(self, arg0: list[numpy.ndarray[object[m, n]]], arg1: list[pydrake.autodiffutils.AutoDiffXd]) -> None: ...
    @overload
    def __init__(self, arg0: list[pydrake.polynomial.Polynomial_TAutoDiffXdU], arg1: list[pydrake.autodiffutils.AutoDiffXd]) -> None: ...
    def AppendCubicHermiteSegment(self, time: pydrake.autodiffutils.AutoDiffXd, sample: numpy.ndarray[object[m, n], flags.f_contiguous], sample_dot: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    def AppendFirstOrderSegment(self, time: pydrake.autodiffutils.AutoDiffXd, sample: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    def Block(self, start_row: int, start_col: int, block_rows: int, block_cols: int) -> PiecewisePolynomial_TAutoDiffXdU: ...
    def ConcatenateInTime(self, other: PiecewisePolynomial_TAutoDiffXdU) -> None: ...
    @overload
    @staticmethod
    def CubicHermite(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[list[pydrake.autodiffutils.AutoDiffXd]], samples_dot: list[list[pydrake.autodiffutils.AutoDiffXd]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def CubicHermite(breaks, samples, samples_dot) -> Any: ...
    @overload
    @staticmethod
    def CubicHermite(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[numpy.ndarray[object[m, n]]], samples_dot: list[numpy.ndarray[object[m, n]]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def CubicShapePreserving(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[list[pydrake.autodiffutils.AutoDiffXd]], zero_end_point_derivatives: bool = ...) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def CubicShapePreserving(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[numpy.ndarray[object[m, n]]], zero_end_point_derivatives: bool = ...) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[list[pydrake.autodiffutils.AutoDiffXd]], sample_dot_at_start: numpy.ndarray[object[m, n]], sample_dot_at_end: numpy.ndarray[object[m, n]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives() -> Any: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[numpy.ndarray[object[m, n]]], sample_dot_at_start: numpy.ndarray[object[m, n]], sample_dot_at_end: numpy.ndarray[object[m, n]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[list[pydrake.autodiffutils.AutoDiffXd]], periodic_end_condition: bool = ...) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks, samples) -> Any: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[numpy.ndarray[object[m, n]]], periodic_end: bool) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def FirstOrderHold(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[list[pydrake.autodiffutils.AutoDiffXd]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def FirstOrderHold(breaks, samples) -> Any: ...
    @overload
    @staticmethod
    def FirstOrderHold(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[numpy.ndarray[object[m, n]]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def LagrangeInterpolatingPolynomial(times: list[pydrake.autodiffutils.AutoDiffXd], samples: list[list[pydrake.autodiffutils.AutoDiffXd]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def LagrangeInterpolatingPolynomial(times, samples) -> Any: ...
    @overload
    @staticmethod
    def LagrangeInterpolatingPolynomial(times: list[pydrake.autodiffutils.AutoDiffXd], samples: list[numpy.ndarray[object[m, n]]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    def RemoveFinalSegment(self) -> None: ...
    def Reshape(self, rows: int, cols: int) -> None: ...
    def ReverseTime(self) -> None: ...
    def ScaleTime(self, scale: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def Transpose(self) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def ZeroOrderHold(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[list[pydrake.autodiffutils.AutoDiffXd]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    @staticmethod
    def ZeroOrderHold(breaks, samples) -> Any: ...
    @overload
    @staticmethod
    def ZeroOrderHold(breaks: list[pydrake.autodiffutils.AutoDiffXd], samples: list[numpy.ndarray[object[m, n]]]) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    def derivative(self, derivative_order: int = ...) -> PiecewisePolynomial_TAutoDiffXdU: ...
    @overload
    def derivative(self) -> Any: ...
    def getPolynomial(self, segment_index: int, row: int = ..., col: int = ...) -> pydrake.polynomial.Polynomial_TAutoDiffXdU: ...
    def getPolynomialMatrix(self, segment_index: int) -> numpy.ndarray[object[m, n]]: ...
    def getSegmentPolynomialDegree(self, segment_index: int, row: int = ..., col: int = ...) -> int: ...
    def isApprox(self, other: PiecewisePolynomial_TAutoDiffXdU, tol: float, tol_type: pydrake.common.ToleranceType = ...) -> bool: ...
    def setPolynomialMatrixBlock(self, replacement: numpy.ndarray[object[m, n]], segment_index: int, row_start: int = ..., col_start: int = ...) -> None: ...
    def shiftRight(self, offset: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def slice(self, start_segment_index: int, num_segments: int) -> PiecewisePolynomial_TAutoDiffXdU: ...
    def __add__(self, arg0: PiecewisePolynomial_TAutoDiffXdU) -> PiecewisePolynomial_TAutoDiffXdU: ...
    def __copy__(self) -> PiecewisePolynomial_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> PiecewisePolynomial_TAutoDiffXdU: ...

class _TemporaryName_N5drake12trajectories19PiecewisePolynomialINS_8symbolic10ExpressionEEE(PiecewiseTrajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    @overload
    def __init__(self, arg0: list[numpy.ndarray[object[m, n]]], arg1: list[pydrake.symbolic.Expression]) -> None: ...
    @overload
    def __init__(self, arg0: list[pydrake.polynomial.Polynomial_TExpressionU], arg1: list[pydrake.symbolic.Expression]) -> None: ...
    def AppendCubicHermiteSegment(self, time: pydrake.symbolic.Expression, sample: numpy.ndarray[object[m, n], flags.f_contiguous], sample_dot: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    def AppendFirstOrderSegment(self, time: pydrake.symbolic.Expression, sample: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    def Block(self, start_row: int, start_col: int, block_rows: int, block_cols: int) -> PiecewisePolynomial_TExpressionU: ...
    def ConcatenateInTime(self, other: PiecewisePolynomial_TExpressionU) -> None: ...
    @overload
    @staticmethod
    def CubicHermite(breaks: list[pydrake.symbolic.Expression], samples: list[list[pydrake.symbolic.Expression]], samples_dot: list[list[pydrake.symbolic.Expression]]) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def CubicHermite(breaks, samples, samples_dot) -> Any: ...
    @overload
    @staticmethod
    def CubicHermite(breaks: list[pydrake.symbolic.Expression], samples: list[numpy.ndarray[object[m, n]]], samples_dot: list[numpy.ndarray[object[m, n]]]) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def CubicShapePreserving(breaks: list[pydrake.symbolic.Expression], samples: list[list[pydrake.symbolic.Expression]], zero_end_point_derivatives: bool = ...) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def CubicShapePreserving(breaks: list[pydrake.symbolic.Expression], samples: list[numpy.ndarray[object[m, n]]], zero_end_point_derivatives: bool = ...) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[pydrake.symbolic.Expression], samples: list[list[pydrake.symbolic.Expression]], sample_dot_at_start: numpy.ndarray[object[m, n]], sample_dot_at_end: numpy.ndarray[object[m, n]]) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives() -> Any: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[pydrake.symbolic.Expression], samples: list[numpy.ndarray[object[m, n]]], sample_dot_at_start: numpy.ndarray[object[m, n]], sample_dot_at_end: numpy.ndarray[object[m, n]]) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[pydrake.symbolic.Expression], samples: list[list[pydrake.symbolic.Expression]], periodic_end_condition: bool = ...) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks, samples) -> Any: ...
    @overload
    @staticmethod
    def CubicWithContinuousSecondDerivatives(breaks: list[pydrake.symbolic.Expression], samples: list[numpy.ndarray[object[m, n]]], periodic_end: bool) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def FirstOrderHold(breaks: list[pydrake.symbolic.Expression], samples: list[list[pydrake.symbolic.Expression]]) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def FirstOrderHold(breaks, samples) -> Any: ...
    @overload
    @staticmethod
    def FirstOrderHold(breaks: list[pydrake.symbolic.Expression], samples: list[numpy.ndarray[object[m, n]]]) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def LagrangeInterpolatingPolynomial(times: list[pydrake.symbolic.Expression], samples: list[list[pydrake.symbolic.Expression]]) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def LagrangeInterpolatingPolynomial(times, samples) -> Any: ...
    @overload
    @staticmethod
    def LagrangeInterpolatingPolynomial(times: list[pydrake.symbolic.Expression], samples: list[numpy.ndarray[object[m, n]]]) -> PiecewisePolynomial_TExpressionU: ...
    def RemoveFinalSegment(self) -> None: ...
    def Reshape(self, rows: int, cols: int) -> None: ...
    def ReverseTime(self) -> None: ...
    def ScaleTime(self, scale: pydrake.symbolic.Expression) -> None: ...
    def Transpose(self) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def ZeroOrderHold(breaks: list[pydrake.symbolic.Expression], samples: list[list[pydrake.symbolic.Expression]]) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    @staticmethod
    def ZeroOrderHold(breaks, samples) -> Any: ...
    @overload
    @staticmethod
    def ZeroOrderHold(breaks: list[pydrake.symbolic.Expression], samples: list[numpy.ndarray[object[m, n]]]) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    def derivative(self, derivative_order: int = ...) -> PiecewisePolynomial_TExpressionU: ...
    @overload
    def derivative(self) -> Any: ...
    def getPolynomial(self, segment_index: int, row: int = ..., col: int = ...) -> pydrake.polynomial.Polynomial_TExpressionU: ...
    def getPolynomialMatrix(self, segment_index: int) -> numpy.ndarray[object[m, n]]: ...
    def getSegmentPolynomialDegree(self, segment_index: int, row: int = ..., col: int = ...) -> int: ...
    def isApprox(self, other: PiecewisePolynomial_TExpressionU, tol: float, tol_type: pydrake.common.ToleranceType = ...) -> bool: ...
    def setPolynomialMatrixBlock(self, replacement: numpy.ndarray[object[m, n]], segment_index: int, row_start: int = ..., col_start: int = ...) -> None: ...
    def shiftRight(self, offset: pydrake.symbolic.Expression) -> None: ...
    def slice(self, start_segment_index: int, num_segments: int) -> PiecewisePolynomial_TExpressionU: ...
    def __add__(self, arg0: PiecewisePolynomial_TExpressionU) -> PiecewisePolynomial_TExpressionU: ...
    def __copy__(self) -> PiecewisePolynomial_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> PiecewisePolynomial_TExpressionU: ...

class _TemporaryName_N5drake12trajectories19PiecewiseTrajectoryIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Trajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def duration(self, segment_index: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    @overload
    def end_time(self, segment_index: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    @overload
    def end_time(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_number_of_segments(self) -> int: ...
    def get_segment_index(self, t: pydrake.autodiffutils.AutoDiffXd) -> int: ...
    def get_segment_times(self) -> list[pydrake.autodiffutils.AutoDiffXd]: ...
    def is_time_in_range(self, t: pydrake.autodiffutils.AutoDiffXd) -> bool: ...
    @overload
    def start_time(self, segment_index: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    @overload
    def start_time(self) -> pydrake.autodiffutils.AutoDiffXd: ...

class _TemporaryName_N5drake12trajectories19PiecewiseTrajectoryINS_8symbolic10ExpressionEEE(Trajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def duration(self, segment_index: int) -> pydrake.symbolic.Expression: ...
    @overload
    def end_time(self, segment_index: int) -> pydrake.symbolic.Expression: ...
    @overload
    def end_time(self) -> pydrake.symbolic.Expression: ...
    def get_number_of_segments(self) -> int: ...
    def get_segment_index(self, t: pydrake.symbolic.Expression) -> int: ...
    def get_segment_times(self) -> list[pydrake.symbolic.Expression]: ...
    def is_time_in_range(self, t: pydrake.symbolic.Expression) -> pydrake.symbolic.Formula: ...
    @overload
    def start_time(self, segment_index: int) -> pydrake.symbolic.Expression: ...
    @overload
    def start_time(self) -> pydrake.symbolic.Expression: ...

class _TemporaryName_N5drake12trajectories20DerivativeTrajectoryIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Trajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, nominal: Trajectory_TAutoDiffXdU, derivative_order: int = ...) -> None: ...
    def __copy__(self) -> DerivativeTrajectory_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> DerivativeTrajectory_TAutoDiffXdU: ...

class _TemporaryName_N5drake12trajectories20DerivativeTrajectoryINS_8symbolic10ExpressionEEE(Trajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, nominal: Trajectory_TExpressionU, derivative_order: int = ...) -> None: ...
    def __copy__(self) -> DerivativeTrajectory_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> DerivativeTrajectory_TExpressionU: ...

class _TemporaryName_N5drake12trajectories22DiscreteTimeTrajectoryIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Trajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, times: list[pydrake.autodiffutils.AutoDiffXd], values: list[numpy.ndarray[object[m, n]]], time_comparison_tolerance: float = ...) -> None: ...
    def ToZeroOrderHold(self) -> PiecewisePolynomial_TAutoDiffXdU: ...
    def get_times(self) -> list[pydrake.autodiffutils.AutoDiffXd]: ...
    def num_times(self) -> int: ...
    def time_comparison_tolerance(self) -> float: ...
    def __copy__(self) -> DiscreteTimeTrajectory_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> DiscreteTimeTrajectory_TAutoDiffXdU: ...

class _TemporaryName_N5drake12trajectories22DiscreteTimeTrajectoryINS_8symbolic10ExpressionEEE(Trajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, times: list[pydrake.symbolic.Expression], values: list[numpy.ndarray[object[m, n]]], time_comparison_tolerance: float = ...) -> None: ...
    def ToZeroOrderHold(self) -> PiecewisePolynomial_TExpressionU: ...
    def get_times(self) -> list[pydrake.symbolic.Expression]: ...
    def num_times(self) -> int: ...
    def time_comparison_tolerance(self) -> float: ...
    def __copy__(self) -> DiscreteTimeTrajectory_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> DiscreteTimeTrajectory_TExpressionU: ...

class _TemporaryName_N5drake12trajectories24FunctionHandleTrajectoryIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Trajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, func: Callable[[pydrake.autodiffutils.AutoDiffXd], numpy.ndarray[object[m, n]]], rows: int, cols: int = ..., start_time: float = ..., end_time: float = ...) -> None: ...
    def set_derivative(self, func: Callable[[pydrake.autodiffutils.AutoDiffXd, int], numpy.ndarray[object[m, n]]]) -> None: ...
    def __copy__(self) -> FunctionHandleTrajectory_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> FunctionHandleTrajectory_TAutoDiffXdU: ...

class _TemporaryName_N5drake12trajectories24FunctionHandleTrajectoryINS_8symbolic10ExpressionEEE(Trajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, func: Callable[[pydrake.symbolic.Expression], numpy.ndarray[object[m, n]]], rows: int, cols: int = ..., start_time: float = ..., end_time: float = ...) -> None: ...
    def set_derivative(self, func: Callable[[pydrake.symbolic.Expression, int], numpy.ndarray[object[m, n]]]) -> None: ...
    def __copy__(self) -> FunctionHandleTrajectory_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> FunctionHandleTrajectory_TExpressionU: ...

class _TemporaryName_N5drake12trajectories24PiecewiseQuaternionSlerpIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(PiecewiseTrajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, breaks: list[pydrake.autodiffutils.AutoDiffXd], quaternions: list[pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU]) -> None: ...
    @overload
    def __init__(self, breaks: list[pydrake.autodiffutils.AutoDiffXd], rotation_matrices: list[numpy.ndarray[object[3, 3]]]) -> None: ...
    @overload
    def __init__(self, breaks: list[pydrake.autodiffutils.AutoDiffXd], rotation_matrices: list[pydrake.math.RotationMatrix_TAutoDiffXdU]) -> None: ...
    @overload
    def __init__(self, breaks: list[pydrake.autodiffutils.AutoDiffXd], angle_axes: list[pydrake.common.eigen_geometry.AngleAxis_TAutoDiffXdU]) -> None: ...
    @overload
    def Append(self, time: pydrake.autodiffutils.AutoDiffXd, quaternion: pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU) -> None: ...
    @overload
    def Append(self, time: pydrake.autodiffutils.AutoDiffXd, rotation_matrix: pydrake.math.RotationMatrix_TAutoDiffXdU) -> None: ...
    @overload
    def Append(self, time: pydrake.autodiffutils.AutoDiffXd, angle_axis: pydrake.common.eigen_geometry.AngleAxis_TAutoDiffXdU) -> None: ...
    def angular_acceleration(self, time: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[3, 1]]: ...
    def angular_velocity(self, time: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[3, 1]]: ...
    def orientation(self, time: pydrake.autodiffutils.AutoDiffXd) -> pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU: ...
    def __copy__(self) -> PiecewiseQuaternionSlerp_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> PiecewiseQuaternionSlerp_TAutoDiffXdU: ...

class _TemporaryName_N5drake12trajectories24PiecewiseQuaternionSlerpINS_8symbolic10ExpressionEEE(PiecewiseTrajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, breaks: list[pydrake.symbolic.Expression], quaternions: list[pydrake.common.eigen_geometry.Quaternion_TExpressionU]) -> None: ...
    @overload
    def __init__(self, breaks: list[pydrake.symbolic.Expression], rotation_matrices: list[numpy.ndarray[object[3, 3]]]) -> None: ...
    @overload
    def __init__(self, breaks: list[pydrake.symbolic.Expression], rotation_matrices: list[pydrake.math.RotationMatrix_TExpressionU]) -> None: ...
    @overload
    def __init__(self, breaks: list[pydrake.symbolic.Expression], angle_axes: list[pydrake.common.eigen_geometry.AngleAxis_TExpressionU]) -> None: ...
    @overload
    def Append(self, time: pydrake.symbolic.Expression, quaternion: pydrake.common.eigen_geometry.Quaternion_TExpressionU) -> None: ...
    @overload
    def Append(self, time: pydrake.symbolic.Expression, rotation_matrix: pydrake.math.RotationMatrix_TExpressionU) -> None: ...
    @overload
    def Append(self, time: pydrake.symbolic.Expression, angle_axis: pydrake.common.eigen_geometry.AngleAxis_TExpressionU) -> None: ...
    def angular_acceleration(self, time: pydrake.symbolic.Expression) -> numpy.ndarray[object[3, 1]]: ...
    def angular_velocity(self, time: pydrake.symbolic.Expression) -> numpy.ndarray[object[3, 1]]: ...
    def orientation(self, time: pydrake.symbolic.Expression) -> pydrake.common.eigen_geometry.Quaternion_TExpressionU: ...
    def __copy__(self) -> PiecewiseQuaternionSlerp_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> PiecewiseQuaternionSlerp_TExpressionU: ...

class _TemporaryName_N5drake12trajectories27PathParameterizedTrajectoryIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Trajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, path: Trajectory_TAutoDiffXdU, time_scaling: Trajectory_TAutoDiffXdU) -> None: ...
    def path(self) -> Trajectory_TAutoDiffXdU: ...
    def time_scaling(self) -> Trajectory_TAutoDiffXdU: ...
    def __copy__(self) -> PathParameterizedTrajectory_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> PathParameterizedTrajectory_TAutoDiffXdU: ...

class _TemporaryName_N5drake12trajectories27PathParameterizedTrajectoryINS_8symbolic10ExpressionEEE(Trajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, path: Trajectory_TExpressionU, time_scaling: Trajectory_TExpressionU) -> None: ...
    def path(self) -> Trajectory_TExpressionU: ...
    def time_scaling(self) -> Trajectory_TExpressionU: ...
    def __copy__(self) -> PathParameterizedTrajectory_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> PathParameterizedTrajectory_TExpressionU: ...

class _TemporaryName_N5drake12trajectories8internal17WrappedTrajectoryIN5Eigen14AutoDiffScalarINS3_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Trajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, trajectory: Trajectory_TAutoDiffXdU) -> None: ...
    def unwrap(self) -> Trajectory_TAutoDiffXdU: ...

class _TemporaryName_N5drake12trajectories8internal17WrappedTrajectoryINS_8symbolic10ExpressionEEE(Trajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, trajectory: Trajectory_TExpressionU) -> None: ...
    def unwrap(self) -> Trajectory_TExpressionU: ...

class _WrappedTrajectory(Trajectory):
    def __init__(self, trajectory: Trajectory) -> None: ...
    def unwrap(self) -> Trajectory: ...

class _WrappedTrajectory_𝓣AutoDiffXd𝓤(Trajectory_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, trajectory: Trajectory_TAutoDiffXdU) -> None: ...
    def unwrap(self) -> Trajectory_TAutoDiffXdU: ...

class _WrappedTrajectory_𝓣Expression𝓤(Trajectory_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, trajectory: Trajectory_TExpressionU) -> None: ...
    def unwrap(self) -> Trajectory_TExpressionU: ...
