import flags
import numpy
import os
import pydrake.common.schema
import pydrake.geometry
import pydrake.lcm
import pydrake.math
import pydrake.multibody.plant
import pydrake.multibody.tree
import pydrake.systems.framework
import pydrake.systems.lcm
from _typeshed import Incomplete
from pydrake.common.cpp_template import Accelerometer_ as Accelerometer_, Gyroscope_ as Gyroscope_, Image as Image, ImageTraits as ImageTraits, RotaryEncoders_ as RotaryEncoders_
from typing import Any, ClassVar, overload

class Accelerometer(pydrake.systems.framework.LeafSystem):
    def __init__(self, body: pydrake.multibody.tree.RigidBody, X_BS: pydrake.math.RigidTransform, gravity_vector: numpy.ndarray[numpy.float64[3, 1]] = ...) -> None: ...
    def body_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def get_body_accelerations_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_body_velocities_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_measurement_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def gravity_vector(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def pose(self) -> pydrake.math.RigidTransform: ...

class Accelerometer_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_BS: pydrake.math.RigidTransform, gravity_vector: numpy.ndarray[numpy.float64[3, 1]] = ...) -> None: ...
    def body_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def get_body_accelerations_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_body_velocities_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_measurement_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def gravity_vector(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def pose(self) -> pydrake.math.RigidTransform: ...

class Accelerometer_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, body: pydrake.multibody.tree.RigidBody_TExpressionU, X_BS: pydrake.math.RigidTransform, gravity_vector: numpy.ndarray[numpy.float64[3, 1]] = ...) -> None: ...
    def body_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def get_body_accelerations_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_body_velocities_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_measurement_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def gravity_vector(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def pose(self) -> pydrake.math.RigidTransform: ...

class CameraConfig:
    class FocalLength:
        __fields__: ClassVar[tuple] = ...  # read-only
        x: float | None
        y: float | None
        def __init__(self, **kwargs) -> None: ...
        def focal_x(self) -> float: ...
        def focal_y(self) -> float: ...
        def __copy__(self) -> CameraConfig.FocalLength: ...
        def __deepcopy__(self, arg0: dict) -> CameraConfig.FocalLength: ...

    class FovDegrees:
        __fields__: ClassVar[tuple] = ...  # read-only
        x: float | None
        y: float | None
        def __init__(self, **kwargs) -> None: ...
        def focal_x(self, width: int, height: int) -> float: ...
        def focal_y(self, width: int, height: int) -> float: ...
        def __copy__(self) -> CameraConfig.FovDegrees: ...
        def __deepcopy__(self, arg0: dict) -> CameraConfig.FovDegrees: ...
    __fields__: ClassVar[tuple] = ...  # read-only
    X_BC: pydrake.common.schema.Transform
    X_BD: pydrake.common.schema.Transform
    X_PB: pydrake.common.schema.Transform
    background: Incomplete
    capture_offset: float
    center_x: float | None
    center_y: float | None
    clipping_far: float
    clipping_near: float
    depth: bool
    do_compress: bool
    focal: CameraConfig.FocalLength | CameraConfig.FovDegrees
    fps: float
    height: int
    label: bool
    lcm_bus: str
    name: str
    output_delay: float
    renderer_class: str | pydrake.geometry.RenderEngineVtkParams | pydrake.geometry.RenderEngineGlParams | pydrake.geometry.RenderEngineGltfClientParams
    renderer_name: str
    rgb: bool
    show_rgb: Incomplete
    width: int
    z_far: float
    z_near: float
    def __init__(self, **kwargs) -> None: ...
    def MakeCameras(self) -> tuple[pydrake.geometry.ColorRenderCamera, pydrake.geometry.DepthRenderCamera]: ...
    def focal_x(self) -> float: ...
    def focal_y(self) -> float: ...
    def principal_point(self) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    def __copy__(self) -> CameraConfig: ...
    def __deepcopy__(self, arg0: dict) -> CameraConfig: ...

class CameraInfo:
    def __init__(self, width: int, height: int, fov_y: float) -> None: ...
    def center_x(self) -> float: ...
    def center_y(self) -> float: ...
    def focal_x(self) -> float: ...
    def focal_y(self) -> float: ...
    def fov_x(self) -> float: ...
    def fov_y(self) -> float: ...
    def height(self) -> int: ...
    def intrinsic_matrix(self) -> numpy.ndarray[numpy.float64[3, 3]]: ...
    def width(self) -> int: ...

class Gyroscope(pydrake.systems.framework.LeafSystem):
    def __init__(self, body: pydrake.multibody.tree.RigidBody, X_BS: pydrake.math.RigidTransform) -> None: ...
    def body_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_body_velocities_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_measurement_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def pose(self) -> pydrake.math.RigidTransform: ...

class Gyroscope_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_BS: pydrake.math.RigidTransform) -> None: ...
    def body_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_body_velocities_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_measurement_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def pose(self) -> pydrake.math.RigidTransform: ...

class Gyroscope_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, body: pydrake.multibody.tree.RigidBody_TExpressionU, X_BS: pydrake.math.RigidTransform) -> None: ...
    def body_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_body_velocities_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_measurement_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def pose(self) -> pydrake.math.RigidTransform: ...

class ImageBgr8U:
    class Traits:
        ChannelType: ClassVar[type[numpy.uint8]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.uint8[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class ImageBgra8U:
    class Traits:
        ChannelType: ClassVar[type[numpy.uint8]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.uint8[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class ImageDepth16U:
    class Traits:
        ChannelType: ClassVar[type[numpy.uint16]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.uint16[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class ImageDepth32F:
    class Traits:
        ChannelType: ClassVar[type[numpy.float32]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: float) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.float32[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class ImageFileFormat:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kJpeg: ClassVar[ImageFileFormat] = ...
    kPng: ClassVar[ImageFileFormat] = ...
    kTiff: ClassVar[ImageFileFormat] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class ImageGrey8U:
    class Traits:
        ChannelType: ClassVar[type[numpy.uint8]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.uint8[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class ImageIo:
    class Metadata:
        __fields__: ClassVar[tuple] = ...  # read-only
        channels: int
        depth: int
        format: ImageFileFormat
        height: int
        scalar: PixelScalar
        width: int
        def __init__(self, **kwargs) -> None: ...
        def __copy__(self) -> ImageIo.Metadata: ...
        def __deepcopy__(self, arg0: dict) -> ImageIo.Metadata: ...
    def __init__(self) -> None: ...
    @overload
    def Load(self, path: os.PathLike, format: ImageFileFormat | None = ...) -> ImageTPixelTypepkBgr8UU | ImageTPixelTypepkBgra8UU | ImageTPixelTypepkDepth16UU | ImageTPixelTypepkDepth32FU | ImageTPixelTypepkGrey8UU | ImageTPixelTypepkRgb8UU | ImageTPixelTypepkRgba8UU | ImageTPixelTypepkLabel16IU: ...
    @overload
    def Load(self, buffer: bytes, format: ImageFileFormat | None = ...) -> ImageTPixelTypepkBgr8UU | ImageTPixelTypepkBgra8UU | ImageTPixelTypepkDepth16UU | ImageTPixelTypepkDepth32FU | ImageTPixelTypepkGrey8UU | ImageTPixelTypepkRgb8UU | ImageTPixelTypepkRgba8UU | ImageTPixelTypepkLabel16IU: ...
    @overload
    def LoadMetadata(self, path: os.PathLike) -> ImageIo.Metadata | None: ...
    @overload
    def LoadMetadata(self, buffer: bytes) -> ImageIo.Metadata | None: ...
    @overload
    def Save(self, image: ImageTPixelTypepkBgr8UU | ImageTPixelTypepkBgra8UU | ImageTPixelTypepkDepth16UU | ImageTPixelTypepkDepth32FU | ImageTPixelTypepkGrey8UU | ImageTPixelTypepkRgb8UU | ImageTPixelTypepkRgba8UU | ImageTPixelTypepkLabel16IU, path: os.PathLike, format: ImageFileFormat | None = ...) -> None: ...
    @overload
    def Save(self, image: ImageTPixelTypepkBgr8UU | ImageTPixelTypepkBgra8UU | ImageTPixelTypepkDepth16UU | ImageTPixelTypepkDepth32FU | ImageTPixelTypepkGrey8UU | ImageTPixelTypepkRgb8UU | ImageTPixelTypepkRgba8UU | ImageTPixelTypepkLabel16IU, format: ImageFileFormat) -> bytes: ...

class ImageLabel16I:
    class Traits:
        ChannelType: ClassVar[type[numpy.int16]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.int16[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class ImageRgb8U:
    class Traits:
        ChannelType: ClassVar[type[numpy.uint8]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.uint8[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class ImageRgba8U:
    class Traits:
        ChannelType: ClassVar[type[numpy.uint8]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.uint8[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class ImageToLcmImageArrayT(pydrake.systems.framework.LeafSystem):
    DeclareImageInputPort: Incomplete
    @overload
    def __init__(self, color_frame_name: str, depth_frame_name: str, label_frame_name: str, do_compress: bool = ...) -> None: ...
    @overload
    def __init__(self, do_compress: bool = ...) -> None: ...
    def DeclareImageInputPort𝓣PixelType𝓹kBgr8U𝓤(self, name: str) -> pydrake.systems.framework.InputPort: ...
    def DeclareImageInputPort𝓣PixelType𝓹kBgra8U𝓤(self, name: str) -> pydrake.systems.framework.InputPort: ...
    def DeclareImageInputPort𝓣PixelType𝓹kDepth16U𝓤(self, name: str) -> pydrake.systems.framework.InputPort: ...
    def DeclareImageInputPort𝓣PixelType𝓹kDepth32F𝓤(self, name: str) -> pydrake.systems.framework.InputPort: ...
    def DeclareImageInputPort𝓣PixelType𝓹kGrey8U𝓤(self, name: str) -> pydrake.systems.framework.InputPort: ...
    def DeclareImageInputPort𝓣PixelType𝓹kLabel16I𝓤(self, name: str) -> pydrake.systems.framework.InputPort: ...
    def DeclareImageInputPort𝓣PixelType𝓹kRgb8U𝓤(self, name: str) -> pydrake.systems.framework.InputPort: ...
    def DeclareImageInputPort𝓣PixelType𝓹kRgba8U𝓤(self, name: str) -> pydrake.systems.framework.InputPort: ...
    def color_image_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def depth_image_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def image_array_t_msg_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def label_image_input_port(self) -> pydrake.systems.framework.InputPort: ...

class ImageTraits𝓣PixelType𝓹kBgr8U𝓤:
    ChannelType: ClassVar[type[numpy.uint8]] = ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    kNumChannels: ClassVar[int] = ...
    kPixelFormat: ClassVar[PixelFormat] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class ImageTraits𝓣PixelType𝓹kBgra8U𝓤:
    ChannelType: ClassVar[type[numpy.uint8]] = ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    kNumChannels: ClassVar[int] = ...
    kPixelFormat: ClassVar[PixelFormat] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class ImageTraits𝓣PixelType𝓹kDepth16U𝓤:
    ChannelType: ClassVar[type[numpy.uint16]] = ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    kNumChannels: ClassVar[int] = ...
    kPixelFormat: ClassVar[PixelFormat] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class ImageTraits𝓣PixelType𝓹kDepth32F𝓤:
    ChannelType: ClassVar[type[numpy.float32]] = ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    kNumChannels: ClassVar[int] = ...
    kPixelFormat: ClassVar[PixelFormat] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class ImageTraits𝓣PixelType𝓹kGrey8U𝓤:
    ChannelType: ClassVar[type[numpy.uint8]] = ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    kNumChannels: ClassVar[int] = ...
    kPixelFormat: ClassVar[PixelFormat] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class ImageTraits𝓣PixelType𝓹kLabel16I𝓤:
    ChannelType: ClassVar[type[numpy.int16]] = ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    kNumChannels: ClassVar[int] = ...
    kPixelFormat: ClassVar[PixelFormat] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class ImageTraits𝓣PixelType𝓹kRgb8U𝓤:
    ChannelType: ClassVar[type[numpy.uint8]] = ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    kNumChannels: ClassVar[int] = ...
    kPixelFormat: ClassVar[PixelFormat] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class ImageTraits𝓣PixelType𝓹kRgba8U𝓤:
    ChannelType: ClassVar[type[numpy.uint8]] = ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    kNumChannels: ClassVar[int] = ...
    kPixelFormat: ClassVar[PixelFormat] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class ImageWriter(pydrake.systems.framework.LeafSystem):
    def __init__(self) -> None: ...
    def DeclareImageInputPort(self, pixel_type: PixelType, port_name: str, file_name_format: str, publish_period: float, start_time: float) -> pydrake.systems.framework.InputPort: ...
    def ResetAllImageCounts(self) -> None: ...

class Image𝓣PixelType𝓹kBgr8U𝓤:
    class Traits:
        ChannelType: ClassVar[type[numpy.uint8]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.uint8[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class Image𝓣PixelType𝓹kBgra8U𝓤:
    class Traits:
        ChannelType: ClassVar[type[numpy.uint8]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.uint8[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class Image𝓣PixelType𝓹kDepth16U𝓤:
    class Traits:
        ChannelType: ClassVar[type[numpy.uint16]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.uint16[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class Image𝓣PixelType𝓹kDepth32F𝓤:
    class Traits:
        ChannelType: ClassVar[type[numpy.float32]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: float) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.float32[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class Image𝓣PixelType𝓹kGrey8U𝓤:
    class Traits:
        ChannelType: ClassVar[type[numpy.uint8]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.uint8[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class Image𝓣PixelType𝓹kLabel16I𝓤:
    class Traits:
        ChannelType: ClassVar[type[numpy.int16]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.int16[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class Image𝓣PixelType𝓹kRgb8U𝓤:
    class Traits:
        ChannelType: ClassVar[type[numpy.uint8]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.uint8[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class Image𝓣PixelType𝓹kRgba8U𝓤:
    class Traits:
        ChannelType: ClassVar[type[numpy.uint8]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.uint8[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class LcmImageArrayToImages(pydrake.systems.framework.LeafSystem):
    def __init__(self) -> None: ...
    def color_image_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def depth_image_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def image_array_t_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def label_image_output_port(self) -> pydrake.systems.framework.OutputPort: ...

class PixelFormat:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kBgr: ClassVar[PixelFormat] = ...
    kBgra: ClassVar[PixelFormat] = ...
    kDepth: ClassVar[PixelFormat] = ...
    kGrey: ClassVar[PixelFormat] = ...
    kLabel: ClassVar[PixelFormat] = ...
    kRgb: ClassVar[PixelFormat] = ...
    kRgba: ClassVar[PixelFormat] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class PixelScalar:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    k16I: ClassVar[PixelScalar] = ...
    k16U: ClassVar[PixelScalar] = ...
    k32F: ClassVar[PixelScalar] = ...
    k8U: ClassVar[PixelScalar] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class PixelType:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kBgr8U: ClassVar[PixelType] = ...
    kBgra8U: ClassVar[PixelType] = ...
    kDepth16U: ClassVar[PixelType] = ...
    kDepth32F: ClassVar[PixelType] = ...
    kGrey8U: ClassVar[PixelType] = ...
    kLabel16I: ClassVar[PixelType] = ...
    kRgb8U: ClassVar[PixelType] = ...
    kRgba8U: ClassVar[PixelType] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class RgbdSensor(pydrake.systems.framework.LeafSystem):
    @overload
    def __init__(self, parent_id: pydrake.geometry.FrameId, X_PB: pydrake.math.RigidTransform, color_camera: pydrake.geometry.ColorRenderCamera, depth_camera: pydrake.geometry.DepthRenderCamera) -> None: ...
    @overload
    def __init__(self, parent_id: pydrake.geometry.FrameId, X_PB: pydrake.math.RigidTransform, depth_camera: pydrake.geometry.DepthRenderCamera, show_window: bool = ...) -> None: ...
    def GetColorRenderCamera(self, context: pydrake.systems.framework.Context) -> pydrake.geometry.ColorRenderCamera: ...
    def GetDepthRenderCamera(self, context: pydrake.systems.framework.Context) -> pydrake.geometry.DepthRenderCamera: ...
    def GetParentFrameId(self, context: pydrake.systems.framework.Context) -> pydrake.geometry.FrameId: ...
    def GetX_PB(self, context: pydrake.systems.framework.Context) -> pydrake.math.RigidTransform: ...
    def SetColorRenderCamera(self, context: pydrake.systems.framework.Context, color_camera: pydrake.geometry.ColorRenderCamera) -> None: ...
    def SetDepthRenderCamera(self, context: pydrake.systems.framework.Context, depth_camera: pydrake.geometry.DepthRenderCamera) -> None: ...
    def SetParentFrameId(self, context: pydrake.systems.framework.Context, id: pydrake.geometry.FrameId) -> None: ...
    def SetX_PB(self, context: pydrake.systems.framework.Context, sensor_pose: pydrake.math.RigidTransform) -> None: ...
    def body_pose_in_world_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def color_image_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def default_X_PB(self) -> pydrake.math.RigidTransform: ...
    def default_color_render_camera(self) -> pydrake.geometry.ColorRenderCamera: ...
    def default_depth_render_camera(self) -> pydrake.geometry.DepthRenderCamera: ...
    def default_parent_frame_id(self) -> pydrake.geometry.FrameId: ...
    def depth_image_16U_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def depth_image_32F_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def image_time_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def label_image_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def query_object_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def set_default_X_PB(self, sensor_pose: pydrake.math.RigidTransform) -> None: ...
    def set_default_color_render_camera(self, color_camera: pydrake.geometry.ColorRenderCamera) -> None: ...
    def set_default_depth_render_camera(self, depth_camera: pydrake.geometry.DepthRenderCamera) -> None: ...
    def set_default_parent_frame_id(self, id: pydrake.geometry.FrameId) -> None: ...

class RgbdSensorAsync(pydrake.systems.framework.LeafSystem):
    def __init__(self, scene_graph: pydrake.geometry.SceneGraph, parent_id: pydrake.geometry.FrameId, X_PB: pydrake.math.RigidTransform, fps: float, capture_offset: float, output_delay: float, color_camera: pydrake.geometry.ColorRenderCamera | None, depth_camera: pydrake.geometry.DepthRenderCamera | None = ..., render_label_image: bool = ...) -> None: ...
    def GetColorRenderCamera(self, context: pydrake.systems.framework.Context) -> pydrake.geometry.ColorRenderCamera | None: ...
    def GetDepthRenderCamera(self, context: pydrake.systems.framework.Context) -> pydrake.geometry.DepthRenderCamera | None: ...
    def GetParentFrameId(self, context: pydrake.systems.framework.Context) -> pydrake.geometry.FrameId: ...
    def GetX_PB(self, context: pydrake.systems.framework.Context) -> pydrake.math.RigidTransform: ...
    def SetColorRenderCamera(self, context: pydrake.systems.framework.Context, color_camera: pydrake.geometry.ColorRenderCamera) -> None: ...
    def SetDepthRenderCamera(self, context: pydrake.systems.framework.Context, depth_camera: pydrake.geometry.DepthRenderCamera) -> None: ...
    def SetParentFrameId(self, context: pydrake.systems.framework.Context, id: pydrake.geometry.FrameId) -> None: ...
    def SetX_PB(self, context: pydrake.systems.framework.Context, sensor_pose: pydrake.math.RigidTransform) -> None: ...
    def body_pose_in_world_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def capture_offset(self) -> float: ...
    def color_image_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def default_X_PB(self) -> pydrake.math.RigidTransform: ...
    def default_color_render_camera(self) -> pydrake.geometry.ColorRenderCamera | None: ...
    def default_depth_render_camera(self) -> pydrake.geometry.DepthRenderCamera | None: ...
    def default_parent_frame_id(self) -> pydrake.geometry.FrameId: ...
    def depth_image_16U_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def depth_image_32F_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def fps(self) -> float: ...
    def image_time_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def label_image_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def output_delay(self) -> float: ...
    def set_default_X_PB(self, sensor_pose: pydrake.math.RigidTransform) -> None: ...
    def set_default_color_render_camera(self, color_camera: pydrake.geometry.ColorRenderCamera) -> None: ...
    def set_default_depth_render_camera(self, depth_camera: pydrake.geometry.DepthRenderCamera) -> None: ...
    def set_default_parent_frame_id(self, id: pydrake.geometry.FrameId) -> None: ...

class RgbdSensorDiscrete(pydrake.systems.framework.Diagram):
    kDefaultPeriod: ClassVar[float] = ...
    def __init__(self, sensor: RgbdSensor, period: float = ..., render_label_image: bool = ...) -> None: ...
    @overload
    def body_pose_in_world_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    @overload
    def body_pose_in_world_output_port(self) -> Any: ...
    @overload
    def color_image_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    @overload
    def color_image_output_port(self) -> Any: ...
    @overload
    def depth_image_16U_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    @overload
    def depth_image_16U_output_port(self) -> Any: ...
    @overload
    def depth_image_32F_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    @overload
    def depth_image_32F_output_port(self) -> Any: ...
    def image_time_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    @overload
    def label_image_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    @overload
    def label_image_output_port(self) -> Any: ...
    def period(self) -> float: ...
    @overload
    def query_object_input_port(self) -> pydrake.systems.framework.InputPort: ...
    @overload
    def query_object_input_port(self) -> Any: ...
    def sensor(self) -> RgbdSensor: ...

class RotaryEncoders(pydrake.systems.framework.VectorSystem):
    @overload
    def __init__(self, ticks_per_revolution: list[int]) -> None: ...
    @overload
    def __init__(self, input_port_size: int, input_vector_indices: list[int]) -> None: ...
    @overload
    def __init__(self, input_port_size: int, input_vector_indices: list[int], ticks_per_revolution: list[int]) -> None: ...
    def get_calibration_offsets(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def set_calibration_offsets(self, context: pydrake.systems.framework.Context, calibration_offsets: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class RotaryEncoders_𝓣AutoDiffXd𝓤(pydrake.systems.framework.VectorSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, ticks_per_revolution: list[int]) -> None: ...
    @overload
    def __init__(self, input_port_size: int, input_vector_indices: list[int]) -> None: ...
    @overload
    def __init__(self, input_port_size: int, input_vector_indices: list[int], ticks_per_revolution: list[int]) -> None: ...
    def get_calibration_offsets(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    def set_calibration_offsets(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, calibration_offsets: numpy.ndarray[object[m, 1]]) -> None: ...

class RotaryEncoders_𝓣Expression𝓤(pydrake.systems.framework.VectorSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, ticks_per_revolution: list[int]) -> None: ...
    @overload
    def __init__(self, input_port_size: int, input_vector_indices: list[int]) -> None: ...
    @overload
    def __init__(self, input_port_size: int, input_vector_indices: list[int], ticks_per_revolution: list[int]) -> None: ...
    def get_calibration_offsets(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    def set_calibration_offsets(self, context: pydrake.systems.framework.Context_TExpressionU, calibration_offsets: numpy.ndarray[object[m, 1]]) -> None: ...

class _TemporaryName_N5drake7systems7sensors11ImageTraitsILNS1_9PixelTypeE0EEE:
    ChannelType: ClassVar[type[numpy.uint8]] = ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    kNumChannels: ClassVar[int] = ...
    kPixelFormat: ClassVar[PixelFormat] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake7systems7sensors11ImageTraitsILNS1_9PixelTypeE1EEE:
    ChannelType: ClassVar[type[numpy.uint8]] = ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    kNumChannels: ClassVar[int] = ...
    kPixelFormat: ClassVar[PixelFormat] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake7systems7sensors11ImageTraitsILNS1_9PixelTypeE2EEE:
    ChannelType: ClassVar[type[numpy.uint8]] = ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    kNumChannels: ClassVar[int] = ...
    kPixelFormat: ClassVar[PixelFormat] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake7systems7sensors11ImageTraitsILNS1_9PixelTypeE3EEE:
    ChannelType: ClassVar[type[numpy.uint8]] = ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    kNumChannels: ClassVar[int] = ...
    kPixelFormat: ClassVar[PixelFormat] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake7systems7sensors11ImageTraitsILNS1_9PixelTypeE4EEE:
    ChannelType: ClassVar[type[numpy.uint8]] = ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    kNumChannels: ClassVar[int] = ...
    kPixelFormat: ClassVar[PixelFormat] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake7systems7sensors11ImageTraitsILNS1_9PixelTypeE5EEE:
    ChannelType: ClassVar[type[numpy.uint16]] = ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    kNumChannels: ClassVar[int] = ...
    kPixelFormat: ClassVar[PixelFormat] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake7systems7sensors11ImageTraitsILNS1_9PixelTypeE6EEE:
    ChannelType: ClassVar[type[numpy.float32]] = ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    kNumChannels: ClassVar[int] = ...
    kPixelFormat: ClassVar[PixelFormat] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake7systems7sensors11ImageTraitsILNS1_9PixelTypeE7EEE:
    ChannelType: ClassVar[type[numpy.int16]] = ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    kNumChannels: ClassVar[int] = ...
    kPixelFormat: ClassVar[PixelFormat] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake7systems7sensors13AccelerometerIN5Eigen14AutoDiffScalarINS3_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_BS: pydrake.math.RigidTransform, gravity_vector: numpy.ndarray[numpy.float64[3, 1]] = ...) -> None: ...
    def body_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def get_body_accelerations_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_body_velocities_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_measurement_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def gravity_vector(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def pose(self) -> pydrake.math.RigidTransform: ...

class _TemporaryName_N5drake7systems7sensors13AccelerometerINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, body: pydrake.multibody.tree.RigidBody_TExpressionU, X_BS: pydrake.math.RigidTransform, gravity_vector: numpy.ndarray[numpy.float64[3, 1]] = ...) -> None: ...
    def body_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def get_body_accelerations_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_body_velocities_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_measurement_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def gravity_vector(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def pose(self) -> pydrake.math.RigidTransform: ...

class _TemporaryName_N5drake7systems7sensors14RotaryEncodersIN5Eigen14AutoDiffScalarINS3_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.VectorSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, ticks_per_revolution: list[int]) -> None: ...
    @overload
    def __init__(self, input_port_size: int, input_vector_indices: list[int]) -> None: ...
    @overload
    def __init__(self, input_port_size: int, input_vector_indices: list[int], ticks_per_revolution: list[int]) -> None: ...
    def get_calibration_offsets(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    def set_calibration_offsets(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, calibration_offsets: numpy.ndarray[object[m, 1]]) -> None: ...

class _TemporaryName_N5drake7systems7sensors14RotaryEncodersINS_8symbolic10ExpressionEEE(pydrake.systems.framework.VectorSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, ticks_per_revolution: list[int]) -> None: ...
    @overload
    def __init__(self, input_port_size: int, input_vector_indices: list[int]) -> None: ...
    @overload
    def __init__(self, input_port_size: int, input_vector_indices: list[int], ticks_per_revolution: list[int]) -> None: ...
    def get_calibration_offsets(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    def set_calibration_offsets(self, context: pydrake.systems.framework.Context_TExpressionU, calibration_offsets: numpy.ndarray[object[m, 1]]) -> None: ...

class _TemporaryName_N5drake7systems7sensors5ImageILNS1_9PixelTypeE0EEE:
    class Traits:
        ChannelType: ClassVar[type[numpy.uint8]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.uint8[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class _TemporaryName_N5drake7systems7sensors5ImageILNS1_9PixelTypeE1EEE:
    class Traits:
        ChannelType: ClassVar[type[numpy.uint8]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.uint8[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class _TemporaryName_N5drake7systems7sensors5ImageILNS1_9PixelTypeE2EEE:
    class Traits:
        ChannelType: ClassVar[type[numpy.uint8]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.uint8[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class _TemporaryName_N5drake7systems7sensors5ImageILNS1_9PixelTypeE3EEE:
    class Traits:
        ChannelType: ClassVar[type[numpy.uint8]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.uint8[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class _TemporaryName_N5drake7systems7sensors5ImageILNS1_9PixelTypeE4EEE:
    class Traits:
        ChannelType: ClassVar[type[numpy.uint8]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.uint8[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class _TemporaryName_N5drake7systems7sensors5ImageILNS1_9PixelTypeE5EEE:
    class Traits:
        ChannelType: ClassVar[type[numpy.uint16]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.uint16[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class _TemporaryName_N5drake7systems7sensors5ImageILNS1_9PixelTypeE6EEE:
    class Traits:
        ChannelType: ClassVar[type[numpy.float32]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: float) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.float32[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class _TemporaryName_N5drake7systems7sensors5ImageILNS1_9PixelTypeE7EEE:
    class Traits:
        ChannelType: ClassVar[type[numpy.int16]] = ...
        _original_name: ClassVar[str] = ...
        _original_qualname: ClassVar[str] = ...
        kNumChannels: ClassVar[int] = ...
        kPixelFormat: ClassVar[PixelFormat] = ...
        def __init__(self, *args, **kwargs) -> None: ...
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, width: int, height: int) -> None: ...
    @overload
    def __init__(self, width: int, height: int, initial_value: int) -> None: ...
    @overload
    def at(self, x: int, y: int) -> numpy.ndarray[numpy.int16[m, 1], flags.writeable]: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    @overload
    def at(self, x, y) -> Any: ...
    def height(self) -> int: ...
    def resize(self, arg0: int, arg1: int) -> None: ...
    def size(self) -> int: ...
    def width(self) -> int: ...
    @property
    def data(self) -> object: ...
    @property
    def mutable_data(self) -> object: ...
    @property
    def shape(self) -> tuple: ...

class _TemporaryName_N5drake7systems7sensors9GyroscopeIN5Eigen14AutoDiffScalarINS3_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_BS: pydrake.math.RigidTransform) -> None: ...
    def body_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_body_velocities_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_measurement_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def pose(self) -> pydrake.math.RigidTransform: ...

class _TemporaryName_N5drake7systems7sensors9GyroscopeINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, body: pydrake.multibody.tree.RigidBody_TExpressionU, X_BS: pydrake.math.RigidTransform) -> None: ...
    def body_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_body_velocities_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_measurement_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def pose(self) -> pydrake.math.RigidTransform: ...

def ApplyCameraConfig(config: CameraConfig, builder: pydrake.systems.framework.DiagramBuilder, lcm_buses: pydrake.systems.lcm.LcmBuses = ..., plant: pydrake.multibody.plant.MultibodyPlant = ..., scene_graph: pydrake.geometry.SceneGraph = ..., lcm: pydrake.lcm.DrakeLcmInterface | pydrake.systems.lcm.LcmInterfaceSystem = ...) -> None: ...
def ConvertDepth16UTo32F(input: ImageTPixelTypepkDepth16UU, output: ImageTPixelTypepkDepth32FU) -> None: ...
def ConvertDepth32FTo16U(input: ImageTPixelTypepkDepth32FU, output: ImageTPixelTypepkDepth16UU) -> None: ...
