import flags
import numpy
import pydrake.autodiffutils
import pydrake.common
import pydrake.common.value
import pydrake.math
import pydrake.symbolic
import pydrake.systems.framework
import pydrake.trajectories
import scipy.sparse
from pydrake.common.cpp_template import Adder_ as Adder_, AffineSystem_ as AffineSystem_, BusCreator_ as BusCreator_, BusSelector_ as BusSelector_, ConstantValueSource_ as ConstantValueSource_, ConstantVectorSource_ as ConstantVectorSource_, Demultiplexer_ as Demultiplexer_, DiscreteDerivative_ as DiscreteDerivative_, DiscreteTimeDelay_ as DiscreteTimeDelay_, DiscreteTimeIntegrator_ as DiscreteTimeIntegrator_, FirstOrderLowPassFilter_ as FirstOrderLowPassFilter_, Gain_ as Gain_, Integrator_ as Integrator_, LinearSystem_ as LinearSystem_, LinearTransformDensity_ as LinearTransformDensity_, MatrixGain_ as MatrixGain_, MultilayerPerceptron_ as MultilayerPerceptron_, Multiplexer_ as Multiplexer_, PassThrough_ as PassThrough_, PortSwitch_ as PortSwitch_, Saturation_ as Saturation_, Selector_ as Selector_, SharedPointerSystem_ as SharedPointerSystem_, Sine_ as Sine_, SparseMatrixGain_ as SparseMatrixGain_, StateInterpolatorWithDiscreteDerivative_ as StateInterpolatorWithDiscreteDerivative_, SymbolicVectorSystem_ as SymbolicVectorSystem_, TrajectoryAffineSystem_ as TrajectoryAffineSystem_, TrajectoryLinearSystem_ as TrajectoryLinearSystem_, TrajectorySource_ as TrajectorySource_, VectorLogSink_ as VectorLogSink_, VectorLog_ as VectorLog_, WrapToSystem_ as WrapToSystem_, ZeroOrderHold_ as ZeroOrderHold_
from typing import Any, Callable, ClassVar, overload

class Adder(pydrake.systems.framework.LeafSystem):
    def __init__(self, num_inputs: int, size: int) -> None: ...

class Adder_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, num_inputs: int, size: int) -> None: ...

class Adder_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, num_inputs: int, size: int) -> None: ...

class AffineSystem(pydrake.systems.framework.LeafSystem):
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., B: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., f0: numpy.ndarray[numpy.float64[m, 1]] = ..., C: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., y0: numpy.ndarray[numpy.float64[m, 1]] = ..., time_period: float = ...) -> None: ...
    def A(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def B(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def C(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def D(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def UpdateCoefficients(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., B: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., f0: numpy.ndarray[numpy.float64[m, 1]] = ..., C: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., y0: numpy.ndarray[numpy.float64[m, 1]] = ...) -> None: ...
    def configure_default_state(self, x0: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def configure_random_state(self, covariance: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...
    def f0(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def num_inputs(self) -> int: ...
    def num_outputs(self) -> int: ...
    def num_states(self) -> int: ...
    def time_period(self) -> float: ...
    def y0(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class AffineSystem_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., B: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., f0: numpy.ndarray[numpy.float64[m, 1]] = ..., C: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., y0: numpy.ndarray[numpy.float64[m, 1]] = ..., time_period: float = ...) -> None: ...
    def A(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def B(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def C(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def D(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def UpdateCoefficients(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., B: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., f0: numpy.ndarray[numpy.float64[m, 1]] = ..., C: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., y0: numpy.ndarray[numpy.float64[m, 1]] = ...) -> None: ...
    def configure_default_state(self, x0: numpy.ndarray[object[m, 1]]) -> None: ...
    def configure_random_state(self, covariance: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...
    def f0(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def num_inputs(self) -> int: ...
    def num_outputs(self) -> int: ...
    def num_states(self) -> int: ...
    def time_period(self) -> float: ...
    def y0(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class AffineSystem_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., B: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., f0: numpy.ndarray[numpy.float64[m, 1]] = ..., C: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., y0: numpy.ndarray[numpy.float64[m, 1]] = ..., time_period: float = ...) -> None: ...
    def A(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def B(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def C(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def D(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def UpdateCoefficients(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., B: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., f0: numpy.ndarray[numpy.float64[m, 1]] = ..., C: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., y0: numpy.ndarray[numpy.float64[m, 1]] = ...) -> None: ...
    def configure_default_state(self, x0: numpy.ndarray[object[m, 1]]) -> None: ...
    def configure_random_state(self, covariance: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...
    def f0(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def num_inputs(self) -> int: ...
    def num_outputs(self) -> int: ...
    def num_states(self) -> int: ...
    def time_period(self) -> float: ...
    def y0(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class BarycentricMeshSystem(pydrake.systems.framework.LeafSystem):
    def __init__(self, arg0: pydrake.math.BarycentricMesh, arg1: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...
    def get_mesh(self) -> pydrake.math.BarycentricMesh: ...
    def get_output_values(self) -> numpy.ndarray[numpy.float64[m, n]]: ...

class BusCreator(pydrake.systems.framework.LeafSystem):
    def __init__(self, output_port_name: str | pydrake.systems.framework.UseDefaultName = ...) -> None: ...
    def DeclareAbstractInputPort(self, name: str | pydrake.systems.framework.UseDefaultName, model_value: pydrake.common.value.AbstractValue) -> pydrake.systems.framework.InputPort: ...
    def DeclareVectorInputPort(self, name: str | pydrake.systems.framework.UseDefaultName, size: int) -> pydrake.systems.framework.InputPort: ...

class BusCreator_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, output_port_name: str | pydrake.systems.framework.UseDefaultName = ...) -> None: ...
    def DeclareAbstractInputPort(self, name: str | pydrake.systems.framework.UseDefaultName, model_value: pydrake.common.value.AbstractValue) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def DeclareVectorInputPort(self, name: str | pydrake.systems.framework.UseDefaultName, size: int) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...

class BusCreator_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, output_port_name: str | pydrake.systems.framework.UseDefaultName = ...) -> None: ...
    def DeclareAbstractInputPort(self, name: str | pydrake.systems.framework.UseDefaultName, model_value: pydrake.common.value.AbstractValue) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def DeclareVectorInputPort(self, name: str | pydrake.systems.framework.UseDefaultName, size: int) -> pydrake.systems.framework.InputPort_TExpressionU: ...

class BusSelector(pydrake.systems.framework.LeafSystem):
    def __init__(self, input_port_name: str | pydrake.systems.framework.UseDefaultName = ...) -> None: ...
    def DeclareAbstractOutputPort(self, name: str | pydrake.systems.framework.UseDefaultName, model_value: pydrake.common.value.AbstractValue) -> pydrake.systems.framework.OutputPort: ...
    def DeclareVectorOutputPort(self, name: str | pydrake.systems.framework.UseDefaultName, size: int) -> pydrake.systems.framework.OutputPort: ...

class BusSelector_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, input_port_name: str | pydrake.systems.framework.UseDefaultName = ...) -> None: ...
    def DeclareAbstractOutputPort(self, name: str | pydrake.systems.framework.UseDefaultName, model_value: pydrake.common.value.AbstractValue) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def DeclareVectorOutputPort(self, name: str | pydrake.systems.framework.UseDefaultName, size: int) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...

class BusSelector_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, input_port_name: str | pydrake.systems.framework.UseDefaultName = ...) -> None: ...
    def DeclareAbstractOutputPort(self, name: str | pydrake.systems.framework.UseDefaultName, model_value: pydrake.common.value.AbstractValue) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def DeclareVectorOutputPort(self, name: str | pydrake.systems.framework.UseDefaultName, size: int) -> pydrake.systems.framework.OutputPort_TExpressionU: ...

class ConstantValueSource(pydrake.systems.framework.LeafSystem):
    def __init__(self, value: pydrake.common.value.AbstractValue) -> None: ...

class ConstantValueSource_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, value: pydrake.common.value.AbstractValue) -> None: ...

class ConstantValueSource_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, value: pydrake.common.value.AbstractValue) -> None: ...

class ConstantVectorSource(pydrake.systems.framework.LeafSystem):
    def __init__(self, source_value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def get_mutable_source_value(self, context: pydrake.systems.framework.Context) -> pydrake.systems.framework.BasicVector: ...
    def get_source_value(self, context: pydrake.systems.framework.Context) -> pydrake.systems.framework.BasicVector: ...

class ConstantVectorSource_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, source_value: numpy.ndarray[object[m, 1]]) -> None: ...
    def get_mutable_source_value(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.systems.framework.BasicVector_TAutoDiffXdU: ...
    def get_source_value(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.systems.framework.BasicVector_TAutoDiffXdU: ...

class ConstantVectorSource_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, source_value: numpy.ndarray[object[m, 1]]) -> None: ...
    def get_mutable_source_value(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.systems.framework.BasicVector_TExpressionU: ...
    def get_source_value(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.systems.framework.BasicVector_TExpressionU: ...

class Demultiplexer(pydrake.systems.framework.LeafSystem):
    @overload
    def __init__(self, size: int, output_ports_size: int = ...) -> None: ...
    @overload
    def __init__(self, output_ports_sizes: list[int]) -> None: ...
    def get_output_ports_sizes(self) -> list[int]: ...

class Demultiplexer_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, size: int, output_ports_size: int = ...) -> None: ...
    @overload
    def __init__(self, output_ports_sizes: list[int]) -> None: ...
    def get_output_ports_sizes(self) -> list[int]: ...

class Demultiplexer_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, size: int, output_ports_size: int = ...) -> None: ...
    @overload
    def __init__(self, output_ports_sizes: list[int]) -> None: ...
    def get_output_ports_sizes(self) -> list[int]: ...

class DiscreteDerivative(pydrake.systems.framework.LeafSystem):
    def __init__(self, num_inputs: int, time_step: float, suppress_initial_transient: bool = ...) -> None: ...
    def suppress_initial_transient(self) -> bool: ...
    def time_step(self) -> float: ...

class DiscreteDerivative_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, num_inputs: int, time_step: float, suppress_initial_transient: bool = ...) -> None: ...
    def suppress_initial_transient(self) -> bool: ...
    def time_step(self) -> float: ...

class DiscreteDerivative_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, num_inputs: int, time_step: float, suppress_initial_transient: bool = ...) -> None: ...
    def suppress_initial_transient(self) -> bool: ...
    def time_step(self) -> float: ...

class DiscreteTimeDelay(pydrake.systems.framework.LeafSystem):
    @overload
    def __init__(self, update_sec: float, delay_time_steps: int, vector_size: int) -> None: ...
    @overload
    def __init__(self, update_sec: float, delay_time_steps: int, abstract_model_value: pydrake.common.value.AbstractValue) -> None: ...

class DiscreteTimeDelay_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, update_sec: float, delay_time_steps: int, vector_size: int) -> None: ...
    @overload
    def __init__(self, update_sec: float, delay_time_steps: int, abstract_model_value: pydrake.common.value.AbstractValue) -> None: ...

class DiscreteTimeDelay_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, update_sec: float, delay_time_steps: int, vector_size: int) -> None: ...
    @overload
    def __init__(self, update_sec: float, delay_time_steps: int, abstract_model_value: pydrake.common.value.AbstractValue) -> None: ...

class DiscreteTimeIntegrator(pydrake.systems.framework.LeafSystem):
    def __init__(self, size: int, time_step: float) -> None: ...
    def set_integral_value(self, context: pydrake.systems.framework.Context, value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def time_step(self) -> float: ...

class DiscreteTimeIntegrator_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, size: int, time_step: float) -> None: ...
    def set_integral_value(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def time_step(self) -> float: ...

class DiscreteTimeIntegrator_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, size: int, time_step: float) -> None: ...
    def set_integral_value(self, context: pydrake.systems.framework.Context_TExpressionU, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def time_step(self) -> float: ...

class FirstOrderLowPassFilter(pydrake.systems.framework.LeafSystem):
    @overload
    def __init__(self, time_constant: float, size: int = ...) -> None: ...
    @overload
    def __init__(self, time_constants: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def get_time_constant(self) -> float: ...
    def get_time_constants_vector(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def set_initial_output_value(self, arg0: pydrake.systems.framework.Context, arg1: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class FirstOrderLowPassFilter_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, time_constant: float, size: int = ...) -> None: ...
    @overload
    def __init__(self, time_constants: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def get_time_constant(self) -> float: ...
    def get_time_constants_vector(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def set_initial_output_value(self, arg0: pydrake.systems.framework.Context_TAutoDiffXdU, arg1: numpy.ndarray[object[m, 1]]) -> None: ...

class FirstOrderLowPassFilter_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, time_constant: float, size: int = ...) -> None: ...
    @overload
    def __init__(self, time_constants: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def get_time_constant(self) -> float: ...
    def get_time_constants_vector(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def set_initial_output_value(self, arg0: pydrake.systems.framework.Context_TExpressionU, arg1: numpy.ndarray[object[m, 1]]) -> None: ...

class Gain(pydrake.systems.framework.LeafSystem):
    @overload
    def __init__(self, k: float, size: int) -> None: ...
    @overload
    def __init__(self, k: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class Gain_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, k: float, size: int) -> None: ...
    @overload
    def __init__(self, k: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class Gain_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, k: float, size: int) -> None: ...
    @overload
    def __init__(self, k: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class Integrator(pydrake.systems.framework.LeafSystem):
    @overload
    def __init__(self, size: int) -> None: ...
    @overload
    def __init__(self, initial_value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_default_integral_value(self, initial_value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_integral_value(self, context: pydrake.systems.framework.Context, value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class Integrator_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, size: int) -> None: ...
    @overload
    def __init__(self, initial_value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_default_integral_value(self, initial_value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_integral_value(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, value: numpy.ndarray[object[m, 1]]) -> None: ...

class Integrator_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, size: int) -> None: ...
    @overload
    def __init__(self, initial_value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_default_integral_value(self, initial_value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_integral_value(self, context: pydrake.systems.framework.Context_TExpressionU, value: numpy.ndarray[object[m, 1]]) -> None: ...

class LinearSystem(AffineSystem):
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., B: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., C: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., time_period: float = ...) -> None: ...

class LinearSystem_𝓣AutoDiffXd𝓤(AffineSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., B: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., C: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., time_period: float = ...) -> None: ...

class LinearSystem_𝓣Expression𝓤(AffineSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., B: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., C: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., time_period: float = ...) -> None: ...

class LinearTransformDensity(pydrake.systems.framework.LeafSystem):
    def __init__(self, distribution: pydrake.common.RandomDistribution, input_size: int, output_size: int) -> None: ...
    def CalcDensity(self, context: pydrake.systems.framework.Context) -> float: ...
    def FixConstantA(self, context: pydrake.systems.framework.Context, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> pydrake.systems.framework.FixedInputPortValue: ...
    def FixConstantB(self, context: pydrake.systems.framework.Context, b: numpy.ndarray[numpy.float64[m, 1]]) -> pydrake.systems.framework.FixedInputPortValue: ...
    def get_distribution(self) -> pydrake.common.RandomDistribution: ...
    def get_input_port_A(self) -> pydrake.systems.framework.InputPort: ...
    def get_input_port_b(self) -> pydrake.systems.framework.InputPort: ...
    def get_input_port_w_in(self) -> pydrake.systems.framework.InputPort: ...
    def get_output_port_w_out(self) -> pydrake.systems.framework.OutputPort: ...
    def get_output_port_w_out_density(self) -> pydrake.systems.framework.OutputPort: ...

class LinearTransformDensity_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, distribution: pydrake.common.RandomDistribution, input_size: int, output_size: int) -> None: ...
    def CalcDensity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def FixConstantA(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, A: numpy.ndarray[object[m, n], flags.f_contiguous]) -> pydrake.systems.framework.FixedInputPortValue: ...
    def FixConstantB(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, b: numpy.ndarray[object[m, 1]]) -> pydrake.systems.framework.FixedInputPortValue: ...
    def get_distribution(self) -> pydrake.common.RandomDistribution: ...
    def get_input_port_A(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_input_port_b(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_input_port_w_in(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_output_port_w_out(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_output_port_w_out_density(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...

class MatrixGain(LinearSystem):
    def __init__(self, D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...

class MatrixGain_𝓣AutoDiffXd𝓤(LinearSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...

class MatrixGain_𝓣Expression𝓤(LinearSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...

class MultilayerPerceptron(pydrake.systems.framework.LeafSystem):
    @overload
    def __init__(self, layers: list[int], activation_type: PerceptronActivationType = ...) -> None: ...
    @overload
    def __init__(self, layers: list[int], activation_types: list[PerceptronActivationType]) -> None: ...
    @overload
    def __init__(self, use_sin_cos_for_input: list[bool], remaining_layers: list[int], activation_types: list[PerceptronActivationType]) -> None: ...
    def Backpropagation(self, context: pydrake.systems.framework.Context, X: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], loss: Callable[[numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], numpy.ndarray[numpy.float64[m, n], flags.writeable, flags.f_contiguous] | None], float], dloss_dparams: numpy.ndarray[numpy.float64[m, 1], flags.writeable] | None) -> float: ...
    def BackpropagationMeanSquaredError(self, context: pydrake.systems.framework.Context, X: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], Y_desired: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], dloss_dparams: numpy.ndarray[numpy.float64[m, 1], flags.writeable] | None) -> float: ...
    @overload
    def BatchOutput(self, context: pydrake.systems.framework.Context, X: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], Y: numpy.ndarray[numpy.float64[m, n], flags.writeable, flags.f_contiguous] | None, dYdX: numpy.ndarray[numpy.float64[m, n], flags.writeable, flags.f_contiguous] | None = ...) -> None: ...
    @overload
    def BatchOutput(self, context: pydrake.systems.framework.Context, X: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def BatchOutput(self, context, X, Y) -> Any: ...
    @overload
    def GetBiases(self, context: pydrake.systems.framework.Context, layer: int) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetBiases(self, params: numpy.ndarray[numpy.float64[m, 1]], layer: int) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetMutableParameters(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[m, 1], flags.writeable]: ...
    def GetParameters(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetWeights(self, context: pydrake.systems.framework.Context, layer: int) -> numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]: ...
    @overload
    def GetWeights(self, params: numpy.ndarray[numpy.float64[m, 1]], layer: int) -> numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]: ...
    @overload
    def SetBiases(self, context: pydrake.systems.framework.Context, layer: int, b: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def SetBiases(self, params: numpy.ndarray[numpy.float64[m, 1], flags.writeable] | None, layer: int, b: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def SetParameters(self, context: pydrake.systems.framework.Context, params: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def SetWeights(self, context: pydrake.systems.framework.Context, layer: int, W: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...
    @overload
    def SetWeights(self, params: numpy.ndarray[numpy.float64[m, 1], flags.writeable] | None, layer: int, W: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...
    def activation_type(self, layer: int) -> PerceptronActivationType: ...
    def layers(self) -> list[int]: ...
    def num_parameters(self) -> int: ...

class MultilayerPerceptron_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, layers: list[int], activation_type: PerceptronActivationType = ...) -> None: ...
    @overload
    def __init__(self, layers: list[int], activation_types: list[PerceptronActivationType]) -> None: ...
    @overload
    def __init__(self, use_sin_cos_for_input: list[bool], remaining_layers: list[int], activation_types: list[PerceptronActivationType]) -> None: ...
    def Backpropagation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, X: numpy.ndarray[object[m, n], flags.f_contiguous], loss: Callable[[numpy.ndarray[object[m, n], flags.f_contiguous], numpy.ndarray[object[m, n], flags.writeable, flags.f_contiguous] | None], pydrake.autodiffutils.AutoDiffXd], dloss_dparams: numpy.ndarray[object[m, 1], flags.writeable] | None) -> pydrake.autodiffutils.AutoDiffXd: ...
    def BackpropagationMeanSquaredError(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, X: numpy.ndarray[object[m, n], flags.f_contiguous], Y_desired: numpy.ndarray[object[m, n], flags.f_contiguous], dloss_dparams: numpy.ndarray[object[m, 1], flags.writeable] | None) -> pydrake.autodiffutils.AutoDiffXd: ...
    @overload
    def BatchOutput(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, X: numpy.ndarray[object[m, n], flags.f_contiguous], Y: numpy.ndarray[object[m, n], flags.writeable, flags.f_contiguous] | None, dYdX: numpy.ndarray[object[m, n], flags.writeable, flags.f_contiguous] | None = ...) -> None: ...
    @overload
    def BatchOutput(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, X: numpy.ndarray[object[m, n], flags.f_contiguous]) -> numpy.ndarray[object[m, n]]: ...
    @overload
    def BatchOutput(self, context, X, Y) -> Any: ...
    @overload
    def GetBiases(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, layer: int) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetBiases(self, params: numpy.ndarray[object[m, 1]], layer: int) -> numpy.ndarray[object[m, 1]]: ...
    def GetMutableParameters(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1], flags.writeable]: ...
    def GetParameters(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetWeights(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, layer: int) -> numpy.ndarray[object[m, n], flags.f_contiguous]: ...
    @overload
    def GetWeights(self, params: numpy.ndarray[object[m, 1]], layer: int) -> numpy.ndarray[object[m, n], flags.f_contiguous]: ...
    @overload
    def SetBiases(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, layer: int, b: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetBiases(self, params: numpy.ndarray[object[m, 1], flags.writeable] | None, layer: int, b: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetParameters(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, params: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetWeights(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, layer: int, W: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    @overload
    def SetWeights(self, params: numpy.ndarray[object[m, 1], flags.writeable] | None, layer: int, W: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    def activation_type(self, layer: int) -> PerceptronActivationType: ...
    def layers(self) -> list[int]: ...
    def num_parameters(self) -> int: ...

class MultilayerPerceptron_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, layers: list[int], activation_type: PerceptronActivationType = ...) -> None: ...
    @overload
    def __init__(self, layers: list[int], activation_types: list[PerceptronActivationType]) -> None: ...
    @overload
    def __init__(self, use_sin_cos_for_input: list[bool], remaining_layers: list[int], activation_types: list[PerceptronActivationType]) -> None: ...
    def Backpropagation(self, context: pydrake.systems.framework.Context_TExpressionU, X: numpy.ndarray[object[m, n], flags.f_contiguous], loss: Callable[[numpy.ndarray[object[m, n], flags.f_contiguous], numpy.ndarray[object[m, n], flags.writeable, flags.f_contiguous] | None], pydrake.symbolic.Expression], dloss_dparams: numpy.ndarray[object[m, 1], flags.writeable] | None) -> pydrake.symbolic.Expression: ...
    def BackpropagationMeanSquaredError(self, context: pydrake.systems.framework.Context_TExpressionU, X: numpy.ndarray[object[m, n], flags.f_contiguous], Y_desired: numpy.ndarray[object[m, n], flags.f_contiguous], dloss_dparams: numpy.ndarray[object[m, 1], flags.writeable] | None) -> pydrake.symbolic.Expression: ...
    @overload
    def BatchOutput(self, context: pydrake.systems.framework.Context_TExpressionU, X: numpy.ndarray[object[m, n], flags.f_contiguous], Y: numpy.ndarray[object[m, n], flags.writeable, flags.f_contiguous] | None, dYdX: numpy.ndarray[object[m, n], flags.writeable, flags.f_contiguous] | None = ...) -> None: ...
    @overload
    def BatchOutput(self, context: pydrake.systems.framework.Context_TExpressionU, X: numpy.ndarray[object[m, n], flags.f_contiguous]) -> numpy.ndarray[object[m, n]]: ...
    @overload
    def BatchOutput(self, context, X, Y) -> Any: ...
    @overload
    def GetBiases(self, context: pydrake.systems.framework.Context_TExpressionU, layer: int) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetBiases(self, params: numpy.ndarray[object[m, 1]], layer: int) -> numpy.ndarray[object[m, 1]]: ...
    def GetMutableParameters(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1], flags.writeable]: ...
    def GetParameters(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetWeights(self, context: pydrake.systems.framework.Context_TExpressionU, layer: int) -> numpy.ndarray[object[m, n], flags.f_contiguous]: ...
    @overload
    def GetWeights(self, params: numpy.ndarray[object[m, 1]], layer: int) -> numpy.ndarray[object[m, n], flags.f_contiguous]: ...
    @overload
    def SetBiases(self, context: pydrake.systems.framework.Context_TExpressionU, layer: int, b: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetBiases(self, params: numpy.ndarray[object[m, 1], flags.writeable] | None, layer: int, b: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetParameters(self, context: pydrake.systems.framework.Context_TExpressionU, params: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetWeights(self, context: pydrake.systems.framework.Context_TExpressionU, layer: int, W: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    @overload
    def SetWeights(self, params: numpy.ndarray[object[m, 1], flags.writeable] | None, layer: int, W: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    def activation_type(self, layer: int) -> PerceptronActivationType: ...
    def layers(self) -> list[int]: ...
    def num_parameters(self) -> int: ...

class Multiplexer(pydrake.systems.framework.LeafSystem):
    @overload
    def __init__(self, num_scalar_inputs: int) -> None: ...
    @overload
    def __init__(self, input_sizes: list[int]) -> None: ...
    @overload
    def __init__(self, model_vector: pydrake.systems.framework.BasicVector) -> None: ...

class Multiplexer_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, num_scalar_inputs: int) -> None: ...
    @overload
    def __init__(self, input_sizes: list[int]) -> None: ...
    @overload
    def __init__(self, model_vector: pydrake.systems.framework.BasicVector_TAutoDiffXdU) -> None: ...

class Multiplexer_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, num_scalar_inputs: int) -> None: ...
    @overload
    def __init__(self, input_sizes: list[int]) -> None: ...
    @overload
    def __init__(self, model_vector: pydrake.systems.framework.BasicVector_TExpressionU) -> None: ...

class PassThrough(pydrake.systems.framework.LeafSystem):
    @overload
    def __init__(self, vector_size: int) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def __init__(self, abstract_model_value: pydrake.common.value.AbstractValue) -> None: ...

class PassThrough_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, vector_size: int) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def __init__(self, abstract_model_value: pydrake.common.value.AbstractValue) -> None: ...

class PassThrough_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, vector_size: int) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def __init__(self, abstract_model_value: pydrake.common.value.AbstractValue) -> None: ...

class PerceptronActivationType:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kIdentity: ClassVar[PerceptronActivationType] = ...
    kReLU: ClassVar[PerceptronActivationType] = ...
    kTanh: ClassVar[PerceptronActivationType] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class PortSwitch(pydrake.systems.framework.LeafSystem):
    def __init__(self, vector_size: int) -> None: ...
    def DeclareInputPort(self, name: str) -> pydrake.systems.framework.InputPort: ...
    def get_port_selector_input_port(self) -> pydrake.systems.framework.InputPort: ...

class PortSwitch_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, vector_size: int) -> None: ...
    def DeclareInputPort(self, name: str) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_port_selector_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...

class PortSwitch_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, vector_size: int) -> None: ...
    def DeclareInputPort(self, name: str) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_port_selector_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...

class RandomSource(pydrake.systems.framework.LeafSystem):
    def __init__(self, distribution: pydrake.common.RandomDistribution, num_outputs: int, sampling_interval_sec: float) -> None: ...

class Saturation(pydrake.systems.framework.LeafSystem):
    def __init__(self, min_value: numpy.ndarray[numpy.float64[m, 1]], max_value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class Saturation_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, min_value: numpy.ndarray[object[m, 1]], max_value: numpy.ndarray[object[m, 1]]) -> None: ...

class Saturation_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, min_value: numpy.ndarray[object[m, 1]], max_value: numpy.ndarray[object[m, 1]]) -> None: ...

class Selector(pydrake.systems.framework.LeafSystem):
    def __init__(self, params: SelectorParams) -> None: ...

class SelectorParams:
    class InputPortParams:
        __fields__: ClassVar[tuple] = ...  # read-only
        name: str | None
        size: int
        def __init__(self, **kwargs) -> None: ...
        def __copy__(self) -> SelectorParams.InputPortParams: ...
        def __deepcopy__(self, arg0: dict) -> SelectorParams.InputPortParams: ...

    class OutputPortParams:
        __fields__: ClassVar[tuple] = ...  # read-only
        name: str | None
        selections: list[SelectorParams.OutputSelection]
        def __init__(self, **kwargs) -> None: ...
        def __copy__(self) -> SelectorParams.OutputPortParams: ...
        def __deepcopy__(self, arg0: dict) -> SelectorParams.OutputPortParams: ...

    class OutputSelection:
        __fields__: ClassVar[tuple] = ...  # read-only
        input_offset: int
        input_port_index: int
        def __init__(self, **kwargs) -> None: ...
        def __copy__(self) -> SelectorParams.OutputSelection: ...
        def __deepcopy__(self, arg0: dict) -> SelectorParams.OutputSelection: ...
    __fields__: ClassVar[tuple] = ...  # read-only
    inputs: list[SelectorParams.InputPortParams]
    outputs: list[SelectorParams.OutputPortParams]
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> SelectorParams: ...
    def __deepcopy__(self, arg0: dict) -> SelectorParams: ...

class Selector_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, params: SelectorParams) -> None: ...

class Selector_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, params: SelectorParams) -> None: ...

class SharedPointerSystem(pydrake.systems.framework.LeafSystem):
    def __init__(self, value_to_hold: object) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder, value_to_hold: object) -> object: ...
    def get(self) -> object: ...

class SharedPointerSystem_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, value_to_hold: object) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder_TAutoDiffXdU, value_to_hold: object) -> object: ...
    def get(self) -> object: ...

class SharedPointerSystem_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, value_to_hold: object) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder_TExpressionU, value_to_hold: object) -> object: ...
    def get(self) -> object: ...

class Sine(pydrake.systems.framework.LeafSystem):
    @overload
    def __init__(self, amplitude: float, frequency: float, phase: float, size: int, is_time_based: bool = ...) -> None: ...
    @overload
    def __init__(self, amplitudes: numpy.ndarray[numpy.float64[m, 1]], frequencies: numpy.ndarray[numpy.float64[m, 1]], phases: numpy.ndarray[numpy.float64[m, 1]], is_time_based: bool = ...) -> None: ...

class Sine_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, amplitude: float, frequency: float, phase: float, size: int, is_time_based: bool = ...) -> None: ...
    @overload
    def __init__(self, amplitudes: numpy.ndarray[numpy.float64[m, 1]], frequencies: numpy.ndarray[numpy.float64[m, 1]], phases: numpy.ndarray[numpy.float64[m, 1]], is_time_based: bool = ...) -> None: ...

class Sine_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, amplitude: float, frequency: float, phase: float, size: int, is_time_based: bool = ...) -> None: ...
    @overload
    def __init__(self, amplitudes: numpy.ndarray[numpy.float64[m, 1]], frequencies: numpy.ndarray[numpy.float64[m, 1]], phases: numpy.ndarray[numpy.float64[m, 1]], is_time_based: bool = ...) -> None: ...

class SparseMatrixGain(pydrake.systems.framework.LeafSystem):
    def __init__(self, D: scipy.sparse.csc_matrix[numpy.float64]) -> None: ...
    def D(self) -> scipy.sparse.csc_matrix[numpy.float64]: ...
    def set_D(self, D: scipy.sparse.csc_matrix[numpy.float64]) -> None: ...

class SparseMatrixGain_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, D: scipy.sparse.csc_matrix[numpy.float64]) -> None: ...
    def D(self) -> scipy.sparse.csc_matrix[numpy.float64]: ...
    def set_D(self, D: scipy.sparse.csc_matrix[numpy.float64]) -> None: ...

class SparseMatrixGain_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, D: scipy.sparse.csc_matrix[numpy.float64]) -> None: ...
    def D(self) -> scipy.sparse.csc_matrix[numpy.float64]: ...
    def set_D(self, D: scipy.sparse.csc_matrix[numpy.float64]) -> None: ...

class StateInterpolatorWithDiscreteDerivative(pydrake.systems.framework.Diagram):
    def __init__(self, num_positions: int, time_step: float, suppress_initial_transient: bool = ...) -> None: ...
    @overload
    def set_initial_position(self, context: pydrake.systems.framework.Context, position: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def set_initial_position(self, state: pydrake.systems.framework.State, position: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def suppress_initial_transient(self) -> bool: ...

class StateInterpolatorWithDiscreteDerivative_𝓣AutoDiffXd𝓤(pydrake.systems.framework.Diagram_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, num_positions: int, time_step: float, suppress_initial_transient: bool = ...) -> None: ...
    @overload
    def set_initial_position(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, position: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def set_initial_position(self, state: pydrake.systems.framework.State_TAutoDiffXdU, position: numpy.ndarray[object[m, 1]]) -> None: ...
    def suppress_initial_transient(self) -> bool: ...

class StateInterpolatorWithDiscreteDerivative_𝓣Expression𝓤(pydrake.systems.framework.Diagram_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, num_positions: int, time_step: float, suppress_initial_transient: bool = ...) -> None: ...
    @overload
    def set_initial_position(self, context: pydrake.systems.framework.Context_TExpressionU, position: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def set_initial_position(self, state: pydrake.systems.framework.State_TExpressionU, position: numpy.ndarray[object[m, 1]]) -> None: ...
    def suppress_initial_transient(self) -> bool: ...

class SymbolicVectorSystem(pydrake.systems.framework.LeafSystem):
    @overload
    def __init__(self, time: pydrake.symbolic.Variable | None = ..., state: numpy.ndarray[object[m, 1]] = ..., input: numpy.ndarray[object[m, 1]] = ..., dynamics: numpy.ndarray[object[m, 1]] = ..., output: numpy.ndarray[object[m, 1]] = ..., time_period: float = ...) -> None: ...
    @overload
    def __init__(self, time: pydrake.symbolic.Variable | None = ..., state: numpy.ndarray[object[m, 1]] = ..., input: numpy.ndarray[object[m, 1]] = ..., parameter: numpy.ndarray[object[m, 1]] = ..., dynamics: numpy.ndarray[object[m, 1]] = ..., output: numpy.ndarray[object[m, 1]] = ..., time_period: float = ...) -> None: ...
    def dynamics_for_variable(self, var: pydrake.symbolic.Variable) -> pydrake.symbolic.Expression: ...

class SymbolicVectorSystem_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, time: pydrake.symbolic.Variable | None = ..., state: numpy.ndarray[object[m, 1]] = ..., input: numpy.ndarray[object[m, 1]] = ..., dynamics: numpy.ndarray[object[m, 1]] = ..., output: numpy.ndarray[object[m, 1]] = ..., time_period: float = ...) -> None: ...
    @overload
    def __init__(self, time: pydrake.symbolic.Variable | None = ..., state: numpy.ndarray[object[m, 1]] = ..., input: numpy.ndarray[object[m, 1]] = ..., parameter: numpy.ndarray[object[m, 1]] = ..., dynamics: numpy.ndarray[object[m, 1]] = ..., output: numpy.ndarray[object[m, 1]] = ..., time_period: float = ...) -> None: ...
    def dynamics_for_variable(self, var: pydrake.symbolic.Variable) -> pydrake.symbolic.Expression: ...

class SymbolicVectorSystem_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, time: pydrake.symbolic.Variable | None = ..., state: numpy.ndarray[object[m, 1]] = ..., input: numpy.ndarray[object[m, 1]] = ..., dynamics: numpy.ndarray[object[m, 1]] = ..., output: numpy.ndarray[object[m, 1]] = ..., time_period: float = ...) -> None: ...
    @overload
    def __init__(self, time: pydrake.symbolic.Variable | None = ..., state: numpy.ndarray[object[m, 1]] = ..., input: numpy.ndarray[object[m, 1]] = ..., parameter: numpy.ndarray[object[m, 1]] = ..., dynamics: numpy.ndarray[object[m, 1]] = ..., output: numpy.ndarray[object[m, 1]] = ..., time_period: float = ...) -> None: ...
    def dynamics_for_variable(self, var: pydrake.symbolic.Variable) -> pydrake.symbolic.Expression: ...

class TrajectoryAffineSystem(pydrake.systems.framework.LeafSystem):
    def __init__(self, A: pydrake.trajectories.Trajectory, B: pydrake.trajectories.Trajectory, f0: pydrake.trajectories.Trajectory, C: pydrake.trajectories.Trajectory, D: pydrake.trajectories.Trajectory, y0: pydrake.trajectories.Trajectory, time_period: float = ...) -> None: ...
    def A(self, arg0: float) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def B(self, arg0: float) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def C(self, arg0: float) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def D(self, arg0: float) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def configure_default_state(self, x0: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def configure_random_state(self, covariance: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...
    def f0(self, arg0: float) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def time_period(self) -> float: ...
    def y0(self, arg0: float) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class TrajectoryAffineSystem_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, A: pydrake.trajectories.Trajectory, B: pydrake.trajectories.Trajectory, f0: pydrake.trajectories.Trajectory, C: pydrake.trajectories.Trajectory, D: pydrake.trajectories.Trajectory, y0: pydrake.trajectories.Trajectory, time_period: float = ...) -> None: ...
    def A(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, n]]: ...
    def B(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, n]]: ...
    def C(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, n]]: ...
    def D(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, n]]: ...
    def configure_default_state(self, x0: numpy.ndarray[object[m, 1]]) -> None: ...
    def configure_random_state(self, covariance: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...
    def f0(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, 1]]: ...
    def time_period(self) -> float: ...
    def y0(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, 1]]: ...

class TrajectoryLinearSystem(pydrake.systems.framework.LeafSystem):
    def __init__(self, A: pydrake.trajectories.Trajectory, B: pydrake.trajectories.Trajectory, C: pydrake.trajectories.Trajectory, D: pydrake.trajectories.Trajectory, time_period: float = ...) -> None: ...
    def A(self, arg0: float) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def B(self, arg0: float) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def C(self, arg0: float) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def D(self, arg0: float) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def configure_default_state(self, x0: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def configure_random_state(self, covariance: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...
    def time_period(self) -> float: ...

class TrajectoryLinearSystem_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, A: pydrake.trajectories.Trajectory, B: pydrake.trajectories.Trajectory, C: pydrake.trajectories.Trajectory, D: pydrake.trajectories.Trajectory, time_period: float = ...) -> None: ...
    def A(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, n]]: ...
    def B(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, n]]: ...
    def C(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, n]]: ...
    def D(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, n]]: ...
    def configure_default_state(self, x0: numpy.ndarray[object[m, 1]]) -> None: ...
    def configure_random_state(self, covariance: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...
    def time_period(self) -> float: ...

class TrajectorySource(pydrake.systems.framework.LeafSystem):
    def __init__(self, trajectory: pydrake.trajectories.Trajectory, output_derivative_order: int = ..., zero_derivatives_beyond_limits: bool = ...) -> None: ...
    def UpdateTrajectory(self, trajectory: pydrake.trajectories.Trajectory) -> None: ...

class TrajectorySource_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, trajectory: pydrake.trajectories.Trajectory_TAutoDiffXdU, output_derivative_order: int = ..., zero_derivatives_beyond_limits: bool = ...) -> None: ...
    def UpdateTrajectory(self, trajectory: pydrake.trajectories.Trajectory_TAutoDiffXdU) -> None: ...

class TrajectorySource_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, trajectory: pydrake.trajectories.Trajectory_TExpressionU, output_derivative_order: int = ..., zero_derivatives_beyond_limits: bool = ...) -> None: ...
    def UpdateTrajectory(self, trajectory: pydrake.trajectories.Trajectory_TExpressionU) -> None: ...

class VectorLog:
    kDefaultCapacity: ClassVar[int] = ...  # read-only
    def __init__(self, input_size: int) -> None: ...
    def AddData(self, time: float, sample: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def Clear(self) -> None: ...
    def Reserve(self, arg0: int) -> None: ...
    def data(self) -> numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]: ...
    def get_input_size(self) -> int: ...
    def num_samples(self) -> int: ...
    def sample_times(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class VectorLogSink(pydrake.systems.framework.LeafSystem):
    @overload
    def __init__(self, input_size: int, publish_period: float = ...) -> None: ...
    @overload
    def __init__(self, input_size: int, publish_triggers: set[pydrake.systems.framework.TriggerType], publish_period: float = ...) -> None: ...
    def FindLog(self, context: pydrake.systems.framework.Context) -> VectorLog: ...
    def FindMutableLog(self, context: pydrake.systems.framework.Context) -> VectorLog: ...
    def GetLog(self, context: pydrake.systems.framework.Context) -> VectorLog: ...
    def GetMutableLog(self, context: pydrake.systems.framework.Context) -> VectorLog: ...

class VectorLogSink_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, input_size: int, publish_period: float = ...) -> None: ...
    @overload
    def __init__(self, input_size: int, publish_triggers: set[pydrake.systems.framework.TriggerType], publish_period: float = ...) -> None: ...
    def FindLog(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> VectorLog_TAutoDiffXdU: ...
    def FindMutableLog(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> VectorLog_TAutoDiffXdU: ...
    def GetLog(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> VectorLog_TAutoDiffXdU: ...
    def GetMutableLog(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> VectorLog_TAutoDiffXdU: ...

class VectorLogSink_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, input_size: int, publish_period: float = ...) -> None: ...
    @overload
    def __init__(self, input_size: int, publish_triggers: set[pydrake.systems.framework.TriggerType], publish_period: float = ...) -> None: ...
    def FindLog(self, context: pydrake.systems.framework.Context_TExpressionU) -> VectorLog_TExpressionU: ...
    def FindMutableLog(self, context: pydrake.systems.framework.Context_TExpressionU) -> VectorLog_TExpressionU: ...
    def GetLog(self, context: pydrake.systems.framework.Context_TExpressionU) -> VectorLog_TExpressionU: ...
    def GetMutableLog(self, context: pydrake.systems.framework.Context_TExpressionU) -> VectorLog_TExpressionU: ...

class VectorLog_𝓣AutoDiffXd𝓤:
    kDefaultCapacity: ClassVar[int] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, input_size: int) -> None: ...
    def AddData(self, time: pydrake.autodiffutils.AutoDiffXd, sample: numpy.ndarray[object[m, 1]]) -> None: ...
    def Clear(self) -> None: ...
    def Reserve(self, arg0: int) -> None: ...
    def data(self) -> numpy.ndarray[object[m, n]]: ...
    def get_input_size(self) -> int: ...
    def num_samples(self) -> int: ...
    def sample_times(self) -> numpy.ndarray[object[m, 1]]: ...

class VectorLog_𝓣Expression𝓤:
    kDefaultCapacity: ClassVar[int] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, input_size: int) -> None: ...
    def AddData(self, time: pydrake.symbolic.Expression, sample: numpy.ndarray[object[m, 1]]) -> None: ...
    def Clear(self) -> None: ...
    def Reserve(self, arg0: int) -> None: ...
    def data(self) -> numpy.ndarray[object[m, n]]: ...
    def get_input_size(self) -> int: ...
    def num_samples(self) -> int: ...
    def sample_times(self) -> numpy.ndarray[object[m, 1]]: ...

class WrapToSystem(pydrake.systems.framework.LeafSystem):
    def __init__(self, arg0: int) -> None: ...
    def set_interval(self, arg0: int, arg1: float, arg2: float) -> None: ...

class WrapToSystem_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, arg0: int) -> None: ...
    def set_interval(self, arg0: int, arg1: pydrake.autodiffutils.AutoDiffXd, arg2: pydrake.autodiffutils.AutoDiffXd) -> None: ...

class WrapToSystem_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, arg0: int) -> None: ...
    def set_interval(self, arg0: int, arg1: pydrake.symbolic.Expression, arg2: pydrake.symbolic.Expression) -> None: ...

class ZeroOrderHold(pydrake.systems.framework.LeafSystem):
    @overload
    def __init__(self, period_sec: float, vector_size: int, offset_sec: float = ...) -> None: ...
    @overload
    def __init__(self, period_sec: float, abstract_model_value: pydrake.common.value.AbstractValue, offset_sec: float = ...) -> None: ...
    def SetVectorState(self, arg0: pydrake.systems.framework.Context, arg1: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def offset(self) -> float: ...
    def period(self) -> float: ...

class ZeroOrderHold_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, period_sec: float, vector_size: int, offset_sec: float = ...) -> None: ...
    @overload
    def __init__(self, period_sec: float, abstract_model_value: pydrake.common.value.AbstractValue, offset_sec: float = ...) -> None: ...
    def SetVectorState(self, arg0: pydrake.systems.framework.Context_TAutoDiffXdU, arg1: numpy.ndarray[object[m, 1]]) -> None: ...
    def offset(self) -> float: ...
    def period(self) -> float: ...

class ZeroOrderHold_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, period_sec: float, vector_size: int, offset_sec: float = ...) -> None: ...
    @overload
    def __init__(self, period_sec: float, abstract_model_value: pydrake.common.value.AbstractValue, offset_sec: float = ...) -> None: ...
    def SetVectorState(self, arg0: pydrake.systems.framework.Context_TExpressionU, arg1: numpy.ndarray[object[m, 1]]) -> None: ...
    def offset(self) -> float: ...
    def period(self) -> float: ...

class _TemporaryName_N5drake7systems10BusCreatorIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, output_port_name: str | pydrake.systems.framework.UseDefaultName = ...) -> None: ...
    def DeclareAbstractInputPort(self, name: str | pydrake.systems.framework.UseDefaultName, model_value: pydrake.common.value.AbstractValue) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def DeclareVectorInputPort(self, name: str | pydrake.systems.framework.UseDefaultName, size: int) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...

class _TemporaryName_N5drake7systems10BusCreatorINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, output_port_name: str | pydrake.systems.framework.UseDefaultName = ...) -> None: ...
    def DeclareAbstractInputPort(self, name: str | pydrake.systems.framework.UseDefaultName, model_value: pydrake.common.value.AbstractValue) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def DeclareVectorInputPort(self, name: str | pydrake.systems.framework.UseDefaultName, size: int) -> pydrake.systems.framework.InputPort_TExpressionU: ...

class _TemporaryName_N5drake7systems10IntegratorIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, size: int) -> None: ...
    @overload
    def __init__(self, initial_value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_default_integral_value(self, initial_value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_integral_value(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, value: numpy.ndarray[object[m, 1]]) -> None: ...

class _TemporaryName_N5drake7systems10IntegratorINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, size: int) -> None: ...
    @overload
    def __init__(self, initial_value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_default_integral_value(self, initial_value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_integral_value(self, context: pydrake.systems.framework.Context_TExpressionU, value: numpy.ndarray[object[m, 1]]) -> None: ...

class _TemporaryName_N5drake7systems10MatrixGainIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(LinearSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...

class _TemporaryName_N5drake7systems10MatrixGainINS_8symbolic10ExpressionEEE(LinearSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...

class _TemporaryName_N5drake7systems10PortSwitchIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, vector_size: int) -> None: ...
    def DeclareInputPort(self, name: str) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_port_selector_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...

class _TemporaryName_N5drake7systems10PortSwitchINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, vector_size: int) -> None: ...
    def DeclareInputPort(self, name: str) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_port_selector_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...

class _TemporaryName_N5drake7systems10SaturationIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, min_value: numpy.ndarray[object[m, 1]], max_value: numpy.ndarray[object[m, 1]]) -> None: ...

class _TemporaryName_N5drake7systems10SaturationINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, min_value: numpy.ndarray[object[m, 1]], max_value: numpy.ndarray[object[m, 1]]) -> None: ...

class _TemporaryName_N5drake7systems11BusSelectorIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, input_port_name: str | pydrake.systems.framework.UseDefaultName = ...) -> None: ...
    def DeclareAbstractOutputPort(self, name: str | pydrake.systems.framework.UseDefaultName, model_value: pydrake.common.value.AbstractValue) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def DeclareVectorOutputPort(self, name: str | pydrake.systems.framework.UseDefaultName, size: int) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...

class _TemporaryName_N5drake7systems11BusSelectorINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, input_port_name: str | pydrake.systems.framework.UseDefaultName = ...) -> None: ...
    def DeclareAbstractOutputPort(self, name: str | pydrake.systems.framework.UseDefaultName, model_value: pydrake.common.value.AbstractValue) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def DeclareVectorOutputPort(self, name: str | pydrake.systems.framework.UseDefaultName, size: int) -> pydrake.systems.framework.OutputPort_TExpressionU: ...

class _TemporaryName_N5drake7systems11MultiplexerIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, num_scalar_inputs: int) -> None: ...
    @overload
    def __init__(self, input_sizes: list[int]) -> None: ...
    @overload
    def __init__(self, model_vector: pydrake.systems.framework.BasicVector_TAutoDiffXdU) -> None: ...

class _TemporaryName_N5drake7systems11MultiplexerINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, num_scalar_inputs: int) -> None: ...
    @overload
    def __init__(self, input_sizes: list[int]) -> None: ...
    @overload
    def __init__(self, model_vector: pydrake.systems.framework.BasicVector_TExpressionU) -> None: ...

class _TemporaryName_N5drake7systems11PassThroughIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, vector_size: int) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def __init__(self, abstract_model_value: pydrake.common.value.AbstractValue) -> None: ...

class _TemporaryName_N5drake7systems11PassThroughINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, vector_size: int) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def __init__(self, abstract_model_value: pydrake.common.value.AbstractValue) -> None: ...

class _TemporaryName_N5drake7systems12AffineSystemIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., B: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., f0: numpy.ndarray[numpy.float64[m, 1]] = ..., C: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., y0: numpy.ndarray[numpy.float64[m, 1]] = ..., time_period: float = ...) -> None: ...
    def A(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def B(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def C(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def D(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def UpdateCoefficients(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., B: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., f0: numpy.ndarray[numpy.float64[m, 1]] = ..., C: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., y0: numpy.ndarray[numpy.float64[m, 1]] = ...) -> None: ...
    def configure_default_state(self, x0: numpy.ndarray[object[m, 1]]) -> None: ...
    def configure_random_state(self, covariance: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...
    def f0(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def num_inputs(self) -> int: ...
    def num_outputs(self) -> int: ...
    def num_states(self) -> int: ...
    def time_period(self) -> float: ...
    def y0(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class _TemporaryName_N5drake7systems12AffineSystemINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., B: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., f0: numpy.ndarray[numpy.float64[m, 1]] = ..., C: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., y0: numpy.ndarray[numpy.float64[m, 1]] = ..., time_period: float = ...) -> None: ...
    def A(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def B(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def C(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def D(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def UpdateCoefficients(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., B: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., f0: numpy.ndarray[numpy.float64[m, 1]] = ..., C: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., y0: numpy.ndarray[numpy.float64[m, 1]] = ...) -> None: ...
    def configure_default_state(self, x0: numpy.ndarray[object[m, 1]]) -> None: ...
    def configure_random_state(self, covariance: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...
    def f0(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def num_inputs(self) -> int: ...
    def num_outputs(self) -> int: ...
    def num_states(self) -> int: ...
    def time_period(self) -> float: ...
    def y0(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class _TemporaryName_N5drake7systems12LinearSystemIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(AffineSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., B: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., C: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., time_period: float = ...) -> None: ...

class _TemporaryName_N5drake7systems12LinearSystemINS_8symbolic10ExpressionEEE(AffineSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., B: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., C: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., D: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., time_period: float = ...) -> None: ...

class _TemporaryName_N5drake7systems12WrapToSystemIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, arg0: int) -> None: ...
    def set_interval(self, arg0: int, arg1: pydrake.autodiffutils.AutoDiffXd, arg2: pydrake.autodiffutils.AutoDiffXd) -> None: ...

class _TemporaryName_N5drake7systems12WrapToSystemINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, arg0: int) -> None: ...
    def set_interval(self, arg0: int, arg1: pydrake.symbolic.Expression, arg2: pydrake.symbolic.Expression) -> None: ...

class _TemporaryName_N5drake7systems13DemultiplexerIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, size: int, output_ports_size: int = ...) -> None: ...
    @overload
    def __init__(self, output_ports_sizes: list[int]) -> None: ...
    def get_output_ports_sizes(self) -> list[int]: ...

class _TemporaryName_N5drake7systems13DemultiplexerINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, size: int, output_ports_size: int = ...) -> None: ...
    @overload
    def __init__(self, output_ports_sizes: list[int]) -> None: ...
    def get_output_ports_sizes(self) -> list[int]: ...

class _TemporaryName_N5drake7systems13VectorLogSinkIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, input_size: int, publish_period: float = ...) -> None: ...
    @overload
    def __init__(self, input_size: int, publish_triggers: set[pydrake.systems.framework.TriggerType], publish_period: float = ...) -> None: ...
    def FindLog(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> VectorLog_TAutoDiffXdU: ...
    def FindMutableLog(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> VectorLog_TAutoDiffXdU: ...
    def GetLog(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> VectorLog_TAutoDiffXdU: ...
    def GetMutableLog(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> VectorLog_TAutoDiffXdU: ...

class _TemporaryName_N5drake7systems13VectorLogSinkINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, input_size: int, publish_period: float = ...) -> None: ...
    @overload
    def __init__(self, input_size: int, publish_triggers: set[pydrake.systems.framework.TriggerType], publish_period: float = ...) -> None: ...
    def FindLog(self, context: pydrake.systems.framework.Context_TExpressionU) -> VectorLog_TExpressionU: ...
    def FindMutableLog(self, context: pydrake.systems.framework.Context_TExpressionU) -> VectorLog_TExpressionU: ...
    def GetLog(self, context: pydrake.systems.framework.Context_TExpressionU) -> VectorLog_TExpressionU: ...
    def GetMutableLog(self, context: pydrake.systems.framework.Context_TExpressionU) -> VectorLog_TExpressionU: ...

class _TemporaryName_N5drake7systems13ZeroOrderHoldIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, period_sec: float, vector_size: int, offset_sec: float = ...) -> None: ...
    @overload
    def __init__(self, period_sec: float, abstract_model_value: pydrake.common.value.AbstractValue, offset_sec: float = ...) -> None: ...
    def SetVectorState(self, arg0: pydrake.systems.framework.Context_TAutoDiffXdU, arg1: numpy.ndarray[object[m, 1]]) -> None: ...
    def offset(self) -> float: ...
    def period(self) -> float: ...

class _TemporaryName_N5drake7systems13ZeroOrderHoldINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, period_sec: float, vector_size: int, offset_sec: float = ...) -> None: ...
    @overload
    def __init__(self, period_sec: float, abstract_model_value: pydrake.common.value.AbstractValue, offset_sec: float = ...) -> None: ...
    def SetVectorState(self, arg0: pydrake.systems.framework.Context_TExpressionU, arg1: numpy.ndarray[object[m, 1]]) -> None: ...
    def offset(self) -> float: ...
    def period(self) -> float: ...

class _TemporaryName_N5drake7systems16SparseMatrixGainIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, D: scipy.sparse.csc_matrix[numpy.float64]) -> None: ...
    def D(self) -> scipy.sparse.csc_matrix[numpy.float64]: ...
    def set_D(self, D: scipy.sparse.csc_matrix[numpy.float64]) -> None: ...

class _TemporaryName_N5drake7systems16SparseMatrixGainINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, D: scipy.sparse.csc_matrix[numpy.float64]) -> None: ...
    def D(self) -> scipy.sparse.csc_matrix[numpy.float64]: ...
    def set_D(self, D: scipy.sparse.csc_matrix[numpy.float64]) -> None: ...

class _TemporaryName_N5drake7systems16TrajectorySourceIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, trajectory: pydrake.trajectories.Trajectory_TAutoDiffXdU, output_derivative_order: int = ..., zero_derivatives_beyond_limits: bool = ...) -> None: ...
    def UpdateTrajectory(self, trajectory: pydrake.trajectories.Trajectory_TAutoDiffXdU) -> None: ...

class _TemporaryName_N5drake7systems16TrajectorySourceINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, trajectory: pydrake.trajectories.Trajectory_TExpressionU, output_derivative_order: int = ..., zero_derivatives_beyond_limits: bool = ...) -> None: ...
    def UpdateTrajectory(self, trajectory: pydrake.trajectories.Trajectory_TExpressionU) -> None: ...

class _TemporaryName_N5drake7systems17DiscreteTimeDelayIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, update_sec: float, delay_time_steps: int, vector_size: int) -> None: ...
    @overload
    def __init__(self, update_sec: float, delay_time_steps: int, abstract_model_value: pydrake.common.value.AbstractValue) -> None: ...

class _TemporaryName_N5drake7systems17DiscreteTimeDelayINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, update_sec: float, delay_time_steps: int, vector_size: int) -> None: ...
    @overload
    def __init__(self, update_sec: float, delay_time_steps: int, abstract_model_value: pydrake.common.value.AbstractValue) -> None: ...

class _TemporaryName_N5drake7systems18DiscreteDerivativeIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, num_inputs: int, time_step: float, suppress_initial_transient: bool = ...) -> None: ...
    def suppress_initial_transient(self) -> bool: ...
    def time_step(self) -> float: ...

class _TemporaryName_N5drake7systems18DiscreteDerivativeINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, num_inputs: int, time_step: float, suppress_initial_transient: bool = ...) -> None: ...
    def suppress_initial_transient(self) -> bool: ...
    def time_step(self) -> float: ...

class _TemporaryName_N5drake7systems19ConstantValueSourceIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, value: pydrake.common.value.AbstractValue) -> None: ...

class _TemporaryName_N5drake7systems19ConstantValueSourceINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, value: pydrake.common.value.AbstractValue) -> None: ...

class _TemporaryName_N5drake7systems19SharedPointerSystemIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, value_to_hold: object) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder_TAutoDiffXdU, value_to_hold: object) -> object: ...
    def get(self) -> object: ...

class _TemporaryName_N5drake7systems19SharedPointerSystemINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, value_to_hold: object) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder_TExpressionU, value_to_hold: object) -> object: ...
    def get(self) -> object: ...

class _TemporaryName_N5drake7systems20ConstantVectorSourceIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, source_value: numpy.ndarray[object[m, 1]]) -> None: ...
    def get_mutable_source_value(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.systems.framework.BasicVector_TAutoDiffXdU: ...
    def get_source_value(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.systems.framework.BasicVector_TAutoDiffXdU: ...

class _TemporaryName_N5drake7systems20ConstantVectorSourceINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, source_value: numpy.ndarray[object[m, 1]]) -> None: ...
    def get_mutable_source_value(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.systems.framework.BasicVector_TExpressionU: ...
    def get_source_value(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.systems.framework.BasicVector_TExpressionU: ...

class _TemporaryName_N5drake7systems20MultilayerPerceptronIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, layers: list[int], activation_type: PerceptronActivationType = ...) -> None: ...
    @overload
    def __init__(self, layers: list[int], activation_types: list[PerceptronActivationType]) -> None: ...
    @overload
    def __init__(self, use_sin_cos_for_input: list[bool], remaining_layers: list[int], activation_types: list[PerceptronActivationType]) -> None: ...
    def Backpropagation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, X: numpy.ndarray[object[m, n], flags.f_contiguous], loss: Callable[[numpy.ndarray[object[m, n], flags.f_contiguous], numpy.ndarray[object[m, n], flags.writeable, flags.f_contiguous] | None], pydrake.autodiffutils.AutoDiffXd], dloss_dparams: numpy.ndarray[object[m, 1], flags.writeable] | None) -> pydrake.autodiffutils.AutoDiffXd: ...
    def BackpropagationMeanSquaredError(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, X: numpy.ndarray[object[m, n], flags.f_contiguous], Y_desired: numpy.ndarray[object[m, n], flags.f_contiguous], dloss_dparams: numpy.ndarray[object[m, 1], flags.writeable] | None) -> pydrake.autodiffutils.AutoDiffXd: ...
    @overload
    def BatchOutput(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, X: numpy.ndarray[object[m, n], flags.f_contiguous], Y: numpy.ndarray[object[m, n], flags.writeable, flags.f_contiguous] | None, dYdX: numpy.ndarray[object[m, n], flags.writeable, flags.f_contiguous] | None = ...) -> None: ...
    @overload
    def BatchOutput(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, X: numpy.ndarray[object[m, n], flags.f_contiguous]) -> numpy.ndarray[object[m, n]]: ...
    @overload
    def BatchOutput(self, context, X, Y) -> Any: ...
    @overload
    def GetBiases(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, layer: int) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetBiases(self, params: numpy.ndarray[object[m, 1]], layer: int) -> numpy.ndarray[object[m, 1]]: ...
    def GetMutableParameters(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1], flags.writeable]: ...
    def GetParameters(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetWeights(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, layer: int) -> numpy.ndarray[object[m, n], flags.f_contiguous]: ...
    @overload
    def GetWeights(self, params: numpy.ndarray[object[m, 1]], layer: int) -> numpy.ndarray[object[m, n], flags.f_contiguous]: ...
    @overload
    def SetBiases(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, layer: int, b: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetBiases(self, params: numpy.ndarray[object[m, 1], flags.writeable] | None, layer: int, b: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetParameters(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, params: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetWeights(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, layer: int, W: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    @overload
    def SetWeights(self, params: numpy.ndarray[object[m, 1], flags.writeable] | None, layer: int, W: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    def activation_type(self, layer: int) -> PerceptronActivationType: ...
    def layers(self) -> list[int]: ...
    def num_parameters(self) -> int: ...

class _TemporaryName_N5drake7systems20MultilayerPerceptronINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, layers: list[int], activation_type: PerceptronActivationType = ...) -> None: ...
    @overload
    def __init__(self, layers: list[int], activation_types: list[PerceptronActivationType]) -> None: ...
    @overload
    def __init__(self, use_sin_cos_for_input: list[bool], remaining_layers: list[int], activation_types: list[PerceptronActivationType]) -> None: ...
    def Backpropagation(self, context: pydrake.systems.framework.Context_TExpressionU, X: numpy.ndarray[object[m, n], flags.f_contiguous], loss: Callable[[numpy.ndarray[object[m, n], flags.f_contiguous], numpy.ndarray[object[m, n], flags.writeable, flags.f_contiguous] | None], pydrake.symbolic.Expression], dloss_dparams: numpy.ndarray[object[m, 1], flags.writeable] | None) -> pydrake.symbolic.Expression: ...
    def BackpropagationMeanSquaredError(self, context: pydrake.systems.framework.Context_TExpressionU, X: numpy.ndarray[object[m, n], flags.f_contiguous], Y_desired: numpy.ndarray[object[m, n], flags.f_contiguous], dloss_dparams: numpy.ndarray[object[m, 1], flags.writeable] | None) -> pydrake.symbolic.Expression: ...
    @overload
    def BatchOutput(self, context: pydrake.systems.framework.Context_TExpressionU, X: numpy.ndarray[object[m, n], flags.f_contiguous], Y: numpy.ndarray[object[m, n], flags.writeable, flags.f_contiguous] | None, dYdX: numpy.ndarray[object[m, n], flags.writeable, flags.f_contiguous] | None = ...) -> None: ...
    @overload
    def BatchOutput(self, context: pydrake.systems.framework.Context_TExpressionU, X: numpy.ndarray[object[m, n], flags.f_contiguous]) -> numpy.ndarray[object[m, n]]: ...
    @overload
    def BatchOutput(self, context, X, Y) -> Any: ...
    @overload
    def GetBiases(self, context: pydrake.systems.framework.Context_TExpressionU, layer: int) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetBiases(self, params: numpy.ndarray[object[m, 1]], layer: int) -> numpy.ndarray[object[m, 1]]: ...
    def GetMutableParameters(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1], flags.writeable]: ...
    def GetParameters(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetWeights(self, context: pydrake.systems.framework.Context_TExpressionU, layer: int) -> numpy.ndarray[object[m, n], flags.f_contiguous]: ...
    @overload
    def GetWeights(self, params: numpy.ndarray[object[m, 1]], layer: int) -> numpy.ndarray[object[m, n], flags.f_contiguous]: ...
    @overload
    def SetBiases(self, context: pydrake.systems.framework.Context_TExpressionU, layer: int, b: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetBiases(self, params: numpy.ndarray[object[m, 1], flags.writeable] | None, layer: int, b: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetParameters(self, context: pydrake.systems.framework.Context_TExpressionU, params: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetWeights(self, context: pydrake.systems.framework.Context_TExpressionU, layer: int, W: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    @overload
    def SetWeights(self, params: numpy.ndarray[object[m, 1], flags.writeable] | None, layer: int, W: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    def activation_type(self, layer: int) -> PerceptronActivationType: ...
    def layers(self) -> list[int]: ...
    def num_parameters(self) -> int: ...

class _TemporaryName_N5drake7systems20SymbolicVectorSystemIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, time: pydrake.symbolic.Variable | None = ..., state: numpy.ndarray[object[m, 1]] = ..., input: numpy.ndarray[object[m, 1]] = ..., dynamics: numpy.ndarray[object[m, 1]] = ..., output: numpy.ndarray[object[m, 1]] = ..., time_period: float = ...) -> None: ...
    @overload
    def __init__(self, time: pydrake.symbolic.Variable | None = ..., state: numpy.ndarray[object[m, 1]] = ..., input: numpy.ndarray[object[m, 1]] = ..., parameter: numpy.ndarray[object[m, 1]] = ..., dynamics: numpy.ndarray[object[m, 1]] = ..., output: numpy.ndarray[object[m, 1]] = ..., time_period: float = ...) -> None: ...
    def dynamics_for_variable(self, var: pydrake.symbolic.Variable) -> pydrake.symbolic.Expression: ...

class _TemporaryName_N5drake7systems20SymbolicVectorSystemINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, time: pydrake.symbolic.Variable | None = ..., state: numpy.ndarray[object[m, 1]] = ..., input: numpy.ndarray[object[m, 1]] = ..., dynamics: numpy.ndarray[object[m, 1]] = ..., output: numpy.ndarray[object[m, 1]] = ..., time_period: float = ...) -> None: ...
    @overload
    def __init__(self, time: pydrake.symbolic.Variable | None = ..., state: numpy.ndarray[object[m, 1]] = ..., input: numpy.ndarray[object[m, 1]] = ..., parameter: numpy.ndarray[object[m, 1]] = ..., dynamics: numpy.ndarray[object[m, 1]] = ..., output: numpy.ndarray[object[m, 1]] = ..., time_period: float = ...) -> None: ...
    def dynamics_for_variable(self, var: pydrake.symbolic.Variable) -> pydrake.symbolic.Expression: ...

class _TemporaryName_N5drake7systems22DiscreteTimeIntegratorIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, size: int, time_step: float) -> None: ...
    def set_integral_value(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def time_step(self) -> float: ...

class _TemporaryName_N5drake7systems22DiscreteTimeIntegratorINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, size: int, time_step: float) -> None: ...
    def set_integral_value(self, context: pydrake.systems.framework.Context_TExpressionU, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def time_step(self) -> float: ...

class _TemporaryName_N5drake7systems22LinearTransformDensityIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, distribution: pydrake.common.RandomDistribution, input_size: int, output_size: int) -> None: ...
    def CalcDensity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def FixConstantA(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, A: numpy.ndarray[object[m, n], flags.f_contiguous]) -> pydrake.systems.framework.FixedInputPortValue: ...
    def FixConstantB(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, b: numpy.ndarray[object[m, 1]]) -> pydrake.systems.framework.FixedInputPortValue: ...
    def get_distribution(self) -> pydrake.common.RandomDistribution: ...
    def get_input_port_A(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_input_port_b(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_input_port_w_in(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_output_port_w_out(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_output_port_w_out_density(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...

class _TemporaryName_N5drake7systems22TrajectoryAffineSystemIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, A: pydrake.trajectories.Trajectory, B: pydrake.trajectories.Trajectory, f0: pydrake.trajectories.Trajectory, C: pydrake.trajectories.Trajectory, D: pydrake.trajectories.Trajectory, y0: pydrake.trajectories.Trajectory, time_period: float = ...) -> None: ...
    def A(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, n]]: ...
    def B(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, n]]: ...
    def C(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, n]]: ...
    def D(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, n]]: ...
    def configure_default_state(self, x0: numpy.ndarray[object[m, 1]]) -> None: ...
    def configure_random_state(self, covariance: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...
    def f0(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, 1]]: ...
    def time_period(self) -> float: ...
    def y0(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, 1]]: ...

class _TemporaryName_N5drake7systems22TrajectoryLinearSystemIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, A: pydrake.trajectories.Trajectory, B: pydrake.trajectories.Trajectory, C: pydrake.trajectories.Trajectory, D: pydrake.trajectories.Trajectory, time_period: float = ...) -> None: ...
    def A(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, n]]: ...
    def B(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, n]]: ...
    def C(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, n]]: ...
    def D(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, n]]: ...
    def configure_default_state(self, x0: numpy.ndarray[object[m, 1]]) -> None: ...
    def configure_random_state(self, covariance: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...
    def time_period(self) -> float: ...

class _TemporaryName_N5drake7systems23FirstOrderLowPassFilterIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, time_constant: float, size: int = ...) -> None: ...
    @overload
    def __init__(self, time_constants: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def get_time_constant(self) -> float: ...
    def get_time_constants_vector(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def set_initial_output_value(self, arg0: pydrake.systems.framework.Context_TAutoDiffXdU, arg1: numpy.ndarray[object[m, 1]]) -> None: ...

class _TemporaryName_N5drake7systems23FirstOrderLowPassFilterINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, time_constant: float, size: int = ...) -> None: ...
    @overload
    def __init__(self, time_constants: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def get_time_constant(self) -> float: ...
    def get_time_constants_vector(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def set_initial_output_value(self, arg0: pydrake.systems.framework.Context_TExpressionU, arg1: numpy.ndarray[object[m, 1]]) -> None: ...

class _TemporaryName_N5drake7systems39StateInterpolatorWithDiscreteDerivativeIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.Diagram_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, num_positions: int, time_step: float, suppress_initial_transient: bool = ...) -> None: ...
    @overload
    def set_initial_position(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, position: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def set_initial_position(self, state: pydrake.systems.framework.State_TAutoDiffXdU, position: numpy.ndarray[object[m, 1]]) -> None: ...
    def suppress_initial_transient(self) -> bool: ...

class _TemporaryName_N5drake7systems39StateInterpolatorWithDiscreteDerivativeINS_8symbolic10ExpressionEEE(pydrake.systems.framework.Diagram_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, num_positions: int, time_step: float, suppress_initial_transient: bool = ...) -> None: ...
    @overload
    def set_initial_position(self, context: pydrake.systems.framework.Context_TExpressionU, position: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def set_initial_position(self, state: pydrake.systems.framework.State_TExpressionU, position: numpy.ndarray[object[m, 1]]) -> None: ...
    def suppress_initial_transient(self) -> bool: ...

class _TemporaryName_N5drake7systems4GainIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, k: float, size: int) -> None: ...
    @overload
    def __init__(self, k: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class _TemporaryName_N5drake7systems4GainINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, k: float, size: int) -> None: ...
    @overload
    def __init__(self, k: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class _TemporaryName_N5drake7systems4SineIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, amplitude: float, frequency: float, phase: float, size: int, is_time_based: bool = ...) -> None: ...
    @overload
    def __init__(self, amplitudes: numpy.ndarray[numpy.float64[m, 1]], frequencies: numpy.ndarray[numpy.float64[m, 1]], phases: numpy.ndarray[numpy.float64[m, 1]], is_time_based: bool = ...) -> None: ...

class _TemporaryName_N5drake7systems4SineINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, amplitude: float, frequency: float, phase: float, size: int, is_time_based: bool = ...) -> None: ...
    @overload
    def __init__(self, amplitudes: numpy.ndarray[numpy.float64[m, 1]], frequencies: numpy.ndarray[numpy.float64[m, 1]], phases: numpy.ndarray[numpy.float64[m, 1]], is_time_based: bool = ...) -> None: ...

class _TemporaryName_N5drake7systems5AdderIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, num_inputs: int, size: int) -> None: ...

class _TemporaryName_N5drake7systems5AdderINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, num_inputs: int, size: int) -> None: ...

class _TemporaryName_N5drake7systems8SelectorIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, params: SelectorParams) -> None: ...

class _TemporaryName_N5drake7systems8SelectorINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, params: SelectorParams) -> None: ...

class _TemporaryName_N5drake7systems9VectorLogIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    kDefaultCapacity: ClassVar[int] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, input_size: int) -> None: ...
    def AddData(self, time: pydrake.autodiffutils.AutoDiffXd, sample: numpy.ndarray[object[m, 1]]) -> None: ...
    def Clear(self) -> None: ...
    def Reserve(self, arg0: int) -> None: ...
    def data(self) -> numpy.ndarray[object[m, n]]: ...
    def get_input_size(self) -> int: ...
    def num_samples(self) -> int: ...
    def sample_times(self) -> numpy.ndarray[object[m, 1]]: ...

class _TemporaryName_N5drake7systems9VectorLogINS_8symbolic10ExpressionEEE:
    kDefaultCapacity: ClassVar[int] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, input_size: int) -> None: ...
    def AddData(self, time: pydrake.symbolic.Expression, sample: numpy.ndarray[object[m, 1]]) -> None: ...
    def Clear(self) -> None: ...
    def Reserve(self, arg0: int) -> None: ...
    def data(self) -> numpy.ndarray[object[m, n]]: ...
    def get_input_size(self) -> int: ...
    def num_samples(self) -> int: ...
    def sample_times(self) -> numpy.ndarray[object[m, 1]]: ...

@overload
def AddRandomInputs(sampling_interval_sec: float, builder: pydrake.systems.framework.DiagramBuilder) -> int: ...
@overload
def AddRandomInputs(sampling_interval_sec: float, builder: pydrake.systems.framework.DiagramBuilder_TAutoDiffXdU) -> int: ...
def ControllabilityMatrix(arg0: LinearSystem) -> numpy.ndarray[numpy.float64[m, n]]: ...
def FirstOrderTaylorApproximation(system: pydrake.systems.framework.System, context: pydrake.systems.framework.Context, input_port_index: pydrake.systems.framework.InputPortSelection | pydrake.systems.framework.InputPortIndex = ..., output_port_index: pydrake.systems.framework.OutputPortSelection | pydrake.systems.framework.OutputPortIndex = ...) -> AffineSystem: ...
def IsControllable(sys: LinearSystem, threshold: float | None = ...) -> bool: ...
def IsDetectable(sys: LinearSystem, threshold: float | None = ...) -> bool: ...
def IsObservable(sys: LinearSystem, threshold: float | None = ...) -> bool: ...
def IsStabilizable(sys: LinearSystem, threshold: float | None = ...) -> bool: ...
def Linearize(system: pydrake.systems.framework.System, context: pydrake.systems.framework.Context, input_port_index: pydrake.systems.framework.InputPortSelection | pydrake.systems.framework.InputPortIndex = ..., output_port_index: pydrake.systems.framework.OutputPortSelection | pydrake.systems.framework.OutputPortIndex = ..., equilibrium_check_tolerance: float = ...) -> LinearSystem: ...
def LogVectorOutput(src: pydrake.systems.framework.OutputPort, builder: pydrake.systems.framework.DiagramBuilder, publish_period: float = ...) -> VectorLogSink: ...
def ObservabilityMatrix(arg0: LinearSystem) -> numpy.ndarray[numpy.float64[m, n]]: ...
