import pydrake.common.value
import pydrake.lcm
import pydrake.systems.framework
from typing import Callable, ClassVar, overload

class LcmBuses:
    kLcmUrlMemqNull: ClassVar[str] = ...  # read-only
    def __init__(self) -> None: ...
    def Add(self, bus_name: str, bus: pydrake.lcm.DrakeLcmInterface) -> None: ...
    def Find(self, description_of_caller: str, bus_name: str) -> pydrake.lcm.DrakeLcmInterface: ...
    def GetAllBusNames(self) -> list[str]: ...
    def size(self) -> int: ...

class LcmInterfaceSystem(pydrake.systems.framework.LeafSystem):
    def __init__(self, lcm: pydrake.lcm.DrakeLcmInterface) -> None: ...
    def HandleSubscriptions(self, timeout_millis: int) -> int: ...
    def get_lcm_url(self) -> str: ...

class LcmPublisherSystem(pydrake.systems.framework.LeafSystem):
    Make: ClassVar[Callable] = ...
    @overload
    def __init__(self, channel: str, serializer: SerializerInterface, lcm: LcmInterfaceSystem, publish_period: float = ..., publish_offset: float = ...) -> None: ...
    @overload
    def __init__(self, channel: str, serializer: SerializerInterface, lcm: pydrake.lcm.DrakeLcmInterface, publish_period: float = ..., publish_offset: float = ...) -> None: ...
    @overload
    def __init__(self, channel: str, serializer: SerializerInterface, lcm: LcmInterfaceSystem, publish_triggers: set[pydrake.systems.framework.TriggerType], publish_period: float = ..., publish_offset: float = ...) -> None: ...
    @overload
    def __init__(self, channel: str, serializer: SerializerInterface, lcm: pydrake.lcm.DrakeLcmInterface, publish_triggers: set[pydrake.systems.framework.TriggerType], publish_period: float = ..., publish_offset: float = ...) -> None: ...

class LcmScopeSystem(pydrake.systems.framework.LeafSystem):
    def __init__(self, size: int) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder, lcm: pydrake.lcm.DrakeLcmInterface, signal: pydrake.systems.framework.OutputPort, channel: str, publish_period: float) -> list: ...

class LcmSubscriberSystem(pydrake.systems.framework.LeafSystem):
    Make: ClassVar[Callable] = ...
    @overload
    def __init__(self, channel: str, serializer: SerializerInterface, lcm: LcmInterfaceSystem, wait_for_message_on_initialization_timeout: float = ...) -> None: ...
    @overload
    def __init__(self, channel: str, serializer: SerializerInterface, lcm: pydrake.lcm.DrakeLcmInterface, wait_for_message_on_initialization_timeout: float = ...) -> None: ...
    def WaitForMessage(self, old_message_count: int, message: pydrake.common.value.AbstractValue = ..., timeout: float = ...) -> int: ...

class PySerializer(SerializerInterface):
    __init__: ClassVar[Callable] = ...
    CreateDefaultValue: ClassVar[Callable] = ...
    Deserialize: ClassVar[Callable] = ...
    Serialize: ClassVar[Callable] = ...

class SerializerInterface:
    def __init__(self) -> None: ...
    def CreateDefaultValue(self) -> pydrake.common.value.AbstractValue: ...
    def Deserialize(self, message_bytes: bytes, abstract_value: pydrake.common.value.AbstractValue) -> None: ...
    def Serialize(self, abstract_value: pydrake.common.value.AbstractValue) -> bytes: ...

class _Serializer(SerializerInterface):
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_acrobot_x𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_acrobot_y𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_allegro_command𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_allegro_status𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_call_python_data𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_call_python𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_contact_results_for_viz𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_drake_signal𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_force_torque𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_header𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_hydroelastic_contact_surface_for_viz𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_hydroelastic_quadrature_per_point_data_for_viz𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_iiwa_command𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_iiwa_status_telemetry𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_iiwa_status𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_image_array𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_image𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_jaco_command𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_jaco_status𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_panda_command𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_panda_status𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_planar_gripper_command𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_planar_gripper_finger_command𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_planar_gripper_finger_face_assignments𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_planar_gripper_finger_face_assignment𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_planar_gripper_finger_status𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_planar_gripper_status𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_planar_manipuland_status𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_planar_plant_state𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_point_cloud_field𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_point_cloud𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_point_pair_contact_info_for_viz𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_point𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_quaternion𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_robot_plan𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_robot_state𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_schunk_wsg_command𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_schunk_wsg_status𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_scope𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_viewer_command𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_viewer_draw𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_viewer_geometry_data𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_viewer_link_data𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _Serializer_𝓣lcmt_viewer_load_robot𝓤(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_10lcmt_imageEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_10lcmt_pointEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_10lcmt_scopeEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_11lcmt_headerEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_14lcmt_acrobot_xEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_14lcmt_acrobot_yEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_15lcmt_quaternionEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_15lcmt_robot_planEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_16lcmt_call_pythonEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_16lcmt_iiwa_statusEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_16lcmt_image_arrayEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_16lcmt_jaco_statusEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_16lcmt_point_cloudEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_16lcmt_robot_stateEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_16lcmt_viewer_drawEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_17lcmt_drake_signalEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_17lcmt_force_torqueEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_17lcmt_iiwa_commandEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_17lcmt_jaco_commandEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_17lcmt_panda_statusEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_18lcmt_panda_commandEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_19lcmt_allegro_statusEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_19lcmt_viewer_commandEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_20lcmt_allegro_commandEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_21lcmt_call_python_dataEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_21lcmt_viewer_link_dataEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_22lcmt_point_cloud_fieldEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_22lcmt_schunk_wsg_statusEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_22lcmt_viewer_load_robotEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_23lcmt_planar_plant_stateEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_23lcmt_schunk_wsg_commandEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_25lcmt_viewer_geometry_dataEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_26lcmt_iiwa_status_telemetryEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_26lcmt_planar_gripper_statusEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_27lcmt_planar_gripper_commandEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_28lcmt_contact_results_for_vizEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_29lcmt_planar_manipuland_statusEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_33lcmt_planar_gripper_finger_statusEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_34lcmt_planar_gripper_finger_commandEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_36lcmt_point_pair_contact_info_for_vizEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_41lcmt_hydroelastic_contact_surface_for_vizEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_42lcmt_planar_gripper_finger_face_assignmentEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_43lcmt_planar_gripper_finger_face_assignmentsEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems3lcm10SerializerINS_51lcmt_hydroelastic_quadrature_per_point_data_for_vizEEE(SerializerInterface):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...

def ApplyLcmBusConfig(lcm_buses: dict[str, pydrake.lcm.DrakeLcmParams | None], builder: pydrake.systems.framework.DiagramBuilder) -> LcmBuses: ...
