import flags
import numpy
import pydrake.autodiffutils
import pydrake.common
import pydrake.common.value
import pydrake.symbolic
import typing
from _typeshed import Incomplete
from pydrake.common.cpp_template import BasicVector_ as BasicVector_, Context_ as Context_, ContinuousState_ as ContinuousState_, DiagramBuilder_ as DiagramBuilder_, Diagram_ as Diagram_, DiscreteUpdateEvent_ as DiscreteUpdateEvent_, DiscreteValues_ as DiscreteValues_, Event_ as Event_, InputPort_ as InputPort_, LeafContext_ as LeafContext_, LeafOutputPort_ as LeafOutputPort_, LeafSystem_ as LeafSystem_, OutputPort_ as OutputPort_, Parameters_ as Parameters_, PublishEvent_ as PublishEvent_, State_ as State_, Subvector_ as Subvector_, Supervector_ as Supervector_, SystemOutput_ as SystemOutput_, SystemVisitor_ as SystemVisitor_, System_ as System_, UnrestrictedUpdateEvent_ as UnrestrictedUpdateEvent_, VectorBase_ as VectorBase_, VectorSystem_ as VectorSystem_, WitnessFunction_ as WitnessFunction_
from typing import Any, Callable, ClassVar, Iterator, overload

kUseDefaultName: UseDefaultName

class AbstractParameterIndex:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def is_valid(self) -> bool: ...
    @overload
    def __eq__(self, arg0: AbstractParameterIndex) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __lt__(self, arg0: AbstractParameterIndex) -> bool: ...

class AbstractStateIndex:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def is_valid(self) -> bool: ...
    @overload
    def __eq__(self, arg0: AbstractStateIndex) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __lt__(self, arg0: AbstractStateIndex) -> bool: ...

class AbstractValues:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: list[pydrake.common.value.AbstractValue]) -> None: ...
    def Clone(self) -> AbstractValues: ...
    def SetFrom(self, arg0: AbstractValues) -> None: ...
    def get_mutable_value(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_value(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def size(self) -> int: ...
    def __copy__(self) -> AbstractValues: ...
    def __deepcopy__(self, arg0: dict) -> AbstractValues: ...

class BasicVector(VectorBase):
    @overload
    def __init__(self, data: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def __init__(self, size: int) -> None: ...
    def Clone(self) -> BasicVector: ...
    def get_mutable_value(self) -> numpy.ndarray[numpy.float64[m, 1], flags.writeable]: ...
    def get_value(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def set_value(self, arg0: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def value(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def __copy__(self) -> BasicVector: ...
    def __deepcopy__(self, arg0: dict) -> BasicVector: ...

class BasicVector_𝓣AutoDiffXd𝓤(VectorBase_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, data: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def __init__(self, size: int) -> None: ...
    def Clone(self) -> BasicVector_TAutoDiffXdU: ...
    def get_mutable_value(self) -> numpy.ndarray[object[m, 1], flags.writeable]: ...
    def get_value(self) -> numpy.ndarray[object[m, 1]]: ...
    def set_value(self, arg0: numpy.ndarray[object[m, 1]]) -> None: ...
    def value(self) -> numpy.ndarray[object[m, 1]]: ...
    def __copy__(self) -> BasicVector_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> BasicVector_TAutoDiffXdU: ...

class BasicVector_𝓣Expression𝓤(VectorBase_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, data: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def __init__(self, size: int) -> None: ...
    def Clone(self) -> BasicVector_TExpressionU: ...
    def get_mutable_value(self) -> numpy.ndarray[object[m, 1], flags.writeable]: ...
    def get_value(self) -> numpy.ndarray[object[m, 1]]: ...
    def set_value(self, arg0: numpy.ndarray[object[m, 1]]) -> None: ...
    def value(self) -> numpy.ndarray[object[m, 1]]: ...
    def __copy__(self) -> BasicVector_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> BasicVector_TExpressionU: ...

class BusValue:
    def __init__(self) -> None: ...
    def Clear(self) -> None: ...
    def Find(self, name: str) -> object: ...
    def Set(self, name: str, value: pydrake.common.value.AbstractValue) -> None: ...
    def __copy__(self) -> BusValue: ...
    def __deepcopy__(self, arg0: dict) -> BusValue: ...
    def __getitem__(self, key: str) -> object: ...
    def __iter__(self) -> Iterator[str]: ...

class CacheEntry:
    def __init__(self, *args, **kwargs) -> None: ...
    def Eval(self, context: ContextBase) -> object: ...
    def EvalAbstract(self, context: ContextBase) -> pydrake.common.value.AbstractValue: ...
    def cache_index(self) -> CacheIndex: ...
    def description(self) -> str: ...
    def disable_caching(self, context: ContextBase) -> None: ...
    def disable_caching_by_default(self) -> None: ...
    def enable_caching(self, context: ContextBase) -> None: ...
    def get_cache_entry_value(self, context: ContextBase) -> CacheEntryValue: ...
    def get_mutable_cache_entry_value(self, context: ContextBase) -> CacheEntryValue: ...
    def has_default_prerequisites(self) -> bool: ...
    def is_cache_entry_disabled(self, context: ContextBase) -> bool: ...
    def is_disabled_by_default(self) -> bool: ...
    def is_out_of_date(self, context: ContextBase) -> bool: ...
    def prerequisites(self) -> set[DependencyTicket]: ...
    def ticket(self) -> DependencyTicket: ...

class CacheEntryValue:
    def __init__(self, *args, **kwargs) -> None: ...
    def GetMutableValueOrThrow(self) -> object: ...
    def GetValueOrThrow(self) -> object: ...

class CacheIndex:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def is_valid(self) -> bool: ...
    @overload
    def __eq__(self, arg0: CacheIndex) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __lt__(self, arg0: CacheIndex) -> bool: ...

class Context(ContextBase):
    def __init__(self, *args, **kwargs) -> None: ...
    def Clone(self) -> Context: ...
    def SetAbstractState(self, index: int, value: object) -> None: ...
    def SetAccuracy(self, accuracy: float | None) -> None: ...
    def SetContinuousState(self, arg0: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def SetDiscreteState(self, xd: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def SetDiscreteState(self, group_index: int, xd: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def SetDiscreteState(self, xd: DiscreteValues) -> None: ...
    @overload
    def SetStateAndParametersFrom(self, source: Context) -> None: ...
    @overload
    def SetStateAndParametersFrom(self, source: Context_TAutoDiffXdU) -> None: ...
    @overload
    def SetStateAndParametersFrom(self, source: Context_TExpressionU) -> None: ...
    def SetTime(self, time_sec: float) -> None: ...
    def SetTimeAndContinuousState(self, arg0: float, arg1: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def SetTimeStateAndParametersFrom(self, source: Context) -> None: ...
    @overload
    def SetTimeStateAndParametersFrom(self, source: Context_TAutoDiffXdU) -> None: ...
    @overload
    def SetTimeStateAndParametersFrom(self, source: Context_TExpressionU) -> None: ...
    def get_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    @overload
    def get_abstract_state(self) -> AbstractValues: ...
    @overload
    def get_abstract_state(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_accuracy(self) -> float | None: ...
    def get_continuous_state(self) -> ContinuousState: ...
    def get_continuous_state_vector(self) -> VectorBase: ...
    @overload
    def get_discrete_state(self) -> DiscreteValues: ...
    @overload
    def get_discrete_state(self, arg0: int) -> BasicVector: ...
    def get_discrete_state_vector(self) -> BasicVector: ...
    def get_mutable_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    @overload
    def get_mutable_abstract_state(self) -> AbstractValues: ...
    @overload
    def get_mutable_abstract_state(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_mutable_continuous_state(self) -> ContinuousState: ...
    def get_mutable_continuous_state_vector(self) -> VectorBase: ...
    @overload
    def get_mutable_discrete_state(self) -> DiscreteValues: ...
    @overload
    def get_mutable_discrete_state(self, arg0: int) -> BasicVector: ...
    def get_mutable_discrete_state_vector(self) -> BasicVector: ...
    def get_mutable_numeric_parameter(self, index: int) -> BasicVector: ...
    def get_mutable_parameters(self) -> Parameters: ...
    def get_mutable_state(self) -> State: ...
    def get_numeric_parameter(self, index: int) -> BasicVector: ...
    def get_parameters(self) -> Parameters: ...
    def get_state(self) -> State: ...
    def get_time(self) -> float: ...
    def has_only_continuous_state(self) -> bool: ...
    def has_only_discrete_state(self) -> bool: ...
    def is_stateless(self) -> bool: ...
    def num_abstract_parameters(self) -> int: ...
    def num_abstract_states(self) -> int: ...
    def num_continuous_states(self) -> int: ...
    def num_discrete_state_groups(self) -> int: ...
    def num_numeric_parameter_groups(self) -> int: ...
    def num_total_states(self) -> int: ...
    def __copy__(self) -> Context: ...
    def __deepcopy__(self, arg0: dict) -> Context: ...

class ContextBase:
    def __init__(self, *args, **kwargs) -> None: ...
    def DisableCaching(self) -> None: ...
    def EnableCaching(self) -> None: ...
    def FreezeCache(self) -> None: ...
    def SetAllCacheEntriesOutOfDate(self) -> None: ...
    def UnfreezeCache(self) -> None: ...
    def is_cache_frozen(self) -> bool: ...
    def num_input_ports(self) -> int: ...
    def num_output_ports(self) -> int: ...

class Context_𝓣AutoDiffXd𝓤(ContextBase):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Clone(self) -> Context_TAutoDiffXdU: ...
    def SetAbstractState(self, index: int, value: object) -> None: ...
    def SetAccuracy(self, accuracy: float | None) -> None: ...
    def SetContinuousState(self, arg0: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetDiscreteState(self, xd: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetDiscreteState(self, group_index: int, xd: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetDiscreteState(self, xd: DiscreteValues_TAutoDiffXdU) -> None: ...
    @overload
    def SetStateAndParametersFrom(self, source: Context) -> None: ...
    @overload
    def SetStateAndParametersFrom(self, source: Context_TAutoDiffXdU) -> None: ...
    @overload
    def SetStateAndParametersFrom(self, source: Context_TExpressionU) -> None: ...
    def SetTime(self, time_sec: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def SetTimeAndContinuousState(self, arg0: pydrake.autodiffutils.AutoDiffXd, arg1: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetTimeStateAndParametersFrom(self, source: Context) -> None: ...
    @overload
    def SetTimeStateAndParametersFrom(self, source: Context_TAutoDiffXdU) -> None: ...
    @overload
    def SetTimeStateAndParametersFrom(self, source: Context_TExpressionU) -> None: ...
    def get_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    @overload
    def get_abstract_state(self) -> AbstractValues: ...
    @overload
    def get_abstract_state(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_accuracy(self) -> float | None: ...
    def get_continuous_state(self) -> ContinuousState_TAutoDiffXdU: ...
    def get_continuous_state_vector(self) -> VectorBase_TAutoDiffXdU: ...
    @overload
    def get_discrete_state(self) -> DiscreteValues_TAutoDiffXdU: ...
    @overload
    def get_discrete_state(self, arg0: int) -> BasicVector_TAutoDiffXdU: ...
    def get_discrete_state_vector(self) -> BasicVector_TAutoDiffXdU: ...
    def get_mutable_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    @overload
    def get_mutable_abstract_state(self) -> AbstractValues: ...
    @overload
    def get_mutable_abstract_state(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_mutable_continuous_state(self) -> ContinuousState_TAutoDiffXdU: ...
    def get_mutable_continuous_state_vector(self) -> VectorBase_TAutoDiffXdU: ...
    @overload
    def get_mutable_discrete_state(self) -> DiscreteValues_TAutoDiffXdU: ...
    @overload
    def get_mutable_discrete_state(self, arg0: int) -> BasicVector_TAutoDiffXdU: ...
    def get_mutable_discrete_state_vector(self) -> BasicVector_TAutoDiffXdU: ...
    def get_mutable_numeric_parameter(self, index: int) -> BasicVector_TAutoDiffXdU: ...
    def get_mutable_parameters(self) -> Parameters_TAutoDiffXdU: ...
    def get_mutable_state(self) -> State_TAutoDiffXdU: ...
    def get_numeric_parameter(self, index: int) -> BasicVector_TAutoDiffXdU: ...
    def get_parameters(self) -> Parameters_TAutoDiffXdU: ...
    def get_state(self) -> State_TAutoDiffXdU: ...
    def get_time(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def has_only_continuous_state(self) -> bool: ...
    def has_only_discrete_state(self) -> bool: ...
    def is_stateless(self) -> bool: ...
    def num_abstract_parameters(self) -> int: ...
    def num_abstract_states(self) -> int: ...
    def num_continuous_states(self) -> int: ...
    def num_discrete_state_groups(self) -> int: ...
    def num_numeric_parameter_groups(self) -> int: ...
    def num_total_states(self) -> int: ...
    def __copy__(self) -> Context_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> Context_TAutoDiffXdU: ...

class Context_𝓣Expression𝓤(ContextBase):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Clone(self) -> Context_TExpressionU: ...
    def SetAbstractState(self, index: int, value: object) -> None: ...
    def SetAccuracy(self, accuracy: float | None) -> None: ...
    def SetContinuousState(self, arg0: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetDiscreteState(self, xd: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetDiscreteState(self, group_index: int, xd: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetDiscreteState(self, xd: DiscreteValues_TExpressionU) -> None: ...
    @overload
    def SetStateAndParametersFrom(self, source: Context) -> None: ...
    @overload
    def SetStateAndParametersFrom(self, source: Context_TAutoDiffXdU) -> None: ...
    @overload
    def SetStateAndParametersFrom(self, source: Context_TExpressionU) -> None: ...
    def SetTime(self, time_sec: pydrake.symbolic.Expression) -> None: ...
    def SetTimeAndContinuousState(self, arg0: pydrake.symbolic.Expression, arg1: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetTimeStateAndParametersFrom(self, source: Context) -> None: ...
    @overload
    def SetTimeStateAndParametersFrom(self, source: Context_TAutoDiffXdU) -> None: ...
    @overload
    def SetTimeStateAndParametersFrom(self, source: Context_TExpressionU) -> None: ...
    def get_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    @overload
    def get_abstract_state(self) -> AbstractValues: ...
    @overload
    def get_abstract_state(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_accuracy(self) -> float | None: ...
    def get_continuous_state(self) -> ContinuousState_TExpressionU: ...
    def get_continuous_state_vector(self) -> VectorBase_TExpressionU: ...
    @overload
    def get_discrete_state(self) -> DiscreteValues_TExpressionU: ...
    @overload
    def get_discrete_state(self, arg0: int) -> BasicVector_TExpressionU: ...
    def get_discrete_state_vector(self) -> BasicVector_TExpressionU: ...
    def get_mutable_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    @overload
    def get_mutable_abstract_state(self) -> AbstractValues: ...
    @overload
    def get_mutable_abstract_state(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_mutable_continuous_state(self) -> ContinuousState_TExpressionU: ...
    def get_mutable_continuous_state_vector(self) -> VectorBase_TExpressionU: ...
    @overload
    def get_mutable_discrete_state(self) -> DiscreteValues_TExpressionU: ...
    @overload
    def get_mutable_discrete_state(self, arg0: int) -> BasicVector_TExpressionU: ...
    def get_mutable_discrete_state_vector(self) -> BasicVector_TExpressionU: ...
    def get_mutable_numeric_parameter(self, index: int) -> BasicVector_TExpressionU: ...
    def get_mutable_parameters(self) -> Parameters_TExpressionU: ...
    def get_mutable_state(self) -> State_TExpressionU: ...
    def get_numeric_parameter(self, index: int) -> BasicVector_TExpressionU: ...
    def get_parameters(self) -> Parameters_TExpressionU: ...
    def get_state(self) -> State_TExpressionU: ...
    def get_time(self) -> pydrake.symbolic.Expression: ...
    def has_only_continuous_state(self) -> bool: ...
    def has_only_discrete_state(self) -> bool: ...
    def is_stateless(self) -> bool: ...
    def num_abstract_parameters(self) -> int: ...
    def num_abstract_states(self) -> int: ...
    def num_continuous_states(self) -> int: ...
    def num_discrete_state_groups(self) -> int: ...
    def num_numeric_parameter_groups(self) -> int: ...
    def num_total_states(self) -> int: ...
    def __copy__(self) -> Context_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> Context_TExpressionU: ...

class ContinuousState:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, state: BasicVector) -> None: ...
    @overload
    def __init__(self, state: BasicVector, num_q: int, num_v: int, num_z: int) -> None: ...
    @overload
    def __init__(self, state: VectorBase) -> None: ...
    @overload
    def __init__(self, state: VectorBase, num_q: int, num_v: int, num_z: int) -> None: ...
    def Clone(self) -> ContinuousState: ...
    def CopyToVector(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def SetFrom(self, arg0: ContinuousState) -> None: ...
    def SetFromVector(self, value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def get_generalized_position(self) -> VectorBase: ...
    def get_generalized_velocity(self) -> VectorBase: ...
    def get_misc_continuous_state(self) -> VectorBase: ...
    def get_mutable_generalized_position(self) -> VectorBase: ...
    def get_mutable_generalized_velocity(self) -> VectorBase: ...
    def get_mutable_misc_continuous_state(self) -> VectorBase: ...
    def get_mutable_vector(self) -> VectorBase: ...
    def get_vector(self) -> VectorBase: ...
    def num_q(self) -> int: ...
    def num_v(self) -> int: ...
    def num_z(self) -> int: ...
    def size(self) -> int: ...
    def __copy__(self) -> ContinuousState: ...
    def __deepcopy__(self, arg0: dict) -> ContinuousState: ...
    def __getitem__(self, arg0: int) -> float: ...
    def __iter__(self) -> typing.Iterator[float]: ...
    def __setitem__(self, arg0: int, arg1: float) -> None: ...

class ContinuousStateIndex:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def is_valid(self) -> bool: ...
    @overload
    def __eq__(self, arg0: ContinuousStateIndex) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __lt__(self, arg0: ContinuousStateIndex) -> bool: ...

class ContinuousState_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, state: BasicVector_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, state: BasicVector_TAutoDiffXdU, num_q: int, num_v: int, num_z: int) -> None: ...
    @overload
    def __init__(self, state: VectorBase_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, state: VectorBase_TAutoDiffXdU, num_q: int, num_v: int, num_z: int) -> None: ...
    def Clone(self) -> ContinuousState_TAutoDiffXdU: ...
    def CopyToVector(self) -> numpy.ndarray[object[m, 1]]: ...
    def SetFrom(self, arg0: ContinuousState) -> None: ...
    def SetFromVector(self, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def get_generalized_position(self) -> VectorBase_TAutoDiffXdU: ...
    def get_generalized_velocity(self) -> VectorBase_TAutoDiffXdU: ...
    def get_misc_continuous_state(self) -> VectorBase_TAutoDiffXdU: ...
    def get_mutable_generalized_position(self) -> VectorBase_TAutoDiffXdU: ...
    def get_mutable_generalized_velocity(self) -> VectorBase_TAutoDiffXdU: ...
    def get_mutable_misc_continuous_state(self) -> VectorBase_TAutoDiffXdU: ...
    def get_mutable_vector(self) -> VectorBase_TAutoDiffXdU: ...
    def get_vector(self) -> VectorBase_TAutoDiffXdU: ...
    def num_q(self) -> int: ...
    def num_v(self) -> int: ...
    def num_z(self) -> int: ...
    def size(self) -> int: ...
    def __copy__(self) -> ContinuousState_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> ContinuousState_TAutoDiffXdU: ...
    def __getitem__(self, arg0: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    def __iter__(self) -> typing.Iterator[pydrake.autodiffutils.AutoDiffXd]: ...
    def __setitem__(self, arg0: int, arg1: pydrake.autodiffutils.AutoDiffXd) -> None: ...

class ContinuousState_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, state: BasicVector_TExpressionU) -> None: ...
    @overload
    def __init__(self, state: BasicVector_TExpressionU, num_q: int, num_v: int, num_z: int) -> None: ...
    @overload
    def __init__(self, state: VectorBase_TExpressionU) -> None: ...
    @overload
    def __init__(self, state: VectorBase_TExpressionU, num_q: int, num_v: int, num_z: int) -> None: ...
    def Clone(self) -> ContinuousState_TExpressionU: ...
    def CopyToVector(self) -> numpy.ndarray[object[m, 1]]: ...
    def SetFrom(self, arg0: ContinuousState) -> None: ...
    def SetFromVector(self, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def get_generalized_position(self) -> VectorBase_TExpressionU: ...
    def get_generalized_velocity(self) -> VectorBase_TExpressionU: ...
    def get_misc_continuous_state(self) -> VectorBase_TExpressionU: ...
    def get_mutable_generalized_position(self) -> VectorBase_TExpressionU: ...
    def get_mutable_generalized_velocity(self) -> VectorBase_TExpressionU: ...
    def get_mutable_misc_continuous_state(self) -> VectorBase_TExpressionU: ...
    def get_mutable_vector(self) -> VectorBase_TExpressionU: ...
    def get_vector(self) -> VectorBase_TExpressionU: ...
    def num_q(self) -> int: ...
    def num_v(self) -> int: ...
    def num_z(self) -> int: ...
    def size(self) -> int: ...
    def __copy__(self) -> ContinuousState_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> ContinuousState_TExpressionU: ...
    def __getitem__(self, arg0: int) -> pydrake.symbolic.Expression: ...
    def __iter__(self) -> typing.Iterator[pydrake.symbolic.Expression]: ...
    def __setitem__(self, arg0: int, arg1: pydrake.symbolic.Expression) -> None: ...

class DependencyTicket:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def is_valid(self) -> bool: ...
    @overload
    def __eq__(self, arg0: DependencyTicket) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __lt__(self, arg0: DependencyTicket) -> bool: ...

class Diagram(System):
    def __init__(self) -> None: ...
    def AreConnected(self, output: OutputPort, input: InputPort) -> bool: ...
    def GetInputPortLocators(self, port_index: InputPortIndex) -> list: ...
    def GetMutableSubsystemState(self, arg0: System, arg1: Context) -> State: ...
    def GetSubsystemByName(self, name: str) -> System: ...
    def GetSystems(self) -> list[System]: ...
    def HasSubsystemNamed(self, name: str) -> bool: ...
    def connection_map(self) -> dict: ...
    def get_output_port_locator(self, port_index: OutputPortIndex) -> tuple: ...

class DiagramBuilder:
    def __init__(self) -> None: ...
    def AddNamedSystem(self, name: str, system: System) -> System: ...
    def AddSystem(self, system: System) -> System: ...
    def Build(self) -> Diagram: ...
    def BuildInto(self, target: Diagram) -> None: ...
    def Connect(self, arg0: OutputPort, arg1: InputPort) -> None: ...
    @overload
    def ConnectInput(self, diagram_port_name: str, input: InputPort) -> None: ...
    @overload
    def ConnectInput(self, diagram_port_index: InputPortIndex, input: InputPort) -> None: ...
    def ConnectToSame(self, exemplar: InputPort, dest: InputPort) -> bool: ...
    def Disconnect(self, source: OutputPort, dest: InputPort) -> None: ...
    def ExportInput(self, input: InputPort, name: str | UseDefaultName = ...) -> InputPortIndex: ...
    def ExportOutput(self, output: OutputPort, name: str | UseDefaultName = ...) -> OutputPortIndex: ...
    def GetMutableSubsystemByName(self, name: str) -> System: ...
    def GetMutableSystems(self) -> list[System]: ...
    def GetSubsystemByName(self, name: str) -> System: ...
    def GetSystems(self) -> list[System]: ...
    def HasSubsystemNamed(self, name: str) -> bool: ...
    def IsConnectedOrExported(self, port: InputPort) -> bool: ...
    def RemoveSystem(self, system: System) -> None: ...
    def already_built(self) -> bool: ...
    def connection_map(self) -> dict: ...
    def empty(self) -> bool: ...
    def num_input_ports(self) -> int: ...
    def num_output_ports(self) -> int: ...

class DiagramBuilder_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def AddNamedSystem(self, name: str, system: System_TAutoDiffXdU) -> System_TAutoDiffXdU: ...
    def AddSystem(self, system: System_TAutoDiffXdU) -> System_TAutoDiffXdU: ...
    def Build(self) -> Diagram_TAutoDiffXdU: ...
    def BuildInto(self, target: Diagram_TAutoDiffXdU) -> None: ...
    def Connect(self, arg0: OutputPort_TAutoDiffXdU, arg1: InputPort_TAutoDiffXdU) -> None: ...
    @overload
    def ConnectInput(self, diagram_port_name: str, input: InputPort_TAutoDiffXdU) -> None: ...
    @overload
    def ConnectInput(self, diagram_port_index: InputPortIndex, input: InputPort_TAutoDiffXdU) -> None: ...
    def ConnectToSame(self, exemplar: InputPort_TAutoDiffXdU, dest: InputPort_TAutoDiffXdU) -> bool: ...
    def Disconnect(self, source: OutputPort_TAutoDiffXdU, dest: InputPort_TAutoDiffXdU) -> None: ...
    def ExportInput(self, input: InputPort_TAutoDiffXdU, name: str | UseDefaultName = ...) -> InputPortIndex: ...
    def ExportOutput(self, output: OutputPort_TAutoDiffXdU, name: str | UseDefaultName = ...) -> OutputPortIndex: ...
    def GetMutableSubsystemByName(self, name: str) -> System_TAutoDiffXdU: ...
    def GetMutableSystems(self) -> list[System_TAutoDiffXdU]: ...
    def GetSubsystemByName(self, name: str) -> System_TAutoDiffXdU: ...
    def GetSystems(self) -> list[System_TAutoDiffXdU]: ...
    def HasSubsystemNamed(self, name: str) -> bool: ...
    def IsConnectedOrExported(self, port: InputPort_TAutoDiffXdU) -> bool: ...
    def RemoveSystem(self, system: System_TAutoDiffXdU) -> None: ...
    def already_built(self) -> bool: ...
    def connection_map(self) -> dict: ...
    def empty(self) -> bool: ...
    def num_input_ports(self) -> int: ...
    def num_output_ports(self) -> int: ...

class DiagramBuilder_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def AddNamedSystem(self, name: str, system: System_TExpressionU) -> System_TExpressionU: ...
    def AddSystem(self, system: System_TExpressionU) -> System_TExpressionU: ...
    def Build(self) -> Diagram_TExpressionU: ...
    def BuildInto(self, target: Diagram_TExpressionU) -> None: ...
    def Connect(self, arg0: OutputPort_TExpressionU, arg1: InputPort_TExpressionU) -> None: ...
    @overload
    def ConnectInput(self, diagram_port_name: str, input: InputPort_TExpressionU) -> None: ...
    @overload
    def ConnectInput(self, diagram_port_index: InputPortIndex, input: InputPort_TExpressionU) -> None: ...
    def ConnectToSame(self, exemplar: InputPort_TExpressionU, dest: InputPort_TExpressionU) -> bool: ...
    def Disconnect(self, source: OutputPort_TExpressionU, dest: InputPort_TExpressionU) -> None: ...
    def ExportInput(self, input: InputPort_TExpressionU, name: str | UseDefaultName = ...) -> InputPortIndex: ...
    def ExportOutput(self, output: OutputPort_TExpressionU, name: str | UseDefaultName = ...) -> OutputPortIndex: ...
    def GetMutableSubsystemByName(self, name: str) -> System_TExpressionU: ...
    def GetMutableSystems(self) -> list[System_TExpressionU]: ...
    def GetSubsystemByName(self, name: str) -> System_TExpressionU: ...
    def GetSystems(self) -> list[System_TExpressionU]: ...
    def HasSubsystemNamed(self, name: str) -> bool: ...
    def IsConnectedOrExported(self, port: InputPort_TExpressionU) -> bool: ...
    def RemoveSystem(self, system: System_TExpressionU) -> None: ...
    def already_built(self) -> bool: ...
    def connection_map(self) -> dict: ...
    def empty(self) -> bool: ...
    def num_input_ports(self) -> int: ...
    def num_output_ports(self) -> int: ...

class Diagram_𝓣AutoDiffXd𝓤(System_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def AreConnected(self, output: OutputPort_TAutoDiffXdU, input: InputPort_TAutoDiffXdU) -> bool: ...
    def GetInputPortLocators(self, port_index: InputPortIndex) -> list: ...
    def GetMutableSubsystemState(self, arg0: System_TAutoDiffXdU, arg1: Context_TAutoDiffXdU) -> State_TAutoDiffXdU: ...
    def GetSubsystemByName(self, name: str) -> System_TAutoDiffXdU: ...
    def GetSystems(self) -> list[System_TAutoDiffXdU]: ...
    def HasSubsystemNamed(self, name: str) -> bool: ...
    def connection_map(self) -> dict: ...
    def get_output_port_locator(self, port_index: OutputPortIndex) -> tuple: ...

class Diagram_𝓣Expression𝓤(System_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def AreConnected(self, output: OutputPort_TExpressionU, input: InputPort_TExpressionU) -> bool: ...
    def GetInputPortLocators(self, port_index: InputPortIndex) -> list: ...
    def GetMutableSubsystemState(self, arg0: System_TExpressionU, arg1: Context_TExpressionU) -> State_TExpressionU: ...
    def GetSubsystemByName(self, name: str) -> System_TExpressionU: ...
    def GetSystems(self) -> list[System_TExpressionU]: ...
    def HasSubsystemNamed(self, name: str) -> bool: ...
    def connection_map(self) -> dict: ...
    def get_output_port_locator(self, port_index: OutputPortIndex) -> tuple: ...

class DiscreteStateIndex:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def is_valid(self) -> bool: ...
    @overload
    def __eq__(self, arg0: DiscreteStateIndex) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __lt__(self, arg0: DiscreteStateIndex) -> bool: ...

class DiscreteUpdateEvent(Event):
    def __init__(self) -> Any: ...

class DiscreteUpdateEvent_𝓣AutoDiffXd𝓤(Event_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class DiscreteUpdateEvent_𝓣Expression𝓤(Event_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class DiscreteValues:
    @overload
    def __init__(self, datum: BasicVector) -> None: ...
    @overload
    def __init__(self, data: list[BasicVector]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def Clone(self) -> DiscreteValues: ...
    def SetFrom(self, arg0: DiscreteValues) -> None: ...
    def get_data(self) -> list[BasicVector]: ...
    def get_mutable_value(self, index: int = ...) -> numpy.ndarray[numpy.float64[m, 1], flags.writeable]: ...
    def get_mutable_vector(self, index: int = ...) -> BasicVector: ...
    def get_value(self, index: int = ...) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def get_vector(self, index: int = ...) -> BasicVector: ...
    def num_groups(self) -> int: ...
    @overload
    def set_value(self, value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def set_value(self, index: int, value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def size(self) -> int: ...
    def value(self, index: int = ...) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def __copy__(self) -> DiscreteValues: ...
    def __deepcopy__(self, arg0: dict) -> DiscreteValues: ...
    def __getitem__(self, arg0: int) -> float: ...
    def __iter__(self) -> typing.Iterator[float]: ...
    def __setitem__(self, arg0: int, arg1: float) -> None: ...

class DiscreteValues_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, datum: BasicVector_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, data: list[BasicVector_TAutoDiffXdU]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def Clone(self) -> DiscreteValues_TAutoDiffXdU: ...
    def SetFrom(self, arg0: DiscreteValues) -> None: ...
    def get_data(self) -> list[BasicVector_TAutoDiffXdU]: ...
    def get_mutable_value(self, index: int = ...) -> numpy.ndarray[object[m, 1], flags.writeable]: ...
    def get_mutable_vector(self, index: int = ...) -> BasicVector_TAutoDiffXdU: ...
    def get_value(self, index: int = ...) -> numpy.ndarray[object[m, 1]]: ...
    def get_vector(self, index: int = ...) -> BasicVector_TAutoDiffXdU: ...
    def num_groups(self) -> int: ...
    @overload
    def set_value(self, value: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def set_value(self, index: int, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def size(self) -> int: ...
    def value(self, index: int = ...) -> numpy.ndarray[object[m, 1]]: ...
    def __copy__(self) -> DiscreteValues_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> DiscreteValues_TAutoDiffXdU: ...
    def __getitem__(self, arg0: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    def __iter__(self) -> typing.Iterator[pydrake.autodiffutils.AutoDiffXd]: ...
    def __setitem__(self, arg0: int, arg1: pydrake.autodiffutils.AutoDiffXd) -> None: ...

class DiscreteValues_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, datum: BasicVector_TExpressionU) -> None: ...
    @overload
    def __init__(self, data: list[BasicVector_TExpressionU]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def Clone(self) -> DiscreteValues_TExpressionU: ...
    def SetFrom(self, arg0: DiscreteValues) -> None: ...
    def get_data(self) -> list[BasicVector_TExpressionU]: ...
    def get_mutable_value(self, index: int = ...) -> numpy.ndarray[object[m, 1], flags.writeable]: ...
    def get_mutable_vector(self, index: int = ...) -> BasicVector_TExpressionU: ...
    def get_value(self, index: int = ...) -> numpy.ndarray[object[m, 1]]: ...
    def get_vector(self, index: int = ...) -> BasicVector_TExpressionU: ...
    def num_groups(self) -> int: ...
    @overload
    def set_value(self, value: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def set_value(self, index: int, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def size(self) -> int: ...
    def value(self, index: int = ...) -> numpy.ndarray[object[m, 1]]: ...
    def __copy__(self) -> DiscreteValues_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> DiscreteValues_TExpressionU: ...
    def __getitem__(self, arg0: int) -> pydrake.symbolic.Expression: ...
    def __iter__(self) -> typing.Iterator[pydrake.symbolic.Expression]: ...
    def __setitem__(self, arg0: int, arg1: pydrake.symbolic.Expression) -> None: ...

class Event:
    def __init__(self, *args, **kwargs) -> None: ...
    def get_trigger_type(self) -> TriggerType: ...

class EventStatus:
    class Severity:
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        kDidNothing: ClassVar[EventStatus.Severity] = ...
        kFailed: ClassVar[EventStatus.Severity] = ...
        kReachedTermination: ClassVar[EventStatus.Severity] = ...
        kSucceeded: ClassVar[EventStatus.Severity] = ...
        def __init__(self, value: int) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def DidNothing() -> EventStatus: ...
    @staticmethod
    def Failed(system: object, message: str) -> EventStatus: ...
    def KeepMoreSevere(self, candidate: EventStatus) -> EventStatus: ...
    @staticmethod
    def ReachedTermination(system: object, message: str) -> EventStatus: ...
    @staticmethod
    def Succeeded() -> EventStatus: ...
    def message(self) -> str: ...
    def severity(self) -> EventStatus.Severity: ...
    def system(self) -> object: ...
    def __copy__(self) -> EventStatus: ...
    def __deepcopy__(self, arg0: dict) -> EventStatus: ...

class Event_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def get_trigger_type(self) -> TriggerType: ...

class Event_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def get_trigger_type(self) -> TriggerType: ...

class FixedInputPortValue:
    def __init__(self, *args, **kwargs) -> None: ...
    def GetMutableData(self) -> pydrake.common.value.AbstractValue: ...

class InputPort:
    def __init__(self, *args, **kwargs) -> None: ...
    def Allocate(self) -> pydrake.common.value.AbstractValue: ...
    def Eval(self, arg0: Context) -> object: ...
    def EvalAbstract(self, context: Context) -> pydrake.common.value.AbstractValue: ...
    def EvalBasicVector(self, context: Context) -> object: ...
    def FixValue(self, context: Context, value: pydrake.common.value.AbstractValue) -> FixedInputPortValue: ...
    def GetFullDescription(self) -> str: ...
    def HasValue(self, context: Context) -> bool: ...
    def get_data_type(self) -> PortDataType: ...
    def get_index(self) -> InputPortIndex: ...
    def get_name(self) -> str: ...
    def get_system(self) -> object: ...
    def size(self) -> int: ...
    def ticket(self) -> DependencyTicket: ...

class InputPortIndex:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def is_valid(self) -> bool: ...
    @overload
    def __eq__(self, arg0: InputPortIndex) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __lt__(self, arg0: InputPortIndex) -> bool: ...

class InputPortSelection:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kNoInput: ClassVar[InputPortSelection] = ...
    kUseFirstInputIfItExists: ClassVar[InputPortSelection] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class InputPort_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Allocate(self) -> pydrake.common.value.AbstractValue: ...
    def Eval(self, arg0: Context_TAutoDiffXdU) -> object: ...
    def EvalAbstract(self, context: Context_TAutoDiffXdU) -> pydrake.common.value.AbstractValue: ...
    def EvalBasicVector(self, context: Context_TAutoDiffXdU) -> object: ...
    def FixValue(self, context: Context_TAutoDiffXdU, value: pydrake.common.value.AbstractValue) -> FixedInputPortValue: ...
    def GetFullDescription(self) -> str: ...
    def HasValue(self, context: Context_TAutoDiffXdU) -> bool: ...
    def get_data_type(self) -> PortDataType: ...
    def get_index(self) -> InputPortIndex: ...
    def get_name(self) -> str: ...
    def get_system(self) -> object: ...
    def size(self) -> int: ...
    def ticket(self) -> DependencyTicket: ...

class InputPort_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Allocate(self) -> pydrake.common.value.AbstractValue: ...
    def Eval(self, arg0: Context_TExpressionU) -> object: ...
    def EvalAbstract(self, context: Context_TExpressionU) -> pydrake.common.value.AbstractValue: ...
    def EvalBasicVector(self, context: Context_TExpressionU) -> object: ...
    def FixValue(self, context: Context_TExpressionU, value: pydrake.common.value.AbstractValue) -> FixedInputPortValue: ...
    def GetFullDescription(self) -> str: ...
    def HasValue(self, context: Context_TExpressionU) -> bool: ...
    def get_data_type(self) -> PortDataType: ...
    def get_index(self) -> InputPortIndex: ...
    def get_name(self) -> str: ...
    def get_system(self) -> object: ...
    def size(self) -> int: ...
    def ticket(self) -> DependencyTicket: ...

class LeafContext(Context):
    def __init__(self, *args, **kwargs) -> None: ...

class LeafContext_𝓣AutoDiffXd𝓤(Context_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class LeafContext_𝓣Expression𝓤(Context_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class LeafOutputPort(OutputPort):
    def __init__(self, *args, **kwargs) -> None: ...
    def cache_entry(self) -> CacheEntry: ...
    @overload
    def disable_caching_by_default(self) -> None: ...
    @overload
    def disable_caching_by_default(self) -> Any: ...

class LeafOutputPort_𝓣AutoDiffXd𝓤(OutputPort_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def cache_entry(self) -> CacheEntry: ...
    @overload
    def disable_caching_by_default(self) -> None: ...
    @overload
    def disable_caching_by_default(self) -> Any: ...

class LeafOutputPort_𝓣Expression𝓤(OutputPort_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def cache_entry(self) -> CacheEntry: ...
    @overload
    def disable_caching_by_default(self) -> None: ...
    @overload
    def disable_caching_by_default(self) -> Any: ...

class LeafSystem(System):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, converter: SystemScalarConverter) -> None: ...
    def DeclareAbstractInputPort(self, name: str, model_value: pydrake.common.value.AbstractValue) -> InputPort: ...
    def DeclareAbstractOutputPort(self, name: str, alloc: Callable, calc: Callable[[object, object], None], prerequisites_of_calc: set[DependencyTicket] = ...) -> OutputPort: ...
    def DeclareAbstractParameter(self, model_value: pydrake.common.value.AbstractValue) -> int: ...
    def DeclareAbstractState(self, model_value: pydrake.common.value.AbstractValue) -> AbstractStateIndex: ...
    @overload
    def DeclareContinuousState(self, num_state_variables: int) -> ContinuousStateIndex: ...
    @overload
    def DeclareContinuousState(self, num_q: int, num_v: int, num_z: int) -> ContinuousStateIndex: ...
    @overload
    def DeclareContinuousState(self, model_vector: BasicVector) -> ContinuousStateIndex: ...
    @overload
    def DeclareContinuousState(self, model_vector: BasicVector, num_q: int, num_v: int, num_z: int) -> ContinuousStateIndex: ...
    @overload
    def DeclareDiscreteState(self, model_vector: BasicVector) -> DiscreteStateIndex: ...
    @overload
    def DeclareDiscreteState(self, vector: numpy.ndarray[numpy.float64[m, 1]]) -> DiscreteStateIndex: ...
    @overload
    def DeclareDiscreteState(self, num_state_variables: int) -> DiscreteStateIndex: ...
    @overload
    def DeclareDiscreteState(self) -> Any: ...
    @overload
    def DeclareForcedDiscreteUpdateEvent(self, update: Callable[[Context, DiscreteValues], EventStatus | None]) -> None: ...
    @overload
    def DeclareForcedDiscreteUpdateEvent(self) -> Any: ...
    @overload
    def DeclareForcedPublishEvent(self, publish: Callable[[Context], EventStatus | None]) -> None: ...
    @overload
    def DeclareForcedPublishEvent(self) -> Any: ...
    @overload
    def DeclareForcedUnrestrictedUpdateEvent(self, update: Callable[[Context, State], EventStatus | None]) -> None: ...
    @overload
    def DeclareForcedUnrestrictedUpdateEvent(self) -> Any: ...
    def DeclareInitializationDiscreteUpdateEvent(self, update: Callable[[Context, DiscreteValues], EventStatus | None]) -> None: ...
    def DeclareInitializationEvent(self, event: Event) -> None: ...
    def DeclareInitializationPublishEvent(self, publish: Callable[[Context], EventStatus | None]) -> None: ...
    def DeclareInitializationUnrestrictedUpdateEvent(self, update: Callable[[Context, State], EventStatus | None]) -> None: ...
    def DeclareNumericParameter(self, model_vector: BasicVector) -> int: ...
    def DeclarePerStepDiscreteUpdateEvent(self, update: Callable[[Context, DiscreteValues], EventStatus | None]) -> None: ...
    def DeclarePerStepEvent(self, event: Event) -> None: ...
    def DeclarePerStepPublishEvent(self, publish: Callable[[Context], EventStatus | None]) -> None: ...
    def DeclarePerStepUnrestrictedUpdateEvent(self, update: Callable[[Context, State], EventStatus | None]) -> None: ...
    def DeclarePeriodicDiscreteUpdateEvent(self, period_sec: float, offset_sec: float, update: Callable[[Context, DiscreteValues], EventStatus | None]) -> None: ...
    def DeclarePeriodicEvent(self, period_sec: float, offset_sec: float, event: Event) -> None: ...
    def DeclarePeriodicPublishEvent(self, period_sec: float, offset_sec: float, publish: Callable[[Context], EventStatus | None]) -> None: ...
    def DeclarePeriodicUnrestrictedUpdateEvent(self, period_sec: float, offset_sec: float, update: Callable[[Context, State], EventStatus | None]) -> None: ...
    @overload
    def DeclareStateOutputPort(self, name: str | UseDefaultName, state_index: ContinuousStateIndex) -> LeafOutputPort: ...
    @overload
    def DeclareStateOutputPort(self, name: str | UseDefaultName, state_index: DiscreteStateIndex) -> LeafOutputPort: ...
    @overload
    def DeclareStateOutputPort(self, name: str | UseDefaultName, state_index: AbstractStateIndex) -> LeafOutputPort: ...
    def DeclareVectorInputPort(self, name: str, model_vector: BasicVector, random_type: pydrake.common.RandomDistribution | None = ...) -> InputPort: ...
    def DeclareVectorOutputPort(self, name: str, model_value: BasicVector, calc: Callable[[Context, BasicVector], None], prerequisites_of_calc: set[DependencyTicket] = ...) -> OutputPort: ...
    def DoCalcTimeDerivatives(self, arg0: Context, arg1: ContinuousState) -> None: ...
    @overload
    def MakeWitnessFunction(self, description: str, direction_type: WitnessFunctionDirection, calc: Callable[[Context], float | None]) -> WitnessFunction: ...
    @overload
    def MakeWitnessFunction(self, description: str, direction_type: WitnessFunctionDirection, calc: Callable[[Context], float], e: Event) -> WitnessFunction: ...

class LeafSystem_𝓣AutoDiffXd𝓤(System_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, converter: SystemScalarConverter) -> None: ...
    def DeclareAbstractInputPort(self, name: str, model_value: pydrake.common.value.AbstractValue) -> InputPort_TAutoDiffXdU: ...
    def DeclareAbstractOutputPort(self, name: str, alloc: Callable, calc: Callable[[object, object], None], prerequisites_of_calc: set[DependencyTicket] = ...) -> OutputPort_TAutoDiffXdU: ...
    def DeclareAbstractParameter(self, model_value: pydrake.common.value.AbstractValue) -> int: ...
    def DeclareAbstractState(self, model_value: pydrake.common.value.AbstractValue) -> AbstractStateIndex: ...
    @overload
    def DeclareContinuousState(self, num_state_variables: int) -> ContinuousStateIndex: ...
    @overload
    def DeclareContinuousState(self, num_q: int, num_v: int, num_z: int) -> ContinuousStateIndex: ...
    @overload
    def DeclareContinuousState(self, model_vector: BasicVector_TAutoDiffXdU) -> ContinuousStateIndex: ...
    @overload
    def DeclareContinuousState(self, model_vector: BasicVector_TAutoDiffXdU, num_q: int, num_v: int, num_z: int) -> ContinuousStateIndex: ...
    @overload
    def DeclareDiscreteState(self, model_vector: BasicVector_TAutoDiffXdU) -> DiscreteStateIndex: ...
    @overload
    def DeclareDiscreteState(self, vector: numpy.ndarray[object[m, 1]]) -> DiscreteStateIndex: ...
    @overload
    def DeclareDiscreteState(self, num_state_variables: int) -> DiscreteStateIndex: ...
    @overload
    def DeclareDiscreteState(self) -> Any: ...
    @overload
    def DeclareForcedDiscreteUpdateEvent(self, update: Callable[[Context_TAutoDiffXdU, DiscreteValues_TAutoDiffXdU], EventStatus | None]) -> None: ...
    @overload
    def DeclareForcedDiscreteUpdateEvent(self) -> Any: ...
    @overload
    def DeclareForcedPublishEvent(self, publish: Callable[[Context_TAutoDiffXdU], EventStatus | None]) -> None: ...
    @overload
    def DeclareForcedPublishEvent(self) -> Any: ...
    @overload
    def DeclareForcedUnrestrictedUpdateEvent(self, update: Callable[[Context_TAutoDiffXdU, State_TAutoDiffXdU], EventStatus | None]) -> None: ...
    @overload
    def DeclareForcedUnrestrictedUpdateEvent(self) -> Any: ...
    def DeclareInitializationDiscreteUpdateEvent(self, update: Callable[[Context_TAutoDiffXdU, DiscreteValues_TAutoDiffXdU], EventStatus | None]) -> None: ...
    def DeclareInitializationEvent(self, event: Event_TAutoDiffXdU) -> None: ...
    def DeclareInitializationPublishEvent(self, publish: Callable[[Context_TAutoDiffXdU], EventStatus | None]) -> None: ...
    def DeclareInitializationUnrestrictedUpdateEvent(self, update: Callable[[Context_TAutoDiffXdU, State_TAutoDiffXdU], EventStatus | None]) -> None: ...
    def DeclareNumericParameter(self, model_vector: BasicVector_TAutoDiffXdU) -> int: ...
    def DeclarePerStepDiscreteUpdateEvent(self, update: Callable[[Context_TAutoDiffXdU, DiscreteValues_TAutoDiffXdU], EventStatus | None]) -> None: ...
    def DeclarePerStepEvent(self, event: Event_TAutoDiffXdU) -> None: ...
    def DeclarePerStepPublishEvent(self, publish: Callable[[Context_TAutoDiffXdU], EventStatus | None]) -> None: ...
    def DeclarePerStepUnrestrictedUpdateEvent(self, update: Callable[[Context_TAutoDiffXdU, State_TAutoDiffXdU], EventStatus | None]) -> None: ...
    def DeclarePeriodicDiscreteUpdateEvent(self, period_sec: float, offset_sec: float, update: Callable[[Context_TAutoDiffXdU, DiscreteValues_TAutoDiffXdU], EventStatus | None]) -> None: ...
    def DeclarePeriodicEvent(self, period_sec: float, offset_sec: float, event: Event_TAutoDiffXdU) -> None: ...
    def DeclarePeriodicPublishEvent(self, period_sec: float, offset_sec: float, publish: Callable[[Context_TAutoDiffXdU], EventStatus | None]) -> None: ...
    def DeclarePeriodicUnrestrictedUpdateEvent(self, period_sec: float, offset_sec: float, update: Callable[[Context_TAutoDiffXdU, State_TAutoDiffXdU], EventStatus | None]) -> None: ...
    @overload
    def DeclareStateOutputPort(self, name: str | UseDefaultName, state_index: ContinuousStateIndex) -> LeafOutputPort_TAutoDiffXdU: ...
    @overload
    def DeclareStateOutputPort(self, name: str | UseDefaultName, state_index: DiscreteStateIndex) -> LeafOutputPort_TAutoDiffXdU: ...
    @overload
    def DeclareStateOutputPort(self, name: str | UseDefaultName, state_index: AbstractStateIndex) -> LeafOutputPort_TAutoDiffXdU: ...
    def DeclareVectorInputPort(self, name: str, model_vector: BasicVector_TAutoDiffXdU, random_type: pydrake.common.RandomDistribution | None = ...) -> InputPort_TAutoDiffXdU: ...
    def DeclareVectorOutputPort(self, name: str, model_value: BasicVector_TAutoDiffXdU, calc: Callable[[Context_TAutoDiffXdU, BasicVector_TAutoDiffXdU], None], prerequisites_of_calc: set[DependencyTicket] = ...) -> OutputPort_TAutoDiffXdU: ...
    def DoCalcTimeDerivatives(self, arg0: Context_TAutoDiffXdU, arg1: ContinuousState_TAutoDiffXdU) -> None: ...
    @overload
    def MakeWitnessFunction(self, description: str, direction_type: WitnessFunctionDirection, calc: Callable[[Context_TAutoDiffXdU], pydrake.autodiffutils.AutoDiffXd | None]) -> WitnessFunction_TAutoDiffXdU: ...
    @overload
    def MakeWitnessFunction(self, description: str, direction_type: WitnessFunctionDirection, calc: Callable[[Context_TAutoDiffXdU], pydrake.autodiffutils.AutoDiffXd], e: Event_TAutoDiffXdU) -> WitnessFunction_TAutoDiffXdU: ...

class LeafSystem_𝓣Expression𝓤(System_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, converter: SystemScalarConverter) -> None: ...
    def DeclareAbstractInputPort(self, name: str, model_value: pydrake.common.value.AbstractValue) -> InputPort_TExpressionU: ...
    def DeclareAbstractOutputPort(self, name: str, alloc: Callable, calc: Callable[[object, object], None], prerequisites_of_calc: set[DependencyTicket] = ...) -> OutputPort_TExpressionU: ...
    def DeclareAbstractParameter(self, model_value: pydrake.common.value.AbstractValue) -> int: ...
    def DeclareAbstractState(self, model_value: pydrake.common.value.AbstractValue) -> AbstractStateIndex: ...
    @overload
    def DeclareContinuousState(self, num_state_variables: int) -> ContinuousStateIndex: ...
    @overload
    def DeclareContinuousState(self, num_q: int, num_v: int, num_z: int) -> ContinuousStateIndex: ...
    @overload
    def DeclareContinuousState(self, model_vector: BasicVector_TExpressionU) -> ContinuousStateIndex: ...
    @overload
    def DeclareContinuousState(self, model_vector: BasicVector_TExpressionU, num_q: int, num_v: int, num_z: int) -> ContinuousStateIndex: ...
    @overload
    def DeclareDiscreteState(self, model_vector: BasicVector_TExpressionU) -> DiscreteStateIndex: ...
    @overload
    def DeclareDiscreteState(self, vector: numpy.ndarray[object[m, 1]]) -> DiscreteStateIndex: ...
    @overload
    def DeclareDiscreteState(self, num_state_variables: int) -> DiscreteStateIndex: ...
    @overload
    def DeclareDiscreteState(self) -> Any: ...
    @overload
    def DeclareForcedDiscreteUpdateEvent(self, update: Callable[[Context_TExpressionU, DiscreteValues_TExpressionU], EventStatus | None]) -> None: ...
    @overload
    def DeclareForcedDiscreteUpdateEvent(self) -> Any: ...
    @overload
    def DeclareForcedPublishEvent(self, publish: Callable[[Context_TExpressionU], EventStatus | None]) -> None: ...
    @overload
    def DeclareForcedPublishEvent(self) -> Any: ...
    @overload
    def DeclareForcedUnrestrictedUpdateEvent(self, update: Callable[[Context_TExpressionU, State_TExpressionU], EventStatus | None]) -> None: ...
    @overload
    def DeclareForcedUnrestrictedUpdateEvent(self) -> Any: ...
    def DeclareInitializationDiscreteUpdateEvent(self, update: Callable[[Context_TExpressionU, DiscreteValues_TExpressionU], EventStatus | None]) -> None: ...
    def DeclareInitializationEvent(self, event: Event_TExpressionU) -> None: ...
    def DeclareInitializationPublishEvent(self, publish: Callable[[Context_TExpressionU], EventStatus | None]) -> None: ...
    def DeclareInitializationUnrestrictedUpdateEvent(self, update: Callable[[Context_TExpressionU, State_TExpressionU], EventStatus | None]) -> None: ...
    def DeclareNumericParameter(self, model_vector: BasicVector_TExpressionU) -> int: ...
    def DeclarePerStepDiscreteUpdateEvent(self, update: Callable[[Context_TExpressionU, DiscreteValues_TExpressionU], EventStatus | None]) -> None: ...
    def DeclarePerStepEvent(self, event: Event_TExpressionU) -> None: ...
    def DeclarePerStepPublishEvent(self, publish: Callable[[Context_TExpressionU], EventStatus | None]) -> None: ...
    def DeclarePerStepUnrestrictedUpdateEvent(self, update: Callable[[Context_TExpressionU, State_TExpressionU], EventStatus | None]) -> None: ...
    def DeclarePeriodicDiscreteUpdateEvent(self, period_sec: float, offset_sec: float, update: Callable[[Context_TExpressionU, DiscreteValues_TExpressionU], EventStatus | None]) -> None: ...
    def DeclarePeriodicEvent(self, period_sec: float, offset_sec: float, event: Event_TExpressionU) -> None: ...
    def DeclarePeriodicPublishEvent(self, period_sec: float, offset_sec: float, publish: Callable[[Context_TExpressionU], EventStatus | None]) -> None: ...
    def DeclarePeriodicUnrestrictedUpdateEvent(self, period_sec: float, offset_sec: float, update: Callable[[Context_TExpressionU, State_TExpressionU], EventStatus | None]) -> None: ...
    @overload
    def DeclareStateOutputPort(self, name: str | UseDefaultName, state_index: ContinuousStateIndex) -> LeafOutputPort_TExpressionU: ...
    @overload
    def DeclareStateOutputPort(self, name: str | UseDefaultName, state_index: DiscreteStateIndex) -> LeafOutputPort_TExpressionU: ...
    @overload
    def DeclareStateOutputPort(self, name: str | UseDefaultName, state_index: AbstractStateIndex) -> LeafOutputPort_TExpressionU: ...
    def DeclareVectorInputPort(self, name: str, model_vector: BasicVector_TExpressionU, random_type: pydrake.common.RandomDistribution | None = ...) -> InputPort_TExpressionU: ...
    def DeclareVectorOutputPort(self, name: str, model_value: BasicVector_TExpressionU, calc: Callable[[Context_TExpressionU, BasicVector_TExpressionU], None], prerequisites_of_calc: set[DependencyTicket] = ...) -> OutputPort_TExpressionU: ...
    def DoCalcTimeDerivatives(self, arg0: Context_TExpressionU, arg1: ContinuousState_TExpressionU) -> None: ...
    @overload
    def MakeWitnessFunction(self, description: str, direction_type: WitnessFunctionDirection, calc: Callable[[Context_TExpressionU], pydrake.symbolic.Expression | None]) -> WitnessFunction_TExpressionU: ...
    @overload
    def MakeWitnessFunction(self, description: str, direction_type: WitnessFunctionDirection, calc: Callable[[Context_TExpressionU], pydrake.symbolic.Expression], e: Event_TExpressionU) -> WitnessFunction_TExpressionU: ...

class NumericParameterIndex:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def is_valid(self) -> bool: ...
    @overload
    def __eq__(self, arg0: NumericParameterIndex) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __lt__(self, arg0: NumericParameterIndex) -> bool: ...

class OutputPort:
    def __init__(self, *args, **kwargs) -> None: ...
    def Allocate(self) -> pydrake.common.value.AbstractValue: ...
    def Eval(self, arg0: Context) -> object: ...
    def EvalAbstract(self, context: Context) -> object: ...
    def EvalBasicVector(self, context: Context) -> object: ...
    def get_data_type(self) -> PortDataType: ...
    def get_index(self) -> OutputPortIndex: ...
    def get_name(self) -> str: ...
    def get_system(self) -> object: ...
    def size(self) -> int: ...

class OutputPortIndex:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def is_valid(self) -> bool: ...
    @overload
    def __eq__(self, arg0: OutputPortIndex) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __lt__(self, arg0: OutputPortIndex) -> bool: ...

class OutputPortSelection:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kNoOutput: ClassVar[OutputPortSelection] = ...
    kUseFirstOutputIfItExists: ClassVar[OutputPortSelection] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class OutputPort_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Allocate(self) -> pydrake.common.value.AbstractValue: ...
    def Eval(self, arg0: Context_TAutoDiffXdU) -> object: ...
    def EvalAbstract(self, context: Context_TAutoDiffXdU) -> object: ...
    def EvalBasicVector(self, context: Context_TAutoDiffXdU) -> object: ...
    def get_data_type(self) -> PortDataType: ...
    def get_index(self) -> OutputPortIndex: ...
    def get_name(self) -> str: ...
    def get_system(self) -> object: ...
    def size(self) -> int: ...

class OutputPort_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Allocate(self) -> pydrake.common.value.AbstractValue: ...
    def Eval(self, arg0: Context_TExpressionU) -> object: ...
    def EvalAbstract(self, context: Context_TExpressionU) -> object: ...
    def EvalBasicVector(self, context: Context_TExpressionU) -> object: ...
    def get_data_type(self) -> PortDataType: ...
    def get_index(self) -> OutputPortIndex: ...
    def get_name(self) -> str: ...
    def get_system(self) -> object: ...
    def size(self) -> int: ...

class Parameters:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, numeric: list[BasicVector], abstract: list[pydrake.common.value.AbstractValue]) -> None: ...
    @overload
    def __init__(self, numeric: list[BasicVector]) -> None: ...
    @overload
    def __init__(self, abstract: list[pydrake.common.value.AbstractValue]) -> None: ...
    @overload
    def __init__(self, vec: BasicVector) -> None: ...
    @overload
    def __init__(self, value: pydrake.common.value.AbstractValue) -> None: ...
    def Clone(self) -> Parameters: ...
    def SetFrom(self, arg0: Parameters) -> None: ...
    def get_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_abstract_parameters(self) -> AbstractValues: ...
    def get_mutable_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_mutable_numeric_parameter(self, index: int) -> BasicVector: ...
    def get_numeric_parameter(self, index: int) -> BasicVector: ...
    def get_numeric_parameters(self) -> DiscreteValues: ...
    def num_abstract_parameters(self) -> int: ...
    def num_numeric_parameter_groups(self) -> int: ...
    def set_abstract_parameters(self, abstract_params: AbstractValues) -> None: ...
    def set_numeric_parameters(self, numeric_params: DiscreteValues) -> None: ...
    def __copy__(self) -> Parameters: ...
    def __deepcopy__(self, arg0: dict) -> Parameters: ...

class Parameters_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, numeric: list[BasicVector_TAutoDiffXdU], abstract: list[pydrake.common.value.AbstractValue]) -> None: ...
    @overload
    def __init__(self, numeric: list[BasicVector_TAutoDiffXdU]) -> None: ...
    @overload
    def __init__(self, abstract: list[pydrake.common.value.AbstractValue]) -> None: ...
    @overload
    def __init__(self, vec: BasicVector_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, value: pydrake.common.value.AbstractValue) -> None: ...
    def Clone(self) -> Parameters_TAutoDiffXdU: ...
    def SetFrom(self, arg0: Parameters) -> None: ...
    def get_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_abstract_parameters(self) -> AbstractValues: ...
    def get_mutable_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_mutable_numeric_parameter(self, index: int) -> BasicVector_TAutoDiffXdU: ...
    def get_numeric_parameter(self, index: int) -> BasicVector_TAutoDiffXdU: ...
    def get_numeric_parameters(self) -> DiscreteValues_TAutoDiffXdU: ...
    def num_abstract_parameters(self) -> int: ...
    def num_numeric_parameter_groups(self) -> int: ...
    def set_abstract_parameters(self, abstract_params: AbstractValues) -> None: ...
    def set_numeric_parameters(self, numeric_params: DiscreteValues_TAutoDiffXdU) -> None: ...
    def __copy__(self) -> Parameters_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> Parameters_TAutoDiffXdU: ...

class Parameters_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, numeric: list[BasicVector_TExpressionU], abstract: list[pydrake.common.value.AbstractValue]) -> None: ...
    @overload
    def __init__(self, numeric: list[BasicVector_TExpressionU]) -> None: ...
    @overload
    def __init__(self, abstract: list[pydrake.common.value.AbstractValue]) -> None: ...
    @overload
    def __init__(self, vec: BasicVector_TExpressionU) -> None: ...
    @overload
    def __init__(self, value: pydrake.common.value.AbstractValue) -> None: ...
    def Clone(self) -> Parameters_TExpressionU: ...
    def SetFrom(self, arg0: Parameters) -> None: ...
    def get_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_abstract_parameters(self) -> AbstractValues: ...
    def get_mutable_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_mutable_numeric_parameter(self, index: int) -> BasicVector_TExpressionU: ...
    def get_numeric_parameter(self, index: int) -> BasicVector_TExpressionU: ...
    def get_numeric_parameters(self) -> DiscreteValues_TExpressionU: ...
    def num_abstract_parameters(self) -> int: ...
    def num_numeric_parameter_groups(self) -> int: ...
    def set_abstract_parameters(self, abstract_params: AbstractValues) -> None: ...
    def set_numeric_parameters(self, numeric_params: DiscreteValues_TExpressionU) -> None: ...
    def __copy__(self) -> Parameters_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> Parameters_TExpressionU: ...

class PeriodicEventData:
    def __init__(self, *args, **kwargs) -> None: ...
    def offset_sec(self) -> float: ...
    def period_sec(self) -> float: ...
    def __copy__(self) -> PeriodicEventData: ...
    def __deepcopy__(self, arg0: dict) -> PeriodicEventData: ...

class PortDataType:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kAbstractValued: ClassVar[PortDataType] = ...
    kVectorValued: ClassVar[PortDataType] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class PublishEvent(Event):
    @overload
    def __init__(self, callback: Callable[[Context, PublishEvent], EventStatus | None]) -> None: ...
    @overload
    def __init__(self, system_callback) -> None: ...
    @overload
    def __init__(self, trigger_type: TriggerType, callback: Callable[[Context, PublishEvent], EventStatus | None]) -> None: ...
    @overload
    def __init__(self, trigger_type: TriggerType, system_callback) -> None: ...

class PublishEvent_𝓣AutoDiffXd𝓤(Event_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, callback: Callable[[Context_TAutoDiffXdU, PublishEvent_TAutoDiffXdU], EventStatus | None]) -> None: ...
    @overload
    def __init__(self, system_callback) -> None: ...
    @overload
    def __init__(self, trigger_type: TriggerType, callback: Callable[[Context_TAutoDiffXdU, PublishEvent_TAutoDiffXdU], EventStatus | None]) -> None: ...
    @overload
    def __init__(self, trigger_type: TriggerType, system_callback) -> None: ...

class PublishEvent_𝓣Expression𝓤(Event_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, callback: Callable[[Context_TExpressionU, PublishEvent_TExpressionU], EventStatus | None]) -> None: ...
    @overload
    def __init__(self, system_callback) -> None: ...
    @overload
    def __init__(self, trigger_type: TriggerType, callback: Callable[[Context_TExpressionU, PublishEvent_TExpressionU], EventStatus | None]) -> None: ...
    @overload
    def __init__(self, trigger_type: TriggerType, system_callback) -> None: ...

class State:
    def __init__(self) -> None: ...
    def get_abstract_state(self) -> AbstractValues: ...
    def get_continuous_state(self) -> ContinuousState: ...
    def get_discrete_state(self) -> DiscreteValues: ...
    @overload
    def get_mutable_abstract_state(self) -> AbstractValues: ...
    @overload
    def get_mutable_abstract_state(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_mutable_continuous_state(self) -> ContinuousState: ...
    @overload
    def get_mutable_discrete_state(self) -> DiscreteValues: ...
    @overload
    def get_mutable_discrete_state(self, index: int) -> BasicVector: ...

class State_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def get_abstract_state(self) -> AbstractValues: ...
    def get_continuous_state(self) -> ContinuousState_TAutoDiffXdU: ...
    def get_discrete_state(self) -> DiscreteValues_TAutoDiffXdU: ...
    @overload
    def get_mutable_abstract_state(self) -> AbstractValues: ...
    @overload
    def get_mutable_abstract_state(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_mutable_continuous_state(self) -> ContinuousState_TAutoDiffXdU: ...
    @overload
    def get_mutable_discrete_state(self) -> DiscreteValues_TAutoDiffXdU: ...
    @overload
    def get_mutable_discrete_state(self, index: int) -> BasicVector_TAutoDiffXdU: ...

class State_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def get_abstract_state(self) -> AbstractValues: ...
    def get_continuous_state(self) -> ContinuousState_TExpressionU: ...
    def get_discrete_state(self) -> DiscreteValues_TExpressionU: ...
    @overload
    def get_mutable_abstract_state(self) -> AbstractValues: ...
    @overload
    def get_mutable_abstract_state(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_mutable_continuous_state(self) -> ContinuousState_TExpressionU: ...
    @overload
    def get_mutable_discrete_state(self) -> DiscreteValues_TExpressionU: ...
    @overload
    def get_mutable_discrete_state(self, index: int) -> BasicVector_TExpressionU: ...

class SubsystemIndex:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def is_valid(self) -> bool: ...
    @overload
    def __eq__(self, arg0: SubsystemIndex) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __lt__(self, arg0: SubsystemIndex) -> bool: ...

class Subvector(VectorBase):
    def __init__(self, *args, **kwargs) -> None: ...

class Subvector_𝓣AutoDiffXd𝓤(VectorBase_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class Subvector_𝓣Expression𝓤(VectorBase_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class Supervector(VectorBase):
    def __init__(self, *args, **kwargs) -> None: ...

class Supervector_𝓣AutoDiffXd𝓤(VectorBase_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class Supervector_𝓣Expression𝓤(VectorBase_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class System(SystemBase):
    ToScalarType: Incomplete
    ToScalarTypeMaybe: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...
    def Accept(self, v: SystemVisitor) -> None: ...
    def AllocateContext(self) -> Context: ...
    def AllocateDiscreteVariables(self) -> DiscreteValues: ...
    def AllocateImplicitTimeDerivativesResidual(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def AllocateInputAbstract(self, input_port: InputPort) -> pydrake.common.value.AbstractValue: ...
    def AllocateInputVector(self, input_port: InputPort) -> BasicVector: ...
    def AllocateOutput(self) -> SystemOutput: ...
    def AllocateTimeDerivatives(self) -> ContinuousState: ...
    def CalcConservativePower(self, context: Context) -> float: ...
    def CalcForcedDiscreteVariableUpdate(self, context: Context, discrete_state: DiscreteValues) -> None: ...
    def CalcForcedUnrestrictedUpdate(self, context: Context, state: State) -> None: ...
    @overload
    def CalcImplicitTimeDerivativesResidual(self, context: Context, proposed_derivatives: ContinuousState, residual: numpy.ndarray[numpy.float64[m, 1], flags.writeable] | None) -> None: ...
    @overload
    def CalcImplicitTimeDerivativesResidual(self, context: Context, proposed_derivatives: ContinuousState) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def CalcKineticEnergy(self, context: Context) -> float: ...
    def CalcNonConservativePower(self, context: Context) -> float: ...
    def CalcOutput(self, context: Context, outputs: SystemOutput) -> None: ...
    def CalcPotentialEnergy(self, context: Context) -> float: ...
    def CalcTimeDerivatives(self, context: Context, derivatives: ContinuousState) -> None: ...
    def Clone(self) -> System: ...
    def CreateDefaultContext(self) -> Context: ...
    def DeclareInputPort(self, name: str | UseDefaultName, type: PortDataType, size: int, random_type: pydrake.common.RandomDistribution | None = ...) -> InputPort: ...
    def EvalAbstractInput(self, context: Context, port_index: int) -> pydrake.common.value.AbstractValue: ...
    def EvalKineticEnergy(self, context: Context) -> float: ...
    def EvalPotentialEnergy(self, context: Context) -> float: ...
    def EvalTimeDerivatives(self, context: Context) -> ContinuousState: ...
    @overload
    def EvalUniquePeriodicDiscreteUpdate(self, context: Context) -> DiscreteValues: ...
    @overload
    def EvalUniquePeriodicDiscreteUpdate(self, context) -> Any: ...
    @overload
    def EvalUniquePeriodicDiscreteUpdate(self) -> Any: ...
    def EvalVectorInput(self, context: Context, port_index: int) -> BasicVector: ...
    def ExecuteForcedEvents(self, context: Context, publish: bool = ...) -> None: ...
    def ExecuteInitializationEvents(self, context: Context) -> None: ...
    def FixInputPortsFrom(self, other_system: System, other_context: Context, target_context: Context) -> None: ...
    def ForcedPublish(self, context: Context) -> None: ...
    def GetInputPort(self, port_name: str) -> InputPort: ...
    def GetMutableSubsystemContext(self, subsystem: System, context: Context) -> Context: ...
    @overload
    def GetMyContextFromRoot(self, root_context: Context) -> Context: ...
    @overload
    def GetMyContextFromRoot(self) -> Any: ...
    def GetMyMutableContextFromRoot(self, root_context: Context) -> Context: ...
    def GetOutputPort(self, port_name: str) -> OutputPort: ...
    def GetSubsystemContext(self, subsystem: System, context: Context) -> Context: ...
    def GetUniquePeriodicDiscreteUpdateAttribute(self) -> PeriodicEventData | None: ...
    @overload
    def GetWitnessFunctions(self, context: Context) -> list[WitnessFunction]: ...
    @overload
    def GetWitnessFunctions(self, context) -> Any: ...
    def HasAnyDirectFeedthrough(self) -> bool: ...
    @overload
    def HasDirectFeedthrough(self, output_port: int) -> bool: ...
    @overload
    def HasDirectFeedthrough(self, input_port: int, output_port: int) -> bool: ...
    def HasInputPort(self, port_name: str) -> bool: ...
    def HasOutputPort(self, port_name: str) -> bool: ...
    @overload
    def IsDifferenceEquationSystem(self) -> tuple[bool, float]: ...
    @overload
    def IsDifferenceEquationSystem(self) -> Any: ...
    def IsDifferentialEquationSystem(self) -> bool: ...
    def SetDefaultContext(self, context: Context) -> None: ...
    def SetRandomContext(self, context: Context, generator: pydrake.common.RandomGenerator) -> None: ...
    def ToAutoDiffXd(self) -> System_TAutoDiffXdU: ...
    def ToAutoDiffXdMaybe(self) -> System_TAutoDiffXdU: ...
    def ToScalarTypeMaybe𝓣AutoDiffXd𝓤(self) -> System_TAutoDiffXdU: ...
    def ToScalarTypeMaybe𝓣Expression𝓤(self) -> System_TExpressionU: ...
    def ToScalarTypeMaybe𝓣float𝓤(self) -> System: ...
    def ToScalarType𝓣AutoDiffXd𝓤(self) -> System_TAutoDiffXdU: ...
    def ToScalarType𝓣Expression𝓤(self) -> System_TExpressionU: ...
    def ToScalarType𝓣float𝓤(self) -> System: ...
    def ToSymbolic(self) -> System_TExpressionU: ...
    def ToSymbolicMaybe(self) -> System_TExpressionU: ...
    @overload
    def get_input_port(self, port_index: int, warn_deprecated: bool = ...) -> InputPort: ...
    @overload
    def get_input_port(self) -> InputPort: ...
    @overload
    def get_output_port(self, port_index: int, warn_deprecated: bool = ...) -> OutputPort: ...
    @overload
    def get_output_port(self) -> OutputPort: ...
    def get_system_scalar_converter(self) -> SystemScalarConverter: ...
    def num_constraints(self) -> int: ...
    def __copy__(self) -> System: ...
    def __deepcopy__(self, arg0: dict) -> System: ...

class SystemBase:
    class GraphvizFragment:
        fragments: list[str]
        input_ports: list[str]
        output_ports: list[str]
        def __init__(self, *args, **kwargs) -> None: ...

    class GraphvizFragmentParams:
        header_lines: list[str]
        max_depth: int
        node_id: str
        options: dict[str, str]
        def __init__(self, *args, **kwargs) -> None: ...
    def __init__(self, *args, **kwargs) -> None: ...
    def DeclareCacheEntry(self, description: str, value_producer: ValueProducer, prerequisites_of_calc: set[DependencyTicket] = ...) -> CacheEntry: ...
    def DoGetGraphvizFragment(self, arg0: SystemBase.GraphvizFragmentParams) -> SystemBase.GraphvizFragment: ...
    def GetGraphvizFragment(self, max_depth: int | None = ..., options: dict[str, str] = ...) -> SystemBase.GraphvizFragment: ...
    def GetGraphvizString(self, max_depth: int | None = ..., options: dict[str, str] = ...) -> str: ...
    def GetSystemName(self) -> str: ...
    def GetSystemPathname(self) -> str: ...
    def GetSystemType(self) -> str: ...
    def ValidateContext(self, context: ContextBase) -> None: ...
    def abstract_parameter_ticket(self, index: AbstractParameterIndex) -> DependencyTicket: ...
    def abstract_state_ticket(self, index: AbstractStateIndex) -> DependencyTicket: ...
    @staticmethod
    def accuracy_ticket() -> DependencyTicket: ...
    @staticmethod
    def all_input_ports_ticket() -> DependencyTicket: ...
    @staticmethod
    def all_parameters_ticket() -> DependencyTicket: ...
    @staticmethod
    def all_sources_except_input_ports_ticket() -> DependencyTicket: ...
    @staticmethod
    def all_sources_ticket() -> DependencyTicket: ...
    @staticmethod
    def all_state_ticket() -> DependencyTicket: ...
    def cache_entry_ticket(self, index: CacheIndex) -> DependencyTicket: ...
    @staticmethod
    def configuration_ticket() -> DependencyTicket: ...
    def discrete_state_ticket(self, index: DiscreteStateIndex) -> DependencyTicket: ...
    def get_cache_entry(self, index: CacheIndex) -> CacheEntry: ...
    def get_name(self) -> str: ...
    def implicit_time_derivatives_residual_size(self) -> int: ...
    def input_port_ticket(self, index: InputPortIndex) -> DependencyTicket: ...
    @staticmethod
    def ke_ticket() -> DependencyTicket: ...
    @staticmethod
    def kinematics_ticket() -> DependencyTicket: ...
    @staticmethod
    def nothing_ticket() -> DependencyTicket: ...
    def num_abstract_parameters(self) -> int: ...
    def num_abstract_states(self) -> int: ...
    def num_continuous_states(self) -> int: ...
    def num_discrete_state_groups(self) -> int: ...
    @overload
    def num_input_ports(self) -> int: ...
    @overload
    def num_input_ports(self) -> Any: ...
    def num_numeric_parameter_groups(self) -> int: ...
    @overload
    def num_output_ports(self) -> int: ...
    @overload
    def num_output_ports(self) -> Any: ...
    def numeric_parameter_ticket(self, index: NumericParameterIndex) -> DependencyTicket: ...
    @staticmethod
    def pa_ticket() -> DependencyTicket: ...
    @staticmethod
    def pc_ticket() -> DependencyTicket: ...
    @staticmethod
    def pe_ticket() -> DependencyTicket: ...
    @staticmethod
    def pn_ticket() -> DependencyTicket: ...
    @staticmethod
    def pnc_ticket() -> DependencyTicket: ...
    @staticmethod
    def q_ticket() -> DependencyTicket: ...
    def set_name(self, name: str) -> None: ...
    @staticmethod
    def time_ticket() -> DependencyTicket: ...
    @staticmethod
    def v_ticket() -> DependencyTicket: ...
    @staticmethod
    def xa_ticket() -> DependencyTicket: ...
    @staticmethod
    def xc_ticket() -> DependencyTicket: ...
    @staticmethod
    def xcdot_ticket() -> DependencyTicket: ...
    @staticmethod
    def xd_ticket() -> DependencyTicket: ...
    @staticmethod
    def z_ticket() -> DependencyTicket: ...

class SystemConstraintIndex:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def is_valid(self) -> bool: ...
    @overload
    def __eq__(self, arg0: SystemConstraintIndex) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __lt__(self, arg0: SystemConstraintIndex) -> bool: ...

class SystemOutput:
    def __init__(self, *args, **kwargs) -> None: ...
    def get_data(self, arg0: int) -> pydrake.common.value.AbstractValue: ...
    def get_vector_data(self, arg0: int) -> BasicVector: ...
    def num_ports(self) -> int: ...

class SystemOutput_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def get_data(self, arg0: int) -> pydrake.common.value.AbstractValue: ...
    def get_vector_data(self, arg0: int) -> BasicVector_TAutoDiffXdU: ...
    def num_ports(self) -> int: ...

class SystemOutput_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def get_data(self, arg0: int) -> pydrake.common.value.AbstractValue: ...
    def get_vector_data(self, arg0: int) -> BasicVector_TExpressionU: ...
    def num_ports(self) -> int: ...

class SystemScalarConverter:
    SupportedConversionPairs: ClassVar[tuple] = ...
    SupportedScalars: ClassVar[tuple] = ...
    IsConvertible: Incomplete
    def __init__(self) -> None: ...
    def IsConvertible𝓣AutoDiffXd𝓬Expression𝓤(self) -> bool: ...
    def IsConvertible𝓣AutoDiffXd𝓬float𝓤(self) -> bool: ...
    def IsConvertible𝓣Expression𝓬AutoDiffXd𝓤(self) -> bool: ...
    def IsConvertible𝓣Expression𝓬float𝓤(self) -> bool: ...
    def IsConvertible𝓣float𝓬AutoDiffXd𝓤(self) -> bool: ...
    def IsConvertible𝓣float𝓬Expression𝓤(self) -> bool: ...
    def __copy__(self) -> SystemScalarConverter: ...

class SystemVisitor:
    def __init__(self) -> None: ...
    def VisitDiagram(self, diagram: Diagram) -> None: ...
    def VisitSystem(self, system: System) -> None: ...

class SystemVisitor_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def VisitDiagram(self, diagram: Diagram_TAutoDiffXdU) -> None: ...
    def VisitSystem(self, system: System_TAutoDiffXdU) -> None: ...

class SystemVisitor_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def VisitDiagram(self, diagram: Diagram_TExpressionU) -> None: ...
    def VisitSystem(self, system: System_TExpressionU) -> None: ...

class System_𝓣AutoDiffXd𝓤(SystemBase):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    ToScalarType: Incomplete
    ToScalarTypeMaybe: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...
    def Accept(self, v: SystemVisitor_TAutoDiffXdU) -> None: ...
    def AllocateContext(self) -> Context_TAutoDiffXdU: ...
    def AllocateDiscreteVariables(self) -> DiscreteValues_TAutoDiffXdU: ...
    def AllocateImplicitTimeDerivativesResidual(self) -> numpy.ndarray[object[m, 1]]: ...
    def AllocateInputAbstract(self, input_port: InputPort_TAutoDiffXdU) -> pydrake.common.value.AbstractValue: ...
    def AllocateInputVector(self, input_port: InputPort_TAutoDiffXdU) -> BasicVector_TAutoDiffXdU: ...
    def AllocateOutput(self) -> SystemOutput_TAutoDiffXdU: ...
    def AllocateTimeDerivatives(self) -> ContinuousState_TAutoDiffXdU: ...
    def CalcConservativePower(self, context: Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def CalcForcedDiscreteVariableUpdate(self, context: Context_TAutoDiffXdU, discrete_state: DiscreteValues_TAutoDiffXdU) -> None: ...
    def CalcForcedUnrestrictedUpdate(self, context: Context_TAutoDiffXdU, state: State_TAutoDiffXdU) -> None: ...
    @overload
    def CalcImplicitTimeDerivativesResidual(self, context: Context_TAutoDiffXdU, proposed_derivatives: ContinuousState_TAutoDiffXdU, residual: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    @overload
    def CalcImplicitTimeDerivativesResidual(self, context: Context_TAutoDiffXdU, proposed_derivatives: ContinuousState_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcKineticEnergy(self, context: Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def CalcNonConservativePower(self, context: Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def CalcOutput(self, context: Context_TAutoDiffXdU, outputs: SystemOutput_TAutoDiffXdU) -> None: ...
    def CalcPotentialEnergy(self, context: Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def CalcTimeDerivatives(self, context: Context_TAutoDiffXdU, derivatives: ContinuousState_TAutoDiffXdU) -> None: ...
    def Clone(self) -> System_TAutoDiffXdU: ...
    def CreateDefaultContext(self) -> Context_TAutoDiffXdU: ...
    def DeclareInputPort(self, name: str | UseDefaultName, type: PortDataType, size: int, random_type: pydrake.common.RandomDistribution | None = ...) -> InputPort_TAutoDiffXdU: ...
    def EvalAbstractInput(self, context: Context_TAutoDiffXdU, port_index: int) -> pydrake.common.value.AbstractValue: ...
    def EvalKineticEnergy(self, context: Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def EvalPotentialEnergy(self, context: Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def EvalTimeDerivatives(self, context: Context_TAutoDiffXdU) -> ContinuousState_TAutoDiffXdU: ...
    @overload
    def EvalUniquePeriodicDiscreteUpdate(self, context: Context_TAutoDiffXdU) -> DiscreteValues_TAutoDiffXdU: ...
    @overload
    def EvalUniquePeriodicDiscreteUpdate(self, context) -> Any: ...
    @overload
    def EvalUniquePeriodicDiscreteUpdate(self) -> Any: ...
    def EvalVectorInput(self, context: Context_TAutoDiffXdU, port_index: int) -> BasicVector_TAutoDiffXdU: ...
    def ExecuteForcedEvents(self, context: Context_TAutoDiffXdU, publish: bool = ...) -> None: ...
    def ExecuteInitializationEvents(self, context: Context_TAutoDiffXdU) -> None: ...
    def FixInputPortsFrom(self, other_system: System, other_context: Context, target_context: Context_TAutoDiffXdU) -> None: ...
    def ForcedPublish(self, context: Context_TAutoDiffXdU) -> None: ...
    def GetInputPort(self, port_name: str) -> InputPort_TAutoDiffXdU: ...
    def GetMutableSubsystemContext(self, subsystem: System_TAutoDiffXdU, context: Context_TAutoDiffXdU) -> Context_TAutoDiffXdU: ...
    @overload
    def GetMyContextFromRoot(self, root_context: Context_TAutoDiffXdU) -> Context_TAutoDiffXdU: ...
    @overload
    def GetMyContextFromRoot(self) -> Any: ...
    def GetMyMutableContextFromRoot(self, root_context: Context_TAutoDiffXdU) -> Context_TAutoDiffXdU: ...
    def GetOutputPort(self, port_name: str) -> OutputPort_TAutoDiffXdU: ...
    def GetSubsystemContext(self, subsystem: System_TAutoDiffXdU, context: Context_TAutoDiffXdU) -> Context_TAutoDiffXdU: ...
    def GetUniquePeriodicDiscreteUpdateAttribute(self) -> PeriodicEventData | None: ...
    @overload
    def GetWitnessFunctions(self, context: Context_TAutoDiffXdU) -> list[WitnessFunction_TAutoDiffXdU]: ...
    @overload
    def GetWitnessFunctions(self, context) -> Any: ...
    def HasAnyDirectFeedthrough(self) -> bool: ...
    @overload
    def HasDirectFeedthrough(self, output_port: int) -> bool: ...
    @overload
    def HasDirectFeedthrough(self, input_port: int, output_port: int) -> bool: ...
    def HasInputPort(self, port_name: str) -> bool: ...
    def HasOutputPort(self, port_name: str) -> bool: ...
    @overload
    def IsDifferenceEquationSystem(self) -> tuple[bool, float]: ...
    @overload
    def IsDifferenceEquationSystem(self) -> Any: ...
    def IsDifferentialEquationSystem(self) -> bool: ...
    def SetDefaultContext(self, context: Context_TAutoDiffXdU) -> None: ...
    def SetRandomContext(self, context: Context_TAutoDiffXdU, generator: pydrake.common.RandomGenerator) -> None: ...
    def ToAutoDiffXd(self) -> System_TAutoDiffXdU: ...
    def ToAutoDiffXdMaybe(self) -> System_TAutoDiffXdU: ...
    def ToScalarTypeMaybe𝓣AutoDiffXd𝓤(self) -> System_TAutoDiffXdU: ...
    def ToScalarTypeMaybe𝓣Expression𝓤(self) -> System_TExpressionU: ...
    def ToScalarTypeMaybe𝓣float𝓤(self) -> System: ...
    def ToScalarType𝓣AutoDiffXd𝓤(self) -> System_TAutoDiffXdU: ...
    def ToScalarType𝓣Expression𝓤(self) -> System_TExpressionU: ...
    def ToScalarType𝓣float𝓤(self) -> System: ...
    def ToSymbolic(self) -> System_TExpressionU: ...
    def ToSymbolicMaybe(self) -> System_TExpressionU: ...
    @overload
    def get_input_port(self, port_index: int, warn_deprecated: bool = ...) -> InputPort_TAutoDiffXdU: ...
    @overload
    def get_input_port(self) -> InputPort_TAutoDiffXdU: ...
    @overload
    def get_output_port(self, port_index: int, warn_deprecated: bool = ...) -> OutputPort_TAutoDiffXdU: ...
    @overload
    def get_output_port(self) -> OutputPort_TAutoDiffXdU: ...
    def get_system_scalar_converter(self) -> SystemScalarConverter: ...
    def num_constraints(self) -> int: ...
    def __copy__(self) -> System_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> System_TAutoDiffXdU: ...

class System_𝓣Expression𝓤(SystemBase):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    ToScalarType: Incomplete
    ToScalarTypeMaybe: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...
    def Accept(self, v: SystemVisitor_TExpressionU) -> None: ...
    def AllocateContext(self) -> Context_TExpressionU: ...
    def AllocateDiscreteVariables(self) -> DiscreteValues_TExpressionU: ...
    def AllocateImplicitTimeDerivativesResidual(self) -> numpy.ndarray[object[m, 1]]: ...
    def AllocateInputAbstract(self, input_port: InputPort_TExpressionU) -> pydrake.common.value.AbstractValue: ...
    def AllocateInputVector(self, input_port: InputPort_TExpressionU) -> BasicVector_TExpressionU: ...
    def AllocateOutput(self) -> SystemOutput_TExpressionU: ...
    def AllocateTimeDerivatives(self) -> ContinuousState_TExpressionU: ...
    def CalcConservativePower(self, context: Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def CalcForcedDiscreteVariableUpdate(self, context: Context_TExpressionU, discrete_state: DiscreteValues_TExpressionU) -> None: ...
    def CalcForcedUnrestrictedUpdate(self, context: Context_TExpressionU, state: State_TExpressionU) -> None: ...
    @overload
    def CalcImplicitTimeDerivativesResidual(self, context: Context_TExpressionU, proposed_derivatives: ContinuousState_TExpressionU, residual: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    @overload
    def CalcImplicitTimeDerivativesResidual(self, context: Context_TExpressionU, proposed_derivatives: ContinuousState_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcKineticEnergy(self, context: Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def CalcNonConservativePower(self, context: Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def CalcOutput(self, context: Context_TExpressionU, outputs: SystemOutput_TExpressionU) -> None: ...
    def CalcPotentialEnergy(self, context: Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def CalcTimeDerivatives(self, context: Context_TExpressionU, derivatives: ContinuousState_TExpressionU) -> None: ...
    def Clone(self) -> System_TExpressionU: ...
    def CreateDefaultContext(self) -> Context_TExpressionU: ...
    def DeclareInputPort(self, name: str | UseDefaultName, type: PortDataType, size: int, random_type: pydrake.common.RandomDistribution | None = ...) -> InputPort_TExpressionU: ...
    def EvalAbstractInput(self, context: Context_TExpressionU, port_index: int) -> pydrake.common.value.AbstractValue: ...
    def EvalKineticEnergy(self, context: Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def EvalPotentialEnergy(self, context: Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def EvalTimeDerivatives(self, context: Context_TExpressionU) -> ContinuousState_TExpressionU: ...
    @overload
    def EvalUniquePeriodicDiscreteUpdate(self, context: Context_TExpressionU) -> DiscreteValues_TExpressionU: ...
    @overload
    def EvalUniquePeriodicDiscreteUpdate(self, context) -> Any: ...
    @overload
    def EvalUniquePeriodicDiscreteUpdate(self) -> Any: ...
    def EvalVectorInput(self, context: Context_TExpressionU, port_index: int) -> BasicVector_TExpressionU: ...
    def ExecuteForcedEvents(self, context: Context_TExpressionU, publish: bool = ...) -> None: ...
    def ExecuteInitializationEvents(self, context: Context_TExpressionU) -> None: ...
    def FixInputPortsFrom(self, other_system: System, other_context: Context, target_context: Context_TExpressionU) -> None: ...
    def ForcedPublish(self, context: Context_TExpressionU) -> None: ...
    def GetInputPort(self, port_name: str) -> InputPort_TExpressionU: ...
    def GetMutableSubsystemContext(self, subsystem: System_TExpressionU, context: Context_TExpressionU) -> Context_TExpressionU: ...
    @overload
    def GetMyContextFromRoot(self, root_context: Context_TExpressionU) -> Context_TExpressionU: ...
    @overload
    def GetMyContextFromRoot(self) -> Any: ...
    def GetMyMutableContextFromRoot(self, root_context: Context_TExpressionU) -> Context_TExpressionU: ...
    def GetOutputPort(self, port_name: str) -> OutputPort_TExpressionU: ...
    def GetSubsystemContext(self, subsystem: System_TExpressionU, context: Context_TExpressionU) -> Context_TExpressionU: ...
    def GetUniquePeriodicDiscreteUpdateAttribute(self) -> PeriodicEventData | None: ...
    @overload
    def GetWitnessFunctions(self, context: Context_TExpressionU) -> list[WitnessFunction_TExpressionU]: ...
    @overload
    def GetWitnessFunctions(self, context) -> Any: ...
    def HasAnyDirectFeedthrough(self) -> bool: ...
    @overload
    def HasDirectFeedthrough(self, output_port: int) -> bool: ...
    @overload
    def HasDirectFeedthrough(self, input_port: int, output_port: int) -> bool: ...
    def HasInputPort(self, port_name: str) -> bool: ...
    def HasOutputPort(self, port_name: str) -> bool: ...
    @overload
    def IsDifferenceEquationSystem(self) -> tuple[bool, float]: ...
    @overload
    def IsDifferenceEquationSystem(self) -> Any: ...
    def IsDifferentialEquationSystem(self) -> bool: ...
    def SetDefaultContext(self, context: Context_TExpressionU) -> None: ...
    def SetRandomContext(self, context: Context_TExpressionU, generator: pydrake.common.RandomGenerator) -> None: ...
    def ToAutoDiffXd(self) -> System_TAutoDiffXdU: ...
    def ToAutoDiffXdMaybe(self) -> System_TAutoDiffXdU: ...
    def ToScalarTypeMaybe𝓣AutoDiffXd𝓤(self) -> System_TAutoDiffXdU: ...
    def ToScalarTypeMaybe𝓣Expression𝓤(self) -> System_TExpressionU: ...
    def ToScalarTypeMaybe𝓣float𝓤(self) -> System: ...
    def ToScalarType𝓣AutoDiffXd𝓤(self) -> System_TAutoDiffXdU: ...
    def ToScalarType𝓣Expression𝓤(self) -> System_TExpressionU: ...
    def ToScalarType𝓣float𝓤(self) -> System: ...
    def ToSymbolic(self) -> System_TExpressionU: ...
    def ToSymbolicMaybe(self) -> System_TExpressionU: ...
    @overload
    def get_input_port(self, port_index: int, warn_deprecated: bool = ...) -> InputPort_TExpressionU: ...
    @overload
    def get_input_port(self) -> InputPort_TExpressionU: ...
    @overload
    def get_output_port(self, port_index: int, warn_deprecated: bool = ...) -> OutputPort_TExpressionU: ...
    @overload
    def get_output_port(self) -> OutputPort_TExpressionU: ...
    def get_system_scalar_converter(self) -> SystemScalarConverter: ...
    def num_constraints(self) -> int: ...
    def __copy__(self) -> System_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> System_TExpressionU: ...

class TriggerType:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kForced: ClassVar[TriggerType] = ...
    kInitialization: ClassVar[TriggerType] = ...
    kPerStep: ClassVar[TriggerType] = ...
    kPeriodic: ClassVar[TriggerType] = ...
    kTimed: ClassVar[TriggerType] = ...
    kUnknown: ClassVar[TriggerType] = ...
    kWitness: ClassVar[TriggerType] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class UnrestrictedUpdateEvent(Event):
    @overload
    def __init__(self, callback: Callable[[Context, UnrestrictedUpdateEvent, State], EventStatus | None]) -> None: ...
    @overload
    def __init__(self, system_callback) -> None: ...

class UnrestrictedUpdateEvent_𝓣AutoDiffXd𝓤(Event_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, callback: Callable[[Context_TAutoDiffXdU, UnrestrictedUpdateEvent_TAutoDiffXdU, State_TAutoDiffXdU], EventStatus | None]) -> None: ...
    @overload
    def __init__(self, system_callback) -> None: ...

class UnrestrictedUpdateEvent_𝓣Expression𝓤(Event_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, callback: Callable[[Context_TExpressionU, UnrestrictedUpdateEvent_TExpressionU, State_TExpressionU], EventStatus | None]) -> None: ...
    @overload
    def __init__(self, system_callback) -> None: ...

class UseDefaultName:
    def __init__(self, *args, **kwargs) -> None: ...

class ValueProducer:
    def __init__(self, allocate: Callable, calc: Callable[[object, object], None]) -> None: ...
    @staticmethod
    def NoopCalc(arg0: ContextBase, arg1: pydrake.common.value.AbstractValue) -> None: ...

class VectorBase:
    def __init__(self, *args, **kwargs) -> None: ...
    def CopyToVector(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetAtIndex(self, index: int) -> float: ...
    def PlusEqScaled(self, scale: float, rhs: VectorBase) -> VectorBase: ...
    def SetAtIndex(self, index: int, value: float) -> None: ...
    def SetFrom(self, value: VectorBase) -> None: ...
    def SetFromVector(self, value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def SetZero(self) -> None: ...
    def size(self) -> int: ...
    def __getitem__(self, arg0: int) -> float: ...
    def __iter__(self) -> typing.Iterator[float]: ...
    def __setitem__(self, arg0: int, arg1: float) -> None: ...

class VectorBase_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def CopyToVector(self) -> numpy.ndarray[object[m, 1]]: ...
    def GetAtIndex(self, index: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    def PlusEqScaled(self, scale: pydrake.autodiffutils.AutoDiffXd, rhs: VectorBase_TAutoDiffXdU) -> VectorBase_TAutoDiffXdU: ...
    def SetAtIndex(self, index: int, value: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def SetFrom(self, value: VectorBase_TAutoDiffXdU) -> None: ...
    def SetFromVector(self, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetZero(self) -> None: ...
    def size(self) -> int: ...
    def __getitem__(self, arg0: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    def __iter__(self) -> typing.Iterator[pydrake.autodiffutils.AutoDiffXd]: ...
    def __setitem__(self, arg0: int, arg1: pydrake.autodiffutils.AutoDiffXd) -> None: ...

class VectorBase_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def CopyToVector(self) -> numpy.ndarray[object[m, 1]]: ...
    def GetAtIndex(self, index: int) -> pydrake.symbolic.Expression: ...
    def PlusEqScaled(self, scale: pydrake.symbolic.Expression, rhs: VectorBase_TExpressionU) -> VectorBase_TExpressionU: ...
    def SetAtIndex(self, index: int, value: pydrake.symbolic.Expression) -> None: ...
    def SetFrom(self, value: VectorBase_TExpressionU) -> None: ...
    def SetFromVector(self, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetZero(self) -> None: ...
    def size(self) -> int: ...
    def __getitem__(self, arg0: int) -> pydrake.symbolic.Expression: ...
    def __iter__(self) -> typing.Iterator[pydrake.symbolic.Expression]: ...
    def __setitem__(self, arg0: int, arg1: pydrake.symbolic.Expression) -> None: ...

class VectorSystem(LeafSystem):
    def __init__(self, input_size: int, output_size: int, direct_feedthrough: bool | None) -> None: ...

class VectorSystem_𝓣AutoDiffXd𝓤(LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, input_size: int, output_size: int, direct_feedthrough: bool | None) -> None: ...

class VectorSystem_𝓣Expression𝓤(LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, input_size: int, output_size: int, direct_feedthrough: bool | None) -> None: ...

class WitnessFunction:
    def __init__(self, *args, **kwargs) -> None: ...

class WitnessFunctionDirection:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kCrossesZero: ClassVar[WitnessFunctionDirection] = ...
    kNegativeThenNonNegative: ClassVar[WitnessFunctionDirection] = ...
    kNone: ClassVar[WitnessFunctionDirection] = ...
    kPositiveThenNonPositive: ClassVar[WitnessFunctionDirection] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class WitnessFunction_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class WitnessFunction_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _ExternalSystemConstraint:
    def __init__(self) -> None: ...

class _TemporaryName_N5drake7systems10LeafSystemIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(System_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, converter: SystemScalarConverter) -> None: ...
    def DeclareAbstractInputPort(self, name: str, model_value: pydrake.common.value.AbstractValue) -> InputPort_TAutoDiffXdU: ...
    def DeclareAbstractOutputPort(self, name: str, alloc: Callable, calc: Callable[[object, object], None], prerequisites_of_calc: set[DependencyTicket] = ...) -> OutputPort_TAutoDiffXdU: ...
    def DeclareAbstractParameter(self, model_value: pydrake.common.value.AbstractValue) -> int: ...
    def DeclareAbstractState(self, model_value: pydrake.common.value.AbstractValue) -> AbstractStateIndex: ...
    @overload
    def DeclareContinuousState(self, num_state_variables: int) -> ContinuousStateIndex: ...
    @overload
    def DeclareContinuousState(self, num_q: int, num_v: int, num_z: int) -> ContinuousStateIndex: ...
    @overload
    def DeclareContinuousState(self, model_vector: BasicVector_TAutoDiffXdU) -> ContinuousStateIndex: ...
    @overload
    def DeclareContinuousState(self, model_vector: BasicVector_TAutoDiffXdU, num_q: int, num_v: int, num_z: int) -> ContinuousStateIndex: ...
    @overload
    def DeclareDiscreteState(self, model_vector: BasicVector_TAutoDiffXdU) -> DiscreteStateIndex: ...
    @overload
    def DeclareDiscreteState(self, vector: numpy.ndarray[object[m, 1]]) -> DiscreteStateIndex: ...
    @overload
    def DeclareDiscreteState(self, num_state_variables: int) -> DiscreteStateIndex: ...
    @overload
    def DeclareDiscreteState(self) -> Any: ...
    @overload
    def DeclareForcedDiscreteUpdateEvent(self, update: Callable[[Context_TAutoDiffXdU, DiscreteValues_TAutoDiffXdU], EventStatus | None]) -> None: ...
    @overload
    def DeclareForcedDiscreteUpdateEvent(self) -> Any: ...
    @overload
    def DeclareForcedPublishEvent(self, publish: Callable[[Context_TAutoDiffXdU], EventStatus | None]) -> None: ...
    @overload
    def DeclareForcedPublishEvent(self) -> Any: ...
    @overload
    def DeclareForcedUnrestrictedUpdateEvent(self, update: Callable[[Context_TAutoDiffXdU, State_TAutoDiffXdU], EventStatus | None]) -> None: ...
    @overload
    def DeclareForcedUnrestrictedUpdateEvent(self) -> Any: ...
    def DeclareInitializationDiscreteUpdateEvent(self, update: Callable[[Context_TAutoDiffXdU, DiscreteValues_TAutoDiffXdU], EventStatus | None]) -> None: ...
    def DeclareInitializationEvent(self, event: Event_TAutoDiffXdU) -> None: ...
    def DeclareInitializationPublishEvent(self, publish: Callable[[Context_TAutoDiffXdU], EventStatus | None]) -> None: ...
    def DeclareInitializationUnrestrictedUpdateEvent(self, update: Callable[[Context_TAutoDiffXdU, State_TAutoDiffXdU], EventStatus | None]) -> None: ...
    def DeclareNumericParameter(self, model_vector: BasicVector_TAutoDiffXdU) -> int: ...
    def DeclarePerStepDiscreteUpdateEvent(self, update: Callable[[Context_TAutoDiffXdU, DiscreteValues_TAutoDiffXdU], EventStatus | None]) -> None: ...
    def DeclarePerStepEvent(self, event: Event_TAutoDiffXdU) -> None: ...
    def DeclarePerStepPublishEvent(self, publish: Callable[[Context_TAutoDiffXdU], EventStatus | None]) -> None: ...
    def DeclarePerStepUnrestrictedUpdateEvent(self, update: Callable[[Context_TAutoDiffXdU, State_TAutoDiffXdU], EventStatus | None]) -> None: ...
    def DeclarePeriodicDiscreteUpdateEvent(self, period_sec: float, offset_sec: float, update: Callable[[Context_TAutoDiffXdU, DiscreteValues_TAutoDiffXdU], EventStatus | None]) -> None: ...
    def DeclarePeriodicEvent(self, period_sec: float, offset_sec: float, event: Event_TAutoDiffXdU) -> None: ...
    def DeclarePeriodicPublishEvent(self, period_sec: float, offset_sec: float, publish: Callable[[Context_TAutoDiffXdU], EventStatus | None]) -> None: ...
    def DeclarePeriodicUnrestrictedUpdateEvent(self, period_sec: float, offset_sec: float, update: Callable[[Context_TAutoDiffXdU, State_TAutoDiffXdU], EventStatus | None]) -> None: ...
    @overload
    def DeclareStateOutputPort(self, name: str | UseDefaultName, state_index: ContinuousStateIndex) -> LeafOutputPort_TAutoDiffXdU: ...
    @overload
    def DeclareStateOutputPort(self, name: str | UseDefaultName, state_index: DiscreteStateIndex) -> LeafOutputPort_TAutoDiffXdU: ...
    @overload
    def DeclareStateOutputPort(self, name: str | UseDefaultName, state_index: AbstractStateIndex) -> LeafOutputPort_TAutoDiffXdU: ...
    def DeclareVectorInputPort(self, name: str, model_vector: BasicVector_TAutoDiffXdU, random_type: pydrake.common.RandomDistribution | None = ...) -> InputPort_TAutoDiffXdU: ...
    def DeclareVectorOutputPort(self, name: str, model_value: BasicVector_TAutoDiffXdU, calc: Callable[[Context_TAutoDiffXdU, BasicVector_TAutoDiffXdU], None], prerequisites_of_calc: set[DependencyTicket] = ...) -> OutputPort_TAutoDiffXdU: ...
    def DoCalcTimeDerivatives(self, arg0: Context_TAutoDiffXdU, arg1: ContinuousState_TAutoDiffXdU) -> None: ...
    @overload
    def MakeWitnessFunction(self, description: str, direction_type: WitnessFunctionDirection, calc: Callable[[Context_TAutoDiffXdU], pydrake.autodiffutils.AutoDiffXd | None]) -> WitnessFunction_TAutoDiffXdU: ...
    @overload
    def MakeWitnessFunction(self, description: str, direction_type: WitnessFunctionDirection, calc: Callable[[Context_TAutoDiffXdU], pydrake.autodiffutils.AutoDiffXd], e: Event_TAutoDiffXdU) -> WitnessFunction_TAutoDiffXdU: ...

class _TemporaryName_N5drake7systems10LeafSystemINS_8symbolic10ExpressionEEE(System_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, converter: SystemScalarConverter) -> None: ...
    def DeclareAbstractInputPort(self, name: str, model_value: pydrake.common.value.AbstractValue) -> InputPort_TExpressionU: ...
    def DeclareAbstractOutputPort(self, name: str, alloc: Callable, calc: Callable[[object, object], None], prerequisites_of_calc: set[DependencyTicket] = ...) -> OutputPort_TExpressionU: ...
    def DeclareAbstractParameter(self, model_value: pydrake.common.value.AbstractValue) -> int: ...
    def DeclareAbstractState(self, model_value: pydrake.common.value.AbstractValue) -> AbstractStateIndex: ...
    @overload
    def DeclareContinuousState(self, num_state_variables: int) -> ContinuousStateIndex: ...
    @overload
    def DeclareContinuousState(self, num_q: int, num_v: int, num_z: int) -> ContinuousStateIndex: ...
    @overload
    def DeclareContinuousState(self, model_vector: BasicVector_TExpressionU) -> ContinuousStateIndex: ...
    @overload
    def DeclareContinuousState(self, model_vector: BasicVector_TExpressionU, num_q: int, num_v: int, num_z: int) -> ContinuousStateIndex: ...
    @overload
    def DeclareDiscreteState(self, model_vector: BasicVector_TExpressionU) -> DiscreteStateIndex: ...
    @overload
    def DeclareDiscreteState(self, vector: numpy.ndarray[object[m, 1]]) -> DiscreteStateIndex: ...
    @overload
    def DeclareDiscreteState(self, num_state_variables: int) -> DiscreteStateIndex: ...
    @overload
    def DeclareDiscreteState(self) -> Any: ...
    @overload
    def DeclareForcedDiscreteUpdateEvent(self, update: Callable[[Context_TExpressionU, DiscreteValues_TExpressionU], EventStatus | None]) -> None: ...
    @overload
    def DeclareForcedDiscreteUpdateEvent(self) -> Any: ...
    @overload
    def DeclareForcedPublishEvent(self, publish: Callable[[Context_TExpressionU], EventStatus | None]) -> None: ...
    @overload
    def DeclareForcedPublishEvent(self) -> Any: ...
    @overload
    def DeclareForcedUnrestrictedUpdateEvent(self, update: Callable[[Context_TExpressionU, State_TExpressionU], EventStatus | None]) -> None: ...
    @overload
    def DeclareForcedUnrestrictedUpdateEvent(self) -> Any: ...
    def DeclareInitializationDiscreteUpdateEvent(self, update: Callable[[Context_TExpressionU, DiscreteValues_TExpressionU], EventStatus | None]) -> None: ...
    def DeclareInitializationEvent(self, event: Event_TExpressionU) -> None: ...
    def DeclareInitializationPublishEvent(self, publish: Callable[[Context_TExpressionU], EventStatus | None]) -> None: ...
    def DeclareInitializationUnrestrictedUpdateEvent(self, update: Callable[[Context_TExpressionU, State_TExpressionU], EventStatus | None]) -> None: ...
    def DeclareNumericParameter(self, model_vector: BasicVector_TExpressionU) -> int: ...
    def DeclarePerStepDiscreteUpdateEvent(self, update: Callable[[Context_TExpressionU, DiscreteValues_TExpressionU], EventStatus | None]) -> None: ...
    def DeclarePerStepEvent(self, event: Event_TExpressionU) -> None: ...
    def DeclarePerStepPublishEvent(self, publish: Callable[[Context_TExpressionU], EventStatus | None]) -> None: ...
    def DeclarePerStepUnrestrictedUpdateEvent(self, update: Callable[[Context_TExpressionU, State_TExpressionU], EventStatus | None]) -> None: ...
    def DeclarePeriodicDiscreteUpdateEvent(self, period_sec: float, offset_sec: float, update: Callable[[Context_TExpressionU, DiscreteValues_TExpressionU], EventStatus | None]) -> None: ...
    def DeclarePeriodicEvent(self, period_sec: float, offset_sec: float, event: Event_TExpressionU) -> None: ...
    def DeclarePeriodicPublishEvent(self, period_sec: float, offset_sec: float, publish: Callable[[Context_TExpressionU], EventStatus | None]) -> None: ...
    def DeclarePeriodicUnrestrictedUpdateEvent(self, period_sec: float, offset_sec: float, update: Callable[[Context_TExpressionU, State_TExpressionU], EventStatus | None]) -> None: ...
    @overload
    def DeclareStateOutputPort(self, name: str | UseDefaultName, state_index: ContinuousStateIndex) -> LeafOutputPort_TExpressionU: ...
    @overload
    def DeclareStateOutputPort(self, name: str | UseDefaultName, state_index: DiscreteStateIndex) -> LeafOutputPort_TExpressionU: ...
    @overload
    def DeclareStateOutputPort(self, name: str | UseDefaultName, state_index: AbstractStateIndex) -> LeafOutputPort_TExpressionU: ...
    def DeclareVectorInputPort(self, name: str, model_vector: BasicVector_TExpressionU, random_type: pydrake.common.RandomDistribution | None = ...) -> InputPort_TExpressionU: ...
    def DeclareVectorOutputPort(self, name: str, model_value: BasicVector_TExpressionU, calc: Callable[[Context_TExpressionU, BasicVector_TExpressionU], None], prerequisites_of_calc: set[DependencyTicket] = ...) -> OutputPort_TExpressionU: ...
    def DoCalcTimeDerivatives(self, arg0: Context_TExpressionU, arg1: ContinuousState_TExpressionU) -> None: ...
    @overload
    def MakeWitnessFunction(self, description: str, direction_type: WitnessFunctionDirection, calc: Callable[[Context_TExpressionU], pydrake.symbolic.Expression | None]) -> WitnessFunction_TExpressionU: ...
    @overload
    def MakeWitnessFunction(self, description: str, direction_type: WitnessFunctionDirection, calc: Callable[[Context_TExpressionU], pydrake.symbolic.Expression], e: Event_TExpressionU) -> WitnessFunction_TExpressionU: ...

class _TemporaryName_N5drake7systems10OutputPortIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Allocate(self) -> pydrake.common.value.AbstractValue: ...
    def Eval(self, arg0: Context_TAutoDiffXdU) -> object: ...
    def EvalAbstract(self, context: Context_TAutoDiffXdU) -> object: ...
    def EvalBasicVector(self, context: Context_TAutoDiffXdU) -> object: ...
    def get_data_type(self) -> PortDataType: ...
    def get_index(self) -> OutputPortIndex: ...
    def get_name(self) -> str: ...
    def get_system(self) -> object: ...
    def size(self) -> int: ...

class _TemporaryName_N5drake7systems10OutputPortINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Allocate(self) -> pydrake.common.value.AbstractValue: ...
    def Eval(self, arg0: Context_TExpressionU) -> object: ...
    def EvalAbstract(self, context: Context_TExpressionU) -> object: ...
    def EvalBasicVector(self, context: Context_TExpressionU) -> object: ...
    def get_data_type(self) -> PortDataType: ...
    def get_index(self) -> OutputPortIndex: ...
    def get_name(self) -> str: ...
    def get_system(self) -> object: ...
    def size(self) -> int: ...

class _TemporaryName_N5drake7systems10ParametersIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, numeric: list[BasicVector_TAutoDiffXdU], abstract: list[pydrake.common.value.AbstractValue]) -> None: ...
    @overload
    def __init__(self, numeric: list[BasicVector_TAutoDiffXdU]) -> None: ...
    @overload
    def __init__(self, abstract: list[pydrake.common.value.AbstractValue]) -> None: ...
    @overload
    def __init__(self, vec: BasicVector_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, value: pydrake.common.value.AbstractValue) -> None: ...
    def Clone(self) -> Parameters_TAutoDiffXdU: ...
    def SetFrom(self, arg0: Parameters) -> None: ...
    def get_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_abstract_parameters(self) -> AbstractValues: ...
    def get_mutable_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_mutable_numeric_parameter(self, index: int) -> BasicVector_TAutoDiffXdU: ...
    def get_numeric_parameter(self, index: int) -> BasicVector_TAutoDiffXdU: ...
    def get_numeric_parameters(self) -> DiscreteValues_TAutoDiffXdU: ...
    def num_abstract_parameters(self) -> int: ...
    def num_numeric_parameter_groups(self) -> int: ...
    def set_abstract_parameters(self, abstract_params: AbstractValues) -> None: ...
    def set_numeric_parameters(self, numeric_params: DiscreteValues_TAutoDiffXdU) -> None: ...
    def __copy__(self) -> Parameters_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> Parameters_TAutoDiffXdU: ...

class _TemporaryName_N5drake7systems10ParametersINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, numeric: list[BasicVector_TExpressionU], abstract: list[pydrake.common.value.AbstractValue]) -> None: ...
    @overload
    def __init__(self, numeric: list[BasicVector_TExpressionU]) -> None: ...
    @overload
    def __init__(self, abstract: list[pydrake.common.value.AbstractValue]) -> None: ...
    @overload
    def __init__(self, vec: BasicVector_TExpressionU) -> None: ...
    @overload
    def __init__(self, value: pydrake.common.value.AbstractValue) -> None: ...
    def Clone(self) -> Parameters_TExpressionU: ...
    def SetFrom(self, arg0: Parameters) -> None: ...
    def get_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_abstract_parameters(self) -> AbstractValues: ...
    def get_mutable_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_mutable_numeric_parameter(self, index: int) -> BasicVector_TExpressionU: ...
    def get_numeric_parameter(self, index: int) -> BasicVector_TExpressionU: ...
    def get_numeric_parameters(self) -> DiscreteValues_TExpressionU: ...
    def num_abstract_parameters(self) -> int: ...
    def num_numeric_parameter_groups(self) -> int: ...
    def set_abstract_parameters(self, abstract_params: AbstractValues) -> None: ...
    def set_numeric_parameters(self, numeric_params: DiscreteValues_TExpressionU) -> None: ...
    def __copy__(self) -> Parameters_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> Parameters_TExpressionU: ...

class _TemporaryName_N5drake7systems10VectorBaseIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def CopyToVector(self) -> numpy.ndarray[object[m, 1]]: ...
    def GetAtIndex(self, index: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    def PlusEqScaled(self, scale: pydrake.autodiffutils.AutoDiffXd, rhs: VectorBase_TAutoDiffXdU) -> VectorBase_TAutoDiffXdU: ...
    def SetAtIndex(self, index: int, value: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def SetFrom(self, value: VectorBase_TAutoDiffXdU) -> None: ...
    def SetFromVector(self, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetZero(self) -> None: ...
    def size(self) -> int: ...
    def __getitem__(self, arg0: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    def __iter__(self) -> typing.Iterator[pydrake.autodiffutils.AutoDiffXd]: ...
    def __setitem__(self, arg0: int, arg1: pydrake.autodiffutils.AutoDiffXd) -> None: ...

class _TemporaryName_N5drake7systems10VectorBaseINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def CopyToVector(self) -> numpy.ndarray[object[m, 1]]: ...
    def GetAtIndex(self, index: int) -> pydrake.symbolic.Expression: ...
    def PlusEqScaled(self, scale: pydrake.symbolic.Expression, rhs: VectorBase_TExpressionU) -> VectorBase_TExpressionU: ...
    def SetAtIndex(self, index: int, value: pydrake.symbolic.Expression) -> None: ...
    def SetFrom(self, value: VectorBase_TExpressionU) -> None: ...
    def SetFromVector(self, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetZero(self) -> None: ...
    def size(self) -> int: ...
    def __getitem__(self, arg0: int) -> pydrake.symbolic.Expression: ...
    def __iter__(self) -> typing.Iterator[pydrake.symbolic.Expression]: ...
    def __setitem__(self, arg0: int, arg1: pydrake.symbolic.Expression) -> None: ...

class _TemporaryName_N5drake7systems11BasicVectorIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(VectorBase_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, data: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def __init__(self, size: int) -> None: ...
    def Clone(self) -> BasicVector_TAutoDiffXdU: ...
    def get_mutable_value(self) -> numpy.ndarray[object[m, 1], flags.writeable]: ...
    def get_value(self) -> numpy.ndarray[object[m, 1]]: ...
    def set_value(self, arg0: numpy.ndarray[object[m, 1]]) -> None: ...
    def value(self) -> numpy.ndarray[object[m, 1]]: ...
    def __copy__(self) -> BasicVector_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> BasicVector_TAutoDiffXdU: ...

class _TemporaryName_N5drake7systems11BasicVectorINS_8symbolic10ExpressionEEE(VectorBase_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, data: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def __init__(self, size: int) -> None: ...
    def Clone(self) -> BasicVector_TExpressionU: ...
    def get_mutable_value(self) -> numpy.ndarray[object[m, 1], flags.writeable]: ...
    def get_value(self) -> numpy.ndarray[object[m, 1]]: ...
    def set_value(self, arg0: numpy.ndarray[object[m, 1]]) -> None: ...
    def value(self) -> numpy.ndarray[object[m, 1]]: ...
    def __copy__(self) -> BasicVector_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> BasicVector_TExpressionU: ...

class _TemporaryName_N5drake7systems11LeafContextIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Context_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake7systems11LeafContextINS_8symbolic10ExpressionEEE(Context_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake7systems11SupervectorIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(VectorBase_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake7systems11SupervectorINS_8symbolic10ExpressionEEE(VectorBase_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake7systems12PublishEventIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Event_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, callback: Callable[[Context_TAutoDiffXdU, PublishEvent_TAutoDiffXdU], EventStatus | None]) -> None: ...
    @overload
    def __init__(self, system_callback) -> None: ...
    @overload
    def __init__(self, trigger_type: TriggerType, callback: Callable[[Context_TAutoDiffXdU, PublishEvent_TAutoDiffXdU], EventStatus | None]) -> None: ...
    @overload
    def __init__(self, trigger_type: TriggerType, system_callback) -> None: ...

class _TemporaryName_N5drake7systems12PublishEventINS_8symbolic10ExpressionEEE(Event_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, callback: Callable[[Context_TExpressionU, PublishEvent_TExpressionU], EventStatus | None]) -> None: ...
    @overload
    def __init__(self, system_callback) -> None: ...
    @overload
    def __init__(self, trigger_type: TriggerType, callback: Callable[[Context_TExpressionU, PublishEvent_TExpressionU], EventStatus | None]) -> None: ...
    @overload
    def __init__(self, trigger_type: TriggerType, system_callback) -> None: ...

class _TemporaryName_N5drake7systems12SystemOutputIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def get_data(self, arg0: int) -> pydrake.common.value.AbstractValue: ...
    def get_vector_data(self, arg0: int) -> BasicVector_TAutoDiffXdU: ...
    def num_ports(self) -> int: ...

class _TemporaryName_N5drake7systems12SystemOutputINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def get_data(self, arg0: int) -> pydrake.common.value.AbstractValue: ...
    def get_vector_data(self, arg0: int) -> BasicVector_TExpressionU: ...
    def num_ports(self) -> int: ...

class _TemporaryName_N5drake7systems12VectorSystemIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, input_size: int, output_size: int, direct_feedthrough: bool | None) -> None: ...

class _TemporaryName_N5drake7systems12VectorSystemINS_8symbolic10ExpressionEEE(LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, input_size: int, output_size: int, direct_feedthrough: bool | None) -> None: ...

class _TemporaryName_N5drake7systems13SystemVisitorIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def VisitDiagram(self, diagram: Diagram_TAutoDiffXdU) -> None: ...
    def VisitSystem(self, system: System_TAutoDiffXdU) -> None: ...

class _TemporaryName_N5drake7systems13SystemVisitorINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def VisitDiagram(self, diagram: Diagram_TExpressionU) -> None: ...
    def VisitSystem(self, system: System_TExpressionU) -> None: ...

class _TemporaryName_N5drake7systems14DiagramBuilderIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def AddNamedSystem(self, name: str, system: System_TAutoDiffXdU) -> System_TAutoDiffXdU: ...
    def AddSystem(self, system: System_TAutoDiffXdU) -> System_TAutoDiffXdU: ...
    def Build(self) -> Diagram_TAutoDiffXdU: ...
    def BuildInto(self, target: Diagram_TAutoDiffXdU) -> None: ...
    def Connect(self, arg0: OutputPort_TAutoDiffXdU, arg1: InputPort_TAutoDiffXdU) -> None: ...
    @overload
    def ConnectInput(self, diagram_port_name: str, input: InputPort_TAutoDiffXdU) -> None: ...
    @overload
    def ConnectInput(self, diagram_port_index: InputPortIndex, input: InputPort_TAutoDiffXdU) -> None: ...
    def ConnectToSame(self, exemplar: InputPort_TAutoDiffXdU, dest: InputPort_TAutoDiffXdU) -> bool: ...
    def Disconnect(self, source: OutputPort_TAutoDiffXdU, dest: InputPort_TAutoDiffXdU) -> None: ...
    def ExportInput(self, input: InputPort_TAutoDiffXdU, name: str | UseDefaultName = ...) -> InputPortIndex: ...
    def ExportOutput(self, output: OutputPort_TAutoDiffXdU, name: str | UseDefaultName = ...) -> OutputPortIndex: ...
    def GetMutableSubsystemByName(self, name: str) -> System_TAutoDiffXdU: ...
    def GetMutableSystems(self) -> list[System_TAutoDiffXdU]: ...
    def GetSubsystemByName(self, name: str) -> System_TAutoDiffXdU: ...
    def GetSystems(self) -> list[System_TAutoDiffXdU]: ...
    def HasSubsystemNamed(self, name: str) -> bool: ...
    def IsConnectedOrExported(self, port: InputPort_TAutoDiffXdU) -> bool: ...
    def RemoveSystem(self, system: System_TAutoDiffXdU) -> None: ...
    def already_built(self) -> bool: ...
    def connection_map(self) -> dict: ...
    def empty(self) -> bool: ...
    def num_input_ports(self) -> int: ...
    def num_output_ports(self) -> int: ...

class _TemporaryName_N5drake7systems14DiagramBuilderINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def AddNamedSystem(self, name: str, system: System_TExpressionU) -> System_TExpressionU: ...
    def AddSystem(self, system: System_TExpressionU) -> System_TExpressionU: ...
    def Build(self) -> Diagram_TExpressionU: ...
    def BuildInto(self, target: Diagram_TExpressionU) -> None: ...
    def Connect(self, arg0: OutputPort_TExpressionU, arg1: InputPort_TExpressionU) -> None: ...
    @overload
    def ConnectInput(self, diagram_port_name: str, input: InputPort_TExpressionU) -> None: ...
    @overload
    def ConnectInput(self, diagram_port_index: InputPortIndex, input: InputPort_TExpressionU) -> None: ...
    def ConnectToSame(self, exemplar: InputPort_TExpressionU, dest: InputPort_TExpressionU) -> bool: ...
    def Disconnect(self, source: OutputPort_TExpressionU, dest: InputPort_TExpressionU) -> None: ...
    def ExportInput(self, input: InputPort_TExpressionU, name: str | UseDefaultName = ...) -> InputPortIndex: ...
    def ExportOutput(self, output: OutputPort_TExpressionU, name: str | UseDefaultName = ...) -> OutputPortIndex: ...
    def GetMutableSubsystemByName(self, name: str) -> System_TExpressionU: ...
    def GetMutableSystems(self) -> list[System_TExpressionU]: ...
    def GetSubsystemByName(self, name: str) -> System_TExpressionU: ...
    def GetSystems(self) -> list[System_TExpressionU]: ...
    def HasSubsystemNamed(self, name: str) -> bool: ...
    def IsConnectedOrExported(self, port: InputPort_TExpressionU) -> bool: ...
    def RemoveSystem(self, system: System_TExpressionU) -> None: ...
    def already_built(self) -> bool: ...
    def connection_map(self) -> dict: ...
    def empty(self) -> bool: ...
    def num_input_ports(self) -> int: ...
    def num_output_ports(self) -> int: ...

class _TemporaryName_N5drake7systems14DiscreteValuesIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, datum: BasicVector_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, data: list[BasicVector_TAutoDiffXdU]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def Clone(self) -> DiscreteValues_TAutoDiffXdU: ...
    def SetFrom(self, arg0: DiscreteValues) -> None: ...
    def get_data(self) -> list[BasicVector_TAutoDiffXdU]: ...
    def get_mutable_value(self, index: int = ...) -> numpy.ndarray[object[m, 1], flags.writeable]: ...
    def get_mutable_vector(self, index: int = ...) -> BasicVector_TAutoDiffXdU: ...
    def get_value(self, index: int = ...) -> numpy.ndarray[object[m, 1]]: ...
    def get_vector(self, index: int = ...) -> BasicVector_TAutoDiffXdU: ...
    def num_groups(self) -> int: ...
    @overload
    def set_value(self, value: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def set_value(self, index: int, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def size(self) -> int: ...
    def value(self, index: int = ...) -> numpy.ndarray[object[m, 1]]: ...
    def __copy__(self) -> DiscreteValues_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> DiscreteValues_TAutoDiffXdU: ...
    def __getitem__(self, arg0: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    def __iter__(self) -> typing.Iterator[pydrake.autodiffutils.AutoDiffXd]: ...
    def __setitem__(self, arg0: int, arg1: pydrake.autodiffutils.AutoDiffXd) -> None: ...

class _TemporaryName_N5drake7systems14DiscreteValuesINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, datum: BasicVector_TExpressionU) -> None: ...
    @overload
    def __init__(self, data: list[BasicVector_TExpressionU]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def Clone(self) -> DiscreteValues_TExpressionU: ...
    def SetFrom(self, arg0: DiscreteValues) -> None: ...
    def get_data(self) -> list[BasicVector_TExpressionU]: ...
    def get_mutable_value(self, index: int = ...) -> numpy.ndarray[object[m, 1], flags.writeable]: ...
    def get_mutable_vector(self, index: int = ...) -> BasicVector_TExpressionU: ...
    def get_value(self, index: int = ...) -> numpy.ndarray[object[m, 1]]: ...
    def get_vector(self, index: int = ...) -> BasicVector_TExpressionU: ...
    def num_groups(self) -> int: ...
    @overload
    def set_value(self, value: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def set_value(self, index: int, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def size(self) -> int: ...
    def value(self, index: int = ...) -> numpy.ndarray[object[m, 1]]: ...
    def __copy__(self) -> DiscreteValues_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> DiscreteValues_TExpressionU: ...
    def __getitem__(self, arg0: int) -> pydrake.symbolic.Expression: ...
    def __iter__(self) -> typing.Iterator[pydrake.symbolic.Expression]: ...
    def __setitem__(self, arg0: int, arg1: pydrake.symbolic.Expression) -> None: ...

class _TemporaryName_N5drake7systems14LeafOutputPortIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(OutputPort_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def cache_entry(self) -> CacheEntry: ...
    @overload
    def disable_caching_by_default(self) -> None: ...
    @overload
    def disable_caching_by_default(self) -> Any: ...

class _TemporaryName_N5drake7systems14LeafOutputPortINS_8symbolic10ExpressionEEE(OutputPort_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def cache_entry(self) -> CacheEntry: ...
    @overload
    def disable_caching_by_default(self) -> None: ...
    @overload
    def disable_caching_by_default(self) -> Any: ...

class _TemporaryName_N5drake7systems15ContinuousStateIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, state: BasicVector_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, state: BasicVector_TAutoDiffXdU, num_q: int, num_v: int, num_z: int) -> None: ...
    @overload
    def __init__(self, state: VectorBase_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, state: VectorBase_TAutoDiffXdU, num_q: int, num_v: int, num_z: int) -> None: ...
    def Clone(self) -> ContinuousState_TAutoDiffXdU: ...
    def CopyToVector(self) -> numpy.ndarray[object[m, 1]]: ...
    def SetFrom(self, arg0: ContinuousState) -> None: ...
    def SetFromVector(self, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def get_generalized_position(self) -> VectorBase_TAutoDiffXdU: ...
    def get_generalized_velocity(self) -> VectorBase_TAutoDiffXdU: ...
    def get_misc_continuous_state(self) -> VectorBase_TAutoDiffXdU: ...
    def get_mutable_generalized_position(self) -> VectorBase_TAutoDiffXdU: ...
    def get_mutable_generalized_velocity(self) -> VectorBase_TAutoDiffXdU: ...
    def get_mutable_misc_continuous_state(self) -> VectorBase_TAutoDiffXdU: ...
    def get_mutable_vector(self) -> VectorBase_TAutoDiffXdU: ...
    def get_vector(self) -> VectorBase_TAutoDiffXdU: ...
    def num_q(self) -> int: ...
    def num_v(self) -> int: ...
    def num_z(self) -> int: ...
    def size(self) -> int: ...
    def __copy__(self) -> ContinuousState_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> ContinuousState_TAutoDiffXdU: ...
    def __getitem__(self, arg0: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    def __iter__(self) -> typing.Iterator[pydrake.autodiffutils.AutoDiffXd]: ...
    def __setitem__(self, arg0: int, arg1: pydrake.autodiffutils.AutoDiffXd) -> None: ...

class _TemporaryName_N5drake7systems15ContinuousStateINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, state: BasicVector_TExpressionU) -> None: ...
    @overload
    def __init__(self, state: BasicVector_TExpressionU, num_q: int, num_v: int, num_z: int) -> None: ...
    @overload
    def __init__(self, state: VectorBase_TExpressionU) -> None: ...
    @overload
    def __init__(self, state: VectorBase_TExpressionU, num_q: int, num_v: int, num_z: int) -> None: ...
    def Clone(self) -> ContinuousState_TExpressionU: ...
    def CopyToVector(self) -> numpy.ndarray[object[m, 1]]: ...
    def SetFrom(self, arg0: ContinuousState) -> None: ...
    def SetFromVector(self, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def get_generalized_position(self) -> VectorBase_TExpressionU: ...
    def get_generalized_velocity(self) -> VectorBase_TExpressionU: ...
    def get_misc_continuous_state(self) -> VectorBase_TExpressionU: ...
    def get_mutable_generalized_position(self) -> VectorBase_TExpressionU: ...
    def get_mutable_generalized_velocity(self) -> VectorBase_TExpressionU: ...
    def get_mutable_misc_continuous_state(self) -> VectorBase_TExpressionU: ...
    def get_mutable_vector(self) -> VectorBase_TExpressionU: ...
    def get_vector(self) -> VectorBase_TExpressionU: ...
    def num_q(self) -> int: ...
    def num_v(self) -> int: ...
    def num_z(self) -> int: ...
    def size(self) -> int: ...
    def __copy__(self) -> ContinuousState_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> ContinuousState_TExpressionU: ...
    def __getitem__(self, arg0: int) -> pydrake.symbolic.Expression: ...
    def __iter__(self) -> typing.Iterator[pydrake.symbolic.Expression]: ...
    def __setitem__(self, arg0: int, arg1: pydrake.symbolic.Expression) -> None: ...

class _TemporaryName_N5drake7systems15WitnessFunctionIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake7systems15WitnessFunctionINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake7systems19DiscreteUpdateEventIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Event_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake7systems19DiscreteUpdateEventINS_8symbolic10ExpressionEEE(Event_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake7systems23UnrestrictedUpdateEventIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Event_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, callback: Callable[[Context_TAutoDiffXdU, UnrestrictedUpdateEvent_TAutoDiffXdU, State_TAutoDiffXdU], EventStatus | None]) -> None: ...
    @overload
    def __init__(self, system_callback) -> None: ...

class _TemporaryName_N5drake7systems23UnrestrictedUpdateEventINS_8symbolic10ExpressionEEE(Event_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, callback: Callable[[Context_TExpressionU, UnrestrictedUpdateEvent_TExpressionU, State_TExpressionU], EventStatus | None]) -> None: ...
    @overload
    def __init__(self, system_callback) -> None: ...

class _TemporaryName_N5drake7systems5EventIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def get_trigger_type(self) -> TriggerType: ...

class _TemporaryName_N5drake7systems5EventINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def get_trigger_type(self) -> TriggerType: ...

class _TemporaryName_N5drake7systems5StateIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def get_abstract_state(self) -> AbstractValues: ...
    def get_continuous_state(self) -> ContinuousState_TAutoDiffXdU: ...
    def get_discrete_state(self) -> DiscreteValues_TAutoDiffXdU: ...
    @overload
    def get_mutable_abstract_state(self) -> AbstractValues: ...
    @overload
    def get_mutable_abstract_state(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_mutable_continuous_state(self) -> ContinuousState_TAutoDiffXdU: ...
    @overload
    def get_mutable_discrete_state(self) -> DiscreteValues_TAutoDiffXdU: ...
    @overload
    def get_mutable_discrete_state(self, index: int) -> BasicVector_TAutoDiffXdU: ...

class _TemporaryName_N5drake7systems5StateINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def get_abstract_state(self) -> AbstractValues: ...
    def get_continuous_state(self) -> ContinuousState_TExpressionU: ...
    def get_discrete_state(self) -> DiscreteValues_TExpressionU: ...
    @overload
    def get_mutable_abstract_state(self) -> AbstractValues: ...
    @overload
    def get_mutable_abstract_state(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_mutable_continuous_state(self) -> ContinuousState_TExpressionU: ...
    @overload
    def get_mutable_discrete_state(self) -> DiscreteValues_TExpressionU: ...
    @overload
    def get_mutable_discrete_state(self, index: int) -> BasicVector_TExpressionU: ...

class _TemporaryName_N5drake7systems6SystemIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(SystemBase):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    ToScalarType: Incomplete
    ToScalarTypeMaybe: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...
    def Accept(self, v: SystemVisitor_TAutoDiffXdU) -> None: ...
    def AllocateContext(self) -> Context_TAutoDiffXdU: ...
    def AllocateDiscreteVariables(self) -> DiscreteValues_TAutoDiffXdU: ...
    def AllocateImplicitTimeDerivativesResidual(self) -> numpy.ndarray[object[m, 1]]: ...
    def AllocateInputAbstract(self, input_port: InputPort_TAutoDiffXdU) -> pydrake.common.value.AbstractValue: ...
    def AllocateInputVector(self, input_port: InputPort_TAutoDiffXdU) -> BasicVector_TAutoDiffXdU: ...
    def AllocateOutput(self) -> SystemOutput_TAutoDiffXdU: ...
    def AllocateTimeDerivatives(self) -> ContinuousState_TAutoDiffXdU: ...
    def CalcConservativePower(self, context: Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def CalcForcedDiscreteVariableUpdate(self, context: Context_TAutoDiffXdU, discrete_state: DiscreteValues_TAutoDiffXdU) -> None: ...
    def CalcForcedUnrestrictedUpdate(self, context: Context_TAutoDiffXdU, state: State_TAutoDiffXdU) -> None: ...
    @overload
    def CalcImplicitTimeDerivativesResidual(self, context: Context_TAutoDiffXdU, proposed_derivatives: ContinuousState_TAutoDiffXdU, residual: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    @overload
    def CalcImplicitTimeDerivativesResidual(self, context: Context_TAutoDiffXdU, proposed_derivatives: ContinuousState_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcKineticEnergy(self, context: Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def CalcNonConservativePower(self, context: Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def CalcOutput(self, context: Context_TAutoDiffXdU, outputs: SystemOutput_TAutoDiffXdU) -> None: ...
    def CalcPotentialEnergy(self, context: Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def CalcTimeDerivatives(self, context: Context_TAutoDiffXdU, derivatives: ContinuousState_TAutoDiffXdU) -> None: ...
    def Clone(self) -> System_TAutoDiffXdU: ...
    def CreateDefaultContext(self) -> Context_TAutoDiffXdU: ...
    def DeclareInputPort(self, name: str | UseDefaultName, type: PortDataType, size: int, random_type: pydrake.common.RandomDistribution | None = ...) -> InputPort_TAutoDiffXdU: ...
    def EvalAbstractInput(self, context: Context_TAutoDiffXdU, port_index: int) -> pydrake.common.value.AbstractValue: ...
    def EvalKineticEnergy(self, context: Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def EvalPotentialEnergy(self, context: Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def EvalTimeDerivatives(self, context: Context_TAutoDiffXdU) -> ContinuousState_TAutoDiffXdU: ...
    @overload
    def EvalUniquePeriodicDiscreteUpdate(self, context: Context_TAutoDiffXdU) -> DiscreteValues_TAutoDiffXdU: ...
    @overload
    def EvalUniquePeriodicDiscreteUpdate(self, context) -> Any: ...
    @overload
    def EvalUniquePeriodicDiscreteUpdate(self) -> Any: ...
    def EvalVectorInput(self, context: Context_TAutoDiffXdU, port_index: int) -> BasicVector_TAutoDiffXdU: ...
    def ExecuteForcedEvents(self, context: Context_TAutoDiffXdU, publish: bool = ...) -> None: ...
    def ExecuteInitializationEvents(self, context: Context_TAutoDiffXdU) -> None: ...
    def FixInputPortsFrom(self, other_system: System, other_context: Context, target_context: Context_TAutoDiffXdU) -> None: ...
    def ForcedPublish(self, context: Context_TAutoDiffXdU) -> None: ...
    def GetInputPort(self, port_name: str) -> InputPort_TAutoDiffXdU: ...
    def GetMutableSubsystemContext(self, subsystem: System_TAutoDiffXdU, context: Context_TAutoDiffXdU) -> Context_TAutoDiffXdU: ...
    @overload
    def GetMyContextFromRoot(self, root_context: Context_TAutoDiffXdU) -> Context_TAutoDiffXdU: ...
    @overload
    def GetMyContextFromRoot(self) -> Any: ...
    def GetMyMutableContextFromRoot(self, root_context: Context_TAutoDiffXdU) -> Context_TAutoDiffXdU: ...
    def GetOutputPort(self, port_name: str) -> OutputPort_TAutoDiffXdU: ...
    def GetSubsystemContext(self, subsystem: System_TAutoDiffXdU, context: Context_TAutoDiffXdU) -> Context_TAutoDiffXdU: ...
    def GetUniquePeriodicDiscreteUpdateAttribute(self) -> PeriodicEventData | None: ...
    @overload
    def GetWitnessFunctions(self, context: Context_TAutoDiffXdU) -> list[WitnessFunction_TAutoDiffXdU]: ...
    @overload
    def GetWitnessFunctions(self, context) -> Any: ...
    def HasAnyDirectFeedthrough(self) -> bool: ...
    @overload
    def HasDirectFeedthrough(self, output_port: int) -> bool: ...
    @overload
    def HasDirectFeedthrough(self, input_port: int, output_port: int) -> bool: ...
    def HasInputPort(self, port_name: str) -> bool: ...
    def HasOutputPort(self, port_name: str) -> bool: ...
    @overload
    def IsDifferenceEquationSystem(self) -> tuple[bool, float]: ...
    @overload
    def IsDifferenceEquationSystem(self) -> Any: ...
    def IsDifferentialEquationSystem(self) -> bool: ...
    def SetDefaultContext(self, context: Context_TAutoDiffXdU) -> None: ...
    def SetRandomContext(self, context: Context_TAutoDiffXdU, generator: pydrake.common.RandomGenerator) -> None: ...
    def ToAutoDiffXd(self) -> System_TAutoDiffXdU: ...
    def ToAutoDiffXdMaybe(self) -> System_TAutoDiffXdU: ...
    def ToScalarTypeMaybe𝓣AutoDiffXd𝓤(self) -> System_TAutoDiffXdU: ...
    def ToScalarTypeMaybe𝓣Expression𝓤(self) -> System_TExpressionU: ...
    def ToScalarTypeMaybe𝓣float𝓤(self) -> System: ...
    def ToScalarType𝓣AutoDiffXd𝓤(self) -> System_TAutoDiffXdU: ...
    def ToScalarType𝓣Expression𝓤(self) -> System_TExpressionU: ...
    def ToScalarType𝓣float𝓤(self) -> System: ...
    def ToSymbolic(self) -> System_TExpressionU: ...
    def ToSymbolicMaybe(self) -> System_TExpressionU: ...
    @overload
    def get_input_port(self, port_index: int, warn_deprecated: bool = ...) -> InputPort_TAutoDiffXdU: ...
    @overload
    def get_input_port(self) -> InputPort_TAutoDiffXdU: ...
    @overload
    def get_output_port(self, port_index: int, warn_deprecated: bool = ...) -> OutputPort_TAutoDiffXdU: ...
    @overload
    def get_output_port(self) -> OutputPort_TAutoDiffXdU: ...
    def get_system_scalar_converter(self) -> SystemScalarConverter: ...
    def num_constraints(self) -> int: ...
    def __copy__(self) -> System_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> System_TAutoDiffXdU: ...

class _TemporaryName_N5drake7systems6SystemINS_8symbolic10ExpressionEEE(SystemBase):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    ToScalarType: Incomplete
    ToScalarTypeMaybe: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...
    def Accept(self, v: SystemVisitor_TExpressionU) -> None: ...
    def AllocateContext(self) -> Context_TExpressionU: ...
    def AllocateDiscreteVariables(self) -> DiscreteValues_TExpressionU: ...
    def AllocateImplicitTimeDerivativesResidual(self) -> numpy.ndarray[object[m, 1]]: ...
    def AllocateInputAbstract(self, input_port: InputPort_TExpressionU) -> pydrake.common.value.AbstractValue: ...
    def AllocateInputVector(self, input_port: InputPort_TExpressionU) -> BasicVector_TExpressionU: ...
    def AllocateOutput(self) -> SystemOutput_TExpressionU: ...
    def AllocateTimeDerivatives(self) -> ContinuousState_TExpressionU: ...
    def CalcConservativePower(self, context: Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def CalcForcedDiscreteVariableUpdate(self, context: Context_TExpressionU, discrete_state: DiscreteValues_TExpressionU) -> None: ...
    def CalcForcedUnrestrictedUpdate(self, context: Context_TExpressionU, state: State_TExpressionU) -> None: ...
    @overload
    def CalcImplicitTimeDerivativesResidual(self, context: Context_TExpressionU, proposed_derivatives: ContinuousState_TExpressionU, residual: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    @overload
    def CalcImplicitTimeDerivativesResidual(self, context: Context_TExpressionU, proposed_derivatives: ContinuousState_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcKineticEnergy(self, context: Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def CalcNonConservativePower(self, context: Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def CalcOutput(self, context: Context_TExpressionU, outputs: SystemOutput_TExpressionU) -> None: ...
    def CalcPotentialEnergy(self, context: Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def CalcTimeDerivatives(self, context: Context_TExpressionU, derivatives: ContinuousState_TExpressionU) -> None: ...
    def Clone(self) -> System_TExpressionU: ...
    def CreateDefaultContext(self) -> Context_TExpressionU: ...
    def DeclareInputPort(self, name: str | UseDefaultName, type: PortDataType, size: int, random_type: pydrake.common.RandomDistribution | None = ...) -> InputPort_TExpressionU: ...
    def EvalAbstractInput(self, context: Context_TExpressionU, port_index: int) -> pydrake.common.value.AbstractValue: ...
    def EvalKineticEnergy(self, context: Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def EvalPotentialEnergy(self, context: Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def EvalTimeDerivatives(self, context: Context_TExpressionU) -> ContinuousState_TExpressionU: ...
    @overload
    def EvalUniquePeriodicDiscreteUpdate(self, context: Context_TExpressionU) -> DiscreteValues_TExpressionU: ...
    @overload
    def EvalUniquePeriodicDiscreteUpdate(self, context) -> Any: ...
    @overload
    def EvalUniquePeriodicDiscreteUpdate(self) -> Any: ...
    def EvalVectorInput(self, context: Context_TExpressionU, port_index: int) -> BasicVector_TExpressionU: ...
    def ExecuteForcedEvents(self, context: Context_TExpressionU, publish: bool = ...) -> None: ...
    def ExecuteInitializationEvents(self, context: Context_TExpressionU) -> None: ...
    def FixInputPortsFrom(self, other_system: System, other_context: Context, target_context: Context_TExpressionU) -> None: ...
    def ForcedPublish(self, context: Context_TExpressionU) -> None: ...
    def GetInputPort(self, port_name: str) -> InputPort_TExpressionU: ...
    def GetMutableSubsystemContext(self, subsystem: System_TExpressionU, context: Context_TExpressionU) -> Context_TExpressionU: ...
    @overload
    def GetMyContextFromRoot(self, root_context: Context_TExpressionU) -> Context_TExpressionU: ...
    @overload
    def GetMyContextFromRoot(self) -> Any: ...
    def GetMyMutableContextFromRoot(self, root_context: Context_TExpressionU) -> Context_TExpressionU: ...
    def GetOutputPort(self, port_name: str) -> OutputPort_TExpressionU: ...
    def GetSubsystemContext(self, subsystem: System_TExpressionU, context: Context_TExpressionU) -> Context_TExpressionU: ...
    def GetUniquePeriodicDiscreteUpdateAttribute(self) -> PeriodicEventData | None: ...
    @overload
    def GetWitnessFunctions(self, context: Context_TExpressionU) -> list[WitnessFunction_TExpressionU]: ...
    @overload
    def GetWitnessFunctions(self, context) -> Any: ...
    def HasAnyDirectFeedthrough(self) -> bool: ...
    @overload
    def HasDirectFeedthrough(self, output_port: int) -> bool: ...
    @overload
    def HasDirectFeedthrough(self, input_port: int, output_port: int) -> bool: ...
    def HasInputPort(self, port_name: str) -> bool: ...
    def HasOutputPort(self, port_name: str) -> bool: ...
    @overload
    def IsDifferenceEquationSystem(self) -> tuple[bool, float]: ...
    @overload
    def IsDifferenceEquationSystem(self) -> Any: ...
    def IsDifferentialEquationSystem(self) -> bool: ...
    def SetDefaultContext(self, context: Context_TExpressionU) -> None: ...
    def SetRandomContext(self, context: Context_TExpressionU, generator: pydrake.common.RandomGenerator) -> None: ...
    def ToAutoDiffXd(self) -> System_TAutoDiffXdU: ...
    def ToAutoDiffXdMaybe(self) -> System_TAutoDiffXdU: ...
    def ToScalarTypeMaybe𝓣AutoDiffXd𝓤(self) -> System_TAutoDiffXdU: ...
    def ToScalarTypeMaybe𝓣Expression𝓤(self) -> System_TExpressionU: ...
    def ToScalarTypeMaybe𝓣float𝓤(self) -> System: ...
    def ToScalarType𝓣AutoDiffXd𝓤(self) -> System_TAutoDiffXdU: ...
    def ToScalarType𝓣Expression𝓤(self) -> System_TExpressionU: ...
    def ToScalarType𝓣float𝓤(self) -> System: ...
    def ToSymbolic(self) -> System_TExpressionU: ...
    def ToSymbolicMaybe(self) -> System_TExpressionU: ...
    @overload
    def get_input_port(self, port_index: int, warn_deprecated: bool = ...) -> InputPort_TExpressionU: ...
    @overload
    def get_input_port(self) -> InputPort_TExpressionU: ...
    @overload
    def get_output_port(self, port_index: int, warn_deprecated: bool = ...) -> OutputPort_TExpressionU: ...
    @overload
    def get_output_port(self) -> OutputPort_TExpressionU: ...
    def get_system_scalar_converter(self) -> SystemScalarConverter: ...
    def num_constraints(self) -> int: ...
    def __copy__(self) -> System_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> System_TExpressionU: ...

class _TemporaryName_N5drake7systems7ContextIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(ContextBase):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Clone(self) -> Context_TAutoDiffXdU: ...
    def SetAbstractState(self, index: int, value: object) -> None: ...
    def SetAccuracy(self, accuracy: float | None) -> None: ...
    def SetContinuousState(self, arg0: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetDiscreteState(self, xd: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetDiscreteState(self, group_index: int, xd: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetDiscreteState(self, xd: DiscreteValues_TAutoDiffXdU) -> None: ...
    @overload
    def SetStateAndParametersFrom(self, source: Context) -> None: ...
    @overload
    def SetStateAndParametersFrom(self, source: Context_TAutoDiffXdU) -> None: ...
    @overload
    def SetStateAndParametersFrom(self, source: Context_TExpressionU) -> None: ...
    def SetTime(self, time_sec: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def SetTimeAndContinuousState(self, arg0: pydrake.autodiffutils.AutoDiffXd, arg1: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetTimeStateAndParametersFrom(self, source: Context) -> None: ...
    @overload
    def SetTimeStateAndParametersFrom(self, source: Context_TAutoDiffXdU) -> None: ...
    @overload
    def SetTimeStateAndParametersFrom(self, source: Context_TExpressionU) -> None: ...
    def get_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    @overload
    def get_abstract_state(self) -> AbstractValues: ...
    @overload
    def get_abstract_state(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_accuracy(self) -> float | None: ...
    def get_continuous_state(self) -> ContinuousState_TAutoDiffXdU: ...
    def get_continuous_state_vector(self) -> VectorBase_TAutoDiffXdU: ...
    @overload
    def get_discrete_state(self) -> DiscreteValues_TAutoDiffXdU: ...
    @overload
    def get_discrete_state(self, arg0: int) -> BasicVector_TAutoDiffXdU: ...
    def get_discrete_state_vector(self) -> BasicVector_TAutoDiffXdU: ...
    def get_mutable_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    @overload
    def get_mutable_abstract_state(self) -> AbstractValues: ...
    @overload
    def get_mutable_abstract_state(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_mutable_continuous_state(self) -> ContinuousState_TAutoDiffXdU: ...
    def get_mutable_continuous_state_vector(self) -> VectorBase_TAutoDiffXdU: ...
    @overload
    def get_mutable_discrete_state(self) -> DiscreteValues_TAutoDiffXdU: ...
    @overload
    def get_mutable_discrete_state(self, arg0: int) -> BasicVector_TAutoDiffXdU: ...
    def get_mutable_discrete_state_vector(self) -> BasicVector_TAutoDiffXdU: ...
    def get_mutable_numeric_parameter(self, index: int) -> BasicVector_TAutoDiffXdU: ...
    def get_mutable_parameters(self) -> Parameters_TAutoDiffXdU: ...
    def get_mutable_state(self) -> State_TAutoDiffXdU: ...
    def get_numeric_parameter(self, index: int) -> BasicVector_TAutoDiffXdU: ...
    def get_parameters(self) -> Parameters_TAutoDiffXdU: ...
    def get_state(self) -> State_TAutoDiffXdU: ...
    def get_time(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def has_only_continuous_state(self) -> bool: ...
    def has_only_discrete_state(self) -> bool: ...
    def is_stateless(self) -> bool: ...
    def num_abstract_parameters(self) -> int: ...
    def num_abstract_states(self) -> int: ...
    def num_continuous_states(self) -> int: ...
    def num_discrete_state_groups(self) -> int: ...
    def num_numeric_parameter_groups(self) -> int: ...
    def num_total_states(self) -> int: ...
    def __copy__(self) -> Context_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> Context_TAutoDiffXdU: ...

class _TemporaryName_N5drake7systems7ContextINS_8symbolic10ExpressionEEE(ContextBase):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Clone(self) -> Context_TExpressionU: ...
    def SetAbstractState(self, index: int, value: object) -> None: ...
    def SetAccuracy(self, accuracy: float | None) -> None: ...
    def SetContinuousState(self, arg0: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetDiscreteState(self, xd: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetDiscreteState(self, group_index: int, xd: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetDiscreteState(self, xd: DiscreteValues_TExpressionU) -> None: ...
    @overload
    def SetStateAndParametersFrom(self, source: Context) -> None: ...
    @overload
    def SetStateAndParametersFrom(self, source: Context_TAutoDiffXdU) -> None: ...
    @overload
    def SetStateAndParametersFrom(self, source: Context_TExpressionU) -> None: ...
    def SetTime(self, time_sec: pydrake.symbolic.Expression) -> None: ...
    def SetTimeAndContinuousState(self, arg0: pydrake.symbolic.Expression, arg1: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetTimeStateAndParametersFrom(self, source: Context) -> None: ...
    @overload
    def SetTimeStateAndParametersFrom(self, source: Context_TAutoDiffXdU) -> None: ...
    @overload
    def SetTimeStateAndParametersFrom(self, source: Context_TExpressionU) -> None: ...
    def get_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    @overload
    def get_abstract_state(self) -> AbstractValues: ...
    @overload
    def get_abstract_state(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_accuracy(self) -> float | None: ...
    def get_continuous_state(self) -> ContinuousState_TExpressionU: ...
    def get_continuous_state_vector(self) -> VectorBase_TExpressionU: ...
    @overload
    def get_discrete_state(self) -> DiscreteValues_TExpressionU: ...
    @overload
    def get_discrete_state(self, arg0: int) -> BasicVector_TExpressionU: ...
    def get_discrete_state_vector(self) -> BasicVector_TExpressionU: ...
    def get_mutable_abstract_parameter(self, index: int) -> pydrake.common.value.AbstractValue: ...
    @overload
    def get_mutable_abstract_state(self) -> AbstractValues: ...
    @overload
    def get_mutable_abstract_state(self, index: int) -> pydrake.common.value.AbstractValue: ...
    def get_mutable_continuous_state(self) -> ContinuousState_TExpressionU: ...
    def get_mutable_continuous_state_vector(self) -> VectorBase_TExpressionU: ...
    @overload
    def get_mutable_discrete_state(self) -> DiscreteValues_TExpressionU: ...
    @overload
    def get_mutable_discrete_state(self, arg0: int) -> BasicVector_TExpressionU: ...
    def get_mutable_discrete_state_vector(self) -> BasicVector_TExpressionU: ...
    def get_mutable_numeric_parameter(self, index: int) -> BasicVector_TExpressionU: ...
    def get_mutable_parameters(self) -> Parameters_TExpressionU: ...
    def get_mutable_state(self) -> State_TExpressionU: ...
    def get_numeric_parameter(self, index: int) -> BasicVector_TExpressionU: ...
    def get_parameters(self) -> Parameters_TExpressionU: ...
    def get_state(self) -> State_TExpressionU: ...
    def get_time(self) -> pydrake.symbolic.Expression: ...
    def has_only_continuous_state(self) -> bool: ...
    def has_only_discrete_state(self) -> bool: ...
    def is_stateless(self) -> bool: ...
    def num_abstract_parameters(self) -> int: ...
    def num_abstract_states(self) -> int: ...
    def num_continuous_states(self) -> int: ...
    def num_discrete_state_groups(self) -> int: ...
    def num_numeric_parameter_groups(self) -> int: ...
    def num_total_states(self) -> int: ...
    def __copy__(self) -> Context_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> Context_TExpressionU: ...

class _TemporaryName_N5drake7systems7DiagramIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(System_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def AreConnected(self, output: OutputPort_TAutoDiffXdU, input: InputPort_TAutoDiffXdU) -> bool: ...
    def GetInputPortLocators(self, port_index: InputPortIndex) -> list: ...
    def GetMutableSubsystemState(self, arg0: System_TAutoDiffXdU, arg1: Context_TAutoDiffXdU) -> State_TAutoDiffXdU: ...
    def GetSubsystemByName(self, name: str) -> System_TAutoDiffXdU: ...
    def GetSystems(self) -> list[System_TAutoDiffXdU]: ...
    def HasSubsystemNamed(self, name: str) -> bool: ...
    def connection_map(self) -> dict: ...
    def get_output_port_locator(self, port_index: OutputPortIndex) -> tuple: ...

class _TemporaryName_N5drake7systems7DiagramINS_8symbolic10ExpressionEEE(System_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def AreConnected(self, output: OutputPort_TExpressionU, input: InputPort_TExpressionU) -> bool: ...
    def GetInputPortLocators(self, port_index: InputPortIndex) -> list: ...
    def GetMutableSubsystemState(self, arg0: System_TExpressionU, arg1: Context_TExpressionU) -> State_TExpressionU: ...
    def GetSubsystemByName(self, name: str) -> System_TExpressionU: ...
    def GetSystems(self) -> list[System_TExpressionU]: ...
    def HasSubsystemNamed(self, name: str) -> bool: ...
    def connection_map(self) -> dict: ...
    def get_output_port_locator(self, port_index: OutputPortIndex) -> tuple: ...

class _TemporaryName_N5drake7systems8internal13WrappedSystemIN5Eigen14AutoDiffScalarINS3_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Diagram_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def unwrap(self) -> System_TAutoDiffXdU: ...

class _TemporaryName_N5drake7systems8internal13WrappedSystemINS_8symbolic10ExpressionEEE(Diagram_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def unwrap(self) -> System_TExpressionU: ...

class _TemporaryName_N5drake7systems9InputPortIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Allocate(self) -> pydrake.common.value.AbstractValue: ...
    def Eval(self, arg0: Context_TAutoDiffXdU) -> object: ...
    def EvalAbstract(self, context: Context_TAutoDiffXdU) -> pydrake.common.value.AbstractValue: ...
    def EvalBasicVector(self, context: Context_TAutoDiffXdU) -> object: ...
    def FixValue(self, context: Context_TAutoDiffXdU, value: pydrake.common.value.AbstractValue) -> FixedInputPortValue: ...
    def GetFullDescription(self) -> str: ...
    def HasValue(self, context: Context_TAutoDiffXdU) -> bool: ...
    def get_data_type(self) -> PortDataType: ...
    def get_index(self) -> InputPortIndex: ...
    def get_name(self) -> str: ...
    def get_system(self) -> object: ...
    def size(self) -> int: ...
    def ticket(self) -> DependencyTicket: ...

class _TemporaryName_N5drake7systems9InputPortINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Allocate(self) -> pydrake.common.value.AbstractValue: ...
    def Eval(self, arg0: Context_TExpressionU) -> object: ...
    def EvalAbstract(self, context: Context_TExpressionU) -> pydrake.common.value.AbstractValue: ...
    def EvalBasicVector(self, context: Context_TExpressionU) -> object: ...
    def FixValue(self, context: Context_TExpressionU, value: pydrake.common.value.AbstractValue) -> FixedInputPortValue: ...
    def GetFullDescription(self) -> str: ...
    def HasValue(self, context: Context_TExpressionU) -> bool: ...
    def get_data_type(self) -> PortDataType: ...
    def get_index(self) -> InputPortIndex: ...
    def get_name(self) -> str: ...
    def get_system(self) -> object: ...
    def size(self) -> int: ...
    def ticket(self) -> DependencyTicket: ...

class _TemporaryName_N5drake7systems9SubvectorIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(VectorBase_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake7systems9SubvectorINS_8symbolic10ExpressionEEE(VectorBase_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _WrappedSystem(Diagram):
    def __init__(self, *args, **kwargs) -> None: ...
    def unwrap(self) -> System: ...

class _WrappedSystem_𝓣AutoDiffXd𝓤(Diagram_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def unwrap(self) -> System_TAutoDiffXdU: ...

class _WrappedSystem_𝓣Expression𝓤(Diagram_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def unwrap(self) -> System_TExpressionU: ...
