import flags
import numpy
import pydrake.autodiffutils
import pydrake.common
import pydrake.solvers
import pydrake.symbolic
import pydrake.systems.framework
import pydrake.systems.primitives
import pydrake.trajectories
from pydrake.common.cpp_template import IntegratorBase_ as IntegratorBase_, RungeKutta2Integrator_ as RungeKutta2Integrator_, RungeKutta3Integrator_ as RungeKutta3Integrator_, Simulator_ as Simulator_
from typing import Any, Callable, ClassVar, overload

class InitializeParams:
    __fields__: ClassVar[tuple] = ...  # read-only
    suppress_initialization_events: bool
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> InitializeParams: ...
    def __deepcopy__(self, arg0: dict) -> InitializeParams: ...

class IntegratorBase:
    def __init__(self, *args, **kwargs) -> None: ...
    def GetStatisticsSummary(self) -> list[tuple[str, int | float]]: ...
    @overload
    def Initialize(self) -> None: ...
    @overload
    def Initialize(self) -> Any: ...
    @overload
    def Initialize(self) -> Any: ...
    def Reset(self) -> None: ...
    def ResetStatistics(self) -> None: ...
    def StartDenseIntegration(self) -> None: ...
    def StopDenseIntegration(self) -> pydrake.trajectories.PiecewisePolynomial: ...
    def get_actual_initial_step_size_taken(self) -> float: ...
    def get_context(self) -> pydrake.systems.framework.Context: ...
    def get_dense_output(self) -> pydrake.trajectories.PiecewisePolynomial: ...
    def get_fixed_step_mode(self) -> bool: ...
    def get_initial_step_size_target(self) -> float: ...
    def get_largest_step_size_taken(self) -> float: ...
    def get_maximum_step_size(self) -> float: ...
    def get_mutable_context(self) -> pydrake.systems.framework.Context: ...
    def get_num_derivative_evaluations(self) -> int: ...
    def get_num_step_shrinkages_from_error_control(self) -> int: ...
    def get_num_step_shrinkages_from_substep_failures(self) -> int: ...
    def get_num_steps_taken(self) -> int: ...
    def get_num_substep_failures(self) -> int: ...
    def get_requested_minimum_step_size(self) -> float: ...
    def get_smallest_adapted_step_size_taken(self) -> float: ...
    def get_target_accuracy(self) -> float: ...
    def get_throw_on_minimum_step_size_violation(self) -> bool: ...
    def request_initial_step_size_target(self, step_size: float) -> None: ...
    def reset_context(self, context: pydrake.systems.framework.Context) -> None: ...
    def set_fixed_step_mode(self, flag: bool) -> None: ...
    @overload
    def set_maximum_step_size(self, max_step_size: float) -> None: ...
    @overload
    def set_maximum_step_size(self) -> Any: ...
    def set_requested_minimum_step_size(self, min_step_size: float) -> None: ...
    def set_target_accuracy(self, accuracy: float) -> None: ...
    def set_throw_on_minimum_step_size_violation(self, throws: bool) -> None: ...

class IntegratorBase_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def GetStatisticsSummary(self) -> list[tuple[str, int | float]]: ...
    @overload
    def Initialize(self) -> None: ...
    @overload
    def Initialize(self) -> Any: ...
    @overload
    def Initialize(self) -> Any: ...
    def Reset(self) -> None: ...
    def ResetStatistics(self) -> None: ...
    def StartDenseIntegration(self) -> None: ...
    def StopDenseIntegration(self) -> pydrake.trajectories.PiecewisePolynomial_TAutoDiffXdU: ...
    def get_actual_initial_step_size_taken(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_context(self) -> pydrake.systems.framework.Context_TAutoDiffXdU: ...
    def get_dense_output(self) -> pydrake.trajectories.PiecewisePolynomial_TAutoDiffXdU: ...
    def get_fixed_step_mode(self) -> bool: ...
    def get_initial_step_size_target(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_largest_step_size_taken(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_maximum_step_size(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_mutable_context(self) -> pydrake.systems.framework.Context_TAutoDiffXdU: ...
    def get_num_derivative_evaluations(self) -> int: ...
    def get_num_step_shrinkages_from_error_control(self) -> int: ...
    def get_num_step_shrinkages_from_substep_failures(self) -> int: ...
    def get_num_steps_taken(self) -> int: ...
    def get_num_substep_failures(self) -> int: ...
    def get_requested_minimum_step_size(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_smallest_adapted_step_size_taken(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_target_accuracy(self) -> float: ...
    def get_throw_on_minimum_step_size_violation(self) -> bool: ...
    def request_initial_step_size_target(self, step_size: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def reset_context(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...
    def set_fixed_step_mode(self, flag: bool) -> None: ...
    @overload
    def set_maximum_step_size(self, max_step_size: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    @overload
    def set_maximum_step_size(self) -> Any: ...
    def set_requested_minimum_step_size(self, min_step_size: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def set_target_accuracy(self, accuracy: float) -> None: ...
    def set_throw_on_minimum_step_size_violation(self, throws: bool) -> None: ...

class IntegratorBase_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def GetStatisticsSummary(self) -> list[tuple[str, int | float]]: ...
    @overload
    def Initialize(self) -> None: ...
    @overload
    def Initialize(self) -> Any: ...
    @overload
    def Initialize(self) -> Any: ...
    def Reset(self) -> None: ...
    def ResetStatistics(self) -> None: ...
    def StartDenseIntegration(self) -> None: ...
    def StopDenseIntegration(self) -> pydrake.trajectories.PiecewisePolynomial_TExpressionU: ...
    def get_actual_initial_step_size_taken(self) -> pydrake.symbolic.Expression: ...
    def get_context(self) -> pydrake.systems.framework.Context_TExpressionU: ...
    def get_dense_output(self) -> pydrake.trajectories.PiecewisePolynomial_TExpressionU: ...
    def get_fixed_step_mode(self) -> bool: ...
    def get_initial_step_size_target(self) -> pydrake.symbolic.Expression: ...
    def get_largest_step_size_taken(self) -> pydrake.symbolic.Expression: ...
    def get_maximum_step_size(self) -> pydrake.symbolic.Expression: ...
    def get_mutable_context(self) -> pydrake.systems.framework.Context_TExpressionU: ...
    def get_num_derivative_evaluations(self) -> int: ...
    def get_num_step_shrinkages_from_error_control(self) -> int: ...
    def get_num_step_shrinkages_from_substep_failures(self) -> int: ...
    def get_num_steps_taken(self) -> int: ...
    def get_num_substep_failures(self) -> int: ...
    def get_requested_minimum_step_size(self) -> pydrake.symbolic.Expression: ...
    def get_smallest_adapted_step_size_taken(self) -> pydrake.symbolic.Expression: ...
    def get_target_accuracy(self) -> float: ...
    def get_throw_on_minimum_step_size_violation(self) -> bool: ...
    def request_initial_step_size_target(self, step_size: pydrake.symbolic.Expression) -> None: ...
    def reset_context(self, context: pydrake.systems.framework.Context_TExpressionU) -> None: ...
    def set_fixed_step_mode(self, flag: bool) -> None: ...
    @overload
    def set_maximum_step_size(self, max_step_size: pydrake.symbolic.Expression) -> None: ...
    @overload
    def set_maximum_step_size(self) -> Any: ...
    def set_requested_minimum_step_size(self, min_step_size: pydrake.symbolic.Expression) -> None: ...
    def set_target_accuracy(self, accuracy: float) -> None: ...
    def set_throw_on_minimum_step_size_violation(self, throws: bool) -> None: ...

class RandomSimulationResult:
    generator_snapshot: pydrake.common.RandomGenerator
    output: float
    def __init__(self, *args, **kwargs) -> None: ...

class RegionOfAttractionOptions:
    lyapunov_candidate: pydrake.symbolic.Expression
    solver_id: pydrake.solvers.SolverId | None
    solver_options: pydrake.solvers.SolverOptions | None
    state_variables: numpy.ndarray[object[m, 1]]
    use_implicit_dynamics: bool
    def __init__(self) -> None: ...
    def __copy__(self) -> RegionOfAttractionOptions: ...
    def __deepcopy__(self, arg0: dict) -> RegionOfAttractionOptions: ...

class RungeKutta2Integrator(IntegratorBase):
    def __init__(self, system: pydrake.systems.framework.System, max_step_size: float, context: pydrake.systems.framework.Context = ...) -> None: ...

class RungeKutta2Integrator_𝓣AutoDiffXd𝓤(IntegratorBase_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, system: pydrake.systems.framework.System_TAutoDiffXdU, max_step_size: pydrake.autodiffutils.AutoDiffXd, context: pydrake.systems.framework.Context_TAutoDiffXdU = ...) -> None: ...

class RungeKutta2Integrator_𝓣Expression𝓤(IntegratorBase_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, system: pydrake.systems.framework.System_TExpressionU, max_step_size: pydrake.symbolic.Expression, context: pydrake.systems.framework.Context_TExpressionU = ...) -> None: ...

class RungeKutta3Integrator(IntegratorBase):
    def __init__(self, system: pydrake.systems.framework.System, context: pydrake.systems.framework.Context = ...) -> None: ...

class RungeKutta3Integrator_𝓣AutoDiffXd𝓤(IntegratorBase_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, system: pydrake.systems.framework.System_TAutoDiffXdU, context: pydrake.systems.framework.Context_TAutoDiffXdU = ...) -> None: ...

class Simulator:
    def __init__(self, system: pydrake.systems.framework.System, context: object = ...) -> None: ...
    def AdvancePendingEvents(self) -> SimulatorStatus: ...
    def AdvanceTo(self, boundary_time: float, interruptible: bool = ...) -> SimulatorStatus: ...
    def Initialize(self, params: InitializeParams = ...) -> SimulatorStatus: ...
    def ResetStatistics(self) -> None: ...
    def clear_monitor(self) -> None: ...
    def get_actual_realtime_rate(self) -> float: ...
    def get_context(self) -> pydrake.systems.framework.Context: ...
    def get_integrator(self) -> IntegratorBase: ...
    def get_monitor(self) -> Callable[[pydrake.systems.framework.Context], pydrake.systems.framework.EventStatus]: ...
    def get_mutable_context(self) -> pydrake.systems.framework.Context: ...
    def get_mutable_integrator(self) -> IntegratorBase: ...
    def get_num_discrete_updates(self) -> int: ...
    def get_num_publishes(self) -> int: ...
    def get_num_steps_taken(self) -> int: ...
    def get_num_unrestricted_updates(self) -> int: ...
    def get_system(self) -> pydrake.systems.framework.System: ...
    def get_target_realtime_rate(self) -> float: ...
    def has_context(self) -> bool: ...
    def reset_context(self, context: pydrake.systems.framework.Context) -> None: ...
    def set_monitor(self, monitor: Callable[[pydrake.systems.framework.Context], pydrake.systems.framework.EventStatus | None]) -> None: ...
    def set_publish_at_initialization(self, publish: bool) -> None: ...
    def set_publish_every_time_step(self, publish: bool) -> None: ...
    def set_target_realtime_rate(self, realtime_rate: float) -> None: ...

class SimulatorConfig:
    __fields__: ClassVar[tuple] = ...  # read-only
    accuracy: float
    integration_scheme: str
    max_step_size: float
    publish_every_time_step: bool
    start_time: float
    target_realtime_rate: float
    use_error_control: bool
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> SimulatorConfig: ...
    def __deepcopy__(self, arg0: dict) -> SimulatorConfig: ...

class SimulatorStatus:
    class ReturnReason:
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        kEventHandlerFailed: ClassVar[SimulatorStatus.ReturnReason] = ...
        kReachedBoundaryTime: ClassVar[SimulatorStatus.ReturnReason] = ...
        kReachedTerminationCondition: ClassVar[SimulatorStatus.ReturnReason] = ...
        def __init__(self, value: int) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    def __init__(self, *args, **kwargs) -> None: ...
    def FormatMessage(self) -> str: ...
    def IsIdenticalStatus(self, other: SimulatorStatus) -> bool: ...
    def boundary_time(self) -> float: ...
    def message(self) -> str: ...
    def reason(self) -> SimulatorStatus.ReturnReason: ...
    def return_time(self) -> float: ...
    def succeeded(self) -> bool: ...
    def system(self) -> pydrake.systems.framework.SystemBase: ...

class Simulator_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, system: pydrake.systems.framework.System_TAutoDiffXdU, context: object = ...) -> None: ...
    def AdvancePendingEvents(self) -> SimulatorStatus: ...
    def AdvanceTo(self, boundary_time: pydrake.autodiffutils.AutoDiffXd, interruptible: bool = ...) -> SimulatorStatus: ...
    def Initialize(self, params: InitializeParams = ...) -> SimulatorStatus: ...
    def ResetStatistics(self) -> None: ...
    def clear_monitor(self) -> None: ...
    def get_actual_realtime_rate(self) -> float: ...
    def get_context(self) -> pydrake.systems.framework.Context_TAutoDiffXdU: ...
    def get_integrator(self) -> IntegratorBase_TAutoDiffXdU: ...
    def get_monitor(self) -> Callable[[pydrake.systems.framework.Context_TAutoDiffXdU], pydrake.systems.framework.EventStatus]: ...
    def get_mutable_context(self) -> pydrake.systems.framework.Context_TAutoDiffXdU: ...
    def get_mutable_integrator(self) -> IntegratorBase_TAutoDiffXdU: ...
    def get_num_discrete_updates(self) -> int: ...
    def get_num_publishes(self) -> int: ...
    def get_num_steps_taken(self) -> int: ...
    def get_num_unrestricted_updates(self) -> int: ...
    def get_system(self) -> pydrake.systems.framework.System_TAutoDiffXdU: ...
    def get_target_realtime_rate(self) -> float: ...
    def has_context(self) -> bool: ...
    def reset_context(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...
    def set_monitor(self, monitor: Callable[[pydrake.systems.framework.Context_TAutoDiffXdU], pydrake.systems.framework.EventStatus | None]) -> None: ...
    def set_publish_at_initialization(self, publish: bool) -> None: ...
    def set_publish_every_time_step(self, publish: bool) -> None: ...
    def set_target_realtime_rate(self, realtime_rate: float) -> None: ...

class _TemporaryName_N5drake7systems14IntegratorBaseIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def GetStatisticsSummary(self) -> list[tuple[str, int | float]]: ...
    @overload
    def Initialize(self) -> None: ...
    @overload
    def Initialize(self) -> Any: ...
    @overload
    def Initialize(self) -> Any: ...
    def Reset(self) -> None: ...
    def ResetStatistics(self) -> None: ...
    def StartDenseIntegration(self) -> None: ...
    def StopDenseIntegration(self) -> pydrake.trajectories.PiecewisePolynomial_TAutoDiffXdU: ...
    def get_actual_initial_step_size_taken(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_context(self) -> pydrake.systems.framework.Context_TAutoDiffXdU: ...
    def get_dense_output(self) -> pydrake.trajectories.PiecewisePolynomial_TAutoDiffXdU: ...
    def get_fixed_step_mode(self) -> bool: ...
    def get_initial_step_size_target(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_largest_step_size_taken(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_maximum_step_size(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_mutable_context(self) -> pydrake.systems.framework.Context_TAutoDiffXdU: ...
    def get_num_derivative_evaluations(self) -> int: ...
    def get_num_step_shrinkages_from_error_control(self) -> int: ...
    def get_num_step_shrinkages_from_substep_failures(self) -> int: ...
    def get_num_steps_taken(self) -> int: ...
    def get_num_substep_failures(self) -> int: ...
    def get_requested_minimum_step_size(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_smallest_adapted_step_size_taken(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_target_accuracy(self) -> float: ...
    def get_throw_on_minimum_step_size_violation(self) -> bool: ...
    def request_initial_step_size_target(self, step_size: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def reset_context(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...
    def set_fixed_step_mode(self, flag: bool) -> None: ...
    @overload
    def set_maximum_step_size(self, max_step_size: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    @overload
    def set_maximum_step_size(self) -> Any: ...
    def set_requested_minimum_step_size(self, min_step_size: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def set_target_accuracy(self, accuracy: float) -> None: ...
    def set_throw_on_minimum_step_size_violation(self, throws: bool) -> None: ...

class _TemporaryName_N5drake7systems14IntegratorBaseINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def GetStatisticsSummary(self) -> list[tuple[str, int | float]]: ...
    @overload
    def Initialize(self) -> None: ...
    @overload
    def Initialize(self) -> Any: ...
    @overload
    def Initialize(self) -> Any: ...
    def Reset(self) -> None: ...
    def ResetStatistics(self) -> None: ...
    def StartDenseIntegration(self) -> None: ...
    def StopDenseIntegration(self) -> pydrake.trajectories.PiecewisePolynomial_TExpressionU: ...
    def get_actual_initial_step_size_taken(self) -> pydrake.symbolic.Expression: ...
    def get_context(self) -> pydrake.systems.framework.Context_TExpressionU: ...
    def get_dense_output(self) -> pydrake.trajectories.PiecewisePolynomial_TExpressionU: ...
    def get_fixed_step_mode(self) -> bool: ...
    def get_initial_step_size_target(self) -> pydrake.symbolic.Expression: ...
    def get_largest_step_size_taken(self) -> pydrake.symbolic.Expression: ...
    def get_maximum_step_size(self) -> pydrake.symbolic.Expression: ...
    def get_mutable_context(self) -> pydrake.systems.framework.Context_TExpressionU: ...
    def get_num_derivative_evaluations(self) -> int: ...
    def get_num_step_shrinkages_from_error_control(self) -> int: ...
    def get_num_step_shrinkages_from_substep_failures(self) -> int: ...
    def get_num_steps_taken(self) -> int: ...
    def get_num_substep_failures(self) -> int: ...
    def get_requested_minimum_step_size(self) -> pydrake.symbolic.Expression: ...
    def get_smallest_adapted_step_size_taken(self) -> pydrake.symbolic.Expression: ...
    def get_target_accuracy(self) -> float: ...
    def get_throw_on_minimum_step_size_violation(self) -> bool: ...
    def request_initial_step_size_target(self, step_size: pydrake.symbolic.Expression) -> None: ...
    def reset_context(self, context: pydrake.systems.framework.Context_TExpressionU) -> None: ...
    def set_fixed_step_mode(self, flag: bool) -> None: ...
    @overload
    def set_maximum_step_size(self, max_step_size: pydrake.symbolic.Expression) -> None: ...
    @overload
    def set_maximum_step_size(self) -> Any: ...
    def set_requested_minimum_step_size(self, min_step_size: pydrake.symbolic.Expression) -> None: ...
    def set_target_accuracy(self, accuracy: float) -> None: ...
    def set_throw_on_minimum_step_size_violation(self, throws: bool) -> None: ...

class _TemporaryName_N5drake7systems21RungeKutta2IntegratorIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(IntegratorBase_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, system: pydrake.systems.framework.System_TAutoDiffXdU, max_step_size: pydrake.autodiffutils.AutoDiffXd, context: pydrake.systems.framework.Context_TAutoDiffXdU = ...) -> None: ...

class _TemporaryName_N5drake7systems21RungeKutta2IntegratorINS_8symbolic10ExpressionEEE(IntegratorBase_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, system: pydrake.systems.framework.System_TExpressionU, max_step_size: pydrake.symbolic.Expression, context: pydrake.systems.framework.Context_TExpressionU = ...) -> None: ...

class _TemporaryName_N5drake7systems21RungeKutta3IntegratorIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(IntegratorBase_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, system: pydrake.systems.framework.System_TAutoDiffXdU, context: pydrake.systems.framework.Context_TAutoDiffXdU = ...) -> None: ...

class _TemporaryName_N5drake7systems9SimulatorIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, system: pydrake.systems.framework.System_TAutoDiffXdU, context: object = ...) -> None: ...
    def AdvancePendingEvents(self) -> SimulatorStatus: ...
    def AdvanceTo(self, boundary_time: pydrake.autodiffutils.AutoDiffXd, interruptible: bool = ...) -> SimulatorStatus: ...
    def Initialize(self, params: InitializeParams = ...) -> SimulatorStatus: ...
    def ResetStatistics(self) -> None: ...
    def clear_monitor(self) -> None: ...
    def get_actual_realtime_rate(self) -> float: ...
    def get_context(self) -> pydrake.systems.framework.Context_TAutoDiffXdU: ...
    def get_integrator(self) -> IntegratorBase_TAutoDiffXdU: ...
    def get_monitor(self) -> Callable[[pydrake.systems.framework.Context_TAutoDiffXdU], pydrake.systems.framework.EventStatus]: ...
    def get_mutable_context(self) -> pydrake.systems.framework.Context_TAutoDiffXdU: ...
    def get_mutable_integrator(self) -> IntegratorBase_TAutoDiffXdU: ...
    def get_num_discrete_updates(self) -> int: ...
    def get_num_publishes(self) -> int: ...
    def get_num_steps_taken(self) -> int: ...
    def get_num_unrestricted_updates(self) -> int: ...
    def get_system(self) -> pydrake.systems.framework.System_TAutoDiffXdU: ...
    def get_target_realtime_rate(self) -> float: ...
    def has_context(self) -> bool: ...
    def reset_context(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...
    def set_monitor(self, monitor: Callable[[pydrake.systems.framework.Context_TAutoDiffXdU], pydrake.systems.framework.EventStatus | None]) -> None: ...
    def set_publish_at_initialization(self, publish: bool) -> None: ...
    def set_publish_every_time_step(self, publish: bool) -> None: ...
    def set_target_realtime_rate(self, realtime_rate: float) -> None: ...

@overload
def ApplySimulatorConfig(config: SimulatorConfig, simulator: Simulator) -> None: ...
@overload
def ApplySimulatorConfig(config: SimulatorConfig, simulator: Simulator_TAutoDiffXdU) -> None: ...
@overload
def BatchEvalTimeDerivatives(system: pydrake.systems.framework.System, context: pydrake.systems.framework.Context, times: numpy.ndarray[numpy.float64[1, n]], states: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], inputs: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], input_port_index: pydrake.systems.framework.InputPortSelection | pydrake.systems.framework.InputPortIndex = ..., parallelize: pydrake.common.Parallelism = ...) -> numpy.ndarray[numpy.float64[m, n]]: ...
@overload
def BatchEvalTimeDerivatives(system: pydrake.systems.framework.System_TAutoDiffXdU, context: pydrake.systems.framework.Context_TAutoDiffXdU, times: numpy.ndarray[object[1, n]], states: numpy.ndarray[object[m, n], flags.f_contiguous], inputs: numpy.ndarray[object[m, n], flags.f_contiguous], input_port_index: pydrake.systems.framework.InputPortSelection | pydrake.systems.framework.InputPortIndex = ..., parallelize: pydrake.common.Parallelism = ...) -> numpy.ndarray[object[m, n]]: ...
@overload
def BatchEvalTimeDerivatives(system: pydrake.systems.framework.System_TExpressionU, context: pydrake.systems.framework.Context_TExpressionU, times: numpy.ndarray[object[1, n]], states: numpy.ndarray[object[m, n], flags.f_contiguous], inputs: numpy.ndarray[object[m, n], flags.f_contiguous], input_port_index: pydrake.systems.framework.InputPortSelection | pydrake.systems.framework.InputPortIndex = ..., parallelize: pydrake.common.Parallelism = ...) -> numpy.ndarray[object[m, n]]: ...
@overload
def BatchEvalUniquePeriodicDiscreteUpdate(system: pydrake.systems.framework.System, context: pydrake.systems.framework.Context, times: numpy.ndarray[numpy.float64[1, n]], states: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], inputs: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], num_time_steps: int = ..., input_port_index: pydrake.systems.framework.InputPortSelection | pydrake.systems.framework.InputPortIndex = ..., parallelize: pydrake.common.Parallelism = ...) -> numpy.ndarray[numpy.float64[m, n]]: ...
@overload
def BatchEvalUniquePeriodicDiscreteUpdate(system: pydrake.systems.framework.System_TAutoDiffXdU, context: pydrake.systems.framework.Context_TAutoDiffXdU, times: numpy.ndarray[object[1, n]], states: numpy.ndarray[object[m, n], flags.f_contiguous], inputs: numpy.ndarray[object[m, n], flags.f_contiguous], num_time_steps: int = ..., input_port_index: pydrake.systems.framework.InputPortSelection | pydrake.systems.framework.InputPortIndex = ..., parallelize: pydrake.common.Parallelism = ...) -> numpy.ndarray[object[m, n]]: ...
@overload
def BatchEvalUniquePeriodicDiscreteUpdate(system: pydrake.systems.framework.System_TExpressionU, context: pydrake.systems.framework.Context_TExpressionU, times: numpy.ndarray[object[1, n]], states: numpy.ndarray[object[m, n], flags.f_contiguous], inputs: numpy.ndarray[object[m, n], flags.f_contiguous], num_time_steps: int = ..., input_port_index: pydrake.systems.framework.InputPortSelection | pydrake.systems.framework.InputPortIndex = ..., parallelize: pydrake.common.Parallelism = ...) -> numpy.ndarray[object[m, n]]: ...
@overload
def DiscreteTimeApproximation(linear_system: pydrake.systems.primitives.LinearSystem, time_period: float) -> pydrake.systems.primitives.LinearSystem: ...
@overload
def DiscreteTimeApproximation(affine_system: pydrake.systems.primitives.AffineSystem, time_period: float) -> pydrake.systems.primitives.AffineSystem: ...
@overload
def DiscreteTimeApproximation(system: pydrake.systems.framework.System, time_period: float, integrator_config: SimulatorConfig = ...) -> pydrake.systems.framework.System: ...
def ExtractSimulatorConfig(simulator: Simulator) -> SimulatorConfig: ...
def GetIntegrationSchemes() -> list[str]: ...
def MonteCarloSimulation(*args, **kwargs): ...
@overload
def PrintSimulatorStatistics(arg0: Simulator) -> None: ...
@overload
def PrintSimulatorStatistics(arg0: Simulator_TAutoDiffXdU) -> None: ...
def RandomSimulation(make_simulator: Callable[[pydrake.common.RandomGenerator], object], output: Callable[[pydrake.systems.framework.System, pydrake.systems.framework.Context], float | None], final_time: float, generator: pydrake.common.RandomGenerator) -> float: ...
def RegionOfAttraction(system: pydrake.systems.framework.System, context: pydrake.systems.framework.Context, options: RegionOfAttractionOptions = ...) -> pydrake.symbolic.Expression: ...
@overload
def ResetIntegratorFromFlags(simulator: Simulator, scheme: str, max_step_size: float) -> IntegratorBase: ...
@overload
def ResetIntegratorFromFlags(simulator: Simulator_TAutoDiffXdU, scheme: str, max_step_size: pydrake.autodiffutils.AutoDiffXd) -> IntegratorBase_TAutoDiffXdU: ...
