import flags
import numpy
import pydrake.common
from typing import Any, Callable, ClassVar, Iterator, overload

from_sympy: Callable
logical_and: Callable
logical_or: Callable
to_sympy: Callable

class Expression:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, constant: float) -> None: ...
    @overload
    def __init__(self, var: Variable) -> None: ...
    def Differentiate(self, x: Variable) -> Expression: ...
    def EqualTo(self, arg0: Expression) -> bool: ...
    @overload
    def Evaluate(self, env: dict[Variable, float] = ..., generator: pydrake.common.RandomGenerator = ...) -> float: ...
    @overload
    def Evaluate(self, generator: pydrake.common.RandomGenerator) -> float: ...
    def EvaluatePartial(self, env: dict[Variable, float]) -> Expression: ...
    def Expand(self) -> Expression: ...
    def GetFreeVariables(self) -> Variables: ...
    def GetVariables(self) -> Variables: ...
    def Jacobian(self, vars: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[1, n]]: ...
    @overload
    def Substitute(self, var: Variable, e: Expression) -> Expression: ...
    @overload
    def Substitute(self, s: dict[Variable, Expression]) -> Expression: ...
    def Unapply(self) -> object: ...
    def abs(self) -> Expression: ...
    def acos(self) -> Expression: ...
    def arccos(self) -> Expression: ...
    def arcsin(self) -> Expression: ...
    def arctan(self) -> Expression: ...
    @overload
    def arctan2(self, x: Expression) -> Expression: ...
    @overload
    def arctan2(self, y, x) -> Any: ...
    def asin(self) -> Expression: ...
    def atan(self) -> Expression: ...
    @overload
    def atan2(self, x: Expression) -> Expression: ...
    @overload
    def atan2(self, y, x) -> Any: ...
    def ceil(self) -> Expression: ...
    def cos(self) -> Expression: ...
    def cosh(self) -> Expression: ...
    def exp(self) -> Expression: ...
    def floor(self) -> Expression: ...
    def get_kind(self) -> ExpressionKind: ...
    def is_polynomial(self) -> bool: ...
    def log(self) -> Expression: ...
    def max(self, arg0: Expression) -> Expression: ...
    def min(self, arg0: Expression) -> Expression: ...
    @overload
    def pow(self, arg0: float) -> Expression: ...
    @overload
    def pow(self, arg0: Expression) -> Expression: ...
    def sin(self) -> Expression: ...
    def sinh(self) -> Expression: ...
    def sqrt(self) -> Expression: ...
    def tan(self) -> Expression: ...
    def tanh(self) -> Expression: ...
    def to_string(self) -> str: ...
    def __abs__(self) -> Expression: ...
    @overload
    def __add__(self, arg0: Expression) -> Expression: ...
    @overload
    def __add__(self, arg0: Variable) -> Expression: ...
    @overload
    def __add__(self, arg0: float) -> Expression: ...
    def __ceil__(self) -> Expression: ...
    @overload
    def __copy__(self) -> Expression: ...
    @overload
    def __copy__(self) -> Expression: ...
    def __deepcopy__(self, arg0: dict) -> Expression: ...
    @overload
    def __eq__(self, arg0: Expression) -> Formula: ...
    @overload
    def __eq__(self, arg0: Variable) -> Formula: ...
    @overload
    def __eq__(self, arg0: float) -> Formula: ...
    def __floor__(self) -> Expression: ...
    @overload
    def __ge__(self, arg0: Expression) -> Formula: ...
    @overload
    def __ge__(self, arg0: Variable) -> Formula: ...
    @overload
    def __ge__(self, arg0: float) -> Formula: ...
    @overload
    def __gt__(self, arg0: Expression) -> Formula: ...
    @overload
    def __gt__(self, arg0: Variable) -> Formula: ...
    @overload
    def __gt__(self, arg0: float) -> Formula: ...
    @overload
    def __iadd__(self, arg0: Expression) -> Expression: ...
    @overload
    def __iadd__(self, arg0: Variable) -> Expression: ...
    @overload
    def __iadd__(self, arg0: float) -> Expression: ...
    @overload
    def __imul__(self, arg0: Expression) -> Expression: ...
    @overload
    def __imul__(self, arg0: Variable) -> Expression: ...
    @overload
    def __imul__(self, arg0: float) -> Expression: ...
    @overload
    def __isub__(self, arg0: Expression) -> Expression: ...
    @overload
    def __isub__(self, arg0: Variable) -> Expression: ...
    @overload
    def __isub__(self, arg0: float) -> Expression: ...
    @overload
    def __itruediv__(self, arg0: Expression) -> Expression: ...
    @overload
    def __itruediv__(self, arg0: Variable) -> Expression: ...
    @overload
    def __itruediv__(self, arg0: float) -> Expression: ...
    @overload
    def __le__(self, arg0: Expression) -> Formula: ...
    @overload
    def __le__(self, arg0: Variable) -> Formula: ...
    @overload
    def __le__(self, arg0: float) -> Formula: ...
    @overload
    def __lt__(self, arg0: Expression) -> Formula: ...
    @overload
    def __lt__(self, arg0: Variable) -> Formula: ...
    @overload
    def __lt__(self, arg0: float) -> Formula: ...
    @overload
    def __mul__(self, arg0: Expression) -> Expression: ...
    @overload
    def __mul__(self, arg0: Variable) -> Expression: ...
    @overload
    def __mul__(self, arg0: float) -> Expression: ...
    @overload
    def __ne__(self, arg0: Expression) -> Formula: ...
    @overload
    def __ne__(self, arg0: Variable) -> Formula: ...
    @overload
    def __ne__(self, arg0: float) -> Formula: ...
    def __neg__(self) -> Expression: ...
    def __pos__(self) -> Expression: ...
    @overload
    def __pow__(self, arg0: float) -> Expression: ...
    @overload
    def __pow__(self, arg0: Variable) -> Expression: ...
    @overload
    def __pow__(self, arg0: Expression) -> Expression: ...
    @overload
    def __radd__(self, arg0: Variable) -> Expression: ...
    @overload
    def __radd__(self, arg0: float) -> Expression: ...
    @overload
    def __rmul__(self, arg0: Variable) -> Expression: ...
    @overload
    def __rmul__(self, arg0: float) -> Expression: ...
    @overload
    def __rsub__(self, arg0: Variable) -> Expression: ...
    @overload
    def __rsub__(self, arg0: float) -> Expression: ...
    @overload
    def __rtruediv__(self, arg0: Variable) -> Expression: ...
    @overload
    def __rtruediv__(self, arg0: float) -> Expression: ...
    @overload
    def __sub__(self, arg0: Expression) -> Expression: ...
    @overload
    def __sub__(self, arg0: Variable) -> Expression: ...
    @overload
    def __sub__(self, arg0: float) -> Expression: ...
    @overload
    def __truediv__(self, arg0: Expression) -> Expression: ...
    @overload
    def __truediv__(self, arg0: Variable) -> Expression: ...
    @overload
    def __truediv__(self, arg0: float) -> Expression: ...

class ExpressionKind:
    __members__: ClassVar[dict] = ...  # read-only
    Abs: ClassVar[ExpressionKind] = ...
    Acos: ClassVar[ExpressionKind] = ...
    Add: ClassVar[ExpressionKind] = ...
    Asin: ClassVar[ExpressionKind] = ...
    Atan: ClassVar[ExpressionKind] = ...
    Atan2: ClassVar[ExpressionKind] = ...
    Ceil: ClassVar[ExpressionKind] = ...
    Constant: ClassVar[ExpressionKind] = ...
    Cos: ClassVar[ExpressionKind] = ...
    Cosh: ClassVar[ExpressionKind] = ...
    Div: ClassVar[ExpressionKind] = ...
    Exp: ClassVar[ExpressionKind] = ...
    Floor: ClassVar[ExpressionKind] = ...
    IfThenElse: ClassVar[ExpressionKind] = ...
    Log: ClassVar[ExpressionKind] = ...
    Max: ClassVar[ExpressionKind] = ...
    Min: ClassVar[ExpressionKind] = ...
    Mul: ClassVar[ExpressionKind] = ...
    NaN: ClassVar[ExpressionKind] = ...
    Pow: ClassVar[ExpressionKind] = ...
    Sin: ClassVar[ExpressionKind] = ...
    Sinh: ClassVar[ExpressionKind] = ...
    Sqrt: ClassVar[ExpressionKind] = ...
    Tan: ClassVar[ExpressionKind] = ...
    Tanh: ClassVar[ExpressionKind] = ...
    UninterpretedFunction: ClassVar[ExpressionKind] = ...
    Var: ClassVar[ExpressionKind] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Formula:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, value: bool) -> None: ...
    @overload
    def __init__(self, var: Variable) -> None: ...
    def EqualTo(self, arg0: Formula) -> bool: ...
    def Evaluate(self, env: dict[Variable, float] = ...) -> bool: ...
    @staticmethod
    def False_() -> Formula: ...
    def GetFreeVariables(self) -> Variables: ...
    @overload
    def Substitute(self, var: Variable, e: Expression) -> Formula: ...
    @overload
    def Substitute(self, var: Variable, e: Variable) -> Formula: ...
    @overload
    def Substitute(self, var: Variable, e: float) -> Formula: ...
    @overload
    def Substitute(self, s: dict[Variable, Expression]) -> Formula: ...
    @staticmethod
    def True_() -> Formula: ...
    def Unapply(self) -> object: ...
    def get_kind(self) -> FormulaKind: ...
    def to_string(self) -> str: ...
    def __bool__(self) -> bool: ...
    def __eq__(self, arg0: Formula) -> bool: ...
    def __hash__(self) -> int: ...
    def __ne__(self, arg0: Formula) -> bool: ...
    def __nonzero__(self) -> None: ...

class FormulaKind:
    __members__: ClassVar[dict] = ...  # read-only
    And: ClassVar[FormulaKind] = ...
    Eq: ClassVar[FormulaKind] = ...
    False_: ClassVar[FormulaKind] = ...
    Forall: ClassVar[FormulaKind] = ...
    Geq: ClassVar[FormulaKind] = ...
    Gt: ClassVar[FormulaKind] = ...
    Isnan: ClassVar[FormulaKind] = ...
    Leq: ClassVar[FormulaKind] = ...
    Lt: ClassVar[FormulaKind] = ...
    Neq: ClassVar[FormulaKind] = ...
    Not: ClassVar[FormulaKind] = ...
    Or: ClassVar[FormulaKind] = ...
    PositiveSemidefinite: ClassVar[FormulaKind] = ...
    True_: ClassVar[FormulaKind] = ...
    Var: ClassVar[FormulaKind] = ...
    __entries: ClassVar[dict] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Monomial:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, var: Variable) -> None: ...
    @overload
    def __init__(self, var: Variable, exponent: int) -> None: ...
    @overload
    def __init__(self, powers: dict[Variable, int]) -> None: ...
    @overload
    def __init__(self, vars: numpy.ndarray[object[m, 1]], exponents: numpy.ndarray[numpy.int32[m, 1]]) -> None: ...
    def EqualTo(self, arg0: Monomial) -> bool: ...
    @overload
    def Evaluate(self, env: dict[Variable, float]) -> float: ...
    @overload
    def Evaluate(self, vars: numpy.ndarray[object[m, 1]], vars_values: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def EvaluatePartial(self, env: dict[Variable, float]) -> tuple[float, Monomial]: ...
    def GetVariables(self) -> Variables: ...
    def ToExpression(self) -> Expression: ...
    def degree(self, v: Variable) -> int: ...
    def get_powers(self) -> dict[Variable, int]: ...
    def pow_in_place(self, p: int) -> Monomial: ...
    def total_degree(self) -> int: ...
    def __add__(self, arg0: Expression) -> Expression: ...
    def __eq__(self, arg0: Monomial) -> bool: ...
    def __hash__(self) -> int: ...
    def __imul__(self, arg0: Monomial) -> Monomial: ...
    @overload
    def __mul__(self, arg0: Monomial) -> Monomial: ...
    @overload
    def __mul__(self, arg0: float) -> Polynomial: ...
    @overload
    def __mul__(self, arg0: Expression) -> Expression: ...
    @overload
    def __ne__(self, arg0: Monomial) -> bool: ...
    @overload
    def __ne__(self, arg0: Monomial) -> bool: ...
    def __pow__(self, arg0: int) -> Monomial: ...
    def __radd__(self, arg0: Expression) -> Expression: ...
    @overload
    def __rmul__(self, arg0: float) -> Polynomial: ...
    @overload
    def __rmul__(self, arg0: Expression) -> Expression: ...
    def __rsub__(self, arg0: Expression) -> Expression: ...
    def __rtruediv__(self, arg0: Expression) -> Expression: ...
    def __sub__(self, arg0: Expression) -> Expression: ...
    def __truediv__(self, arg0: Expression) -> Expression: ...

class Polynomial:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, map: dict[Monomial, Expression]) -> None: ...
    @overload
    def __init__(self, m: Monomial) -> None: ...
    @overload
    def __init__(self, e: Expression) -> None: ...
    @overload
    def __init__(self, e: Expression, indeterminates: Variables) -> None: ...
    @overload
    def __init__(self, e: Expression, indeterminates: numpy.ndarray[object[m, 1]]) -> None: ...
    def AddProduct(self, coeff: Expression, m: Monomial) -> Polynomial: ...
    def CoefficientsAlmostEqual(self, p: Polynomial, tolerance: float) -> bool: ...
    def Degree(self, v: Variable) -> int: ...
    def Differentiate(self, x: Variable) -> Polynomial: ...
    def EqualTo(self, arg0: Polynomial) -> bool: ...
    def Evaluate(self, env: dict[Variable, float]) -> float: ...
    def EvaluateIndeterminates(self, indeterminates: numpy.ndarray[object[m, 1]], indeterminates_values: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def EvaluatePartial(self, env: dict[Variable, float]) -> Polynomial: ...
    @overload
    def EvaluatePartial(self, var: Variable, c: float) -> Polynomial: ...
    def EvaluateWithAffineCoefficients(self, indeterminates: numpy.ndarray[object[m, 1]], indeterminates_values: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> tuple[numpy.ndarray[numpy.float64[m, n]], numpy.ndarray[object[m, 1]], numpy.ndarray[numpy.float64[m, 1]]]: ...
    def Expand(self) -> Polynomial: ...
    @overload
    def Integrate(self, x: Variable) -> Polynomial: ...
    @overload
    def Integrate(self, x: Variable, a: float, b: float) -> Polynomial: ...
    def IsEven(self) -> bool: ...
    def IsOdd(self) -> bool: ...
    def Jacobian(self, vars: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[1, n]]: ...
    def RemoveTermsWithSmallCoefficients(self, coefficient_tol: float) -> Polynomial: ...
    def Roots(self) -> numpy.ndarray[numpy.complex128[m, 1]]: ...
    def SetIndeterminates(self, new_indeterminates: Variables) -> None: ...
    def SubstituteAndExpand(self, indeterminate_substitution: dict[Variable, Polynomial], substitutions_cached_data: SubstituteAndExpandCacheData = ...) -> Polynomial: ...
    def ToExpression(self) -> Expression: ...
    def TotalDegree(self) -> int: ...
    def decision_variables(self) -> Variables: ...
    def indeterminates(self) -> Variables: ...
    @overload
    def monomial_to_coefficient_map(self) -> dict[Monomial, Expression]: ...
    @overload
    def monomial_to_coefficient_map(self) -> Any: ...
    @overload
    def __add__(self, arg0: Polynomial) -> Polynomial: ...
    @overload
    def __add__(self, arg0: Monomial) -> Polynomial: ...
    @overload
    def __add__(self, arg0: float) -> Polynomial: ...
    @overload
    def __add__(self, arg0: Variable) -> Polynomial: ...
    @overload
    def __add__(self, arg0: Expression) -> Expression: ...
    def __eq__(self, arg0: Polynomial) -> Formula: ...
    def __hash__(self) -> int: ...
    @overload
    def __mul__(self, arg0: Polynomial) -> Polynomial: ...
    @overload
    def __mul__(self, arg0: Monomial) -> Polynomial: ...
    @overload
    def __mul__(self, arg0: float) -> Polynomial: ...
    @overload
    def __mul__(self, arg0: Variable) -> Polynomial: ...
    @overload
    def __mul__(self, arg0: Expression) -> Expression: ...
    def __ne__(self, arg0: Polynomial) -> Formula: ...
    def __neg__(self) -> Polynomial: ...
    def __pow__(self, arg0: int) -> Polynomial: ...
    @overload
    def __radd__(self, arg0: Monomial) -> Polynomial: ...
    @overload
    def __radd__(self, arg0: float) -> Polynomial: ...
    @overload
    def __radd__(self, arg0: Variable) -> Polynomial: ...
    @overload
    def __radd__(self, arg0: Expression) -> Expression: ...
    @overload
    def __rmul__(self, arg0: Monomial) -> Polynomial: ...
    @overload
    def __rmul__(self, arg0: float) -> Polynomial: ...
    @overload
    def __rmul__(self, arg0: Variable) -> Polynomial: ...
    @overload
    def __rmul__(self, arg0: Expression) -> Expression: ...
    @overload
    def __rsub__(self, arg0: Monomial) -> Polynomial: ...
    @overload
    def __rsub__(self, arg0: float) -> Polynomial: ...
    @overload
    def __rsub__(self, arg0: Variable) -> Polynomial: ...
    @overload
    def __rsub__(self, arg0: Expression) -> Expression: ...
    @overload
    def __rtruediv__(self, arg0: float) -> Expression: ...
    @overload
    def __rtruediv__(self, arg0: Expression) -> Expression: ...
    @overload
    def __sub__(self, arg0: Polynomial) -> Polynomial: ...
    @overload
    def __sub__(self, arg0: Monomial) -> Polynomial: ...
    @overload
    def __sub__(self, arg0: float) -> Polynomial: ...
    @overload
    def __sub__(self, arg0: Variable) -> Polynomial: ...
    @overload
    def __sub__(self, arg0: Expression) -> Expression: ...
    @overload
    def __truediv__(self, arg0: float) -> Polynomial: ...
    @overload
    def __truediv__(self, arg0: Expression) -> Expression: ...

class RationalFunction:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, numerator: Polynomial, denominator: Polynomial) -> None: ...
    @overload
    def __init__(self, p: Polynomial) -> None: ...
    @overload
    def __init__(self, m: Monomial) -> None: ...
    @overload
    def __init__(self, c: float) -> None: ...
    @overload
    def __init__(self) -> None: ...
    def EqualTo(self, f: RationalFunction) -> bool: ...
    def Evaluate(self, env: dict[Variable, float]) -> float: ...
    def SetIndeterminates(self, new_indeterminates: Variables) -> None: ...
    def ToExpression(self) -> Expression: ...
    def denominator(self) -> Polynomial: ...
    def numerator(self) -> Polynomial: ...
    @overload
    def __add__(self, arg0: RationalFunction) -> RationalFunction: ...
    @overload
    def __add__(self, arg0: float) -> RationalFunction: ...
    @overload
    def __add__(self, arg0: Polynomial) -> RationalFunction: ...
    @overload
    def __add__(self, arg0: Monomial) -> RationalFunction: ...
    def __eq__(self, arg0: RationalFunction) -> Formula: ...
    @overload
    def __mul__(self, arg0: RationalFunction) -> RationalFunction: ...
    @overload
    def __mul__(self, arg0: float) -> RationalFunction: ...
    @overload
    def __mul__(self, arg0: Polynomial) -> RationalFunction: ...
    @overload
    def __mul__(self, arg0: Monomial) -> RationalFunction: ...
    def __ne__(self, arg0: RationalFunction) -> Formula: ...
    def __neg__(self) -> RationalFunction: ...
    @overload
    def __radd__(self, arg0: float) -> RationalFunction: ...
    @overload
    def __radd__(self, arg0: Polynomial) -> RationalFunction: ...
    @overload
    def __radd__(self, arg0: Monomial) -> RationalFunction: ...
    @overload
    def __rmul__(self, arg0: float) -> RationalFunction: ...
    @overload
    def __rmul__(self, arg0: Polynomial) -> RationalFunction: ...
    @overload
    def __rmul__(self, arg0: Monomial) -> RationalFunction: ...
    @overload
    def __rsub__(self, arg0: float) -> RationalFunction: ...
    @overload
    def __rsub__(self, arg0: Polynomial) -> RationalFunction: ...
    @overload
    def __rsub__(self, arg0: Monomial) -> RationalFunction: ...
    @overload
    def __rtruediv__(self, arg0: float) -> RationalFunction: ...
    @overload
    def __rtruediv__(self, arg0: Polynomial) -> RationalFunction: ...
    @overload
    def __rtruediv__(self, arg0: Monomial) -> RationalFunction: ...
    @overload
    def __sub__(self, arg0: RationalFunction) -> RationalFunction: ...
    @overload
    def __sub__(self, arg0: float) -> RationalFunction: ...
    @overload
    def __sub__(self, arg0: Polynomial) -> RationalFunction: ...
    @overload
    def __sub__(self, arg0: Monomial) -> RationalFunction: ...
    @overload
    def __truediv__(self, arg0: RationalFunction) -> RationalFunction: ...
    @overload
    def __truediv__(self, arg0: float) -> RationalFunction: ...
    @overload
    def __truediv__(self, arg0: Polynomial) -> RationalFunction: ...
    @overload
    def __truediv__(self, arg0: Monomial) -> RationalFunction: ...

class SinCos:
    c: Variable
    s: Variable
    type: SinCosSubstitutionType
    def __init__(self, s: Variable, c: Variable, type: SinCosSubstitutionType = ...) -> None: ...

class SinCosSubstitutionType:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kAngle: ClassVar[SinCosSubstitutionType] = ...
    kHalfAnglePreferCos: ClassVar[SinCosSubstitutionType] = ...
    kHalfAnglePreferSin: ClassVar[SinCosSubstitutionType] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SubstituteAndExpandCacheData:
    def __init__(self) -> None: ...
    def get_data(self) -> dict[Monomial, Polynomial]: ...

class Variable:
    class Type:
        __members__: ClassVar[dict] = ...  # read-only
        BINARY: ClassVar[Variable.Type] = ...
        BOOLEAN: ClassVar[Variable.Type] = ...
        CONTINUOUS: ClassVar[Variable.Type] = ...
        INTEGER: ClassVar[Variable.Type] = ...
        RANDOM_EXPONENTIAL: ClassVar[Variable.Type] = ...
        RANDOM_GAUSSIAN: ClassVar[Variable.Type] = ...
        RANDOM_UNIFORM: ClassVar[Variable.Type] = ...
        __entries: ClassVar[dict] = ...
        def __init__(self, value: int) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    def __init__(self, name: str, type: Variable.Type = ...) -> None: ...
    def EqualTo(self, arg0: Variable) -> bool: ...
    def abs(self) -> Expression: ...
    def acos(self) -> Expression: ...
    def arccos(self) -> Expression: ...
    def arcsin(self) -> Expression: ...
    def arctan(self) -> Expression: ...
    @overload
    def arctan2(self, x: Variable) -> Expression: ...
    @overload
    def arctan2(self, y, x) -> Any: ...
    def asin(self) -> Expression: ...
    def atan(self) -> Expression: ...
    @overload
    def atan2(self, x: Variable) -> Expression: ...
    @overload
    def atan2(self, y, x) -> Any: ...
    def ceil(self) -> Expression: ...
    def cos(self) -> Expression: ...
    def cosh(self) -> Expression: ...
    def exp(self) -> Expression: ...
    def floor(self) -> Expression: ...
    def get_id(self) -> int: ...
    def get_name(self) -> str: ...
    def get_type(self) -> Variable.Type: ...
    def is_dummy(self) -> bool: ...
    def log(self) -> Expression: ...
    def max(self, arg0: Variable) -> Expression: ...
    def min(self, arg0: Variable) -> Expression: ...
    @overload
    def pow(self, arg0: float) -> Expression: ...
    @overload
    def pow(self, arg0: Expression) -> Expression: ...
    def sin(self) -> Expression: ...
    def sinh(self) -> Expression: ...
    def sqrt(self) -> Expression: ...
    def tan(self) -> Expression: ...
    def tanh(self) -> Expression: ...
    def __abs__(self) -> Expression: ...
    @overload
    def __add__(self, arg0: Variable) -> Expression: ...
    @overload
    def __add__(self, arg0: float) -> Expression: ...
    def __ceil__(self) -> Expression: ...
    def __copy__(self) -> Variable: ...
    def __deepcopy__(self, arg0: dict) -> Variable: ...
    @overload
    def __eq__(self, arg0: Expression) -> Formula: ...
    @overload
    def __eq__(self, arg0: Variable) -> Formula: ...
    @overload
    def __eq__(self, arg0: float) -> Formula: ...
    def __floor__(self) -> Expression: ...
    @overload
    def __ge__(self, arg0: Expression) -> Formula: ...
    @overload
    def __ge__(self, arg0: Variable) -> Formula: ...
    @overload
    def __ge__(self, arg0: float) -> Formula: ...
    @overload
    def __gt__(self, arg0: Expression) -> Formula: ...
    @overload
    def __gt__(self, arg0: Variable) -> Formula: ...
    @overload
    def __gt__(self, arg0: float) -> Formula: ...
    def __hash__(self) -> int: ...
    @overload
    def __le__(self, arg0: Expression) -> Formula: ...
    @overload
    def __le__(self, arg0: Variable) -> Formula: ...
    @overload
    def __le__(self, arg0: float) -> Formula: ...
    @overload
    def __lt__(self, arg0: Expression) -> Formula: ...
    @overload
    def __lt__(self, arg0: Variable) -> Formula: ...
    @overload
    def __lt__(self, arg0: float) -> Formula: ...
    @overload
    def __mul__(self, arg0: Variable) -> Expression: ...
    @overload
    def __mul__(self, arg0: float) -> Expression: ...
    @overload
    def __ne__(self, arg0: Expression) -> Formula: ...
    @overload
    def __ne__(self, arg0: Variable) -> Formula: ...
    @overload
    def __ne__(self, arg0: float) -> Formula: ...
    def __neg__(self) -> Expression: ...
    def __pos__(self) -> Expression: ...
    @overload
    def __pow__(self, arg0: float) -> Expression: ...
    @overload
    def __pow__(self, arg0: Variable) -> Expression: ...
    @overload
    def __pow__(self, arg0: Expression) -> Expression: ...
    def __radd__(self, arg0: float) -> Expression: ...
    def __rmul__(self, arg0: float) -> Expression: ...
    def __rsub__(self, arg0: float) -> Expression: ...
    def __rtruediv__(self, arg0: float) -> Expression: ...
    @overload
    def __sub__(self, arg0: Variable) -> Expression: ...
    @overload
    def __sub__(self, arg0: float) -> Expression: ...
    @overload
    def __truediv__(self, arg0: Variable) -> Expression: ...
    @overload
    def __truediv__(self, arg0: float) -> Expression: ...

class Variables:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: numpy.ndarray[object[m, 1]]) -> None: ...
    def EqualTo(self, arg0: Variables) -> bool: ...
    def IsStrictSubsetOf(self, vars: Variables) -> bool: ...
    def IsStrictSupersetOf(self, vars: Variables) -> bool: ...
    def IsSubsetOf(self, vars: Variables) -> bool: ...
    def IsSupersetOf(self, vars: Variables) -> bool: ...
    def empty(self) -> bool: ...
    @overload
    def erase(self, key: Variable) -> int: ...
    @overload
    def erase(self, vars: Variables) -> int: ...
    def include(self, key: Variable) -> bool: ...
    @overload
    def insert(self, var: Variable) -> None: ...
    @overload
    def insert(self, vars: Variables) -> None: ...
    def size(self) -> int: ...
    def to_string(self) -> str: ...
    @overload
    def __add__(self, arg0: Variables) -> Variables: ...
    @overload
    def __add__(self, arg0: Variable) -> Variables: ...
    def __contains__(self, arg0: Variable) -> bool: ...
    def __eq__(self, arg0: Variables) -> bool: ...
    def __hash__(self) -> int: ...
    def __iter__(self) -> Iterator[Variable]: ...
    def __len__(self) -> int: ...
    def __lt__(self, arg0: Variables) -> bool: ...
    def __radd__(self, arg0: Variable) -> Variables: ...
    @overload
    def __sub__(self, arg0: Variables) -> Variables: ...
    @overload
    def __sub__(self, arg0: Variable) -> Variables: ...

def CalcMonomialBasisOrderUpToOne(x: Variables, sort_monomial: bool = ...) -> numpy.ndarray[object[m, 1]]: ...
@overload
def CalcPolynomialWLowerTriangularPart(monomial_basis: numpy.ndarray[object[m, 1]], gram_lower: numpy.ndarray[numpy.float64[m, 1]]) -> Polynomial: ...
@overload
def CalcPolynomialWLowerTriangularPart(monomial_basis: numpy.ndarray[object[m, 1]], gram_lower: numpy.ndarray[object[m, 1]]) -> Polynomial: ...
@overload
def CalcPolynomialWLowerTriangularPart(monomial_basis: numpy.ndarray[object[m, 1]], gram_lower: numpy.ndarray[object[m, 1]]) -> Polynomial: ...
def DecomposeAffineExpression(e: Expression, map_var_to_index: dict[int, int]) -> tuple[numpy.ndarray[numpy.float64[1, n]], float]: ...
@overload
def DecomposeAffineExpressions(expressions: numpy.ndarray[object[m, 1]], vars: numpy.ndarray[object[m, 1]]) -> tuple[numpy.ndarray[numpy.float64[m, n]], numpy.ndarray[numpy.float64[m, 1]]]: ...
@overload
def DecomposeAffineExpressions(v: numpy.ndarray[object[m, 1]]) -> tuple[numpy.ndarray[numpy.float64[m, n]], numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[object[m, 1]]]: ...
def DecomposeL2NormExpression(e: Expression, psd_tol: float = ..., coefficient_tol: float = ...) -> tuple[bool, numpy.ndarray[numpy.float64[m, n]], numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[object[m, 1]]]: ...
def DecomposeLinearExpressions(expressions: numpy.ndarray[object[m, 1]], vars: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[numpy.float64[m, n]]: ...
def DecomposeLumpedParameters(f: numpy.ndarray[object[m, 1]], parameters: numpy.ndarray[object[m, 1]]) -> tuple[numpy.ndarray[object[m, n]], numpy.ndarray[object[m, 1]], numpy.ndarray[object[m, 1]]]: ...
def DecomposeQuadraticPolynomial(poly: Polynomial, map_var_to_index: dict[int, int]) -> tuple[numpy.ndarray[numpy.float64[m, n]], numpy.ndarray[numpy.float64[m, 1]], float]: ...
@overload
def Evaluate(m: numpy.ndarray[object[m, n]], env: dict[Variable, float] = ..., generator: pydrake.common.RandomGenerator = ...) -> numpy.ndarray[numpy.float64[m, n]]: ...
@overload
def Evaluate(m: numpy.ndarray[object[m, n]], env: dict[Variable, float]) -> numpy.ndarray[numpy.float64[m, n]]: ...
def EvenDegreeMonomialBasis(vars: Variables, degree: int) -> numpy.ndarray[object[m, 1]]: ...
@overload
def ExtractVariablesFromExpression(e: Expression) -> tuple[numpy.ndarray[object[m, 1]], dict[int, int]]: ...
@overload
def ExtractVariablesFromExpression(expressions: numpy.ndarray[object[m, 1]]) -> tuple[numpy.ndarray[object[m, 1]], dict[int, int]]: ...
def GetVariableVector(expressions: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
@overload
def IsAffine(m: numpy.ndarray[object[m, n], flags.f_contiguous], vars: Variables) -> bool: ...
@overload
def IsAffine(m: numpy.ndarray[object[m, n], flags.f_contiguous]) -> bool: ...
@overload
def Jacobian(f: numpy.ndarray[object[m, 1]], vars: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, n]]: ...
@overload
def Jacobian(f: numpy.ndarray[object[m, 1]], vars: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, n]]: ...
def MakeMatrixBinaryVariable(rows: int, cols: int, name: str) -> numpy.ndarray[object[m, n]]: ...
def MakeMatrixBooleanVariable(rows: int, cols: int, name: str) -> numpy.ndarray[object[m, n]]: ...
def MakeMatrixContinuousVariable(rows: int, cols: int, name: str) -> numpy.ndarray[object[m, n]]: ...
def MakeMatrixVariable(rows: int, cols: int, name: str, type: Variable.Type = ...) -> numpy.ndarray[object[m, n]]: ...
def MakeVectorBinaryVariable(rows: int, name: str) -> numpy.ndarray[object[m, 1]]: ...
def MakeVectorBooleanVariable(rows: int, name: str) -> numpy.ndarray[object[m, 1]]: ...
def MakeVectorContinuousVariable(rows: int, name: str) -> numpy.ndarray[object[m, 1]]: ...
def MakeVectorVariable(rows: int, name: str, type: Variable.Type = ...) -> numpy.ndarray[object[m, 1]]: ...
def MonomialBasis(vars: numpy.ndarray[object[m, 1]], degree: int) -> numpy.ndarray[object[m, 1]]: ...
def OddDegreeMonomialBasis(vars: Variables, degree: int) -> numpy.ndarray[object[m, 1]]: ...
@overload
def ReplaceBilinearTerms(e: Expression, x: numpy.ndarray[object[m, 1]], y: numpy.ndarray[object[m, 1]], W: numpy.ndarray[object[m, n], flags.f_contiguous]) -> Expression: ...
@overload
def ReplaceBilinearTerms(e, x, y, W) -> Any: ...
@overload
def Substitute(m: numpy.ndarray[object[m, n]], subst: dict[Variable, Expression]) -> numpy.ndarray[object[m, n]]: ...
@overload
def Substitute(m: numpy.ndarray[object[m, n]], var: Variable, e: Expression) -> numpy.ndarray[object[m, n]]: ...
@overload
def Substitute(e: Expression, subs: dict[Variable, SinCos]) -> Expression: ...
@overload
def Substitute(m: numpy.ndarray[object[m, n]], subs: dict[Variable, SinCos]) -> numpy.ndarray[object[m, n]]: ...
def SubstituteStereographicProjection(e: Polynomial, sin_cos: list[SinCos], t: numpy.ndarray[object[m, 1]]) -> RationalFunction: ...
def TaylorExpand(f: Expression, a: dict[Variable, float], order: int) -> Expression: ...
@overload
def ToLatex(e: Expression, precision: int = ...) -> str: ...
@overload
def ToLatex(f: Formula, precision: int = ...) -> str: ...
@overload
def ToLatex(M: numpy.ndarray[object[m, n]], precision: int = ...) -> str: ...
@overload
def ToLatex(M: numpy.ndarray[numpy.float64[m, n]], precision: int = ...) -> str: ...
def abs(arg0: Expression) -> Expression: ...
def acos(arg0: Expression) -> Expression: ...
def arccos(arg0: Expression) -> Expression: ...
def arcsin(arg0: Expression) -> Expression: ...
def arctan(arg0: Expression) -> Expression: ...
def arctan2(y: Expression, x: Expression) -> Expression: ...
def asin(arg0: Expression) -> Expression: ...
def atan(arg0: Expression) -> Expression: ...
def atan2(y: Expression, x: Expression) -> Expression: ...
def ceil(arg0: Expression) -> Expression: ...
def cos(arg0: Expression) -> Expression: ...
def cosh(arg0: Expression) -> Expression: ...
def exp(arg0: Expression) -> Expression: ...
def floor(arg0: Expression) -> Expression: ...
def forall(vars: Variables, f: Formula) -> Formula: ...
@overload
def if_then_else(f_cond: Formula, e_then: Expression, e_else: Expression) -> Expression: ...
@overload
def if_then_else(cond, expr_then, expr_else) -> Any: ...
def intersect(vars1: Variables, vars2: Variables) -> Variables: ...
def inv(arg0: numpy.ndarray[object[m, n]]) -> numpy.ndarray[object[m, n]]: ...
@overload
def isnan(x: Expression) -> Formula: ...
@overload
def isnan(e: Expression) -> Formula: ...
@overload
def isnan(e) -> Any: ...
@overload
def isnan(double) -> Any: ...
@overload
def isnan(e) -> Any: ...
def log(arg0: Expression) -> Expression: ...
def logical_not(arg0: Formula) -> Formula: ...
def max(arg0: Expression, arg1: Expression) -> Expression: ...
def min(arg0: Expression, arg1: Expression) -> Expression: ...
@overload
def positive_semidefinite(m: numpy.ndarray[object[m, n], flags.f_contiguous]) -> Formula: ...
@overload
def positive_semidefinite(m.triangularView<Eigen) -> Any: ...
@overload
def positive_semidefinite(m.triangularView<Eigen) -> Any: ...
@overload
def positive_semidefinite(m) -> Any: ...
@overload
def pow(arg0: Expression, arg1: float) -> Expression: ...
@overload
def pow(arg0: Expression, arg1: Expression) -> Expression: ...
def sin(arg0: Expression) -> Expression: ...
def sinh(arg0: Expression) -> Expression: ...
def sqrt(arg0: Expression) -> Expression: ...
def tan(arg0: Expression) -> Expression: ...
def tanh(arg0: Expression) -> Expression: ...
def uninterpreted_function(name: str, arguments: list[Expression]) -> Expression: ...
