import flags
import numpy
import pydrake.autodiffutils
import pydrake.common
import pydrake.symbolic
import scipy.sparse
from pydrake.common.cpp_template import Binding as Binding
from typing import Any, Callable, ClassVar, overload

class AugmentedLagrangianNonsmooth:
    def __init__(self, prog: MathematicalProgram, include_x_bounds: bool) -> None: ...
    @overload
    def Eval(self, x: numpy.ndarray[numpy.float64[m, 1]], lambda_val: numpy.ndarray[numpy.float64[m, 1]], mu: float) -> tuple[float, numpy.ndarray[numpy.float64[m, 1]], float]: ...
    @overload
    def Eval(self, x: numpy.ndarray[object[m, 1]], lambda_val: numpy.ndarray[numpy.float64[m, 1]], mu: float) -> tuple[pydrake.autodiffutils.AutoDiffXd, numpy.ndarray[object[m, 1]], pydrake.autodiffutils.AutoDiffXd]: ...
    def include_x_bounds(self) -> bool: ...
    def is_equality(self) -> list[bool]: ...
    def lagrangian_size(self) -> int: ...
    def prog(self) -> MathematicalProgram: ...
    def x_lo(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def x_up(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class AugmentedLagrangianSmooth:
    def __init__(self, prog: MathematicalProgram, include_x_bounds: bool) -> None: ...
    @overload
    def Eval(self, x: numpy.ndarray[numpy.float64[m, 1]], s: numpy.ndarray[numpy.float64[m, 1]], lambda_val: numpy.ndarray[numpy.float64[m, 1]], mu: float) -> tuple[float, numpy.ndarray[numpy.float64[m, 1]], float]: ...
    @overload
    def Eval(self) -> Any: ...
    @overload
    def Eval(self, x: numpy.ndarray[object[m, 1]], s: numpy.ndarray[object[m, 1]], lambda_val: numpy.ndarray[numpy.float64[m, 1]], mu: float) -> tuple[pydrake.autodiffutils.AutoDiffXd, numpy.ndarray[object[m, 1]], pydrake.autodiffutils.AutoDiffXd]: ...
    @overload
    def Eval(self) -> Any: ...
    def include_x_bounds(self) -> bool: ...
    def is_equality(self) -> list[bool]: ...
    def lagrangian_size(self) -> int: ...
    def prog(self) -> MathematicalProgram: ...
    def s_size(self) -> int: ...
    def x_lo(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def x_up(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class Binding𝓣BoundingBoxConstraint𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: BoundingBoxConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> BoundingBoxConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTBoundingBoxConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣Constraint𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, c: Constraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def __init__(self, arg0: object) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> Constraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣Cost𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, c: Cost, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def __init__(self, arg0: object) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> Cost: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTCostU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣EvaluatorBase𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, c: EvaluatorBase, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def __init__(self, arg0: object) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> EvaluatorBase: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTEvaluatorBaseU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣ExponentialConeConstraint𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: ExponentialConeConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> ExponentialConeConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTExponentialConeConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣ExpressionConstraint𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: ExpressionConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> ExpressionConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTExpressionConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣ExpressionCost𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: ExpressionCost, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> ExpressionCost: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTExpressionCostU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣L1NormCost𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: L1NormCost, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> L1NormCost: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTL1NormCostU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣L2NormCost𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: L2NormCost, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> L2NormCost: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTL2NormCostU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣LInfNormCost𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: LInfNormCost, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> LInfNormCost: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTLInfNormCostU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣LinearComplementarityConstraint𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: LinearComplementarityConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> LinearComplementarityConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTLinearComplementarityConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣LinearConstraint𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: LinearConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> LinearConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTLinearConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣LinearCost𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: LinearCost, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> LinearCost: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTLinearCostU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣LinearEqualityConstraint𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: LinearEqualityConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> LinearEqualityConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTLinearEqualityConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣LinearMatrixInequalityConstraint𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: LinearMatrixInequalityConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> LinearMatrixInequalityConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTLinearMatrixInequalityConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣LorentzConeConstraint𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: LorentzConeConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> LorentzConeConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTLorentzConeConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣MinimumValueLowerBoundConstraint𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: MinimumValueLowerBoundConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> MinimumValueLowerBoundConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTMinimumValueLowerBoundConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣MinimumValueUpperBoundConstraint𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: MinimumValueUpperBoundConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> MinimumValueUpperBoundConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTMinimumValueUpperBoundConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣PerspectiveQuadraticCost𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: PerspectiveQuadraticCost, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> PerspectiveQuadraticCost: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTPerspectiveQuadraticCostU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣PositiveSemidefiniteConstraint𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: PositiveSemidefiniteConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> PositiveSemidefiniteConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTPositiveSemidefiniteConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣QuadraticConstraint𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: QuadraticConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> QuadraticConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTQuadraticConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣QuadraticCost𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: QuadraticCost, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> QuadraticCost: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTQuadraticCostU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣RotatedLorentzConeConstraint𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: RotatedLorentzConeConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> RotatedLorentzConeConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTRotatedLorentzConeConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class Binding𝓣VisualizationCallback𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: VisualizationCallback, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> VisualizationCallback: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTVisualizationCallbackU) -> bool: ...
    def __hash__(self) -> int: ...

class BoundingBoxConstraint(LinearConstraint):
    def __init__(self, lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class ClarabelSolver(SolverInterface):
    def __init__(self) -> None: ...
    @staticmethod
    def id() -> SolverId: ...

class ClarabelSolverDetails:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def iterations(self) -> int: ...
    @property
    def solve_time(self) -> float: ...
    @property
    def status(self) -> str: ...

class ClpSolver(SolverInterface):
    def __init__(self) -> None: ...
    @staticmethod
    def id() -> SolverId: ...

class ClpSolverDetails:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def status(self) -> int: ...

class CommonSolverOption:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kMaxThreads: ClassVar[CommonSolverOption] = ...
    kPrintFileName: ClassVar[CommonSolverOption] = ...
    kPrintToConsole: ClassVar[CommonSolverOption] = ...
    kStandaloneReproductionFileName: ClassVar[CommonSolverOption] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Constraint(EvaluatorBase):
    def __init__(self, *args, **kwargs) -> None: ...
    def CheckSatisfied(self, x: numpy.ndarray[numpy.float64[m, 1]], tol: float = ...) -> bool: ...
    def CheckSatisfiedVectorized(self, x: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], tol: float) -> list[bool]: ...
    def lower_bound(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def num_constraints(self) -> int: ...
    def upper_bound(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class Cost(EvaluatorBase):
    def __init__(self, *args, **kwargs) -> None: ...

class CsdpSolver(SolverInterface):
    def __init__(self) -> None: ...
    @staticmethod
    def id() -> SolverId: ...

class CsdpSolverDetails:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def Z_val(self) -> scipy.sparse.csc_matrix[numpy.float64]: ...
    @property
    def dual_objective(self) -> float: ...
    @property
    def primal_objective(self) -> float: ...
    @property
    def return_code(self) -> int: ...
    @property
    def y_val(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class EvaluatorBase:
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def Eval(self, x: numpy.ndarray[numpy.float64[m, 1]]) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def Eval(self, x: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def Eval(self, x: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    def SetGradientSparsityPattern(self, gradient_sparsity_pattern: list[tuple[int, int]]) -> None: ...
    @overload
    def ToLatex(self, vars: numpy.ndarray[object[m, 1]], precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def get_description(self) -> str: ...
    def gradient_sparsity_pattern(self) -> list[tuple[int, int]] | None: ...
    def is_thread_safe(self) -> bool: ...
    def num_outputs(self) -> int: ...
    def num_vars(self) -> int: ...
    def set_description(self, arg0: str) -> None: ...

class ExponentialConeConstraint(Constraint):
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n]], b: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def A(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def b(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...

class ExpressionConstraint(Constraint):
    def __init__(self, v: numpy.ndarray[object[m, 1]], lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def expressions(self) -> numpy.ndarray[object[m, 1]]: ...
    def vars(self) -> numpy.ndarray[object[m, 1]]: ...

class ExpressionCost(Cost):
    def __init__(self, e: pydrake.symbolic.Expression) -> None: ...
    def expression(self) -> pydrake.symbolic.Expression: ...
    def vars(self) -> numpy.ndarray[object[m, 1]]: ...

class GurobiSolver(SolverInterface):
    class License:
        def __init__(self, *args, **kwargs) -> None: ...
        def is_valid(self) -> bool: ...
        def __enter__(self) -> GurobiSolver.License: ...
        def __exit__(self, *args, **kwargs) -> None: ...

    class SolveStatusInfo:
        def __init__(self, *args, **kwargs) -> None: ...
        @property
        def best_bound(self) -> float: ...
        @property
        def best_objective(self) -> float: ...
        @property
        def current_objective(self) -> float: ...
        @property
        def explored_node_count(self) -> int: ...
        @property
        def feasible_solutions_count(self) -> int: ...
        @property
        def reported_runtime(self) -> float: ...
    def __init__(self) -> None: ...
    @staticmethod
    def AcquireLicense() -> GurobiSolver.License: ...
    def AddMipNodeCallback(self, callback: Callable[[MathematicalProgram, GurobiSolver.SolveStatusInfo, numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[object[m, 1]]], None]) -> None: ...
    def AddMipSolCallback(self, callback: Callable[[MathematicalProgram, GurobiSolver.SolveStatusInfo], None]) -> None: ...
    @staticmethod
    def id() -> SolverId: ...

class GurobiSolverDetails:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def error_code(self) -> int: ...
    @property
    def objective_bound(self) -> float: ...
    @property
    def optimization_status(self) -> int: ...
    @property
    def optimizer_time(self) -> float: ...

class IntervalBinning:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kLinear: ClassVar[IntervalBinning] = ...
    kLogarithmic: ClassVar[IntervalBinning] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class IpoptSolver(SolverInterface):
    def __init__(self) -> None: ...
    @staticmethod
    def id() -> SolverId: ...

class IpoptSolverDetails:
    def __init__(self, *args, **kwargs) -> None: ...
    def ConvertStatusToString(self) -> str: ...
    @property
    def g(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @property
    def lambda_val(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @property
    def status(self) -> int: ...
    @property
    def z_L(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @property
    def z_U(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class L1NormCost(Cost):
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n]], b: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def A(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def UpdateCoefficients(self, new_A: numpy.ndarray[numpy.float64[m, n]], new_b: numpy.ndarray[numpy.float64[m, 1]] = ...) -> None: ...
    def b(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def update_A_entry(self, i: int, j: int, val: float) -> None: ...
    def update_b_entry(self, i: int, val: float) -> None: ...

class L2NormCost(Cost):
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n]], b: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def GetDenseA(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def UpdateCoefficients(self, new_A: numpy.ndarray[numpy.float64[m, n]], new_b: numpy.ndarray[numpy.float64[m, 1]] = ...) -> None: ...
    @overload
    def UpdateCoefficients(self, new_A: scipy.sparse.csc_matrix[numpy.float64], new_b: numpy.ndarray[numpy.float64[m, 1]] = ...) -> None: ...
    def b(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def get_sparse_A(self) -> scipy.sparse.csc_matrix[numpy.float64]: ...

class LInfNormCost(Cost):
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n]], b: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def A(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def UpdateCoefficients(self, new_A: numpy.ndarray[numpy.float64[m, n]], new_b: numpy.ndarray[numpy.float64[m, 1]] = ...) -> None: ...
    def b(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def update_A_entry(self, i: int, j: int, val: float) -> None: ...
    def update_b_entry(self, i: int, val: float) -> None: ...

class LinearComplementarityConstraint(Constraint):
    def __init__(self, *args, **kwargs) -> None: ...
    def M(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def q(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class LinearConstraint(Constraint):
    @overload
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n]], lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def __init__(self, A: scipy.sparse.csc_matrix[numpy.float64], lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def GetDenseA(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def RemoveTinyCoefficient(self, tol: float) -> None: ...
    def UpdateCoefficients(self, new_A: numpy.ndarray[numpy.float64[m, n]], new_lb: numpy.ndarray[numpy.float64[m, 1]], new_ub: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def UpdateLowerBound(self, new_lb: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def UpdateUpperBound(self, new_ub: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def get_sparse_A(self) -> scipy.sparse.csc_matrix[numpy.float64]: ...
    def is_dense_A_constructed(self) -> bool: ...
    def set_bounds(self, new_lb: numpy.ndarray[numpy.float64[m, 1]], new_ub: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class LinearCost(Cost):
    def __init__(self, a: numpy.ndarray[numpy.float64[m, 1]], b: float) -> None: ...
    def UpdateCoefficients(self, new_a: numpy.ndarray[numpy.float64[m, 1]], new_b: float = ...) -> None: ...
    def a(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def b(self) -> float: ...
    def update_coefficient_entry(self, i: int, val: float) -> None: ...
    def update_constant_term(self, new_b: float) -> None: ...

class LinearEqualityConstraint(LinearConstraint):
    @overload
    def __init__(self, Aeq: numpy.ndarray[numpy.float64[m, n]], beq: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def __init__(self, Aeq: scipy.sparse.csc_matrix[numpy.float64], beq: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def __init__(self, a: numpy.ndarray[numpy.float64[1, n]], beq: float) -> None: ...
    @overload
    def UpdateCoefficients(self, Aeq: numpy.ndarray[numpy.float64[m, n]], beq: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def UpdateCoefficients(self, Aeq: scipy.sparse.csc_matrix[numpy.float64], beq: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class LinearMatrixInequalityConstraint(Constraint):
    def __init__(self, F: list[numpy.ndarray[numpy.float64[m, n]]], symmetry_tolerance: float = ...) -> None: ...
    def F(self) -> list[numpy.ndarray[numpy.float64[m, n]]]: ...
    @overload
    def matrix_rows(self) -> int: ...
    @overload
    def matrix_rows(self) -> Any: ...

class LorentzConeConstraint(Constraint):
    class EvalType:
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        kConvex: ClassVar[LorentzConeConstraint.EvalType] = ...
        kConvexSmooth: ClassVar[LorentzConeConstraint.EvalType] = ...
        kNonconvex: ClassVar[LorentzConeConstraint.EvalType] = ...
        def __init__(self, value: int) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n]], b: numpy.ndarray[numpy.float64[m, 1]], eval_type: LorentzConeConstraint.EvalType = ...) -> None: ...
    def A(self) -> scipy.sparse.csc_matrix[numpy.float64]: ...
    def UpdateCoefficients(self, new_A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], new_b: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def b(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def eval_type(self) -> LorentzConeConstraint.EvalType: ...

class MathematicalProgram:
    class NonnegativePolynomial:
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        kDsos: ClassVar[MathematicalProgram.NonnegativePolynomial] = ...
        kSdsos: ClassVar[MathematicalProgram.NonnegativePolynomial] = ...
        kSos: ClassVar[MathematicalProgram.NonnegativePolynomial] = ...
        def __init__(self, value: int) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    def __init__(self) -> None: ...
    def Add2NormSquaredCost(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], b: numpy.ndarray[numpy.float64[m, 1]], vars: numpy.ndarray[object[m, 1]]) -> BindingTQuadraticCostU: ...
    @overload
    def AddBoundingBoxConstraint(self, arg0: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], arg1: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], arg2: numpy.ndarray[object[m, n], flags.f_contiguous]) -> BindingTBoundingBoxConstraintU: ...
    @overload
    def AddBoundingBoxConstraint(self, arg0: float, arg1: float, arg2: pydrake.symbolic.Variable) -> BindingTBoundingBoxConstraintU: ...
    @overload
    def AddBoundingBoxConstraint(self, arg0: float, arg1: float, arg2: numpy.ndarray[object[m, n], flags.f_contiguous]) -> BindingTBoundingBoxConstraintU: ...
    @overload
    def AddConstraint(self, func: Callable, lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]], vars: numpy.ndarray[object[m, 1]], description: str = ...) -> BindingTConstraintU: ...
    @overload
    def AddConstraint(self, arg0: pydrake.symbolic.Expression, arg1: float, arg2: float) -> BindingTConstraintU: ...
    @overload
    def AddConstraint(self, arg0: pydrake.symbolic.Formula) -> BindingTConstraintU: ...
    @overload
    def AddConstraint(self, constraint: Constraint, vars: numpy.ndarray[object[m, 1]]) -> BindingTConstraintU: ...
    @overload
    def AddConstraint(self, formulas: numpy.ndarray[object[m, n], flags.f_contiguous]) -> BindingTConstraintU: ...
    @overload
    def AddConstraint(self, constsymbolic) -> Any: ...
    @overload
    def AddConstraint(self, constsymbolic) -> Any: ...
    @overload
    def AddConstraint(self, binding: BindingTConstraintU) -> BindingTConstraintU: ...
    @overload
    def AddCost(self, func: Callable, vars: numpy.ndarray[object[m, 1]], description: str = ...) -> BindingTCostU: ...
    @overload
    def AddCost(self, binding: BindingTCostU) -> BindingTCostU: ...
    @overload
    def AddCost(self, e: pydrake.symbolic.Expression) -> BindingTCostU: ...
    @overload
    def AddCost(self, obj: Cost, vars: numpy.ndarray[object[m, 1]]) -> BindingTCostU: ...
    def AddDecisionVariables(self, decision_variables: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    def AddEqualityConstraintBetweenPolynomials(self, p1: pydrake.symbolic.Polynomial, p2: pydrake.symbolic.Polynomial) -> list[BindingTLinearEqualityConstraintU]: ...
    @overload
    def AddExponentialConeConstraint(self, A: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous], b: numpy.ndarray[numpy.float64[3, 1]], vars: numpy.ndarray[object[m, 1]]) -> BindingTExponentialConeConstraintU: ...
    @overload
    def AddExponentialConeConstraint(self, z: numpy.ndarray[object[3, 1]]) -> BindingTExponentialConeConstraintU: ...
    def AddIndeterminate(self, new_indeterminate: pydrake.symbolic.Variable) -> int: ...
    def AddIndeterminates(self, new_indeterminates: numpy.ndarray[object[m, n], flags.f_contiguous]) -> None: ...
    def AddL1NormCostInEpigraphForm(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], b: numpy.ndarray[numpy.float64[m, 1]], vars: numpy.ndarray[object[m, 1]]) -> tuple[numpy.ndarray[object[m, 1]], BindingTLinearCostU, BindingTLinearConstraintU]: ...
    def AddL2NormCost(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], b: numpy.ndarray[numpy.float64[m, 1]], vars: numpy.ndarray[object[m, 1]]) -> BindingTL2NormCostU: ...
    def AddL2NormCostUsingConicConstraint(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], b: numpy.ndarray[numpy.float64[m, 1]], vars: numpy.ndarray[object[m, 1]]) -> tuple[pydrake.symbolic.Variable, BindingTLinearCostU, BindingTLorentzConeConstraintU]: ...
    def AddLinearComplementarityConstraint(self, M: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], q: numpy.ndarray[numpy.float64[m, 1]], vars: numpy.ndarray[object[m, 1]]) -> BindingTLinearComplementarityConstraintU: ...
    @overload
    def AddLinearConstraint(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]], vars: numpy.ndarray[object[m, 1]]) -> BindingTLinearConstraintU: ...
    @overload
    def AddLinearConstraint(self, a: numpy.ndarray[numpy.float64[1, n]], lb: float, ub: float, vars: numpy.ndarray[object[m, 1]]) -> BindingTLinearConstraintU: ...
    @overload
    def AddLinearConstraint(self, A: scipy.sparse.csc_matrix[numpy.float64], lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]], vars: numpy.ndarray[object[m, 1]]) -> BindingTLinearConstraintU: ...
    @overload
    def AddLinearConstraint(self, e: pydrake.symbolic.Expression, lb: float, ub: float) -> BindingTLinearConstraintU: ...
    @overload
    def AddLinearConstraint(self, v: numpy.ndarray[object[m, n], flags.f_contiguous], lb: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], ub: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> BindingTLinearConstraintU: ...
    @overload
    def AddLinearConstraint(self, f: pydrake.symbolic.Formula) -> BindingTLinearConstraintU: ...
    @overload
    def AddLinearConstraint(self, formulas: numpy.ndarray[object[m, n], flags.f_contiguous]) -> BindingTLinearConstraintU: ...
    @overload
    def AddLinearConstraint(self, constsymbolic) -> Any: ...
    def AddLinearCost(self, e: pydrake.symbolic.Expression) -> BindingTLinearCostU: ...
    @overload
    def AddLinearEqualityConstraint(self, Aeq: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], beq: numpy.ndarray[numpy.float64[m, 1]], vars: numpy.ndarray[object[m, 1]]) -> BindingTLinearEqualityConstraintU: ...
    @overload
    def AddLinearEqualityConstraint(self, a: numpy.ndarray[numpy.float64[1, n]], beq: float, vars: numpy.ndarray[object[m, 1]]) -> BindingTLinearEqualityConstraintU: ...
    @overload
    def AddLinearEqualityConstraint(self, Aeq: scipy.sparse.csc_matrix[numpy.float64], beq: numpy.ndarray[numpy.float64[m, 1]], vars: numpy.ndarray[object[m, 1]]) -> BindingTLinearEqualityConstraintU: ...
    @overload
    def AddLinearEqualityConstraint(self, e: pydrake.symbolic.Expression, b: float) -> BindingTLinearEqualityConstraintU: ...
    @overload
    def AddLinearEqualityConstraint(self, f: pydrake.symbolic.Formula) -> BindingTLinearEqualityConstraintU: ...
    @overload
    def AddLinearEqualityConstraint(self, formulas: numpy.ndarray[object[m, n], flags.f_contiguous]) -> BindingTLinearEqualityConstraintU: ...
    @overload
    def AddLinearEqualityConstraint(self, v: numpy.ndarray[object[m, 1]], b: numpy.ndarray[numpy.float64[m, 1]]) -> BindingTLinearEqualityConstraintU: ...
    @overload
    def AddLinearMatrixInequalityConstraint(self, F: list[numpy.ndarray[numpy.float64[m, n]]], vars: numpy.ndarray[object[m, 1]]) -> BindingTLinearMatrixInequalityConstraintU: ...
    @overload
    def AddLinearMatrixInequalityConstraint(self, X: numpy.ndarray[object[m, n], flags.f_contiguous]) -> BindingTLinearMatrixInequalityConstraintU: ...
    def AddLogDeterminantLowerBoundConstraint(self, X: numpy.ndarray[object[m, n], flags.f_contiguous], lower: float) -> tuple[BindingTLinearConstraintU, numpy.ndarray[object[m, 1]], numpy.ndarray[object[m, n]]]: ...
    def AddLorentzConeConstraint(self, f: pydrake.symbolic.Formula, eval_type: LorentzConeConstraint.EvalType = ..., psd_tol: float = ..., coefficient_tol: float = ...) -> BindingTLorentzConeConstraintU: ...
    def AddMaximizeGeometricMeanCost(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], b: numpy.ndarray[numpy.float64[m, 1]], x: numpy.ndarray[object[m, 1]]) -> BindingTLinearCostU: ...
    def AddMaximizeLogDeterminantCost(self, X: numpy.ndarray[object[m, n], flags.f_contiguous]) -> tuple[BindingTLinearCostU, numpy.ndarray[object[m, 1]], numpy.ndarray[object[m, n]]]: ...
    def AddPositiveDiagonallyDominantDualConeMatrixConstraint(self, X: numpy.ndarray[object[m, n], flags.f_contiguous]) -> BindingTLinearConstraintU: ...
    def AddPositiveDiagonallyDominantMatrixConstraint(self, X: numpy.ndarray[object[m, n], flags.f_contiguous]) -> numpy.ndarray[object[m, n]]: ...
    @overload
    def AddPositiveSemidefiniteConstraint(self, arg0: numpy.ndarray[object[m, n], flags.f_contiguous]) -> BindingTPositiveSemidefiniteConstraintU: ...
    @overload
    def AddPositiveSemidefiniteConstraint(self, arg0: numpy.ndarray[object[m, n], flags.f_contiguous]) -> BindingTPositiveSemidefiniteConstraintU: ...
    @overload
    def AddPositiveSemidefiniteConstraint(self, e) -> Any: ...
    @overload
    def AddPrincipalSubmatrixIsPsdConstraint(self, arg0: numpy.ndarray[object[m, n], flags.f_contiguous], arg1: set[int]) -> BindingTPositiveSemidefiniteConstraintU: ...
    @overload
    def AddPrincipalSubmatrixIsPsdConstraint(self, arg0: numpy.ndarray[object[m, n], flags.f_contiguous], arg1: set[int]) -> BindingTLinearMatrixInequalityConstraintU: ...
    def AddQuadraticAsRotatedLorentzConeConstraint(self, Q: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], b: numpy.ndarray[numpy.float64[m, 1]], c: float, vars: numpy.ndarray[object[m, 1]], psd_tol: float = ...) -> BindingTRotatedLorentzConeConstraintU: ...
    @overload
    def AddQuadraticConstraint(self, Q: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], b: numpy.ndarray[numpy.float64[m, 1]], lb: float, ub: float, vars: numpy.ndarray[object[m, 1]], hessian_type: QuadraticConstraint.HessianType | None = ...) -> BindingTQuadraticConstraintU: ...
    @overload
    def AddQuadraticConstraint(self, e: pydrake.symbolic.Expression, lb: float, ub: float, hessian_type: QuadraticConstraint.HessianType | None = ...) -> BindingTQuadraticConstraintU: ...
    @overload
    def AddQuadraticCost(self, e: pydrake.symbolic.Expression, is_convex: bool | None = ...) -> BindingTQuadraticCostU: ...
    @overload
    def AddQuadraticCost(self, Q: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], b: numpy.ndarray[numpy.float64[m, 1]], vars: numpy.ndarray[object[m, 1]], is_convex: bool | None = ...) -> BindingTQuadraticCostU: ...
    @overload
    def AddQuadraticCost(self, Q: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], b: numpy.ndarray[numpy.float64[m, 1]], c: float, vars: numpy.ndarray[object[m, 1]], is_convex: bool | None = ...) -> BindingTQuadraticCostU: ...
    @overload
    def AddQuadraticErrorCost(self, w: float, x_desired: numpy.ndarray[numpy.float64[m, 1]], vars: numpy.ndarray[object[m, 1]]) -> BindingTQuadraticCostU: ...
    @overload
    def AddQuadraticErrorCost(self, Q: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], x_desired: numpy.ndarray[numpy.float64[m, 1]], vars: numpy.ndarray[object[m, 1]]) -> BindingTQuadraticCostU: ...
    def AddRotatedLorentzConeConstraint(self, linear_expression1: pydrake.symbolic.Expression, linear_expression2: pydrake.symbolic.Expression, quadratic_expression: pydrake.symbolic.Expression, tol: float = ...) -> BindingTRotatedLorentzConeConstraintU: ...
    def AddScaledDiagonallyDominantDualConeMatrixConstraint(self, X: numpy.ndarray[object[m, n], flags.f_contiguous]) -> list[BindingTRotatedLorentzConeConstraintU]: ...
    def AddScaledDiagonallyDominantMatrixConstraint(self, X: numpy.ndarray[object[m, n], flags.f_contiguous]) -> list[list[numpy.ndarray[object[2, 2]]]]: ...
    def AddSosConstraint(self, p: pydrake.symbolic.Polynomial, monomial_basis: numpy.ndarray[object[m, 1]], type: MathematicalProgram.NonnegativePolynomial = ..., gram_name: str = ...) -> numpy.ndarray[object[m, n]]: ...
    def AddVisualizationCallback(self, arg0: Callable[[numpy.ndarray[numpy.float64[m, 1]]], None], arg1: numpy.ndarray[object[m, 1]]) -> BindingTVisualizationCallbackU: ...
    @overload
    def CheckSatisfied(self, binding: BindingTConstraintU, prog_var_vals: numpy.ndarray[numpy.float64[m, 1]], tol: float = ...) -> bool: ...
    @overload
    def CheckSatisfied(self, bindings: list[BindingTConstraintU], prog_var_vals: numpy.ndarray[numpy.float64[m, 1]], tol: float = ...) -> bool: ...
    @overload
    def CheckSatisfiedAtInitialGuess(self, binding: BindingTConstraintU, tol: float = ...) -> bool: ...
    @overload
    def CheckSatisfiedAtInitialGuess(self, bindings: list[BindingTConstraintU], tol: float = ...) -> bool: ...
    def ClearVariableScaling(self) -> None: ...
    def Clone(self) -> MathematicalProgram: ...
    @overload
    def EvalBinding(self, binding: BindingTEvaluatorBaseU, prog_var_vals: numpy.ndarray[numpy.float64[m, 1]]) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def EvalBinding(self, binding: BindingTEvaluatorBaseU, prog_var_vals: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    def EvalBindingAtInitialGuess(self, binding: BindingTEvaluatorBaseU) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def EvalBindingVectorized(self, binding: BindingTEvaluatorBaseU, prog_var_vals: numpy.ndarray[numpy.float64[m, n]]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def EvalBindings(self, bindings: list[BindingTEvaluatorBaseU], prog_var_vals: numpy.ndarray[numpy.float64[m, 1]]) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def EvalBindings(self, bindings: list[BindingTEvaluatorBaseU], prog_var_vals: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    def FindDecisionVariableIndex(self, var: pydrake.symbolic.Variable) -> int: ...
    def FindDecisionVariableIndices(self, vars: numpy.ndarray[object[m, 1]]) -> list[int]: ...
    def FindIndeterminateIndex(self, var: pydrake.symbolic.Variable) -> int: ...
    def GetAllConstraints(self) -> list[BindingTConstraintU]: ...
    def GetAllCosts(self) -> list[BindingTCostU]: ...
    def GetBindingVariableValues(self, binding: BindingTEvaluatorBaseU, prog_var_vals: numpy.ndarray[numpy.float64[m, 1]]) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetInitialGuess(self, arg0: pydrake.symbolic.Variable) -> float: ...
    @overload
    def GetInitialGuess(self, arg0: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetInitialGuess(self, arg0: numpy.ndarray[object[m, n]]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def GetLinearConstraints(self) -> list[BindingTLinearConstraintU]: ...
    def GetVariableScaling(self) -> dict[int, float]: ...
    def IsThreadSafe(self) -> bool: ...
    def MakePolynomial(self, e: pydrake.symbolic.Expression) -> pydrake.symbolic.Polynomial: ...
    @overload
    def NewBinaryVariables(self, rows: int, name: str = ...) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def NewBinaryVariables(self, introws, intcols, const
std) -> Any: ...
    @overload
    def NewBinaryVariables(self, rows: int, cols: int, name: str = ...) -> numpy.ndarray[object[m, n]]: ...
    @overload
    def NewContinuousVariables(self, rows: int, name: str = ...) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def NewContinuousVariables(self, rows: int, cols: int, name: str = ...) -> numpy.ndarray[object[m, n]]: ...
    def NewEvenDegreeDsosPolynomial(self, indeterminates: pydrake.symbolic.Variables, degree: int) -> tuple[pydrake.symbolic.Polynomial, numpy.ndarray[object[m, n]], numpy.ndarray[object[m, n]]]: ...
    def NewEvenDegreeFreePolynomial(self, indeterminates: pydrake.symbolic.Variables, degree: int, coeff_name: str = ...) -> pydrake.symbolic.Polynomial: ...
    def NewEvenDegreeNonnegativePolynomial(self, indeterminates: pydrake.symbolic.Variables, degree: int, type: MathematicalProgram.NonnegativePolynomial) -> tuple[pydrake.symbolic.Polynomial, numpy.ndarray[object[m, n]], numpy.ndarray[object[m, n]]]: ...
    def NewEvenDegreeSdsosPolynomial(self, indeterminates: pydrake.symbolic.Variables, degree: int) -> tuple[pydrake.symbolic.Polynomial, numpy.ndarray[object[m, n]], numpy.ndarray[object[m, n]]]: ...
    def NewEvenDegreeSosPolynomial(self, indeterminates: pydrake.symbolic.Variables, degree: int) -> tuple[pydrake.symbolic.Polynomial, numpy.ndarray[object[m, n]], numpy.ndarray[object[m, n]]]: ...
    def NewFreePolynomial(self, indeterminates: pydrake.symbolic.Variables, deg: int, coeff_name: str = ...) -> pydrake.symbolic.Polynomial: ...
    @overload
    def NewIndeterminates(self, rows: int, name: str = ...) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def NewIndeterminates(self, introws, intcols, const
std) -> Any: ...
    @overload
    def NewIndeterminates(self, rows: int, cols: int, name: str = ...) -> numpy.ndarray[object[m, n]]: ...
    @overload
    def NewIndeterminates(self, introws, intcols, const
std) -> Any: ...
    def NewOddDegreeFreePolynomial(self, indeterminates: pydrake.symbolic.Variables, degree: int, coeff_name: str = ...) -> pydrake.symbolic.Polynomial: ...
    @overload
    def NewSosPolynomial(self, monomial_basis: numpy.ndarray[object[m, 1]], type: MathematicalProgram.NonnegativePolynomial = ..., gram_name: str = ...) -> tuple[pydrake.symbolic.Polynomial, numpy.ndarray[object[m, n]]]: ...
    @overload
    def NewSosPolynomial(self, gramian: numpy.ndarray[object[m, n], flags.f_contiguous], monomial_basis: numpy.ndarray[object[m, 1]], type: MathematicalProgram.NonnegativePolynomial = ...) -> pydrake.symbolic.Polynomial: ...
    @overload
    def NewSosPolynomial(self, indeterminates: pydrake.symbolic.Variables, degree: int, type: MathematicalProgram.NonnegativePolynomial = ..., gram_name: str = ...) -> tuple[pydrake.symbolic.Polynomial, numpy.ndarray[object[m, n]]]: ...
    def NewSymmetricContinuousVariables(self, rows: int, name: str = ...) -> numpy.ndarray[object[m, n]]: ...
    def RelaxPsdConstraintToDdDualCone(self, constraint: BindingTPositiveSemidefiniteConstraintU) -> BindingTLinearConstraintU: ...
    def RelaxPsdConstraintToSddDualCone(self, constraint: BindingTPositiveSemidefiniteConstraintU) -> list[BindingTRotatedLorentzConeConstraintU]: ...
    def RemoveConstraint(self, constraint: BindingTConstraintU) -> int: ...
    def RemoveCost(self, cost: BindingTCostU) -> int: ...
    def RemoveDecisionVariable(self, var: pydrake.symbolic.Variable) -> int: ...
    def RemoveVisualizationCallback(self, callback: BindingTVisualizationCallbackU) -> int: ...
    def Reparse(self, p: pydrake.symbolic.Polynomial) -> None: ...
    def SetDecisionVariableValueInVector(self, decision_variable: pydrake.symbolic.Variable, decision_variable_new_value: float, values: numpy.ndarray[numpy.float64[m, 1], flags.writeable] | None) -> None: ...
    @overload
    def SetInitialGuess(self, arg0: pydrake.symbolic.Variable, arg1: float) -> None: ...
    @overload
    def SetInitialGuess(self, arg0: numpy.ndarray[object[m, n]], arg1: numpy.ndarray[numpy.float64[m, n]]) -> None: ...
    def SetInitialGuessForAllVariables(self, arg0: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def SetSolverOption(self, solver_id: SolverId, solver_option: str, option_value: float) -> None: ...
    @overload
    def SetSolverOption(self, solver_id: SolverId, solver_option: str, option_value: int) -> None: ...
    @overload
    def SetSolverOption(self, solver_id: SolverId, solver_option: str, option_value: str) -> None: ...
    @overload
    def SetSolverOption(self, arg0: SolverType, arg1: str, arg2: float) -> None: ...
    @overload
    def SetSolverOption(self, arg0: SolverType, arg1: str, arg2: int) -> None: ...
    @overload
    def SetSolverOption(self, arg0: SolverType, arg1: str, arg2: str) -> None: ...
    def SetSolverOptions(self, arg0: SolverOptions) -> None: ...
    def SetVariableScaling(self, var: pydrake.symbolic.Variable, s: float) -> None: ...
    def TightenPsdConstraintToDd(self, constraint: BindingTPositiveSemidefiniteConstraintU) -> numpy.ndarray[object[m, n]]: ...
    def TightenPsdConstraintToSdd(self, constraint: BindingTPositiveSemidefiniteConstraintU) -> list[list[numpy.ndarray[object[2, 2]]]]: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def bounding_box_constraints(self) -> list[BindingTBoundingBoxConstraintU]: ...
    def decision_variable(self, i: int) -> pydrake.symbolic.Variable: ...
    def decision_variable_index(self) -> dict[int, int]: ...
    def decision_variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def exponential_cone_constraints(self) -> list[BindingTExponentialConeConstraintU]: ...
    def generic_constraints(self) -> list[BindingTConstraintU]: ...
    def generic_costs(self) -> list[BindingTCostU]: ...
    def indeterminate(self, i: int) -> pydrake.symbolic.Variable: ...
    def indeterminates(self) -> numpy.ndarray[object[m, 1]]: ...
    def indeterminates_index(self) -> dict[int, int]: ...
    def initial_guess(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def l2norm_costs(self) -> list[BindingTL2NormCostU]: ...
    def linear_complementarity_constraints(self) -> list[BindingTLinearComplementarityConstraintU]: ...
    def linear_constraints(self) -> list[BindingTLinearConstraintU]: ...
    def linear_costs(self) -> list[BindingTLinearCostU]: ...
    def linear_equality_constraints(self) -> list[BindingTLinearEqualityConstraintU]: ...
    def linear_matrix_inequality_constraints(self) -> list[BindingTLinearMatrixInequalityConstraintU]: ...
    def lorentz_cone_constraints(self) -> list[BindingTLorentzConeConstraintU]: ...
    def num_indeterminates(self) -> int: ...
    def num_vars(self) -> int: ...
    def positive_semidefinite_constraints(self) -> list[BindingTPositiveSemidefiniteConstraintU]: ...
    def quadratic_constraints(self) -> list[BindingTQuadraticConstraintU]: ...
    def quadratic_costs(self) -> list[BindingTQuadraticCostU]: ...
    def required_capabilities(self) -> set[ProgramAttribute]: ...
    def rotated_lorentz_cone_constraints(self) -> list[BindingTRotatedLorentzConeConstraintU]: ...
    def solver_options(self) -> SolverOptions: ...
    def visualization_callbacks(self) -> list[BindingTVisualizationCallbackU]: ...
    def __copy__(self) -> MathematicalProgram: ...
    def __deepcopy__(self, arg0: dict) -> MathematicalProgram: ...

class MathematicalProgramResult:
    def __init__(self) -> None: ...
    def EvalBinding(self, arg0: BindingTEvaluatorBaseU) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetDualSolution(self, arg0: BindingTEvaluatorBaseU) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetDualSolution(self, constraint) -> Any: ...
    def GetInfeasibleConstraintNames(self, prog: MathematicalProgram, tol: float | None = ...) -> list[str]: ...
    def GetInfeasibleConstraints(self, prog: MathematicalProgram, tol: float | None = ...) -> list[BindingTConstraintU]: ...
    @overload
    def GetSolution(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetSolution(self, arg0: pydrake.symbolic.Variable) -> float: ...
    @overload
    def GetSolution(self, arg0: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetSolution(self, arg0: numpy.ndarray[object[m, n]]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def GetSolution(self, arg0: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
    @overload
    def GetSolution(self, arg0: pydrake.symbolic.Polynomial) -> pydrake.symbolic.Polynomial: ...
    @overload
    def GetSuboptimalSolution(self, arg0: pydrake.symbolic.Variable, arg1: int) -> float: ...
    @overload
    def GetSuboptimalSolution(self, arg0: numpy.ndarray[object[m, 1]], arg1: int) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetSuboptimalSolution(self, arg0: numpy.ndarray[object[m, n]], arg1: int) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def SetSolution(self, var: pydrake.symbolic.Variable, value: float) -> None: ...
    def get_optimal_cost(self) -> float: ...
    def get_solution_result(self) -> SolutionResult: ...
    def get_solver_details(self) -> object: ...
    def get_solver_id(self) -> SolverId: ...
    def get_suboptimal_objective(self, solution_number: int) -> float: ...
    def get_x_val(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def is_success(self) -> bool: ...
    def num_suboptimal_solution(self) -> int: ...
    def set_solution_result(self, arg0: SolutionResult) -> None: ...
    def set_x_val(self, x_val: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class MinimumValueLowerBoundConstraint(Constraint):
    def __init__(self, num_vars: int, minimum_value_lower: float, influence_value_offset: float, max_num_values: int, value_function: Callable[[numpy.ndarray[object[m, 1]], float], numpy.ndarray[object[m, 1]]], value_function_double: Callable[[numpy.ndarray[numpy.float64[m, 1]], float], numpy.ndarray[numpy.float64[m, 1]]] = ...) -> None: ...
    def influence_value(self) -> float: ...
    def minimum_value_lower(self) -> float: ...
    def set_penalty_function(self, new_penalty_function: Callable[[float, bool], tuple]) -> None: ...

class MinimumValueUpperBoundConstraint(Constraint):
    def __init__(self, num_vars: int, minimum_value_upper: float, influence_value_offset: float, max_num_values: int, value_function: Callable[[numpy.ndarray[object[m, 1]], float], numpy.ndarray[object[m, 1]]], value_function_double: Callable[[numpy.ndarray[numpy.float64[m, 1]], float], numpy.ndarray[numpy.float64[m, 1]]] = ...) -> None: ...
    def influence_value(self) -> float: ...
    def minimum_value_upper(self) -> float: ...
    def set_penalty_function(self, new_penalty_function: Callable[[float, bool], tuple]) -> None: ...

class MixedIntegerBranchAndBound:
    class Options:
        __fields__: ClassVar[tuple] = ...  # read-only
        max_explored_nodes: int
        def __init__(self, **kwargs) -> None: ...
        def __copy__(self) -> MixedIntegerBranchAndBound.Options: ...
        def __deepcopy__(self, arg0: dict) -> MixedIntegerBranchAndBound.Options: ...
    def __init__(self, prog: MathematicalProgram, solver_id: SolverId, options: MixedIntegerBranchAndBound.Options = ...) -> None: ...
    def GetOptimalCost(self) -> float: ...
    def GetSolution(self, mip_var: pydrake.symbolic.Variable, nth_best_solution: int = ...) -> float: ...
    def GetSubOptimalCost(self, nth_suboptimal_cost: int) -> float: ...
    def Solve(self) -> SolutionResult: ...

class MixedIntegerRotationConstraintGenerator:
    class Approach:
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        kBilinearMcCormick: ClassVar[MixedIntegerRotationConstraintGenerator.Approach] = ...
        kBoth: ClassVar[MixedIntegerRotationConstraintGenerator.Approach] = ...
        kBoxSphereIntersection: ClassVar[MixedIntegerRotationConstraintGenerator.Approach] = ...
        def __init__(self, value: int) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class ReturnType:
        def __init__(self, *args, **kwargs) -> None: ...
        @property
        def B_(self): ...
        @property
        def lambda_(self): ...
    def __init__(self, approach: MixedIntegerRotationConstraintGenerator.Approach, num_intervals_per_half_axis: int, interval_binning: IntervalBinning) -> None: ...
    def AddToProgram(self, R: numpy.ndarray[object[3, 3], flags.f_contiguous], prog: MathematicalProgram) -> MixedIntegerRotationConstraintGenerator.ReturnType: ...
    def interval_binning(self) -> IntervalBinning: ...
    def num_intervals_per_half_axis(self) -> int: ...
    def phi(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def phi_nonnegative(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class MobyLCPSolver(SolverInterface):
    def __init__(self) -> None: ...
    @staticmethod
    def id() -> SolverId: ...

class MobyLcpSolver(SolverInterface):
    def __init__(self) -> None: ...
    @staticmethod
    def id() -> SolverId: ...

class MosekSolver(SolverInterface):
    class License:
        def __init__(self, *args, **kwargs) -> None: ...
        def is_valid(self) -> bool: ...
        def __enter__(self) -> MosekSolver.License: ...
        def __exit__(self, *args, **kwargs) -> None: ...
    def __init__(self) -> None: ...
    @staticmethod
    def AcquireLicense() -> MosekSolver.License: ...
    @staticmethod
    def id() -> SolverId: ...

class MosekSolverDetails:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def optimizer_time(self) -> float: ...
    @property
    def rescode(self) -> int: ...
    @property
    def solution_status(self) -> int: ...

class NloptSolver(SolverInterface):
    def __init__(self) -> None: ...
    @staticmethod
    def AlgorithmName() -> str: ...
    @staticmethod
    def ConstraintToleranceName() -> str: ...
    @staticmethod
    def MaxEvalName() -> str: ...
    @staticmethod
    def MaxTimeName() -> str: ...
    @staticmethod
    def XAbsoluteToleranceName() -> str: ...
    @staticmethod
    def XRelativeToleranceName() -> str: ...
    @staticmethod
    def id() -> SolverId: ...

class NloptSolverDetails:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def status(self) -> int: ...

class OsqpSolver(SolverInterface):
    def __init__(self) -> None: ...
    @staticmethod
    def id() -> SolverId: ...

class OsqpSolverDetails:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def dual_res(self) -> float: ...
    @property
    def iter(self) -> int: ...
    @property
    def polish_time(self) -> float: ...
    @property
    def primal_res(self) -> float: ...
    @property
    def run_time(self) -> float: ...
    @property
    def setup_time(self) -> float: ...
    @property
    def solve_time(self) -> float: ...
    @property
    def status_val(self) -> int: ...
    @property
    def y(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class PerspectiveQuadraticCost(Cost):
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n]], b: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def A(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def UpdateCoefficients(self, new_A: numpy.ndarray[numpy.float64[m, n]], new_b: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def b(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def update_A_entry(self, i: int, j: int, val: float) -> None: ...
    def update_b_entry(self, i: int, val: float) -> None: ...

class PositiveSemidefiniteConstraint(Constraint):
    def __init__(self, rows: int) -> None: ...
    def matrix_rows(self) -> int: ...

class ProgramAttribute:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kBinaryVariable: ClassVar[ProgramAttribute] = ...
    kCallback: ClassVar[ProgramAttribute] = ...
    kExponentialConeConstraint: ClassVar[ProgramAttribute] = ...
    kGenericConstraint: ClassVar[ProgramAttribute] = ...
    kGenericCost: ClassVar[ProgramAttribute] = ...
    kL2NormCost: ClassVar[ProgramAttribute] = ...
    kLinearComplementarityConstraint: ClassVar[ProgramAttribute] = ...
    kLinearConstraint: ClassVar[ProgramAttribute] = ...
    kLinearCost: ClassVar[ProgramAttribute] = ...
    kLinearEqualityConstraint: ClassVar[ProgramAttribute] = ...
    kLorentzConeConstraint: ClassVar[ProgramAttribute] = ...
    kPositiveSemidefiniteConstraint: ClassVar[ProgramAttribute] = ...
    kQuadraticConstraint: ClassVar[ProgramAttribute] = ...
    kQuadraticCost: ClassVar[ProgramAttribute] = ...
    kRotatedLorentzConeConstraint: ClassVar[ProgramAttribute] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class ProgramType:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kCGP: ClassVar[ProgramType] = ...
    kGP: ClassVar[ProgramType] = ...
    kLCP: ClassVar[ProgramType] = ...
    kLP: ClassVar[ProgramType] = ...
    kMILP: ClassVar[ProgramType] = ...
    kMIQP: ClassVar[ProgramType] = ...
    kMISDP: ClassVar[ProgramType] = ...
    kMISOCP: ClassVar[ProgramType] = ...
    kNLP: ClassVar[ProgramType] = ...
    kQP: ClassVar[ProgramType] = ...
    kQuadraticCostConicConstraint: ClassVar[ProgramType] = ...
    kSDP: ClassVar[ProgramType] = ...
    kSOCP: ClassVar[ProgramType] = ...
    kUnknown: ClassVar[ProgramType] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class ProjectedGradientDescentSolver(SolverInterface):
    kDefaultBacktrackingAlpha0: ClassVar[float] = ...
    kDefaultBacktrackingC: ClassVar[float] = ...
    kDefaultBacktrackingTau: ClassVar[float] = ...
    kDefaultConvergenceTol: ClassVar[float] = ...
    kDefaultMaxIterations: ClassVar[int] = ...
    kDefaultMaxLineSearchSteps: ClassVar[int] = ...
    def __init__(self) -> None: ...
    @staticmethod
    def BacktrackingAlpha0OptionName() -> str: ...
    @staticmethod
    def BacktrackingCOptionName() -> str: ...
    @staticmethod
    def BacktrackingTauOptionName() -> str: ...
    @staticmethod
    def ConvergenceTolOptionName() -> str: ...
    @staticmethod
    def MaxIterationsOptionName() -> str: ...
    def SetCustomGradientFunction(self, custom_gradient_function: Callable[[numpy.ndarray[numpy.float64[m, 1]]], numpy.ndarray[numpy.float64[m, 1]]]) -> None: ...
    def SetCustomProjectionFunction(self, custom_projection_function: Callable) -> None: ...
    def SetProjectionSolverInterface(self, projection_solver_interface: SolverInterface) -> None: ...
    @staticmethod
    def id() -> SolverId: ...

class PyFunctionConstraint(Constraint):
    def __init__(self, num_vars: int, func: Callable, lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]], description: str = ...) -> None: ...
    def UpdateLowerBound(self, new_lb: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def UpdateUpperBound(self, new_ub: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_bounds(self, lower_bound: numpy.ndarray[numpy.float64[m, 1]], upper_bound: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class PyFunctionCost(Cost):
    def __init__(self, num_vars: int, func: Callable, description: str = ...) -> None: ...

class QuadraticConstraint(Constraint):
    class HessianType:
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        kIndefinite: ClassVar[QuadraticConstraint.HessianType] = ...
        kNegativeSemidefinite: ClassVar[QuadraticConstraint.HessianType] = ...
        kPositiveSemidefinite: ClassVar[QuadraticConstraint.HessianType] = ...
        kZero: ClassVar[QuadraticConstraint.HessianType] = ...
        def __init__(self, value: int) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    def __init__(self, Q0: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], b: numpy.ndarray[numpy.float64[m, 1]], lb: float, ub: float, hessian_type: QuadraticConstraint.HessianType | None = ...) -> None: ...
    def Q(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def UpdateCoefficients(self, new_Q: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], new_b: numpy.ndarray[numpy.float64[m, 1]], hessian_type: QuadraticConstraint.HessianType | None = ...) -> None: ...
    def b(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def hessian_type(self) -> QuadraticConstraint.HessianType: ...
    def is_convex(self) -> bool: ...

class QuadraticCost(Cost):
    def __init__(self, Q: numpy.ndarray[numpy.float64[m, n]], b: numpy.ndarray[numpy.float64[m, 1]], c: float, is_convex: bool | None = ...) -> None: ...
    def Q(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def UpdateCoefficients(self, new_Q: numpy.ndarray[numpy.float64[m, n]], new_b: numpy.ndarray[numpy.float64[m, 1]], new_c: float = ..., is_convex: bool | None = ...) -> None: ...
    def UpdateHessianEntry(self, i: int, j: int, val: float, is_hessian_psd: bool | None = ...) -> None: ...
    def b(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def c(self) -> float: ...
    def is_convex(self) -> bool: ...
    def update_constant_term(self, new_c: float) -> None: ...
    def update_linear_coefficient_entry(self, i: int, val: float) -> None: ...

class RemoveFreeVariableMethod:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kLorentzConeSlack: ClassVar[RemoveFreeVariableMethod] = ...
    kNullspace: ClassVar[RemoveFreeVariableMethod] = ...
    kTwoSlackVariables: ClassVar[RemoveFreeVariableMethod] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class RotatedLorentzConeConstraint(Constraint):
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n]], b: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def A(self) -> scipy.sparse.csc_matrix[numpy.float64]: ...
    def UpdateCoefficients(self, new_A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], new_b: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def b(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class ScsSolver(SolverInterface):
    def __init__(self) -> None: ...
    @staticmethod
    def id() -> SolverId: ...

class ScsSolverDetails:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def dual_objective(self) -> float: ...
    @property
    def duality_gap(self) -> float: ...
    @property
    def iter(self) -> int: ...
    @property
    def primal_objective(self) -> float: ...
    @property
    def primal_residue(self) -> float: ...
    @property
    def residue_infeasibility(self) -> float: ...
    @property
    def residue_unbounded_a(self) -> float: ...
    @property
    def residue_unbounded_p(self) -> float: ...
    @property
    def s(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @property
    def scs_setup_time(self) -> float: ...
    @property
    def scs_solve_time(self) -> float: ...
    @property
    def scs_status(self) -> int: ...
    @property
    def y(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class SemidefiniteRelaxationOptions:
    add_implied_linear_constraints: bool
    add_implied_linear_equality_constraints: bool
    def __init__(self, **kwargs) -> None: ...
    def set_to_strongest(self) -> None: ...
    def set_to_weakest(self) -> None: ...

class SnoptSolver(SolverInterface):
    def __init__(self) -> None: ...
    @staticmethod
    def id() -> SolverId: ...

class SnoptSolverDetails:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def F(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @property
    def Fmul(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @property
    def info(self) -> int: ...
    @property
    def solve_time(self) -> float: ...
    @property
    def xmul(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class SolutionResult:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kDualInfeasible: ClassVar[SolutionResult] = ...
    kInfeasibleConstraints: ClassVar[SolutionResult] = ...
    kInfeasibleOrUnbounded: ClassVar[SolutionResult] = ...
    kInvalidInput: ClassVar[SolutionResult] = ...
    kIterationLimit: ClassVar[SolutionResult] = ...
    kSolutionFound: ClassVar[SolutionResult] = ...
    kSolutionResultNotSet: ClassVar[SolutionResult] = ...
    kSolverSpecificError: ClassVar[SolutionResult] = ...
    kUnbounded: ClassVar[SolutionResult] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SolverId:
    def __init__(self, name: str) -> None: ...
    def name(self) -> str: ...
    def __eq__(self, arg0: SolverId) -> bool: ...
    def __hash__(self) -> int: ...
    def __ne__(self, arg0: SolverId) -> bool: ...

class SolverInterface:
    def __init__(self) -> None: ...
    def AreProgramAttributesSatisfied(self, prog: MathematicalProgram) -> bool: ...
    def ExplainUnsatisfiedProgramAttributes(self, prog: MathematicalProgram) -> str: ...
    @overload
    def Solve(self, prog: MathematicalProgram, initial_guess: numpy.ndarray[numpy.float64[m, 1]] | None, solver_options: SolverOptions | None, result: MathematicalProgramResult) -> None: ...
    @overload
    def Solve(self, prog: MathematicalProgram, initial_guess: numpy.ndarray[numpy.float64[m, 1]] | None = ..., solver_options: SolverOptions | None = ...) -> MathematicalProgramResult: ...
    @overload
    def Solve(self) -> Any: ...
    def SolverName(self) -> str: ...
    def available(self) -> bool: ...
    def enabled(self) -> bool: ...
    def solver_id(self) -> SolverId: ...
    def solver_type(self) -> SolverType | None: ...

class SolverOptions:
    __fields__: ClassVar[tuple] = ...  # read-only
    options: dict[str, dict[str, float | int | str]]
    def __init__(self, options: dict[str, dict[str, float | int | str]] = ...) -> None: ...
    def SetOption(self, solver_id: SolverId, key: str, value: float | int | str) -> None: ...
    def __copy__(self) -> SolverOptions: ...
    def __deepcopy__(self, arg0: dict) -> SolverOptions: ...
    def __eq__(self, arg0: SolverOptions) -> bool: ...
    def __ne__(self, arg0: SolverOptions) -> bool: ...

class SolverType:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kClp: ClassVar[SolverType] = ...
    kCsdp: ClassVar[SolverType] = ...
    kEqualityConstrainedQP: ClassVar[SolverType] = ...
    kGurobi: ClassVar[SolverType] = ...
    kIpopt: ClassVar[SolverType] = ...
    kLinearSystem: ClassVar[SolverType] = ...
    kMobyLCP: ClassVar[SolverType] = ...
    kMosek: ClassVar[SolverType] = ...
    kNlopt: ClassVar[SolverType] = ...
    kOsqp: ClassVar[SolverType] = ...
    kScs: ClassVar[SolverType] = ...
    kSnopt: ClassVar[SolverType] = ...
    kUnrevisedLemke: ClassVar[SolverType] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class UnrevisedLemkeSolver(SolverInterface):
    def __init__(self) -> None: ...
    @staticmethod
    def id() -> SolverId: ...

class VisualizationCallback(EvaluatorBase):
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake7solvers7BindingINS0_10ConstraintEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, c: Constraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def __init__(self, arg0: object) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> Constraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_10L1NormCostEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: L1NormCost, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> L1NormCost: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTL1NormCostU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_10L2NormCostEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: L2NormCost, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> L2NormCost: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTL2NormCostU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_10LinearCostEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: LinearCost, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> LinearCost: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTLinearCostU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_12LInfNormCostEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: LInfNormCost, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> LInfNormCost: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTLInfNormCostU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_13EvaluatorBaseEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, c: EvaluatorBase, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def __init__(self, arg0: object) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> EvaluatorBase: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTEvaluatorBaseU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_13QuadraticCostEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: QuadraticCost, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> QuadraticCost: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTQuadraticCostU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_14ExpressionCostEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: ExpressionCost, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> ExpressionCost: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTExpressionCostU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_16LinearConstraintEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: LinearConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> LinearConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTLinearConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_19QuadraticConstraintEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: QuadraticConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> QuadraticConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTQuadraticConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_20ExpressionConstraintEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: ExpressionConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> ExpressionConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTExpressionConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_21BoundingBoxConstraintEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: BoundingBoxConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> BoundingBoxConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTBoundingBoxConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_21LorentzConeConstraintEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: LorentzConeConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> LorentzConeConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTLorentzConeConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_21VisualizationCallbackEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: VisualizationCallback, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> VisualizationCallback: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTVisualizationCallbackU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_24LinearEqualityConstraintEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: LinearEqualityConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> LinearEqualityConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTLinearEqualityConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_24PerspectiveQuadraticCostEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: PerspectiveQuadraticCost, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> PerspectiveQuadraticCost: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTPerspectiveQuadraticCostU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_25ExponentialConeConstraintEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: ExponentialConeConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> ExponentialConeConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTExponentialConeConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_28RotatedLorentzConeConstraintEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: RotatedLorentzConeConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> RotatedLorentzConeConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTRotatedLorentzConeConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_30PositiveSemidefiniteConstraintEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: PositiveSemidefiniteConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> PositiveSemidefiniteConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTPositiveSemidefiniteConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_31LinearComplementarityConstraintEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: LinearComplementarityConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> LinearComplementarityConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTLinearComplementarityConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_32LinearMatrixInequalityConstraintEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: LinearMatrixInequalityConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> LinearMatrixInequalityConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTLinearMatrixInequalityConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_32MinimumValueLowerBoundConstraintEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: MinimumValueLowerBoundConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> MinimumValueLowerBoundConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTMinimumValueLowerBoundConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_32MinimumValueUpperBoundConstraintEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, c: MinimumValueUpperBoundConstraint, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> MinimumValueUpperBoundConstraint: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTMinimumValueUpperBoundConstraintU) -> bool: ...
    def __hash__(self) -> int: ...

class _TemporaryName_N5drake7solvers7BindingINS0_4CostEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, c: Cost, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def __init__(self, arg0: object) -> None: ...
    @overload
    def ToLatex(self, precision: int = ...) -> str: ...
    @overload
    def ToLatex(self) -> Any: ...
    def evaluator(self) -> Cost: ...
    def variables(self) -> numpy.ndarray[object[m, 1]]: ...
    def __eq__(self, arg0: BindingTCostU) -> bool: ...
    def __hash__(self) -> int: ...

def AddBilinearProductMcCormickEnvelopeSos2(prog: MathematicalProgram, x: pydrake.symbolic.Variable, y: pydrake.symbolic.Variable, w: pydrake.symbolic.Expression, phi_x: numpy.ndarray[numpy.float64[m, 1]], phi_y: numpy.ndarray[numpy.float64[m, 1]], Bx: numpy.ndarray[object[m, 1]], By: numpy.ndarray[object[m, 1]], binning: IntervalBinning) -> numpy.ndarray[object[m, n]]: ...
def AddLogarithmicSos1Constraint(prog: MathematicalProgram, num_lambda: int) -> tuple[numpy.ndarray[object[m, 1]], numpy.ndarray[object[m, 1]]]: ...
def AddLogarithmicSos2Constraint(prog: MathematicalProgram, lambdas: numpy.ndarray[object[m, 1]], binary_variable_name: str = ...) -> numpy.ndarray[object[m, 1]]: ...
def AddSos2Constraint(prog: MathematicalProgram, lambdas: numpy.ndarray[object[m, 1]], y: numpy.ndarray[object[m, 1]]) -> None: ...
def ChooseBestSolver(prog: MathematicalProgram) -> SolverId: ...
def GenerateSDPA(prog: MathematicalProgram, file_name: str, method: RemoveFreeVariableMethod = ...) -> bool: ...
def GetAvailableSolvers(prog_type: ProgramType) -> list[SolverId]: ...
def GetProgramType(arg0: MathematicalProgram) -> ProgramType: ...
def MakeFirstAvailableSolver(solver_ids: list[SolverId]) -> SolverInterface: ...
@overload
def MakeSemidefiniteRelaxation(prog: MathematicalProgram, options: SemidefiniteRelaxationOptions = ...) -> MathematicalProgram: ...
@overload
def MakeSemidefiniteRelaxation(prog: MathematicalProgram, variable_groups: list[pydrake.symbolic.Variables], options: SemidefiniteRelaxationOptions = ...) -> MathematicalProgram: ...
@overload
def MakeSemidefiniteRelaxation(prog) -> Any: ...
@overload
def MakeSemidefiniteRelaxation(prog, 
std) -> Any: ...
def MakeSolver(id: SolverId) -> SolverInterface: ...
def Solve(prog: MathematicalProgram, initial_guess: numpy.ndarray[numpy.float64[m, 1]] | None = ..., solver_options: SolverOptions | None = ...) -> MathematicalProgramResult: ...
@overload
def SolveInParallel(progs: list[MathematicalProgram], initial_guesses: list[numpy.ndarray[numpy.float64[m, 1]] | None] | None = ..., solver_options: list[SolverOptions | None] | None = ..., solver_ids: list[SolverId | None] | None = ..., parallelism: pydrake.common.Parallelism = ..., dynamic_schedule: bool = ...) -> list[MathematicalProgramResult]: ...
@overload
def SolveInParallel(progs: list[MathematicalProgram], initial_guesses: list[numpy.ndarray[numpy.float64[m, 1]] | None] | None = ..., solver_options: SolverOptions = ..., solver_id: SolverId | None = ..., parallelism: pydrake.common.Parallelism = ..., dynamic_schedule: bool = ...) -> list[MathematicalProgramResult]: ...
