import flags
import numpy
import pydrake.common
import pydrake.geometry
import pydrake.geometry.optimization
import pydrake.math
import pydrake.multibody.parsing
import pydrake.multibody.plant
import pydrake.multibody.rational
import pydrake.multibody.tree
import pydrake.solvers
import pydrake.symbolic
import pydrake.systems.framework
import pydrake.trajectories
import scipy.sparse
import typing
from pydrake.common.cpp_template import RobotDiagramBuilder_ as RobotDiagramBuilder_, RobotDiagram_ as RobotDiagram_
from typing import Any, Callable, ClassVar, overload

class BodyShapeDescription:
    @overload
    def __init__(self, shape: pydrake.geometry.Shape, X_BS: pydrake.math.RigidTransform, model_instance_name: str, body_name: str) -> None: ...
    @overload
    def __init__(self, other: BodyShapeDescription) -> None: ...
    def body_name(self) -> str: ...
    def model_instance_name(self) -> str: ...
    def pose_in_body(self) -> pydrake.math.RigidTransform: ...
    def shape(self) -> pydrake.geometry.Shape: ...
    def __copy__(self) -> BodyShapeDescription: ...
    def __deepcopy__(self, arg0: dict) -> BodyShapeDescription: ...

class CollisionChecker:
    def __init__(self, *args, **kwargs) -> None: ...
    def AddCollisionShape(self, group_name: str, description: BodyShapeDescription) -> bool: ...
    def AddCollisionShapeToBody(self, group_name: str, bodyA: pydrake.multibody.tree.RigidBody, shape: pydrake.geometry.Shape, X_AG: pydrake.math.RigidTransform) -> bool: ...
    def AddCollisionShapeToFrame(self, group_name: str, frameA: pydrake.multibody.tree.Frame, shape: pydrake.geometry.Shape, X_AG: pydrake.math.RigidTransform) -> bool: ...
    @overload
    def AddCollisionShapes(self, group_name: str, descriptions: list[BodyShapeDescription]) -> int: ...
    @overload
    def AddCollisionShapes(self, geometry_groups: dict[str, list[BodyShapeDescription]]) -> dict[str, int]: ...
    def CalcContextRobotClearance(self, model_context: CollisionCheckerContext, q: numpy.ndarray[numpy.float64[m, 1]], influence_distance: float) -> RobotClearance: ...
    def CalcRobotClearance(self, q: numpy.ndarray[numpy.float64[m, 1]], influence_distance: float, context_number: int | None = ...) -> RobotClearance: ...
    def CheckConfigCollisionFree(self, q: numpy.ndarray[numpy.float64[m, 1]], context_number: int | None = ...) -> bool: ...
    def CheckConfigsCollisionFree(self, configs: list[numpy.ndarray[numpy.float64[m, 1]]], parallelize: pydrake.common.Parallelism = ...) -> list[int]: ...
    def CheckContextConfigCollisionFree(self, model_context: CollisionCheckerContext, q: numpy.ndarray[numpy.float64[m, 1]]) -> bool: ...
    def CheckContextEdgeCollisionFree(self, model_context: CollisionCheckerContext, q1: numpy.ndarray[numpy.float64[m, 1]], q2: numpy.ndarray[numpy.float64[m, 1]]) -> bool: ...
    def CheckEdgeCollisionFree(self, q1: numpy.ndarray[numpy.float64[m, 1]], q2: numpy.ndarray[numpy.float64[m, 1]], context_number: int | None = ...) -> bool: ...
    def CheckEdgeCollisionFreeParallel(self, q1: numpy.ndarray[numpy.float64[m, 1]], q2: numpy.ndarray[numpy.float64[m, 1]], parallelize: pydrake.common.Parallelism = ...) -> bool: ...
    def CheckEdgesCollisionFree(self, edges: list[tuple[numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[numpy.float64[m, 1]]]], parallelize: pydrake.common.Parallelism = ...) -> list[int]: ...
    def ClassifyBodyCollisions(self, q: numpy.ndarray[numpy.float64[m, 1]], context_number: int | None = ...) -> list[RobotCollisionType]: ...
    def ClassifyContextBodyCollisions(self, model_context: CollisionCheckerContext, q: numpy.ndarray[numpy.float64[m, 1]]) -> list[RobotCollisionType]: ...
    def Clone(self) -> CollisionChecker: ...
    def ComputeConfigurationDistance(self, q1: numpy.ndarray[numpy.float64[m, 1]], q2: numpy.ndarray[numpy.float64[m, 1]]) -> float: ...
    def GetAllAddedCollisionShapes(self) -> dict[str, list[BodyShapeDescription]]: ...
    def GetFilteredCollisionMatrix(self) -> numpy.ndarray[numpy.int32[m, n]]: ...
    def GetLargestPadding(self) -> float: ...
    def GetNominalFilteredCollisionMatrix(self) -> numpy.ndarray[numpy.int32[m, n]]: ...
    @overload
    def GetPaddingBetween(self, bodyA_index: pydrake.multibody.tree.BodyIndex, bodyB_index: pydrake.multibody.tree.BodyIndex) -> float: ...
    @overload
    def GetPaddingBetween(self, bodyA: pydrake.multibody.tree.RigidBody, bodyB: pydrake.multibody.tree.RigidBody) -> float: ...
    def GetPaddingMatrix(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def GetZeroConfiguration(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def InterpolateBetweenConfigurations(self, q1: numpy.ndarray[numpy.float64[m, 1]], q2: numpy.ndarray[numpy.float64[m, 1]], ratio: float) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def IsCollisionFilteredBetween(self, bodyA_index: pydrake.multibody.tree.BodyIndex, bodyB_index: pydrake.multibody.tree.BodyIndex) -> bool: ...
    @overload
    def IsCollisionFilteredBetween(self, bodyA: pydrake.multibody.tree.RigidBody, bodyB: pydrake.multibody.tree.RigidBody) -> bool: ...
    @overload
    def IsPartOfRobot(self, body: pydrake.multibody.tree.RigidBody) -> bool: ...
    @overload
    def IsPartOfRobot(self, body_index: pydrake.multibody.tree.BodyIndex) -> bool: ...
    def MakeStandaloneConfigurationDistanceFunction(self) -> Callable[[numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[numpy.float64[m, 1]]], float]: ...
    def MakeStandaloneConfigurationInterpolationFunction(self) -> Callable[[numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[numpy.float64[m, 1]], float], numpy.ndarray[numpy.float64[m, 1]]]: ...
    def MakeStandaloneModelContext(self) -> CollisionCheckerContext: ...
    def MaxContextNumDistances(self, model_context: CollisionCheckerContext) -> int: ...
    def MaxNumDistances(self, context_number: int | None = ...) -> int: ...
    def MaybeGetUniformRobotEnvironmentPadding(self) -> float | None: ...
    def MaybeGetUniformRobotRobotPadding(self) -> float | None: ...
    def MeasureContextEdgeCollisionFree(self, model_context: CollisionCheckerContext, q1: numpy.ndarray[numpy.float64[m, 1]], q2: numpy.ndarray[numpy.float64[m, 1]]) -> EdgeMeasure: ...
    def MeasureEdgeCollisionFree(self, q1: numpy.ndarray[numpy.float64[m, 1]], q2: numpy.ndarray[numpy.float64[m, 1]], context_number: int | None = ...) -> EdgeMeasure: ...
    def MeasureEdgeCollisionFreeParallel(self, q1: numpy.ndarray[numpy.float64[m, 1]], q2: numpy.ndarray[numpy.float64[m, 1]], parallelize: pydrake.common.Parallelism = ...) -> EdgeMeasure: ...
    def MeasureEdgesCollisionFree(self, edges: list[tuple[numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[numpy.float64[m, 1]]]], parallelize: pydrake.common.Parallelism = ...) -> list[EdgeMeasure]: ...
    def PerformOperationAgainstAllModelContexts(self, operation: Callable[[RobotDiagram, CollisionCheckerContext], None]) -> None: ...
    @overload
    def RemoveAllAddedCollisionShapes(self, group_name: str) -> None: ...
    @overload
    def RemoveAllAddedCollisionShapes(self) -> None: ...
    def SetCollisionFilterMatrix(self, filter_matrix: numpy.ndarray[numpy.int32[m, n]]) -> None: ...
    @overload
    def SetCollisionFilteredBetween(self, bodyA_index: pydrake.multibody.tree.BodyIndex, bodyB_index: pydrake.multibody.tree.BodyIndex, filter_collision: bool) -> None: ...
    @overload
    def SetCollisionFilteredBetween(self, bodyA: pydrake.multibody.tree.RigidBody, bodyB: pydrake.multibody.tree.RigidBody, filter_collision: bool) -> None: ...
    def SetCollisionFilteredWithAllBodies(self, body_index: pydrake.multibody.tree.BodyIndex) -> None: ...
    def SetConfigurationDistanceFunction(self, distance_function: Callable[[numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[numpy.float64[m, 1]]], float]) -> None: ...
    def SetConfigurationInterpolationFunction(self, interpolation_function: Callable[[numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[numpy.float64[m, 1]], float], numpy.ndarray[numpy.float64[m, 1]]]) -> None: ...
    def SetDistanceAndInterpolationProvider(self, provider: DistanceAndInterpolationProvider) -> None: ...
    def SetPaddingAllRobotEnvironmentPairs(self, padding: float) -> None: ...
    def SetPaddingAllRobotRobotPairs(self, padding: float) -> None: ...
    @overload
    def SetPaddingBetween(self, bodyA_index: pydrake.multibody.tree.BodyIndex, bodyB_index: pydrake.multibody.tree.BodyIndex, padding: float) -> None: ...
    @overload
    def SetPaddingBetween(self, bodyA: pydrake.multibody.tree.RigidBody, bodyB: pydrake.multibody.tree.RigidBody, padding: float) -> None: ...
    def SetPaddingMatrix(self, collision_padding: numpy.ndarray[numpy.float64[m, n]]) -> None: ...
    def SetPaddingOneRobotBodyAllEnvironmentPairs(self, body_index: pydrake.multibody.tree.BodyIndex, padding: float) -> None: ...
    def SupportsParallelChecking(self) -> bool: ...
    def UpdateContextPositions(self, model_context: CollisionCheckerContext, q: numpy.ndarray[numpy.float64[m, 1]]) -> pydrake.systems.framework.Context: ...
    def UpdatePositions(self, q: numpy.ndarray[numpy.float64[m, 1]], context_number: int | None = ...) -> pydrake.systems.framework.Context: ...
    def distance_and_interpolation_provider(self) -> DistanceAndInterpolationProvider: ...
    def edge_step_size(self) -> float: ...
    def get_body(self, body_index: pydrake.multibody.tree.BodyIndex) -> pydrake.multibody.tree.RigidBody: ...
    def model(self) -> RobotDiagram: ...
    def model_context(self, context_number: int | None = ...) -> CollisionCheckerContext: ...
    def num_allocated_contexts(self) -> int: ...
    def plant(self) -> pydrake.multibody.plant.MultibodyPlant: ...
    def plant_context(self, context_number: int | None = ...) -> pydrake.systems.framework.Context: ...
    def robot_model_instances(self) -> list[pydrake.multibody.tree.ModelInstanceIndex]: ...
    def set_edge_step_size(self, edge_step_size: float) -> None: ...
    def __copy__(self) -> CollisionChecker: ...
    def __deepcopy__(self, arg0: dict) -> CollisionChecker: ...

class CollisionCheckerContext:
    def __init__(self, model: RobotDiagram) -> None: ...
    def Clone(self) -> CollisionCheckerContext: ...
    def GetQueryObject(self) -> pydrake.geometry.QueryObject: ...
    def model_context(self) -> pydrake.systems.framework.Context: ...
    def plant_context(self) -> pydrake.systems.framework.Context: ...
    def scene_graph_context(self) -> pydrake.systems.framework.Context: ...
    def __copy__(self) -> CollisionCheckerContext: ...
    def __deepcopy__(self, arg0: dict) -> CollisionCheckerContext: ...

class CollisionCheckerParams:
    configuration_distance_function: Callable[[numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[numpy.float64[m, 1]]], float]
    distance_and_interpolation_provider: DistanceAndInterpolationProvider
    edge_step_size: float
    env_collision_padding: float
    implicit_context_parallelism: pydrake.common.Parallelism
    model: RobotDiagram
    robot_model_instances: list[pydrake.multibody.tree.ModelInstanceIndex]
    self_collision_padding: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, **kwargs) -> None: ...

class CommonSampledIrisOptions:
    configuration_space_margin: float
    containment_points: numpy.ndarray[numpy.float64[m, n]] | None
    delta: float
    epsilon: float
    max_iterations: int
    max_iterations_separating_planes: int
    max_separating_planes_per_iteration: int
    mixing_steps: int
    num_particles: int
    parallelism: pydrake.common.Parallelism
    prog_with_additional_constraints: pydrake.solvers.MathematicalProgram
    random_seed: int
    relative_termination_threshold: float
    relax_margin: bool
    remove_all_collisions_possible: bool
    require_sample_point_is_contained: bool
    sample_particles_in_parallel: bool
    tau: float
    termination_threshold: float
    verbose: bool
    def __init__(self) -> None: ...

class DirectCollocation(MultipleShooting):
    def __init__(self, system: pydrake.systems.framework.System, context: pydrake.systems.framework.Context, num_time_samples: int, minimum_time_step: float, maximum_time_step: float, input_port_index: pydrake.systems.framework.InputPortSelection | pydrake.systems.framework.InputPortIndex = ..., assume_non_continuous_states_are_fixed: bool = ..., prog: pydrake.solvers.MathematicalProgram = ...) -> None: ...

class DirectCollocationConstraint(pydrake.solvers.Constraint):
    def __init__(self, system: pydrake.systems.framework.System, context: pydrake.systems.framework.Context, input_port_index: pydrake.systems.framework.InputPortSelection | pydrake.systems.framework.InputPortIndex = ..., assume_non_continuous_states_are_fixed: bool = ...) -> None: ...

class DirectTranscription(MultipleShooting):
    class TimeStep:
        value: float
        def __init__(self, value: float) -> None: ...
    @overload
    def __init__(self, system: pydrake.systems.framework.System, context: pydrake.systems.framework.Context, num_time_samples: int, input_port_index: pydrake.systems.framework.InputPortSelection | pydrake.systems.framework.InputPortIndex = ...) -> None: ...
    @overload
    def __init__(self, system: pydrake.systems.framework.System, context: pydrake.systems.framework.Context, num_time_samples: int, fixed_time_step: DirectTranscription.TimeStep, input_port_index: pydrake.systems.framework.InputPortSelection | pydrake.systems.framework.InputPortIndex = ...) -> None: ...

class DistanceAndInterpolationProvider:
    def __init__(self, *args, **kwargs) -> None: ...
    def ComputeConfigurationDistance(self, arg0: numpy.ndarray[numpy.float64[m, 1]], arg1: numpy.ndarray[numpy.float64[m, 1]]) -> float: ...
    def InterpolateBetweenConfigurations(self, arg0: numpy.ndarray[numpy.float64[m, 1]], arg1: numpy.ndarray[numpy.float64[m, 1]], arg2: float) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class DofMask:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, size: int, value: bool) -> None: ...
    @overload
    def __init__(self, values: list[bool]) -> None: ...
    def Complement(self) -> DofMask: ...
    @overload
    def GetFullToSelectedIndex(self) -> list[int | None]: ...
    @overload
    def GetFullToSelectedIndex(self) -> Any: ...
    @overload
    def GetFullToSelectedIndex(self) -> Any: ...
    def GetJoints(self, plant: pydrake.multibody.plant.MultibodyPlant) -> list[pydrake.multibody.tree.JointIndex]: ...
    @overload
    def GetSelectedToFullIndex(self) -> list[int]: ...
    @overload
    def GetSelectedToFullIndex(self) -> Any: ...
    def Intersect(self, other: DofMask) -> DofMask: ...
    @staticmethod
    def MakeFromModel(plant: pydrake.multibody.plant.MultibodyPlant, model_index: pydrake.multibody.tree.ModelInstanceIndex) -> DofMask: ...
    def Subtract(self, other: DofMask) -> DofMask: ...
    def Union(self, other: DofMask) -> DofMask: ...
    def count(self) -> int: ...
    def size(self) -> int: ...
    def __eq__(self, arg0: DofMask) -> bool: ...
    def __getitem__(self, arg0: int) -> bool: ...
    def __iter__(self) -> typing.Iterator[bool]: ...

class EdgeMeasure:
    @overload
    def __init__(self, distance: float, alpha: float) -> None: ...
    @overload
    def __init__(self, other: EdgeMeasure) -> None: ...
    def alpha(self) -> float: ...
    def alpha_or(self, default_value: float) -> float: ...
    def completely_free(self) -> bool: ...
    def distance(self) -> float: ...
    def partially_free(self) -> bool: ...
    def __copy__(self) -> EdgeMeasure: ...
    def __deepcopy__(self, arg0: dict) -> EdgeMeasure: ...

class GcsTrajectoryOptimization:
    class EdgesBetweenSubgraphs:
        def __init__(self, *args, **kwargs) -> None: ...
        def AddContinuityConstraints(self, continuity_order: int) -> None: ...
        @overload
        def AddEdgeConstraint(self, e: pydrake.symbolic.Formula, use_in_transcription: set[pydrake.geometry.optimization.GraphOfConvexSets.Transcription] = ...) -> None: ...
        @overload
        def AddEdgeConstraint(self, binding: pydrake.solvers.BindingTConstraintU, use_in_transcription: set[pydrake.geometry.optimization.GraphOfConvexSets.Transcription] = ...) -> None: ...
        @overload
        def AddEdgeCost(self, e: pydrake.symbolic.Expression, use_in_transcription: set[pydrake.geometry.optimization.GraphOfConvexSets.Transcription] = ...) -> None: ...
        @overload
        def AddEdgeCost(self, binding: pydrake.solvers.BindingTCostU, use_in_transcription: set[pydrake.geometry.optimization.GraphOfConvexSets.Transcription] = ...) -> None: ...
        def AddNonlinearDerivativeBounds(self, lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]], derivative_order: int) -> None: ...
        def AddPathContinuityConstraints(self, continuity_order: int) -> None: ...
        def AddVelocityBounds(self, lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
        def AddZeroDerivativeConstraints(self, derivative_order: int) -> None: ...
        def Edges(self) -> list[pydrake.geometry.optimization.GraphOfConvexSets.Edge]: ...
        def edge_constituent_vertex_control_points(self) -> tuple[numpy.ndarray[object[m, n]], numpy.ndarray[object[m, n]]]: ...
        def edge_constituent_vertex_durations(self) -> tuple[pydrake.symbolic.Variable, pydrake.symbolic.Variable]: ...

    class Subgraph:
        def __init__(self, *args, **kwargs) -> None: ...
        def AddContinuityConstraints(self, continuity_order: int) -> None: ...
        @overload
        def AddEdgeConstraint(self, e: pydrake.symbolic.Formula, use_in_transcription: set[pydrake.geometry.optimization.GraphOfConvexSets.Transcription] = ...) -> None: ...
        @overload
        def AddEdgeConstraint(self, binding: pydrake.solvers.BindingTConstraintU, use_in_transcription: set[pydrake.geometry.optimization.GraphOfConvexSets.Transcription] = ...) -> None: ...
        @overload
        def AddEdgeCost(self, e: pydrake.symbolic.Expression, use_in_transcription: set[pydrake.geometry.optimization.GraphOfConvexSets.Transcription] = ...) -> None: ...
        @overload
        def AddEdgeCost(self, binding: pydrake.solvers.BindingTCostU, use_in_transcription: set[pydrake.geometry.optimization.GraphOfConvexSets.Transcription] = ...) -> None: ...
        def AddNonlinearDerivativeBounds(self, lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]], derivative_order: int) -> None: ...
        def AddPathContinuityConstraints(self, continuity_order: int) -> None: ...
        @overload
        def AddPathEnergyCost(self, weight_matrix: numpy.ndarray[numpy.float64[m, n]]) -> None: ...
        @overload
        def AddPathEnergyCost(self, weight: float = ...) -> None: ...
        @overload
        def AddPathLengthCost(self, weight_matrix: numpy.ndarray[numpy.float64[m, n]]) -> None: ...
        @overload
        def AddPathLengthCost(self, weight: float = ...) -> None: ...
        def AddTimeCost(self, weight: float = ...) -> None: ...
        def AddVelocityBounds(self, lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
        @overload
        def AddVertexConstraint(self, e: pydrake.symbolic.Formula, use_in_transcription: set[pydrake.geometry.optimization.GraphOfConvexSets.Transcription] = ...) -> None: ...
        @overload
        def AddVertexConstraint(self, binding: pydrake.solvers.BindingTConstraintU, use_in_transcription: set[pydrake.geometry.optimization.GraphOfConvexSets.Transcription] = ...) -> None: ...
        @overload
        def AddVertexCost(self, e: pydrake.symbolic.Expression, use_in_transcription: set[pydrake.geometry.optimization.GraphOfConvexSets.Transcription] = ...) -> None: ...
        @overload
        def AddVertexCost(self, binding: pydrake.solvers.BindingTCostU, use_in_transcription: set[pydrake.geometry.optimization.GraphOfConvexSets.Transcription] = ...) -> None: ...
        def Edges(self) -> list[pydrake.geometry.optimization.GraphOfConvexSets.Edge]: ...
        def Vertices(self) -> list[pydrake.geometry.optimization.GraphOfConvexSets.Vertex]: ...
        def edge_constituent_vertex_control_points(self) -> tuple[numpy.ndarray[object[m, n]], numpy.ndarray[object[m, n]]]: ...
        def edge_constituent_vertex_durations(self) -> tuple[pydrake.symbolic.Variable, pydrake.symbolic.Variable]: ...
        def name(self) -> str: ...
        def order(self) -> int: ...
        def regions(self) -> object: ...
        def size(self) -> int: ...
        def vertex_control_points(self) -> numpy.ndarray[object[m, n]]: ...
        def vertex_duration(self) -> pydrake.symbolic.Variable: ...
    def __init__(self, num_positions: int, continuous_revolute_joints: list[int] = ...) -> None: ...
    def AddContinuityConstraints(self, continuity_order: int) -> None: ...
    def AddEdges(self, from_subgraph: GcsTrajectoryOptimization.Subgraph, to_subgraph: GcsTrajectoryOptimization.Subgraph, subspace: pydrake.geometry.optimization.ConvexSet = ..., edges_between_regions: list[tuple[int, int]] | None = ..., edge_offsets: list[numpy.ndarray[numpy.float64[m, 1]]] | None = ...) -> GcsTrajectoryOptimization.EdgesBetweenSubgraphs: ...
    def AddNonlinearDerivativeBounds(self, lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]], derivative_order: int) -> None: ...
    def AddPathContinuityConstraints(self, continuity_order: int) -> None: ...
    @overload
    def AddPathEnergyCost(self, weight_matrix: numpy.ndarray[numpy.float64[m, n]]) -> None: ...
    @overload
    def AddPathEnergyCost(self, weight: float = ...) -> None: ...
    @overload
    def AddPathLengthCost(self, weight_matrix: numpy.ndarray[numpy.float64[m, n]]) -> None: ...
    @overload
    def AddPathLengthCost(self, weight: float = ...) -> None: ...
    def AddRegions(self, regions: list[pydrake.geometry.optimization.ConvexSet], edges_between_regions: list[tuple[int, int]], order: int, h_min: float = ..., h_max: float = ..., name: str = ..., edge_offsets: list[numpy.ndarray[numpy.float64[m, 1]]] | None = ...) -> GcsTrajectoryOptimization.Subgraph: ...
    def AddTimeCost(self, weight: float = ...) -> None: ...
    def AddVelocityBounds(self, lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def GetEdgesBetweenSubgraphs(self) -> list[GcsTrajectoryOptimization.EdgesBetweenSubgraphs]: ...
    @overload
    def GetGraphvizString(self, result: pydrake.solvers.MathematicalProgramResult = ..., options: pydrake.geometry.optimization.GcsGraphvizOptions = ...) -> str: ...
    @overload
    def GetGraphvizString(self, result: pydrake.solvers.MathematicalProgramResult = ..., show_slacks: bool = ..., show_vars: bool = ..., show_flows: bool = ..., show_costs: bool = ..., scientific: bool = ..., precision: int = ...) -> str: ...
    def GetSubgraphs(self) -> list[GcsTrajectoryOptimization.Subgraph]: ...
    @staticmethod
    def NormalizeSegmentTimes(trajectory: pydrake.trajectories.CompositeTrajectory) -> pydrake.trajectories.CompositeTrajectory: ...
    def RemoveSubgraph(self, subgraph: GcsTrajectoryOptimization.Subgraph) -> None: ...
    def SolveConvexRestriction(self, active_vertices: list[pydrake.geometry.optimization.GraphOfConvexSets.Vertex], options: pydrake.geometry.optimization.GraphOfConvexSetsOptions = ...) -> tuple[pydrake.trajectories.CompositeTrajectory, pydrake.solvers.MathematicalProgramResult]: ...
    def SolvePath(self, source: GcsTrajectoryOptimization.Subgraph, target: GcsTrajectoryOptimization.Subgraph, options: pydrake.geometry.optimization.GraphOfConvexSetsOptions = ...) -> tuple[pydrake.trajectories.CompositeTrajectory, pydrake.solvers.MathematicalProgramResult]: ...
    @staticmethod
    def UnwrapToContinuousTrajectory(gcs_trajectory: pydrake.trajectories.CompositeTrajectory, continuous_revolute_joints: list[int], starting_rounds: list[int] | None = ..., tol: float = ...) -> pydrake.trajectories.CompositeTrajectory: ...
    def continuous_revolute_joints(self) -> list[int]: ...
    def graph_of_convex_sets(self) -> pydrake.geometry.optimization.GraphOfConvexSets: ...
    def num_positions(self) -> int: ...

class IrisFromCliqueCoverOptions:
    coverage_termination_threshold: float
    iris_options: pydrake.geometry.optimization.IrisOptions | IrisNp2Options | IrisZoOptions
    iteration_limit: int
    minimum_clique_size: int
    num_points_per_coverage_check: int
    num_points_per_visibility_round: int
    parallelism: pydrake.common.Parallelism
    point_in_set_tol: float
    rank_tol_for_minimum_volume_circumscribed_ellipsoid: float
    def __init__(self) -> None: ...

class IrisNp2Options:
    add_hyperplane_if_solve_fails: bool
    parameterization: IrisParameterizationFunction
    ray_sampler_options: RaySamplerOptions
    sampled_iris_options: CommonSampledIrisOptions
    sampling_strategy: str
    solver: pydrake.solvers.SolverInterface
    solver_options: pydrake.solvers.SolverOptions
    def __init__(self) -> None: ...

class IrisParameterizationFunction:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, parameterization: Callable, dimension: int) -> None: ...
    @overload
    def __init__(self, expression_parameterization: numpy.ndarray[object[m, 1]], variables: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def __init__(self, kin: pydrake.multibody.rational.RationalForwardKinematics, q_star_val: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def get_parameterization_autodiff(self) -> Callable[[numpy.ndarray[object[m, 1]]], numpy.ndarray[object[m, 1]]]: ...
    def get_parameterization_dimension(self) -> int | None: ...
    def get_parameterization_double(self) -> Callable[[numpy.ndarray[numpy.float64[m, 1]]], numpy.ndarray[numpy.float64[m, 1]]]: ...
    def get_parameterization_is_threadsafe(self) -> bool: ...

class IrisZoOptions:
    bisection_steps: int
    parameterization: IrisParameterizationFunction
    sampled_iris_options: CommonSampledIrisOptions
    def __init__(self) -> None: ...

class JointLimits:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, require_finite_positions: bool = ..., require_finite_velocities: bool = ..., require_finite_accelerations: bool = ...) -> None: ...
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, active_dof: DofMask, require_finite_positions: bool = ..., require_finite_velocities: bool = ..., require_finite_accelerations: bool = ...) -> None: ...
    @overload
    def __init__(self, other: JointLimits, active_dof: DofMask, require_finite_positions: bool = ..., require_finite_velocities: bool = ..., require_finite_accelerations: bool = ...) -> None: ...
    @overload
    def __init__(self, position_lower: numpy.ndarray[numpy.float64[m, 1]], position_upper: numpy.ndarray[numpy.float64[m, 1]], velocity_lower: numpy.ndarray[numpy.float64[m, 1]], velocity_upper: numpy.ndarray[numpy.float64[m, 1]], acceleration_lower: numpy.ndarray[numpy.float64[m, 1]], acceleration_upper: numpy.ndarray[numpy.float64[m, 1]], require_finite_positions: bool = ..., require_finite_velocities: bool = ..., require_finite_accelerations: bool = ...) -> None: ...
    def CheckInAccelerationLimits(self, acceleration: numpy.ndarray[numpy.float64[m, 1]], tolerance: float = ...) -> bool: ...
    def CheckInPositionLimits(self, position: numpy.ndarray[numpy.float64[m, 1]], tolerance: float = ...) -> bool: ...
    def CheckInVelocityLimits(self, velocity: numpy.ndarray[numpy.float64[m, 1]], tolerance: float = ...) -> bool: ...
    def acceleration_lower(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def acceleration_upper(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def num_accelerations(self) -> int: ...
    def num_positions(self) -> int: ...
    def num_velocities(self) -> int: ...
    def position_lower(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def position_upper(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def velocity_lower(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def velocity_upper(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class KinematicTrajectoryOptimization:
    @overload
    def __init__(self, num_positions: int, num_control_points: int, spline_order: int = ..., duration: float = ...) -> None: ...
    @overload
    def __init__(self, trajectory: pydrake.trajectories.BsplineTrajectory) -> None: ...
    def AddAccelerationBounds(self, lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]]) -> list[pydrake.solvers.BindingTConstraintU]: ...
    def AddDurationConstraint(self, lb: float | None, ub: float | None) -> pydrake.solvers.BindingTBoundingBoxConstraintU: ...
    def AddDurationCost(self, weight: float = ...) -> pydrake.solvers.BindingTLinearCostU: ...
    def AddEffortBoundsAtNormalizedTimes(self, plant: pydrake.multibody.plant.MultibodyPlant, s: numpy.ndarray[numpy.float64[m, 1]], lb: numpy.ndarray[numpy.float64[m, 1]] | None = ..., ub: numpy.ndarray[numpy.float64[m, 1]] | None = ..., plant_context: pydrake.systems.framework.Context = ...) -> list[pydrake.solvers.BindingTConstraintU]: ...
    def AddJerkBounds(self, lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]]) -> list[pydrake.solvers.BindingTConstraintU]: ...
    def AddPathAccelerationConstraint(self, lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]], s: float) -> pydrake.solvers.BindingTLinearConstraintU: ...
    def AddPathEnergyCost(self, weight: float = ...) -> list[pydrake.solvers.BindingTCostU]: ...
    def AddPathLengthCost(self, weight: float = ..., use_conic_constraint: bool = ...) -> list[pydrake.solvers.BindingTCostU]: ...
    @overload
    def AddPathPositionConstraint(self, lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]], s: float) -> pydrake.solvers.BindingTLinearConstraintU: ...
    @overload
    def AddPathPositionConstraint(self, constraint: pydrake.solvers.Constraint, s: float) -> pydrake.solvers.BindingTConstraintU: ...
    def AddPathVelocityConstraint(self, lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]], s: float) -> pydrake.solvers.BindingTLinearConstraintU: ...
    def AddPositionBounds(self, lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]]) -> list[pydrake.solvers.BindingTBoundingBoxConstraintU]: ...
    def AddVelocityBounds(self, lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]]) -> list[pydrake.solvers.BindingTLinearConstraintU]: ...
    @overload
    def AddVelocityConstraintAtNormalizedTime(self, constraint: pydrake.solvers.Constraint, s: float) -> pydrake.solvers.BindingTConstraintU: ...
    @overload
    def AddVelocityConstraintAtNormalizedTime(self, binding: pydrake.solvers.BindingTLinearConstraintU, s: float) -> list[pydrake.solvers.BindingTLinearConstraintU]: ...
    def ReconstructTrajectory(self, result: pydrake.solvers.MathematicalProgramResult) -> pydrake.trajectories.BsplineTrajectory: ...
    def SetInitialGuess(self, trajectory: pydrake.trajectories.BsplineTrajectory) -> None: ...
    def basis(self) -> pydrake.math.BsplineBasis: ...
    def control_points(self) -> numpy.ndarray[object[m, n]]: ...
    def duration(self) -> pydrake.symbolic.Variable: ...
    def get_mutable_prog(self) -> pydrake.solvers.MathematicalProgram: ...
    def num_control_points(self) -> int: ...
    def num_positions(self) -> int: ...
    def prog(self) -> pydrake.solvers.MathematicalProgram: ...
    def q(self) -> numpy.ndarray[object[m, 1]]: ...
    def qddot(self) -> numpy.ndarray[object[m, 1]]: ...
    def qdot(self) -> numpy.ndarray[object[m, 1]]: ...

class LinearDistanceAndInterpolationProvider(DistanceAndInterpolationProvider):
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant) -> None: ...
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, distance_weights: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, joint_distance_weights: dict[pydrake.multibody.tree.JointIndex, numpy.ndarray[numpy.float64[m, 1]]]) -> None: ...
    def distance_weights(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def quaternion_dof_start_indices(self) -> list[int]: ...

class MaxCliqueSolverBase:
    def __init__(self) -> None: ...
    def SolveMaxClique(self, adjacency_matrix: scipy.sparse.csc_matrix[bool]) -> numpy.ndarray[bool[m, 1]]: ...

class MaxCliqueSolverViaGreedy(MaxCliqueSolverBase):
    def __init__(self) -> None: ...

class MaxCliqueSolverViaMip(MaxCliqueSolverBase):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, initial_guess: numpy.ndarray[numpy.float64[m, 1]] | None, solver_options: pydrake.solvers.SolverOptions) -> None: ...
    def GetInitialGuess(self) -> numpy.ndarray[numpy.float64[m, 1]] | None: ...
    def GetSolverOptions(self) -> pydrake.solvers.SolverOptions: ...
    def SetInitialGuess(self, initial_guess: numpy.ndarray[numpy.float64[m, 1]] | None) -> None: ...
    def SetSolverOptions(self, solver_options: pydrake.solvers.SolverOptions) -> None: ...

class MinCliqueCoverSolverBase:
    def __init__(self) -> None: ...
    def SolveMinCliqueCover(self, adjacency_matrix: scipy.sparse.csc_matrix[bool], partition: bool = ...) -> list[set[int]]: ...

class MinCliqueCoverSolverViaGreedy(MinCliqueCoverSolverBase):
    def __init__(self, max_clique_solver: MaxCliqueSolverBase, min_clique_size: int = ...) -> None: ...
    def get_min_clique_size(self) -> int: ...
    def set_min_clique_size(self, min_clique_size: int) -> None: ...

class MultipleShooting:
    def __init__(self, *args, **kwargs) -> None: ...
    def AddCompleteTrajectoryCallback(self, callback: Callable[[numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], list[numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]]], None], names: list[str]) -> pydrake.solvers.BindingTVisualizationCallbackU: ...
    @overload
    def AddConstraintToAllKnotPoints(self, f: pydrake.symbolic.Formula) -> list[pydrake.solvers.BindingTConstraintU]: ...
    @overload
    def AddConstraintToAllKnotPoints(self, f: numpy.ndarray[object[m, 1]]) -> list[pydrake.solvers.BindingTConstraintU]: ...
    @overload
    def AddConstraintToAllKnotPoints(self, constraint: pydrake.solvers.BoundingBoxConstraint, vars: numpy.ndarray[object[m, 1]]) -> list[pydrake.solvers.BindingTBoundingBoxConstraintU]: ...
    @overload
    def AddConstraintToAllKnotPoints(self, constraint: pydrake.solvers.LinearEqualityConstraint, vars: numpy.ndarray[object[m, 1]]) -> list[pydrake.solvers.BindingTLinearEqualityConstraintU]: ...
    @overload
    def AddConstraintToAllKnotPoints(self, constraint: pydrake.solvers.LinearConstraint, vars: numpy.ndarray[object[m, 1]]) -> list[pydrake.solvers.BindingTLinearConstraintU]: ...
    @overload
    def AddConstraintToAllKnotPoints(self, constraint: pydrake.solvers.Constraint, vars: numpy.ndarray[object[m, 1]]) -> list[pydrake.solvers.BindingTConstraintU]: ...
    def AddDurationBounds(self, lower_bound: float, upper_bound: float) -> pydrake.solvers.BindingTLinearConstraintU: ...
    def AddEqualTimeIntervalsConstraints(self) -> list[pydrake.solvers.BindingTLinearConstraintU]: ...
    @overload
    def AddFinalCost(self, e: pydrake.symbolic.Expression) -> pydrake.solvers.BindingTCostU: ...
    @overload
    def AddFinalCost(self, matrix: numpy.ndarray[object[m, n], flags.f_contiguous]) -> pydrake.solvers.BindingTCostU: ...
    def AddInputTrajectoryCallback(self, callback: Callable[[numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]], None]) -> pydrake.solvers.BindingTVisualizationCallbackU: ...
    def AddRunningCost(self, g: pydrake.symbolic.Expression) -> None: ...
    def AddStateTrajectoryCallback(self, callback: Callable[[numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]], None]) -> pydrake.solvers.BindingTVisualizationCallbackU: ...
    def AddTimeIntervalBounds(self, lower_bound: float, upper_bound: float) -> pydrake.solvers.BindingTBoundingBoxConstraintU: ...
    def GetInputSamples(self, result: pydrake.solvers.MathematicalProgramResult) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def GetSampleTimes(self, result: pydrake.solvers.MathematicalProgramResult) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetSequentialVariableAtIndex(self, name: str, index: int) -> numpy.ndarray[object[m, 1]]: ...
    def GetSequentialVariableSamples(self, result: pydrake.solvers.MathematicalProgramResult, name: str) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def GetStateSamples(self, result: pydrake.solvers.MathematicalProgramResult) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def NewSequentialVariable(self, rows: int, name: str) -> numpy.ndarray[object[m, 1]]: ...
    def ReconstructInputTrajectory(self, result: pydrake.solvers.MathematicalProgramResult) -> pydrake.trajectories.PiecewisePolynomial: ...
    def ReconstructStateTrajectory(self, result: pydrake.solvers.MathematicalProgramResult) -> pydrake.trajectories.PiecewisePolynomial: ...
    def SetInitialTrajectory(self, traj_init_u: pydrake.trajectories.PiecewisePolynomial, traj_init_x: pydrake.trajectories.PiecewisePolynomial) -> None: ...
    def final_state(self) -> numpy.ndarray[object[m, 1]]: ...
    def fixed_time_step(self) -> float: ...
    def initial_state(self) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def input(self) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def input(self, index: int) -> numpy.ndarray[object[m, 1]]: ...
    def prog(self) -> pydrake.solvers.MathematicalProgram: ...
    @overload
    def state(self) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def state(self, index: int) -> numpy.ndarray[object[m, 1]]: ...
    def time(self) -> numpy.ndarray[object[1, 1]]: ...
    def time_step(self, index: int) -> numpy.ndarray[object[1, 1]]: ...

class RaySamplerOptions:
    num_particles_to_walk_towards: int
    only_walk_toward_collisions: bool
    ray_search_num_steps: int
    def __init__(self) -> None: ...

class RobotClearance:
    @overload
    def __init__(self, num_positions: int) -> None: ...
    @overload
    def __init__(self, other: RobotClearance) -> None: ...
    def Append(self, robot_index: pydrake.multibody.tree.BodyIndex, other_index: pydrake.multibody.tree.BodyIndex, collision_type: RobotCollisionType, distance: float, jacobian: numpy.ndarray[numpy.float64[1, n]]) -> None: ...
    def Reserve(self, size: int) -> None: ...
    def collision_types(self) -> list[RobotCollisionType]: ...
    def distances(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def jacobians(self) -> numpy.ndarray[numpy.float64[m, n], flags.c_contiguous]: ...
    def mutable_jacobians(self) -> numpy.ndarray[numpy.float64[m, n], flags.writeable, flags.c_contiguous]: ...
    def num_positions(self) -> int: ...
    def other_indices(self) -> list[pydrake.multibody.tree.BodyIndex]: ...
    def robot_indices(self) -> list[pydrake.multibody.tree.BodyIndex]: ...
    def size(self) -> int: ...
    def __copy__(self) -> RobotClearance: ...
    def __deepcopy__(self, arg0: dict) -> RobotClearance: ...

class RobotCollisionType:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kEnvironmentAndSelfCollision: ClassVar[RobotCollisionType] = ...
    kEnvironmentCollision: ClassVar[RobotCollisionType] = ...
    kNoCollision: ClassVar[RobotCollisionType] = ...
    kSelfCollision: ClassVar[RobotCollisionType] = ...
    def __init__(self, value: int) -> None: ...
    def MakeUpdated(self, in_environment_collision: bool | None = ..., in_self_collision: bool | None = ...) -> RobotCollisionType: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class RobotDiagram(pydrake.systems.framework.Diagram):
    def __init__(self, *args, **kwargs) -> None: ...
    def mutable_plant_context(self, root_context: pydrake.systems.framework.Context) -> pydrake.systems.framework.Context: ...
    def mutable_scene_graph(self) -> pydrake.geometry.SceneGraph: ...
    def mutable_scene_graph_context(self, root_context: pydrake.systems.framework.Context) -> pydrake.systems.framework.Context: ...
    @overload
    def plant(self) -> pydrake.multibody.plant.MultibodyPlant: ...
    @overload
    def plant(self, readonly) -> Any: ...
    def plant_context(self, root_context: pydrake.systems.framework.Context) -> pydrake.systems.framework.Context: ...
    def scene_graph(self) -> pydrake.geometry.SceneGraph: ...
    def scene_graph_context(self, root_context: pydrake.systems.framework.Context) -> pydrake.systems.framework.Context: ...

class RobotDiagramBuilder:
    def __init__(self, time_step: float = ...) -> None: ...
    def Build(self) -> object: ...
    def IsDiagramBuilt(self) -> bool: ...
    def builder(self) -> pydrake.systems.framework.DiagramBuilder: ...
    def parser(self) -> pydrake.multibody.parsing.Parser: ...
    @overload
    def plant(self) -> pydrake.multibody.plant.MultibodyPlant: ...
    @overload
    def plant(self, mutable) -> Any: ...
    def scene_graph(self) -> pydrake.geometry.SceneGraph: ...

class RobotDiagramBuilder_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, time_step: float = ...) -> None: ...
    def Build(self) -> object: ...
    def IsDiagramBuilt(self) -> bool: ...
    def builder(self) -> pydrake.systems.framework.DiagramBuilder_TAutoDiffXdU: ...
    @overload
    def plant(self) -> pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU: ...
    @overload
    def plant(self, mutable) -> Any: ...
    def scene_graph(self) -> pydrake.geometry.SceneGraph_TAutoDiffXdU: ...

class RobotDiagramBuilder_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, time_step: float = ...) -> None: ...
    def Build(self) -> object: ...
    def IsDiagramBuilt(self) -> bool: ...
    def builder(self) -> pydrake.systems.framework.DiagramBuilder_TExpressionU: ...
    @overload
    def plant(self) -> pydrake.multibody.plant.MultibodyPlant_TExpressionU: ...
    @overload
    def plant(self, mutable) -> Any: ...
    def scene_graph(self) -> pydrake.geometry.SceneGraph_TExpressionU: ...

class RobotDiagram_𝓣AutoDiffXd𝓤(pydrake.systems.framework.Diagram_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def mutable_plant_context(self, root_context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.systems.framework.Context_TAutoDiffXdU: ...
    def mutable_scene_graph(self) -> pydrake.geometry.SceneGraph_TAutoDiffXdU: ...
    def mutable_scene_graph_context(self, root_context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.systems.framework.Context_TAutoDiffXdU: ...
    @overload
    def plant(self) -> pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU: ...
    @overload
    def plant(self, readonly) -> Any: ...
    def plant_context(self, root_context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.systems.framework.Context_TAutoDiffXdU: ...
    def scene_graph(self) -> pydrake.geometry.SceneGraph_TAutoDiffXdU: ...
    def scene_graph_context(self, root_context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.systems.framework.Context_TAutoDiffXdU: ...

class RobotDiagram_𝓣Expression𝓤(pydrake.systems.framework.Diagram_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def mutable_plant_context(self, root_context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.systems.framework.Context_TExpressionU: ...
    def mutable_scene_graph(self) -> pydrake.geometry.SceneGraph_TExpressionU: ...
    def mutable_scene_graph_context(self, root_context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.systems.framework.Context_TExpressionU: ...
    @overload
    def plant(self) -> pydrake.multibody.plant.MultibodyPlant_TExpressionU: ...
    @overload
    def plant(self, readonly) -> Any: ...
    def plant_context(self, root_context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.systems.framework.Context_TExpressionU: ...
    def scene_graph(self) -> pydrake.geometry.SceneGraph_TExpressionU: ...
    def scene_graph_context(self, root_context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.systems.framework.Context_TExpressionU: ...

class SceneGraphCollisionChecker(CollisionChecker):
    def __init__(self, params: CollisionCheckerParams) -> None: ...

class UnimplementedCollisionChecker(CollisionChecker):
    def __init__(self, params: CollisionCheckerParams, supports_parallel_checking: bool) -> None: ...

class ZmpPlanner:
    def __init__(self) -> None: ...
    def ComputeOptimalCoMdd(self, time: float, x: numpy.ndarray[numpy.float64[4, 1]]) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    def Plan(self, zmp_d: pydrake.trajectories.PiecewisePolynomial, x0: numpy.ndarray[numpy.float64[4, 1]], height: float, gravity: float = ..., Qy: numpy.ndarray[numpy.float64[2, 2]] = ..., R: numpy.ndarray[numpy.float64[2, 2]] = ...) -> None: ...
    def comdd_to_cop(self, x: numpy.ndarray[numpy.float64[4, 1]], u: numpy.ndarray[numpy.float64[2, 1]]) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    def get_A(self) -> numpy.ndarray[numpy.float64[4, 4]]: ...
    def get_B(self) -> numpy.ndarray[numpy.float64[4, 2]]: ...
    def get_C(self) -> numpy.ndarray[numpy.float64[2, 4]]: ...
    def get_D(self) -> numpy.ndarray[numpy.float64[2, 2]]: ...
    def get_Qy(self) -> numpy.ndarray[numpy.float64[2, 2]]: ...
    def get_R(self) -> numpy.ndarray[numpy.float64[2, 2]]: ...
    @overload
    def get_Vx(self, time: float) -> numpy.ndarray[numpy.float64[4, 1]]: ...
    @overload
    def get_Vx(self) -> pydrake.trajectories.ExponentialPlusPiecewisePolynomial: ...
    def get_Vxx(self) -> numpy.ndarray[numpy.float64[4, 4]]: ...
    @overload
    def get_desired_zmp(self, time: float) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    @overload
    def get_desired_zmp(self) -> pydrake.trajectories.PiecewisePolynomial: ...
    def get_final_desired_zmp(self) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    @overload
    def get_nominal_com(self, time: float) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    @overload
    def get_nominal_com(self) -> pydrake.trajectories.ExponentialPlusPiecewisePolynomial: ...
    @overload
    def get_nominal_comd(self, time: float) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    @overload
    def get_nominal_comd(self) -> pydrake.trajectories.ExponentialPlusPiecewisePolynomial: ...
    @overload
    def get_nominal_comdd(self, time: float) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    @overload
    def get_nominal_comdd(self) -> pydrake.trajectories.ExponentialPlusPiecewisePolynomial: ...
    def has_planned(self) -> bool: ...
    def __copy__(self) -> ZmpPlanner: ...
    def __deepcopy__(self, arg0: dict) -> ZmpPlanner: ...

class _TemporaryName_N5drake8planning12RobotDiagramIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.Diagram_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def mutable_plant_context(self, root_context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.systems.framework.Context_TAutoDiffXdU: ...
    def mutable_scene_graph(self) -> pydrake.geometry.SceneGraph_TAutoDiffXdU: ...
    def mutable_scene_graph_context(self, root_context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.systems.framework.Context_TAutoDiffXdU: ...
    @overload
    def plant(self) -> pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU: ...
    @overload
    def plant(self, readonly) -> Any: ...
    def plant_context(self, root_context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.systems.framework.Context_TAutoDiffXdU: ...
    def scene_graph(self) -> pydrake.geometry.SceneGraph_TAutoDiffXdU: ...
    def scene_graph_context(self, root_context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.systems.framework.Context_TAutoDiffXdU: ...

class _TemporaryName_N5drake8planning12RobotDiagramINS_8symbolic10ExpressionEEE(pydrake.systems.framework.Diagram_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def mutable_plant_context(self, root_context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.systems.framework.Context_TExpressionU: ...
    def mutable_scene_graph(self) -> pydrake.geometry.SceneGraph_TExpressionU: ...
    def mutable_scene_graph_context(self, root_context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.systems.framework.Context_TExpressionU: ...
    @overload
    def plant(self) -> pydrake.multibody.plant.MultibodyPlant_TExpressionU: ...
    @overload
    def plant(self, readonly) -> Any: ...
    def plant_context(self, root_context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.systems.framework.Context_TExpressionU: ...
    def scene_graph(self) -> pydrake.geometry.SceneGraph_TExpressionU: ...
    def scene_graph_context(self, root_context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.systems.framework.Context_TExpressionU: ...

class _TemporaryName_N5drake8planning19RobotDiagramBuilderIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, time_step: float = ...) -> None: ...
    def Build(self) -> object: ...
    def IsDiagramBuilt(self) -> bool: ...
    def builder(self) -> pydrake.systems.framework.DiagramBuilder_TAutoDiffXdU: ...
    @overload
    def plant(self) -> pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU: ...
    @overload
    def plant(self, mutable) -> Any: ...
    def scene_graph(self) -> pydrake.geometry.SceneGraph_TAutoDiffXdU: ...

class _TemporaryName_N5drake8planning19RobotDiagramBuilderINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, time_step: float = ...) -> None: ...
    def Build(self) -> object: ...
    def IsDiagramBuilt(self) -> bool: ...
    def builder(self) -> pydrake.systems.framework.DiagramBuilder_TExpressionU: ...
    @overload
    def plant(self) -> pydrake.multibody.plant.MultibodyPlant_TExpressionU: ...
    @overload
    def plant(self, mutable) -> Any: ...
    def scene_graph(self) -> pydrake.geometry.SceneGraph_TExpressionU: ...

def AddDirectCollocationConstraint(constraint: DirectCollocationConstraint, time_step: numpy.ndarray[object[m, 1]], state: numpy.ndarray[object[m, 1]], next_state: numpy.ndarray[object[m, 1]], input: numpy.ndarray[object[m, 1]], next_input: numpy.ndarray[object[m, 1]], prog: pydrake.solvers.MathematicalProgram) -> pydrake.solvers.BindingTConstraintU: ...
def GetContinuousRevoluteJointIndices(plant: pydrake.multibody.plant.MultibodyPlant) -> list[int]: ...
def IrisInConfigurationSpaceFromCliqueCover(checker: CollisionChecker, options: IrisFromCliqueCoverOptions, generator: pydrake.common.RandomGenerator, sets: list[pydrake.geometry.optimization.HPolyhedron], max_clique_solver: MaxCliqueSolverBase = ...) -> list[pydrake.geometry.optimization.HPolyhedron]: ...
def IrisNp2(checker: SceneGraphCollisionChecker, starting_ellipsoid: pydrake.geometry.optimization.Hyperellipsoid, domain: pydrake.geometry.optimization.HPolyhedron, options: IrisNp2Options = ...) -> pydrake.geometry.optimization.HPolyhedron: ...
def IrisZo(checker: CollisionChecker, starting_ellipsoid: pydrake.geometry.optimization.Hyperellipsoid, domain: pydrake.geometry.optimization.HPolyhedron, options: IrisZoOptions = ...) -> pydrake.geometry.optimization.HPolyhedron: ...
def MakeBodyShapeDescription(plant: pydrake.multibody.plant.MultibodyPlant, plant_context: pydrake.systems.framework.Context, geometry_id: pydrake.geometry.GeometryId) -> BodyShapeDescription: ...
def VisibilityGraph(checker: CollisionChecker, points: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], parallelize: pydrake.common.Parallelism = ...) -> scipy.sparse.csc_matrix[bool]: ...
