import flags
import numpy
import pydrake.common
import pydrake.systems.framework
import pydrake.systems.sensors
from typing import ClassVar, overload

class BaseField:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kNone: ClassVar[BaseField] = ...
    kNormals: ClassVar[BaseField] = ...
    kRGBs: ClassVar[BaseField] = ...
    kXYZs: ClassVar[BaseField] = ...
    def __init__(self, value: int) -> None: ...
    def __and__(self, other: object) -> object: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __invert__(self) -> object: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    def __or__(self, other: object) -> object: ...
    def __rand__(self, other: object) -> object: ...
    def __ror__(self, other: object) -> object: ...
    def __rxor__(self, other: object) -> object: ...
    def __xor__(self, other: object) -> object: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class DepthImageToPointCloud(pydrake.systems.framework.LeafSystem):
    def __init__(self, camera_info: pydrake.systems.sensors.CameraInfo, pixel_type: pydrake.systems.sensors.PixelType = ..., scale: float = ..., fields: int = ...) -> None: ...
    def camera_pose_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def color_image_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def depth_image_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def point_cloud_output_port(self) -> pydrake.systems.framework.OutputPort: ...

class Fields:
    def __init__(self, base_fields: int) -> None: ...
    def base_fields(self) -> int: ...
    def has_base_fields(self) -> bool: ...
    def __and__(self, arg0: Fields) -> Fields: ...
    def __eq__(self, arg0: Fields) -> bool: ...
    def __ne__(self, arg0: Fields) -> bool: ...
    def __or__(self, arg0: Fields) -> Fields: ...

class PointCloud:
    C: ClassVar[type[numpy.uint8]] = ...
    D: ClassVar[type[numpy.float32]] = ...
    T: ClassVar[type[numpy.float32]] = ...
    kDefaultValue: ClassVar[float] = ...
    @overload
    def __init__(self, new_size: int = ..., fields: Fields = ...) -> None: ...
    @overload
    def __init__(self, other: PointCloud) -> None: ...
    def Crop(self, lower_xyz: numpy.ndarray[numpy.float32[3, 1]], upper_xyz: numpy.ndarray[numpy.float32[3, 1]]) -> PointCloud: ...
    def EstimateNormals(self, radius: float, num_closest: int, parallelize: pydrake.common.Parallelism = ...) -> bool: ...
    def FlipNormalsTowardPoint(self, p_CP: numpy.ndarray[numpy.float32[3, 1]]) -> None: ...
    @staticmethod
    def IsDefaultValue(value: float) -> bool: ...
    @staticmethod
    def IsInvalidValue(value: float) -> bool: ...
    def SetFields(self, new_fields: Fields, skip_initialize: bool = ...) -> None: ...
    def SetFrom(self, other: PointCloud) -> None: ...
    def VoxelizedDownSample(self, voxel_size: float, parallelize: pydrake.common.Parallelism = ...) -> PointCloud: ...
    def fields(self) -> Fields: ...
    def has_normals(self) -> bool: ...
    def has_rgbs(self) -> bool: ...
    def has_xyzs(self) -> bool: ...
    def mutable_normal(self, i: int) -> numpy.ndarray[numpy.float32[3, 1], flags.writeable]: ...
    def mutable_normals(self) -> numpy.ndarray[numpy.float32[3, n], flags.writeable, flags.f_contiguous]: ...
    def mutable_rgb(self, i: int) -> numpy.ndarray[numpy.uint8[3, 1], flags.writeable]: ...
    def mutable_rgbs(self) -> numpy.ndarray[numpy.uint8[3, n], flags.writeable, flags.f_contiguous]: ...
    def mutable_xyz(self, i: int) -> numpy.ndarray[numpy.float32[3, 1], flags.writeable]: ...
    def mutable_xyzs(self) -> numpy.ndarray[numpy.float32[3, n], flags.writeable, flags.f_contiguous]: ...
    def normal(self, i: int) -> numpy.ndarray[numpy.float32[3, 1]]: ...
    def normals(self) -> numpy.ndarray[numpy.float32[3, n], flags.f_contiguous]: ...
    def resize(self, new_size: int) -> None: ...
    def rgb(self, i: int) -> numpy.ndarray[numpy.uint8[3, 1]]: ...
    def rgbs(self) -> numpy.ndarray[numpy.uint8[3, n], flags.f_contiguous]: ...
    def size(self) -> int: ...
    def xyz(self, i: int) -> numpy.ndarray[numpy.float32[3, 1]]: ...
    def xyzs(self) -> numpy.ndarray[numpy.float32[3, n], flags.f_contiguous]: ...
    def __copy__(self) -> PointCloud: ...
    def __deepcopy__(self, arg0: dict) -> PointCloud: ...

class PointCloudToLcm(pydrake.systems.framework.LeafSystem):
    def __init__(self, frame_name: str = ...) -> None: ...

def Concatenate(clouds: list[PointCloud]) -> PointCloud: ...
