import flags
import numpy
import pydrake.autodiffutils
import pydrake.common.eigen_geometry
import pydrake.common.value
import pydrake.geometry
import pydrake.math
import pydrake.multibody.fem
import pydrake.multibody.math
import pydrake.symbolic
import pydrake.systems.framework
from pydrake.common.cpp_template import BallRpyJoint_ as BallRpyJoint_, Body_ as Body_, DoorHinge_ as DoorHinge_, FixedOffsetFrame_ as FixedOffsetFrame_, ForceDensityField_ as ForceDensityField_, ForceElement_ as ForceElement_, Frame_ as Frame_, GravityForceField_ as GravityForceField_, JointActuator_ as JointActuator_, Joint_ as Joint_, LinearBushingRollPitchYaw_ as LinearBushingRollPitchYaw_, LinearSpringDamper_ as LinearSpringDamper_, MultibodyForces_ as MultibodyForces_, PlanarJoint_ as PlanarJoint_, PrismaticJoint_ as PrismaticJoint_, PrismaticSpring_ as PrismaticSpring_, QuaternionFloatingJoint_ as QuaternionFloatingJoint_, RevoluteJoint_ as RevoluteJoint_, RevoluteSpring_ as RevoluteSpring_, RigidBodyFrame_ as RigidBodyFrame_, RigidBody_ as RigidBody_, RotationalInertia_ as RotationalInertia_, RpyFloatingJoint_ as RpyFloatingJoint_, ScrewJoint_ as ScrewJoint_, SpatialInertia_ as SpatialInertia_, UniformGravityFieldElement_ as UniformGravityFieldElement_, UnitInertia_ as UnitInertia_, UniversalJoint_ as UniversalJoint_, WeldJoint_ as WeldJoint_
from typing import Any, Callable, ClassVar, overload

__getattr__: Callable

class BallRpyJoint(Joint):
    kTypeName: ClassVar[str] = ...  # read-only
    def __init__(self, name: str, frame_on_parent: Frame, frame_on_child: Frame, damping: float = ...) -> None: ...
    def default_damping(self) -> float: ...
    def get_angles(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_default_angles(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def set_angles(self, context: pydrake.systems.framework.Context, angles: numpy.ndarray[numpy.float64[3, 1]]) -> BallRpyJoint: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context, w_FM: numpy.ndarray[numpy.float64[3, 1]]) -> BallRpyJoint: ...
    def set_default_angles(self, angles: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_random_angles_distribution(self, angles: numpy.ndarray[object[3, 1]]) -> None: ...

class BallRpyJoint_𝓣AutoDiffXd𝓤(Joint_TAutoDiffXdU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TAutoDiffXdU, frame_on_child: Frame_TAutoDiffXdU, damping: float = ...) -> None: ...
    def default_damping(self) -> float: ...
    def get_angles(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def get_default_angles(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def set_angles(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, angles: numpy.ndarray[object[3, 1]]) -> BallRpyJoint_TAutoDiffXdU: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, w_FM: numpy.ndarray[object[3, 1]]) -> BallRpyJoint_TAutoDiffXdU: ...
    def set_default_angles(self, angles: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_random_angles_distribution(self, angles: numpy.ndarray[object[3, 1]]) -> None: ...

class BallRpyJoint_𝓣Expression𝓤(Joint_TExpressionU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TExpressionU, frame_on_child: Frame_TExpressionU, damping: float = ...) -> None: ...
    def default_damping(self) -> float: ...
    def get_angles(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def get_default_angles(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def set_angles(self, context: pydrake.systems.framework.Context_TExpressionU, angles: numpy.ndarray[object[3, 1]]) -> BallRpyJoint_TExpressionU: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU, w_FM: numpy.ndarray[object[3, 1]]) -> BallRpyJoint_TExpressionU: ...
    def set_default_angles(self, angles: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_random_angles_distribution(self, angles: numpy.ndarray[object[3, 1]]) -> None: ...

class Body:
    def __init__(self, body_name: str, M_BBo_B: SpatialInertia = ...) -> None: ...
    def AddInForce(self, context: pydrake.systems.framework.Context, p_BP_E: numpy.ndarray[numpy.float64[3, 1]], F_Bp_E: pydrake.multibody.math.SpatialForce, frame_E: Frame, forces: MultibodyForces) -> None: ...
    def AddInForceInWorld(self, context: pydrake.systems.framework.Context, F_Bo_W: pydrake.multibody.math.SpatialForce, forces: MultibodyForces) -> None: ...
    def CalcCenterOfMassInBodyFrame(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcCenterOfMassTranslationalAccelerationInWorld(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcCenterOfMassTranslationalVelocityInWorld(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcSpatialInertiaInBodyFrame(self, context: pydrake.systems.framework.Context) -> SpatialInertia: ...
    def EvalPoseInWorld(self, context: pydrake.systems.framework.Context) -> pydrake.math.RigidTransform: ...
    def EvalSpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context) -> pydrake.multibody.math.SpatialAcceleration: ...
    def EvalSpatialVelocityInWorld(self, context: pydrake.systems.framework.Context) -> pydrake.multibody.math.SpatialVelocity: ...
    def GetForceInWorld(self, context: pydrake.systems.framework.Context, forces: MultibodyForces) -> pydrake.multibody.math.SpatialForce: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def Lock(self, context: pydrake.systems.framework.Context) -> None: ...
    def SetCenterOfMassInBodyFrame(self, context: pydrake.systems.framework.Context, com: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def SetMass(self, context: pydrake.systems.framework.Context, mass: float) -> None: ...
    def SetSpatialInertiaInBodyFrame(self, context: pydrake.systems.framework.Context, M_Bo_B: SpatialInertia) -> None: ...
    def Unlock(self, context: pydrake.systems.framework.Context) -> None: ...
    def body_frame(self) -> RigidBodyFrame: ...
    def default_com(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def default_mass(self) -> float: ...
    def default_rotational_inertia(self) -> RotationalInertia: ...
    def default_spatial_inertia(self) -> SpatialInertia: ...
    def default_unit_inertia(self) -> UnitInertia: ...
    def floating_position_suffix(self, arg0: int) -> str: ...
    def floating_positions_start(self) -> int: ...
    def floating_velocities_start_in_v(self) -> int: ...
    def floating_velocity_suffix(self, arg0: int) -> str: ...
    def get_mass(self, context: pydrake.systems.framework.Context) -> float: ...
    def has_quaternion_dofs(self) -> bool: ...
    def index(self) -> BodyIndex: ...
    def is_ephemeral(self) -> bool: ...
    def is_floating(self) -> bool: ...
    def is_floating_base_body(self) -> bool: ...
    @overload
    def is_locked(self, context: pydrake.systems.framework.Context) -> bool: ...
    @overload
    def is_locked(self) -> Any: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def scoped_name(self) -> ScopedName: ...

class BodyIndex:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def is_valid(self) -> bool: ...
    @overload
    def __eq__(self, arg0: BodyIndex) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __lt__(self, arg0: BodyIndex) -> bool: ...

class DeformableBody:
    def __init__(self, *args, **kwargs) -> None: ...
    def AddFixedConstraint(self, body_B: RigidBody, X_BA: pydrake.math.RigidTransform, shape_G: pydrake.geometry.Shape, X_BG: pydrake.math.RigidTransform) -> MultibodyConstraintId: ...
    def CalcCenterOfMassPositionInWorld(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcCenterOfMassTranslationalVelocityInWorld(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcEffectiveAngularVelocity(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def Disable(self, context: pydrake.systems.framework.Context) -> None: ...
    @overload
    def Enable(self, context: pydrake.systems.framework.Context) -> None: ...
    @overload
    def Enable(self) -> Any: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def GetPositions(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, n]]: ...
    def GetPositionsAndVelocities(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, n]]: ...
    def GetVelocities(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, n]]: ...
    def SetPositions(self, context: pydrake.systems.framework.Context, q: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous]) -> None: ...
    def SetPositionsAndVelocities(self, context: pydrake.systems.framework.Context, q: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous], v: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous]) -> None: ...
    def SetVelocities(self, context: pydrake.systems.framework.Context, v: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous]) -> None: ...
    def SetWallBoundaryCondition(self, p_WQ: numpy.ndarray[numpy.float64[3, 1]], n_W: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def body_id(self) -> DeformableBodyId: ...
    def config(self) -> pydrake.multibody.fem.DeformableBodyConfig: ...
    def discrete_state_index(self) -> pydrake.systems.framework.DiscreteStateIndex: ...
    def external_forces(self) -> list[pydrake.multibody.fem.ForceDensityFieldBase]: ...
    def geometry_id(self) -> pydrake.geometry.GeometryId: ...
    def get_default_pose(self) -> pydrake.math.RigidTransform: ...
    def has_fixed_constraint(self) -> bool: ...
    def index(self) -> DeformableBodyIndex: ...
    def is_enabled(self, context: pydrake.systems.framework.Context) -> bool: ...
    def is_enabled_parameter_index(self) -> pydrake.systems.framework.AbstractParameterIndex: ...
    def is_ephemeral(self) -> bool: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def num_dofs(self) -> int: ...
    def reference_positions(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def scoped_name(self) -> ScopedName: ...
    def set_default_pose(self, X_WD: pydrake.math.RigidTransform) -> None: ...

class DeformableBodyId:
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def get_new_id() -> DeformableBodyId: ...
    def get_value(self) -> int: ...
    def is_valid(self) -> bool: ...
    def __eq__(self, arg0: DeformableBodyId) -> bool: ...
    def __hash__(self) -> int: ...
    def __lt__(self, arg0: DeformableBodyId) -> bool: ...
    def __ne__(self, arg0: DeformableBodyId) -> bool: ...

class DeformableBodyIndex:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def is_valid(self) -> bool: ...
    @overload
    def __eq__(self, arg0: DeformableBodyIndex) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __lt__(self, arg0: DeformableBodyIndex) -> bool: ...

class DoorHinge(ForceElement):
    def __init__(self, joint: RevoluteJoint, config: DoorHingeConfig) -> None: ...
    def CalcHingeFrictionalTorque(self, angular_rate: float) -> float: ...
    def CalcHingeSpringTorque(self, angle: float) -> float: ...
    def CalcHingeTorque(self, angle: float, angular_rate: float) -> float: ...
    def config(self) -> DoorHingeConfig: ...
    def joint(self) -> RevoluteJoint: ...

class DoorHingeConfig:
    __fields__: ClassVar[tuple] = ...  # read-only
    catch_torque: float
    catch_width: float
    dynamic_friction_torque: float
    motion_threshold: float
    spring_constant: float
    spring_zero_angle_rad: float
    static_friction_torque: float
    viscous_friction: float
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> DoorHingeConfig: ...
    def __deepcopy__(self, arg0: dict) -> DoorHingeConfig: ...

class DoorHinge_𝓣AutoDiffXd𝓤(ForceElement_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, joint: RevoluteJoint_TAutoDiffXdU, config: DoorHingeConfig) -> None: ...
    def CalcHingeFrictionalTorque(self, angular_rate: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
    def CalcHingeSpringTorque(self, angle: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
    def CalcHingeTorque(self, angle: pydrake.autodiffutils.AutoDiffXd, angular_rate: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
    def config(self) -> DoorHingeConfig: ...
    def joint(self) -> RevoluteJoint_TAutoDiffXdU: ...

class DoorHinge_𝓣Expression𝓤(ForceElement_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, joint: RevoluteJoint_TExpressionU, config: DoorHingeConfig) -> None: ...
    def CalcHingeFrictionalTorque(self, angular_rate: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
    def CalcHingeSpringTorque(self, angle: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
    def CalcHingeTorque(self, angle: pydrake.symbolic.Expression, angular_rate: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
    def config(self) -> DoorHingeConfig: ...
    def joint(self) -> RevoluteJoint_TExpressionU: ...

class FixedOffsetFrame(Frame):
    @overload
    def __init__(self, name: str, P: Frame, X_PF: pydrake.math.RigidTransform, model_instance: ModelInstanceIndex | None = ...) -> None: ...
    @overload
    def __init__(self, name: str, bodyB, X_BF: pydrake.math.RigidTransform) -> None: ...
    def GetPoseInParentFrame(self, context: pydrake.systems.framework.Context) -> pydrake.math.RigidTransform: ...
    def SetPoseInParentFrame(self, context: pydrake.systems.framework.Context, X_PF: pydrake.math.RigidTransform) -> None: ...

class FixedOffsetFrame_𝓣AutoDiffXd𝓤(Frame_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, P: Frame_TAutoDiffXdU, X_PF: pydrake.math.RigidTransform, model_instance: ModelInstanceIndex | None = ...) -> None: ...
    def GetPoseInParentFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def SetPoseInParentFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, X_PF: pydrake.math.RigidTransform_TAutoDiffXdU) -> None: ...

class FixedOffsetFrame_𝓣Expression𝓤(Frame_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, name: str, P: Frame_TExpressionU, X_PF: pydrake.math.RigidTransform, model_instance: ModelInstanceIndex | None = ...) -> None: ...
    @overload
    def __init__(self, name: str, bodyB, X_BF: pydrake.math.RigidTransform) -> None: ...
    def GetPoseInParentFrame(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def SetPoseInParentFrame(self, context: pydrake.systems.framework.Context_TExpressionU, X_PF: pydrake.math.RigidTransform_TExpressionU) -> None: ...

class ForceDensityField(pydrake.multibody.fem.ForceDensityFieldBase):
    def __init__(self, density_type: pydrake.multibody.fem.ForceDensityType = ...) -> None: ...
    @staticmethod
    def DeclareAbstractInputPort(plant, name: str, model_value: pydrake.common.value.AbstractValue) -> pydrake.systems.framework.InputPort: ...
    @staticmethod
    def DeclareCacheEntry(plant, description: str, value_producer: pydrake.systems.framework.ValueProducer, prerequisites_of_calc: set[pydrake.systems.framework.DependencyTicket]) -> pydrake.systems.framework.CacheEntry: ...
    @staticmethod
    def DeclareVectorInputPort(plant, name: str, model_vector: pydrake.systems.framework.BasicVector) -> pydrake.systems.framework.InputPort: ...
    def has_parent_system(self) -> bool: ...
    def parent_system_or_throw(self) -> pydrake.systems.framework.LeafSystem: ...

class ForceDensityField_𝓣AutoDiffXd𝓤(pydrake.multibody.fem.ForceDensityFieldBase_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, density_type: pydrake.multibody.fem.ForceDensityType = ...) -> None: ...
    @staticmethod
    def DeclareAbstractInputPort(*args, **kwargs): ...
    @staticmethod
    def DeclareCacheEntry(*args, **kwargs): ...
    @staticmethod
    def DeclareVectorInputPort(*args, **kwargs): ...
    def has_parent_system(self) -> bool: ...
    def parent_system_or_throw(self) -> pydrake.systems.framework.LeafSystem_TAutoDiffXdU: ...

class ForceDensityField_𝓣Expression𝓤(pydrake.multibody.fem.ForceDensityFieldBase_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, density_type: pydrake.multibody.fem.ForceDensityType = ...) -> None: ...
    @staticmethod
    def DeclareAbstractInputPort(plant, name: str, model_value: pydrake.common.value.AbstractValue) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    @staticmethod
    def DeclareCacheEntry(plant, description: str, value_producer: pydrake.systems.framework.ValueProducer, prerequisites_of_calc: set[pydrake.systems.framework.DependencyTicket]) -> pydrake.systems.framework.CacheEntry: ...
    @staticmethod
    def DeclareVectorInputPort(plant, name: str, model_vector: pydrake.systems.framework.BasicVector_TExpressionU) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def has_parent_system(self) -> bool: ...
    def parent_system_or_throw(self) -> pydrake.systems.framework.LeafSystem_TExpressionU: ...

class ForceElement:
    def __init__(self, *args, **kwargs) -> None: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def index(self) -> ForceElementIndex: ...
    def is_ephemeral(self) -> bool: ...
    def model_instance(self) -> ModelInstanceIndex: ...

class ForceElementIndex:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def is_valid(self) -> bool: ...
    @overload
    def __eq__(self, arg0: ForceElementIndex) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __lt__(self, arg0: ForceElementIndex) -> bool: ...

class ForceElement_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def index(self) -> ForceElementIndex: ...
    def is_ephemeral(self) -> bool: ...
    def model_instance(self) -> ModelInstanceIndex: ...

class ForceElement_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def index(self) -> ForceElementIndex: ...
    def is_ephemeral(self) -> bool: ...
    def model_instance(self) -> ModelInstanceIndex: ...

class Frame:
    def __init__(self, *args, **kwargs) -> None: ...
    def CalcAngularVelocity(self, context: pydrake.systems.framework.Context, measured_in_frame: Frame, expressed_in_frame: Frame) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcOffsetPoseInBody(self, context: pydrake.systems.framework.Context, X_FQ: pydrake.math.RigidTransform) -> pydrake.math.RigidTransform: ...
    def CalcOffsetRotationMatrixInBody(self, context: pydrake.systems.framework.Context, R_FQ: pydrake.math.RotationMatrix) -> pydrake.math.RotationMatrix: ...
    def CalcPose(self, context: pydrake.systems.framework.Context, frame_M: Frame) -> pydrake.math.RigidTransform: ...
    def CalcPoseInBodyFrame(self, context: pydrake.systems.framework.Context) -> pydrake.math.RigidTransform: ...
    def CalcPoseInWorld(self, context: pydrake.systems.framework.Context) -> pydrake.math.RigidTransform: ...
    def CalcRelativeSpatialAcceleration(self, context: pydrake.systems.framework.Context, other_frame: Frame, measured_in_frame: Frame, expressed_in_frame: Frame) -> pydrake.multibody.math.SpatialAcceleration: ...
    def CalcRelativeSpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context, other_frame: Frame) -> pydrake.multibody.math.SpatialAcceleration: ...
    def CalcRelativeSpatialVelocity(self, context: pydrake.systems.framework.Context, other_frame: Frame, measured_in_frame: Frame, expressed_in_frame: Frame) -> pydrake.multibody.math.SpatialVelocity: ...
    def CalcRelativeSpatialVelocityInWorld(self, context: pydrake.systems.framework.Context, other_frame: Frame) -> pydrake.multibody.math.SpatialVelocity: ...
    def CalcRotationMatrix(self, context: pydrake.systems.framework.Context, frame_M: Frame) -> pydrake.math.RotationMatrix: ...
    def CalcRotationMatrixInBodyFrame(self, context: pydrake.systems.framework.Context) -> pydrake.math.RotationMatrix: ...
    def CalcRotationMatrixInWorld(self, context: pydrake.systems.framework.Context) -> pydrake.math.RotationMatrix: ...
    def CalcSpatialAcceleration(self, context: pydrake.systems.framework.Context, measured_in_frame: Frame, expressed_in_frame: Frame) -> pydrake.multibody.math.SpatialAcceleration: ...
    def CalcSpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context) -> pydrake.multibody.math.SpatialAcceleration: ...
    def CalcSpatialVelocity(self, context: pydrake.systems.framework.Context, frame_M: Frame, frame_E: Frame) -> pydrake.multibody.math.SpatialVelocity: ...
    def CalcSpatialVelocityInWorld(self, context: pydrake.systems.framework.Context) -> pydrake.multibody.math.SpatialVelocity: ...
    def EvalAngularVelocityInWorld(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def GetFixedOffsetPoseInBody(self, X_FQ: pydrake.math.RigidTransform) -> pydrake.math.RigidTransform: ...
    @overload
    def GetFixedPoseInBodyFrame(self) -> pydrake.math.RigidTransform: ...
    @overload
    def GetFixedPoseInBodyFrame(self) -> pydrake.math.RigidTransform: ...
    def GetFixedRotationMatrixInBody(self, R_FQ: pydrake.math.RotationMatrix) -> pydrake.math.RotationMatrix: ...
    def GetFixedRotationMatrixInBodyFrame(self) -> pydrake.math.RotationMatrix: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def body(self, *args, **kwargs): ...
    def index(self) -> FrameIndex: ...
    def is_body_frame(self) -> bool: ...
    def is_ephemeral(self) -> bool: ...
    def is_world_frame(self) -> bool: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def scoped_name(self) -> ScopedName: ...

class FrameIndex:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def is_valid(self) -> bool: ...
    @overload
    def __eq__(self, arg0: FrameIndex) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __lt__(self, arg0: FrameIndex) -> bool: ...

class Frame_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def CalcAngularVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, measured_in_frame: Frame_TAutoDiffXdU, expressed_in_frame: Frame_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcOffsetPoseInBody(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, X_FQ: pydrake.math.RigidTransform_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def CalcOffsetRotationMatrixInBody(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, R_FQ: pydrake.math.RotationMatrix_TAutoDiffXdU) -> pydrake.math.RotationMatrix_TAutoDiffXdU: ...
    def CalcPose(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_M: Frame_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def CalcPoseInBodyFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def CalcPoseInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def CalcRelativeSpatialAcceleration(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, other_frame: Frame_TAutoDiffXdU, measured_in_frame: Frame_TAutoDiffXdU, expressed_in_frame: Frame_TAutoDiffXdU) -> pydrake.multibody.math.SpatialAcceleration_TAutoDiffXdU: ...
    def CalcRelativeSpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, other_frame: Frame_TAutoDiffXdU) -> pydrake.multibody.math.SpatialAcceleration_TAutoDiffXdU: ...
    def CalcRelativeSpatialVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, other_frame: Frame_TAutoDiffXdU, measured_in_frame: Frame_TAutoDiffXdU, expressed_in_frame: Frame_TAutoDiffXdU) -> pydrake.multibody.math.SpatialVelocity_TAutoDiffXdU: ...
    def CalcRelativeSpatialVelocityInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, other_frame: Frame_TAutoDiffXdU) -> pydrake.multibody.math.SpatialVelocity_TAutoDiffXdU: ...
    def CalcRotationMatrix(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_M: Frame_TAutoDiffXdU) -> pydrake.math.RotationMatrix_TAutoDiffXdU: ...
    def CalcRotationMatrixInBodyFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.math.RotationMatrix_TAutoDiffXdU: ...
    def CalcRotationMatrixInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.math.RotationMatrix_TAutoDiffXdU: ...
    def CalcSpatialAcceleration(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, measured_in_frame: Frame_TAutoDiffXdU, expressed_in_frame: Frame_TAutoDiffXdU) -> pydrake.multibody.math.SpatialAcceleration_TAutoDiffXdU: ...
    def CalcSpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.multibody.math.SpatialAcceleration_TAutoDiffXdU: ...
    def CalcSpatialVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_M: Frame_TAutoDiffXdU, frame_E: Frame_TAutoDiffXdU) -> pydrake.multibody.math.SpatialVelocity_TAutoDiffXdU: ...
    def CalcSpatialVelocityInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.multibody.math.SpatialVelocity_TAutoDiffXdU: ...
    def EvalAngularVelocityInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def GetFixedOffsetPoseInBody(self, X_FQ: pydrake.math.RigidTransform_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    @overload
    def GetFixedPoseInBodyFrame(self) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    @overload
    def GetFixedPoseInBodyFrame(self) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def GetFixedRotationMatrixInBody(self, R_FQ: pydrake.math.RotationMatrix_TAutoDiffXdU) -> pydrake.math.RotationMatrix_TAutoDiffXdU: ...
    def GetFixedRotationMatrixInBodyFrame(self) -> pydrake.math.RotationMatrix_TAutoDiffXdU: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def body(self, *args, **kwargs): ...
    def index(self) -> FrameIndex: ...
    def is_body_frame(self) -> bool: ...
    def is_ephemeral(self) -> bool: ...
    def is_world_frame(self) -> bool: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def scoped_name(self) -> ScopedName: ...

class Frame_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def CalcAngularVelocity(self, context: pydrake.systems.framework.Context_TExpressionU, measured_in_frame: Frame_TExpressionU, expressed_in_frame: Frame_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcOffsetPoseInBody(self, context: pydrake.systems.framework.Context_TExpressionU, X_FQ: pydrake.math.RigidTransform_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def CalcOffsetRotationMatrixInBody(self, context: pydrake.systems.framework.Context_TExpressionU, R_FQ: pydrake.math.RotationMatrix_TExpressionU) -> pydrake.math.RotationMatrix_TExpressionU: ...
    def CalcPose(self, context: pydrake.systems.framework.Context_TExpressionU, frame_M: Frame_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def CalcPoseInBodyFrame(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def CalcPoseInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def CalcRelativeSpatialAcceleration(self, context: pydrake.systems.framework.Context_TExpressionU, other_frame: Frame_TExpressionU, measured_in_frame: Frame_TExpressionU, expressed_in_frame: Frame_TExpressionU) -> pydrake.multibody.math.SpatialAcceleration_TExpressionU: ...
    def CalcRelativeSpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context_TExpressionU, other_frame: Frame_TExpressionU) -> pydrake.multibody.math.SpatialAcceleration_TExpressionU: ...
    def CalcRelativeSpatialVelocity(self, context: pydrake.systems.framework.Context_TExpressionU, other_frame: Frame_TExpressionU, measured_in_frame: Frame_TExpressionU, expressed_in_frame: Frame_TExpressionU) -> pydrake.multibody.math.SpatialVelocity_TExpressionU: ...
    def CalcRelativeSpatialVelocityInWorld(self, context: pydrake.systems.framework.Context_TExpressionU, other_frame: Frame_TExpressionU) -> pydrake.multibody.math.SpatialVelocity_TExpressionU: ...
    def CalcRotationMatrix(self, context: pydrake.systems.framework.Context_TExpressionU, frame_M: Frame_TExpressionU) -> pydrake.math.RotationMatrix_TExpressionU: ...
    def CalcRotationMatrixInBodyFrame(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.math.RotationMatrix_TExpressionU: ...
    def CalcRotationMatrixInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.math.RotationMatrix_TExpressionU: ...
    def CalcSpatialAcceleration(self, context: pydrake.systems.framework.Context_TExpressionU, measured_in_frame: Frame_TExpressionU, expressed_in_frame: Frame_TExpressionU) -> pydrake.multibody.math.SpatialAcceleration_TExpressionU: ...
    def CalcSpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.multibody.math.SpatialAcceleration_TExpressionU: ...
    def CalcSpatialVelocity(self, context: pydrake.systems.framework.Context_TExpressionU, frame_M: Frame_TExpressionU, frame_E: Frame_TExpressionU) -> pydrake.multibody.math.SpatialVelocity_TExpressionU: ...
    def CalcSpatialVelocityInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.multibody.math.SpatialVelocity_TExpressionU: ...
    def EvalAngularVelocityInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def GetFixedOffsetPoseInBody(self, X_FQ: pydrake.math.RigidTransform_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    @overload
    def GetFixedPoseInBodyFrame(self) -> pydrake.math.RigidTransform_TExpressionU: ...
    @overload
    def GetFixedPoseInBodyFrame(self) -> pydrake.math.RigidTransform_TExpressionU: ...
    def GetFixedRotationMatrixInBody(self, R_FQ: pydrake.math.RotationMatrix_TExpressionU) -> pydrake.math.RotationMatrix_TExpressionU: ...
    def GetFixedRotationMatrixInBodyFrame(self) -> pydrake.math.RotationMatrix_TExpressionU: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def body(self, *args, **kwargs): ...
    def index(self) -> FrameIndex: ...
    def is_body_frame(self) -> bool: ...
    def is_ephemeral(self) -> bool: ...
    def is_world_frame(self) -> bool: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def scoped_name(self) -> ScopedName: ...

class GravityForceField(ForceDensityField):
    def __init__(self, gravity_vector: numpy.ndarray[numpy.float64[3, 1]], mass_density: float) -> None: ...

class GravityForceField_𝓣AutoDiffXd𝓤(ForceDensityField_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, gravity_vector: numpy.ndarray[object[3, 1]], mass_density: pydrake.autodiffutils.AutoDiffXd) -> None: ...

class GravityForceField_𝓣Expression𝓤(ForceDensityField_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, gravity_vector: numpy.ndarray[object[3, 1]], mass_density: pydrake.symbolic.Expression) -> None: ...

class JacobianWrtVariable:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kQDot: ClassVar[JacobianWrtVariable] = ...
    kV: ClassVar[JacobianWrtVariable] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Joint:
    def __init__(self, *args, **kwargs) -> None: ...
    def AddInDamping(self, context: pydrake.systems.framework.Context, forces: MultibodyForces) -> None: ...
    def AddInOneForce(self, context: pydrake.systems.framework.Context, joint_dof: int, joint_tau: float, forces: MultibodyForces) -> None: ...
    def GetDampingVector(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetDefaultPose(self) -> pydrake.math.RigidTransform: ...
    def GetDefaultPosePair(self) -> tuple[pydrake.common.eigen_geometry.Quaternion, numpy.ndarray[numpy.float64[3, 1]]]: ...
    def GetOnePosition(self, context: pydrake.systems.framework.Context) -> float: ...
    def GetOneVelocity(self, context: pydrake.systems.framework.Context) -> float: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def Lock(self, context: pydrake.systems.framework.Context) -> None: ...
    def SetDampingVector(self, context: pydrake.systems.framework.Context, damping: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def SetDefaultPose(self, X_FM: pydrake.math.RigidTransform) -> None: ...
    def SetDefaultPosePair(self, q_FM: pydrake.common.eigen_geometry.Quaternion, p_FM: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def Unlock(self, context: pydrake.systems.framework.Context) -> None: ...
    def acceleration_lower_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def acceleration_upper_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def can_rotate(self) -> bool: ...
    def can_translate(self) -> bool: ...
    def child_body(self) -> RigidBody: ...
    def default_damping_vector(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def default_positions(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def frame_on_child(self) -> Frame: ...
    def frame_on_parent(self) -> Frame: ...
    @overload
    def index(self) -> JointIndex: ...
    @overload
    def index(self) -> JointIndex: ...
    def is_ephemeral(self) -> bool: ...
    def is_locked(self, context: pydrake.systems.framework.Context) -> bool: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def num_positions(self) -> int: ...
    def num_velocities(self) -> int: ...
    def parent_body(self) -> RigidBody: ...
    def position_lower_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def position_start(self) -> int: ...
    def position_suffix(self, arg0: int) -> str: ...
    def position_upper_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def set_acceleration_limits(self, lower_limits: numpy.ndarray[numpy.float64[m, 1]], upper_limits: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_default_damping_vector(self, damping: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_default_positions(self, default_positions: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_position_limits(self, lower_limits: numpy.ndarray[numpy.float64[m, 1]], upper_limits: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_velocity_limits(self, lower_limits: numpy.ndarray[numpy.float64[m, 1]], upper_limits: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def type_name(self) -> str: ...
    def velocity_lower_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def velocity_start(self) -> int: ...
    def velocity_suffix(self, arg0: int) -> str: ...
    def velocity_upper_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class JointActuator:
    def __init__(self, *args, **kwargs) -> None: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def SetGearRatio(self, context: pydrake.systems.framework.Context, gear_ratio: float) -> None: ...
    def SetRotorInertia(self, context: pydrake.systems.framework.Context, rotor_inertia: float) -> None: ...
    def calc_reflected_inertia(self, context: pydrake.systems.framework.Context) -> float: ...
    def default_gear_ratio(self) -> float: ...
    def default_reflected_inertia(self) -> float: ...
    def default_rotor_inertia(self) -> float: ...
    def effort_limit(self) -> float: ...
    def gear_ratio(self, context: pydrake.systems.framework.Context) -> float: ...
    def get_actuation_vector(self, u: numpy.ndarray[numpy.float64[m, 1]]) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def get_controller_gains(self) -> PdControllerGains: ...
    def has_controller(self) -> bool: ...
    def index(self) -> JointActuatorIndex: ...
    def input_start(self) -> int: ...
    def is_ephemeral(self) -> bool: ...
    def joint(self) -> Joint: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def num_inputs(self) -> int: ...
    def rotor_inertia(self, context: pydrake.systems.framework.Context) -> float: ...
    def set_actuation_vector(self, u_actuator: numpy.ndarray[numpy.float64[m, 1]], u: numpy.ndarray[numpy.float64[m, 1], flags.writeable] | None) -> None: ...
    def set_controller_gains(self, gains: PdControllerGains) -> None: ...
    def set_default_gear_ratio(self, gear_ratio: float) -> None: ...
    def set_default_rotor_inertia(self, rotor_inertia: float) -> None: ...

class JointActuatorIndex:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def is_valid(self) -> bool: ...
    @overload
    def __eq__(self, arg0: JointActuatorIndex) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __lt__(self, arg0: JointActuatorIndex) -> bool: ...

class JointActuator_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def SetGearRatio(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, gear_ratio: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def SetRotorInertia(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, rotor_inertia: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def calc_reflected_inertia(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def default_gear_ratio(self) -> float: ...
    def default_reflected_inertia(self) -> float: ...
    def default_rotor_inertia(self) -> float: ...
    def effort_limit(self) -> float: ...
    def gear_ratio(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_actuation_vector(self, u: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    def get_controller_gains(self) -> PdControllerGains: ...
    def has_controller(self) -> bool: ...
    def index(self) -> JointActuatorIndex: ...
    def input_start(self) -> int: ...
    def is_ephemeral(self) -> bool: ...
    def joint(self) -> Joint_TAutoDiffXdU: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def num_inputs(self) -> int: ...
    def rotor_inertia(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def set_actuation_vector(self, u_actuator: numpy.ndarray[object[m, 1]], u: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    def set_controller_gains(self, gains: PdControllerGains) -> None: ...
    def set_default_gear_ratio(self, gear_ratio: float) -> None: ...
    def set_default_rotor_inertia(self, rotor_inertia: float) -> None: ...

class JointActuator_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def SetGearRatio(self, context: pydrake.systems.framework.Context_TExpressionU, gear_ratio: pydrake.symbolic.Expression) -> None: ...
    def SetRotorInertia(self, context: pydrake.systems.framework.Context_TExpressionU, rotor_inertia: pydrake.symbolic.Expression) -> None: ...
    def calc_reflected_inertia(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def default_gear_ratio(self) -> float: ...
    def default_reflected_inertia(self) -> float: ...
    def default_rotor_inertia(self) -> float: ...
    def effort_limit(self) -> float: ...
    def gear_ratio(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_actuation_vector(self, u: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    def get_controller_gains(self) -> PdControllerGains: ...
    def has_controller(self) -> bool: ...
    def index(self) -> JointActuatorIndex: ...
    def input_start(self) -> int: ...
    def is_ephemeral(self) -> bool: ...
    def joint(self) -> Joint_TExpressionU: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def num_inputs(self) -> int: ...
    def rotor_inertia(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def set_actuation_vector(self, u_actuator: numpy.ndarray[object[m, 1]], u: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    def set_controller_gains(self, gains: PdControllerGains) -> None: ...
    def set_default_gear_ratio(self, gear_ratio: float) -> None: ...
    def set_default_rotor_inertia(self, rotor_inertia: float) -> None: ...

class JointIndex:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def is_valid(self) -> bool: ...
    @overload
    def __eq__(self, arg0: JointIndex) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __lt__(self, arg0: JointIndex) -> bool: ...

class Joint_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def AddInDamping(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, forces: MultibodyForces_TAutoDiffXdU) -> None: ...
    def AddInOneForce(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, joint_dof: int, joint_tau: pydrake.autodiffutils.AutoDiffXd, forces: MultibodyForces_TAutoDiffXdU) -> None: ...
    def GetDampingVector(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    def GetDefaultPose(self) -> pydrake.math.RigidTransform: ...
    def GetDefaultPosePair(self) -> tuple[pydrake.common.eigen_geometry.Quaternion, numpy.ndarray[numpy.float64[3, 1]]]: ...
    def GetOnePosition(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def GetOneVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def Lock(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...
    def SetDampingVector(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, damping: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetDefaultPose(self, X_FM: pydrake.math.RigidTransform) -> None: ...
    def SetDefaultPosePair(self, q_FM: pydrake.common.eigen_geometry.Quaternion, p_FM: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def Unlock(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...
    def acceleration_lower_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def acceleration_upper_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def can_rotate(self) -> bool: ...
    def can_translate(self) -> bool: ...
    def child_body(self) -> RigidBody_TAutoDiffXdU: ...
    def default_damping_vector(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def default_positions(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def frame_on_child(self) -> Frame_TAutoDiffXdU: ...
    def frame_on_parent(self) -> Frame_TAutoDiffXdU: ...
    @overload
    def index(self) -> JointIndex: ...
    @overload
    def index(self) -> JointIndex: ...
    def is_ephemeral(self) -> bool: ...
    def is_locked(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> bool: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def num_positions(self) -> int: ...
    def num_velocities(self) -> int: ...
    def parent_body(self) -> RigidBody_TAutoDiffXdU: ...
    def position_lower_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def position_start(self) -> int: ...
    def position_suffix(self, arg0: int) -> str: ...
    def position_upper_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def set_acceleration_limits(self, lower_limits: numpy.ndarray[numpy.float64[m, 1]], upper_limits: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_default_damping_vector(self, damping: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_default_positions(self, default_positions: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_position_limits(self, lower_limits: numpy.ndarray[numpy.float64[m, 1]], upper_limits: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_velocity_limits(self, lower_limits: numpy.ndarray[numpy.float64[m, 1]], upper_limits: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def type_name(self) -> str: ...
    def velocity_lower_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def velocity_start(self) -> int: ...
    def velocity_suffix(self, arg0: int) -> str: ...
    def velocity_upper_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class Joint_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def AddInDamping(self, context: pydrake.systems.framework.Context_TExpressionU, forces: MultibodyForces_TExpressionU) -> None: ...
    def AddInOneForce(self, context: pydrake.systems.framework.Context_TExpressionU, joint_dof: int, joint_tau: pydrake.symbolic.Expression, forces: MultibodyForces_TExpressionU) -> None: ...
    def GetDampingVector(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    def GetDefaultPose(self) -> pydrake.math.RigidTransform: ...
    def GetDefaultPosePair(self) -> tuple[pydrake.common.eigen_geometry.Quaternion, numpy.ndarray[numpy.float64[3, 1]]]: ...
    def GetOnePosition(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def GetOneVelocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def Lock(self, context: pydrake.systems.framework.Context_TExpressionU) -> None: ...
    def SetDampingVector(self, context: pydrake.systems.framework.Context_TExpressionU, damping: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetDefaultPose(self, X_FM: pydrake.math.RigidTransform) -> None: ...
    def SetDefaultPosePair(self, q_FM: pydrake.common.eigen_geometry.Quaternion, p_FM: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def Unlock(self, context: pydrake.systems.framework.Context_TExpressionU) -> None: ...
    def acceleration_lower_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def acceleration_upper_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def can_rotate(self) -> bool: ...
    def can_translate(self) -> bool: ...
    def child_body(self) -> RigidBody_TExpressionU: ...
    def default_damping_vector(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def default_positions(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def frame_on_child(self) -> Frame_TExpressionU: ...
    def frame_on_parent(self) -> Frame_TExpressionU: ...
    @overload
    def index(self) -> JointIndex: ...
    @overload
    def index(self) -> JointIndex: ...
    def is_ephemeral(self) -> bool: ...
    def is_locked(self, context: pydrake.systems.framework.Context_TExpressionU) -> bool: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def num_positions(self) -> int: ...
    def num_velocities(self) -> int: ...
    def parent_body(self) -> RigidBody_TExpressionU: ...
    def position_lower_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def position_start(self) -> int: ...
    def position_suffix(self, arg0: int) -> str: ...
    def position_upper_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def set_acceleration_limits(self, lower_limits: numpy.ndarray[numpy.float64[m, 1]], upper_limits: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_default_damping_vector(self, damping: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_default_positions(self, default_positions: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_position_limits(self, lower_limits: numpy.ndarray[numpy.float64[m, 1]], upper_limits: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_velocity_limits(self, lower_limits: numpy.ndarray[numpy.float64[m, 1]], upper_limits: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def type_name(self) -> str: ...
    def velocity_lower_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def velocity_start(self) -> int: ...
    def velocity_suffix(self, arg0: int) -> str: ...
    def velocity_upper_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class LinearBushingRollPitchYaw(ForceElement):
    def __init__(self, frameA: Frame, frameC: Frame, torque_stiffness_constants: numpy.ndarray[numpy.float64[3, 1]], torque_damping_constants: numpy.ndarray[numpy.float64[3, 1]], force_stiffness_constants: numpy.ndarray[numpy.float64[3, 1]], force_damping_constants: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def CalcBushingSpatialForceOnFrameA(self, context: pydrake.systems.framework.Context) -> pydrake.multibody.math.SpatialForce: ...
    def CalcBushingSpatialForceOnFrameC(self, context: pydrake.systems.framework.Context) -> pydrake.multibody.math.SpatialForce: ...
    def GetForceDampingConstants(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def GetForceStiffnessConstants(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def GetTorqueDampingConstants(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def GetTorqueStiffnessConstants(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def SetForceDampingConstants(self, context: pydrake.systems.framework.Context, force_damping: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def SetForceStiffnessConstants(self, context: pydrake.systems.framework.Context, force_stiffness: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def SetTorqueDampingConstants(self, context: pydrake.systems.framework.Context, torque_damping: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def SetTorqueStiffnessConstants(self, context: pydrake.systems.framework.Context, torque_stiffness: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def force_damping_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def force_stiffness_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def frameA(self) -> Frame: ...
    def frameC(self) -> Frame: ...
    def link0(self) -> RigidBody: ...
    def link1(self) -> RigidBody: ...
    def torque_damping_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def torque_stiffness_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...

class LinearBushingRollPitchYaw_𝓣AutoDiffXd𝓤(ForceElement_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, frameA: Frame_TAutoDiffXdU, frameC: Frame_TAutoDiffXdU, torque_stiffness_constants: numpy.ndarray[numpy.float64[3, 1]], torque_damping_constants: numpy.ndarray[numpy.float64[3, 1]], force_stiffness_constants: numpy.ndarray[numpy.float64[3, 1]], force_damping_constants: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def CalcBushingSpatialForceOnFrameA(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.multibody.math.SpatialForce_TAutoDiffXdU: ...
    def CalcBushingSpatialForceOnFrameC(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.multibody.math.SpatialForce_TAutoDiffXdU: ...
    def GetForceDampingConstants(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def GetForceStiffnessConstants(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def GetTorqueDampingConstants(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def GetTorqueStiffnessConstants(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def SetForceDampingConstants(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, force_damping: numpy.ndarray[object[3, 1]]) -> None: ...
    def SetForceStiffnessConstants(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, force_stiffness: numpy.ndarray[object[3, 1]]) -> None: ...
    def SetTorqueDampingConstants(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, torque_damping: numpy.ndarray[object[3, 1]]) -> None: ...
    def SetTorqueStiffnessConstants(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, torque_stiffness: numpy.ndarray[object[3, 1]]) -> None: ...
    def force_damping_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def force_stiffness_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def frameA(self) -> Frame_TAutoDiffXdU: ...
    def frameC(self) -> Frame_TAutoDiffXdU: ...
    def link0(self) -> RigidBody_TAutoDiffXdU: ...
    def link1(self) -> RigidBody_TAutoDiffXdU: ...
    def torque_damping_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def torque_stiffness_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...

class LinearBushingRollPitchYaw_𝓣Expression𝓤(ForceElement_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, frameA: Frame_TExpressionU, frameC: Frame_TExpressionU, torque_stiffness_constants: numpy.ndarray[numpy.float64[3, 1]], torque_damping_constants: numpy.ndarray[numpy.float64[3, 1]], force_stiffness_constants: numpy.ndarray[numpy.float64[3, 1]], force_damping_constants: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def CalcBushingSpatialForceOnFrameA(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.multibody.math.SpatialForce_TExpressionU: ...
    def CalcBushingSpatialForceOnFrameC(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.multibody.math.SpatialForce_TExpressionU: ...
    def GetForceDampingConstants(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def GetForceStiffnessConstants(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def GetTorqueDampingConstants(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def GetTorqueStiffnessConstants(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def SetForceDampingConstants(self, context: pydrake.systems.framework.Context_TExpressionU, force_damping: numpy.ndarray[object[3, 1]]) -> None: ...
    def SetForceStiffnessConstants(self, context: pydrake.systems.framework.Context_TExpressionU, force_stiffness: numpy.ndarray[object[3, 1]]) -> None: ...
    def SetTorqueDampingConstants(self, context: pydrake.systems.framework.Context_TExpressionU, torque_damping: numpy.ndarray[object[3, 1]]) -> None: ...
    def SetTorqueStiffnessConstants(self, context: pydrake.systems.framework.Context_TExpressionU, torque_stiffness: numpy.ndarray[object[3, 1]]) -> None: ...
    def force_damping_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def force_stiffness_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def frameA(self) -> Frame_TExpressionU: ...
    def frameC(self) -> Frame_TExpressionU: ...
    def link0(self) -> RigidBody_TExpressionU: ...
    def link1(self) -> RigidBody_TExpressionU: ...
    def torque_damping_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def torque_stiffness_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...

class LinearSpringDamper(ForceElement):
    def __init__(self, bodyA: RigidBody, p_AP: numpy.ndarray[numpy.float64[3, 1]], bodyB: RigidBody, p_BQ: numpy.ndarray[numpy.float64[3, 1]], free_length: float, stiffness: float, damping: float) -> None: ...
    def bodyA(self) -> RigidBody: ...
    def bodyB(self) -> RigidBody: ...
    def damping(self) -> float: ...
    def free_length(self) -> float: ...
    def p_AP(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def p_BQ(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def stiffness(self) -> float: ...

class LinearSpringDamper_𝓣AutoDiffXd𝓤(ForceElement_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, bodyA: RigidBody_TAutoDiffXdU, p_AP: numpy.ndarray[numpy.float64[3, 1]], bodyB: RigidBody_TAutoDiffXdU, p_BQ: numpy.ndarray[numpy.float64[3, 1]], free_length: float, stiffness: float, damping: float) -> None: ...
    def bodyA(self) -> RigidBody_TAutoDiffXdU: ...
    def bodyB(self) -> RigidBody_TAutoDiffXdU: ...
    def damping(self) -> float: ...
    def free_length(self) -> float: ...
    def p_AP(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def p_BQ(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def stiffness(self) -> float: ...

class LinearSpringDamper_𝓣Expression𝓤(ForceElement_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, bodyA: RigidBody_TExpressionU, p_AP: numpy.ndarray[numpy.float64[3, 1]], bodyB: RigidBody_TExpressionU, p_BQ: numpy.ndarray[numpy.float64[3, 1]], free_length: float, stiffness: float, damping: float) -> None: ...
    def bodyA(self) -> RigidBody_TExpressionU: ...
    def bodyB(self) -> RigidBody_TExpressionU: ...
    def damping(self) -> float: ...
    def free_length(self) -> float: ...
    def p_AP(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def p_BQ(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def stiffness(self) -> float: ...

class ModelInstanceIndex:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg0: int) -> None: ...
    def is_valid(self) -> bool: ...
    @overload
    def __eq__(self, arg0: ModelInstanceIndex) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __lt__(self, arg0: ModelInstanceIndex) -> bool: ...

class MultibodyConstraintId:
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def get_new_id() -> MultibodyConstraintId: ...
    def get_value(self) -> int: ...
    def is_valid(self) -> bool: ...
    def __eq__(self, arg0: MultibodyConstraintId) -> bool: ...
    def __hash__(self) -> int: ...
    def __lt__(self, arg0: MultibodyConstraintId) -> bool: ...
    def __ne__(self, arg0: MultibodyConstraintId) -> bool: ...

class MultibodyForces:
    @overload
    def __init__(self, plant) -> None: ...
    @overload
    def __init__(self, nb: int, nv: int) -> None: ...
    def AddInForces(self, addend: MultibodyForces) -> None: ...
    def SetZero(self) -> MultibodyForces: ...
    def generalized_forces(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def mutable_generalized_forces(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def num_bodies(self) -> int: ...
    def num_velocities(self) -> int: ...
    def __copy__(self) -> MultibodyForces: ...
    def __deepcopy__(self, arg0: dict) -> MultibodyForces: ...

class MultibodyForces_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, nb: int, nv: int) -> None: ...
    def AddInForces(self, addend: MultibodyForces_TAutoDiffXdU) -> None: ...
    def SetZero(self) -> MultibodyForces_TAutoDiffXdU: ...
    def generalized_forces(self) -> numpy.ndarray[object[m, 1]]: ...
    def mutable_generalized_forces(self) -> numpy.ndarray[object[m, 1]]: ...
    def num_bodies(self) -> int: ...
    def num_velocities(self) -> int: ...
    def __copy__(self) -> MultibodyForces_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> MultibodyForces_TAutoDiffXdU: ...

class MultibodyForces_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, plant) -> None: ...
    @overload
    def __init__(self, nb: int, nv: int) -> None: ...
    def AddInForces(self, addend: MultibodyForces_TExpressionU) -> None: ...
    def SetZero(self) -> MultibodyForces_TExpressionU: ...
    def generalized_forces(self) -> numpy.ndarray[object[m, 1]]: ...
    def mutable_generalized_forces(self) -> numpy.ndarray[object[m, 1]]: ...
    def num_bodies(self) -> int: ...
    def num_velocities(self) -> int: ...
    def __copy__(self) -> MultibodyForces_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> MultibodyForces_TExpressionU: ...

class PdControllerGains:
    d: float
    p: float
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> PdControllerGains: ...
    def __deepcopy__(self, arg0: dict) -> PdControllerGains: ...

class PlanarJoint(Joint):
    kTypeName: ClassVar[str] = ...  # read-only
    def __init__(self, name: str, frame_on_parent: Frame, frame_on_child: Frame, damping: numpy.ndarray[numpy.float64[3, 1]] = ...) -> None: ...
    def default_damping(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context) -> float: ...
    def get_default_rotation(self) -> float: ...
    def get_default_translation(self) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    def get_rotation(self, context: pydrake.systems.framework.Context) -> float: ...
    def get_translation(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context, theta_dot: float) -> PlanarJoint: ...
    def set_default_pose(self, p_FoMo_F: numpy.ndarray[numpy.float64[2, 1]], theta: float) -> None: ...
    def set_default_rotation(self, theta: float) -> None: ...
    def set_default_translation(self, p_FoMo_F: numpy.ndarray[numpy.float64[2, 1]]) -> None: ...
    def set_pose(self, context: pydrake.systems.framework.Context, p_FoMo_F: numpy.ndarray[numpy.float64[2, 1]], theta: float) -> PlanarJoint: ...
    def set_random_pose_distribution(self, p_FoMo_F: numpy.ndarray[object[2, 1]], theta: pydrake.symbolic.Expression) -> None: ...
    def set_rotation(self, context: pydrake.systems.framework.Context, theta: float) -> PlanarJoint: ...
    def set_translation(self, context: pydrake.systems.framework.Context, p_FoMo_F: numpy.ndarray[numpy.float64[2, 1]]) -> PlanarJoint: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context, v_FoMo_F: numpy.ndarray[numpy.float64[2, 1]]) -> PlanarJoint: ...

class PlanarJoint_𝓣AutoDiffXd𝓤(Joint_TAutoDiffXdU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TAutoDiffXdU, frame_on_child: Frame_TAutoDiffXdU, damping: numpy.ndarray[numpy.float64[3, 1]] = ...) -> None: ...
    def default_damping(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_default_rotation(self) -> float: ...
    def get_default_translation(self) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    def get_rotation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[2, 1]]: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[2, 1]]: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, theta_dot: pydrake.autodiffutils.AutoDiffXd) -> PlanarJoint_TAutoDiffXdU: ...
    def set_default_pose(self, p_FoMo_F: numpy.ndarray[numpy.float64[2, 1]], theta: float) -> None: ...
    def set_default_rotation(self, theta: float) -> None: ...
    def set_default_translation(self, p_FoMo_F: numpy.ndarray[numpy.float64[2, 1]]) -> None: ...
    def set_pose(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, p_FoMo_F: numpy.ndarray[object[2, 1]], theta: pydrake.autodiffutils.AutoDiffXd) -> PlanarJoint_TAutoDiffXdU: ...
    def set_random_pose_distribution(self, p_FoMo_F: numpy.ndarray[object[2, 1]], theta: pydrake.symbolic.Expression) -> None: ...
    def set_rotation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, theta: pydrake.autodiffutils.AutoDiffXd) -> PlanarJoint_TAutoDiffXdU: ...
    def set_translation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, p_FoMo_F: numpy.ndarray[object[2, 1]]) -> PlanarJoint_TAutoDiffXdU: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, v_FoMo_F: numpy.ndarray[object[2, 1]]) -> PlanarJoint_TAutoDiffXdU: ...

class PlanarJoint_𝓣Expression𝓤(Joint_TExpressionU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TExpressionU, frame_on_child: Frame_TExpressionU, damping: numpy.ndarray[numpy.float64[3, 1]] = ...) -> None: ...
    def default_damping(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_default_rotation(self) -> float: ...
    def get_default_translation(self) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    def get_rotation(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[2, 1]]: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[2, 1]]: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU, theta_dot: pydrake.symbolic.Expression) -> PlanarJoint_TExpressionU: ...
    def set_default_pose(self, p_FoMo_F: numpy.ndarray[numpy.float64[2, 1]], theta: float) -> None: ...
    def set_default_rotation(self, theta: float) -> None: ...
    def set_default_translation(self, p_FoMo_F: numpy.ndarray[numpy.float64[2, 1]]) -> None: ...
    def set_pose(self, context: pydrake.systems.framework.Context_TExpressionU, p_FoMo_F: numpy.ndarray[object[2, 1]], theta: pydrake.symbolic.Expression) -> PlanarJoint_TExpressionU: ...
    def set_random_pose_distribution(self, p_FoMo_F: numpy.ndarray[object[2, 1]], theta: pydrake.symbolic.Expression) -> None: ...
    def set_rotation(self, context: pydrake.systems.framework.Context_TExpressionU, theta: pydrake.symbolic.Expression) -> PlanarJoint_TExpressionU: ...
    def set_translation(self, context: pydrake.systems.framework.Context_TExpressionU, p_FoMo_F: numpy.ndarray[object[2, 1]]) -> PlanarJoint_TExpressionU: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context_TExpressionU, v_FoMo_F: numpy.ndarray[object[2, 1]]) -> PlanarJoint_TExpressionU: ...

class PrismaticJoint(Joint):
    kTypeName: ClassVar[str] = ...  # read-only
    def __init__(self, name: str, frame_on_parent: Frame, frame_on_child: Frame, axis: numpy.ndarray[numpy.float64[3, 1]], pos_lower_limit: float = ..., pos_upper_limit: float = ..., damping: float = ...) -> None: ...
    def GetDamping(self, context: pydrake.systems.framework.Context) -> float: ...
    def SetDamping(self, context: pydrake.systems.framework.Context, damping: float) -> None: ...
    def acceleration_lower_limit(self) -> float: ...
    def acceleration_upper_limit(self) -> float: ...
    def default_damping(self) -> float: ...
    def get_default_translation(self) -> float: ...
    def get_translation(self, context: pydrake.systems.framework.Context) -> float: ...
    def get_translation_rate(self, context: pydrake.systems.framework.Context) -> float: ...
    def position_lower_limit(self) -> float: ...
    def position_upper_limit(self) -> float: ...
    def set_default_damping(self, damping: float) -> None: ...
    def set_default_translation(self, translation: float) -> None: ...
    def set_random_translation_distribution(self, translation: pydrake.symbolic.Expression) -> None: ...
    def set_translation(self, context: pydrake.systems.framework.Context, translation: float) -> PrismaticJoint: ...
    def set_translation_rate(self, context: pydrake.systems.framework.Context, translation_dot: float) -> PrismaticJoint: ...
    def translation_axis(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def velocity_lower_limit(self) -> float: ...
    def velocity_upper_limit(self) -> float: ...

class PrismaticJoint_𝓣AutoDiffXd𝓤(Joint_TAutoDiffXdU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TAutoDiffXdU, frame_on_child: Frame_TAutoDiffXdU, axis: numpy.ndarray[numpy.float64[3, 1]], pos_lower_limit: float = ..., pos_upper_limit: float = ..., damping: float = ...) -> None: ...
    def GetDamping(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def SetDamping(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, damping: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def acceleration_lower_limit(self) -> float: ...
    def acceleration_upper_limit(self) -> float: ...
    def default_damping(self) -> float: ...
    def get_default_translation(self) -> float: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_translation_rate(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def position_lower_limit(self) -> float: ...
    def position_upper_limit(self) -> float: ...
    def set_default_damping(self, damping: float) -> None: ...
    def set_default_translation(self, translation: float) -> None: ...
    def set_random_translation_distribution(self, translation: pydrake.symbolic.Expression) -> None: ...
    def set_translation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, translation: pydrake.autodiffutils.AutoDiffXd) -> PrismaticJoint_TAutoDiffXdU: ...
    def set_translation_rate(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, translation_dot: pydrake.autodiffutils.AutoDiffXd) -> PrismaticJoint_TAutoDiffXdU: ...
    def translation_axis(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def velocity_lower_limit(self) -> float: ...
    def velocity_upper_limit(self) -> float: ...

class PrismaticJoint_𝓣Expression𝓤(Joint_TExpressionU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TExpressionU, frame_on_child: Frame_TExpressionU, axis: numpy.ndarray[numpy.float64[3, 1]], pos_lower_limit: float = ..., pos_upper_limit: float = ..., damping: float = ...) -> None: ...
    def GetDamping(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def SetDamping(self, context: pydrake.systems.framework.Context_TExpressionU, damping: pydrake.symbolic.Expression) -> None: ...
    def acceleration_lower_limit(self) -> float: ...
    def acceleration_upper_limit(self) -> float: ...
    def default_damping(self) -> float: ...
    def get_default_translation(self) -> float: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_translation_rate(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def position_lower_limit(self) -> float: ...
    def position_upper_limit(self) -> float: ...
    def set_default_damping(self, damping: float) -> None: ...
    def set_default_translation(self, translation: float) -> None: ...
    def set_random_translation_distribution(self, translation: pydrake.symbolic.Expression) -> None: ...
    def set_translation(self, context: pydrake.systems.framework.Context_TExpressionU, translation: pydrake.symbolic.Expression) -> PrismaticJoint_TExpressionU: ...
    def set_translation_rate(self, context: pydrake.systems.framework.Context_TExpressionU, translation_dot: pydrake.symbolic.Expression) -> PrismaticJoint_TExpressionU: ...
    def translation_axis(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def velocity_lower_limit(self) -> float: ...
    def velocity_upper_limit(self) -> float: ...

class PrismaticSpring(ForceElement):
    def __init__(self, joint: PrismaticJoint, nominal_position: float, stiffness: float) -> None: ...
    def joint(self) -> PrismaticJoint: ...
    def nominal_position(self) -> float: ...
    def stiffness(self) -> float: ...

class PrismaticSpring_𝓣AutoDiffXd𝓤(ForceElement_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, joint: PrismaticJoint_TAutoDiffXdU, nominal_position: float, stiffness: float) -> None: ...
    def joint(self) -> PrismaticJoint_TAutoDiffXdU: ...
    def nominal_position(self) -> float: ...
    def stiffness(self) -> float: ...

class PrismaticSpring_𝓣Expression𝓤(ForceElement_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, joint: PrismaticJoint_TExpressionU, nominal_position: float, stiffness: float) -> None: ...
    def joint(self) -> PrismaticJoint_TExpressionU: ...
    def nominal_position(self) -> float: ...
    def stiffness(self) -> float: ...

class QuaternionFloatingJoint(Joint):
    kTypeName: ClassVar[str] = ...  # read-only
    def __init__(self, name: str, frame_on_parent: Frame, frame_on_child: Frame, angular_damping: float = ..., translational_damping: float = ...) -> None: ...
    def GetPose(self, context: pydrake.systems.framework.Context) -> pydrake.math.RigidTransform: ...
    def SetOrientation(self, context: pydrake.systems.framework.Context, R: pydrake.math.RotationMatrix) -> QuaternionFloatingJoint: ...
    def SetPose(self, context: pydrake.systems.framework.Context, X_FM: pydrake.math.RigidTransform) -> QuaternionFloatingJoint: ...
    def SetQuaternion(self, context: pydrake.systems.framework.Context, q_FM: pydrake.common.eigen_geometry.Quaternion) -> QuaternionFloatingJoint: ...
    def SetTranslation(self, context: pydrake.systems.framework.Context, p_FM: numpy.ndarray[numpy.float64[3, 1]]) -> QuaternionFloatingJoint: ...
    def default_angular_damping(self) -> float: ...
    def default_translational_damping(self) -> float: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_default_quaternion(self) -> pydrake.common.eigen_geometry.Quaternion: ...
    def get_default_translation(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_quaternion(self, context: pydrake.systems.framework.Context) -> pydrake.common.eigen_geometry.Quaternion: ...
    def get_translation(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context, w_FM: numpy.ndarray[numpy.float64[3, 1]]) -> QuaternionFloatingJoint: ...
    def set_default_quaternion(self, q_FM: pydrake.common.eigen_geometry.Quaternion) -> None: ...
    def set_default_translation(self, translation: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_random_quaternion_distribution(self, q_FM: pydrake.common.eigen_geometry.Quaternion_TExpressionU) -> None: ...
    def set_random_quaternion_distribution_to_uniform(self) -> None: ...
    def set_random_translation_distribution(self, translation: numpy.ndarray[object[3, 1]]) -> None: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context, v_FM: numpy.ndarray[numpy.float64[3, 1]]) -> QuaternionFloatingJoint: ...

class QuaternionFloatingJoint_𝓣AutoDiffXd𝓤(Joint_TAutoDiffXdU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TAutoDiffXdU, frame_on_child: Frame_TAutoDiffXdU, angular_damping: float = ..., translational_damping: float = ...) -> None: ...
    def GetPose(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def SetOrientation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, R: pydrake.math.RotationMatrix_TAutoDiffXdU) -> QuaternionFloatingJoint_TAutoDiffXdU: ...
    def SetPose(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, X_FM: pydrake.math.RigidTransform_TAutoDiffXdU) -> QuaternionFloatingJoint_TAutoDiffXdU: ...
    def SetQuaternion(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, q_FM: pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU) -> QuaternionFloatingJoint_TAutoDiffXdU: ...
    def SetTranslation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, p_FM: numpy.ndarray[object[3, 1]]) -> QuaternionFloatingJoint_TAutoDiffXdU: ...
    def default_angular_damping(self) -> float: ...
    def default_translational_damping(self) -> float: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def get_default_quaternion(self) -> pydrake.common.eigen_geometry.Quaternion: ...
    def get_default_translation(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_quaternion(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, w_FM: numpy.ndarray[object[3, 1]]) -> QuaternionFloatingJoint_TAutoDiffXdU: ...
    def set_default_quaternion(self, q_FM: pydrake.common.eigen_geometry.Quaternion) -> None: ...
    def set_default_translation(self, translation: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_random_quaternion_distribution(self, q_FM: pydrake.common.eigen_geometry.Quaternion_TExpressionU) -> None: ...
    def set_random_quaternion_distribution_to_uniform(self) -> None: ...
    def set_random_translation_distribution(self, translation: numpy.ndarray[object[3, 1]]) -> None: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, v_FM: numpy.ndarray[object[3, 1]]) -> QuaternionFloatingJoint_TAutoDiffXdU: ...

class QuaternionFloatingJoint_𝓣Expression𝓤(Joint_TExpressionU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TExpressionU, frame_on_child: Frame_TExpressionU, angular_damping: float = ..., translational_damping: float = ...) -> None: ...
    def GetPose(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def SetOrientation(self, context: pydrake.systems.framework.Context_TExpressionU, R: pydrake.math.RotationMatrix_TExpressionU) -> QuaternionFloatingJoint_TExpressionU: ...
    def SetPose(self, context: pydrake.systems.framework.Context_TExpressionU, X_FM: pydrake.math.RigidTransform_TExpressionU) -> QuaternionFloatingJoint_TExpressionU: ...
    def SetQuaternion(self, context: pydrake.systems.framework.Context_TExpressionU, q_FM: pydrake.common.eigen_geometry.Quaternion_TExpressionU) -> QuaternionFloatingJoint_TExpressionU: ...
    def SetTranslation(self, context: pydrake.systems.framework.Context_TExpressionU, p_FM: numpy.ndarray[object[3, 1]]) -> QuaternionFloatingJoint_TExpressionU: ...
    def default_angular_damping(self) -> float: ...
    def default_translational_damping(self) -> float: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def get_default_quaternion(self) -> pydrake.common.eigen_geometry.Quaternion: ...
    def get_default_translation(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_quaternion(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.common.eigen_geometry.Quaternion_TExpressionU: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU, w_FM: numpy.ndarray[object[3, 1]]) -> QuaternionFloatingJoint_TExpressionU: ...
    def set_default_quaternion(self, q_FM: pydrake.common.eigen_geometry.Quaternion) -> None: ...
    def set_default_translation(self, translation: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_random_quaternion_distribution(self, q_FM: pydrake.common.eigen_geometry.Quaternion_TExpressionU) -> None: ...
    def set_random_quaternion_distribution_to_uniform(self) -> None: ...
    def set_random_translation_distribution(self, translation: numpy.ndarray[object[3, 1]]) -> None: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context_TExpressionU, v_FM: numpy.ndarray[object[3, 1]]) -> QuaternionFloatingJoint_TExpressionU: ...

class RevoluteJoint(Joint):
    kTypeName: ClassVar[str] = ...  # read-only
    def __init__(self, name: str, frame_on_parent: Frame, frame_on_child: Frame, axis: numpy.ndarray[numpy.float64[3, 1]], damping: float = ...) -> None: ...
    def GetDamping(self, context: pydrake.systems.framework.Context) -> float: ...
    def SetDamping(self, context: pydrake.systems.framework.Context, damping: float) -> None: ...
    def acceleration_lower_limit(self) -> float: ...
    def acceleration_upper_limit(self) -> float: ...
    def default_damping(self) -> float: ...
    def get_angle(self, context: pydrake.systems.framework.Context) -> float: ...
    def get_angular_rate(self, context: pydrake.systems.framework.Context) -> float: ...
    def get_default_angle(self) -> float: ...
    def position_lower_limit(self) -> float: ...
    def position_upper_limit(self) -> float: ...
    def revolute_axis(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def set_angle(self, context: pydrake.systems.framework.Context, angle: float) -> RevoluteJoint: ...
    def set_angular_rate(self, context: pydrake.systems.framework.Context, angle: float) -> RevoluteJoint: ...
    def set_default_angle(self, angle: float) -> None: ...
    def set_default_damping(self, damping: float) -> None: ...
    def set_random_angle_distribution(self, angle: pydrake.symbolic.Expression) -> None: ...
    def velocity_lower_limit(self) -> float: ...
    def velocity_upper_limit(self) -> float: ...

class RevoluteJoint_𝓣AutoDiffXd𝓤(Joint_TAutoDiffXdU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TAutoDiffXdU, frame_on_child: Frame_TAutoDiffXdU, axis: numpy.ndarray[numpy.float64[3, 1]], damping: float = ...) -> None: ...
    def GetDamping(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def SetDamping(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, damping: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def acceleration_lower_limit(self) -> float: ...
    def acceleration_upper_limit(self) -> float: ...
    def default_damping(self) -> float: ...
    def get_angle(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_angular_rate(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_default_angle(self) -> float: ...
    def position_lower_limit(self) -> float: ...
    def position_upper_limit(self) -> float: ...
    def revolute_axis(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def set_angle(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, angle: pydrake.autodiffutils.AutoDiffXd) -> RevoluteJoint_TAutoDiffXdU: ...
    def set_angular_rate(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, angle: pydrake.autodiffutils.AutoDiffXd) -> RevoluteJoint_TAutoDiffXdU: ...
    def set_default_angle(self, angle: float) -> None: ...
    def set_default_damping(self, damping: float) -> None: ...
    def set_random_angle_distribution(self, angle: pydrake.symbolic.Expression) -> None: ...
    def velocity_lower_limit(self) -> float: ...
    def velocity_upper_limit(self) -> float: ...

class RevoluteJoint_𝓣Expression𝓤(Joint_TExpressionU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TExpressionU, frame_on_child: Frame_TExpressionU, axis: numpy.ndarray[numpy.float64[3, 1]], damping: float = ...) -> None: ...
    def GetDamping(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def SetDamping(self, context: pydrake.systems.framework.Context_TExpressionU, damping: pydrake.symbolic.Expression) -> None: ...
    def acceleration_lower_limit(self) -> float: ...
    def acceleration_upper_limit(self) -> float: ...
    def default_damping(self) -> float: ...
    def get_angle(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_angular_rate(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_default_angle(self) -> float: ...
    def position_lower_limit(self) -> float: ...
    def position_upper_limit(self) -> float: ...
    def revolute_axis(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def set_angle(self, context: pydrake.systems.framework.Context_TExpressionU, angle: pydrake.symbolic.Expression) -> RevoluteJoint_TExpressionU: ...
    def set_angular_rate(self, context: pydrake.systems.framework.Context_TExpressionU, angle: pydrake.symbolic.Expression) -> RevoluteJoint_TExpressionU: ...
    def set_default_angle(self, angle: float) -> None: ...
    def set_default_damping(self, damping: float) -> None: ...
    def set_random_angle_distribution(self, angle: pydrake.symbolic.Expression) -> None: ...
    def velocity_lower_limit(self) -> float: ...
    def velocity_upper_limit(self) -> float: ...

class RevoluteSpring(ForceElement):
    def __init__(self, joint: RevoluteJoint, nominal_angle: float, stiffness: float) -> None: ...
    def GetNominalAngle(self, context: pydrake.systems.framework.Context) -> float: ...
    def GetStiffness(self, context: pydrake.systems.framework.Context) -> float: ...
    def SetNominalAngle(self, context: pydrake.systems.framework.Context, nominal_angle: float) -> None: ...
    def SetStiffness(self, context: pydrake.systems.framework.Context, stiffness: float) -> None: ...
    def default_nominal_angle(self) -> float: ...
    def default_stiffness(self) -> float: ...
    def joint(self) -> RevoluteJoint: ...

class RevoluteSpring_𝓣AutoDiffXd𝓤(ForceElement_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, joint: RevoluteJoint_TAutoDiffXdU, nominal_angle: float, stiffness: float) -> None: ...
    def GetNominalAngle(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def GetStiffness(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def SetNominalAngle(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, nominal_angle: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def SetStiffness(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, stiffness: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def default_nominal_angle(self) -> float: ...
    def default_stiffness(self) -> float: ...
    def joint(self) -> RevoluteJoint_TAutoDiffXdU: ...

class RevoluteSpring_𝓣Expression𝓤(ForceElement_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, joint: RevoluteJoint_TExpressionU, nominal_angle: float, stiffness: float) -> None: ...
    def GetNominalAngle(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def GetStiffness(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def SetNominalAngle(self, context: pydrake.systems.framework.Context_TExpressionU, nominal_angle: pydrake.symbolic.Expression) -> None: ...
    def SetStiffness(self, context: pydrake.systems.framework.Context_TExpressionU, stiffness: pydrake.symbolic.Expression) -> None: ...
    def default_nominal_angle(self) -> float: ...
    def default_stiffness(self) -> float: ...
    def joint(self) -> RevoluteJoint_TExpressionU: ...

class RigidBody:
    def __init__(self, body_name: str, M_BBo_B: SpatialInertia = ...) -> None: ...
    def AddInForce(self, context: pydrake.systems.framework.Context, p_BP_E: numpy.ndarray[numpy.float64[3, 1]], F_Bp_E: pydrake.multibody.math.SpatialForce, frame_E: Frame, forces: MultibodyForces) -> None: ...
    def AddInForceInWorld(self, context: pydrake.systems.framework.Context, F_Bo_W: pydrake.multibody.math.SpatialForce, forces: MultibodyForces) -> None: ...
    def CalcCenterOfMassInBodyFrame(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcCenterOfMassTranslationalAccelerationInWorld(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcCenterOfMassTranslationalVelocityInWorld(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcSpatialInertiaInBodyFrame(self, context: pydrake.systems.framework.Context) -> SpatialInertia: ...
    def EvalPoseInWorld(self, context: pydrake.systems.framework.Context) -> pydrake.math.RigidTransform: ...
    def EvalSpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context) -> pydrake.multibody.math.SpatialAcceleration: ...
    def EvalSpatialVelocityInWorld(self, context: pydrake.systems.framework.Context) -> pydrake.multibody.math.SpatialVelocity: ...
    def GetForceInWorld(self, context: pydrake.systems.framework.Context, forces: MultibodyForces) -> pydrake.multibody.math.SpatialForce: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def Lock(self, context: pydrake.systems.framework.Context) -> None: ...
    def SetCenterOfMassInBodyFrame(self, context: pydrake.systems.framework.Context, com: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def SetMass(self, context: pydrake.systems.framework.Context, mass: float) -> None: ...
    def SetSpatialInertiaInBodyFrame(self, context: pydrake.systems.framework.Context, M_Bo_B: SpatialInertia) -> None: ...
    def Unlock(self, context: pydrake.systems.framework.Context) -> None: ...
    def body_frame(self) -> RigidBodyFrame: ...
    def default_com(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def default_mass(self) -> float: ...
    def default_rotational_inertia(self) -> RotationalInertia: ...
    def default_spatial_inertia(self) -> SpatialInertia: ...
    def default_unit_inertia(self) -> UnitInertia: ...
    def floating_position_suffix(self, arg0: int) -> str: ...
    def floating_positions_start(self) -> int: ...
    def floating_velocities_start_in_v(self) -> int: ...
    def floating_velocity_suffix(self, arg0: int) -> str: ...
    def get_mass(self, context: pydrake.systems.framework.Context) -> float: ...
    def has_quaternion_dofs(self) -> bool: ...
    def index(self) -> BodyIndex: ...
    def is_ephemeral(self) -> bool: ...
    def is_floating(self) -> bool: ...
    def is_floating_base_body(self) -> bool: ...
    @overload
    def is_locked(self, context: pydrake.systems.framework.Context) -> bool: ...
    @overload
    def is_locked(self) -> Any: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def scoped_name(self) -> ScopedName: ...

class RigidBodyFrame(Frame):
    def __init__(self, *args, **kwargs) -> None: ...

class RigidBodyFrame_𝓣AutoDiffXd𝓤(Frame_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class RigidBodyFrame_𝓣Expression𝓤(Frame_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class RigidBody_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, body_name: str, M_BBo_B: SpatialInertia = ...) -> None: ...
    def AddInForce(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, p_BP_E: numpy.ndarray[object[3, 1]], F_Bp_E: pydrake.multibody.math.SpatialForce_TAutoDiffXdU, frame_E: Frame_TAutoDiffXdU, forces: MultibodyForces_TAutoDiffXdU) -> None: ...
    def AddInForceInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, F_Bo_W: pydrake.multibody.math.SpatialForce_TAutoDiffXdU, forces: MultibodyForces_TAutoDiffXdU) -> None: ...
    def CalcCenterOfMassInBodyFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcCenterOfMassTranslationalAccelerationInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcCenterOfMassTranslationalVelocityInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcSpatialInertiaInBodyFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> SpatialInertia_TAutoDiffXdU: ...
    def EvalPoseInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def EvalSpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.multibody.math.SpatialAcceleration_TAutoDiffXdU: ...
    def EvalSpatialVelocityInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.multibody.math.SpatialVelocity_TAutoDiffXdU: ...
    def GetForceInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, forces: MultibodyForces_TAutoDiffXdU) -> pydrake.multibody.math.SpatialForce_TAutoDiffXdU: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def Lock(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...
    def SetCenterOfMassInBodyFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, com: numpy.ndarray[object[3, 1]]) -> None: ...
    def SetMass(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, mass: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def SetSpatialInertiaInBodyFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, M_Bo_B: SpatialInertia_TAutoDiffXdU) -> None: ...
    def Unlock(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...
    def body_frame(self) -> RigidBodyFrame_TAutoDiffXdU: ...
    def default_com(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def default_mass(self) -> float: ...
    def default_rotational_inertia(self) -> RotationalInertia: ...
    def default_spatial_inertia(self) -> SpatialInertia: ...
    def default_unit_inertia(self) -> UnitInertia: ...
    def floating_position_suffix(self, arg0: int) -> str: ...
    def floating_positions_start(self) -> int: ...
    def floating_velocities_start_in_v(self) -> int: ...
    def floating_velocity_suffix(self, arg0: int) -> str: ...
    def get_mass(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def has_quaternion_dofs(self) -> bool: ...
    def index(self) -> BodyIndex: ...
    def is_ephemeral(self) -> bool: ...
    def is_floating(self) -> bool: ...
    def is_floating_base_body(self) -> bool: ...
    @overload
    def is_locked(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> bool: ...
    @overload
    def is_locked(self) -> Any: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def scoped_name(self) -> ScopedName: ...

class RigidBody_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, body_name: str, M_BBo_B: SpatialInertia = ...) -> None: ...
    def AddInForce(self, context: pydrake.systems.framework.Context_TExpressionU, p_BP_E: numpy.ndarray[object[3, 1]], F_Bp_E: pydrake.multibody.math.SpatialForce_TExpressionU, frame_E: Frame_TExpressionU, forces: MultibodyForces_TExpressionU) -> None: ...
    def AddInForceInWorld(self, context: pydrake.systems.framework.Context_TExpressionU, F_Bo_W: pydrake.multibody.math.SpatialForce_TExpressionU, forces: MultibodyForces_TExpressionU) -> None: ...
    def CalcCenterOfMassInBodyFrame(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcCenterOfMassTranslationalAccelerationInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcCenterOfMassTranslationalVelocityInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcSpatialInertiaInBodyFrame(self, context: pydrake.systems.framework.Context_TExpressionU) -> SpatialInertia_TExpressionU: ...
    def EvalPoseInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def EvalSpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.multibody.math.SpatialAcceleration_TExpressionU: ...
    def EvalSpatialVelocityInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.multibody.math.SpatialVelocity_TExpressionU: ...
    def GetForceInWorld(self, context: pydrake.systems.framework.Context_TExpressionU, forces: MultibodyForces_TExpressionU) -> pydrake.multibody.math.SpatialForce_TExpressionU: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def Lock(self, context: pydrake.systems.framework.Context_TExpressionU) -> None: ...
    def SetCenterOfMassInBodyFrame(self, context: pydrake.systems.framework.Context_TExpressionU, com: numpy.ndarray[object[3, 1]]) -> None: ...
    def SetMass(self, context: pydrake.systems.framework.Context_TExpressionU, mass: pydrake.symbolic.Expression) -> None: ...
    def SetSpatialInertiaInBodyFrame(self, context: pydrake.systems.framework.Context_TExpressionU, M_Bo_B: SpatialInertia_TExpressionU) -> None: ...
    def Unlock(self, context: pydrake.systems.framework.Context_TExpressionU) -> None: ...
    def body_frame(self) -> RigidBodyFrame_TExpressionU: ...
    def default_com(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def default_mass(self) -> float: ...
    def default_rotational_inertia(self) -> RotationalInertia: ...
    def default_spatial_inertia(self) -> SpatialInertia: ...
    def default_unit_inertia(self) -> UnitInertia: ...
    def floating_position_suffix(self, arg0: int) -> str: ...
    def floating_positions_start(self) -> int: ...
    def floating_velocities_start_in_v(self) -> int: ...
    def floating_velocity_suffix(self, arg0: int) -> str: ...
    def get_mass(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def has_quaternion_dofs(self) -> bool: ...
    def index(self) -> BodyIndex: ...
    def is_ephemeral(self) -> bool: ...
    def is_floating(self) -> bool: ...
    def is_floating_base_body(self) -> bool: ...
    @overload
    def is_locked(self, context: pydrake.systems.framework.Context_TExpressionU) -> bool: ...
    @overload
    def is_locked(self) -> Any: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def scoped_name(self) -> ScopedName: ...

class RotationalInertia:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Ixx: float, Iyy: float, Izz: float) -> None: ...
    @overload
    def __init__(self, Ixx: float, Iyy: float, Izz: float, Ixy: float, Ixz: float, Iyz: float) -> None: ...
    @overload
    def __init__(self, mass: float, p_PQ_E: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def CalcMaximumPossibleMomentOfInertia(self) -> float: ...
    def CalcPrincipalMomentsAndAxesOfInertia(self) -> tuple[numpy.ndarray[numpy.float64[3, 1]], pydrake.math.RotationMatrix]: ...
    def CalcPrincipalMomentsOfInertia(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CopyToFullMatrix3(self) -> numpy.ndarray[numpy.float64[3, 3]]: ...
    @overload
    def CouldBePhysicallyValid(self) -> bool: ...
    @overload
    def CouldBePhysicallyValid(self) -> Any: ...
    def IsNaN(self) -> bool: ...
    def IsNearlyEqualTo(self, other: RotationalInertia, precision: float) -> bool: ...
    def IsZero(self) -> bool: ...
    def ReExpress(self, R_AE: pydrake.math.RotationMatrix) -> RotationalInertia: ...
    def SetToNaN(self) -> None: ...
    def SetZero(self) -> None: ...
    def ShiftFromCenterOfMass(self, mass: float, p_BcmQ_E: numpy.ndarray[numpy.float64[3, 1]]) -> RotationalInertia: ...
    def ShiftToCenterOfMass(self, mass: float, p_QBcm_E: numpy.ndarray[numpy.float64[3, 1]]) -> RotationalInertia: ...
    def ShiftToThenAwayFromCenterOfMass(self, mass: float, p_PBcm_E: numpy.ndarray[numpy.float64[3, 1]], p_QBcm_E: numpy.ndarray[numpy.float64[3, 1]]) -> RotationalInertia: ...
    def Trace(self) -> float: ...
    @staticmethod
    def TriaxiallySymmetric(I_triaxial: float) -> RotationalInertia: ...
    def cols(self) -> int: ...
    def get_moments(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_products(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def rows(self) -> int: ...
    def __add__(self, arg0: RotationalInertia) -> RotationalInertia: ...
    def __copy__(self) -> RotationalInertia: ...
    def __deepcopy__(self, arg0: dict) -> RotationalInertia: ...
    def __getitem__(self, arg0: tuple) -> float: ...
    def __iadd__(self, arg0: RotationalInertia) -> RotationalInertia: ...
    def __imul__(self, arg0: float) -> RotationalInertia: ...
    def __isub__(self, arg0: RotationalInertia) -> RotationalInertia: ...
    def __itruediv__(self, arg0: float) -> RotationalInertia: ...
    @overload
    def __mul__(self, arg0: float) -> RotationalInertia: ...
    @overload
    def __mul__(self, arg0: numpy.ndarray[numpy.float64[3, 1]]) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def __rmul__(self, arg0: float) -> RotationalInertia: ...
    def __sub__(self, arg0: RotationalInertia) -> RotationalInertia: ...
    def __truediv__(self, arg0: float) -> RotationalInertia: ...

class RotationalInertia_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Ixx: pydrake.autodiffutils.AutoDiffXd, Iyy: pydrake.autodiffutils.AutoDiffXd, Izz: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    @overload
    def __init__(self, Ixx: pydrake.autodiffutils.AutoDiffXd, Iyy: pydrake.autodiffutils.AutoDiffXd, Izz: pydrake.autodiffutils.AutoDiffXd, Ixy: pydrake.autodiffutils.AutoDiffXd, Ixz: pydrake.autodiffutils.AutoDiffXd, Iyz: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    @overload
    def __init__(self, mass: pydrake.autodiffutils.AutoDiffXd, p_PQ_E: numpy.ndarray[object[3, 1]]) -> None: ...
    def CalcMaximumPossibleMomentOfInertia(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def CalcPrincipalMomentsAndAxesOfInertia(self) -> tuple[numpy.ndarray[numpy.float64[3, 1]], pydrake.math.RotationMatrix]: ...
    def CalcPrincipalMomentsOfInertia(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CopyToFullMatrix3(self) -> numpy.ndarray[object[3, 3]]: ...
    @overload
    def CouldBePhysicallyValid(self) -> bool: ...
    @overload
    def CouldBePhysicallyValid(self) -> Any: ...
    def IsNaN(self) -> bool: ...
    def IsNearlyEqualTo(self, other: RotationalInertia_TAutoDiffXdU, precision: float) -> bool: ...
    def IsZero(self) -> bool: ...
    def ReExpress(self, R_AE: pydrake.math.RotationMatrix_TAutoDiffXdU) -> RotationalInertia_TAutoDiffXdU: ...
    def SetToNaN(self) -> None: ...
    def SetZero(self) -> None: ...
    def ShiftFromCenterOfMass(self, mass: pydrake.autodiffutils.AutoDiffXd, p_BcmQ_E: numpy.ndarray[object[3, 1]]) -> RotationalInertia_TAutoDiffXdU: ...
    def ShiftToCenterOfMass(self, mass: pydrake.autodiffutils.AutoDiffXd, p_QBcm_E: numpy.ndarray[object[3, 1]]) -> RotationalInertia_TAutoDiffXdU: ...
    def ShiftToThenAwayFromCenterOfMass(self, mass: pydrake.autodiffutils.AutoDiffXd, p_PBcm_E: numpy.ndarray[object[3, 1]], p_QBcm_E: numpy.ndarray[object[3, 1]]) -> RotationalInertia_TAutoDiffXdU: ...
    def Trace(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    @staticmethod
    def TriaxiallySymmetric(I_triaxial: pydrake.autodiffutils.AutoDiffXd) -> RotationalInertia_TAutoDiffXdU: ...
    def cols(self) -> int: ...
    def get_moments(self) -> numpy.ndarray[object[3, 1]]: ...
    def get_products(self) -> numpy.ndarray[object[3, 1]]: ...
    def rows(self) -> int: ...
    def __add__(self, arg0: RotationalInertia_TAutoDiffXdU) -> RotationalInertia_TAutoDiffXdU: ...
    def __copy__(self) -> RotationalInertia_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> RotationalInertia_TAutoDiffXdU: ...
    def __getitem__(self, arg0: tuple) -> pydrake.autodiffutils.AutoDiffXd: ...
    def __iadd__(self, arg0: RotationalInertia_TAutoDiffXdU) -> RotationalInertia_TAutoDiffXdU: ...
    def __imul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> RotationalInertia_TAutoDiffXdU: ...
    def __isub__(self, arg0: RotationalInertia_TAutoDiffXdU) -> RotationalInertia_TAutoDiffXdU: ...
    def __itruediv__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> RotationalInertia_TAutoDiffXdU: ...
    @overload
    def __mul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> RotationalInertia_TAutoDiffXdU: ...
    @overload
    def __mul__(self, arg0: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def __rmul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> RotationalInertia_TAutoDiffXdU: ...
    def __sub__(self, arg0: RotationalInertia_TAutoDiffXdU) -> RotationalInertia_TAutoDiffXdU: ...
    def __truediv__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> RotationalInertia_TAutoDiffXdU: ...

class RotationalInertia_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Ixx: pydrake.symbolic.Expression, Iyy: pydrake.symbolic.Expression, Izz: pydrake.symbolic.Expression) -> None: ...
    @overload
    def __init__(self, Ixx: pydrake.symbolic.Expression, Iyy: pydrake.symbolic.Expression, Izz: pydrake.symbolic.Expression, Ixy: pydrake.symbolic.Expression, Ixz: pydrake.symbolic.Expression, Iyz: pydrake.symbolic.Expression) -> None: ...
    @overload
    def __init__(self, mass: pydrake.symbolic.Expression, p_PQ_E: numpy.ndarray[object[3, 1]]) -> None: ...
    def CalcMaximumPossibleMomentOfInertia(self) -> pydrake.symbolic.Expression: ...
    def CalcPrincipalMomentsAndAxesOfInertia(self) -> tuple[numpy.ndarray[numpy.float64[3, 1]], pydrake.math.RotationMatrix]: ...
    def CalcPrincipalMomentsOfInertia(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CopyToFullMatrix3(self) -> numpy.ndarray[object[3, 3]]: ...
    @overload
    def CouldBePhysicallyValid(self) -> pydrake.symbolic.Formula: ...
    @overload
    def CouldBePhysicallyValid(self) -> Any: ...
    def IsNaN(self) -> pydrake.symbolic.Formula: ...
    def IsNearlyEqualTo(self, other: RotationalInertia_TExpressionU, precision: float) -> pydrake.symbolic.Formula: ...
    def IsZero(self) -> pydrake.symbolic.Formula: ...
    def ReExpress(self, R_AE: pydrake.math.RotationMatrix_TExpressionU) -> RotationalInertia_TExpressionU: ...
    def SetToNaN(self) -> None: ...
    def SetZero(self) -> None: ...
    def ShiftFromCenterOfMass(self, mass: pydrake.symbolic.Expression, p_BcmQ_E: numpy.ndarray[object[3, 1]]) -> RotationalInertia_TExpressionU: ...
    def ShiftToCenterOfMass(self, mass: pydrake.symbolic.Expression, p_QBcm_E: numpy.ndarray[object[3, 1]]) -> RotationalInertia_TExpressionU: ...
    def ShiftToThenAwayFromCenterOfMass(self, mass: pydrake.symbolic.Expression, p_PBcm_E: numpy.ndarray[object[3, 1]], p_QBcm_E: numpy.ndarray[object[3, 1]]) -> RotationalInertia_TExpressionU: ...
    def Trace(self) -> pydrake.symbolic.Expression: ...
    @staticmethod
    def TriaxiallySymmetric(I_triaxial: pydrake.symbolic.Expression) -> RotationalInertia_TExpressionU: ...
    def cols(self) -> int: ...
    def get_moments(self) -> numpy.ndarray[object[3, 1]]: ...
    def get_products(self) -> numpy.ndarray[object[3, 1]]: ...
    def rows(self) -> int: ...
    def __add__(self, arg0: RotationalInertia_TExpressionU) -> RotationalInertia_TExpressionU: ...
    def __copy__(self) -> RotationalInertia_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> RotationalInertia_TExpressionU: ...
    def __getitem__(self, arg0: tuple) -> pydrake.symbolic.Expression: ...
    def __iadd__(self, arg0: RotationalInertia_TExpressionU) -> RotationalInertia_TExpressionU: ...
    def __imul__(self, arg0: pydrake.symbolic.Expression) -> RotationalInertia_TExpressionU: ...
    def __isub__(self, arg0: RotationalInertia_TExpressionU) -> RotationalInertia_TExpressionU: ...
    def __itruediv__(self, arg0: pydrake.symbolic.Expression) -> RotationalInertia_TExpressionU: ...
    @overload
    def __mul__(self, arg0: pydrake.symbolic.Expression) -> RotationalInertia_TExpressionU: ...
    @overload
    def __mul__(self, arg0: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def __rmul__(self, arg0: pydrake.symbolic.Expression) -> RotationalInertia_TExpressionU: ...
    def __sub__(self, arg0: RotationalInertia_TExpressionU) -> RotationalInertia_TExpressionU: ...
    def __truediv__(self, arg0: pydrake.symbolic.Expression) -> RotationalInertia_TExpressionU: ...

class RpyFloatingJoint(Joint):
    kTypeName: ClassVar[str] = ...  # read-only
    def __init__(self, name: str, frame_on_parent: Frame, frame_on_child: Frame, angular_damping: float = ..., translational_damping: float = ...) -> None: ...
    def GetPose(self, context: pydrake.systems.framework.Context) -> pydrake.math.RigidTransform: ...
    def SetOrientation(self, context: pydrake.systems.framework.Context, R_FM: pydrake.math.RotationMatrix) -> RpyFloatingJoint: ...
    def SetPose(self, context: pydrake.systems.framework.Context, X_FM: pydrake.math.RigidTransform) -> RpyFloatingJoint: ...
    def SetTranslation(self, context: pydrake.systems.framework.Context, p_FM: numpy.ndarray[numpy.float64[3, 1]]) -> RpyFloatingJoint: ...
    def default_angular_damping(self) -> float: ...
    def default_translational_damping(self) -> float: ...
    def get_angles(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_default_angles(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_default_translation(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_translation(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def set_angles(self, context: pydrake.systems.framework.Context, angles: numpy.ndarray[numpy.float64[3, 1]]) -> RpyFloatingJoint: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context, w_FM: numpy.ndarray[numpy.float64[3, 1]]) -> RpyFloatingJoint: ...
    def set_default_angles(self, angles: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_default_translation(self, p_FM: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_random_angles_distribution(self, angles: numpy.ndarray[object[3, 1]]) -> None: ...
    def set_random_translation_distribution(self, p_FM: numpy.ndarray[object[3, 1]]) -> None: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context, v_FM: numpy.ndarray[numpy.float64[3, 1]]) -> RpyFloatingJoint: ...

class RpyFloatingJoint_𝓣AutoDiffXd𝓤(Joint_TAutoDiffXdU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TAutoDiffXdU, frame_on_child: Frame_TAutoDiffXdU, angular_damping: float = ..., translational_damping: float = ...) -> None: ...
    def GetPose(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def SetOrientation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, R_FM: pydrake.math.RotationMatrix_TAutoDiffXdU) -> RpyFloatingJoint_TAutoDiffXdU: ...
    def SetPose(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, X_FM: pydrake.math.RigidTransform_TAutoDiffXdU) -> RpyFloatingJoint_TAutoDiffXdU: ...
    def SetTranslation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, p_FM: numpy.ndarray[object[3, 1]]) -> RpyFloatingJoint_TAutoDiffXdU: ...
    def default_angular_damping(self) -> float: ...
    def default_translational_damping(self) -> float: ...
    def get_angles(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def get_default_angles(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_default_translation(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def set_angles(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, angles: numpy.ndarray[object[3, 1]]) -> RpyFloatingJoint_TAutoDiffXdU: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, w_FM: numpy.ndarray[object[3, 1]]) -> RpyFloatingJoint_TAutoDiffXdU: ...
    def set_default_angles(self, angles: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_default_translation(self, p_FM: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_random_angles_distribution(self, angles: numpy.ndarray[object[3, 1]]) -> None: ...
    def set_random_translation_distribution(self, p_FM: numpy.ndarray[object[3, 1]]) -> None: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, v_FM: numpy.ndarray[object[3, 1]]) -> RpyFloatingJoint_TAutoDiffXdU: ...

class RpyFloatingJoint_𝓣Expression𝓤(Joint_TExpressionU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TExpressionU, frame_on_child: Frame_TExpressionU, angular_damping: float = ..., translational_damping: float = ...) -> None: ...
    def GetPose(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def SetOrientation(self, context: pydrake.systems.framework.Context_TExpressionU, R_FM: pydrake.math.RotationMatrix_TExpressionU) -> RpyFloatingJoint_TExpressionU: ...
    def SetPose(self, context: pydrake.systems.framework.Context_TExpressionU, X_FM: pydrake.math.RigidTransform_TExpressionU) -> RpyFloatingJoint_TExpressionU: ...
    def SetTranslation(self, context: pydrake.systems.framework.Context_TExpressionU, p_FM: numpy.ndarray[object[3, 1]]) -> RpyFloatingJoint_TExpressionU: ...
    def default_angular_damping(self) -> float: ...
    def default_translational_damping(self) -> float: ...
    def get_angles(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def get_default_angles(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_default_translation(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def set_angles(self, context: pydrake.systems.framework.Context_TExpressionU, angles: numpy.ndarray[object[3, 1]]) -> RpyFloatingJoint_TExpressionU: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU, w_FM: numpy.ndarray[object[3, 1]]) -> RpyFloatingJoint_TExpressionU: ...
    def set_default_angles(self, angles: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_default_translation(self, p_FM: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_random_angles_distribution(self, angles: numpy.ndarray[object[3, 1]]) -> None: ...
    def set_random_translation_distribution(self, p_FM: numpy.ndarray[object[3, 1]]) -> None: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context_TExpressionU, v_FM: numpy.ndarray[object[3, 1]]) -> RpyFloatingJoint_TExpressionU: ...

class ScopedName:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, namespace_name: str, element_name: str) -> None: ...
    @staticmethod
    def Join(name1: str, name2: str) -> ScopedName: ...
    @staticmethod
    def Make(namespace_name: str, element_name: str) -> ScopedName | None: ...
    @staticmethod
    def Parse(scoped_name: str) -> ScopedName: ...
    def get_element(self) -> str: ...
    def get_full(self) -> str: ...
    def get_namespace(self) -> str: ...
    def set_element(self, element_name: str) -> None: ...
    def set_namespace(self, namespace_name: str) -> None: ...
    def to_string(self) -> str: ...
    def __copy__(self) -> ScopedName: ...
    def __deepcopy__(self, arg0: dict) -> ScopedName: ...

class ScrewJoint(Joint):
    kTypeName: ClassVar[str] = ...  # read-only
    def __init__(self, name: str, frame_on_parent: Frame, frame_on_child: Frame, screw_pitch: float, damping: float) -> None: ...
    def GetDamping(self, context: pydrake.systems.framework.Context) -> float: ...
    def SetDamping(self, context: pydrake.systems.framework.Context, damping: float) -> None: ...
    def default_damping(self) -> float: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context) -> float: ...
    def get_default_rotation(self) -> float: ...
    def get_default_translation(self) -> float: ...
    def get_rotation(self, context: pydrake.systems.framework.Context) -> float: ...
    def get_translation(self, context: pydrake.systems.framework.Context) -> float: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context) -> float: ...
    def screw_pitch(self) -> float: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context, theta_dot: float) -> ScrewJoint: ...
    def set_default_rotation(self, theta: float) -> None: ...
    def set_default_translation(self, z: float) -> None: ...
    def set_random_pose_distribution(self, theta: numpy.ndarray[object[1, 1]]) -> None: ...
    def set_translation(self, context: pydrake.systems.framework.Context, translation: float) -> ScrewJoint: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context, translation_dot: float) -> ScrewJoint: ...

class ScrewJoint_𝓣AutoDiffXd𝓤(Joint_TAutoDiffXdU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TAutoDiffXdU, frame_on_child: Frame_TAutoDiffXdU, screw_pitch: float, damping: float) -> None: ...
    def GetDamping(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def SetDamping(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, damping: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def default_damping(self) -> float: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_default_rotation(self) -> float: ...
    def get_default_translation(self) -> float: ...
    def get_rotation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def screw_pitch(self) -> float: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, theta_dot: pydrake.autodiffutils.AutoDiffXd) -> ScrewJoint_TAutoDiffXdU: ...
    def set_default_rotation(self, theta: float) -> None: ...
    def set_default_translation(self, z: float) -> None: ...
    def set_random_pose_distribution(self, theta: numpy.ndarray[object[1, 1]]) -> None: ...
    def set_translation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, translation: pydrake.autodiffutils.AutoDiffXd) -> ScrewJoint_TAutoDiffXdU: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, translation_dot: pydrake.autodiffutils.AutoDiffXd) -> ScrewJoint_TAutoDiffXdU: ...

class ScrewJoint_𝓣Expression𝓤(Joint_TExpressionU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TExpressionU, frame_on_child: Frame_TExpressionU, screw_pitch: float, damping: float) -> None: ...
    def GetDamping(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def SetDamping(self, context: pydrake.systems.framework.Context_TExpressionU, damping: pydrake.symbolic.Expression) -> None: ...
    def default_damping(self) -> float: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_default_rotation(self) -> float: ...
    def get_default_translation(self) -> float: ...
    def get_rotation(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def screw_pitch(self) -> float: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU, theta_dot: pydrake.symbolic.Expression) -> ScrewJoint_TExpressionU: ...
    def set_default_rotation(self, theta: float) -> None: ...
    def set_default_translation(self, z: float) -> None: ...
    def set_random_pose_distribution(self, theta: numpy.ndarray[object[1, 1]]) -> None: ...
    def set_translation(self, context: pydrake.systems.framework.Context_TExpressionU, translation: pydrake.symbolic.Expression) -> ScrewJoint_TExpressionU: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context_TExpressionU, translation_dot: pydrake.symbolic.Expression) -> ScrewJoint_TExpressionU: ...

class SpatialInertia:
    def __init__(self, mass: float, p_PScm_E: numpy.ndarray[numpy.float64[3, 1]], G_SP_E: UnitInertia, skip_validity_check: bool = ...) -> None: ...
    def CalcComMoment(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcPrincipalSemiDiametersAndPoseForSolidEllipsoid(self) -> tuple[numpy.ndarray[numpy.float64[3, 1]], pydrake.math.RigidTransform]: ...
    def CalcRotationalInertia(self) -> RotationalInertia: ...
    def CopyToFullMatrix6(self) -> numpy.ndarray[numpy.float64[6, 6]]: ...
    @staticmethod
    def HollowSphereWithDensity(area_density: float, radius: float) -> SpatialInertia: ...
    @staticmethod
    def HollowSphereWithMass(mass: float, radius: float) -> SpatialInertia: ...
    def IsNaN(self) -> bool: ...
    def IsPhysicallyValid(self) -> bool: ...
    def IsZero(self) -> bool: ...
    @staticmethod
    def MakeFromCentralInertia(mass: float, p_PScm_E: numpy.ndarray[numpy.float64[3, 1]], I_SScm_E: RotationalInertia) -> SpatialInertia: ...
    @staticmethod
    def NaN() -> SpatialInertia: ...
    def ReExpress(self, R_AE: pydrake.math.RotationMatrix) -> SpatialInertia: ...
    def SetNaN(self) -> None: ...
    def Shift(self, p_PQ_E: numpy.ndarray[numpy.float64[3, 1]]) -> SpatialInertia: ...
    @staticmethod
    def SolidBoxWithDensity(density: float, lx: float, ly: float, lz: float) -> SpatialInertia: ...
    @staticmethod
    def SolidBoxWithMass(mass: float, lx: float, ly: float, lz: float) -> SpatialInertia: ...
    @staticmethod
    def SolidCapsuleWithDensity(density: float, radius: float, length: float, unit_vector: numpy.ndarray[numpy.float64[3, 1]]) -> SpatialInertia: ...
    @staticmethod
    def SolidCapsuleWithMass(mass: float, radius: float, length: float, unit_vector: numpy.ndarray[numpy.float64[3, 1]]) -> SpatialInertia: ...
    @staticmethod
    def SolidCubeWithDensity(density: float, length: float) -> SpatialInertia: ...
    @staticmethod
    def SolidCylinderWithDensity(density: float, radius: float, length: float, unit_vector: numpy.ndarray[numpy.float64[3, 1]]) -> SpatialInertia: ...
    @staticmethod
    def SolidCylinderWithDensityAboutEnd(density: float, radius: float, length: float, unit_vector: numpy.ndarray[numpy.float64[3, 1]]) -> SpatialInertia: ...
    @staticmethod
    def SolidCylinderWithMass(mass: float, radius: float, length: float, unit_vector: numpy.ndarray[numpy.float64[3, 1]]) -> SpatialInertia: ...
    @staticmethod
    def SolidCylinderWithMassAboutEnd(mass: float, radius: float, length: float, unit_vector: numpy.ndarray[numpy.float64[3, 1]]) -> SpatialInertia: ...
    @staticmethod
    def SolidEllipsoidWithDensity(density: float, a: float, b: float, c: float) -> SpatialInertia: ...
    @staticmethod
    def SolidEllipsoidWithMass(mass: float, a: float, b: float, c: float) -> SpatialInertia: ...
    @staticmethod
    def SolidSphereWithDensity(density: float, radius: float) -> SpatialInertia: ...
    @staticmethod
    def SolidSphereWithMass(mass: float, radius: float) -> SpatialInertia: ...
    @staticmethod
    def ThinRodWithMass(mass: float, length: float, unit_vector: numpy.ndarray[numpy.float64[3, 1]]) -> SpatialInertia: ...
    @staticmethod
    def ThinRodWithMassAboutEnd(mass: float, length: float, unit_vector: numpy.ndarray[numpy.float64[3, 1]]) -> SpatialInertia: ...
    @staticmethod
    def Zero() -> SpatialInertia: ...
    def get_com(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_mass(self) -> float: ...
    def get_unit_inertia(self) -> UnitInertia: ...
    def __copy__(self) -> SpatialInertia: ...
    def __deepcopy__(self, arg0: dict) -> SpatialInertia: ...
    def __iadd__(self, arg0: SpatialInertia) -> SpatialInertia: ...
    @overload
    def __mul__(self, arg0: pydrake.multibody.math.SpatialAcceleration) -> pydrake.multibody.math.SpatialForce: ...
    @overload
    def __mul__(self, arg0: pydrake.multibody.math.SpatialVelocity) -> pydrake.multibody.math.SpatialMomentum: ...

class SpatialInertia_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, mass: pydrake.autodiffutils.AutoDiffXd, p_PScm_E: numpy.ndarray[object[3, 1]], G_SP_E: UnitInertia_TAutoDiffXdU, skip_validity_check: bool = ...) -> None: ...
    def CalcComMoment(self) -> numpy.ndarray[object[3, 1]]: ...
    def CalcPrincipalSemiDiametersAndPoseForSolidEllipsoid(self) -> tuple[numpy.ndarray[numpy.float64[3, 1]], pydrake.math.RigidTransform]: ...
    def CalcRotationalInertia(self) -> RotationalInertia_TAutoDiffXdU: ...
    def CopyToFullMatrix6(self) -> numpy.ndarray[object[6, 6]]: ...
    @staticmethod
    def HollowSphereWithDensity(area_density: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def HollowSphereWithMass(mass: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd) -> SpatialInertia_TAutoDiffXdU: ...
    def IsNaN(self) -> bool: ...
    def IsPhysicallyValid(self) -> bool: ...
    def IsZero(self) -> bool: ...
    @staticmethod
    def MakeFromCentralInertia(mass: pydrake.autodiffutils.AutoDiffXd, p_PScm_E: numpy.ndarray[object[3, 1]], I_SScm_E: RotationalInertia_TAutoDiffXdU) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def NaN() -> SpatialInertia_TAutoDiffXdU: ...
    def ReExpress(self, R_AE: pydrake.math.RotationMatrix_TAutoDiffXdU) -> SpatialInertia_TAutoDiffXdU: ...
    def SetNaN(self) -> None: ...
    def Shift(self, p_PQ_E: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidBoxWithDensity(density: pydrake.autodiffutils.AutoDiffXd, lx: pydrake.autodiffutils.AutoDiffXd, ly: pydrake.autodiffutils.AutoDiffXd, lz: pydrake.autodiffutils.AutoDiffXd) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidBoxWithMass(mass: pydrake.autodiffutils.AutoDiffXd, lx: pydrake.autodiffutils.AutoDiffXd, ly: pydrake.autodiffutils.AutoDiffXd, lz: pydrake.autodiffutils.AutoDiffXd) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCapsuleWithDensity(density: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCapsuleWithMass(mass: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCubeWithDensity(density: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCylinderWithDensity(density: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCylinderWithDensityAboutEnd(density: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCylinderWithMass(mass: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCylinderWithMassAboutEnd(mass: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidEllipsoidWithDensity(density: pydrake.autodiffutils.AutoDiffXd, a: pydrake.autodiffutils.AutoDiffXd, b: pydrake.autodiffutils.AutoDiffXd, c: pydrake.autodiffutils.AutoDiffXd) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidEllipsoidWithMass(mass: pydrake.autodiffutils.AutoDiffXd, a: pydrake.autodiffutils.AutoDiffXd, b: pydrake.autodiffutils.AutoDiffXd, c: pydrake.autodiffutils.AutoDiffXd) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidSphereWithDensity(density: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidSphereWithMass(mass: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def ThinRodWithMass(mass: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def ThinRodWithMassAboutEnd(mass: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def Zero() -> SpatialInertia_TAutoDiffXdU: ...
    def get_com(self) -> numpy.ndarray[object[3, 1]]: ...
    def get_mass(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_unit_inertia(self) -> UnitInertia_TAutoDiffXdU: ...
    def __copy__(self) -> SpatialInertia_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialInertia_TAutoDiffXdU: ...
    def __iadd__(self, arg0: SpatialInertia_TAutoDiffXdU) -> SpatialInertia_TAutoDiffXdU: ...
    @overload
    def __mul__(self, arg0: pydrake.multibody.math.SpatialAcceleration_TAutoDiffXdU) -> pydrake.multibody.math.SpatialForce_TAutoDiffXdU: ...
    @overload
    def __mul__(self, arg0: pydrake.multibody.math.SpatialVelocity_TAutoDiffXdU) -> pydrake.multibody.math.SpatialMomentum_TAutoDiffXdU: ...

class SpatialInertia_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, mass: pydrake.symbolic.Expression, p_PScm_E: numpy.ndarray[object[3, 1]], G_SP_E: UnitInertia_TExpressionU, skip_validity_check: bool = ...) -> None: ...
    def CalcComMoment(self) -> numpy.ndarray[object[3, 1]]: ...
    def CalcPrincipalSemiDiametersAndPoseForSolidEllipsoid(self) -> tuple[numpy.ndarray[numpy.float64[3, 1]], pydrake.math.RigidTransform]: ...
    def CalcRotationalInertia(self) -> RotationalInertia_TExpressionU: ...
    def CopyToFullMatrix6(self) -> numpy.ndarray[object[6, 6]]: ...
    @staticmethod
    def HollowSphereWithDensity(area_density: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def HollowSphereWithMass(mass: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression) -> SpatialInertia_TExpressionU: ...
    def IsNaN(self) -> pydrake.symbolic.Formula: ...
    def IsPhysicallyValid(self) -> pydrake.symbolic.Formula: ...
    def IsZero(self) -> pydrake.symbolic.Formula: ...
    @staticmethod
    def MakeFromCentralInertia(mass: pydrake.symbolic.Expression, p_PScm_E: numpy.ndarray[object[3, 1]], I_SScm_E: RotationalInertia_TExpressionU) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def NaN() -> SpatialInertia_TExpressionU: ...
    def ReExpress(self, R_AE: pydrake.math.RotationMatrix_TExpressionU) -> SpatialInertia_TExpressionU: ...
    def SetNaN(self) -> None: ...
    def Shift(self, p_PQ_E: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidBoxWithDensity(density: pydrake.symbolic.Expression, lx: pydrake.symbolic.Expression, ly: pydrake.symbolic.Expression, lz: pydrake.symbolic.Expression) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidBoxWithMass(mass: pydrake.symbolic.Expression, lx: pydrake.symbolic.Expression, ly: pydrake.symbolic.Expression, lz: pydrake.symbolic.Expression) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidCapsuleWithDensity(density: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidCapsuleWithMass(mass: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidCubeWithDensity(density: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidCylinderWithDensity(density: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidCylinderWithDensityAboutEnd(density: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidCylinderWithMass(mass: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidCylinderWithMassAboutEnd(mass: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidEllipsoidWithDensity(density: pydrake.symbolic.Expression, a: pydrake.symbolic.Expression, b: pydrake.symbolic.Expression, c: pydrake.symbolic.Expression) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidEllipsoidWithMass(mass: pydrake.symbolic.Expression, a: pydrake.symbolic.Expression, b: pydrake.symbolic.Expression, c: pydrake.symbolic.Expression) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidSphereWithDensity(density: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidSphereWithMass(mass: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def ThinRodWithMass(mass: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def ThinRodWithMassAboutEnd(mass: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def Zero() -> SpatialInertia_TExpressionU: ...
    def get_com(self) -> numpy.ndarray[object[3, 1]]: ...
    def get_mass(self) -> pydrake.symbolic.Expression: ...
    def get_unit_inertia(self) -> UnitInertia_TExpressionU: ...
    def __copy__(self) -> SpatialInertia_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialInertia_TExpressionU: ...
    def __iadd__(self, arg0: SpatialInertia_TExpressionU) -> SpatialInertia_TExpressionU: ...
    @overload
    def __mul__(self, arg0: pydrake.multibody.math.SpatialAcceleration_TExpressionU) -> pydrake.multibody.math.SpatialForce_TExpressionU: ...
    @overload
    def __mul__(self, arg0: pydrake.multibody.math.SpatialVelocity_TExpressionU) -> pydrake.multibody.math.SpatialMomentum_TExpressionU: ...

class UniformGravityFieldElement(ForceElement):
    kDefaultStrength: ClassVar[float] = ...  # read-only
    def __init__(self) -> None: ...
    def CalcGravityGeneralizedForces(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def gravity_vector(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def is_enabled(self, model_instance: ModelInstanceIndex) -> bool: ...
    def set_enabled(self, model_instance: ModelInstanceIndex, is_enabled: bool) -> None: ...
    def set_gravity_vector(self, arg0: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...

class UniformGravityFieldElement_𝓣AutoDiffXd𝓤(ForceElement_TAutoDiffXdU):
    kDefaultStrength: ClassVar[float] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def CalcGravityGeneralizedForces(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    def gravity_vector(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def is_enabled(self, model_instance: ModelInstanceIndex) -> bool: ...
    def set_enabled(self, model_instance: ModelInstanceIndex, is_enabled: bool) -> None: ...
    def set_gravity_vector(self, arg0: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...

class UniformGravityFieldElement_𝓣Expression𝓤(ForceElement_TExpressionU):
    kDefaultStrength: ClassVar[float] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def CalcGravityGeneralizedForces(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    def gravity_vector(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def is_enabled(self, model_instance: ModelInstanceIndex) -> bool: ...
    def set_enabled(self, model_instance: ModelInstanceIndex, is_enabled: bool) -> None: ...
    def set_gravity_vector(self, arg0: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...

class UnitInertia(RotationalInertia):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Ixx: float, Iyy: float, Izz: float) -> None: ...
    @overload
    def __init__(self, Ixx: float, Iyy: float, Izz: float, Ixy: float, Ixz: float, Iyz: float) -> None: ...
    @overload
    def __init__(self, I: RotationalInertia) -> None: ...
    @staticmethod
    def AxiallySymmetric(moment_parallel: float, moment_perpendicular: float, unit_vector: numpy.ndarray[numpy.float64[3, 1]]) -> UnitInertia: ...
    @staticmethod
    def HollowSphere(r: float) -> UnitInertia: ...
    @staticmethod
    def PointMass(p_FQ: numpy.ndarray[numpy.float64[3, 1]]) -> UnitInertia: ...
    def ReExpress(self, R_AE: pydrake.math.RotationMatrix) -> UnitInertia: ...
    def SetFromRotationalInertia(self, I: RotationalInertia, mass: float) -> UnitInertia: ...
    def ShiftFromCenterOfMass(self, p_BcmQ_E: numpy.ndarray[numpy.float64[3, 1]]) -> UnitInertia: ...
    def ShiftToCenterOfMass(self, p_QBcm_E: numpy.ndarray[numpy.float64[3, 1]]) -> UnitInertia: ...
    @staticmethod
    def SolidBox(Lx: float, Ly: float, Lz: float) -> UnitInertia: ...
    @staticmethod
    def SolidCapsule(radius: float, length: float, unit_vector: numpy.ndarray[numpy.float64[3, 1]]) -> UnitInertia: ...
    @staticmethod
    def SolidCube(L: float) -> UnitInertia: ...
    @staticmethod
    def SolidCylinder(radius: float, length: float, unit_vector: numpy.ndarray[numpy.float64[3, 1]]) -> UnitInertia: ...
    @staticmethod
    def SolidCylinderAboutEnd(radius: float, length: float, unit_vector: numpy.ndarray[numpy.float64[3, 1]]) -> UnitInertia: ...
    @staticmethod
    def SolidEllipsoid(a: float, b: float, c: float) -> UnitInertia: ...
    @staticmethod
    def SolidSphere(r: float) -> UnitInertia: ...
    @staticmethod
    def StraightLine(moment_perpendicular: float, unit_vector: numpy.ndarray[numpy.float64[3, 1]]) -> UnitInertia: ...
    @staticmethod
    def ThinRod(length: float, unit_vector: numpy.ndarray[numpy.float64[3, 1]]) -> UnitInertia: ...
    @staticmethod
    def TriaxiallySymmetric(I_triaxial: float) -> UnitInertia: ...
    def __copy__(self) -> UnitInertia: ...
    def __deepcopy__(self, arg0: dict) -> UnitInertia: ...

class UnitInertia_𝓣AutoDiffXd𝓤(RotationalInertia_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Ixx: pydrake.autodiffutils.AutoDiffXd, Iyy: pydrake.autodiffutils.AutoDiffXd, Izz: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    @overload
    def __init__(self, Ixx: pydrake.autodiffutils.AutoDiffXd, Iyy: pydrake.autodiffutils.AutoDiffXd, Izz: pydrake.autodiffutils.AutoDiffXd, Ixy: pydrake.autodiffutils.AutoDiffXd, Ixz: pydrake.autodiffutils.AutoDiffXd, Iyz: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    @overload
    def __init__(self, I: RotationalInertia_TAutoDiffXdU) -> None: ...
    @staticmethod
    def AxiallySymmetric(moment_parallel: pydrake.autodiffutils.AutoDiffXd, moment_perpendicular: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def HollowSphere(r: pydrake.autodiffutils.AutoDiffXd) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def PointMass(p_FQ: numpy.ndarray[object[3, 1]]) -> UnitInertia_TAutoDiffXdU: ...
    def ReExpress(self, R_AE: pydrake.math.RotationMatrix_TAutoDiffXdU) -> UnitInertia_TAutoDiffXdU: ...
    def SetFromRotationalInertia(self, I: RotationalInertia_TAutoDiffXdU, mass: pydrake.autodiffutils.AutoDiffXd) -> UnitInertia_TAutoDiffXdU: ...
    def ShiftFromCenterOfMass(self, p_BcmQ_E: numpy.ndarray[object[3, 1]]) -> UnitInertia_TAutoDiffXdU: ...
    def ShiftToCenterOfMass(self, p_QBcm_E: numpy.ndarray[object[3, 1]]) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidBox(Lx: pydrake.autodiffutils.AutoDiffXd, Ly: pydrake.autodiffutils.AutoDiffXd, Lz: pydrake.autodiffutils.AutoDiffXd) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCapsule(radius: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCube(L: pydrake.autodiffutils.AutoDiffXd) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCylinder(radius: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCylinderAboutEnd(radius: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidEllipsoid(a: pydrake.autodiffutils.AutoDiffXd, b: pydrake.autodiffutils.AutoDiffXd, c: pydrake.autodiffutils.AutoDiffXd) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidSphere(r: pydrake.autodiffutils.AutoDiffXd) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def StraightLine(moment_perpendicular: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def ThinRod(length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def TriaxiallySymmetric(I_triaxial: pydrake.autodiffutils.AutoDiffXd) -> UnitInertia_TAutoDiffXdU: ...
    def __copy__(self) -> UnitInertia_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> UnitInertia_TAutoDiffXdU: ...

class UnitInertia_𝓣Expression𝓤(RotationalInertia_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Ixx: pydrake.symbolic.Expression, Iyy: pydrake.symbolic.Expression, Izz: pydrake.symbolic.Expression) -> None: ...
    @overload
    def __init__(self, Ixx: pydrake.symbolic.Expression, Iyy: pydrake.symbolic.Expression, Izz: pydrake.symbolic.Expression, Ixy: pydrake.symbolic.Expression, Ixz: pydrake.symbolic.Expression, Iyz: pydrake.symbolic.Expression) -> None: ...
    @overload
    def __init__(self, I: RotationalInertia_TExpressionU) -> None: ...
    @staticmethod
    def AxiallySymmetric(moment_parallel: pydrake.symbolic.Expression, moment_perpendicular: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def HollowSphere(r: pydrake.symbolic.Expression) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def PointMass(p_FQ: numpy.ndarray[object[3, 1]]) -> UnitInertia_TExpressionU: ...
    def ReExpress(self, R_AE: pydrake.math.RotationMatrix_TExpressionU) -> UnitInertia_TExpressionU: ...
    def SetFromRotationalInertia(self, I: RotationalInertia_TExpressionU, mass: pydrake.symbolic.Expression) -> UnitInertia_TExpressionU: ...
    def ShiftFromCenterOfMass(self, p_BcmQ_E: numpy.ndarray[object[3, 1]]) -> UnitInertia_TExpressionU: ...
    def ShiftToCenterOfMass(self, p_QBcm_E: numpy.ndarray[object[3, 1]]) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def SolidBox(Lx: pydrake.symbolic.Expression, Ly: pydrake.symbolic.Expression, Lz: pydrake.symbolic.Expression) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def SolidCapsule(radius: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def SolidCube(L: pydrake.symbolic.Expression) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def SolidCylinder(radius: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def SolidCylinderAboutEnd(radius: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def SolidEllipsoid(a: pydrake.symbolic.Expression, b: pydrake.symbolic.Expression, c: pydrake.symbolic.Expression) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def SolidSphere(r: pydrake.symbolic.Expression) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def StraightLine(moment_perpendicular: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def ThinRod(length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def TriaxiallySymmetric(I_triaxial: pydrake.symbolic.Expression) -> UnitInertia_TExpressionU: ...
    def __copy__(self) -> UnitInertia_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> UnitInertia_TExpressionU: ...

class UniversalJoint(Joint):
    kTypeName: ClassVar[str] = ...  # read-only
    def __init__(self, name: str, frame_on_parent: Frame, frame_on_child: Frame, damping: float = ...) -> None: ...
    def default_damping(self) -> float: ...
    def get_angles(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    def get_angular_rates(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    def get_default_angles(self) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    def set_angles(self, context: pydrake.systems.framework.Context, angles: numpy.ndarray[numpy.float64[2, 1]]) -> UniversalJoint: ...
    def set_angular_rates(self, context: pydrake.systems.framework.Context, theta_dot: numpy.ndarray[numpy.float64[2, 1]]) -> UniversalJoint: ...
    def set_default_angles(self, angles: numpy.ndarray[numpy.float64[2, 1]]) -> None: ...
    def set_random_angles_distribution(self, angles: numpy.ndarray[object[2, 1]]) -> None: ...

class UniversalJoint_𝓣AutoDiffXd𝓤(Joint_TAutoDiffXdU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TAutoDiffXdU, frame_on_child: Frame_TAutoDiffXdU, damping: float = ...) -> None: ...
    def default_damping(self) -> float: ...
    def get_angles(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[2, 1]]: ...
    def get_angular_rates(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[2, 1]]: ...
    def get_default_angles(self) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    def set_angles(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, angles: numpy.ndarray[object[2, 1]]) -> UniversalJoint_TAutoDiffXdU: ...
    def set_angular_rates(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, theta_dot: numpy.ndarray[object[2, 1]]) -> UniversalJoint_TAutoDiffXdU: ...
    def set_default_angles(self, angles: numpy.ndarray[numpy.float64[2, 1]]) -> None: ...
    def set_random_angles_distribution(self, angles: numpy.ndarray[object[2, 1]]) -> None: ...

class UniversalJoint_𝓣Expression𝓤(Joint_TExpressionU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TExpressionU, frame_on_child: Frame_TExpressionU, damping: float = ...) -> None: ...
    def default_damping(self) -> float: ...
    def get_angles(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[2, 1]]: ...
    def get_angular_rates(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[2, 1]]: ...
    def get_default_angles(self) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    def set_angles(self, context: pydrake.systems.framework.Context_TExpressionU, angles: numpy.ndarray[object[2, 1]]) -> UniversalJoint_TExpressionU: ...
    def set_angular_rates(self, context: pydrake.systems.framework.Context_TExpressionU, theta_dot: numpy.ndarray[object[2, 1]]) -> UniversalJoint_TExpressionU: ...
    def set_default_angles(self, angles: numpy.ndarray[numpy.float64[2, 1]]) -> None: ...
    def set_random_angles_distribution(self, angles: numpy.ndarray[object[2, 1]]) -> None: ...

class WeldJoint(Joint):
    kTypeName: ClassVar[str] = ...  # read-only
    def __init__(self, name: str, frame_on_parent_F: Frame, frame_on_child_M: Frame, X_FM: pydrake.math.RigidTransform) -> None: ...
    def X_FM(self) -> pydrake.math.RigidTransform: ...

class WeldJoint_𝓣AutoDiffXd𝓤(Joint_TAutoDiffXdU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent_F: Frame_TAutoDiffXdU, frame_on_child_M: Frame_TAutoDiffXdU, X_FM: pydrake.math.RigidTransform) -> None: ...
    def X_FM(self) -> pydrake.math.RigidTransform: ...

class WeldJoint_𝓣Expression𝓤(Joint_TExpressionU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent_F: Frame_TExpressionU, frame_on_child_M: Frame_TExpressionU, X_FM: pydrake.math.RigidTransform) -> None: ...
    def X_FM(self) -> pydrake.math.RigidTransform: ...

class _TemporaryName_N5drake9multibody10ScrewJointIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Joint_TAutoDiffXdU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TAutoDiffXdU, frame_on_child: Frame_TAutoDiffXdU, screw_pitch: float, damping: float) -> None: ...
    def GetDamping(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def SetDamping(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, damping: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def default_damping(self) -> float: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_default_rotation(self) -> float: ...
    def get_default_translation(self) -> float: ...
    def get_rotation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def screw_pitch(self) -> float: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, theta_dot: pydrake.autodiffutils.AutoDiffXd) -> ScrewJoint_TAutoDiffXdU: ...
    def set_default_rotation(self, theta: float) -> None: ...
    def set_default_translation(self, z: float) -> None: ...
    def set_random_pose_distribution(self, theta: numpy.ndarray[object[1, 1]]) -> None: ...
    def set_translation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, translation: pydrake.autodiffutils.AutoDiffXd) -> ScrewJoint_TAutoDiffXdU: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, translation_dot: pydrake.autodiffutils.AutoDiffXd) -> ScrewJoint_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody10ScrewJointINS_8symbolic10ExpressionEEE(Joint_TExpressionU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TExpressionU, frame_on_child: Frame_TExpressionU, screw_pitch: float, damping: float) -> None: ...
    def GetDamping(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def SetDamping(self, context: pydrake.systems.framework.Context_TExpressionU, damping: pydrake.symbolic.Expression) -> None: ...
    def default_damping(self) -> float: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_default_rotation(self) -> float: ...
    def get_default_translation(self) -> float: ...
    def get_rotation(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def screw_pitch(self) -> float: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU, theta_dot: pydrake.symbolic.Expression) -> ScrewJoint_TExpressionU: ...
    def set_default_rotation(self, theta: float) -> None: ...
    def set_default_translation(self, z: float) -> None: ...
    def set_random_pose_distribution(self, theta: numpy.ndarray[object[1, 1]]) -> None: ...
    def set_translation(self, context: pydrake.systems.framework.Context_TExpressionU, translation: pydrake.symbolic.Expression) -> ScrewJoint_TExpressionU: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context_TExpressionU, translation_dot: pydrake.symbolic.Expression) -> ScrewJoint_TExpressionU: ...

class _TemporaryName_N5drake9multibody11PlanarJointIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Joint_TAutoDiffXdU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TAutoDiffXdU, frame_on_child: Frame_TAutoDiffXdU, damping: numpy.ndarray[numpy.float64[3, 1]] = ...) -> None: ...
    def default_damping(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_default_rotation(self) -> float: ...
    def get_default_translation(self) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    def get_rotation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[2, 1]]: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[2, 1]]: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, theta_dot: pydrake.autodiffutils.AutoDiffXd) -> PlanarJoint_TAutoDiffXdU: ...
    def set_default_pose(self, p_FoMo_F: numpy.ndarray[numpy.float64[2, 1]], theta: float) -> None: ...
    def set_default_rotation(self, theta: float) -> None: ...
    def set_default_translation(self, p_FoMo_F: numpy.ndarray[numpy.float64[2, 1]]) -> None: ...
    def set_pose(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, p_FoMo_F: numpy.ndarray[object[2, 1]], theta: pydrake.autodiffutils.AutoDiffXd) -> PlanarJoint_TAutoDiffXdU: ...
    def set_random_pose_distribution(self, p_FoMo_F: numpy.ndarray[object[2, 1]], theta: pydrake.symbolic.Expression) -> None: ...
    def set_rotation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, theta: pydrake.autodiffutils.AutoDiffXd) -> PlanarJoint_TAutoDiffXdU: ...
    def set_translation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, p_FoMo_F: numpy.ndarray[object[2, 1]]) -> PlanarJoint_TAutoDiffXdU: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, v_FoMo_F: numpy.ndarray[object[2, 1]]) -> PlanarJoint_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody11PlanarJointINS_8symbolic10ExpressionEEE(Joint_TExpressionU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TExpressionU, frame_on_child: Frame_TExpressionU, damping: numpy.ndarray[numpy.float64[3, 1]] = ...) -> None: ...
    def default_damping(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_default_rotation(self) -> float: ...
    def get_default_translation(self) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    def get_rotation(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[2, 1]]: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[2, 1]]: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU, theta_dot: pydrake.symbolic.Expression) -> PlanarJoint_TExpressionU: ...
    def set_default_pose(self, p_FoMo_F: numpy.ndarray[numpy.float64[2, 1]], theta: float) -> None: ...
    def set_default_rotation(self, theta: float) -> None: ...
    def set_default_translation(self, p_FoMo_F: numpy.ndarray[numpy.float64[2, 1]]) -> None: ...
    def set_pose(self, context: pydrake.systems.framework.Context_TExpressionU, p_FoMo_F: numpy.ndarray[object[2, 1]], theta: pydrake.symbolic.Expression) -> PlanarJoint_TExpressionU: ...
    def set_random_pose_distribution(self, p_FoMo_F: numpy.ndarray[object[2, 1]], theta: pydrake.symbolic.Expression) -> None: ...
    def set_rotation(self, context: pydrake.systems.framework.Context_TExpressionU, theta: pydrake.symbolic.Expression) -> PlanarJoint_TExpressionU: ...
    def set_translation(self, context: pydrake.systems.framework.Context_TExpressionU, p_FoMo_F: numpy.ndarray[object[2, 1]]) -> PlanarJoint_TExpressionU: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context_TExpressionU, v_FoMo_F: numpy.ndarray[object[2, 1]]) -> PlanarJoint_TExpressionU: ...

class _TemporaryName_N5drake9multibody11UnitInertiaIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(RotationalInertia_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Ixx: pydrake.autodiffutils.AutoDiffXd, Iyy: pydrake.autodiffutils.AutoDiffXd, Izz: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    @overload
    def __init__(self, Ixx: pydrake.autodiffutils.AutoDiffXd, Iyy: pydrake.autodiffutils.AutoDiffXd, Izz: pydrake.autodiffutils.AutoDiffXd, Ixy: pydrake.autodiffutils.AutoDiffXd, Ixz: pydrake.autodiffutils.AutoDiffXd, Iyz: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    @overload
    def __init__(self, I: RotationalInertia_TAutoDiffXdU) -> None: ...
    @staticmethod
    def AxiallySymmetric(moment_parallel: pydrake.autodiffutils.AutoDiffXd, moment_perpendicular: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def HollowSphere(r: pydrake.autodiffutils.AutoDiffXd) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def PointMass(p_FQ: numpy.ndarray[object[3, 1]]) -> UnitInertia_TAutoDiffXdU: ...
    def ReExpress(self, R_AE: pydrake.math.RotationMatrix_TAutoDiffXdU) -> UnitInertia_TAutoDiffXdU: ...
    def SetFromRotationalInertia(self, I: RotationalInertia_TAutoDiffXdU, mass: pydrake.autodiffutils.AutoDiffXd) -> UnitInertia_TAutoDiffXdU: ...
    def ShiftFromCenterOfMass(self, p_BcmQ_E: numpy.ndarray[object[3, 1]]) -> UnitInertia_TAutoDiffXdU: ...
    def ShiftToCenterOfMass(self, p_QBcm_E: numpy.ndarray[object[3, 1]]) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidBox(Lx: pydrake.autodiffutils.AutoDiffXd, Ly: pydrake.autodiffutils.AutoDiffXd, Lz: pydrake.autodiffutils.AutoDiffXd) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCapsule(radius: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCube(L: pydrake.autodiffutils.AutoDiffXd) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCylinder(radius: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCylinderAboutEnd(radius: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidEllipsoid(a: pydrake.autodiffutils.AutoDiffXd, b: pydrake.autodiffutils.AutoDiffXd, c: pydrake.autodiffutils.AutoDiffXd) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidSphere(r: pydrake.autodiffutils.AutoDiffXd) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def StraightLine(moment_perpendicular: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def ThinRod(length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TAutoDiffXdU: ...
    @staticmethod
    def TriaxiallySymmetric(I_triaxial: pydrake.autodiffutils.AutoDiffXd) -> UnitInertia_TAutoDiffXdU: ...
    def __copy__(self) -> UnitInertia_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> UnitInertia_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody11UnitInertiaINS_8symbolic10ExpressionEEE(RotationalInertia_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Ixx: pydrake.symbolic.Expression, Iyy: pydrake.symbolic.Expression, Izz: pydrake.symbolic.Expression) -> None: ...
    @overload
    def __init__(self, Ixx: pydrake.symbolic.Expression, Iyy: pydrake.symbolic.Expression, Izz: pydrake.symbolic.Expression, Ixy: pydrake.symbolic.Expression, Ixz: pydrake.symbolic.Expression, Iyz: pydrake.symbolic.Expression) -> None: ...
    @overload
    def __init__(self, I: RotationalInertia_TExpressionU) -> None: ...
    @staticmethod
    def AxiallySymmetric(moment_parallel: pydrake.symbolic.Expression, moment_perpendicular: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def HollowSphere(r: pydrake.symbolic.Expression) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def PointMass(p_FQ: numpy.ndarray[object[3, 1]]) -> UnitInertia_TExpressionU: ...
    def ReExpress(self, R_AE: pydrake.math.RotationMatrix_TExpressionU) -> UnitInertia_TExpressionU: ...
    def SetFromRotationalInertia(self, I: RotationalInertia_TExpressionU, mass: pydrake.symbolic.Expression) -> UnitInertia_TExpressionU: ...
    def ShiftFromCenterOfMass(self, p_BcmQ_E: numpy.ndarray[object[3, 1]]) -> UnitInertia_TExpressionU: ...
    def ShiftToCenterOfMass(self, p_QBcm_E: numpy.ndarray[object[3, 1]]) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def SolidBox(Lx: pydrake.symbolic.Expression, Ly: pydrake.symbolic.Expression, Lz: pydrake.symbolic.Expression) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def SolidCapsule(radius: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def SolidCube(L: pydrake.symbolic.Expression) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def SolidCylinder(radius: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def SolidCylinderAboutEnd(radius: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def SolidEllipsoid(a: pydrake.symbolic.Expression, b: pydrake.symbolic.Expression, c: pydrake.symbolic.Expression) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def SolidSphere(r: pydrake.symbolic.Expression) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def StraightLine(moment_perpendicular: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def ThinRod(length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> UnitInertia_TExpressionU: ...
    @staticmethod
    def TriaxiallySymmetric(I_triaxial: pydrake.symbolic.Expression) -> UnitInertia_TExpressionU: ...
    def __copy__(self) -> UnitInertia_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> UnitInertia_TExpressionU: ...

class _TemporaryName_N5drake9multibody12BallRpyJointIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Joint_TAutoDiffXdU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TAutoDiffXdU, frame_on_child: Frame_TAutoDiffXdU, damping: float = ...) -> None: ...
    def default_damping(self) -> float: ...
    def get_angles(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def get_default_angles(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def set_angles(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, angles: numpy.ndarray[object[3, 1]]) -> BallRpyJoint_TAutoDiffXdU: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, w_FM: numpy.ndarray[object[3, 1]]) -> BallRpyJoint_TAutoDiffXdU: ...
    def set_default_angles(self, angles: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_random_angles_distribution(self, angles: numpy.ndarray[object[3, 1]]) -> None: ...

class _TemporaryName_N5drake9multibody12BallRpyJointINS_8symbolic10ExpressionEEE(Joint_TExpressionU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TExpressionU, frame_on_child: Frame_TExpressionU, damping: float = ...) -> None: ...
    def default_damping(self) -> float: ...
    def get_angles(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def get_default_angles(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def set_angles(self, context: pydrake.systems.framework.Context_TExpressionU, angles: numpy.ndarray[object[3, 1]]) -> BallRpyJoint_TExpressionU: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU, w_FM: numpy.ndarray[object[3, 1]]) -> BallRpyJoint_TExpressionU: ...
    def set_default_angles(self, angles: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_random_angles_distribution(self, angles: numpy.ndarray[object[3, 1]]) -> None: ...

class _TemporaryName_N5drake9multibody12ForceElementIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def index(self) -> ForceElementIndex: ...
    def is_ephemeral(self) -> bool: ...
    def model_instance(self) -> ModelInstanceIndex: ...

class _TemporaryName_N5drake9multibody12ForceElementINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def index(self) -> ForceElementIndex: ...
    def is_ephemeral(self) -> bool: ...
    def model_instance(self) -> ModelInstanceIndex: ...

class _TemporaryName_N5drake9multibody13JointActuatorIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def SetGearRatio(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, gear_ratio: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def SetRotorInertia(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, rotor_inertia: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def calc_reflected_inertia(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def default_gear_ratio(self) -> float: ...
    def default_reflected_inertia(self) -> float: ...
    def default_rotor_inertia(self) -> float: ...
    def effort_limit(self) -> float: ...
    def gear_ratio(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_actuation_vector(self, u: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    def get_controller_gains(self) -> PdControllerGains: ...
    def has_controller(self) -> bool: ...
    def index(self) -> JointActuatorIndex: ...
    def input_start(self) -> int: ...
    def is_ephemeral(self) -> bool: ...
    def joint(self) -> Joint_TAutoDiffXdU: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def num_inputs(self) -> int: ...
    def rotor_inertia(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def set_actuation_vector(self, u_actuator: numpy.ndarray[object[m, 1]], u: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    def set_controller_gains(self, gains: PdControllerGains) -> None: ...
    def set_default_gear_ratio(self, gear_ratio: float) -> None: ...
    def set_default_rotor_inertia(self, rotor_inertia: float) -> None: ...

class _TemporaryName_N5drake9multibody13JointActuatorINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def SetGearRatio(self, context: pydrake.systems.framework.Context_TExpressionU, gear_ratio: pydrake.symbolic.Expression) -> None: ...
    def SetRotorInertia(self, context: pydrake.systems.framework.Context_TExpressionU, rotor_inertia: pydrake.symbolic.Expression) -> None: ...
    def calc_reflected_inertia(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def default_gear_ratio(self) -> float: ...
    def default_reflected_inertia(self) -> float: ...
    def default_rotor_inertia(self) -> float: ...
    def effort_limit(self) -> float: ...
    def gear_ratio(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_actuation_vector(self, u: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    def get_controller_gains(self) -> PdControllerGains: ...
    def has_controller(self) -> bool: ...
    def index(self) -> JointActuatorIndex: ...
    def input_start(self) -> int: ...
    def is_ephemeral(self) -> bool: ...
    def joint(self) -> Joint_TExpressionU: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def num_inputs(self) -> int: ...
    def rotor_inertia(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def set_actuation_vector(self, u_actuator: numpy.ndarray[object[m, 1]], u: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    def set_controller_gains(self, gains: PdControllerGains) -> None: ...
    def set_default_gear_ratio(self, gear_ratio: float) -> None: ...
    def set_default_rotor_inertia(self, rotor_inertia: float) -> None: ...

class _TemporaryName_N5drake9multibody13RevoluteJointIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Joint_TAutoDiffXdU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TAutoDiffXdU, frame_on_child: Frame_TAutoDiffXdU, axis: numpy.ndarray[numpy.float64[3, 1]], damping: float = ...) -> None: ...
    def GetDamping(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def SetDamping(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, damping: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def acceleration_lower_limit(self) -> float: ...
    def acceleration_upper_limit(self) -> float: ...
    def default_damping(self) -> float: ...
    def get_angle(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_angular_rate(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_default_angle(self) -> float: ...
    def position_lower_limit(self) -> float: ...
    def position_upper_limit(self) -> float: ...
    def revolute_axis(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def set_angle(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, angle: pydrake.autodiffutils.AutoDiffXd) -> RevoluteJoint_TAutoDiffXdU: ...
    def set_angular_rate(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, angle: pydrake.autodiffutils.AutoDiffXd) -> RevoluteJoint_TAutoDiffXdU: ...
    def set_default_angle(self, angle: float) -> None: ...
    def set_default_damping(self, damping: float) -> None: ...
    def set_random_angle_distribution(self, angle: pydrake.symbolic.Expression) -> None: ...
    def velocity_lower_limit(self) -> float: ...
    def velocity_upper_limit(self) -> float: ...

class _TemporaryName_N5drake9multibody13RevoluteJointINS_8symbolic10ExpressionEEE(Joint_TExpressionU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TExpressionU, frame_on_child: Frame_TExpressionU, axis: numpy.ndarray[numpy.float64[3, 1]], damping: float = ...) -> None: ...
    def GetDamping(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def SetDamping(self, context: pydrake.systems.framework.Context_TExpressionU, damping: pydrake.symbolic.Expression) -> None: ...
    def acceleration_lower_limit(self) -> float: ...
    def acceleration_upper_limit(self) -> float: ...
    def default_damping(self) -> float: ...
    def get_angle(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_angular_rate(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_default_angle(self) -> float: ...
    def position_lower_limit(self) -> float: ...
    def position_upper_limit(self) -> float: ...
    def revolute_axis(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def set_angle(self, context: pydrake.systems.framework.Context_TExpressionU, angle: pydrake.symbolic.Expression) -> RevoluteJoint_TExpressionU: ...
    def set_angular_rate(self, context: pydrake.systems.framework.Context_TExpressionU, angle: pydrake.symbolic.Expression) -> RevoluteJoint_TExpressionU: ...
    def set_default_angle(self, angle: float) -> None: ...
    def set_default_damping(self, damping: float) -> None: ...
    def set_random_angle_distribution(self, angle: pydrake.symbolic.Expression) -> None: ...
    def velocity_lower_limit(self) -> float: ...
    def velocity_upper_limit(self) -> float: ...

class _TemporaryName_N5drake9multibody14PrismaticJointIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Joint_TAutoDiffXdU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TAutoDiffXdU, frame_on_child: Frame_TAutoDiffXdU, axis: numpy.ndarray[numpy.float64[3, 1]], pos_lower_limit: float = ..., pos_upper_limit: float = ..., damping: float = ...) -> None: ...
    def GetDamping(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def SetDamping(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, damping: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def acceleration_lower_limit(self) -> float: ...
    def acceleration_upper_limit(self) -> float: ...
    def default_damping(self) -> float: ...
    def get_default_translation(self) -> float: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_translation_rate(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def position_lower_limit(self) -> float: ...
    def position_upper_limit(self) -> float: ...
    def set_default_damping(self, damping: float) -> None: ...
    def set_default_translation(self, translation: float) -> None: ...
    def set_random_translation_distribution(self, translation: pydrake.symbolic.Expression) -> None: ...
    def set_translation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, translation: pydrake.autodiffutils.AutoDiffXd) -> PrismaticJoint_TAutoDiffXdU: ...
    def set_translation_rate(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, translation_dot: pydrake.autodiffutils.AutoDiffXd) -> PrismaticJoint_TAutoDiffXdU: ...
    def translation_axis(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def velocity_lower_limit(self) -> float: ...
    def velocity_upper_limit(self) -> float: ...

class _TemporaryName_N5drake9multibody14PrismaticJointINS_8symbolic10ExpressionEEE(Joint_TExpressionU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TExpressionU, frame_on_child: Frame_TExpressionU, axis: numpy.ndarray[numpy.float64[3, 1]], pos_lower_limit: float = ..., pos_upper_limit: float = ..., damping: float = ...) -> None: ...
    def GetDamping(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def SetDamping(self, context: pydrake.systems.framework.Context_TExpressionU, damping: pydrake.symbolic.Expression) -> None: ...
    def acceleration_lower_limit(self) -> float: ...
    def acceleration_upper_limit(self) -> float: ...
    def default_damping(self) -> float: ...
    def get_default_translation(self) -> float: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_translation_rate(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def position_lower_limit(self) -> float: ...
    def position_upper_limit(self) -> float: ...
    def set_default_damping(self, damping: float) -> None: ...
    def set_default_translation(self, translation: float) -> None: ...
    def set_random_translation_distribution(self, translation: pydrake.symbolic.Expression) -> None: ...
    def set_translation(self, context: pydrake.systems.framework.Context_TExpressionU, translation: pydrake.symbolic.Expression) -> PrismaticJoint_TExpressionU: ...
    def set_translation_rate(self, context: pydrake.systems.framework.Context_TExpressionU, translation_dot: pydrake.symbolic.Expression) -> PrismaticJoint_TExpressionU: ...
    def translation_axis(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def velocity_lower_limit(self) -> float: ...
    def velocity_upper_limit(self) -> float: ...

class _TemporaryName_N5drake9multibody14RevoluteSpringIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(ForceElement_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, joint: RevoluteJoint_TAutoDiffXdU, nominal_angle: float, stiffness: float) -> None: ...
    def GetNominalAngle(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def GetStiffness(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def SetNominalAngle(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, nominal_angle: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def SetStiffness(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, stiffness: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def default_nominal_angle(self) -> float: ...
    def default_stiffness(self) -> float: ...
    def joint(self) -> RevoluteJoint_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody14RevoluteSpringINS_8symbolic10ExpressionEEE(ForceElement_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, joint: RevoluteJoint_TExpressionU, nominal_angle: float, stiffness: float) -> None: ...
    def GetNominalAngle(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def GetStiffness(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def SetNominalAngle(self, context: pydrake.systems.framework.Context_TExpressionU, nominal_angle: pydrake.symbolic.Expression) -> None: ...
    def SetStiffness(self, context: pydrake.systems.framework.Context_TExpressionU, stiffness: pydrake.symbolic.Expression) -> None: ...
    def default_nominal_angle(self) -> float: ...
    def default_stiffness(self) -> float: ...
    def joint(self) -> RevoluteJoint_TExpressionU: ...

class _TemporaryName_N5drake9multibody14RigidBodyFrameIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Frame_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake9multibody14RigidBodyFrameINS_8symbolic10ExpressionEEE(Frame_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake9multibody14SpatialInertiaIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, mass: pydrake.autodiffutils.AutoDiffXd, p_PScm_E: numpy.ndarray[object[3, 1]], G_SP_E: UnitInertia_TAutoDiffXdU, skip_validity_check: bool = ...) -> None: ...
    def CalcComMoment(self) -> numpy.ndarray[object[3, 1]]: ...
    def CalcPrincipalSemiDiametersAndPoseForSolidEllipsoid(self) -> tuple[numpy.ndarray[numpy.float64[3, 1]], pydrake.math.RigidTransform]: ...
    def CalcRotationalInertia(self) -> RotationalInertia_TAutoDiffXdU: ...
    def CopyToFullMatrix6(self) -> numpy.ndarray[object[6, 6]]: ...
    @staticmethod
    def HollowSphereWithDensity(area_density: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def HollowSphereWithMass(mass: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd) -> SpatialInertia_TAutoDiffXdU: ...
    def IsNaN(self) -> bool: ...
    def IsPhysicallyValid(self) -> bool: ...
    def IsZero(self) -> bool: ...
    @staticmethod
    def MakeFromCentralInertia(mass: pydrake.autodiffutils.AutoDiffXd, p_PScm_E: numpy.ndarray[object[3, 1]], I_SScm_E: RotationalInertia_TAutoDiffXdU) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def NaN() -> SpatialInertia_TAutoDiffXdU: ...
    def ReExpress(self, R_AE: pydrake.math.RotationMatrix_TAutoDiffXdU) -> SpatialInertia_TAutoDiffXdU: ...
    def SetNaN(self) -> None: ...
    def Shift(self, p_PQ_E: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidBoxWithDensity(density: pydrake.autodiffutils.AutoDiffXd, lx: pydrake.autodiffutils.AutoDiffXd, ly: pydrake.autodiffutils.AutoDiffXd, lz: pydrake.autodiffutils.AutoDiffXd) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidBoxWithMass(mass: pydrake.autodiffutils.AutoDiffXd, lx: pydrake.autodiffutils.AutoDiffXd, ly: pydrake.autodiffutils.AutoDiffXd, lz: pydrake.autodiffutils.AutoDiffXd) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCapsuleWithDensity(density: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCapsuleWithMass(mass: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCubeWithDensity(density: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCylinderWithDensity(density: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCylinderWithDensityAboutEnd(density: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCylinderWithMass(mass: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidCylinderWithMassAboutEnd(mass: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidEllipsoidWithDensity(density: pydrake.autodiffutils.AutoDiffXd, a: pydrake.autodiffutils.AutoDiffXd, b: pydrake.autodiffutils.AutoDiffXd, c: pydrake.autodiffutils.AutoDiffXd) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidEllipsoidWithMass(mass: pydrake.autodiffutils.AutoDiffXd, a: pydrake.autodiffutils.AutoDiffXd, b: pydrake.autodiffutils.AutoDiffXd, c: pydrake.autodiffutils.AutoDiffXd) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidSphereWithDensity(density: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def SolidSphereWithMass(mass: pydrake.autodiffutils.AutoDiffXd, radius: pydrake.autodiffutils.AutoDiffXd) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def ThinRodWithMass(mass: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def ThinRodWithMassAboutEnd(mass: pydrake.autodiffutils.AutoDiffXd, length: pydrake.autodiffutils.AutoDiffXd, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TAutoDiffXdU: ...
    @staticmethod
    def Zero() -> SpatialInertia_TAutoDiffXdU: ...
    def get_com(self) -> numpy.ndarray[object[3, 1]]: ...
    def get_mass(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_unit_inertia(self) -> UnitInertia_TAutoDiffXdU: ...
    def __copy__(self) -> SpatialInertia_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialInertia_TAutoDiffXdU: ...
    def __iadd__(self, arg0: SpatialInertia_TAutoDiffXdU) -> SpatialInertia_TAutoDiffXdU: ...
    @overload
    def __mul__(self, arg0: pydrake.multibody.math.SpatialAcceleration_TAutoDiffXdU) -> pydrake.multibody.math.SpatialForce_TAutoDiffXdU: ...
    @overload
    def __mul__(self, arg0: pydrake.multibody.math.SpatialVelocity_TAutoDiffXdU) -> pydrake.multibody.math.SpatialMomentum_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody14SpatialInertiaINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, mass: pydrake.symbolic.Expression, p_PScm_E: numpy.ndarray[object[3, 1]], G_SP_E: UnitInertia_TExpressionU, skip_validity_check: bool = ...) -> None: ...
    def CalcComMoment(self) -> numpy.ndarray[object[3, 1]]: ...
    def CalcPrincipalSemiDiametersAndPoseForSolidEllipsoid(self) -> tuple[numpy.ndarray[numpy.float64[3, 1]], pydrake.math.RigidTransform]: ...
    def CalcRotationalInertia(self) -> RotationalInertia_TExpressionU: ...
    def CopyToFullMatrix6(self) -> numpy.ndarray[object[6, 6]]: ...
    @staticmethod
    def HollowSphereWithDensity(area_density: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def HollowSphereWithMass(mass: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression) -> SpatialInertia_TExpressionU: ...
    def IsNaN(self) -> pydrake.symbolic.Formula: ...
    def IsPhysicallyValid(self) -> pydrake.symbolic.Formula: ...
    def IsZero(self) -> pydrake.symbolic.Formula: ...
    @staticmethod
    def MakeFromCentralInertia(mass: pydrake.symbolic.Expression, p_PScm_E: numpy.ndarray[object[3, 1]], I_SScm_E: RotationalInertia_TExpressionU) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def NaN() -> SpatialInertia_TExpressionU: ...
    def ReExpress(self, R_AE: pydrake.math.RotationMatrix_TExpressionU) -> SpatialInertia_TExpressionU: ...
    def SetNaN(self) -> None: ...
    def Shift(self, p_PQ_E: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidBoxWithDensity(density: pydrake.symbolic.Expression, lx: pydrake.symbolic.Expression, ly: pydrake.symbolic.Expression, lz: pydrake.symbolic.Expression) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidBoxWithMass(mass: pydrake.symbolic.Expression, lx: pydrake.symbolic.Expression, ly: pydrake.symbolic.Expression, lz: pydrake.symbolic.Expression) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidCapsuleWithDensity(density: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidCapsuleWithMass(mass: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidCubeWithDensity(density: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidCylinderWithDensity(density: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidCylinderWithDensityAboutEnd(density: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidCylinderWithMass(mass: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidCylinderWithMassAboutEnd(mass: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidEllipsoidWithDensity(density: pydrake.symbolic.Expression, a: pydrake.symbolic.Expression, b: pydrake.symbolic.Expression, c: pydrake.symbolic.Expression) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidEllipsoidWithMass(mass: pydrake.symbolic.Expression, a: pydrake.symbolic.Expression, b: pydrake.symbolic.Expression, c: pydrake.symbolic.Expression) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidSphereWithDensity(density: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def SolidSphereWithMass(mass: pydrake.symbolic.Expression, radius: pydrake.symbolic.Expression) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def ThinRodWithMass(mass: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def ThinRodWithMassAboutEnd(mass: pydrake.symbolic.Expression, length: pydrake.symbolic.Expression, unit_vector: numpy.ndarray[object[3, 1]]) -> SpatialInertia_TExpressionU: ...
    @staticmethod
    def Zero() -> SpatialInertia_TExpressionU: ...
    def get_com(self) -> numpy.ndarray[object[3, 1]]: ...
    def get_mass(self) -> pydrake.symbolic.Expression: ...
    def get_unit_inertia(self) -> UnitInertia_TExpressionU: ...
    def __copy__(self) -> SpatialInertia_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialInertia_TExpressionU: ...
    def __iadd__(self, arg0: SpatialInertia_TExpressionU) -> SpatialInertia_TExpressionU: ...
    @overload
    def __mul__(self, arg0: pydrake.multibody.math.SpatialAcceleration_TExpressionU) -> pydrake.multibody.math.SpatialForce_TExpressionU: ...
    @overload
    def __mul__(self, arg0: pydrake.multibody.math.SpatialVelocity_TExpressionU) -> pydrake.multibody.math.SpatialMomentum_TExpressionU: ...

class _TemporaryName_N5drake9multibody14UniversalJointIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Joint_TAutoDiffXdU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TAutoDiffXdU, frame_on_child: Frame_TAutoDiffXdU, damping: float = ...) -> None: ...
    def default_damping(self) -> float: ...
    def get_angles(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[2, 1]]: ...
    def get_angular_rates(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[2, 1]]: ...
    def get_default_angles(self) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    def set_angles(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, angles: numpy.ndarray[object[2, 1]]) -> UniversalJoint_TAutoDiffXdU: ...
    def set_angular_rates(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, theta_dot: numpy.ndarray[object[2, 1]]) -> UniversalJoint_TAutoDiffXdU: ...
    def set_default_angles(self, angles: numpy.ndarray[numpy.float64[2, 1]]) -> None: ...
    def set_random_angles_distribution(self, angles: numpy.ndarray[object[2, 1]]) -> None: ...

class _TemporaryName_N5drake9multibody14UniversalJointINS_8symbolic10ExpressionEEE(Joint_TExpressionU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TExpressionU, frame_on_child: Frame_TExpressionU, damping: float = ...) -> None: ...
    def default_damping(self) -> float: ...
    def get_angles(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[2, 1]]: ...
    def get_angular_rates(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[2, 1]]: ...
    def get_default_angles(self) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    def set_angles(self, context: pydrake.systems.framework.Context_TExpressionU, angles: numpy.ndarray[object[2, 1]]) -> UniversalJoint_TExpressionU: ...
    def set_angular_rates(self, context: pydrake.systems.framework.Context_TExpressionU, theta_dot: numpy.ndarray[object[2, 1]]) -> UniversalJoint_TExpressionU: ...
    def set_default_angles(self, angles: numpy.ndarray[numpy.float64[2, 1]]) -> None: ...
    def set_random_angles_distribution(self, angles: numpy.ndarray[object[2, 1]]) -> None: ...

class _TemporaryName_N5drake9multibody15MultibodyForcesIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, nb: int, nv: int) -> None: ...
    def AddInForces(self, addend: MultibodyForces_TAutoDiffXdU) -> None: ...
    def SetZero(self) -> MultibodyForces_TAutoDiffXdU: ...
    def generalized_forces(self) -> numpy.ndarray[object[m, 1]]: ...
    def mutable_generalized_forces(self) -> numpy.ndarray[object[m, 1]]: ...
    def num_bodies(self) -> int: ...
    def num_velocities(self) -> int: ...
    def __copy__(self) -> MultibodyForces_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> MultibodyForces_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody15MultibodyForcesINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, plant) -> None: ...
    @overload
    def __init__(self, nb: int, nv: int) -> None: ...
    def AddInForces(self, addend: MultibodyForces_TExpressionU) -> None: ...
    def SetZero(self) -> MultibodyForces_TExpressionU: ...
    def generalized_forces(self) -> numpy.ndarray[object[m, 1]]: ...
    def mutable_generalized_forces(self) -> numpy.ndarray[object[m, 1]]: ...
    def num_bodies(self) -> int: ...
    def num_velocities(self) -> int: ...
    def __copy__(self) -> MultibodyForces_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> MultibodyForces_TExpressionU: ...

class _TemporaryName_N5drake9multibody15PrismaticSpringIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(ForceElement_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, joint: PrismaticJoint_TAutoDiffXdU, nominal_position: float, stiffness: float) -> None: ...
    def joint(self) -> PrismaticJoint_TAutoDiffXdU: ...
    def nominal_position(self) -> float: ...
    def stiffness(self) -> float: ...

class _TemporaryName_N5drake9multibody15PrismaticSpringINS_8symbolic10ExpressionEEE(ForceElement_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, joint: PrismaticJoint_TExpressionU, nominal_position: float, stiffness: float) -> None: ...
    def joint(self) -> PrismaticJoint_TExpressionU: ...
    def nominal_position(self) -> float: ...
    def stiffness(self) -> float: ...

class _TemporaryName_N5drake9multibody16FixedOffsetFrameIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Frame_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, P: Frame_TAutoDiffXdU, X_PF: pydrake.math.RigidTransform, model_instance: ModelInstanceIndex | None = ...) -> None: ...
    def GetPoseInParentFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def SetPoseInParentFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, X_PF: pydrake.math.RigidTransform_TAutoDiffXdU) -> None: ...

class _TemporaryName_N5drake9multibody16FixedOffsetFrameINS_8symbolic10ExpressionEEE(Frame_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, name: str, P: Frame_TExpressionU, X_PF: pydrake.math.RigidTransform, model_instance: ModelInstanceIndex | None = ...) -> None: ...
    @overload
    def __init__(self, name: str, bodyB, X_BF: pydrake.math.RigidTransform) -> None: ...
    def GetPoseInParentFrame(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def SetPoseInParentFrame(self, context: pydrake.systems.framework.Context_TExpressionU, X_PF: pydrake.math.RigidTransform_TExpressionU) -> None: ...

class _TemporaryName_N5drake9multibody16RpyFloatingJointIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Joint_TAutoDiffXdU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TAutoDiffXdU, frame_on_child: Frame_TAutoDiffXdU, angular_damping: float = ..., translational_damping: float = ...) -> None: ...
    def GetPose(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def SetOrientation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, R_FM: pydrake.math.RotationMatrix_TAutoDiffXdU) -> RpyFloatingJoint_TAutoDiffXdU: ...
    def SetPose(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, X_FM: pydrake.math.RigidTransform_TAutoDiffXdU) -> RpyFloatingJoint_TAutoDiffXdU: ...
    def SetTranslation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, p_FM: numpy.ndarray[object[3, 1]]) -> RpyFloatingJoint_TAutoDiffXdU: ...
    def default_angular_damping(self) -> float: ...
    def default_translational_damping(self) -> float: ...
    def get_angles(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def get_default_angles(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_default_translation(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def set_angles(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, angles: numpy.ndarray[object[3, 1]]) -> RpyFloatingJoint_TAutoDiffXdU: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, w_FM: numpy.ndarray[object[3, 1]]) -> RpyFloatingJoint_TAutoDiffXdU: ...
    def set_default_angles(self, angles: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_default_translation(self, p_FM: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_random_angles_distribution(self, angles: numpy.ndarray[object[3, 1]]) -> None: ...
    def set_random_translation_distribution(self, p_FM: numpy.ndarray[object[3, 1]]) -> None: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, v_FM: numpy.ndarray[object[3, 1]]) -> RpyFloatingJoint_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody16RpyFloatingJointINS_8symbolic10ExpressionEEE(Joint_TExpressionU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TExpressionU, frame_on_child: Frame_TExpressionU, angular_damping: float = ..., translational_damping: float = ...) -> None: ...
    def GetPose(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def SetOrientation(self, context: pydrake.systems.framework.Context_TExpressionU, R_FM: pydrake.math.RotationMatrix_TExpressionU) -> RpyFloatingJoint_TExpressionU: ...
    def SetPose(self, context: pydrake.systems.framework.Context_TExpressionU, X_FM: pydrake.math.RigidTransform_TExpressionU) -> RpyFloatingJoint_TExpressionU: ...
    def SetTranslation(self, context: pydrake.systems.framework.Context_TExpressionU, p_FM: numpy.ndarray[object[3, 1]]) -> RpyFloatingJoint_TExpressionU: ...
    def default_angular_damping(self) -> float: ...
    def default_translational_damping(self) -> float: ...
    def get_angles(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def get_default_angles(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_default_translation(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def set_angles(self, context: pydrake.systems.framework.Context_TExpressionU, angles: numpy.ndarray[object[3, 1]]) -> RpyFloatingJoint_TExpressionU: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU, w_FM: numpy.ndarray[object[3, 1]]) -> RpyFloatingJoint_TExpressionU: ...
    def set_default_angles(self, angles: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_default_translation(self, p_FM: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_random_angles_distribution(self, angles: numpy.ndarray[object[3, 1]]) -> None: ...
    def set_random_translation_distribution(self, p_FM: numpy.ndarray[object[3, 1]]) -> None: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context_TExpressionU, v_FM: numpy.ndarray[object[3, 1]]) -> RpyFloatingJoint_TExpressionU: ...

class _TemporaryName_N5drake9multibody17ForceDensityFieldIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.multibody.fem.ForceDensityFieldBase_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, density_type: pydrake.multibody.fem.ForceDensityType = ...) -> None: ...
    @staticmethod
    def DeclareAbstractInputPort(*args, **kwargs): ...
    @staticmethod
    def DeclareCacheEntry(*args, **kwargs): ...
    @staticmethod
    def DeclareVectorInputPort(*args, **kwargs): ...
    def has_parent_system(self) -> bool: ...
    def parent_system_or_throw(self) -> pydrake.systems.framework.LeafSystem_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody17ForceDensityFieldINS_8symbolic10ExpressionEEE(pydrake.multibody.fem.ForceDensityFieldBase_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, density_type: pydrake.multibody.fem.ForceDensityType = ...) -> None: ...
    @staticmethod
    def DeclareAbstractInputPort(plant, name: str, model_value: pydrake.common.value.AbstractValue) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    @staticmethod
    def DeclareCacheEntry(plant, description: str, value_producer: pydrake.systems.framework.ValueProducer, prerequisites_of_calc: set[pydrake.systems.framework.DependencyTicket]) -> pydrake.systems.framework.CacheEntry: ...
    @staticmethod
    def DeclareVectorInputPort(plant, name: str, model_vector: pydrake.systems.framework.BasicVector_TExpressionU) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def has_parent_system(self) -> bool: ...
    def parent_system_or_throw(self) -> pydrake.systems.framework.LeafSystem_TExpressionU: ...

class _TemporaryName_N5drake9multibody17GravityForceFieldIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(ForceDensityField_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, gravity_vector: numpy.ndarray[object[3, 1]], mass_density: pydrake.autodiffutils.AutoDiffXd) -> None: ...

class _TemporaryName_N5drake9multibody17GravityForceFieldINS_8symbolic10ExpressionEEE(ForceDensityField_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, gravity_vector: numpy.ndarray[object[3, 1]], mass_density: pydrake.symbolic.Expression) -> None: ...

class _TemporaryName_N5drake9multibody17RotationalInertiaIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Ixx: pydrake.autodiffutils.AutoDiffXd, Iyy: pydrake.autodiffutils.AutoDiffXd, Izz: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    @overload
    def __init__(self, Ixx: pydrake.autodiffutils.AutoDiffXd, Iyy: pydrake.autodiffutils.AutoDiffXd, Izz: pydrake.autodiffutils.AutoDiffXd, Ixy: pydrake.autodiffutils.AutoDiffXd, Ixz: pydrake.autodiffutils.AutoDiffXd, Iyz: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    @overload
    def __init__(self, mass: pydrake.autodiffutils.AutoDiffXd, p_PQ_E: numpy.ndarray[object[3, 1]]) -> None: ...
    def CalcMaximumPossibleMomentOfInertia(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def CalcPrincipalMomentsAndAxesOfInertia(self) -> tuple[numpy.ndarray[numpy.float64[3, 1]], pydrake.math.RotationMatrix]: ...
    def CalcPrincipalMomentsOfInertia(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CopyToFullMatrix3(self) -> numpy.ndarray[object[3, 3]]: ...
    @overload
    def CouldBePhysicallyValid(self) -> bool: ...
    @overload
    def CouldBePhysicallyValid(self) -> Any: ...
    def IsNaN(self) -> bool: ...
    def IsNearlyEqualTo(self, other: RotationalInertia_TAutoDiffXdU, precision: float) -> bool: ...
    def IsZero(self) -> bool: ...
    def ReExpress(self, R_AE: pydrake.math.RotationMatrix_TAutoDiffXdU) -> RotationalInertia_TAutoDiffXdU: ...
    def SetToNaN(self) -> None: ...
    def SetZero(self) -> None: ...
    def ShiftFromCenterOfMass(self, mass: pydrake.autodiffutils.AutoDiffXd, p_BcmQ_E: numpy.ndarray[object[3, 1]]) -> RotationalInertia_TAutoDiffXdU: ...
    def ShiftToCenterOfMass(self, mass: pydrake.autodiffutils.AutoDiffXd, p_QBcm_E: numpy.ndarray[object[3, 1]]) -> RotationalInertia_TAutoDiffXdU: ...
    def ShiftToThenAwayFromCenterOfMass(self, mass: pydrake.autodiffutils.AutoDiffXd, p_PBcm_E: numpy.ndarray[object[3, 1]], p_QBcm_E: numpy.ndarray[object[3, 1]]) -> RotationalInertia_TAutoDiffXdU: ...
    def Trace(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    @staticmethod
    def TriaxiallySymmetric(I_triaxial: pydrake.autodiffutils.AutoDiffXd) -> RotationalInertia_TAutoDiffXdU: ...
    def cols(self) -> int: ...
    def get_moments(self) -> numpy.ndarray[object[3, 1]]: ...
    def get_products(self) -> numpy.ndarray[object[3, 1]]: ...
    def rows(self) -> int: ...
    def __add__(self, arg0: RotationalInertia_TAutoDiffXdU) -> RotationalInertia_TAutoDiffXdU: ...
    def __copy__(self) -> RotationalInertia_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> RotationalInertia_TAutoDiffXdU: ...
    def __getitem__(self, arg0: tuple) -> pydrake.autodiffutils.AutoDiffXd: ...
    def __iadd__(self, arg0: RotationalInertia_TAutoDiffXdU) -> RotationalInertia_TAutoDiffXdU: ...
    def __imul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> RotationalInertia_TAutoDiffXdU: ...
    def __isub__(self, arg0: RotationalInertia_TAutoDiffXdU) -> RotationalInertia_TAutoDiffXdU: ...
    def __itruediv__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> RotationalInertia_TAutoDiffXdU: ...
    @overload
    def __mul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> RotationalInertia_TAutoDiffXdU: ...
    @overload
    def __mul__(self, arg0: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def __rmul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> RotationalInertia_TAutoDiffXdU: ...
    def __sub__(self, arg0: RotationalInertia_TAutoDiffXdU) -> RotationalInertia_TAutoDiffXdU: ...
    def __truediv__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> RotationalInertia_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody17RotationalInertiaINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, Ixx: pydrake.symbolic.Expression, Iyy: pydrake.symbolic.Expression, Izz: pydrake.symbolic.Expression) -> None: ...
    @overload
    def __init__(self, Ixx: pydrake.symbolic.Expression, Iyy: pydrake.symbolic.Expression, Izz: pydrake.symbolic.Expression, Ixy: pydrake.symbolic.Expression, Ixz: pydrake.symbolic.Expression, Iyz: pydrake.symbolic.Expression) -> None: ...
    @overload
    def __init__(self, mass: pydrake.symbolic.Expression, p_PQ_E: numpy.ndarray[object[3, 1]]) -> None: ...
    def CalcMaximumPossibleMomentOfInertia(self) -> pydrake.symbolic.Expression: ...
    def CalcPrincipalMomentsAndAxesOfInertia(self) -> tuple[numpy.ndarray[numpy.float64[3, 1]], pydrake.math.RotationMatrix]: ...
    def CalcPrincipalMomentsOfInertia(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CopyToFullMatrix3(self) -> numpy.ndarray[object[3, 3]]: ...
    @overload
    def CouldBePhysicallyValid(self) -> pydrake.symbolic.Formula: ...
    @overload
    def CouldBePhysicallyValid(self) -> Any: ...
    def IsNaN(self) -> pydrake.symbolic.Formula: ...
    def IsNearlyEqualTo(self, other: RotationalInertia_TExpressionU, precision: float) -> pydrake.symbolic.Formula: ...
    def IsZero(self) -> pydrake.symbolic.Formula: ...
    def ReExpress(self, R_AE: pydrake.math.RotationMatrix_TExpressionU) -> RotationalInertia_TExpressionU: ...
    def SetToNaN(self) -> None: ...
    def SetZero(self) -> None: ...
    def ShiftFromCenterOfMass(self, mass: pydrake.symbolic.Expression, p_BcmQ_E: numpy.ndarray[object[3, 1]]) -> RotationalInertia_TExpressionU: ...
    def ShiftToCenterOfMass(self, mass: pydrake.symbolic.Expression, p_QBcm_E: numpy.ndarray[object[3, 1]]) -> RotationalInertia_TExpressionU: ...
    def ShiftToThenAwayFromCenterOfMass(self, mass: pydrake.symbolic.Expression, p_PBcm_E: numpy.ndarray[object[3, 1]], p_QBcm_E: numpy.ndarray[object[3, 1]]) -> RotationalInertia_TExpressionU: ...
    def Trace(self) -> pydrake.symbolic.Expression: ...
    @staticmethod
    def TriaxiallySymmetric(I_triaxial: pydrake.symbolic.Expression) -> RotationalInertia_TExpressionU: ...
    def cols(self) -> int: ...
    def get_moments(self) -> numpy.ndarray[object[3, 1]]: ...
    def get_products(self) -> numpy.ndarray[object[3, 1]]: ...
    def rows(self) -> int: ...
    def __add__(self, arg0: RotationalInertia_TExpressionU) -> RotationalInertia_TExpressionU: ...
    def __copy__(self) -> RotationalInertia_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> RotationalInertia_TExpressionU: ...
    def __getitem__(self, arg0: tuple) -> pydrake.symbolic.Expression: ...
    def __iadd__(self, arg0: RotationalInertia_TExpressionU) -> RotationalInertia_TExpressionU: ...
    def __imul__(self, arg0: pydrake.symbolic.Expression) -> RotationalInertia_TExpressionU: ...
    def __isub__(self, arg0: RotationalInertia_TExpressionU) -> RotationalInertia_TExpressionU: ...
    def __itruediv__(self, arg0: pydrake.symbolic.Expression) -> RotationalInertia_TExpressionU: ...
    @overload
    def __mul__(self, arg0: pydrake.symbolic.Expression) -> RotationalInertia_TExpressionU: ...
    @overload
    def __mul__(self, arg0: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def __rmul__(self, arg0: pydrake.symbolic.Expression) -> RotationalInertia_TExpressionU: ...
    def __sub__(self, arg0: RotationalInertia_TExpressionU) -> RotationalInertia_TExpressionU: ...
    def __truediv__(self, arg0: pydrake.symbolic.Expression) -> RotationalInertia_TExpressionU: ...

class _TemporaryName_N5drake9multibody18LinearSpringDamperIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(ForceElement_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, bodyA: RigidBody_TAutoDiffXdU, p_AP: numpy.ndarray[numpy.float64[3, 1]], bodyB: RigidBody_TAutoDiffXdU, p_BQ: numpy.ndarray[numpy.float64[3, 1]], free_length: float, stiffness: float, damping: float) -> None: ...
    def bodyA(self) -> RigidBody_TAutoDiffXdU: ...
    def bodyB(self) -> RigidBody_TAutoDiffXdU: ...
    def damping(self) -> float: ...
    def free_length(self) -> float: ...
    def p_AP(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def p_BQ(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def stiffness(self) -> float: ...

class _TemporaryName_N5drake9multibody18LinearSpringDamperINS_8symbolic10ExpressionEEE(ForceElement_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, bodyA: RigidBody_TExpressionU, p_AP: numpy.ndarray[numpy.float64[3, 1]], bodyB: RigidBody_TExpressionU, p_BQ: numpy.ndarray[numpy.float64[3, 1]], free_length: float, stiffness: float, damping: float) -> None: ...
    def bodyA(self) -> RigidBody_TExpressionU: ...
    def bodyB(self) -> RigidBody_TExpressionU: ...
    def damping(self) -> float: ...
    def free_length(self) -> float: ...
    def p_AP(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def p_BQ(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def stiffness(self) -> float: ...

class _TemporaryName_N5drake9multibody23QuaternionFloatingJointIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Joint_TAutoDiffXdU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TAutoDiffXdU, frame_on_child: Frame_TAutoDiffXdU, angular_damping: float = ..., translational_damping: float = ...) -> None: ...
    def GetPose(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def SetOrientation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, R: pydrake.math.RotationMatrix_TAutoDiffXdU) -> QuaternionFloatingJoint_TAutoDiffXdU: ...
    def SetPose(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, X_FM: pydrake.math.RigidTransform_TAutoDiffXdU) -> QuaternionFloatingJoint_TAutoDiffXdU: ...
    def SetQuaternion(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, q_FM: pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU) -> QuaternionFloatingJoint_TAutoDiffXdU: ...
    def SetTranslation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, p_FM: numpy.ndarray[object[3, 1]]) -> QuaternionFloatingJoint_TAutoDiffXdU: ...
    def default_angular_damping(self) -> float: ...
    def default_translational_damping(self) -> float: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def get_default_quaternion(self) -> pydrake.common.eigen_geometry.Quaternion: ...
    def get_default_translation(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_quaternion(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, w_FM: numpy.ndarray[object[3, 1]]) -> QuaternionFloatingJoint_TAutoDiffXdU: ...
    def set_default_quaternion(self, q_FM: pydrake.common.eigen_geometry.Quaternion) -> None: ...
    def set_default_translation(self, translation: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_random_quaternion_distribution(self, q_FM: pydrake.common.eigen_geometry.Quaternion_TExpressionU) -> None: ...
    def set_random_quaternion_distribution_to_uniform(self) -> None: ...
    def set_random_translation_distribution(self, translation: numpy.ndarray[object[3, 1]]) -> None: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, v_FM: numpy.ndarray[object[3, 1]]) -> QuaternionFloatingJoint_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody23QuaternionFloatingJointINS_8symbolic10ExpressionEEE(Joint_TExpressionU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent: Frame_TExpressionU, frame_on_child: Frame_TExpressionU, angular_damping: float = ..., translational_damping: float = ...) -> None: ...
    def GetPose(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def SetOrientation(self, context: pydrake.systems.framework.Context_TExpressionU, R: pydrake.math.RotationMatrix_TExpressionU) -> QuaternionFloatingJoint_TExpressionU: ...
    def SetPose(self, context: pydrake.systems.framework.Context_TExpressionU, X_FM: pydrake.math.RigidTransform_TExpressionU) -> QuaternionFloatingJoint_TExpressionU: ...
    def SetQuaternion(self, context: pydrake.systems.framework.Context_TExpressionU, q_FM: pydrake.common.eigen_geometry.Quaternion_TExpressionU) -> QuaternionFloatingJoint_TExpressionU: ...
    def SetTranslation(self, context: pydrake.systems.framework.Context_TExpressionU, p_FM: numpy.ndarray[object[3, 1]]) -> QuaternionFloatingJoint_TExpressionU: ...
    def default_angular_damping(self) -> float: ...
    def default_translational_damping(self) -> float: ...
    def get_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def get_default_quaternion(self) -> pydrake.common.eigen_geometry.Quaternion: ...
    def get_default_translation(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def get_quaternion(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.common.eigen_geometry.Quaternion_TExpressionU: ...
    def get_translation(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def get_translational_velocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def set_angular_velocity(self, context: pydrake.systems.framework.Context_TExpressionU, w_FM: numpy.ndarray[object[3, 1]]) -> QuaternionFloatingJoint_TExpressionU: ...
    def set_default_quaternion(self, q_FM: pydrake.common.eigen_geometry.Quaternion) -> None: ...
    def set_default_translation(self, translation: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_random_quaternion_distribution(self, q_FM: pydrake.common.eigen_geometry.Quaternion_TExpressionU) -> None: ...
    def set_random_quaternion_distribution_to_uniform(self) -> None: ...
    def set_random_translation_distribution(self, translation: numpy.ndarray[object[3, 1]]) -> None: ...
    def set_translational_velocity(self, context: pydrake.systems.framework.Context_TExpressionU, v_FM: numpy.ndarray[object[3, 1]]) -> QuaternionFloatingJoint_TExpressionU: ...

class _TemporaryName_N5drake9multibody25LinearBushingRollPitchYawIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(ForceElement_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, frameA: Frame_TAutoDiffXdU, frameC: Frame_TAutoDiffXdU, torque_stiffness_constants: numpy.ndarray[numpy.float64[3, 1]], torque_damping_constants: numpy.ndarray[numpy.float64[3, 1]], force_stiffness_constants: numpy.ndarray[numpy.float64[3, 1]], force_damping_constants: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def CalcBushingSpatialForceOnFrameA(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.multibody.math.SpatialForce_TAutoDiffXdU: ...
    def CalcBushingSpatialForceOnFrameC(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.multibody.math.SpatialForce_TAutoDiffXdU: ...
    def GetForceDampingConstants(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def GetForceStiffnessConstants(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def GetTorqueDampingConstants(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def GetTorqueStiffnessConstants(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def SetForceDampingConstants(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, force_damping: numpy.ndarray[object[3, 1]]) -> None: ...
    def SetForceStiffnessConstants(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, force_stiffness: numpy.ndarray[object[3, 1]]) -> None: ...
    def SetTorqueDampingConstants(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, torque_damping: numpy.ndarray[object[3, 1]]) -> None: ...
    def SetTorqueStiffnessConstants(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, torque_stiffness: numpy.ndarray[object[3, 1]]) -> None: ...
    def force_damping_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def force_stiffness_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def frameA(self) -> Frame_TAutoDiffXdU: ...
    def frameC(self) -> Frame_TAutoDiffXdU: ...
    def link0(self) -> RigidBody_TAutoDiffXdU: ...
    def link1(self) -> RigidBody_TAutoDiffXdU: ...
    def torque_damping_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def torque_stiffness_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...

class _TemporaryName_N5drake9multibody25LinearBushingRollPitchYawINS_8symbolic10ExpressionEEE(ForceElement_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, frameA: Frame_TExpressionU, frameC: Frame_TExpressionU, torque_stiffness_constants: numpy.ndarray[numpy.float64[3, 1]], torque_damping_constants: numpy.ndarray[numpy.float64[3, 1]], force_stiffness_constants: numpy.ndarray[numpy.float64[3, 1]], force_damping_constants: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def CalcBushingSpatialForceOnFrameA(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.multibody.math.SpatialForce_TExpressionU: ...
    def CalcBushingSpatialForceOnFrameC(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.multibody.math.SpatialForce_TExpressionU: ...
    def GetForceDampingConstants(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def GetForceStiffnessConstants(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def GetTorqueDampingConstants(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def GetTorqueStiffnessConstants(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def SetForceDampingConstants(self, context: pydrake.systems.framework.Context_TExpressionU, force_damping: numpy.ndarray[object[3, 1]]) -> None: ...
    def SetForceStiffnessConstants(self, context: pydrake.systems.framework.Context_TExpressionU, force_stiffness: numpy.ndarray[object[3, 1]]) -> None: ...
    def SetTorqueDampingConstants(self, context: pydrake.systems.framework.Context_TExpressionU, torque_damping: numpy.ndarray[object[3, 1]]) -> None: ...
    def SetTorqueStiffnessConstants(self, context: pydrake.systems.framework.Context_TExpressionU, torque_stiffness: numpy.ndarray[object[3, 1]]) -> None: ...
    def force_damping_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def force_stiffness_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def frameA(self) -> Frame_TExpressionU: ...
    def frameC(self) -> Frame_TExpressionU: ...
    def link0(self) -> RigidBody_TExpressionU: ...
    def link1(self) -> RigidBody_TExpressionU: ...
    def torque_damping_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def torque_stiffness_constants(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...

class _TemporaryName_N5drake9multibody26UniformGravityFieldElementIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(ForceElement_TAutoDiffXdU):
    kDefaultStrength: ClassVar[float] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def CalcGravityGeneralizedForces(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    def gravity_vector(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def is_enabled(self, model_instance: ModelInstanceIndex) -> bool: ...
    def set_enabled(self, model_instance: ModelInstanceIndex, is_enabled: bool) -> None: ...
    def set_gravity_vector(self, arg0: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...

class _TemporaryName_N5drake9multibody26UniformGravityFieldElementINS_8symbolic10ExpressionEEE(ForceElement_TExpressionU):
    kDefaultStrength: ClassVar[float] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def CalcGravityGeneralizedForces(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    def gravity_vector(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def is_enabled(self, model_instance: ModelInstanceIndex) -> bool: ...
    def set_enabled(self, model_instance: ModelInstanceIndex, is_enabled: bool) -> None: ...
    def set_gravity_vector(self, arg0: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...

class _TemporaryName_N5drake9multibody5FrameIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def CalcAngularVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, measured_in_frame: Frame_TAutoDiffXdU, expressed_in_frame: Frame_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcOffsetPoseInBody(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, X_FQ: pydrake.math.RigidTransform_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def CalcOffsetRotationMatrixInBody(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, R_FQ: pydrake.math.RotationMatrix_TAutoDiffXdU) -> pydrake.math.RotationMatrix_TAutoDiffXdU: ...
    def CalcPose(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_M: Frame_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def CalcPoseInBodyFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def CalcPoseInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def CalcRelativeSpatialAcceleration(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, other_frame: Frame_TAutoDiffXdU, measured_in_frame: Frame_TAutoDiffXdU, expressed_in_frame: Frame_TAutoDiffXdU) -> pydrake.multibody.math.SpatialAcceleration_TAutoDiffXdU: ...
    def CalcRelativeSpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, other_frame: Frame_TAutoDiffXdU) -> pydrake.multibody.math.SpatialAcceleration_TAutoDiffXdU: ...
    def CalcRelativeSpatialVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, other_frame: Frame_TAutoDiffXdU, measured_in_frame: Frame_TAutoDiffXdU, expressed_in_frame: Frame_TAutoDiffXdU) -> pydrake.multibody.math.SpatialVelocity_TAutoDiffXdU: ...
    def CalcRelativeSpatialVelocityInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, other_frame: Frame_TAutoDiffXdU) -> pydrake.multibody.math.SpatialVelocity_TAutoDiffXdU: ...
    def CalcRotationMatrix(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_M: Frame_TAutoDiffXdU) -> pydrake.math.RotationMatrix_TAutoDiffXdU: ...
    def CalcRotationMatrixInBodyFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.math.RotationMatrix_TAutoDiffXdU: ...
    def CalcRotationMatrixInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.math.RotationMatrix_TAutoDiffXdU: ...
    def CalcSpatialAcceleration(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, measured_in_frame: Frame_TAutoDiffXdU, expressed_in_frame: Frame_TAutoDiffXdU) -> pydrake.multibody.math.SpatialAcceleration_TAutoDiffXdU: ...
    def CalcSpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.multibody.math.SpatialAcceleration_TAutoDiffXdU: ...
    def CalcSpatialVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_M: Frame_TAutoDiffXdU, frame_E: Frame_TAutoDiffXdU) -> pydrake.multibody.math.SpatialVelocity_TAutoDiffXdU: ...
    def CalcSpatialVelocityInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.multibody.math.SpatialVelocity_TAutoDiffXdU: ...
    def EvalAngularVelocityInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def GetFixedOffsetPoseInBody(self, X_FQ: pydrake.math.RigidTransform_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    @overload
    def GetFixedPoseInBodyFrame(self) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    @overload
    def GetFixedPoseInBodyFrame(self) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def GetFixedRotationMatrixInBody(self, R_FQ: pydrake.math.RotationMatrix_TAutoDiffXdU) -> pydrake.math.RotationMatrix_TAutoDiffXdU: ...
    def GetFixedRotationMatrixInBodyFrame(self) -> pydrake.math.RotationMatrix_TAutoDiffXdU: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def body(self, *args, **kwargs): ...
    def index(self) -> FrameIndex: ...
    def is_body_frame(self) -> bool: ...
    def is_ephemeral(self) -> bool: ...
    def is_world_frame(self) -> bool: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def scoped_name(self) -> ScopedName: ...

class _TemporaryName_N5drake9multibody5FrameINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def CalcAngularVelocity(self, context: pydrake.systems.framework.Context_TExpressionU, measured_in_frame: Frame_TExpressionU, expressed_in_frame: Frame_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcOffsetPoseInBody(self, context: pydrake.systems.framework.Context_TExpressionU, X_FQ: pydrake.math.RigidTransform_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def CalcOffsetRotationMatrixInBody(self, context: pydrake.systems.framework.Context_TExpressionU, R_FQ: pydrake.math.RotationMatrix_TExpressionU) -> pydrake.math.RotationMatrix_TExpressionU: ...
    def CalcPose(self, context: pydrake.systems.framework.Context_TExpressionU, frame_M: Frame_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def CalcPoseInBodyFrame(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def CalcPoseInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def CalcRelativeSpatialAcceleration(self, context: pydrake.systems.framework.Context_TExpressionU, other_frame: Frame_TExpressionU, measured_in_frame: Frame_TExpressionU, expressed_in_frame: Frame_TExpressionU) -> pydrake.multibody.math.SpatialAcceleration_TExpressionU: ...
    def CalcRelativeSpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context_TExpressionU, other_frame: Frame_TExpressionU) -> pydrake.multibody.math.SpatialAcceleration_TExpressionU: ...
    def CalcRelativeSpatialVelocity(self, context: pydrake.systems.framework.Context_TExpressionU, other_frame: Frame_TExpressionU, measured_in_frame: Frame_TExpressionU, expressed_in_frame: Frame_TExpressionU) -> pydrake.multibody.math.SpatialVelocity_TExpressionU: ...
    def CalcRelativeSpatialVelocityInWorld(self, context: pydrake.systems.framework.Context_TExpressionU, other_frame: Frame_TExpressionU) -> pydrake.multibody.math.SpatialVelocity_TExpressionU: ...
    def CalcRotationMatrix(self, context: pydrake.systems.framework.Context_TExpressionU, frame_M: Frame_TExpressionU) -> pydrake.math.RotationMatrix_TExpressionU: ...
    def CalcRotationMatrixInBodyFrame(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.math.RotationMatrix_TExpressionU: ...
    def CalcRotationMatrixInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.math.RotationMatrix_TExpressionU: ...
    def CalcSpatialAcceleration(self, context: pydrake.systems.framework.Context_TExpressionU, measured_in_frame: Frame_TExpressionU, expressed_in_frame: Frame_TExpressionU) -> pydrake.multibody.math.SpatialAcceleration_TExpressionU: ...
    def CalcSpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.multibody.math.SpatialAcceleration_TExpressionU: ...
    def CalcSpatialVelocity(self, context: pydrake.systems.framework.Context_TExpressionU, frame_M: Frame_TExpressionU, frame_E: Frame_TExpressionU) -> pydrake.multibody.math.SpatialVelocity_TExpressionU: ...
    def CalcSpatialVelocityInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.multibody.math.SpatialVelocity_TExpressionU: ...
    def EvalAngularVelocityInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def GetFixedOffsetPoseInBody(self, X_FQ: pydrake.math.RigidTransform_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    @overload
    def GetFixedPoseInBodyFrame(self) -> pydrake.math.RigidTransform_TExpressionU: ...
    @overload
    def GetFixedPoseInBodyFrame(self) -> pydrake.math.RigidTransform_TExpressionU: ...
    def GetFixedRotationMatrixInBody(self, R_FQ: pydrake.math.RotationMatrix_TExpressionU) -> pydrake.math.RotationMatrix_TExpressionU: ...
    def GetFixedRotationMatrixInBodyFrame(self) -> pydrake.math.RotationMatrix_TExpressionU: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def body(self, *args, **kwargs): ...
    def index(self) -> FrameIndex: ...
    def is_body_frame(self) -> bool: ...
    def is_ephemeral(self) -> bool: ...
    def is_world_frame(self) -> bool: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def scoped_name(self) -> ScopedName: ...

class _TemporaryName_N5drake9multibody5JointIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def AddInDamping(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, forces: MultibodyForces_TAutoDiffXdU) -> None: ...
    def AddInOneForce(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, joint_dof: int, joint_tau: pydrake.autodiffutils.AutoDiffXd, forces: MultibodyForces_TAutoDiffXdU) -> None: ...
    def GetDampingVector(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    def GetDefaultPose(self) -> pydrake.math.RigidTransform: ...
    def GetDefaultPosePair(self) -> tuple[pydrake.common.eigen_geometry.Quaternion, numpy.ndarray[numpy.float64[3, 1]]]: ...
    def GetOnePosition(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def GetOneVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def Lock(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...
    def SetDampingVector(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, damping: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetDefaultPose(self, X_FM: pydrake.math.RigidTransform) -> None: ...
    def SetDefaultPosePair(self, q_FM: pydrake.common.eigen_geometry.Quaternion, p_FM: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def Unlock(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...
    def acceleration_lower_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def acceleration_upper_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def can_rotate(self) -> bool: ...
    def can_translate(self) -> bool: ...
    def child_body(self) -> RigidBody_TAutoDiffXdU: ...
    def default_damping_vector(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def default_positions(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def frame_on_child(self) -> Frame_TAutoDiffXdU: ...
    def frame_on_parent(self) -> Frame_TAutoDiffXdU: ...
    @overload
    def index(self) -> JointIndex: ...
    @overload
    def index(self) -> JointIndex: ...
    def is_ephemeral(self) -> bool: ...
    def is_locked(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> bool: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def num_positions(self) -> int: ...
    def num_velocities(self) -> int: ...
    def parent_body(self) -> RigidBody_TAutoDiffXdU: ...
    def position_lower_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def position_start(self) -> int: ...
    def position_suffix(self, arg0: int) -> str: ...
    def position_upper_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def set_acceleration_limits(self, lower_limits: numpy.ndarray[numpy.float64[m, 1]], upper_limits: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_default_damping_vector(self, damping: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_default_positions(self, default_positions: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_position_limits(self, lower_limits: numpy.ndarray[numpy.float64[m, 1]], upper_limits: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_velocity_limits(self, lower_limits: numpy.ndarray[numpy.float64[m, 1]], upper_limits: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def type_name(self) -> str: ...
    def velocity_lower_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def velocity_start(self) -> int: ...
    def velocity_suffix(self, arg0: int) -> str: ...
    def velocity_upper_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class _TemporaryName_N5drake9multibody5JointINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def AddInDamping(self, context: pydrake.systems.framework.Context_TExpressionU, forces: MultibodyForces_TExpressionU) -> None: ...
    def AddInOneForce(self, context: pydrake.systems.framework.Context_TExpressionU, joint_dof: int, joint_tau: pydrake.symbolic.Expression, forces: MultibodyForces_TExpressionU) -> None: ...
    def GetDampingVector(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    def GetDefaultPose(self) -> pydrake.math.RigidTransform: ...
    def GetDefaultPosePair(self) -> tuple[pydrake.common.eigen_geometry.Quaternion, numpy.ndarray[numpy.float64[3, 1]]]: ...
    def GetOnePosition(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def GetOneVelocity(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def Lock(self, context: pydrake.systems.framework.Context_TExpressionU) -> None: ...
    def SetDampingVector(self, context: pydrake.systems.framework.Context_TExpressionU, damping: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetDefaultPose(self, X_FM: pydrake.math.RigidTransform) -> None: ...
    def SetDefaultPosePair(self, q_FM: pydrake.common.eigen_geometry.Quaternion, p_FM: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def Unlock(self, context: pydrake.systems.framework.Context_TExpressionU) -> None: ...
    def acceleration_lower_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def acceleration_upper_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def can_rotate(self) -> bool: ...
    def can_translate(self) -> bool: ...
    def child_body(self) -> RigidBody_TExpressionU: ...
    def default_damping_vector(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def default_positions(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def frame_on_child(self) -> Frame_TExpressionU: ...
    def frame_on_parent(self) -> Frame_TExpressionU: ...
    @overload
    def index(self) -> JointIndex: ...
    @overload
    def index(self) -> JointIndex: ...
    def is_ephemeral(self) -> bool: ...
    def is_locked(self, context: pydrake.systems.framework.Context_TExpressionU) -> bool: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def num_positions(self) -> int: ...
    def num_velocities(self) -> int: ...
    def parent_body(self) -> RigidBody_TExpressionU: ...
    def position_lower_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def position_start(self) -> int: ...
    def position_suffix(self, arg0: int) -> str: ...
    def position_upper_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def set_acceleration_limits(self, lower_limits: numpy.ndarray[numpy.float64[m, 1]], upper_limits: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_default_damping_vector(self, damping: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_default_positions(self, default_positions: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_position_limits(self, lower_limits: numpy.ndarray[numpy.float64[m, 1]], upper_limits: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_velocity_limits(self, lower_limits: numpy.ndarray[numpy.float64[m, 1]], upper_limits: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def type_name(self) -> str: ...
    def velocity_lower_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def velocity_start(self) -> int: ...
    def velocity_suffix(self, arg0: int) -> str: ...
    def velocity_upper_limits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class _TemporaryName_N5drake9multibody9DoorHingeIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(ForceElement_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, joint: RevoluteJoint_TAutoDiffXdU, config: DoorHingeConfig) -> None: ...
    def CalcHingeFrictionalTorque(self, angular_rate: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
    def CalcHingeSpringTorque(self, angle: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
    def CalcHingeTorque(self, angle: pydrake.autodiffutils.AutoDiffXd, angular_rate: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
    def config(self) -> DoorHingeConfig: ...
    def joint(self) -> RevoluteJoint_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody9DoorHingeINS_8symbolic10ExpressionEEE(ForceElement_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, joint: RevoluteJoint_TExpressionU, config: DoorHingeConfig) -> None: ...
    def CalcHingeFrictionalTorque(self, angular_rate: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
    def CalcHingeSpringTorque(self, angle: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
    def CalcHingeTorque(self, angle: pydrake.symbolic.Expression, angular_rate: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
    def config(self) -> DoorHingeConfig: ...
    def joint(self) -> RevoluteJoint_TExpressionU: ...

class _TemporaryName_N5drake9multibody9RigidBodyIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, body_name: str, M_BBo_B: SpatialInertia = ...) -> None: ...
    def AddInForce(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, p_BP_E: numpy.ndarray[object[3, 1]], F_Bp_E: pydrake.multibody.math.SpatialForce_TAutoDiffXdU, frame_E: Frame_TAutoDiffXdU, forces: MultibodyForces_TAutoDiffXdU) -> None: ...
    def AddInForceInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, F_Bo_W: pydrake.multibody.math.SpatialForce_TAutoDiffXdU, forces: MultibodyForces_TAutoDiffXdU) -> None: ...
    def CalcCenterOfMassInBodyFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcCenterOfMassTranslationalAccelerationInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcCenterOfMassTranslationalVelocityInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcSpatialInertiaInBodyFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> SpatialInertia_TAutoDiffXdU: ...
    def EvalPoseInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def EvalSpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.multibody.math.SpatialAcceleration_TAutoDiffXdU: ...
    def EvalSpatialVelocityInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.multibody.math.SpatialVelocity_TAutoDiffXdU: ...
    def GetForceInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, forces: MultibodyForces_TAutoDiffXdU) -> pydrake.multibody.math.SpatialForce_TAutoDiffXdU: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def Lock(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...
    def SetCenterOfMassInBodyFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, com: numpy.ndarray[object[3, 1]]) -> None: ...
    def SetMass(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, mass: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def SetSpatialInertiaInBodyFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, M_Bo_B: SpatialInertia_TAutoDiffXdU) -> None: ...
    def Unlock(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...
    def body_frame(self) -> RigidBodyFrame_TAutoDiffXdU: ...
    def default_com(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def default_mass(self) -> float: ...
    def default_rotational_inertia(self) -> RotationalInertia: ...
    def default_spatial_inertia(self) -> SpatialInertia: ...
    def default_unit_inertia(self) -> UnitInertia: ...
    def floating_position_suffix(self, arg0: int) -> str: ...
    def floating_positions_start(self) -> int: ...
    def floating_velocities_start_in_v(self) -> int: ...
    def floating_velocity_suffix(self, arg0: int) -> str: ...
    def get_mass(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def has_quaternion_dofs(self) -> bool: ...
    def index(self) -> BodyIndex: ...
    def is_ephemeral(self) -> bool: ...
    def is_floating(self) -> bool: ...
    def is_floating_base_body(self) -> bool: ...
    @overload
    def is_locked(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> bool: ...
    @overload
    def is_locked(self) -> Any: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def scoped_name(self) -> ScopedName: ...

class _TemporaryName_N5drake9multibody9RigidBodyINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, body_name: str, M_BBo_B: SpatialInertia = ...) -> None: ...
    def AddInForce(self, context: pydrake.systems.framework.Context_TExpressionU, p_BP_E: numpy.ndarray[object[3, 1]], F_Bp_E: pydrake.multibody.math.SpatialForce_TExpressionU, frame_E: Frame_TExpressionU, forces: MultibodyForces_TExpressionU) -> None: ...
    def AddInForceInWorld(self, context: pydrake.systems.framework.Context_TExpressionU, F_Bo_W: pydrake.multibody.math.SpatialForce_TExpressionU, forces: MultibodyForces_TExpressionU) -> None: ...
    def CalcCenterOfMassInBodyFrame(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcCenterOfMassTranslationalAccelerationInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcCenterOfMassTranslationalVelocityInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcSpatialInertiaInBodyFrame(self, context: pydrake.systems.framework.Context_TExpressionU) -> SpatialInertia_TExpressionU: ...
    def EvalPoseInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def EvalSpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.multibody.math.SpatialAcceleration_TExpressionU: ...
    def EvalSpatialVelocityInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.multibody.math.SpatialVelocity_TExpressionU: ...
    def GetForceInWorld(self, context: pydrake.systems.framework.Context_TExpressionU, forces: MultibodyForces_TExpressionU) -> pydrake.multibody.math.SpatialForce_TExpressionU: ...
    def GetParentPlant(self, *args, **kwargs): ...
    def Lock(self, context: pydrake.systems.framework.Context_TExpressionU) -> None: ...
    def SetCenterOfMassInBodyFrame(self, context: pydrake.systems.framework.Context_TExpressionU, com: numpy.ndarray[object[3, 1]]) -> None: ...
    def SetMass(self, context: pydrake.systems.framework.Context_TExpressionU, mass: pydrake.symbolic.Expression) -> None: ...
    def SetSpatialInertiaInBodyFrame(self, context: pydrake.systems.framework.Context_TExpressionU, M_Bo_B: SpatialInertia_TExpressionU) -> None: ...
    def Unlock(self, context: pydrake.systems.framework.Context_TExpressionU) -> None: ...
    def body_frame(self) -> RigidBodyFrame_TExpressionU: ...
    def default_com(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def default_mass(self) -> float: ...
    def default_rotational_inertia(self) -> RotationalInertia: ...
    def default_spatial_inertia(self) -> SpatialInertia: ...
    def default_unit_inertia(self) -> UnitInertia: ...
    def floating_position_suffix(self, arg0: int) -> str: ...
    def floating_positions_start(self) -> int: ...
    def floating_velocities_start_in_v(self) -> int: ...
    def floating_velocity_suffix(self, arg0: int) -> str: ...
    def get_mass(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    def has_quaternion_dofs(self) -> bool: ...
    def index(self) -> BodyIndex: ...
    def is_ephemeral(self) -> bool: ...
    def is_floating(self) -> bool: ...
    def is_floating_base_body(self) -> bool: ...
    @overload
    def is_locked(self, context: pydrake.systems.framework.Context_TExpressionU) -> bool: ...
    @overload
    def is_locked(self) -> Any: ...
    def model_instance(self) -> ModelInstanceIndex: ...
    def name(self) -> str: ...
    def scoped_name(self) -> ScopedName: ...

class _TemporaryName_N5drake9multibody9WeldJointIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(Joint_TAutoDiffXdU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent_F: Frame_TAutoDiffXdU, frame_on_child_M: Frame_TAutoDiffXdU, X_FM: pydrake.math.RigidTransform) -> None: ...
    def X_FM(self) -> pydrake.math.RigidTransform: ...

class _TemporaryName_N5drake9multibody9WeldJointINS_8symbolic10ExpressionEEE(Joint_TExpressionU):
    kTypeName: ClassVar[str] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, name: str, frame_on_parent_F: Frame_TExpressionU, frame_on_child_M: Frame_TExpressionU, X_FM: pydrake.math.RigidTransform) -> None: ...
    def X_FM(self) -> pydrake.math.RigidTransform: ...

def CalcSpatialInertia(const
geometry, double) -> Any: ...
def default_model_instance() -> ModelInstanceIndex: ...
def world_frame_index() -> FrameIndex: ...
def world_index() -> BodyIndex: ...
def world_model_instance() -> ModelInstanceIndex: ...
