import flags
import numpy
import pydrake.autodiffutils
import pydrake.geometry
import pydrake.lcm
import pydrake.math
import pydrake.multibody.fem
import pydrake.multibody.math
import pydrake.multibody.tree
import pydrake.symbolic
import pydrake.systems.framework
import pydrake.systems.lcm
import scipy.sparse
from pydrake.common.cpp_template import ContactResults_ as ContactResults_, CoulombFriction_ as CoulombFriction_, DeformableContactInfo_ as DeformableContactInfo_, ExternallyAppliedSpatialForceMultiplexer_ as ExternallyAppliedSpatialForceMultiplexer_, ExternallyAppliedSpatialForce_ as ExternallyAppliedSpatialForce_, HydroelasticContactInfo_ as HydroelasticContactInfo_, MultibodyPlant_ as MultibodyPlant_, PointPairContactInfo_ as PointPairContactInfo_, Propeller_ as Propeller_, Wing_ as Wing_
from typing import Any, Callable, ClassVar, overload

__getattr__: Callable

class ContactModel:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kHydroelastic: ClassVar[ContactModel] = ...
    kHydroelasticWithFallback: ClassVar[ContactModel] = ...
    kHydroelasticsOnly: ClassVar[ContactModel] = ...
    kPoint: ClassVar[ContactModel] = ...
    kPointContactOnly: ClassVar[ContactModel] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class ContactResults:
    def __init__(self) -> None: ...
    def SelectHydroelastic(self, selector: Callable[[HydroelasticContactInfo], bool]) -> ContactResults: ...
    def deformable_contact_info(self, i: int) -> DeformableContactInfo: ...
    def hydroelastic_contact_info(self, i: int) -> HydroelasticContactInfo: ...
    def num_deformable_contacts(self) -> int: ...
    def num_hydroelastic_contacts(self) -> int: ...
    def num_point_pair_contacts(self) -> int: ...
    def plant(self, *args, **kwargs): ...
    def point_pair_contact_info(self, i: int) -> PointPairContactInfo: ...
    def __copy__(self) -> ContactResults: ...
    def __deepcopy__(self, arg0: dict) -> ContactResults: ...

class ContactResultsToLcmSystem(pydrake.systems.framework.LeafSystem):
    def __init__(self, plant) -> None: ...
    def get_contact_result_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_lcm_message_output_port(self) -> pydrake.systems.framework.OutputPort: ...

class ContactResults_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def SelectHydroelastic(self, selector: Callable[[HydroelasticContactInfo_TAutoDiffXdU], bool]) -> ContactResults_TAutoDiffXdU: ...
    def deformable_contact_info(self, i: int) -> DeformableContactInfo_TAutoDiffXdU: ...
    def hydroelastic_contact_info(self, i: int) -> HydroelasticContactInfo_TAutoDiffXdU: ...
    def num_deformable_contacts(self) -> int: ...
    def num_hydroelastic_contacts(self) -> int: ...
    def num_point_pair_contacts(self) -> int: ...
    def plant(self, *args, **kwargs): ...
    def point_pair_contact_info(self, i: int) -> PointPairContactInfo_TAutoDiffXdU: ...
    def __copy__(self) -> ContactResults_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> ContactResults_TAutoDiffXdU: ...

class ContactResults_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def SelectHydroelastic(self, selector: Callable[[HydroelasticContactInfo_TExpressionU], bool]) -> ContactResults_TExpressionU: ...
    def deformable_contact_info(self, i: int) -> DeformableContactInfo_TExpressionU: ...
    def hydroelastic_contact_info(self, i: int) -> HydroelasticContactInfo_TExpressionU: ...
    def num_deformable_contacts(self) -> int: ...
    def num_hydroelastic_contacts(self) -> int: ...
    def num_point_pair_contacts(self) -> int: ...
    def plant(self, *args, **kwargs): ...
    def point_pair_contact_info(self, i: int) -> PointPairContactInfo_TExpressionU: ...
    def __copy__(self) -> ContactResults_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> ContactResults_TExpressionU: ...

class CoulombFriction:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, static_friction: float, dynamic_friction: float) -> None: ...
    def dynamic_friction(self) -> float: ...
    def static_friction(self) -> float: ...
    def __copy__(self) -> CoulombFriction: ...
    def __deepcopy__(self, arg0: dict) -> CoulombFriction: ...

class CoulombFriction_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, static_friction: pydrake.autodiffutils.AutoDiffXd, dynamic_friction: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def dynamic_friction(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def static_friction(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def __copy__(self) -> CoulombFriction_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> CoulombFriction_TAutoDiffXdU: ...

class CoulombFriction_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, static_friction: pydrake.symbolic.Expression, dynamic_friction: pydrake.symbolic.Expression) -> None: ...
    def dynamic_friction(self) -> pydrake.symbolic.Expression: ...
    def static_friction(self) -> pydrake.symbolic.Expression: ...
    def __copy__(self) -> CoulombFriction_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> CoulombFriction_TExpressionU: ...

class DeformableContactInfo:
    def __init__(self, id_A: pydrake.geometry.GeometryId, id_B: pydrake.geometry.GeometryId, contact_mesh_W: pydrake.geometry.PolygonSurfaceMesh, F_Ac_W: pydrake.multibody.math.SpatialForce) -> None: ...
    def F_Ac_W(self) -> pydrake.multibody.math.SpatialForce: ...
    def contact_mesh(self) -> pydrake.geometry.PolygonSurfaceMesh: ...
    def id_A(self) -> pydrake.geometry.GeometryId: ...
    def id_B(self) -> pydrake.geometry.GeometryId: ...
    def __copy__(self) -> DeformableContactInfo: ...
    def __deepcopy__(self, arg0: dict) -> DeformableContactInfo: ...

class DeformableContactInfo_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, id_A: pydrake.geometry.GeometryId, id_B: pydrake.geometry.GeometryId, contact_mesh_W: pydrake.geometry.PolygonSurfaceMesh_TAutoDiffXdU, F_Ac_W: pydrake.multibody.math.SpatialForce_TAutoDiffXdU) -> None: ...
    def F_Ac_W(self) -> pydrake.multibody.math.SpatialForce_TAutoDiffXdU: ...
    def contact_mesh(self) -> pydrake.geometry.PolygonSurfaceMesh_TAutoDiffXdU: ...
    def id_A(self) -> pydrake.geometry.GeometryId: ...
    def id_B(self) -> pydrake.geometry.GeometryId: ...
    def __copy__(self) -> DeformableContactInfo_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> DeformableContactInfo_TAutoDiffXdU: ...

class DeformableContactInfo_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def __copy__(self) -> DeformableContactInfo_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> DeformableContactInfo_TExpressionU: ...

class DeformableModel(PhysicalModel):
    def __init__(self, *args, **kwargs) -> None: ...
    def AddExternalForce(self, external_force: pydrake.multibody.fem.ForceDensityFieldBase) -> None: ...
    def AddFixedConstraint(self, body_A_id: pydrake.multibody.tree.DeformableBodyId, body_B: pydrake.multibody.tree.RigidBody, X_BA: pydrake.math.RigidTransform, shape_G: pydrake.geometry.Shape, X_BG: pydrake.math.RigidTransform) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def Disable(self, id: pydrake.multibody.tree.DeformableBodyId, context: pydrake.systems.framework.Context) -> None: ...
    @overload
    def Enable(self, id: pydrake.multibody.tree.DeformableBodyId, context: pydrake.systems.framework.Context) -> None: ...
    @overload
    def Enable(self) -> Any: ...
    @overload
    def GetBody(self, id: pydrake.multibody.tree.DeformableBodyId) -> pydrake.multibody.tree.DeformableBody: ...
    @overload
    def GetBody(self, index: pydrake.multibody.tree.DeformableBodyIndex) -> pydrake.multibody.tree.DeformableBody: ...
    def GetBodyByName(self, name: str) -> pydrake.multibody.tree.DeformableBody: ...
    @overload
    def GetBodyId(self, index: pydrake.multibody.tree.DeformableBodyIndex) -> pydrake.multibody.tree.DeformableBodyId: ...
    @overload
    def GetBodyId(self, geometry_id: pydrake.geometry.GeometryId) -> pydrake.multibody.tree.DeformableBodyId: ...
    def GetBodyIds(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.DeformableBodyId]: ...
    def GetBodyIndex(self, id: pydrake.multibody.tree.DeformableBodyId) -> pydrake.multibody.tree.DeformableBodyIndex: ...
    def GetDiscreteStateIndex(self, id: pydrake.multibody.tree.DeformableBodyId) -> pydrake.systems.framework.DiscreteStateIndex: ...
    def GetExternalForces(self, id: pydrake.multibody.tree.DeformableBodyId) -> list[pydrake.multibody.fem.ForceDensityFieldBase]: ...
    def GetGeometryId(self, id: pydrake.multibody.tree.DeformableBodyId) -> pydrake.geometry.GeometryId: ...
    def GetMutableBody(self, id: pydrake.multibody.tree.DeformableBodyId) -> pydrake.multibody.tree.DeformableBody: ...
    def GetPositions(self, context: pydrake.systems.framework.Context, id: pydrake.multibody.tree.DeformableBodyId) -> numpy.ndarray[numpy.float64[3, n]]: ...
    def GetPositionsAndVelocities(self, context: pydrake.systems.framework.Context, id: pydrake.multibody.tree.DeformableBodyId) -> numpy.ndarray[numpy.float64[3, n]]: ...
    def GetReferencePositions(self, id: pydrake.multibody.tree.DeformableBodyId) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetVelocities(self, context: pydrake.systems.framework.Context, id: pydrake.multibody.tree.DeformableBodyId) -> numpy.ndarray[numpy.float64[3, n]]: ...
    @overload
    def HasBodyNamed(self, name: str) -> bool: ...
    @overload
    def HasBodyNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def HasConstraint(self, id: pydrake.multibody.tree.DeformableBodyId) -> bool: ...
    @overload
    def RegisterDeformableBody(self, geometry_instance: pydrake.geometry.GeometryInstance, config: pydrake.multibody.fem.DeformableBodyConfig, resolution_hint: float) -> pydrake.multibody.tree.DeformableBodyId: ...
    @overload
    def RegisterDeformableBody(self, geometry_instance: pydrake.geometry.GeometryInstance, model_instance: pydrake.multibody.tree.ModelInstanceIndex, config: pydrake.multibody.fem.DeformableBodyConfig, resolution_hint: float) -> pydrake.multibody.tree.DeformableBodyId: ...
    def SetPositions(self, context: pydrake.systems.framework.Context, id: pydrake.multibody.tree.DeformableBodyId, q: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous]) -> None: ...
    def SetPositionsAndVelocities(self, context: pydrake.systems.framework.Context, id: pydrake.multibody.tree.DeformableBodyId, q: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous], v: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous]) -> None: ...
    def SetVelocities(self, context: pydrake.systems.framework.Context, id: pydrake.multibody.tree.DeformableBodyId, v: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous]) -> None: ...
    def SetWallBoundaryCondition(self, id: pydrake.multibody.tree.DeformableBodyId, p_WQ: numpy.ndarray[numpy.float64[3, 1]], n_W: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def is_empty(self) -> bool: ...
    def is_enabled(self, id: pydrake.multibody.tree.DeformableBodyId, context: pydrake.systems.framework.Context) -> bool: ...
    def num_bodies(self) -> int: ...

class DiscreteContactApproximation:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kLagged: ClassVar[DiscreteContactApproximation] = ...
    kSap: ClassVar[DiscreteContactApproximation] = ...
    kSimilar: ClassVar[DiscreteContactApproximation] = ...
    kTamsi: ClassVar[DiscreteContactApproximation] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class DiscreteContactSolver:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kSap: ClassVar[DiscreteContactSolver] = ...
    kTamsi: ClassVar[DiscreteContactSolver] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class DistanceConstraintParams:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, bodyA: pydrake.multibody.tree.BodyIndex, p_AP: numpy.ndarray[numpy.float64[3, 1]], bodyB: pydrake.multibody.tree.BodyIndex, p_BQ: numpy.ndarray[numpy.float64[3, 1]], distance: float, stiffness: float, damping: float) -> None: ...
    def bodyA(self) -> pydrake.multibody.tree.BodyIndex: ...
    def bodyB(self) -> pydrake.multibody.tree.BodyIndex: ...
    def damping(self) -> float: ...
    def distance(self) -> float: ...
    def p_AP(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def p_BQ(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def stiffness(self) -> float: ...
    def __copy__(self) -> DistanceConstraintParams: ...
    def __deepcopy__(self, arg0: dict) -> DistanceConstraintParams: ...

class ExternallyAppliedSpatialForce:
    F_Bq_W: pydrake.multibody.math.SpatialForce
    body_index: pydrake.multibody.tree.BodyIndex
    p_BoBq_B: numpy.ndarray[numpy.float64[3, 1]]
    def __init__(self) -> None: ...
    def __copy__(self) -> ExternallyAppliedSpatialForce: ...
    def __deepcopy__(self, arg0: dict) -> ExternallyAppliedSpatialForce: ...

class ExternallyAppliedSpatialForceMultiplexer(pydrake.systems.framework.LeafSystem):
    def __init__(self, num_inputs: int) -> None: ...

class ExternallyAppliedSpatialForceMultiplexer_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, num_inputs: int) -> None: ...

class ExternallyAppliedSpatialForceMultiplexer_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, num_inputs: int) -> None: ...

class ExternallyAppliedSpatialForce_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    F_Bq_W: pydrake.multibody.math.SpatialForce_TAutoDiffXdU
    body_index: pydrake.multibody.tree.BodyIndex
    p_BoBq_B: numpy.ndarray[object[3, 1]]
    def __init__(self) -> None: ...
    def __copy__(self) -> ExternallyAppliedSpatialForce_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> ExternallyAppliedSpatialForce_TAutoDiffXdU: ...

class ExternallyAppliedSpatialForce_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    F_Bq_W: pydrake.multibody.math.SpatialForce_TExpressionU
    body_index: pydrake.multibody.tree.BodyIndex
    p_BoBq_B: numpy.ndarray[object[3, 1]]
    def __init__(self) -> None: ...
    def __copy__(self) -> ExternallyAppliedSpatialForce_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> ExternallyAppliedSpatialForce_TExpressionU: ...

class HydroelasticContactInfo:
    def __init__(self, *args, **kwargs) -> None: ...
    def F_Ac_W(self) -> pydrake.multibody.math.SpatialForce: ...
    def contact_surface(self) -> pydrake.geometry.ContactSurface: ...
    def __copy__(self) -> HydroelasticContactInfo: ...
    def __deepcopy__(self, arg0: dict) -> HydroelasticContactInfo: ...

class HydroelasticContactInfo_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def F_Ac_W(self) -> pydrake.multibody.math.SpatialForce_TAutoDiffXdU: ...
    def contact_surface(self) -> pydrake.geometry.ContactSurface_TAutoDiffXdU: ...
    def __copy__(self) -> HydroelasticContactInfo_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> HydroelasticContactInfo_TAutoDiffXdU: ...

class HydroelasticContactInfo_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def __copy__(self) -> HydroelasticContactInfo_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> HydroelasticContactInfo_TExpressionU: ...

class MultibodyPlant(pydrake.systems.framework.LeafSystem):
    def __init__(self, time_step: float) -> None: ...
    def AddBallConstraint(self, body_A: pydrake.multibody.tree.RigidBody, p_AP: numpy.ndarray[numpy.float64[3, 1]], body_B: pydrake.multibody.tree.RigidBody, p_BQ: numpy.ndarray[numpy.float64[3, 1]] | None = ...) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def AddCouplerConstraint(self, joint0: pydrake.multibody.tree.Joint, joint1: pydrake.multibody.tree.Joint, gear_ratio: float, offset: float = ...) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def AddDistanceConstraint(self, body_A: pydrake.multibody.tree.RigidBody, p_AP: numpy.ndarray[numpy.float64[3, 1]], body_B: pydrake.multibody.tree.RigidBody, p_BQ: numpy.ndarray[numpy.float64[3, 1]], distance: float, stiffness: float = ..., damping: float = ...) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def AddForceElement(self, force_element: pydrake.multibody.tree.ForceElement) -> pydrake.multibody.tree.ForceElement: ...
    def AddFrame(self, frame: pydrake.multibody.tree.Frame) -> pydrake.multibody.tree.Frame: ...
    def AddJoint(self, joint: pydrake.multibody.tree.Joint) -> pydrake.multibody.tree.Joint: ...
    def AddJointActuator(self, name: str, joint: pydrake.multibody.tree.Joint, effort_limit: float = ...) -> pydrake.multibody.tree.JointActuator: ...
    def AddModelInstance(self, name: str) -> pydrake.multibody.tree.ModelInstanceIndex: ...
    def AddRigidBody(self, name: str, M_BBo_B: pydrake.multibody.tree.SpatialInertia = ...) -> pydrake.multibody.tree.RigidBody: ...
    def AddWeldConstraint(self, body_A: pydrake.multibody.tree.RigidBody, X_AP: pydrake.math.RigidTransform, body_B: pydrake.multibody.tree.RigidBody, X_BQ: pydrake.math.RigidTransform) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def CalcBiasCenterOfMassTranslationalAcceleration(self, context: pydrake.systems.framework.Context, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_A: pydrake.multibody.tree.Frame, frame_E: pydrake.multibody.tree.Frame) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcBiasSpatialAcceleration(self, context: pydrake.systems.framework.Context, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame, p_BoBp_B: numpy.ndarray[numpy.float64[3, 1]], frame_A: pydrake.multibody.tree.Frame, frame_E: pydrake.multibody.tree.Frame) -> pydrake.multibody.math.SpatialAcceleration: ...
    def CalcBiasTerm(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def CalcBiasTranslationalAcceleration(self, context: pydrake.systems.framework.Context, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame, p_BoBi_B: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame, frame_E: pydrake.multibody.tree.Frame) -> numpy.ndarray[numpy.float64[3, n]]: ...
    def CalcCenterOfMassPositionInWorld(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcCenterOfMassTranslationalAccelerationInWorld(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcCenterOfMassTranslationalVelocityInWorld(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcForceElementsContribution(self, context: pydrake.systems.framework.Context, forces: pydrake.multibody.tree.MultibodyForces) -> None: ...
    def CalcGeneralizedForces(self, context: pydrake.systems.framework.Context, forces: pydrake.multibody.tree.MultibodyForces) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def CalcGravityGeneralizedForces(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def CalcInverseDynamics(self, context: pydrake.systems.framework.Context, known_vdot: numpy.ndarray[numpy.float64[m, 1]], external_forces: pydrake.multibody.tree.MultibodyForces) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def CalcJacobianAngularVelocity(self, context: pydrake.systems.framework.Context, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame, frame_A: pydrake.multibody.tree.Frame, frame_E: pydrake.multibody.tree.Frame) -> numpy.ndarray[numpy.float64[3, n]]: ...
    def CalcJacobianCenterOfMassTranslationalVelocity(self, context: pydrake.systems.framework.Context, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_A: pydrake.multibody.tree.Frame, frame_E: pydrake.multibody.tree.Frame) -> numpy.ndarray[numpy.float64[3, n]]: ...
    def CalcJacobianPositionVector(self, context: pydrake.systems.framework.Context, frame_B: pydrake.multibody.tree.Frame, p_BoBi_B: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame, frame_E: pydrake.multibody.tree.Frame) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def CalcJacobianSpatialVelocity(self, context: pydrake.systems.framework.Context, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame, p_BoBp_B: numpy.ndarray[numpy.float64[3, 1]], frame_A: pydrake.multibody.tree.Frame, frame_E: pydrake.multibody.tree.Frame) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def CalcJacobianTranslationalVelocity(self, context: pydrake.systems.framework.Context, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame, p_BoBi_B: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame, frame_E: pydrake.multibody.tree.Frame) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def CalcMassMatrix(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def CalcMassMatrixViaInverseDynamics(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def CalcPointsPositions(self, context: pydrake.systems.framework.Context, frame_B: pydrake.multibody.tree.Frame, p_BQi: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def CalcPointsVelocities(self, context: pydrake.systems.framework.Context, frame_B: pydrake.multibody.tree.Frame, p_BQi: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame, frame_E: pydrake.multibody.tree.Frame) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def CalcRelativeRotationMatrix(self, context: pydrake.systems.framework.Context, frame_A: pydrake.multibody.tree.Frame, frame_B: pydrake.multibody.tree.Frame) -> pydrake.math.RotationMatrix: ...
    def CalcRelativeTransform(self, context: pydrake.systems.framework.Context, frame_A: pydrake.multibody.tree.Frame, frame_B: pydrake.multibody.tree.Frame) -> pydrake.math.RigidTransform: ...
    def CalcSpatialAccelerationsFromVdot(self, context: pydrake.systems.framework.Context, known_vdot: numpy.ndarray[numpy.float64[m, 1]]) -> list[pydrake.multibody.math.SpatialAcceleration]: ...
    def CalcSpatialInertia(self, context: pydrake.systems.framework.Context, frame_F: pydrake.multibody.tree.Frame, body_indexes: list[pydrake.multibody.tree.BodyIndex]) -> pydrake.multibody.tree.SpatialInertia: ...
    def CalcSpatialMomentumInWorldAboutPoint(self, context: pydrake.systems.framework.Context, p_WoP_W: numpy.ndarray[numpy.float64[3, 1]]) -> pydrake.multibody.math.SpatialMomentum: ...
    @overload
    def CalcTotalMass(self, context: pydrake.systems.framework.Context) -> float: ...
    @overload
    def CalcTotalMass(self, context: pydrake.systems.framework.Context, model_instances: list[pydrake.multibody.tree.ModelInstanceIndex]) -> float: ...
    def CollectRegisteredGeometries(self, bodies: list[pydrake.multibody.tree.RigidBody]) -> pydrake.geometry.GeometrySet: ...
    def EvalBodyPoseInWorld(self, context: pydrake.systems.framework.Context, body: pydrake.multibody.tree.RigidBody) -> pydrake.math.RigidTransform: ...
    def EvalBodySpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context, body: pydrake.multibody.tree.RigidBody) -> pydrake.multibody.math.SpatialAcceleration: ...
    def EvalBodySpatialVelocityInWorld(self, context: pydrake.systems.framework.Context, body: pydrake.multibody.tree.RigidBody) -> pydrake.multibody.math.SpatialVelocity: ...
    def EvalSceneGraphInspector(self, context: pydrake.systems.framework.Context) -> pydrake.geometry.SceneGraphInspector: ...
    @overload
    def Finalize(self) -> None: ...
    @overload
    def Finalize(self) -> Any: ...
    @overload
    def Finalize(self) -> Any: ...
    @overload
    def Finalize(self) -> Any: ...
    def GetAccelerationLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetAccelerationUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetActuatedJointIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.JointIndex]: ...
    def GetActuationFromArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, u: numpy.ndarray[numpy.float64[m, 1]]) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetActuatorNames(self, add_model_instance_prefix: bool = ...) -> list[str]: ...
    @overload
    def GetActuatorNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ...) -> list[str]: ...
    def GetBodiesKinematicallyAffectedBy(self, joint_indexes: list[pydrake.multibody.tree.JointIndex]) -> list[pydrake.multibody.tree.BodyIndex]: ...
    def GetBodiesWeldedTo(self, body: pydrake.multibody.tree.RigidBody) -> list[pydrake.multibody.tree.RigidBody]: ...
    @overload
    def GetBodyByName(self, name: str) -> pydrake.multibody.tree.RigidBody: ...
    @overload
    def GetBodyByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody: ...
    def GetBodyFrameIdIfExists(self, body_index: pydrake.multibody.tree.BodyIndex) -> pydrake.geometry.FrameId | None: ...
    def GetBodyFrameIdOrThrow(self, body_index: pydrake.multibody.tree.BodyIndex) -> pydrake.geometry.FrameId: ...
    def GetBodyFromFrameId(self, arg0: pydrake.geometry.FrameId) -> pydrake.multibody.tree.RigidBody: ...
    def GetBodyIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.BodyIndex]: ...
    def GetCollisionGeometriesForBody(self, body: pydrake.multibody.tree.RigidBody) -> list[pydrake.geometry.GeometryId]: ...
    def GetConstraintActiveStatus(self, context: pydrake.systems.framework.Context, id: pydrake.multibody.tree.MultibodyConstraintId) -> bool: ...
    def GetConstraintIds(self) -> list[pydrake.multibody.tree.MultibodyConstraintId]: ...
    @staticmethod
    def GetDefaultContactSurfaceRepresentation(time_step: float) -> pydrake.geometry.HydroelasticContactRepresentation: ...
    def GetDefaultDistanceConstraintParams(self) -> dict[pydrake.multibody.tree.MultibodyConstraintId, DistanceConstraintParams]: ...
    def GetDefaultFloatingBaseBodyPose(self, body: pydrake.multibody.tree.RigidBody) -> pydrake.math.RigidTransform: ...
    def GetDefaultFreeBodyPose(self, body: pydrake.multibody.tree.RigidBody) -> pydrake.math.RigidTransform: ...
    @overload
    def GetDefaultPositions(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetDefaultPositions(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetDistanceConstraintParams(self, context: pydrake.systems.framework.Context) -> dict[pydrake.multibody.tree.MultibodyConstraintId, DistanceConstraintParams]: ...
    @overload
    def GetDistanceConstraintParams(self, context: pydrake.systems.framework.Context, id: pydrake.multibody.tree.MultibodyConstraintId) -> DistanceConstraintParams: ...
    def GetEffortLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetEffortUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetFloatingBaseBodies(self) -> set[pydrake.multibody.tree.BodyIndex]: ...
    @overload
    def GetFrameByName(self, name: str) -> pydrake.multibody.tree.Frame: ...
    @overload
    def GetFrameByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.Frame: ...
    def GetFrameIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.FrameIndex]: ...
    def GetFreeBodyPose(self, context: pydrake.systems.framework.Context, body: pydrake.multibody.tree.RigidBody) -> pydrake.math.RigidTransform: ...
    @overload
    def GetJointActuatorByName(self, name: str) -> pydrake.multibody.tree.JointActuator: ...
    @overload
    def GetJointActuatorByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.JointActuator: ...
    @overload
    def GetJointActuatorIndices(self) -> list[pydrake.multibody.tree.JointActuatorIndex]: ...
    @overload
    def GetJointActuatorIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.JointActuatorIndex]: ...
    def GetJointByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex | None = ...) -> pydrake.multibody.tree.Joint: ...
    @overload
    def GetJointIndices(self) -> list[pydrake.multibody.tree.JointIndex]: ...
    @overload
    def GetJointIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.JointIndex]: ...
    def GetModelInstanceByName(self, name: str) -> pydrake.multibody.tree.ModelInstanceIndex: ...
    def GetModelInstanceName(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> str: ...
    def GetMutableJointByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex | None = ...) -> pydrake.multibody.tree.Joint: ...
    def GetPositionLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetPositionNames(self, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    @overload
    def GetPositionNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    def GetPositionUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetPositions(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetPositions(self, context: pydrake.systems.framework.Context, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetPositionsAndVelocities(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetPositionsAndVelocities(self, context: pydrake.systems.framework.Context, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetPositionsFromArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q: numpy.ndarray[numpy.float64[m, 1]]) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetRigidBodyByName(self, name: str) -> pydrake.multibody.tree.RigidBody: ...
    @overload
    def GetRigidBodyByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody: ...
    @overload
    def GetStateNames(self, add_model_instance_prefix: bool = ...) -> list[str]: ...
    @overload
    def GetStateNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ...) -> list[str]: ...
    def GetTopologyGraphvizString(self) -> str: ...
    def GetUniqueFloatingBaseBodyOrThrow(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody: ...
    def GetUniqueFreeBaseBodyOrThrow(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody: ...
    @overload
    def GetVelocities(self, context: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetVelocities(self, context: pydrake.systems.framework.Context, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetVelocitiesFromArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, v: numpy.ndarray[numpy.float64[m, 1]]) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetVelocityLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetVelocityNames(self, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    @overload
    def GetVelocityNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    def GetVelocityUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetVisualGeometriesForBody(self, body: pydrake.multibody.tree.RigidBody) -> list[pydrake.geometry.GeometryId]: ...
    @overload
    def HasBodyNamed(self, name: str) -> bool: ...
    @overload
    def HasBodyNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    @overload
    def HasFrameNamed(self, name: str) -> bool: ...
    @overload
    def HasFrameNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    @overload
    def HasJointActuatorNamed(self, name: str) -> bool: ...
    @overload
    def HasJointActuatorNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    @overload
    def HasJointNamed(self, name: str) -> bool: ...
    @overload
    def HasJointNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def HasModelInstanceNamed(self, name: str) -> bool: ...
    def HasUniqueFloatingBaseBody(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def HasUniqueFreeBaseBody(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def IsAnchored(self, body: pydrake.multibody.tree.RigidBody) -> bool: ...
    def IsVelocityEqualToQDot(self) -> bool: ...
    def MakeActuationMatrix(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def MakeActuationMatrixPseudoinverse(self) -> scipy.sparse.csc_matrix[numpy.float64]: ...
    @overload
    def MakeActuatorSelectorMatrix(self, user_to_actuator_index_map: list[pydrake.multibody.tree.JointActuatorIndex]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def MakeActuatorSelectorMatrix(self, user_to_joint_index_map: list[pydrake.multibody.tree.JointIndex]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def MakeActuatorSelectorMatrix(self, conststd) -> Any: ...
    def MakeQDotToVelocityMap(self, context: pydrake.systems.framework.Context) -> scipy.sparse.csc_matrix[numpy.float64]: ...
    def MakeStateSelectorMatrix(self, user_to_joint_index_map: list[pydrake.multibody.tree.JointIndex]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def MakeVelocityToQDotMap(self, context: pydrake.systems.framework.Context) -> scipy.sparse.csc_matrix[numpy.float64]: ...
    @overload
    def MapQDotToVelocity(self, context: pydrake.systems.framework.Context, qdot: numpy.ndarray[numpy.float64[m, 1]]) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def MapQDotToVelocity(self) -> Any: ...
    @overload
    def MapVelocityToQDot(self, context: pydrake.systems.framework.Context, v: numpy.ndarray[numpy.float64[m, 1]]) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def MapVelocityToQDot(self) -> Any: ...
    def NumBodiesWithName(self, name: str) -> int: ...
    def RegisterAsSourceForSceneGraph(self, scene_graph: pydrake.geometry.SceneGraph) -> pydrake.geometry.SourceId: ...
    def RegisterCollisionGeometry(self, body: pydrake.multibody.tree.RigidBody, X_BG: pydrake.math.RigidTransform, shape: pydrake.geometry.Shape, name: str, properties: pydrake.geometry.ProximityProperties) -> pydrake.geometry.GeometryId: ...
    @overload
    def RegisterVisualGeometry(self, body: pydrake.multibody.tree.RigidBody, X_BG: pydrake.math.RigidTransform, shape: pydrake.geometry.Shape, name: str, diffuse_color: numpy.ndarray[numpy.float64[4, 1]]) -> pydrake.geometry.GeometryId: ...
    @overload
    def RegisterVisualGeometry(self, body: pydrake.multibody.tree.RigidBody, geometry_instance: pydrake.geometry.GeometryInstance) -> pydrake.geometry.GeometryId: ...
    def RemoveConstraint(self, id: pydrake.multibody.tree.MultibodyConstraintId) -> None: ...
    def RemoveJoint(self, joint: pydrake.multibody.tree.Joint) -> None: ...
    def RemoveJointActuator(self, actuator: pydrake.multibody.tree.JointActuator) -> None: ...
    def RenameModelInstance(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, name: str) -> None: ...
    def SetActuationInArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, u_instance: numpy.ndarray[numpy.float64[m, 1]], u: numpy.ndarray[numpy.float64[m, 1], flags.writeable] | None) -> None: ...
    def SetConstraintActiveStatus(self, context: pydrake.systems.framework.Context, id: pydrake.multibody.tree.MultibodyConstraintId, status: bool) -> None: ...
    def SetDefaultFloatingBaseBodyPose(self, body: pydrake.multibody.tree.RigidBody, X_WB: pydrake.math.RigidTransform) -> None: ...
    def SetDefaultFreeBodyPose(self, body: pydrake.multibody.tree.RigidBody, X_PB: pydrake.math.RigidTransform) -> None: ...
    @overload
    def SetDefaultPositions(self, q: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def SetDefaultPositions(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q_instance: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def SetDefaultState(self, context: pydrake.systems.framework.Context, state: pydrake.systems.framework.State) -> None: ...
    def SetDistanceConstraintParams(self, context: pydrake.systems.framework.Context, id: pydrake.multibody.tree.MultibodyConstraintId, params: DistanceConstraintParams) -> None: ...
    def SetFloatingBaseBodyPoseInAnchoredFrame(self, context: pydrake.systems.framework.Context, frame_F: pydrake.multibody.tree.Frame, body: pydrake.multibody.tree.RigidBody, X_FB: pydrake.math.RigidTransform) -> None: ...
    def SetFloatingBaseBodyPoseInWorldFrame(self, context: pydrake.systems.framework.Context, body: pydrake.multibody.tree.RigidBody, X_WB: pydrake.math.RigidTransform) -> None: ...
    def SetFreeBodyPose(self, context: pydrake.systems.framework.Context, body: pydrake.multibody.tree.RigidBody, X_JpJc: pydrake.math.RigidTransform) -> None: ...
    def SetFreeBodySpatialVelocity(self, context: pydrake.systems.framework.Context, body: pydrake.multibody.tree.RigidBody, V_JpJc: pydrake.multibody.math.SpatialVelocity) -> None: ...
    @overload
    def SetPositions(self, context: pydrake.systems.framework.Context, q: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def SetPositions(self, context: pydrake.systems.framework.Context, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def SetPositionsAndVelocities(self, context: pydrake.systems.framework.Context, q_v: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def SetPositionsAndVelocities(self, context: pydrake.systems.framework.Context, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q_v: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def SetPositionsInArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q_instance: numpy.ndarray[numpy.float64[m, 1]], q: numpy.ndarray[numpy.float64[m, 1], flags.writeable] | None) -> None: ...
    def SetUseSampledOutputPorts(self, use_sampled_output_ports: bool) -> None: ...
    @overload
    def SetVelocities(self, context: pydrake.systems.framework.Context, v: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def SetVelocities(self, context: pydrake.systems.framework.Context, model_instance: pydrake.multibody.tree.ModelInstanceIndex, v: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def SetVelocitiesInArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, v_instance: numpy.ndarray[numpy.float64[m, 1]], v: numpy.ndarray[numpy.float64[m, 1], flags.writeable] | None) -> None: ...
    def WeldFrames(self, frame_on_parent_F: pydrake.multibody.tree.Frame, frame_on_child_M: pydrake.multibody.tree.Frame, X_FM: pydrake.math.RigidTransform = ...) -> pydrake.multibody.tree.WeldJoint: ...
    def deformable_model(self) -> DeformableModel: ...
    def geometry_source_is_registered(self) -> bool: ...
    @overload
    def get_actuation_input_port(self) -> pydrake.systems.framework.InputPort: ...
    @overload
    def get_actuation_input_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.InputPort: ...
    def get_adjacent_bodies_collision_filters(self) -> bool: ...
    def get_applied_generalized_force_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_applied_spatial_force_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_body(self, body_index: pydrake.multibody.tree.BodyIndex) -> pydrake.multibody.tree.RigidBody: ...
    def get_body_poses_output_port(self, *args, **kwargs): ...
    def get_body_spatial_accelerations_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_body_spatial_velocities_output_port(self, *args, **kwargs): ...
    def get_contact_model(self) -> ContactModel: ...
    def get_contact_penalty_method_time_scale(self) -> float: ...
    def get_contact_results_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_contact_surface_representation(self) -> pydrake.geometry.HydroelasticContactRepresentation: ...
    def get_deformable_body_configuration_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    @overload
    def get_desired_state_input_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.InputPort: ...
    @overload
    def get_desired_state_input_port(self, model_instance) -> Any: ...
    def get_discrete_contact_approximation(self) -> DiscreteContactApproximation: ...
    def get_discrete_contact_solver(self) -> DiscreteContactSolver: ...
    def get_force_element(self, force_element_index: pydrake.multibody.tree.ForceElementIndex) -> pydrake.multibody.tree.ForceElement: ...
    def get_frame(self, frame_index: pydrake.multibody.tree.FrameIndex) -> pydrake.multibody.tree.Frame: ...
    def get_generalized_acceleration_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_generalized_contact_forces_output_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.OutputPort: ...
    def get_geometry_pose_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_geometry_query_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_joint(self, joint_index: pydrake.multibody.tree.JointIndex) -> pydrake.multibody.tree.Joint: ...
    def get_joint_actuator(self, actuator_index: pydrake.multibody.tree.JointActuatorIndex) -> pydrake.multibody.tree.JointActuator: ...
    def get_mutable_joint(self, joint_index: pydrake.multibody.tree.JointIndex) -> pydrake.multibody.tree.Joint: ...
    def get_mutable_joint_actuator(self, actuator_index: pydrake.multibody.tree.JointActuatorIndex) -> pydrake.multibody.tree.JointActuator: ...
    def get_net_actuation_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_reaction_forces_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_sap_near_rigid_threshold(self) -> float: ...
    def get_source_id(self) -> pydrake.geometry.SourceId | None: ...
    @overload
    def get_state_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    @overload
    def get_state_output_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.OutputPort: ...
    def gravity_field(self) -> pydrake.multibody.tree.UniformGravityFieldElement: ...
    def has_joint(self, joint_index: pydrake.multibody.tree.JointIndex) -> bool: ...
    def has_joint_actuator(self, actuator_index: pydrake.multibody.tree.JointActuatorIndex) -> bool: ...
    def has_sampled_output_ports(self) -> bool: ...
    def is_finalized(self) -> bool: ...
    def is_gravity_enabled(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def mutable_deformable_model(self) -> DeformableModel: ...
    def mutable_gravity_field(self) -> pydrake.multibody.tree.UniformGravityFieldElement: ...
    @overload
    def num_actuated_dofs(self) -> int: ...
    @overload
    def num_actuated_dofs(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    @overload
    def num_actuators(self) -> int: ...
    @overload
    def num_actuators(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    def num_bodies(self) -> int: ...
    def num_collision_geometries(self) -> int: ...
    def num_constraints(self) -> int: ...
    def num_force_elements(self) -> int: ...
    def num_frames(self) -> int: ...
    def num_joints(self) -> int: ...
    def num_model_instances(self) -> int: ...
    @overload
    def num_multibody_states(self) -> int: ...
    @overload
    def num_multibody_states(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    @overload
    def num_positions(self) -> int: ...
    @overload
    def num_positions(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    @overload
    def num_velocities(self) -> int: ...
    @overload
    def num_velocities(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    def set_adjacent_bodies_collision_filters(self, value: bool) -> None: ...
    def set_contact_model(self, model: ContactModel) -> None: ...
    def set_contact_surface_representation(self, surface_representation: pydrake.geometry.HydroelasticContactRepresentation) -> None: ...
    def set_discrete_contact_approximation(self, approximation: DiscreteContactApproximation) -> None: ...
    def set_gravity_enabled(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, is_enabled: bool) -> None: ...
    def set_penetration_allowance(self, penetration_allowance: float = ...) -> None: ...
    def set_sap_near_rigid_threshold(self, near_rigid_threshold: float = ...) -> None: ...
    def set_stiction_tolerance(self, v_stiction: float = ...) -> None: ...
    def time_step(self) -> float: ...
    def world_body(self) -> pydrake.multibody.tree.RigidBody: ...
    def world_frame(self) -> pydrake.multibody.tree.RigidBodyFrame: ...

class MultibodyPlantConfig:
    __fields__: ClassVar[tuple] = ...  # read-only
    adjacent_bodies_collision_filters: bool
    contact_model: str
    contact_surface_representation: str
    discrete_contact_approximation: str
    penetration_allowance: float
    sap_near_rigid_threshold: float
    stiction_tolerance: float
    time_step: float
    use_sampled_output_ports: bool
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> MultibodyPlantConfig: ...
    def __deepcopy__(self, arg0: dict) -> MultibodyPlantConfig: ...

class MultibodyPlant_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, time_step: float) -> None: ...
    def AddBallConstraint(self, body_A: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, p_AP: numpy.ndarray[numpy.float64[3, 1]], body_B: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, p_BQ: numpy.ndarray[numpy.float64[3, 1]] | None = ...) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def AddCouplerConstraint(self, joint0: pydrake.multibody.tree.Joint_TAutoDiffXdU, joint1: pydrake.multibody.tree.Joint_TAutoDiffXdU, gear_ratio: float, offset: float = ...) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def AddDistanceConstraint(self, body_A: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, p_AP: numpy.ndarray[numpy.float64[3, 1]], body_B: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, p_BQ: numpy.ndarray[numpy.float64[3, 1]], distance: float, stiffness: float = ..., damping: float = ...) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def AddForceElement(self, force_element: pydrake.multibody.tree.ForceElement_TAutoDiffXdU) -> pydrake.multibody.tree.ForceElement_TAutoDiffXdU: ...
    def AddFrame(self, frame: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> pydrake.multibody.tree.Frame_TAutoDiffXdU: ...
    def AddJoint(self, joint: pydrake.multibody.tree.Joint_TAutoDiffXdU) -> pydrake.multibody.tree.Joint_TAutoDiffXdU: ...
    def AddJointActuator(self, name: str, joint: pydrake.multibody.tree.Joint_TAutoDiffXdU, effort_limit: float = ...) -> pydrake.multibody.tree.JointActuator_TAutoDiffXdU: ...
    def AddModelInstance(self, name: str) -> pydrake.multibody.tree.ModelInstanceIndex: ...
    def AddRigidBody(self, name: str, M_BBo_B: pydrake.multibody.tree.SpatialInertia = ...) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    def AddWeldConstraint(self, body_A: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_AP: pydrake.math.RigidTransform, body_B: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_BQ: pydrake.math.RigidTransform) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def CalcBiasCenterOfMassTranslationalAcceleration(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_E: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcBiasSpatialAcceleration(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_BoBp_B: numpy.ndarray[object[3, 1]], frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_E: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> pydrake.multibody.math.SpatialAcceleration_TAutoDiffXdU: ...
    def CalcBiasTerm(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcBiasTranslationalAcceleration(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_BoBi_B: numpy.ndarray[object[3, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_E: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> numpy.ndarray[object[3, n]]: ...
    def CalcCenterOfMassPositionInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcCenterOfMassTranslationalAccelerationInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcCenterOfMassTranslationalVelocityInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcForceElementsContribution(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, forces: pydrake.multibody.tree.MultibodyForces_TAutoDiffXdU) -> None: ...
    def CalcGeneralizedForces(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, forces: pydrake.multibody.tree.MultibodyForces_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcGravityGeneralizedForces(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcInverseDynamics(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, known_vdot: numpy.ndarray[object[m, 1]], external_forces: pydrake.multibody.tree.MultibodyForces_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcJacobianAngularVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_E: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> numpy.ndarray[object[3, n]]: ...
    def CalcJacobianCenterOfMassTranslationalVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_E: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> numpy.ndarray[object[3, n]]: ...
    def CalcJacobianPositionVector(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_BoBi_B: numpy.ndarray[object[3, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_E: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> numpy.ndarray[object[m, n]]: ...
    def CalcJacobianSpatialVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_BoBp_B: numpy.ndarray[object[3, 1]], frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_E: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> numpy.ndarray[object[m, n]]: ...
    def CalcJacobianTranslationalVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_BoBi_B: numpy.ndarray[object[3, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_E: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> numpy.ndarray[object[m, n]]: ...
    def CalcMassMatrix(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, n]]: ...
    def CalcMassMatrixViaInverseDynamics(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, n]]: ...
    def CalcPointsPositions(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_BQi: numpy.ndarray[object[m, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> numpy.ndarray[object[m, n]]: ...
    def CalcPointsVelocities(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_BQi: numpy.ndarray[object[m, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_E: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> numpy.ndarray[object[m, n]]: ...
    def CalcRelativeRotationMatrix(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> pydrake.math.RotationMatrix_TAutoDiffXdU: ...
    def CalcRelativeTransform(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def CalcSpatialAccelerationsFromVdot(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, known_vdot: numpy.ndarray[object[m, 1]]) -> list[pydrake.multibody.math.SpatialAcceleration_TAutoDiffXdU]: ...
    def CalcSpatialInertia(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_F: pydrake.multibody.tree.Frame_TAutoDiffXdU, body_indexes: list[pydrake.multibody.tree.BodyIndex]) -> pydrake.multibody.tree.SpatialInertia_TAutoDiffXdU: ...
    def CalcSpatialMomentumInWorldAboutPoint(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, p_WoP_W: numpy.ndarray[object[3, 1]]) -> pydrake.multibody.math.SpatialMomentum_TAutoDiffXdU: ...
    @overload
    def CalcTotalMass(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    @overload
    def CalcTotalMass(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, model_instances: list[pydrake.multibody.tree.ModelInstanceIndex]) -> pydrake.autodiffutils.AutoDiffXd: ...
    def CollectRegisteredGeometries(self, bodies: list[pydrake.multibody.tree.RigidBody_TAutoDiffXdU]) -> pydrake.geometry.GeometrySet: ...
    def EvalBodyPoseInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def EvalBodySpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> pydrake.multibody.math.SpatialAcceleration_TAutoDiffXdU: ...
    def EvalBodySpatialVelocityInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> pydrake.multibody.math.SpatialVelocity_TAutoDiffXdU: ...
    def EvalSceneGraphInspector(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.geometry.SceneGraphInspector_TAutoDiffXdU: ...
    @overload
    def Finalize(self) -> None: ...
    @overload
    def Finalize(self) -> Any: ...
    @overload
    def Finalize(self) -> Any: ...
    @overload
    def Finalize(self) -> Any: ...
    def GetAccelerationLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetAccelerationUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetActuatedJointIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.JointIndex]: ...
    def GetActuationFromArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, u: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetActuatorNames(self, add_model_instance_prefix: bool = ...) -> list[str]: ...
    @overload
    def GetActuatorNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ...) -> list[str]: ...
    def GetBodiesKinematicallyAffectedBy(self, joint_indexes: list[pydrake.multibody.tree.JointIndex]) -> list[pydrake.multibody.tree.BodyIndex]: ...
    def GetBodiesWeldedTo(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> list[pydrake.multibody.tree.RigidBody_TAutoDiffXdU]: ...
    @overload
    def GetBodyByName(self, name: str) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    @overload
    def GetBodyByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    def GetBodyFrameIdIfExists(self, body_index: pydrake.multibody.tree.BodyIndex) -> pydrake.geometry.FrameId | None: ...
    def GetBodyFrameIdOrThrow(self, body_index: pydrake.multibody.tree.BodyIndex) -> pydrake.geometry.FrameId: ...
    def GetBodyFromFrameId(self, arg0: pydrake.geometry.FrameId) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    def GetBodyIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.BodyIndex]: ...
    def GetCollisionGeometriesForBody(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> list[pydrake.geometry.GeometryId]: ...
    def GetConstraintActiveStatus(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, id: pydrake.multibody.tree.MultibodyConstraintId) -> bool: ...
    def GetConstraintIds(self) -> list[pydrake.multibody.tree.MultibodyConstraintId]: ...
    @staticmethod
    def GetDefaultContactSurfaceRepresentation(time_step: float) -> pydrake.geometry.HydroelasticContactRepresentation: ...
    def GetDefaultDistanceConstraintParams(self) -> dict[pydrake.multibody.tree.MultibodyConstraintId, DistanceConstraintParams]: ...
    def GetDefaultFloatingBaseBodyPose(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> pydrake.math.RigidTransform: ...
    def GetDefaultFreeBodyPose(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> pydrake.math.RigidTransform: ...
    @overload
    def GetDefaultPositions(self) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetDefaultPositions(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetDistanceConstraintParams(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> dict[pydrake.multibody.tree.MultibodyConstraintId, DistanceConstraintParams]: ...
    @overload
    def GetDistanceConstraintParams(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, id: pydrake.multibody.tree.MultibodyConstraintId) -> DistanceConstraintParams: ...
    def GetEffortLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetEffortUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetFloatingBaseBodies(self) -> set[pydrake.multibody.tree.BodyIndex]: ...
    @overload
    def GetFrameByName(self, name: str) -> pydrake.multibody.tree.Frame_TAutoDiffXdU: ...
    @overload
    def GetFrameByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.Frame_TAutoDiffXdU: ...
    def GetFrameIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.FrameIndex]: ...
    def GetFreeBodyPose(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    @overload
    def GetJointActuatorByName(self, name: str) -> pydrake.multibody.tree.JointActuator_TAutoDiffXdU: ...
    @overload
    def GetJointActuatorByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.JointActuator_TAutoDiffXdU: ...
    @overload
    def GetJointActuatorIndices(self) -> list[pydrake.multibody.tree.JointActuatorIndex]: ...
    @overload
    def GetJointActuatorIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.JointActuatorIndex]: ...
    def GetJointByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex | None = ...) -> pydrake.multibody.tree.Joint_TAutoDiffXdU: ...
    @overload
    def GetJointIndices(self) -> list[pydrake.multibody.tree.JointIndex]: ...
    @overload
    def GetJointIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.JointIndex]: ...
    def GetModelInstanceByName(self, name: str) -> pydrake.multibody.tree.ModelInstanceIndex: ...
    def GetModelInstanceName(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> str: ...
    def GetMutableJointByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex | None = ...) -> pydrake.multibody.tree.Joint_TAutoDiffXdU: ...
    def GetPositionLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetPositionNames(self, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    @overload
    def GetPositionNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    def GetPositionUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetPositions(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetPositions(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetPositionsAndVelocities(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetPositionsAndVelocities(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[object[m, 1]]: ...
    def GetPositionsFromArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetRigidBodyByName(self, name: str) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    @overload
    def GetRigidBodyByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    @overload
    def GetStateNames(self, add_model_instance_prefix: bool = ...) -> list[str]: ...
    @overload
    def GetStateNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ...) -> list[str]: ...
    def GetTopologyGraphvizString(self) -> str: ...
    def GetUniqueFloatingBaseBodyOrThrow(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    def GetUniqueFreeBaseBodyOrThrow(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    @overload
    def GetVelocities(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetVelocities(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[object[m, 1]]: ...
    def GetVelocitiesFromArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, v: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    def GetVelocityLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetVelocityNames(self, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    @overload
    def GetVelocityNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    def GetVelocityUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetVisualGeometriesForBody(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> list[pydrake.geometry.GeometryId]: ...
    @overload
    def HasBodyNamed(self, name: str) -> bool: ...
    @overload
    def HasBodyNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    @overload
    def HasFrameNamed(self, name: str) -> bool: ...
    @overload
    def HasFrameNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    @overload
    def HasJointActuatorNamed(self, name: str) -> bool: ...
    @overload
    def HasJointActuatorNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    @overload
    def HasJointNamed(self, name: str) -> bool: ...
    @overload
    def HasJointNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def HasModelInstanceNamed(self, name: str) -> bool: ...
    def HasUniqueFloatingBaseBody(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def HasUniqueFreeBaseBody(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def IsAnchored(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> bool: ...
    def IsVelocityEqualToQDot(self) -> bool: ...
    def MakeActuationMatrix(self) -> numpy.ndarray[object[m, n]]: ...
    def MakeActuationMatrixPseudoinverse(self) -> scipy.sparse.csc_matrix[numpy.float64]: ...
    @overload
    def MakeActuatorSelectorMatrix(self, user_to_actuator_index_map: list[pydrake.multibody.tree.JointActuatorIndex]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def MakeActuatorSelectorMatrix(self, user_to_joint_index_map: list[pydrake.multibody.tree.JointIndex]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def MakeActuatorSelectorMatrix(self, conststd) -> Any: ...
    def MakeStateSelectorMatrix(self, user_to_joint_index_map: list[pydrake.multibody.tree.JointIndex]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def MapQDotToVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, qdot: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def MapQDotToVelocity(self) -> Any: ...
    @overload
    def MapVelocityToQDot(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, v: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def MapVelocityToQDot(self) -> Any: ...
    def NumBodiesWithName(self, name: str) -> int: ...
    def RegisterAsSourceForSceneGraph(self, scene_graph: pydrake.geometry.SceneGraph_TAutoDiffXdU) -> pydrake.geometry.SourceId: ...
    def RegisterCollisionGeometry(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_BG: pydrake.math.RigidTransform, shape: pydrake.geometry.Shape, name: str, properties: pydrake.geometry.ProximityProperties) -> pydrake.geometry.GeometryId: ...
    @overload
    def RegisterVisualGeometry(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_BG: pydrake.math.RigidTransform, shape: pydrake.geometry.Shape, name: str, diffuse_color: numpy.ndarray[numpy.float64[4, 1]]) -> pydrake.geometry.GeometryId: ...
    @overload
    def RegisterVisualGeometry(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, geometry_instance: pydrake.geometry.GeometryInstance) -> pydrake.geometry.GeometryId: ...
    def RemoveConstraint(self, id: pydrake.multibody.tree.MultibodyConstraintId) -> None: ...
    def RemoveJoint(self, joint: pydrake.multibody.tree.Joint_TAutoDiffXdU) -> None: ...
    def RemoveJointActuator(self, actuator: pydrake.multibody.tree.JointActuator_TAutoDiffXdU) -> None: ...
    def RenameModelInstance(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, name: str) -> None: ...
    def SetActuationInArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, u_instance: numpy.ndarray[object[m, 1]], u: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    def SetConstraintActiveStatus(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, id: pydrake.multibody.tree.MultibodyConstraintId, status: bool) -> None: ...
    def SetDefaultFloatingBaseBodyPose(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_WB: pydrake.math.RigidTransform) -> None: ...
    def SetDefaultFreeBodyPose(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_PB: pydrake.math.RigidTransform) -> None: ...
    @overload
    def SetDefaultPositions(self, q: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def SetDefaultPositions(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q_instance: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def SetDefaultState(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, state: pydrake.systems.framework.State_TAutoDiffXdU) -> None: ...
    def SetDistanceConstraintParams(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, id: pydrake.multibody.tree.MultibodyConstraintId, params: DistanceConstraintParams) -> None: ...
    def SetFloatingBaseBodyPoseInAnchoredFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_F: pydrake.multibody.tree.Frame_TAutoDiffXdU, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_FB: pydrake.math.RigidTransform_TAutoDiffXdU) -> None: ...
    def SetFloatingBaseBodyPoseInWorldFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_WB: pydrake.math.RigidTransform_TAutoDiffXdU) -> None: ...
    def SetFreeBodyPose(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_JpJc: pydrake.math.RigidTransform_TAutoDiffXdU) -> None: ...
    def SetFreeBodySpatialVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, V_JpJc: pydrake.multibody.math.SpatialVelocity_TAutoDiffXdU) -> None: ...
    @overload
    def SetPositions(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, q: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetPositions(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetPositionsAndVelocities(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, q_v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetPositionsAndVelocities(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q_v: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetPositionsInArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q_instance: numpy.ndarray[object[m, 1]], q: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    def SetUseSampledOutputPorts(self, use_sampled_output_ports: bool) -> None: ...
    @overload
    def SetVelocities(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetVelocities(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, model_instance: pydrake.multibody.tree.ModelInstanceIndex, v: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetVelocitiesInArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, v_instance: numpy.ndarray[object[m, 1]], v: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    def WeldFrames(self, frame_on_parent_F: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_on_child_M: pydrake.multibody.tree.Frame_TAutoDiffXdU, X_FM: pydrake.math.RigidTransform = ...) -> pydrake.multibody.tree.WeldJoint_TAutoDiffXdU: ...
    def deformable_model(self, *args, **kwargs): ...
    def geometry_source_is_registered(self) -> bool: ...
    @overload
    def get_actuation_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    @overload
    def get_actuation_input_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_adjacent_bodies_collision_filters(self) -> bool: ...
    def get_applied_generalized_force_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_applied_spatial_force_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_body(self, body_index: pydrake.multibody.tree.BodyIndex) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    def get_body_poses_output_port(self, *args, **kwargs): ...
    def get_body_spatial_accelerations_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_body_spatial_velocities_output_port(self, *args, **kwargs): ...
    def get_contact_model(self) -> ContactModel: ...
    def get_contact_penalty_method_time_scale(self) -> float: ...
    def get_contact_results_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_contact_surface_representation(self) -> pydrake.geometry.HydroelasticContactRepresentation: ...
    def get_deformable_body_configuration_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    @overload
    def get_desired_state_input_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    @overload
    def get_desired_state_input_port(self, model_instance) -> Any: ...
    def get_discrete_contact_approximation(self) -> DiscreteContactApproximation: ...
    def get_discrete_contact_solver(self) -> DiscreteContactSolver: ...
    def get_force_element(self, force_element_index: pydrake.multibody.tree.ForceElementIndex) -> pydrake.multibody.tree.ForceElement_TAutoDiffXdU: ...
    def get_frame(self, frame_index: pydrake.multibody.tree.FrameIndex) -> pydrake.multibody.tree.Frame_TAutoDiffXdU: ...
    def get_generalized_acceleration_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_generalized_contact_forces_output_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_geometry_pose_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_geometry_query_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_joint(self, joint_index: pydrake.multibody.tree.JointIndex) -> pydrake.multibody.tree.Joint_TAutoDiffXdU: ...
    def get_joint_actuator(self, actuator_index: pydrake.multibody.tree.JointActuatorIndex) -> pydrake.multibody.tree.JointActuator_TAutoDiffXdU: ...
    def get_mutable_joint(self, joint_index: pydrake.multibody.tree.JointIndex) -> pydrake.multibody.tree.Joint_TAutoDiffXdU: ...
    def get_mutable_joint_actuator(self, actuator_index: pydrake.multibody.tree.JointActuatorIndex) -> pydrake.multibody.tree.JointActuator_TAutoDiffXdU: ...
    def get_net_actuation_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_reaction_forces_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_sap_near_rigid_threshold(self) -> float: ...
    def get_source_id(self) -> pydrake.geometry.SourceId | None: ...
    @overload
    def get_state_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    @overload
    def get_state_output_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def gravity_field(self) -> pydrake.multibody.tree.UniformGravityFieldElement_TAutoDiffXdU: ...
    def has_joint(self, joint_index: pydrake.multibody.tree.JointIndex) -> bool: ...
    def has_joint_actuator(self, actuator_index: pydrake.multibody.tree.JointActuatorIndex) -> bool: ...
    def has_sampled_output_ports(self) -> bool: ...
    def is_finalized(self) -> bool: ...
    def is_gravity_enabled(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def mutable_deformable_model(self, *args, **kwargs): ...
    def mutable_gravity_field(self) -> pydrake.multibody.tree.UniformGravityFieldElement_TAutoDiffXdU: ...
    @overload
    def num_actuated_dofs(self) -> int: ...
    @overload
    def num_actuated_dofs(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    @overload
    def num_actuators(self) -> int: ...
    @overload
    def num_actuators(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    def num_bodies(self) -> int: ...
    def num_collision_geometries(self) -> int: ...
    def num_constraints(self) -> int: ...
    def num_force_elements(self) -> int: ...
    def num_frames(self) -> int: ...
    def num_joints(self) -> int: ...
    def num_model_instances(self) -> int: ...
    @overload
    def num_multibody_states(self) -> int: ...
    @overload
    def num_multibody_states(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    @overload
    def num_positions(self) -> int: ...
    @overload
    def num_positions(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    @overload
    def num_velocities(self) -> int: ...
    @overload
    def num_velocities(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    def set_adjacent_bodies_collision_filters(self, value: bool) -> None: ...
    def set_contact_model(self, model: ContactModel) -> None: ...
    def set_contact_surface_representation(self, surface_representation: pydrake.geometry.HydroelasticContactRepresentation) -> None: ...
    def set_discrete_contact_approximation(self, approximation: DiscreteContactApproximation) -> None: ...
    def set_gravity_enabled(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, is_enabled: bool) -> None: ...
    def set_penetration_allowance(self, penetration_allowance: float = ...) -> None: ...
    def set_sap_near_rigid_threshold(self, near_rigid_threshold: float = ...) -> None: ...
    def set_stiction_tolerance(self, v_stiction: float = ...) -> None: ...
    def time_step(self) -> float: ...
    def world_body(self) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    def world_frame(self) -> pydrake.multibody.tree.RigidBodyFrame_TAutoDiffXdU: ...

class MultibodyPlant_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, time_step: float) -> None: ...
    def AddBallConstraint(self, body_A: pydrake.multibody.tree.RigidBody_TExpressionU, p_AP: numpy.ndarray[numpy.float64[3, 1]], body_B: pydrake.multibody.tree.RigidBody_TExpressionU, p_BQ: numpy.ndarray[numpy.float64[3, 1]] | None = ...) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def AddCouplerConstraint(self, joint0: pydrake.multibody.tree.Joint_TExpressionU, joint1: pydrake.multibody.tree.Joint_TExpressionU, gear_ratio: float, offset: float = ...) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def AddDistanceConstraint(self, body_A: pydrake.multibody.tree.RigidBody_TExpressionU, p_AP: numpy.ndarray[numpy.float64[3, 1]], body_B: pydrake.multibody.tree.RigidBody_TExpressionU, p_BQ: numpy.ndarray[numpy.float64[3, 1]], distance: float, stiffness: float = ..., damping: float = ...) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def AddForceElement(self, force_element: pydrake.multibody.tree.ForceElement_TExpressionU) -> pydrake.multibody.tree.ForceElement_TExpressionU: ...
    def AddFrame(self, frame: pydrake.multibody.tree.Frame_TExpressionU) -> pydrake.multibody.tree.Frame_TExpressionU: ...
    def AddJoint(self, joint: pydrake.multibody.tree.Joint_TExpressionU) -> pydrake.multibody.tree.Joint_TExpressionU: ...
    def AddJointActuator(self, name: str, joint: pydrake.multibody.tree.Joint_TExpressionU, effort_limit: float = ...) -> pydrake.multibody.tree.JointActuator_TExpressionU: ...
    def AddModelInstance(self, name: str) -> pydrake.multibody.tree.ModelInstanceIndex: ...
    def AddRigidBody(self, name: str, M_BBo_B: pydrake.multibody.tree.SpatialInertia = ...) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    def AddWeldConstraint(self, body_A: pydrake.multibody.tree.RigidBody_TExpressionU, X_AP: pydrake.math.RigidTransform, body_B: pydrake.multibody.tree.RigidBody_TExpressionU, X_BQ: pydrake.math.RigidTransform) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def CalcBiasCenterOfMassTranslationalAcceleration(self, context: pydrake.systems.framework.Context_TExpressionU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_E: pydrake.multibody.tree.Frame_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcBiasSpatialAcceleration(self, context: pydrake.systems.framework.Context_TExpressionU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TExpressionU, p_BoBp_B: numpy.ndarray[object[3, 1]], frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_E: pydrake.multibody.tree.Frame_TExpressionU) -> pydrake.multibody.math.SpatialAcceleration_TExpressionU: ...
    def CalcBiasTerm(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcBiasTranslationalAcceleration(self, context: pydrake.systems.framework.Context_TExpressionU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TExpressionU, p_BoBi_B: numpy.ndarray[object[3, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_E: pydrake.multibody.tree.Frame_TExpressionU) -> numpy.ndarray[object[3, n]]: ...
    def CalcCenterOfMassPositionInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcCenterOfMassTranslationalAccelerationInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcCenterOfMassTranslationalVelocityInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcForceElementsContribution(self, context: pydrake.systems.framework.Context_TExpressionU, forces: pydrake.multibody.tree.MultibodyForces_TExpressionU) -> None: ...
    def CalcGeneralizedForces(self, context: pydrake.systems.framework.Context_TExpressionU, forces: pydrake.multibody.tree.MultibodyForces_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcGravityGeneralizedForces(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcInverseDynamics(self, context: pydrake.systems.framework.Context_TExpressionU, known_vdot: numpy.ndarray[object[m, 1]], external_forces: pydrake.multibody.tree.MultibodyForces_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcJacobianAngularVelocity(self, context: pydrake.systems.framework.Context_TExpressionU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TExpressionU, frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_E: pydrake.multibody.tree.Frame_TExpressionU) -> numpy.ndarray[object[3, n]]: ...
    def CalcJacobianCenterOfMassTranslationalVelocity(self, context: pydrake.systems.framework.Context_TExpressionU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_E: pydrake.multibody.tree.Frame_TExpressionU) -> numpy.ndarray[object[3, n]]: ...
    def CalcJacobianPositionVector(self, context: pydrake.systems.framework.Context_TExpressionU, frame_B: pydrake.multibody.tree.Frame_TExpressionU, p_BoBi_B: numpy.ndarray[object[3, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_E: pydrake.multibody.tree.Frame_TExpressionU) -> numpy.ndarray[object[m, n]]: ...
    def CalcJacobianSpatialVelocity(self, context: pydrake.systems.framework.Context_TExpressionU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TExpressionU, p_BoBp_B: numpy.ndarray[object[3, 1]], frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_E: pydrake.multibody.tree.Frame_TExpressionU) -> numpy.ndarray[object[m, n]]: ...
    def CalcJacobianTranslationalVelocity(self, context: pydrake.systems.framework.Context_TExpressionU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TExpressionU, p_BoBi_B: numpy.ndarray[object[3, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_E: pydrake.multibody.tree.Frame_TExpressionU) -> numpy.ndarray[object[m, n]]: ...
    def CalcMassMatrix(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, n]]: ...
    def CalcMassMatrixViaInverseDynamics(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, n]]: ...
    def CalcPointsPositions(self, context: pydrake.systems.framework.Context_TExpressionU, frame_B: pydrake.multibody.tree.Frame_TExpressionU, p_BQi: numpy.ndarray[object[m, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TExpressionU) -> numpy.ndarray[object[m, n]]: ...
    def CalcPointsVelocities(self, context: pydrake.systems.framework.Context_TExpressionU, frame_B: pydrake.multibody.tree.Frame_TExpressionU, p_BQi: numpy.ndarray[object[m, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_E: pydrake.multibody.tree.Frame_TExpressionU) -> numpy.ndarray[object[m, n]]: ...
    def CalcRelativeRotationMatrix(self, context: pydrake.systems.framework.Context_TExpressionU, frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_B: pydrake.multibody.tree.Frame_TExpressionU) -> pydrake.math.RotationMatrix_TExpressionU: ...
    def CalcRelativeTransform(self, context: pydrake.systems.framework.Context_TExpressionU, frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_B: pydrake.multibody.tree.Frame_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def CalcSpatialAccelerationsFromVdot(self, context: pydrake.systems.framework.Context_TExpressionU, known_vdot: numpy.ndarray[object[m, 1]]) -> list[pydrake.multibody.math.SpatialAcceleration_TExpressionU]: ...
    def CalcSpatialInertia(self, context: pydrake.systems.framework.Context_TExpressionU, frame_F: pydrake.multibody.tree.Frame_TExpressionU, body_indexes: list[pydrake.multibody.tree.BodyIndex]) -> pydrake.multibody.tree.SpatialInertia_TExpressionU: ...
    def CalcSpatialMomentumInWorldAboutPoint(self, context: pydrake.systems.framework.Context_TExpressionU, p_WoP_W: numpy.ndarray[object[3, 1]]) -> pydrake.multibody.math.SpatialMomentum_TExpressionU: ...
    @overload
    def CalcTotalMass(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    @overload
    def CalcTotalMass(self, context: pydrake.systems.framework.Context_TExpressionU, model_instances: list[pydrake.multibody.tree.ModelInstanceIndex]) -> pydrake.symbolic.Expression: ...
    def CollectRegisteredGeometries(self, bodies: list[pydrake.multibody.tree.RigidBody_TExpressionU]) -> pydrake.geometry.GeometrySet: ...
    def EvalBodyPoseInWorld(self, context: pydrake.systems.framework.Context_TExpressionU, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def EvalBodySpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context_TExpressionU, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> pydrake.multibody.math.SpatialAcceleration_TExpressionU: ...
    def EvalBodySpatialVelocityInWorld(self, context: pydrake.systems.framework.Context_TExpressionU, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> pydrake.multibody.math.SpatialVelocity_TExpressionU: ...
    def EvalSceneGraphInspector(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.geometry.SceneGraphInspector_TExpressionU: ...
    @overload
    def Finalize(self) -> None: ...
    @overload
    def Finalize(self) -> Any: ...
    @overload
    def Finalize(self) -> Any: ...
    @overload
    def Finalize(self) -> Any: ...
    def GetAccelerationLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetAccelerationUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetActuatedJointIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.JointIndex]: ...
    def GetActuationFromArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, u: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetActuatorNames(self, add_model_instance_prefix: bool = ...) -> list[str]: ...
    @overload
    def GetActuatorNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ...) -> list[str]: ...
    def GetBodiesKinematicallyAffectedBy(self, joint_indexes: list[pydrake.multibody.tree.JointIndex]) -> list[pydrake.multibody.tree.BodyIndex]: ...
    def GetBodiesWeldedTo(self, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> list[pydrake.multibody.tree.RigidBody_TExpressionU]: ...
    @overload
    def GetBodyByName(self, name: str) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    @overload
    def GetBodyByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    def GetBodyFrameIdIfExists(self, body_index: pydrake.multibody.tree.BodyIndex) -> pydrake.geometry.FrameId | None: ...
    def GetBodyFrameIdOrThrow(self, body_index: pydrake.multibody.tree.BodyIndex) -> pydrake.geometry.FrameId: ...
    def GetBodyFromFrameId(self, arg0: pydrake.geometry.FrameId) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    def GetBodyIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.BodyIndex]: ...
    def GetCollisionGeometriesForBody(self, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> list[pydrake.geometry.GeometryId]: ...
    def GetConstraintActiveStatus(self, context: pydrake.systems.framework.Context_TExpressionU, id: pydrake.multibody.tree.MultibodyConstraintId) -> bool: ...
    def GetConstraintIds(self) -> list[pydrake.multibody.tree.MultibodyConstraintId]: ...
    @staticmethod
    def GetDefaultContactSurfaceRepresentation(time_step: float) -> pydrake.geometry.HydroelasticContactRepresentation: ...
    def GetDefaultDistanceConstraintParams(self) -> dict[pydrake.multibody.tree.MultibodyConstraintId, DistanceConstraintParams]: ...
    def GetDefaultFloatingBaseBodyPose(self, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> pydrake.math.RigidTransform: ...
    def GetDefaultFreeBodyPose(self, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> pydrake.math.RigidTransform: ...
    @overload
    def GetDefaultPositions(self) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetDefaultPositions(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetDistanceConstraintParams(self, context: pydrake.systems.framework.Context_TExpressionU) -> dict[pydrake.multibody.tree.MultibodyConstraintId, DistanceConstraintParams]: ...
    @overload
    def GetDistanceConstraintParams(self, context: pydrake.systems.framework.Context_TExpressionU, id: pydrake.multibody.tree.MultibodyConstraintId) -> DistanceConstraintParams: ...
    def GetEffortLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetEffortUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetFloatingBaseBodies(self) -> set[pydrake.multibody.tree.BodyIndex]: ...
    @overload
    def GetFrameByName(self, name: str) -> pydrake.multibody.tree.Frame_TExpressionU: ...
    @overload
    def GetFrameByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.Frame_TExpressionU: ...
    def GetFrameIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.FrameIndex]: ...
    def GetFreeBodyPose(self, context: pydrake.systems.framework.Context_TExpressionU, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    @overload
    def GetJointActuatorByName(self, name: str) -> pydrake.multibody.tree.JointActuator_TExpressionU: ...
    @overload
    def GetJointActuatorByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.JointActuator_TExpressionU: ...
    @overload
    def GetJointActuatorIndices(self) -> list[pydrake.multibody.tree.JointActuatorIndex]: ...
    @overload
    def GetJointActuatorIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.JointActuatorIndex]: ...
    def GetJointByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex | None = ...) -> pydrake.multibody.tree.Joint_TExpressionU: ...
    @overload
    def GetJointIndices(self) -> list[pydrake.multibody.tree.JointIndex]: ...
    @overload
    def GetJointIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.JointIndex]: ...
    def GetModelInstanceByName(self, name: str) -> pydrake.multibody.tree.ModelInstanceIndex: ...
    def GetModelInstanceName(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> str: ...
    def GetMutableJointByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex | None = ...) -> pydrake.multibody.tree.Joint_TExpressionU: ...
    def GetPositionLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetPositionNames(self, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    @overload
    def GetPositionNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    def GetPositionUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetPositions(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetPositions(self, context: pydrake.systems.framework.Context_TExpressionU, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetPositionsAndVelocities(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetPositionsAndVelocities(self, context: pydrake.systems.framework.Context_TExpressionU, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[object[m, 1]]: ...
    def GetPositionsFromArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetRigidBodyByName(self, name: str) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    @overload
    def GetRigidBodyByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    @overload
    def GetStateNames(self, add_model_instance_prefix: bool = ...) -> list[str]: ...
    @overload
    def GetStateNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ...) -> list[str]: ...
    def GetTopologyGraphvizString(self) -> str: ...
    def GetUniqueFloatingBaseBodyOrThrow(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    def GetUniqueFreeBaseBodyOrThrow(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    @overload
    def GetVelocities(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetVelocities(self, context: pydrake.systems.framework.Context_TExpressionU, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[object[m, 1]]: ...
    def GetVelocitiesFromArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, v: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    def GetVelocityLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetVelocityNames(self, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    @overload
    def GetVelocityNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    def GetVelocityUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetVisualGeometriesForBody(self, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> list[pydrake.geometry.GeometryId]: ...
    @overload
    def HasBodyNamed(self, name: str) -> bool: ...
    @overload
    def HasBodyNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    @overload
    def HasFrameNamed(self, name: str) -> bool: ...
    @overload
    def HasFrameNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    @overload
    def HasJointActuatorNamed(self, name: str) -> bool: ...
    @overload
    def HasJointActuatorNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    @overload
    def HasJointNamed(self, name: str) -> bool: ...
    @overload
    def HasJointNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def HasModelInstanceNamed(self, name: str) -> bool: ...
    def HasUniqueFloatingBaseBody(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def HasUniqueFreeBaseBody(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def IsAnchored(self, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> bool: ...
    def IsVelocityEqualToQDot(self) -> bool: ...
    def MakeActuationMatrix(self) -> numpy.ndarray[object[m, n]]: ...
    def MakeActuationMatrixPseudoinverse(self) -> scipy.sparse.csc_matrix[numpy.float64]: ...
    @overload
    def MakeActuatorSelectorMatrix(self, user_to_actuator_index_map: list[pydrake.multibody.tree.JointActuatorIndex]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def MakeActuatorSelectorMatrix(self, user_to_joint_index_map: list[pydrake.multibody.tree.JointIndex]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def MakeActuatorSelectorMatrix(self, conststd) -> Any: ...
    def MakeStateSelectorMatrix(self, user_to_joint_index_map: list[pydrake.multibody.tree.JointIndex]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def MapQDotToVelocity(self, context: pydrake.systems.framework.Context_TExpressionU, qdot: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def MapQDotToVelocity(self) -> Any: ...
    @overload
    def MapVelocityToQDot(self, context: pydrake.systems.framework.Context_TExpressionU, v: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def MapVelocityToQDot(self) -> Any: ...
    def NumBodiesWithName(self, name: str) -> int: ...
    def RegisterAsSourceForSceneGraph(self, scene_graph: pydrake.geometry.SceneGraph_TExpressionU) -> pydrake.geometry.SourceId: ...
    def RegisterCollisionGeometry(self, body: pydrake.multibody.tree.RigidBody_TExpressionU, X_BG: pydrake.math.RigidTransform, shape: pydrake.geometry.Shape, name: str, properties: pydrake.geometry.ProximityProperties) -> pydrake.geometry.GeometryId: ...
    @overload
    def RegisterVisualGeometry(self, body: pydrake.multibody.tree.RigidBody_TExpressionU, X_BG: pydrake.math.RigidTransform, shape: pydrake.geometry.Shape, name: str, diffuse_color: numpy.ndarray[numpy.float64[4, 1]]) -> pydrake.geometry.GeometryId: ...
    @overload
    def RegisterVisualGeometry(self, body: pydrake.multibody.tree.RigidBody_TExpressionU, geometry_instance: pydrake.geometry.GeometryInstance) -> pydrake.geometry.GeometryId: ...
    def RemoveConstraint(self, id: pydrake.multibody.tree.MultibodyConstraintId) -> None: ...
    def RemoveJoint(self, joint: pydrake.multibody.tree.Joint_TExpressionU) -> None: ...
    def RemoveJointActuator(self, actuator: pydrake.multibody.tree.JointActuator_TExpressionU) -> None: ...
    def RenameModelInstance(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, name: str) -> None: ...
    def SetActuationInArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, u_instance: numpy.ndarray[object[m, 1]], u: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    def SetConstraintActiveStatus(self, context: pydrake.systems.framework.Context_TExpressionU, id: pydrake.multibody.tree.MultibodyConstraintId, status: bool) -> None: ...
    def SetDefaultFloatingBaseBodyPose(self, body: pydrake.multibody.tree.RigidBody_TExpressionU, X_WB: pydrake.math.RigidTransform) -> None: ...
    def SetDefaultFreeBodyPose(self, body: pydrake.multibody.tree.RigidBody_TExpressionU, X_PB: pydrake.math.RigidTransform) -> None: ...
    @overload
    def SetDefaultPositions(self, q: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def SetDefaultPositions(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q_instance: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def SetDefaultState(self, context: pydrake.systems.framework.Context_TExpressionU, state: pydrake.systems.framework.State_TExpressionU) -> None: ...
    def SetDistanceConstraintParams(self, context: pydrake.systems.framework.Context_TExpressionU, id: pydrake.multibody.tree.MultibodyConstraintId, params: DistanceConstraintParams) -> None: ...
    def SetFloatingBaseBodyPoseInAnchoredFrame(self, context: pydrake.systems.framework.Context_TExpressionU, frame_F: pydrake.multibody.tree.Frame_TExpressionU, body: pydrake.multibody.tree.RigidBody_TExpressionU, X_FB: pydrake.math.RigidTransform_TExpressionU) -> None: ...
    def SetFloatingBaseBodyPoseInWorldFrame(self, context: pydrake.systems.framework.Context_TExpressionU, body: pydrake.multibody.tree.RigidBody_TExpressionU, X_WB: pydrake.math.RigidTransform_TExpressionU) -> None: ...
    def SetFreeBodyPose(self, context: pydrake.systems.framework.Context_TExpressionU, body: pydrake.multibody.tree.RigidBody_TExpressionU, X_JpJc: pydrake.math.RigidTransform_TExpressionU) -> None: ...
    def SetFreeBodySpatialVelocity(self, context: pydrake.systems.framework.Context_TExpressionU, body: pydrake.multibody.tree.RigidBody_TExpressionU, V_JpJc: pydrake.multibody.math.SpatialVelocity_TExpressionU) -> None: ...
    @overload
    def SetPositions(self, context: pydrake.systems.framework.Context_TExpressionU, q: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetPositions(self, context: pydrake.systems.framework.Context_TExpressionU, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetPositionsAndVelocities(self, context: pydrake.systems.framework.Context_TExpressionU, q_v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetPositionsAndVelocities(self, context: pydrake.systems.framework.Context_TExpressionU, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q_v: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetPositionsInArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q_instance: numpy.ndarray[object[m, 1]], q: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    def SetUseSampledOutputPorts(self, use_sampled_output_ports: bool) -> None: ...
    @overload
    def SetVelocities(self, context: pydrake.systems.framework.Context_TExpressionU, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetVelocities(self, context: pydrake.systems.framework.Context_TExpressionU, model_instance: pydrake.multibody.tree.ModelInstanceIndex, v: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetVelocitiesInArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, v_instance: numpy.ndarray[object[m, 1]], v: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    def WeldFrames(self, frame_on_parent_F: pydrake.multibody.tree.Frame_TExpressionU, frame_on_child_M: pydrake.multibody.tree.Frame_TExpressionU, X_FM: pydrake.math.RigidTransform = ...) -> pydrake.multibody.tree.WeldJoint_TExpressionU: ...
    def deformable_model(self, *args, **kwargs): ...
    def geometry_source_is_registered(self) -> bool: ...
    @overload
    def get_actuation_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    @overload
    def get_actuation_input_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_adjacent_bodies_collision_filters(self) -> bool: ...
    def get_applied_generalized_force_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_applied_spatial_force_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_body(self, body_index: pydrake.multibody.tree.BodyIndex) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    def get_body_poses_output_port(self, *args, **kwargs): ...
    def get_body_spatial_accelerations_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_body_spatial_velocities_output_port(self, *args, **kwargs): ...
    def get_contact_model(self) -> ContactModel: ...
    def get_contact_penalty_method_time_scale(self) -> float: ...
    def get_contact_results_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_contact_surface_representation(self) -> pydrake.geometry.HydroelasticContactRepresentation: ...
    def get_deformable_body_configuration_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    @overload
    def get_desired_state_input_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    @overload
    def get_desired_state_input_port(self, model_instance) -> Any: ...
    def get_discrete_contact_approximation(self) -> DiscreteContactApproximation: ...
    def get_discrete_contact_solver(self) -> DiscreteContactSolver: ...
    def get_force_element(self, force_element_index: pydrake.multibody.tree.ForceElementIndex) -> pydrake.multibody.tree.ForceElement_TExpressionU: ...
    def get_frame(self, frame_index: pydrake.multibody.tree.FrameIndex) -> pydrake.multibody.tree.Frame_TExpressionU: ...
    def get_generalized_acceleration_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_generalized_contact_forces_output_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_geometry_pose_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_geometry_query_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_joint(self, joint_index: pydrake.multibody.tree.JointIndex) -> pydrake.multibody.tree.Joint_TExpressionU: ...
    def get_joint_actuator(self, actuator_index: pydrake.multibody.tree.JointActuatorIndex) -> pydrake.multibody.tree.JointActuator_TExpressionU: ...
    def get_mutable_joint(self, joint_index: pydrake.multibody.tree.JointIndex) -> pydrake.multibody.tree.Joint_TExpressionU: ...
    def get_mutable_joint_actuator(self, actuator_index: pydrake.multibody.tree.JointActuatorIndex) -> pydrake.multibody.tree.JointActuator_TExpressionU: ...
    def get_net_actuation_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_reaction_forces_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_sap_near_rigid_threshold(self) -> float: ...
    def get_source_id(self) -> pydrake.geometry.SourceId | None: ...
    @overload
    def get_state_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    @overload
    def get_state_output_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def gravity_field(self) -> pydrake.multibody.tree.UniformGravityFieldElement_TExpressionU: ...
    def has_joint(self, joint_index: pydrake.multibody.tree.JointIndex) -> bool: ...
    def has_joint_actuator(self, actuator_index: pydrake.multibody.tree.JointActuatorIndex) -> bool: ...
    def has_sampled_output_ports(self) -> bool: ...
    def is_finalized(self) -> bool: ...
    def is_gravity_enabled(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def mutable_deformable_model(self, *args, **kwargs): ...
    def mutable_gravity_field(self) -> pydrake.multibody.tree.UniformGravityFieldElement_TExpressionU: ...
    @overload
    def num_actuated_dofs(self) -> int: ...
    @overload
    def num_actuated_dofs(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    @overload
    def num_actuators(self) -> int: ...
    @overload
    def num_actuators(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    def num_bodies(self) -> int: ...
    def num_collision_geometries(self) -> int: ...
    def num_constraints(self) -> int: ...
    def num_force_elements(self) -> int: ...
    def num_frames(self) -> int: ...
    def num_joints(self) -> int: ...
    def num_model_instances(self) -> int: ...
    @overload
    def num_multibody_states(self) -> int: ...
    @overload
    def num_multibody_states(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    @overload
    def num_positions(self) -> int: ...
    @overload
    def num_positions(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    @overload
    def num_velocities(self) -> int: ...
    @overload
    def num_velocities(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    def set_adjacent_bodies_collision_filters(self, value: bool) -> None: ...
    def set_contact_model(self, model: ContactModel) -> None: ...
    def set_contact_surface_representation(self, surface_representation: pydrake.geometry.HydroelasticContactRepresentation) -> None: ...
    def set_discrete_contact_approximation(self, approximation: DiscreteContactApproximation) -> None: ...
    def set_gravity_enabled(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, is_enabled: bool) -> None: ...
    def set_penetration_allowance(self, penetration_allowance: float = ...) -> None: ...
    def set_sap_near_rigid_threshold(self, near_rigid_threshold: float = ...) -> None: ...
    def set_stiction_tolerance(self, v_stiction: float = ...) -> None: ...
    def time_step(self) -> float: ...
    def world_body(self) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    def world_frame(self) -> pydrake.multibody.tree.RigidBodyFrame_TExpressionU: ...

class PhysicalModel:
    def __init__(self, *args, **kwargs) -> None: ...

class PointPairContactInfo:
    def __init__(self, bodyA_index: pydrake.multibody.tree.BodyIndex, bodyB_index: pydrake.multibody.tree.BodyIndex, f_Bc_W: numpy.ndarray[numpy.float64[3, 1]], p_WC: numpy.ndarray[numpy.float64[3, 1]], separation_speed: float, slip_speed: float, point_pair: pydrake.geometry.PenetrationAsPointPair) -> None: ...
    def bodyA_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def bodyB_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def contact_force(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def contact_point(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    @overload
    def point_pair(self) -> pydrake.geometry.PenetrationAsPointPair: ...
    @overload
    def point_pair(self) -> Any: ...
    @overload
    def point_pair(self) -> Any: ...
    def separation_speed(self) -> float: ...
    def slip_speed(self) -> float: ...
    def __copy__(self) -> PointPairContactInfo: ...
    def __deepcopy__(self, arg0: dict) -> PointPairContactInfo: ...

class PointPairContactInfo_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, bodyA_index: pydrake.multibody.tree.BodyIndex, bodyB_index: pydrake.multibody.tree.BodyIndex, f_Bc_W: numpy.ndarray[object[3, 1]], p_WC: numpy.ndarray[object[3, 1]], separation_speed: pydrake.autodiffutils.AutoDiffXd, slip_speed: pydrake.autodiffutils.AutoDiffXd, point_pair: pydrake.geometry.PenetrationAsPointPair_TAutoDiffXdU) -> None: ...
    def bodyA_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def bodyB_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def contact_force(self) -> numpy.ndarray[object[3, 1]]: ...
    def contact_point(self) -> numpy.ndarray[object[3, 1]]: ...
    @overload
    def point_pair(self) -> pydrake.geometry.PenetrationAsPointPair_TAutoDiffXdU: ...
    @overload
    def point_pair(self) -> Any: ...
    @overload
    def point_pair(self) -> Any: ...
    def separation_speed(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def slip_speed(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def __copy__(self) -> PointPairContactInfo_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> PointPairContactInfo_TAutoDiffXdU: ...

class PointPairContactInfo_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, bodyA_index: pydrake.multibody.tree.BodyIndex, bodyB_index: pydrake.multibody.tree.BodyIndex, f_Bc_W: numpy.ndarray[object[3, 1]], p_WC: numpy.ndarray[object[3, 1]], separation_speed: pydrake.symbolic.Expression, slip_speed: pydrake.symbolic.Expression, point_pair: pydrake.geometry.PenetrationAsPointPair_TExpressionU) -> None: ...
    def bodyA_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def bodyB_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def contact_force(self) -> numpy.ndarray[object[3, 1]]: ...
    def contact_point(self) -> numpy.ndarray[object[3, 1]]: ...
    @overload
    def point_pair(self) -> pydrake.geometry.PenetrationAsPointPair_TExpressionU: ...
    @overload
    def point_pair(self) -> Any: ...
    @overload
    def point_pair(self) -> Any: ...
    def separation_speed(self) -> pydrake.symbolic.Expression: ...
    def slip_speed(self) -> pydrake.symbolic.Expression: ...
    def __copy__(self) -> PointPairContactInfo_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> PointPairContactInfo_TExpressionU: ...

class Propeller(pydrake.systems.framework.LeafSystem):
    @overload
    def __init__(self, body_index: pydrake.multibody.tree.BodyIndex, X_BP: pydrake.math.RigidTransform = ..., thrust_ratio: float = ..., moment_ratio: float = ...) -> None: ...
    @overload
    def __init__(self, propeller_info: list[PropellerInfo]) -> None: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_command_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_spatial_forces_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def num_propellers(self) -> int: ...

class PropellerInfo:
    X_BP: pydrake.math.RigidTransform
    body_index: pydrake.multibody.tree.BodyIndex
    moment_ratio: float
    thrust_ratio: float
    def __init__(self, body_index: pydrake.multibody.tree.BodyIndex, X_BP: pydrake.math.RigidTransform = ..., thrust_ratio: float = ..., moment_ratio: float = ...) -> None: ...
    def __copy__(self) -> PropellerInfo: ...
    def __deepcopy__(self, arg0: dict) -> PropellerInfo: ...

class Propeller_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, body_index: pydrake.multibody.tree.BodyIndex, X_BP: pydrake.math.RigidTransform = ..., thrust_ratio: float = ..., moment_ratio: float = ...) -> None: ...
    @overload
    def __init__(self, propeller_info: list[PropellerInfo]) -> None: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_command_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_spatial_forces_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def num_propellers(self) -> int: ...

class Propeller_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, body_index: pydrake.multibody.tree.BodyIndex, X_BP: pydrake.math.RigidTransform = ..., thrust_ratio: float = ..., moment_ratio: float = ...) -> None: ...
    @overload
    def __init__(self, propeller_info: list[PropellerInfo]) -> None: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_command_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_spatial_forces_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def num_propellers(self) -> int: ...

class Wing(pydrake.systems.framework.LeafSystem):
    def __init__(self, body_index: pydrake.multibody.tree.BodyIndex, surface_area: float, X_BodyWing: pydrake.math.RigidTransform = ..., fluid_density: float = ...) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder, plant: MultibodyPlant, body_index: pydrake.multibody.tree.BodyIndex, surface_area: float, X_BodyWing: pydrake.math.RigidTransform = ..., fluid_density: float = ...) -> Wing: ...
    def get_aerodynamic_center_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_body_spatial_velocities_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_fluid_density_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_spatial_force_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_wind_velocity_input_port(self) -> pydrake.systems.framework.InputPort: ...

class Wing_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, body_index: pydrake.multibody.tree.BodyIndex, surface_area: float, X_BodyWing: pydrake.math.RigidTransform = ..., fluid_density: float = ...) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder_TAutoDiffXdU, plant: MultibodyPlant_TAutoDiffXdU, body_index: pydrake.multibody.tree.BodyIndex, surface_area: float, X_BodyWing: pydrake.math.RigidTransform = ..., fluid_density: float = ...) -> Wing_TAutoDiffXdU: ...
    def get_aerodynamic_center_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_body_spatial_velocities_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_fluid_density_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_spatial_force_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_wind_velocity_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...

class Wing_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, body_index: pydrake.multibody.tree.BodyIndex, surface_area: float, X_BodyWing: pydrake.math.RigidTransform = ..., fluid_density: float = ...) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder_TExpressionU, plant: MultibodyPlant_TExpressionU, body_index: pydrake.multibody.tree.BodyIndex, surface_area: float, X_BodyWing: pydrake.math.RigidTransform = ..., fluid_density: float = ...) -> Wing_TExpressionU: ...
    def get_aerodynamic_center_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_body_spatial_velocities_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_fluid_density_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_spatial_force_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_wind_velocity_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...

class _TemporaryName_N5drake9multibody14ContactResultsIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def SelectHydroelastic(self, selector: Callable[[HydroelasticContactInfo_TAutoDiffXdU], bool]) -> ContactResults_TAutoDiffXdU: ...
    def deformable_contact_info(self, i: int) -> DeformableContactInfo_TAutoDiffXdU: ...
    def hydroelastic_contact_info(self, i: int) -> HydroelasticContactInfo_TAutoDiffXdU: ...
    def num_deformable_contacts(self) -> int: ...
    def num_hydroelastic_contacts(self) -> int: ...
    def num_point_pair_contacts(self) -> int: ...
    def plant(self, *args, **kwargs): ...
    def point_pair_contact_info(self, i: int) -> PointPairContactInfo_TAutoDiffXdU: ...
    def __copy__(self) -> ContactResults_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> ContactResults_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody14ContactResultsINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def SelectHydroelastic(self, selector: Callable[[HydroelasticContactInfo_TExpressionU], bool]) -> ContactResults_TExpressionU: ...
    def deformable_contact_info(self, i: int) -> DeformableContactInfo_TExpressionU: ...
    def hydroelastic_contact_info(self, i: int) -> HydroelasticContactInfo_TExpressionU: ...
    def num_deformable_contacts(self) -> int: ...
    def num_hydroelastic_contacts(self) -> int: ...
    def num_point_pair_contacts(self) -> int: ...
    def plant(self, *args, **kwargs): ...
    def point_pair_contact_info(self, i: int) -> PointPairContactInfo_TExpressionU: ...
    def __copy__(self) -> ContactResults_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> ContactResults_TExpressionU: ...

class _TemporaryName_N5drake9multibody14MultibodyPlantIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, time_step: float) -> None: ...
    def AddBallConstraint(self, body_A: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, p_AP: numpy.ndarray[numpy.float64[3, 1]], body_B: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, p_BQ: numpy.ndarray[numpy.float64[3, 1]] | None = ...) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def AddCouplerConstraint(self, joint0: pydrake.multibody.tree.Joint_TAutoDiffXdU, joint1: pydrake.multibody.tree.Joint_TAutoDiffXdU, gear_ratio: float, offset: float = ...) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def AddDistanceConstraint(self, body_A: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, p_AP: numpy.ndarray[numpy.float64[3, 1]], body_B: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, p_BQ: numpy.ndarray[numpy.float64[3, 1]], distance: float, stiffness: float = ..., damping: float = ...) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def AddForceElement(self, force_element: pydrake.multibody.tree.ForceElement_TAutoDiffXdU) -> pydrake.multibody.tree.ForceElement_TAutoDiffXdU: ...
    def AddFrame(self, frame: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> pydrake.multibody.tree.Frame_TAutoDiffXdU: ...
    def AddJoint(self, joint: pydrake.multibody.tree.Joint_TAutoDiffXdU) -> pydrake.multibody.tree.Joint_TAutoDiffXdU: ...
    def AddJointActuator(self, name: str, joint: pydrake.multibody.tree.Joint_TAutoDiffXdU, effort_limit: float = ...) -> pydrake.multibody.tree.JointActuator_TAutoDiffXdU: ...
    def AddModelInstance(self, name: str) -> pydrake.multibody.tree.ModelInstanceIndex: ...
    def AddRigidBody(self, name: str, M_BBo_B: pydrake.multibody.tree.SpatialInertia = ...) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    def AddWeldConstraint(self, body_A: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_AP: pydrake.math.RigidTransform, body_B: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_BQ: pydrake.math.RigidTransform) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def CalcBiasCenterOfMassTranslationalAcceleration(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_E: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcBiasSpatialAcceleration(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_BoBp_B: numpy.ndarray[object[3, 1]], frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_E: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> pydrake.multibody.math.SpatialAcceleration_TAutoDiffXdU: ...
    def CalcBiasTerm(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcBiasTranslationalAcceleration(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_BoBi_B: numpy.ndarray[object[3, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_E: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> numpy.ndarray[object[3, n]]: ...
    def CalcCenterOfMassPositionInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcCenterOfMassTranslationalAccelerationInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcCenterOfMassTranslationalVelocityInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcForceElementsContribution(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, forces: pydrake.multibody.tree.MultibodyForces_TAutoDiffXdU) -> None: ...
    def CalcGeneralizedForces(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, forces: pydrake.multibody.tree.MultibodyForces_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcGravityGeneralizedForces(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcInverseDynamics(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, known_vdot: numpy.ndarray[object[m, 1]], external_forces: pydrake.multibody.tree.MultibodyForces_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcJacobianAngularVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_E: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> numpy.ndarray[object[3, n]]: ...
    def CalcJacobianCenterOfMassTranslationalVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_E: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> numpy.ndarray[object[3, n]]: ...
    def CalcJacobianPositionVector(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_BoBi_B: numpy.ndarray[object[3, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_E: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> numpy.ndarray[object[m, n]]: ...
    def CalcJacobianSpatialVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_BoBp_B: numpy.ndarray[object[3, 1]], frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_E: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> numpy.ndarray[object[m, n]]: ...
    def CalcJacobianTranslationalVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_BoBi_B: numpy.ndarray[object[3, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_E: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> numpy.ndarray[object[m, n]]: ...
    def CalcMassMatrix(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, n]]: ...
    def CalcMassMatrixViaInverseDynamics(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, n]]: ...
    def CalcPointsPositions(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_BQi: numpy.ndarray[object[m, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> numpy.ndarray[object[m, n]]: ...
    def CalcPointsVelocities(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_BQi: numpy.ndarray[object[m, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_E: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> numpy.ndarray[object[m, n]]: ...
    def CalcRelativeRotationMatrix(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> pydrake.math.RotationMatrix_TAutoDiffXdU: ...
    def CalcRelativeTransform(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_A: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_B: pydrake.multibody.tree.Frame_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def CalcSpatialAccelerationsFromVdot(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, known_vdot: numpy.ndarray[object[m, 1]]) -> list[pydrake.multibody.math.SpatialAcceleration_TAutoDiffXdU]: ...
    def CalcSpatialInertia(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_F: pydrake.multibody.tree.Frame_TAutoDiffXdU, body_indexes: list[pydrake.multibody.tree.BodyIndex]) -> pydrake.multibody.tree.SpatialInertia_TAutoDiffXdU: ...
    def CalcSpatialMomentumInWorldAboutPoint(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, p_WoP_W: numpy.ndarray[object[3, 1]]) -> pydrake.multibody.math.SpatialMomentum_TAutoDiffXdU: ...
    @overload
    def CalcTotalMass(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    @overload
    def CalcTotalMass(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, model_instances: list[pydrake.multibody.tree.ModelInstanceIndex]) -> pydrake.autodiffutils.AutoDiffXd: ...
    def CollectRegisteredGeometries(self, bodies: list[pydrake.multibody.tree.RigidBody_TAutoDiffXdU]) -> pydrake.geometry.GeometrySet: ...
    def EvalBodyPoseInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def EvalBodySpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> pydrake.multibody.math.SpatialAcceleration_TAutoDiffXdU: ...
    def EvalBodySpatialVelocityInWorld(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> pydrake.multibody.math.SpatialVelocity_TAutoDiffXdU: ...
    def EvalSceneGraphInspector(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> pydrake.geometry.SceneGraphInspector_TAutoDiffXdU: ...
    @overload
    def Finalize(self) -> None: ...
    @overload
    def Finalize(self) -> Any: ...
    @overload
    def Finalize(self) -> Any: ...
    @overload
    def Finalize(self) -> Any: ...
    def GetAccelerationLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetAccelerationUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetActuatedJointIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.JointIndex]: ...
    def GetActuationFromArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, u: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetActuatorNames(self, add_model_instance_prefix: bool = ...) -> list[str]: ...
    @overload
    def GetActuatorNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ...) -> list[str]: ...
    def GetBodiesKinematicallyAffectedBy(self, joint_indexes: list[pydrake.multibody.tree.JointIndex]) -> list[pydrake.multibody.tree.BodyIndex]: ...
    def GetBodiesWeldedTo(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> list[pydrake.multibody.tree.RigidBody_TAutoDiffXdU]: ...
    @overload
    def GetBodyByName(self, name: str) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    @overload
    def GetBodyByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    def GetBodyFrameIdIfExists(self, body_index: pydrake.multibody.tree.BodyIndex) -> pydrake.geometry.FrameId | None: ...
    def GetBodyFrameIdOrThrow(self, body_index: pydrake.multibody.tree.BodyIndex) -> pydrake.geometry.FrameId: ...
    def GetBodyFromFrameId(self, arg0: pydrake.geometry.FrameId) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    def GetBodyIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.BodyIndex]: ...
    def GetCollisionGeometriesForBody(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> list[pydrake.geometry.GeometryId]: ...
    def GetConstraintActiveStatus(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, id: pydrake.multibody.tree.MultibodyConstraintId) -> bool: ...
    def GetConstraintIds(self) -> list[pydrake.multibody.tree.MultibodyConstraintId]: ...
    @staticmethod
    def GetDefaultContactSurfaceRepresentation(time_step: float) -> pydrake.geometry.HydroelasticContactRepresentation: ...
    def GetDefaultDistanceConstraintParams(self) -> dict[pydrake.multibody.tree.MultibodyConstraintId, DistanceConstraintParams]: ...
    def GetDefaultFloatingBaseBodyPose(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> pydrake.math.RigidTransform: ...
    def GetDefaultFreeBodyPose(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> pydrake.math.RigidTransform: ...
    @overload
    def GetDefaultPositions(self) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetDefaultPositions(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetDistanceConstraintParams(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> dict[pydrake.multibody.tree.MultibodyConstraintId, DistanceConstraintParams]: ...
    @overload
    def GetDistanceConstraintParams(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, id: pydrake.multibody.tree.MultibodyConstraintId) -> DistanceConstraintParams: ...
    def GetEffortLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetEffortUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetFloatingBaseBodies(self) -> set[pydrake.multibody.tree.BodyIndex]: ...
    @overload
    def GetFrameByName(self, name: str) -> pydrake.multibody.tree.Frame_TAutoDiffXdU: ...
    @overload
    def GetFrameByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.Frame_TAutoDiffXdU: ...
    def GetFrameIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.FrameIndex]: ...
    def GetFreeBodyPose(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    @overload
    def GetJointActuatorByName(self, name: str) -> pydrake.multibody.tree.JointActuator_TAutoDiffXdU: ...
    @overload
    def GetJointActuatorByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.JointActuator_TAutoDiffXdU: ...
    @overload
    def GetJointActuatorIndices(self) -> list[pydrake.multibody.tree.JointActuatorIndex]: ...
    @overload
    def GetJointActuatorIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.JointActuatorIndex]: ...
    def GetJointByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex | None = ...) -> pydrake.multibody.tree.Joint_TAutoDiffXdU: ...
    @overload
    def GetJointIndices(self) -> list[pydrake.multibody.tree.JointIndex]: ...
    @overload
    def GetJointIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.JointIndex]: ...
    def GetModelInstanceByName(self, name: str) -> pydrake.multibody.tree.ModelInstanceIndex: ...
    def GetModelInstanceName(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> str: ...
    def GetMutableJointByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex | None = ...) -> pydrake.multibody.tree.Joint_TAutoDiffXdU: ...
    def GetPositionLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetPositionNames(self, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    @overload
    def GetPositionNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    def GetPositionUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetPositions(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetPositions(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetPositionsAndVelocities(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetPositionsAndVelocities(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[object[m, 1]]: ...
    def GetPositionsFromArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetRigidBodyByName(self, name: str) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    @overload
    def GetRigidBodyByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    @overload
    def GetStateNames(self, add_model_instance_prefix: bool = ...) -> list[str]: ...
    @overload
    def GetStateNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ...) -> list[str]: ...
    def GetTopologyGraphvizString(self) -> str: ...
    def GetUniqueFloatingBaseBodyOrThrow(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    def GetUniqueFreeBaseBodyOrThrow(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    @overload
    def GetVelocities(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetVelocities(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[object[m, 1]]: ...
    def GetVelocitiesFromArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, v: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    def GetVelocityLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetVelocityNames(self, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    @overload
    def GetVelocityNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    def GetVelocityUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetVisualGeometriesForBody(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> list[pydrake.geometry.GeometryId]: ...
    @overload
    def HasBodyNamed(self, name: str) -> bool: ...
    @overload
    def HasBodyNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    @overload
    def HasFrameNamed(self, name: str) -> bool: ...
    @overload
    def HasFrameNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    @overload
    def HasJointActuatorNamed(self, name: str) -> bool: ...
    @overload
    def HasJointActuatorNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    @overload
    def HasJointNamed(self, name: str) -> bool: ...
    @overload
    def HasJointNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def HasModelInstanceNamed(self, name: str) -> bool: ...
    def HasUniqueFloatingBaseBody(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def HasUniqueFreeBaseBody(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def IsAnchored(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU) -> bool: ...
    def IsVelocityEqualToQDot(self) -> bool: ...
    def MakeActuationMatrix(self) -> numpy.ndarray[object[m, n]]: ...
    def MakeActuationMatrixPseudoinverse(self) -> scipy.sparse.csc_matrix[numpy.float64]: ...
    @overload
    def MakeActuatorSelectorMatrix(self, user_to_actuator_index_map: list[pydrake.multibody.tree.JointActuatorIndex]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def MakeActuatorSelectorMatrix(self, user_to_joint_index_map: list[pydrake.multibody.tree.JointIndex]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def MakeActuatorSelectorMatrix(self, conststd) -> Any: ...
    def MakeStateSelectorMatrix(self, user_to_joint_index_map: list[pydrake.multibody.tree.JointIndex]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def MapQDotToVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, qdot: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def MapQDotToVelocity(self) -> Any: ...
    @overload
    def MapVelocityToQDot(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, v: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def MapVelocityToQDot(self) -> Any: ...
    def NumBodiesWithName(self, name: str) -> int: ...
    def RegisterAsSourceForSceneGraph(self, scene_graph: pydrake.geometry.SceneGraph_TAutoDiffXdU) -> pydrake.geometry.SourceId: ...
    def RegisterCollisionGeometry(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_BG: pydrake.math.RigidTransform, shape: pydrake.geometry.Shape, name: str, properties: pydrake.geometry.ProximityProperties) -> pydrake.geometry.GeometryId: ...
    @overload
    def RegisterVisualGeometry(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_BG: pydrake.math.RigidTransform, shape: pydrake.geometry.Shape, name: str, diffuse_color: numpy.ndarray[numpy.float64[4, 1]]) -> pydrake.geometry.GeometryId: ...
    @overload
    def RegisterVisualGeometry(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, geometry_instance: pydrake.geometry.GeometryInstance) -> pydrake.geometry.GeometryId: ...
    def RemoveConstraint(self, id: pydrake.multibody.tree.MultibodyConstraintId) -> None: ...
    def RemoveJoint(self, joint: pydrake.multibody.tree.Joint_TAutoDiffXdU) -> None: ...
    def RemoveJointActuator(self, actuator: pydrake.multibody.tree.JointActuator_TAutoDiffXdU) -> None: ...
    def RenameModelInstance(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, name: str) -> None: ...
    def SetActuationInArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, u_instance: numpy.ndarray[object[m, 1]], u: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    def SetConstraintActiveStatus(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, id: pydrake.multibody.tree.MultibodyConstraintId, status: bool) -> None: ...
    def SetDefaultFloatingBaseBodyPose(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_WB: pydrake.math.RigidTransform) -> None: ...
    def SetDefaultFreeBodyPose(self, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_PB: pydrake.math.RigidTransform) -> None: ...
    @overload
    def SetDefaultPositions(self, q: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def SetDefaultPositions(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q_instance: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def SetDefaultState(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, state: pydrake.systems.framework.State_TAutoDiffXdU) -> None: ...
    def SetDistanceConstraintParams(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, id: pydrake.multibody.tree.MultibodyConstraintId, params: DistanceConstraintParams) -> None: ...
    def SetFloatingBaseBodyPoseInAnchoredFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, frame_F: pydrake.multibody.tree.Frame_TAutoDiffXdU, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_FB: pydrake.math.RigidTransform_TAutoDiffXdU) -> None: ...
    def SetFloatingBaseBodyPoseInWorldFrame(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_WB: pydrake.math.RigidTransform_TAutoDiffXdU) -> None: ...
    def SetFreeBodyPose(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, X_JpJc: pydrake.math.RigidTransform_TAutoDiffXdU) -> None: ...
    def SetFreeBodySpatialVelocity(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, body: pydrake.multibody.tree.RigidBody_TAutoDiffXdU, V_JpJc: pydrake.multibody.math.SpatialVelocity_TAutoDiffXdU) -> None: ...
    @overload
    def SetPositions(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, q: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetPositions(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetPositionsAndVelocities(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, q_v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetPositionsAndVelocities(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q_v: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetPositionsInArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q_instance: numpy.ndarray[object[m, 1]], q: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    def SetUseSampledOutputPorts(self, use_sampled_output_ports: bool) -> None: ...
    @overload
    def SetVelocities(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetVelocities(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, model_instance: pydrake.multibody.tree.ModelInstanceIndex, v: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetVelocitiesInArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, v_instance: numpy.ndarray[object[m, 1]], v: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    def WeldFrames(self, frame_on_parent_F: pydrake.multibody.tree.Frame_TAutoDiffXdU, frame_on_child_M: pydrake.multibody.tree.Frame_TAutoDiffXdU, X_FM: pydrake.math.RigidTransform = ...) -> pydrake.multibody.tree.WeldJoint_TAutoDiffXdU: ...
    def deformable_model(self, *args, **kwargs): ...
    def geometry_source_is_registered(self) -> bool: ...
    @overload
    def get_actuation_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    @overload
    def get_actuation_input_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_adjacent_bodies_collision_filters(self) -> bool: ...
    def get_applied_generalized_force_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_applied_spatial_force_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_body(self, body_index: pydrake.multibody.tree.BodyIndex) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    def get_body_poses_output_port(self, *args, **kwargs): ...
    def get_body_spatial_accelerations_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_body_spatial_velocities_output_port(self, *args, **kwargs): ...
    def get_contact_model(self) -> ContactModel: ...
    def get_contact_penalty_method_time_scale(self) -> float: ...
    def get_contact_results_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_contact_surface_representation(self) -> pydrake.geometry.HydroelasticContactRepresentation: ...
    def get_deformable_body_configuration_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    @overload
    def get_desired_state_input_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    @overload
    def get_desired_state_input_port(self, model_instance) -> Any: ...
    def get_discrete_contact_approximation(self) -> DiscreteContactApproximation: ...
    def get_discrete_contact_solver(self) -> DiscreteContactSolver: ...
    def get_force_element(self, force_element_index: pydrake.multibody.tree.ForceElementIndex) -> pydrake.multibody.tree.ForceElement_TAutoDiffXdU: ...
    def get_frame(self, frame_index: pydrake.multibody.tree.FrameIndex) -> pydrake.multibody.tree.Frame_TAutoDiffXdU: ...
    def get_generalized_acceleration_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_generalized_contact_forces_output_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_geometry_pose_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_geometry_query_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_joint(self, joint_index: pydrake.multibody.tree.JointIndex) -> pydrake.multibody.tree.Joint_TAutoDiffXdU: ...
    def get_joint_actuator(self, actuator_index: pydrake.multibody.tree.JointActuatorIndex) -> pydrake.multibody.tree.JointActuator_TAutoDiffXdU: ...
    def get_mutable_joint(self, joint_index: pydrake.multibody.tree.JointIndex) -> pydrake.multibody.tree.Joint_TAutoDiffXdU: ...
    def get_mutable_joint_actuator(self, actuator_index: pydrake.multibody.tree.JointActuatorIndex) -> pydrake.multibody.tree.JointActuator_TAutoDiffXdU: ...
    def get_net_actuation_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_reaction_forces_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_sap_near_rigid_threshold(self) -> float: ...
    def get_source_id(self) -> pydrake.geometry.SourceId | None: ...
    @overload
    def get_state_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    @overload
    def get_state_output_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def gravity_field(self) -> pydrake.multibody.tree.UniformGravityFieldElement_TAutoDiffXdU: ...
    def has_joint(self, joint_index: pydrake.multibody.tree.JointIndex) -> bool: ...
    def has_joint_actuator(self, actuator_index: pydrake.multibody.tree.JointActuatorIndex) -> bool: ...
    def has_sampled_output_ports(self) -> bool: ...
    def is_finalized(self) -> bool: ...
    def is_gravity_enabled(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def mutable_deformable_model(self, *args, **kwargs): ...
    def mutable_gravity_field(self) -> pydrake.multibody.tree.UniformGravityFieldElement_TAutoDiffXdU: ...
    @overload
    def num_actuated_dofs(self) -> int: ...
    @overload
    def num_actuated_dofs(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    @overload
    def num_actuators(self) -> int: ...
    @overload
    def num_actuators(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    def num_bodies(self) -> int: ...
    def num_collision_geometries(self) -> int: ...
    def num_constraints(self) -> int: ...
    def num_force_elements(self) -> int: ...
    def num_frames(self) -> int: ...
    def num_joints(self) -> int: ...
    def num_model_instances(self) -> int: ...
    @overload
    def num_multibody_states(self) -> int: ...
    @overload
    def num_multibody_states(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    @overload
    def num_positions(self) -> int: ...
    @overload
    def num_positions(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    @overload
    def num_velocities(self) -> int: ...
    @overload
    def num_velocities(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    def set_adjacent_bodies_collision_filters(self, value: bool) -> None: ...
    def set_contact_model(self, model: ContactModel) -> None: ...
    def set_contact_surface_representation(self, surface_representation: pydrake.geometry.HydroelasticContactRepresentation) -> None: ...
    def set_discrete_contact_approximation(self, approximation: DiscreteContactApproximation) -> None: ...
    def set_gravity_enabled(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, is_enabled: bool) -> None: ...
    def set_penetration_allowance(self, penetration_allowance: float = ...) -> None: ...
    def set_sap_near_rigid_threshold(self, near_rigid_threshold: float = ...) -> None: ...
    def set_stiction_tolerance(self, v_stiction: float = ...) -> None: ...
    def time_step(self) -> float: ...
    def world_body(self) -> pydrake.multibody.tree.RigidBody_TAutoDiffXdU: ...
    def world_frame(self) -> pydrake.multibody.tree.RigidBodyFrame_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody14MultibodyPlantINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, time_step: float) -> None: ...
    def AddBallConstraint(self, body_A: pydrake.multibody.tree.RigidBody_TExpressionU, p_AP: numpy.ndarray[numpy.float64[3, 1]], body_B: pydrake.multibody.tree.RigidBody_TExpressionU, p_BQ: numpy.ndarray[numpy.float64[3, 1]] | None = ...) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def AddCouplerConstraint(self, joint0: pydrake.multibody.tree.Joint_TExpressionU, joint1: pydrake.multibody.tree.Joint_TExpressionU, gear_ratio: float, offset: float = ...) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def AddDistanceConstraint(self, body_A: pydrake.multibody.tree.RigidBody_TExpressionU, p_AP: numpy.ndarray[numpy.float64[3, 1]], body_B: pydrake.multibody.tree.RigidBody_TExpressionU, p_BQ: numpy.ndarray[numpy.float64[3, 1]], distance: float, stiffness: float = ..., damping: float = ...) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def AddForceElement(self, force_element: pydrake.multibody.tree.ForceElement_TExpressionU) -> pydrake.multibody.tree.ForceElement_TExpressionU: ...
    def AddFrame(self, frame: pydrake.multibody.tree.Frame_TExpressionU) -> pydrake.multibody.tree.Frame_TExpressionU: ...
    def AddJoint(self, joint: pydrake.multibody.tree.Joint_TExpressionU) -> pydrake.multibody.tree.Joint_TExpressionU: ...
    def AddJointActuator(self, name: str, joint: pydrake.multibody.tree.Joint_TExpressionU, effort_limit: float = ...) -> pydrake.multibody.tree.JointActuator_TExpressionU: ...
    def AddModelInstance(self, name: str) -> pydrake.multibody.tree.ModelInstanceIndex: ...
    def AddRigidBody(self, name: str, M_BBo_B: pydrake.multibody.tree.SpatialInertia = ...) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    def AddWeldConstraint(self, body_A: pydrake.multibody.tree.RigidBody_TExpressionU, X_AP: pydrake.math.RigidTransform, body_B: pydrake.multibody.tree.RigidBody_TExpressionU, X_BQ: pydrake.math.RigidTransform) -> pydrake.multibody.tree.MultibodyConstraintId: ...
    def CalcBiasCenterOfMassTranslationalAcceleration(self, context: pydrake.systems.framework.Context_TExpressionU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_E: pydrake.multibody.tree.Frame_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcBiasSpatialAcceleration(self, context: pydrake.systems.framework.Context_TExpressionU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TExpressionU, p_BoBp_B: numpy.ndarray[object[3, 1]], frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_E: pydrake.multibody.tree.Frame_TExpressionU) -> pydrake.multibody.math.SpatialAcceleration_TExpressionU: ...
    def CalcBiasTerm(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcBiasTranslationalAcceleration(self, context: pydrake.systems.framework.Context_TExpressionU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TExpressionU, p_BoBi_B: numpy.ndarray[object[3, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_E: pydrake.multibody.tree.Frame_TExpressionU) -> numpy.ndarray[object[3, n]]: ...
    def CalcCenterOfMassPositionInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcCenterOfMassTranslationalAccelerationInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcCenterOfMassTranslationalVelocityInWorld(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[3, 1]]: ...
    def CalcForceElementsContribution(self, context: pydrake.systems.framework.Context_TExpressionU, forces: pydrake.multibody.tree.MultibodyForces_TExpressionU) -> None: ...
    def CalcGeneralizedForces(self, context: pydrake.systems.framework.Context_TExpressionU, forces: pydrake.multibody.tree.MultibodyForces_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcGravityGeneralizedForces(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcInverseDynamics(self, context: pydrake.systems.framework.Context_TExpressionU, known_vdot: numpy.ndarray[object[m, 1]], external_forces: pydrake.multibody.tree.MultibodyForces_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    def CalcJacobianAngularVelocity(self, context: pydrake.systems.framework.Context_TExpressionU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TExpressionU, frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_E: pydrake.multibody.tree.Frame_TExpressionU) -> numpy.ndarray[object[3, n]]: ...
    def CalcJacobianCenterOfMassTranslationalVelocity(self, context: pydrake.systems.framework.Context_TExpressionU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_E: pydrake.multibody.tree.Frame_TExpressionU) -> numpy.ndarray[object[3, n]]: ...
    def CalcJacobianPositionVector(self, context: pydrake.systems.framework.Context_TExpressionU, frame_B: pydrake.multibody.tree.Frame_TExpressionU, p_BoBi_B: numpy.ndarray[object[3, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_E: pydrake.multibody.tree.Frame_TExpressionU) -> numpy.ndarray[object[m, n]]: ...
    def CalcJacobianSpatialVelocity(self, context: pydrake.systems.framework.Context_TExpressionU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TExpressionU, p_BoBp_B: numpy.ndarray[object[3, 1]], frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_E: pydrake.multibody.tree.Frame_TExpressionU) -> numpy.ndarray[object[m, n]]: ...
    def CalcJacobianTranslationalVelocity(self, context: pydrake.systems.framework.Context_TExpressionU, with_respect_to: pydrake.multibody.tree.JacobianWrtVariable, frame_B: pydrake.multibody.tree.Frame_TExpressionU, p_BoBi_B: numpy.ndarray[object[3, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_E: pydrake.multibody.tree.Frame_TExpressionU) -> numpy.ndarray[object[m, n]]: ...
    def CalcMassMatrix(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, n]]: ...
    def CalcMassMatrixViaInverseDynamics(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, n]]: ...
    def CalcPointsPositions(self, context: pydrake.systems.framework.Context_TExpressionU, frame_B: pydrake.multibody.tree.Frame_TExpressionU, p_BQi: numpy.ndarray[object[m, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TExpressionU) -> numpy.ndarray[object[m, n]]: ...
    def CalcPointsVelocities(self, context: pydrake.systems.framework.Context_TExpressionU, frame_B: pydrake.multibody.tree.Frame_TExpressionU, p_BQi: numpy.ndarray[object[m, n], flags.f_contiguous], frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_E: pydrake.multibody.tree.Frame_TExpressionU) -> numpy.ndarray[object[m, n]]: ...
    def CalcRelativeRotationMatrix(self, context: pydrake.systems.framework.Context_TExpressionU, frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_B: pydrake.multibody.tree.Frame_TExpressionU) -> pydrake.math.RotationMatrix_TExpressionU: ...
    def CalcRelativeTransform(self, context: pydrake.systems.framework.Context_TExpressionU, frame_A: pydrake.multibody.tree.Frame_TExpressionU, frame_B: pydrake.multibody.tree.Frame_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def CalcSpatialAccelerationsFromVdot(self, context: pydrake.systems.framework.Context_TExpressionU, known_vdot: numpy.ndarray[object[m, 1]]) -> list[pydrake.multibody.math.SpatialAcceleration_TExpressionU]: ...
    def CalcSpatialInertia(self, context: pydrake.systems.framework.Context_TExpressionU, frame_F: pydrake.multibody.tree.Frame_TExpressionU, body_indexes: list[pydrake.multibody.tree.BodyIndex]) -> pydrake.multibody.tree.SpatialInertia_TExpressionU: ...
    def CalcSpatialMomentumInWorldAboutPoint(self, context: pydrake.systems.framework.Context_TExpressionU, p_WoP_W: numpy.ndarray[object[3, 1]]) -> pydrake.multibody.math.SpatialMomentum_TExpressionU: ...
    @overload
    def CalcTotalMass(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.symbolic.Expression: ...
    @overload
    def CalcTotalMass(self, context: pydrake.systems.framework.Context_TExpressionU, model_instances: list[pydrake.multibody.tree.ModelInstanceIndex]) -> pydrake.symbolic.Expression: ...
    def CollectRegisteredGeometries(self, bodies: list[pydrake.multibody.tree.RigidBody_TExpressionU]) -> pydrake.geometry.GeometrySet: ...
    def EvalBodyPoseInWorld(self, context: pydrake.systems.framework.Context_TExpressionU, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    def EvalBodySpatialAccelerationInWorld(self, context: pydrake.systems.framework.Context_TExpressionU, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> pydrake.multibody.math.SpatialAcceleration_TExpressionU: ...
    def EvalBodySpatialVelocityInWorld(self, context: pydrake.systems.framework.Context_TExpressionU, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> pydrake.multibody.math.SpatialVelocity_TExpressionU: ...
    def EvalSceneGraphInspector(self, context: pydrake.systems.framework.Context_TExpressionU) -> pydrake.geometry.SceneGraphInspector_TExpressionU: ...
    @overload
    def Finalize(self) -> None: ...
    @overload
    def Finalize(self) -> Any: ...
    @overload
    def Finalize(self) -> Any: ...
    @overload
    def Finalize(self) -> Any: ...
    def GetAccelerationLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetAccelerationUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetActuatedJointIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.JointIndex]: ...
    def GetActuationFromArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, u: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetActuatorNames(self, add_model_instance_prefix: bool = ...) -> list[str]: ...
    @overload
    def GetActuatorNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ...) -> list[str]: ...
    def GetBodiesKinematicallyAffectedBy(self, joint_indexes: list[pydrake.multibody.tree.JointIndex]) -> list[pydrake.multibody.tree.BodyIndex]: ...
    def GetBodiesWeldedTo(self, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> list[pydrake.multibody.tree.RigidBody_TExpressionU]: ...
    @overload
    def GetBodyByName(self, name: str) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    @overload
    def GetBodyByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    def GetBodyFrameIdIfExists(self, body_index: pydrake.multibody.tree.BodyIndex) -> pydrake.geometry.FrameId | None: ...
    def GetBodyFrameIdOrThrow(self, body_index: pydrake.multibody.tree.BodyIndex) -> pydrake.geometry.FrameId: ...
    def GetBodyFromFrameId(self, arg0: pydrake.geometry.FrameId) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    def GetBodyIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.BodyIndex]: ...
    def GetCollisionGeometriesForBody(self, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> list[pydrake.geometry.GeometryId]: ...
    def GetConstraintActiveStatus(self, context: pydrake.systems.framework.Context_TExpressionU, id: pydrake.multibody.tree.MultibodyConstraintId) -> bool: ...
    def GetConstraintIds(self) -> list[pydrake.multibody.tree.MultibodyConstraintId]: ...
    @staticmethod
    def GetDefaultContactSurfaceRepresentation(time_step: float) -> pydrake.geometry.HydroelasticContactRepresentation: ...
    def GetDefaultDistanceConstraintParams(self) -> dict[pydrake.multibody.tree.MultibodyConstraintId, DistanceConstraintParams]: ...
    def GetDefaultFloatingBaseBodyPose(self, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> pydrake.math.RigidTransform: ...
    def GetDefaultFreeBodyPose(self, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> pydrake.math.RigidTransform: ...
    @overload
    def GetDefaultPositions(self) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetDefaultPositions(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetDistanceConstraintParams(self, context: pydrake.systems.framework.Context_TExpressionU) -> dict[pydrake.multibody.tree.MultibodyConstraintId, DistanceConstraintParams]: ...
    @overload
    def GetDistanceConstraintParams(self, context: pydrake.systems.framework.Context_TExpressionU, id: pydrake.multibody.tree.MultibodyConstraintId) -> DistanceConstraintParams: ...
    def GetEffortLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetEffortUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetFloatingBaseBodies(self) -> set[pydrake.multibody.tree.BodyIndex]: ...
    @overload
    def GetFrameByName(self, name: str) -> pydrake.multibody.tree.Frame_TExpressionU: ...
    @overload
    def GetFrameByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.Frame_TExpressionU: ...
    def GetFrameIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.FrameIndex]: ...
    def GetFreeBodyPose(self, context: pydrake.systems.framework.Context_TExpressionU, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> pydrake.math.RigidTransform_TExpressionU: ...
    @overload
    def GetJointActuatorByName(self, name: str) -> pydrake.multibody.tree.JointActuator_TExpressionU: ...
    @overload
    def GetJointActuatorByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.JointActuator_TExpressionU: ...
    @overload
    def GetJointActuatorIndices(self) -> list[pydrake.multibody.tree.JointActuatorIndex]: ...
    @overload
    def GetJointActuatorIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.JointActuatorIndex]: ...
    def GetJointByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex | None = ...) -> pydrake.multibody.tree.Joint_TExpressionU: ...
    @overload
    def GetJointIndices(self) -> list[pydrake.multibody.tree.JointIndex]: ...
    @overload
    def GetJointIndices(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> list[pydrake.multibody.tree.JointIndex]: ...
    def GetModelInstanceByName(self, name: str) -> pydrake.multibody.tree.ModelInstanceIndex: ...
    def GetModelInstanceName(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> str: ...
    def GetMutableJointByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex | None = ...) -> pydrake.multibody.tree.Joint_TExpressionU: ...
    def GetPositionLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetPositionNames(self, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    @overload
    def GetPositionNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    def GetPositionUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetPositions(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetPositions(self, context: pydrake.systems.framework.Context_TExpressionU, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetPositionsAndVelocities(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetPositionsAndVelocities(self, context: pydrake.systems.framework.Context_TExpressionU, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[object[m, 1]]: ...
    def GetPositionsFromArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetRigidBodyByName(self, name: str) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    @overload
    def GetRigidBodyByName(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    @overload
    def GetStateNames(self, add_model_instance_prefix: bool = ...) -> list[str]: ...
    @overload
    def GetStateNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ...) -> list[str]: ...
    def GetTopologyGraphvizString(self) -> str: ...
    def GetUniqueFloatingBaseBodyOrThrow(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    def GetUniqueFreeBaseBodyOrThrow(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    @overload
    def GetVelocities(self, context: pydrake.systems.framework.Context_TExpressionU) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def GetVelocities(self, context: pydrake.systems.framework.Context_TExpressionU, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> numpy.ndarray[object[m, 1]]: ...
    def GetVelocitiesFromArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, v: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    def GetVelocityLowerLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def GetVelocityNames(self, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    @overload
    def GetVelocityNames(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, add_model_instance_prefix: bool = ..., always_add_suffix: bool = ...) -> list[str]: ...
    def GetVelocityUpperLimits(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetVisualGeometriesForBody(self, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> list[pydrake.geometry.GeometryId]: ...
    @overload
    def HasBodyNamed(self, name: str) -> bool: ...
    @overload
    def HasBodyNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    @overload
    def HasFrameNamed(self, name: str) -> bool: ...
    @overload
    def HasFrameNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    @overload
    def HasJointActuatorNamed(self, name: str) -> bool: ...
    @overload
    def HasJointActuatorNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    @overload
    def HasJointNamed(self, name: str) -> bool: ...
    @overload
    def HasJointNamed(self, name: str, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def HasModelInstanceNamed(self, name: str) -> bool: ...
    def HasUniqueFloatingBaseBody(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def HasUniqueFreeBaseBody(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def IsAnchored(self, body: pydrake.multibody.tree.RigidBody_TExpressionU) -> bool: ...
    def IsVelocityEqualToQDot(self) -> bool: ...
    def MakeActuationMatrix(self) -> numpy.ndarray[object[m, n]]: ...
    def MakeActuationMatrixPseudoinverse(self) -> scipy.sparse.csc_matrix[numpy.float64]: ...
    @overload
    def MakeActuatorSelectorMatrix(self, user_to_actuator_index_map: list[pydrake.multibody.tree.JointActuatorIndex]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def MakeActuatorSelectorMatrix(self, user_to_joint_index_map: list[pydrake.multibody.tree.JointIndex]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def MakeActuatorSelectorMatrix(self, conststd) -> Any: ...
    def MakeStateSelectorMatrix(self, user_to_joint_index_map: list[pydrake.multibody.tree.JointIndex]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def MapQDotToVelocity(self, context: pydrake.systems.framework.Context_TExpressionU, qdot: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def MapQDotToVelocity(self) -> Any: ...
    @overload
    def MapVelocityToQDot(self, context: pydrake.systems.framework.Context_TExpressionU, v: numpy.ndarray[object[m, 1]]) -> numpy.ndarray[object[m, 1]]: ...
    @overload
    def MapVelocityToQDot(self) -> Any: ...
    def NumBodiesWithName(self, name: str) -> int: ...
    def RegisterAsSourceForSceneGraph(self, scene_graph: pydrake.geometry.SceneGraph_TExpressionU) -> pydrake.geometry.SourceId: ...
    def RegisterCollisionGeometry(self, body: pydrake.multibody.tree.RigidBody_TExpressionU, X_BG: pydrake.math.RigidTransform, shape: pydrake.geometry.Shape, name: str, properties: pydrake.geometry.ProximityProperties) -> pydrake.geometry.GeometryId: ...
    @overload
    def RegisterVisualGeometry(self, body: pydrake.multibody.tree.RigidBody_TExpressionU, X_BG: pydrake.math.RigidTransform, shape: pydrake.geometry.Shape, name: str, diffuse_color: numpy.ndarray[numpy.float64[4, 1]]) -> pydrake.geometry.GeometryId: ...
    @overload
    def RegisterVisualGeometry(self, body: pydrake.multibody.tree.RigidBody_TExpressionU, geometry_instance: pydrake.geometry.GeometryInstance) -> pydrake.geometry.GeometryId: ...
    def RemoveConstraint(self, id: pydrake.multibody.tree.MultibodyConstraintId) -> None: ...
    def RemoveJoint(self, joint: pydrake.multibody.tree.Joint_TExpressionU) -> None: ...
    def RemoveJointActuator(self, actuator: pydrake.multibody.tree.JointActuator_TExpressionU) -> None: ...
    def RenameModelInstance(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, name: str) -> None: ...
    def SetActuationInArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, u_instance: numpy.ndarray[object[m, 1]], u: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    def SetConstraintActiveStatus(self, context: pydrake.systems.framework.Context_TExpressionU, id: pydrake.multibody.tree.MultibodyConstraintId, status: bool) -> None: ...
    def SetDefaultFloatingBaseBodyPose(self, body: pydrake.multibody.tree.RigidBody_TExpressionU, X_WB: pydrake.math.RigidTransform) -> None: ...
    def SetDefaultFreeBodyPose(self, body: pydrake.multibody.tree.RigidBody_TExpressionU, X_PB: pydrake.math.RigidTransform) -> None: ...
    @overload
    def SetDefaultPositions(self, q: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def SetDefaultPositions(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q_instance: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def SetDefaultState(self, context: pydrake.systems.framework.Context_TExpressionU, state: pydrake.systems.framework.State_TExpressionU) -> None: ...
    def SetDistanceConstraintParams(self, context: pydrake.systems.framework.Context_TExpressionU, id: pydrake.multibody.tree.MultibodyConstraintId, params: DistanceConstraintParams) -> None: ...
    def SetFloatingBaseBodyPoseInAnchoredFrame(self, context: pydrake.systems.framework.Context_TExpressionU, frame_F: pydrake.multibody.tree.Frame_TExpressionU, body: pydrake.multibody.tree.RigidBody_TExpressionU, X_FB: pydrake.math.RigidTransform_TExpressionU) -> None: ...
    def SetFloatingBaseBodyPoseInWorldFrame(self, context: pydrake.systems.framework.Context_TExpressionU, body: pydrake.multibody.tree.RigidBody_TExpressionU, X_WB: pydrake.math.RigidTransform_TExpressionU) -> None: ...
    def SetFreeBodyPose(self, context: pydrake.systems.framework.Context_TExpressionU, body: pydrake.multibody.tree.RigidBody_TExpressionU, X_JpJc: pydrake.math.RigidTransform_TExpressionU) -> None: ...
    def SetFreeBodySpatialVelocity(self, context: pydrake.systems.framework.Context_TExpressionU, body: pydrake.multibody.tree.RigidBody_TExpressionU, V_JpJc: pydrake.multibody.math.SpatialVelocity_TExpressionU) -> None: ...
    @overload
    def SetPositions(self, context: pydrake.systems.framework.Context_TExpressionU, q: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetPositions(self, context: pydrake.systems.framework.Context_TExpressionU, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetPositionsAndVelocities(self, context: pydrake.systems.framework.Context_TExpressionU, q_v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetPositionsAndVelocities(self, context: pydrake.systems.framework.Context_TExpressionU, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q_v: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetPositionsInArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, q_instance: numpy.ndarray[object[m, 1]], q: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    def SetUseSampledOutputPorts(self, use_sampled_output_ports: bool) -> None: ...
    @overload
    def SetVelocities(self, context: pydrake.systems.framework.Context_TExpressionU, v: numpy.ndarray[object[m, 1]]) -> None: ...
    @overload
    def SetVelocities(self, context: pydrake.systems.framework.Context_TExpressionU, model_instance: pydrake.multibody.tree.ModelInstanceIndex, v: numpy.ndarray[object[m, 1]]) -> None: ...
    def SetVelocitiesInArray(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, v_instance: numpy.ndarray[object[m, 1]], v: numpy.ndarray[object[m, 1], flags.writeable] | None) -> None: ...
    def WeldFrames(self, frame_on_parent_F: pydrake.multibody.tree.Frame_TExpressionU, frame_on_child_M: pydrake.multibody.tree.Frame_TExpressionU, X_FM: pydrake.math.RigidTransform = ...) -> pydrake.multibody.tree.WeldJoint_TExpressionU: ...
    def deformable_model(self, *args, **kwargs): ...
    def geometry_source_is_registered(self) -> bool: ...
    @overload
    def get_actuation_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    @overload
    def get_actuation_input_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_adjacent_bodies_collision_filters(self) -> bool: ...
    def get_applied_generalized_force_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_applied_spatial_force_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_body(self, body_index: pydrake.multibody.tree.BodyIndex) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    def get_body_poses_output_port(self, *args, **kwargs): ...
    def get_body_spatial_accelerations_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_body_spatial_velocities_output_port(self, *args, **kwargs): ...
    def get_contact_model(self) -> ContactModel: ...
    def get_contact_penalty_method_time_scale(self) -> float: ...
    def get_contact_results_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_contact_surface_representation(self) -> pydrake.geometry.HydroelasticContactRepresentation: ...
    def get_deformable_body_configuration_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    @overload
    def get_desired_state_input_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    @overload
    def get_desired_state_input_port(self, model_instance) -> Any: ...
    def get_discrete_contact_approximation(self) -> DiscreteContactApproximation: ...
    def get_discrete_contact_solver(self) -> DiscreteContactSolver: ...
    def get_force_element(self, force_element_index: pydrake.multibody.tree.ForceElementIndex) -> pydrake.multibody.tree.ForceElement_TExpressionU: ...
    def get_frame(self, frame_index: pydrake.multibody.tree.FrameIndex) -> pydrake.multibody.tree.Frame_TExpressionU: ...
    def get_generalized_acceleration_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_generalized_contact_forces_output_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_geometry_pose_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_geometry_query_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_joint(self, joint_index: pydrake.multibody.tree.JointIndex) -> pydrake.multibody.tree.Joint_TExpressionU: ...
    def get_joint_actuator(self, actuator_index: pydrake.multibody.tree.JointActuatorIndex) -> pydrake.multibody.tree.JointActuator_TExpressionU: ...
    def get_mutable_joint(self, joint_index: pydrake.multibody.tree.JointIndex) -> pydrake.multibody.tree.Joint_TExpressionU: ...
    def get_mutable_joint_actuator(self, actuator_index: pydrake.multibody.tree.JointActuatorIndex) -> pydrake.multibody.tree.JointActuator_TExpressionU: ...
    def get_net_actuation_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_reaction_forces_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_sap_near_rigid_threshold(self) -> float: ...
    def get_source_id(self) -> pydrake.geometry.SourceId | None: ...
    @overload
    def get_state_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    @overload
    def get_state_output_port(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def gravity_field(self) -> pydrake.multibody.tree.UniformGravityFieldElement_TExpressionU: ...
    def has_joint(self, joint_index: pydrake.multibody.tree.JointIndex) -> bool: ...
    def has_joint_actuator(self, actuator_index: pydrake.multibody.tree.JointActuatorIndex) -> bool: ...
    def has_sampled_output_ports(self) -> bool: ...
    def is_finalized(self) -> bool: ...
    def is_gravity_enabled(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> bool: ...
    def mutable_deformable_model(self, *args, **kwargs): ...
    def mutable_gravity_field(self) -> pydrake.multibody.tree.UniformGravityFieldElement_TExpressionU: ...
    @overload
    def num_actuated_dofs(self) -> int: ...
    @overload
    def num_actuated_dofs(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    @overload
    def num_actuators(self) -> int: ...
    @overload
    def num_actuators(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    def num_bodies(self) -> int: ...
    def num_collision_geometries(self) -> int: ...
    def num_constraints(self) -> int: ...
    def num_force_elements(self) -> int: ...
    def num_frames(self) -> int: ...
    def num_joints(self) -> int: ...
    def num_model_instances(self) -> int: ...
    @overload
    def num_multibody_states(self) -> int: ...
    @overload
    def num_multibody_states(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    @overload
    def num_positions(self) -> int: ...
    @overload
    def num_positions(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    @overload
    def num_velocities(self) -> int: ...
    @overload
    def num_velocities(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex) -> int: ...
    def set_adjacent_bodies_collision_filters(self, value: bool) -> None: ...
    def set_contact_model(self, model: ContactModel) -> None: ...
    def set_contact_surface_representation(self, surface_representation: pydrake.geometry.HydroelasticContactRepresentation) -> None: ...
    def set_discrete_contact_approximation(self, approximation: DiscreteContactApproximation) -> None: ...
    def set_gravity_enabled(self, model_instance: pydrake.multibody.tree.ModelInstanceIndex, is_enabled: bool) -> None: ...
    def set_penetration_allowance(self, penetration_allowance: float = ...) -> None: ...
    def set_sap_near_rigid_threshold(self, near_rigid_threshold: float = ...) -> None: ...
    def set_stiction_tolerance(self, v_stiction: float = ...) -> None: ...
    def time_step(self) -> float: ...
    def world_body(self) -> pydrake.multibody.tree.RigidBody_TExpressionU: ...
    def world_frame(self) -> pydrake.multibody.tree.RigidBodyFrame_TExpressionU: ...

class _TemporaryName_N5drake9multibody15CoulombFrictionIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, static_friction: pydrake.autodiffutils.AutoDiffXd, dynamic_friction: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def dynamic_friction(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def static_friction(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def __copy__(self) -> CoulombFriction_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> CoulombFriction_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody15CoulombFrictionINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, static_friction: pydrake.symbolic.Expression, dynamic_friction: pydrake.symbolic.Expression) -> None: ...
    def dynamic_friction(self) -> pydrake.symbolic.Expression: ...
    def static_friction(self) -> pydrake.symbolic.Expression: ...
    def __copy__(self) -> CoulombFriction_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> CoulombFriction_TExpressionU: ...

class _TemporaryName_N5drake9multibody20PointPairContactInfoIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, bodyA_index: pydrake.multibody.tree.BodyIndex, bodyB_index: pydrake.multibody.tree.BodyIndex, f_Bc_W: numpy.ndarray[object[3, 1]], p_WC: numpy.ndarray[object[3, 1]], separation_speed: pydrake.autodiffutils.AutoDiffXd, slip_speed: pydrake.autodiffutils.AutoDiffXd, point_pair: pydrake.geometry.PenetrationAsPointPair_TAutoDiffXdU) -> None: ...
    def bodyA_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def bodyB_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def contact_force(self) -> numpy.ndarray[object[3, 1]]: ...
    def contact_point(self) -> numpy.ndarray[object[3, 1]]: ...
    @overload
    def point_pair(self) -> pydrake.geometry.PenetrationAsPointPair_TAutoDiffXdU: ...
    @overload
    def point_pair(self) -> Any: ...
    @overload
    def point_pair(self) -> Any: ...
    def separation_speed(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def slip_speed(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def __copy__(self) -> PointPairContactInfo_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> PointPairContactInfo_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody20PointPairContactInfoINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, bodyA_index: pydrake.multibody.tree.BodyIndex, bodyB_index: pydrake.multibody.tree.BodyIndex, f_Bc_W: numpy.ndarray[object[3, 1]], p_WC: numpy.ndarray[object[3, 1]], separation_speed: pydrake.symbolic.Expression, slip_speed: pydrake.symbolic.Expression, point_pair: pydrake.geometry.PenetrationAsPointPair_TExpressionU) -> None: ...
    def bodyA_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def bodyB_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    def contact_force(self) -> numpy.ndarray[object[3, 1]]: ...
    def contact_point(self) -> numpy.ndarray[object[3, 1]]: ...
    @overload
    def point_pair(self) -> pydrake.geometry.PenetrationAsPointPair_TExpressionU: ...
    @overload
    def point_pair(self) -> Any: ...
    @overload
    def point_pair(self) -> Any: ...
    def separation_speed(self) -> pydrake.symbolic.Expression: ...
    def slip_speed(self) -> pydrake.symbolic.Expression: ...
    def __copy__(self) -> PointPairContactInfo_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> PointPairContactInfo_TExpressionU: ...

class _TemporaryName_N5drake9multibody21DeformableContactInfoIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, id_A: pydrake.geometry.GeometryId, id_B: pydrake.geometry.GeometryId, contact_mesh_W: pydrake.geometry.PolygonSurfaceMesh_TAutoDiffXdU, F_Ac_W: pydrake.multibody.math.SpatialForce_TAutoDiffXdU) -> None: ...
    def F_Ac_W(self) -> pydrake.multibody.math.SpatialForce_TAutoDiffXdU: ...
    def contact_mesh(self) -> pydrake.geometry.PolygonSurfaceMesh_TAutoDiffXdU: ...
    def id_A(self) -> pydrake.geometry.GeometryId: ...
    def id_B(self) -> pydrake.geometry.GeometryId: ...
    def __copy__(self) -> DeformableContactInfo_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> DeformableContactInfo_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody21DeformableContactInfoINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def __copy__(self) -> DeformableContactInfo_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> DeformableContactInfo_TExpressionU: ...

class _TemporaryName_N5drake9multibody23HydroelasticContactInfoIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def F_Ac_W(self) -> pydrake.multibody.math.SpatialForce_TAutoDiffXdU: ...
    def contact_surface(self) -> pydrake.geometry.ContactSurface_TAutoDiffXdU: ...
    def __copy__(self) -> HydroelasticContactInfo_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> HydroelasticContactInfo_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody23HydroelasticContactInfoINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def __copy__(self) -> HydroelasticContactInfo_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> HydroelasticContactInfo_TExpressionU: ...

class _TemporaryName_N5drake9multibody29ExternallyAppliedSpatialForceIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    F_Bq_W: pydrake.multibody.math.SpatialForce_TAutoDiffXdU
    body_index: pydrake.multibody.tree.BodyIndex
    p_BoBq_B: numpy.ndarray[object[3, 1]]
    def __init__(self) -> None: ...
    def __copy__(self) -> ExternallyAppliedSpatialForce_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> ExternallyAppliedSpatialForce_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody29ExternallyAppliedSpatialForceINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    F_Bq_W: pydrake.multibody.math.SpatialForce_TExpressionU
    body_index: pydrake.multibody.tree.BodyIndex
    p_BoBq_B: numpy.ndarray[object[3, 1]]
    def __init__(self) -> None: ...
    def __copy__(self) -> ExternallyAppliedSpatialForce_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> ExternallyAppliedSpatialForce_TExpressionU: ...

class _TemporaryName_N5drake9multibody40ExternallyAppliedSpatialForceMultiplexerIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, num_inputs: int) -> None: ...

class _TemporaryName_N5drake9multibody40ExternallyAppliedSpatialForceMultiplexerINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, num_inputs: int) -> None: ...

class _TemporaryName_N5drake9multibody4WingIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, body_index: pydrake.multibody.tree.BodyIndex, surface_area: float, X_BodyWing: pydrake.math.RigidTransform = ..., fluid_density: float = ...) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder_TAutoDiffXdU, plant: MultibodyPlant_TAutoDiffXdU, body_index: pydrake.multibody.tree.BodyIndex, surface_area: float, X_BodyWing: pydrake.math.RigidTransform = ..., fluid_density: float = ...) -> Wing_TAutoDiffXdU: ...
    def get_aerodynamic_center_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_body_spatial_velocities_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_fluid_density_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_spatial_force_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_wind_velocity_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody4WingINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, body_index: pydrake.multibody.tree.BodyIndex, surface_area: float, X_BodyWing: pydrake.math.RigidTransform = ..., fluid_density: float = ...) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder_TExpressionU, plant: MultibodyPlant_TExpressionU, body_index: pydrake.multibody.tree.BodyIndex, surface_area: float, X_BodyWing: pydrake.math.RigidTransform = ..., fluid_density: float = ...) -> Wing_TExpressionU: ...
    def get_aerodynamic_center_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_body_spatial_velocities_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_fluid_density_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_spatial_force_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_wind_velocity_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...

class _TemporaryName_N5drake9multibody9PropellerIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, body_index: pydrake.multibody.tree.BodyIndex, X_BP: pydrake.math.RigidTransform = ..., thrust_ratio: float = ..., moment_ratio: float = ...) -> None: ...
    @overload
    def __init__(self, propeller_info: list[PropellerInfo]) -> None: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_command_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_spatial_forces_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def num_propellers(self) -> int: ...

class _TemporaryName_N5drake9multibody9PropellerINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, body_index: pydrake.multibody.tree.BodyIndex, X_BP: pydrake.math.RigidTransform = ..., thrust_ratio: float = ..., moment_ratio: float = ...) -> None: ...
    @overload
    def __init__(self, propeller_info: list[PropellerInfo]) -> None: ...
    def get_body_poses_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_command_input_port(self) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_spatial_forces_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def num_propellers(self) -> int: ...

def AddMultibodyPlant(config: MultibodyPlantConfig, builder: pydrake.systems.framework.DiagramBuilder) -> tuple: ...
@overload
def AddMultibodyPlantSceneGraph(builder: pydrake.systems.framework.DiagramBuilder, plant: MultibodyPlant, scene_graph: pydrake.geometry.SceneGraph = ...) -> tuple: ...
@overload
def AddMultibodyPlantSceneGraph(builder: pydrake.systems.framework.DiagramBuilder, time_step: float, scene_graph: pydrake.geometry.SceneGraph = ...) -> tuple: ...
@overload
def AddMultibodyPlantSceneGraph(builder: pydrake.systems.framework.DiagramBuilder_TAutoDiffXdU, plant: MultibodyPlant_TAutoDiffXdU, scene_graph: pydrake.geometry.SceneGraph_TAutoDiffXdU = ...) -> tuple: ...
@overload
def AddMultibodyPlantSceneGraph(builder: pydrake.systems.framework.DiagramBuilder_TAutoDiffXdU, time_step: float, scene_graph: pydrake.geometry.SceneGraph_TAutoDiffXdU = ...) -> tuple: ...
@overload
def AddMultibodyPlantSceneGraph(builder: pydrake.systems.framework.DiagramBuilder_TExpressionU, plant: MultibodyPlant_TExpressionU, scene_graph: pydrake.geometry.SceneGraph_TExpressionU = ...) -> tuple: ...
@overload
def AddMultibodyPlantSceneGraph(builder: pydrake.systems.framework.DiagramBuilder_TExpressionU, time_step: float, scene_graph: pydrake.geometry.SceneGraph_TExpressionU = ...) -> tuple: ...
def ApplyMultibodyPlantConfig(config: MultibodyPlantConfig, plant: MultibodyPlant) -> None: ...
def CalcContactFrictionFromSurfaceProperties(surface_properties1: CoulombFriction, surface_properties2: CoulombFriction) -> CoulombFriction: ...
def ConnectContactResultsToDrakeVisualizer(builder: pydrake.systems.framework.DiagramBuilder, plant, scene_graph: pydrake.geometry.SceneGraph, lcm: pydrake.lcm.DrakeLcmInterface = ..., publish_period: float | None = ...) -> pydrake.systems.lcm.LcmPublisherSystem: ...
