import numpy
import os
import pydrake.common.schema
import pydrake.geometry
import pydrake.math
import pydrake.multibody.tree
import pydrake.systems.framework
from typing import ClassVar, overload

class AddCollisionFilterGroup:
    __fields__: ClassVar[tuple] = ...  # read-only
    ignored_collision_filter_groups: list[str]
    member_groups: list[str]
    members: list[str]
    model_namespace: str | None
    name: str
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> AddCollisionFilterGroup: ...
    def __deepcopy__(self, arg0: dict) -> AddCollisionFilterGroup: ...

class AddDirectives:
    __fields__: ClassVar[tuple] = ...  # read-only
    file: str
    model_namespace: str | None
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> AddDirectives: ...
    def __deepcopy__(self, arg0: dict) -> AddDirectives: ...

class AddFrame:
    __fields__: ClassVar[tuple] = ...  # read-only
    X_PF: pydrake.common.schema.Transform
    name: str
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> AddFrame: ...
    def __deepcopy__(self, arg0: dict) -> AddFrame: ...

class AddModel:
    __fields__: ClassVar[tuple] = ...  # read-only
    default_free_body_pose: dict[str, pydrake.common.schema.Transform]
    default_joint_positions: dict[str, numpy.ndarray[numpy.float64[m, 1]]]
    file: str
    name: str
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> AddModel: ...
    def __deepcopy__(self, arg0: dict) -> AddModel: ...

class AddModelInstance:
    __fields__: ClassVar[tuple] = ...  # read-only
    name: str
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> AddModelInstance: ...
    def __deepcopy__(self, arg0: dict) -> AddModelInstance: ...

class AddWeld:
    __fields__: ClassVar[tuple] = ...  # read-only
    X_PC: pydrake.common.schema.Transform | None
    child: str
    parent: str
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> AddWeld: ...
    def __deepcopy__(self, arg0: dict) -> AddWeld: ...

class CollisionFilterGroups:
    def __init__(self) -> None: ...
    def AddExclusionPair(self, pair: tuple[str]) -> None: ...
    def AddGroup(self, name: str, members: set[str]) -> None: ...
    def empty(self) -> bool: ...
    def exclusion_pairs(self) -> set[tuple[str]]: ...
    def groups(self) -> dict[str, set[str]]: ...

class ModelDirective:
    __fields__: ClassVar[tuple] = ...  # read-only
    add_collision_filter_group: AddCollisionFilterGroup | None
    add_directives: AddDirectives | None
    add_frame: AddFrame | None
    add_model: AddModel | None
    add_model_instance: AddModelInstance | None
    add_weld: AddWeld | None
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> ModelDirective: ...
    def __deepcopy__(self, arg0: dict) -> ModelDirective: ...

class ModelDirectives:
    __fields__: ClassVar[tuple] = ...  # read-only
    directives: list[ModelDirective]
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> ModelDirectives: ...
    def __deepcopy__(self, arg0: dict) -> ModelDirectives: ...

class ModelInstanceInfo:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def X_PC(self) -> pydrake.math.RigidTransform: ...
    @property
    def child_frame_name(self) -> str: ...
    @property
    def model_instance(self) -> pydrake.multibody.tree.ModelInstanceIndex: ...
    @property
    def model_name(self) -> str: ...
    @property
    def model_path(self) -> str: ...
    @property
    def parent_frame_name(self) -> str: ...

class PackageMap:
    class RemoteParams:
        __fields__: ClassVar[tuple] = ...  # read-only
        archive_type: str | None
        sha256: str
        strip_prefix: str | None
        urls: list[str]
        def __init__(self, **kwargs) -> None: ...
        def ToJson(self) -> str: ...
        def __copy__(self) -> PackageMap.RemoteParams: ...
        def __deepcopy__(self, arg0: dict) -> PackageMap.RemoteParams: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: PackageMap) -> None: ...
    def Add(self, package_name: str, package_path: os.PathLike) -> None: ...
    def AddMap(self, other_map: PackageMap) -> None: ...
    def AddPackageXml(self, filename: os.PathLike) -> None: ...
    def AddRemote(self, package_name: str, params: PackageMap.RemoteParams) -> None: ...
    def Contains(self, package_name: str) -> bool: ...
    def GetPackageNames(self) -> list[str]: ...
    def GetPath(self, package_name: str) -> str: ...
    @staticmethod
    def MakeEmpty() -> PackageMap: ...
    def PopulateFromEnvironment(self, environment_variable: str) -> None: ...
    def PopulateFromFolder(self, path: os.PathLike) -> None: ...
    def PopulateFromRosPackagePath(self) -> None: ...
    def Remove(self, package_name: str) -> None: ...
    def ResolveUrl(self, url: str) -> str: ...
    def size(self) -> int: ...
    def __copy__(self) -> PackageMap: ...
    def __deepcopy__(self, arg0: dict) -> PackageMap: ...

class Parser:
    @overload
    def __init__(self, plant, scene_graph: pydrake.geometry.SceneGraph = ..., model_name_prefix: str = ...) -> None: ...
    @overload
    def __init__(self, plant, model_name_prefix: str) -> None: ...
    @overload
    def __init__(self, builder: pydrake.systems.framework.DiagramBuilder, plant=..., scene_graph: pydrake.geometry.SceneGraph = ..., model_name_prefix: str = ...) -> None: ...
    def AddModels(self, file_name: os.PathLike) -> list[pydrake.multibody.tree.ModelInstanceIndex]: ...
    def AddModelsFromString(self, file_contents: str, file_type: str) -> list[pydrake.multibody.tree.ModelInstanceIndex]: ...
    def AddModelsFromUrl(self, url: str) -> list[pydrake.multibody.tree.ModelInstanceIndex]: ...
    def GetAutoRenaming(self) -> bool: ...
    def GetCollisionFilterGroups(self) -> CollisionFilterGroups: ...
    def SetAutoRenaming(self, value: bool) -> None: ...
    def SetStrictParsing(self) -> None: ...
    def builder(self) -> pydrake.systems.framework.DiagramBuilder: ...
    def package_map(self) -> PackageMap: ...
    def plant(self, *args, **kwargs): ...
    def scene_graph(self) -> pydrake.geometry.SceneGraph: ...

def FlattenModelDirectives(directives: ModelDirectives, package_map: PackageMap) -> ModelDirectives: ...
@overload
def GetScopedFrameByName(plant, full_name: str) -> pydrake.multibody.tree.Frame: ...
@overload
def GetScopedFrameByName(plant, full_name: str) -> pydrake.multibody.tree.Frame_TExpressionU: ...
@overload
def GetScopedFrameByNameMaybe(plant, full_name: str) -> pydrake.multibody.tree.Frame: ...
@overload
def GetScopedFrameByNameMaybe(plant, full_name: str) -> pydrake.multibody.tree.Frame_TExpressionU: ...
def LoadModelDirectives(filename: os.PathLike) -> ModelDirectives: ...
def LoadModelDirectivesFromString(model_directives: str) -> ModelDirectives: ...
@overload
def ProcessModelDirectives(directives: ModelDirectives, parser: Parser) -> list[ModelInstanceInfo]: ...
@overload
def ProcessModelDirectives(directives: ModelDirectives, plant, parser: Parser = ...) -> list[ModelInstanceInfo]: ...
