import numpy
import pydrake.geometry
import pydrake.multibody.math
import pydrake.multibody.plant
import pydrake.multibody.tree
import pydrake.solvers
import pydrake.symbolic
import pydrake.systems.framework
import pydrake.trajectories
from typing import ClassVar, overload

class CalcGridPointsOptions:
    __fields__: ClassVar[tuple] = ...  # read-only
    max_err: float
    max_iter: int
    max_seg_length: float
    min_points: int
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> CalcGridPointsOptions: ...
    def __deepcopy__(self, arg0: dict) -> CalcGridPointsOptions: ...

class CentroidalMomentumConstraint(pydrake.solvers.Constraint):
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU, model_instances: list[pydrake.multibody.tree.ModelInstanceIndex] | None, plant_context: pydrake.systems.framework.Context_TAutoDiffXdU, angular_only: bool) -> None: ...

class ContactWrench:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def F_Cb_W(self) -> pydrake.multibody.math.SpatialForce: ...
    @property
    def bodyA_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    @property
    def bodyB_index(self) -> pydrake.multibody.tree.BodyIndex: ...
    @property
    def p_WCb_W(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...

class ContactWrenchFromForceInWorldFrameEvaluator(pydrake.solvers.EvaluatorBase):
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU, context: pydrake.systems.framework.Context_TAutoDiffXdU, geometry_id_pair: tuple[pydrake.geometry.GeometryId]) -> None: ...

class QuaternionEulerIntegrationConstraint(pydrake.solvers.Constraint):
    def __init__(self, allow_quaternion_negation: bool) -> None: ...
    @overload
    def ComposeVariable(self, quat1: numpy.ndarray[numpy.float64[4, 1]], quat2: numpy.ndarray[numpy.float64[4, 1]], angular_vel: numpy.ndarray[numpy.float64[3, 1]], h: float) -> numpy.ndarray[numpy.float64[12, 1]]: ...
    @overload
    def ComposeVariable(self, quat1: numpy.ndarray[object[4, 1]], quat2: numpy.ndarray[object[4, 1]], angular_vel: numpy.ndarray[object[3, 1]], h: pydrake.symbolic.Variable) -> numpy.ndarray[object[12, 1]]: ...
    @overload
    def ComposeVariable(self, quat1: numpy.ndarray[object[4, 1]], quat2: numpy.ndarray[object[4, 1]], angular_vel: numpy.ndarray[object[3, 1]], h: pydrake.symbolic.Expression) -> numpy.ndarray[object[12, 1]]: ...
    def allow_quaternion_negation(self) -> bool: ...

class SpatialVelocityConstraint(pydrake.solvers.Constraint):
    class AngularVelocityBounds:
        magnitude_lower: float
        magnitude_upper: float
        reference_direction: numpy.ndarray[numpy.float64[3, 1]]
        theta_bound: float
        def __init__(self) -> None: ...
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU, frameA: pydrake.multibody.tree.Frame_TAutoDiffXdU, v_AC_lower: numpy.ndarray[numpy.float64[3, 1]], v_AC_upper: numpy.ndarray[numpy.float64[3, 1]], frameB: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_BCo: numpy.ndarray[numpy.float64[3, 1]], plant_context: pydrake.systems.framework.Context_TAutoDiffXdU, w_AC_bounds=...) -> None: ...

class StaticEquilibriumProblem:
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU, context: pydrake.systems.framework.Context_TAutoDiffXdU, ignored_collision_pairs: set[tuple[pydrake.geometry.GeometryId, pydrake.geometry.GeometryId]]) -> None: ...
    def GetContactWrenchSolution(self, result: pydrake.solvers.MathematicalProgramResult) -> list[ContactWrench]: ...
    def UpdateComplementarityTolerance(self, tol: float) -> None: ...
    def get_mutable_prog(self) -> pydrake.solvers.MathematicalProgram: ...
    def prog(self) -> pydrake.solvers.MathematicalProgram: ...
    def q_vars(self) -> numpy.ndarray[object[m, 1]]: ...
    def u_vars(self) -> numpy.ndarray[object[m, 1]]: ...

class Toppra:
    def __init__(self, path: pydrake.trajectories.Trajectory, plant: pydrake.multibody.plant.MultibodyPlant, gridpoints: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def AddFrameAccelerationLimit(self, constraint_frame: pydrake.multibody.tree.Frame, lower_limit: numpy.ndarray[numpy.float64[6, 1]], upper_limit: numpy.ndarray[numpy.float64[6, 1]], discretization: ToppraDiscretization = ...) -> tuple[pydrake.solvers.BindingTLinearConstraintU, pydrake.solvers.BindingTLinearConstraintU]: ...
    @overload
    def AddFrameTranslationalSpeedLimit(self, constraint_frame: pydrake.multibody.tree.Frame, upper_limit: float) -> pydrake.solvers.BindingTBoundingBoxConstraintU: ...
    @overload
    def AddFrameTranslationalSpeedLimit(self, constraint_frame: pydrake.multibody.tree.Frame, upper_limit: pydrake.trajectories.Trajectory) -> pydrake.solvers.BindingTBoundingBoxConstraintU: ...
    def AddFrameVelocityLimit(self, constraint_frame: pydrake.multibody.tree.Frame, lower_limit: numpy.ndarray[numpy.float64[6, 1]], upper_limit: numpy.ndarray[numpy.float64[6, 1]]) -> pydrake.solvers.BindingTBoundingBoxConstraintU: ...
    def AddJointAccelerationLimit(self, lower_limit: numpy.ndarray[numpy.float64[m, 1]], upper_limit: numpy.ndarray[numpy.float64[m, 1]], discretization: ToppraDiscretization = ...) -> tuple[pydrake.solvers.BindingTLinearConstraintU, pydrake.solvers.BindingTLinearConstraintU]: ...
    def AddJointTorqueLimit(self, lower_limit: numpy.ndarray[numpy.float64[m, 1]], upper_limit: numpy.ndarray[numpy.float64[m, 1]], discretization: ToppraDiscretization = ...) -> tuple[pydrake.solvers.BindingTLinearConstraintU, pydrake.solvers.BindingTLinearConstraintU]: ...
    def AddJointVelocityLimit(self, lower_limit: numpy.ndarray[numpy.float64[m, 1]], upper_limit: numpy.ndarray[numpy.float64[m, 1]]) -> pydrake.solvers.BindingTBoundingBoxConstraintU: ...
    @staticmethod
    def CalcGridPoints(path: pydrake.trajectories.Trajectory, options: CalcGridPointsOptions) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def SolvePathParameterization(self, s_dot_start: float = ..., s_dot_end: float = ...) -> pydrake.trajectories.PiecewisePolynomial | None: ...

class ToppraDiscretization:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kCollocation: ClassVar[ToppraDiscretization] = ...
    kInterpolation: ClassVar[ToppraDiscretization] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...
