import numpy
import pydrake.geometry
import pydrake.multibody.plant
import pydrake.systems.framework
from pydrake.common.cpp_template import ContactVisualizer_ as ContactVisualizer_, JointSliders_ as JointSliders_
from typing import Any, ClassVar, overload

class ContactVisualizer(pydrake.systems.framework.LeafSystem):
    def __init__(self, meshcat: pydrake.geometry.Meshcat, params: ContactVisualizerParams = ...) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder, plant: pydrake.multibody.plant.MultibodyPlant, meshcat: pydrake.geometry.Meshcat, params: ContactVisualizerParams = ...) -> ContactVisualizer: ...
    @overload
    def Delete(self) -> None: ...
    @overload
    def Delete(self, std) -> Any: ...
    def contact_results_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def query_object_input_port(self) -> pydrake.systems.framework.InputPort: ...

class ContactVisualizerParams:
    __fields__: ClassVar[tuple] = ...  # read-only
    color: pydrake.geometry.Rgba
    delete_on_initialization_event: bool
    force_threshold: float
    hydro_force_color: pydrake.geometry.Rgba
    hydro_moment_color: pydrake.geometry.Rgba
    moment_threshold: float
    newton_meters_per_meter: float
    newtons_per_meter: float
    prefix: str
    publish_period: float
    radius: float
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> ContactVisualizerParams: ...
    def __deepcopy__(self, arg0: dict) -> ContactVisualizerParams: ...

class ContactVisualizer_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, meshcat: pydrake.geometry.Meshcat, params: ContactVisualizerParams = ...) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder_TAutoDiffXdU, plant: pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU, meshcat: pydrake.geometry.Meshcat, params: ContactVisualizerParams = ...) -> ContactVisualizer_TAutoDiffXdU: ...
    @overload
    def Delete(self) -> None: ...
    @overload
    def Delete(self, std) -> Any: ...
    def contact_results_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def query_object_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...

class JointSliders(pydrake.systems.framework.LeafSystem):
    def __init__(self, meshcat: pydrake.geometry.Meshcat, plant: pydrake.multibody.plant.MultibodyPlant, initial_value: numpy.ndarray[numpy.float64[m, 1]] | None = ..., lower_limit: None | float | numpy.ndarray[numpy.float64[m, 1]] = ..., upper_limit: None | float | numpy.ndarray[numpy.float64[m, 1]] = ..., step: None | float | numpy.ndarray[numpy.float64[m, 1]] = ..., decrement_keycodes: list[str] = ..., increment_keycodes: list[str] = ...) -> None: ...
    def Delete(self) -> None: ...
    def Run(self, diagram: pydrake.systems.framework.Diagram, timeout: float | None = ..., stop_button_keycode: str = ...) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def SetPositions(self, q: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class JointSliders_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, meshcat: pydrake.geometry.Meshcat, plant: pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU, initial_value: numpy.ndarray[numpy.float64[m, 1]] | None = ..., lower_limit: None | float | numpy.ndarray[numpy.float64[m, 1]] = ..., upper_limit: None | float | numpy.ndarray[numpy.float64[m, 1]] = ..., step: None | float | numpy.ndarray[numpy.float64[m, 1]] = ..., decrement_keycodes: list[str] = ..., increment_keycodes: list[str] = ...) -> None: ...
    def Delete(self) -> None: ...
    def Run(self, diagram: pydrake.systems.framework.Diagram_TAutoDiffXdU, timeout: float | None = ..., stop_button_keycode: str = ...) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def SetPositions(self, q: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class _HydroelasticContactVisualizer:
    def __init__(self, meshcat: pydrake.geometry.Meshcat, params: ContactVisualizerParams) -> None: ...
    def Delete(self) -> None: ...
    def Update(self, time: float, items: list[_HydroelasticContactVisualizerItem]) -> None: ...

class _HydroelasticContactVisualizerItem:
    body_A: str
    body_B: str
    centroid_W: numpy.ndarray[numpy.float64[3, 1]]
    faces: numpy.ndarray[numpy.int32[3, n]]
    force_C_W: numpy.ndarray[numpy.float64[3, 1]]
    moment_C_W: numpy.ndarray[numpy.float64[3, 1]]
    p_WV: numpy.ndarray[numpy.float64[3, n]]
    pressure: numpy.ndarray[numpy.float64[m, 1]]
    def __init__(self, body_A: str, body_B: str, centroid_W: numpy.ndarray[numpy.float64[3, 1]], force_C_W: numpy.ndarray[numpy.float64[3, 1]], moment_C_W: numpy.ndarray[numpy.float64[3, 1]], p_WV: numpy.ndarray[numpy.float64[3, n]], faces: numpy.ndarray[numpy.int32[3, n]], pressure: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class _PointContactVisualizer:
    def __init__(self, meshcat: pydrake.geometry.Meshcat, params: ContactVisualizerParams) -> None: ...
    def Update(self, time: float, items: list[_PointContactVisualizerItem]) -> None: ...

class _PointContactVisualizerItem:
    body_A: str
    body_B: str
    contact_force: numpy.ndarray[numpy.float64[3, 1]]
    contact_point: numpy.ndarray[numpy.float64[3, 1]]
    def __init__(self, body_A: str, body_B: str, contact_force: numpy.ndarray[numpy.float64[3, 1]], contact_point: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...

class _TemporaryName_N5drake9multibody7meshcat12JointSlidersIN5Eigen14AutoDiffScalarINS3_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, meshcat: pydrake.geometry.Meshcat, plant: pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU, initial_value: numpy.ndarray[numpy.float64[m, 1]] | None = ..., lower_limit: None | float | numpy.ndarray[numpy.float64[m, 1]] = ..., upper_limit: None | float | numpy.ndarray[numpy.float64[m, 1]] = ..., step: None | float | numpy.ndarray[numpy.float64[m, 1]] = ..., decrement_keycodes: list[str] = ..., increment_keycodes: list[str] = ...) -> None: ...
    def Delete(self) -> None: ...
    def Run(self, diagram: pydrake.systems.framework.Diagram_TAutoDiffXdU, timeout: float | None = ..., stop_button_keycode: str = ...) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def SetPositions(self, q: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class _TemporaryName_N5drake9multibody7meshcat17ContactVisualizerIN5Eigen14AutoDiffScalarINS3_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, meshcat: pydrake.geometry.Meshcat, params: ContactVisualizerParams = ...) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder_TAutoDiffXdU, plant: pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU, meshcat: pydrake.geometry.Meshcat, params: ContactVisualizerParams = ...) -> ContactVisualizer_TAutoDiffXdU: ...
    @overload
    def Delete(self) -> None: ...
    @overload
    def Delete(self, std) -> Any: ...
    def contact_results_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def query_object_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
