import numpy
import pydrake.autodiffutils
import pydrake.autodiffutils as _ad
import pydrake.math
import pydrake.symbolic
import pydrake.symbolic as _sym
from pydrake.common.cpp_template import SpatialAcceleration_ as SpatialAcceleration_, SpatialForce_ as SpatialForce_, SpatialMomentum_ as SpatialMomentum_, SpatialVelocity_ as SpatialVelocity_
from typing import Any, Callable, ClassVar, overload

__getattr__: Callable

class SpatialAcceleration:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, alpha: numpy.ndarray[numpy.float64[3, 1]], a: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    @overload
    def __init__(self, A: numpy.ndarray[numpy.float64[6, 1]]) -> None: ...
    def ComposeWithMovingFrameAcceleration(self, position_of_moving_frame: numpy.ndarray[numpy.float64[3, 1]], angular_velocity_of_this_frame: numpy.ndarray[numpy.float64[3, 1]], velocity_of_moving_frame: SpatialVelocity, acceleration_of_moving_frame: SpatialAcceleration) -> SpatialAcceleration: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix) -> SpatialAcceleration: ...
    def SetZero(self) -> SpatialAcceleration: ...
    def Shift(self, offset: numpy.ndarray[numpy.float64[3, 1]], angular_velocity_of_this_frame: numpy.ndarray[numpy.float64[3, 1]]) -> SpatialAcceleration: ...
    def ShiftWithZeroAngularVelocity(self, offset: numpy.ndarray[numpy.float64[3, 1]]) -> SpatialAcceleration: ...
    @staticmethod
    def Zero() -> SpatialAcceleration: ...
    def get_coeffs(self) -> numpy.ndarray[numpy.float64[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def translational(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def __add__(self, arg0: SpatialAcceleration) -> SpatialAcceleration: ...
    def __copy__(self) -> SpatialAcceleration: ...
    def __deepcopy__(self, arg0: dict) -> SpatialAcceleration: ...
    def __iadd__(self, arg0: SpatialAcceleration) -> SpatialAcceleration: ...
    def __imul__(self, arg0: float) -> SpatialAcceleration: ...
    def __isub__(self, arg0: SpatialAcceleration) -> SpatialAcceleration: ...
    def __mul__(self, arg0: float) -> SpatialAcceleration: ...
    def __neg__(self) -> SpatialAcceleration: ...
    def __rmul__(self, arg0: float) -> SpatialAcceleration: ...
    def __sub__(self, arg0: SpatialAcceleration) -> SpatialAcceleration: ...

class SpatialAcceleration_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, alpha: numpy.ndarray[object[3, 1]], a: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, A: numpy.ndarray[object[6, 1]]) -> None: ...
    def ComposeWithMovingFrameAcceleration(self, position_of_moving_frame: numpy.ndarray[object[3, 1]], angular_velocity_of_this_frame: numpy.ndarray[object[3, 1]], velocity_of_moving_frame: SpatialVelocity_TAutoDiffXdU, acceleration_of_moving_frame: SpatialAcceleration_TAutoDiffXdU) -> SpatialAcceleration_TAutoDiffXdU: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix_TAutoDiffXdU) -> SpatialAcceleration_TAutoDiffXdU: ...
    def SetZero(self) -> SpatialAcceleration_TAutoDiffXdU: ...
    def Shift(self, offset: numpy.ndarray[object[3, 1]], angular_velocity_of_this_frame: numpy.ndarray[object[3, 1]]) -> SpatialAcceleration_TAutoDiffXdU: ...
    def ShiftWithZeroAngularVelocity(self, offset: numpy.ndarray[object[3, 1]]) -> SpatialAcceleration_TAutoDiffXdU: ...
    @staticmethod
    def Zero() -> SpatialAcceleration_TAutoDiffXdU: ...
    def get_coeffs(self) -> numpy.ndarray[object[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[object[3, 1]]: ...
    def translational(self) -> numpy.ndarray[object[3, 1]]: ...
    def __add__(self, arg0: SpatialAcceleration_TAutoDiffXdU) -> SpatialAcceleration_TAutoDiffXdU: ...
    def __copy__(self) -> SpatialAcceleration_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialAcceleration_TAutoDiffXdU: ...
    def __iadd__(self, arg0: SpatialAcceleration_TAutoDiffXdU) -> SpatialAcceleration_TAutoDiffXdU: ...
    def __imul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialAcceleration_TAutoDiffXdU: ...
    def __isub__(self, arg0: SpatialAcceleration_TAutoDiffXdU) -> SpatialAcceleration_TAutoDiffXdU: ...
    def __mul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialAcceleration_TAutoDiffXdU: ...
    def __neg__(self) -> SpatialAcceleration_TAutoDiffXdU: ...
    def __rmul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialAcceleration_TAutoDiffXdU: ...
    def __sub__(self, arg0: SpatialAcceleration_TAutoDiffXdU) -> SpatialAcceleration_TAutoDiffXdU: ...

class SpatialAcceleration_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, alpha: numpy.ndarray[object[3, 1]], a: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, A: numpy.ndarray[object[6, 1]]) -> None: ...
    def ComposeWithMovingFrameAcceleration(self, position_of_moving_frame: numpy.ndarray[object[3, 1]], angular_velocity_of_this_frame: numpy.ndarray[object[3, 1]], velocity_of_moving_frame: SpatialVelocity_TExpressionU, acceleration_of_moving_frame: SpatialAcceleration_TExpressionU) -> SpatialAcceleration_TExpressionU: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix_TExpressionU) -> SpatialAcceleration_TExpressionU: ...
    def SetZero(self) -> SpatialAcceleration_TExpressionU: ...
    def Shift(self, offset: numpy.ndarray[object[3, 1]], angular_velocity_of_this_frame: numpy.ndarray[object[3, 1]]) -> SpatialAcceleration_TExpressionU: ...
    def ShiftWithZeroAngularVelocity(self, offset: numpy.ndarray[object[3, 1]]) -> SpatialAcceleration_TExpressionU: ...
    @staticmethod
    def Zero() -> SpatialAcceleration_TExpressionU: ...
    def get_coeffs(self) -> numpy.ndarray[object[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[object[3, 1]]: ...
    def translational(self) -> numpy.ndarray[object[3, 1]]: ...
    def __add__(self, arg0: SpatialAcceleration_TExpressionU) -> SpatialAcceleration_TExpressionU: ...
    def __copy__(self) -> SpatialAcceleration_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialAcceleration_TExpressionU: ...
    def __iadd__(self, arg0: SpatialAcceleration_TExpressionU) -> SpatialAcceleration_TExpressionU: ...
    def __imul__(self, arg0: pydrake.symbolic.Expression) -> SpatialAcceleration_TExpressionU: ...
    def __isub__(self, arg0: SpatialAcceleration_TExpressionU) -> SpatialAcceleration_TExpressionU: ...
    def __mul__(self, arg0: pydrake.symbolic.Expression) -> SpatialAcceleration_TExpressionU: ...
    def __neg__(self) -> SpatialAcceleration_TExpressionU: ...
    def __rmul__(self, arg0: pydrake.symbolic.Expression) -> SpatialAcceleration_TExpressionU: ...
    def __sub__(self, arg0: SpatialAcceleration_TExpressionU) -> SpatialAcceleration_TExpressionU: ...

class SpatialForce:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, tau: numpy.ndarray[numpy.float64[3, 1]], f: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    @overload
    def __init__(self, F: numpy.ndarray[numpy.float64[6, 1]]) -> None: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix) -> SpatialForce: ...
    def SetZero(self) -> SpatialForce: ...
    @overload
    def Shift(self, offset: numpy.ndarray[numpy.float64[3, 1]]) -> SpatialForce: ...
    @overload
    def Shift(self) -> Any: ...
    @staticmethod
    def Zero() -> SpatialForce: ...
    def dot(self, velocity: SpatialVelocity) -> float: ...
    def get_coeffs(self) -> numpy.ndarray[numpy.float64[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def translational(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def __add__(self, arg0: SpatialForce) -> SpatialForce: ...
    def __copy__(self) -> SpatialForce: ...
    def __deepcopy__(self, arg0: dict) -> SpatialForce: ...
    def __iadd__(self, arg0: SpatialForce) -> SpatialForce: ...
    def __imul__(self, arg0: float) -> SpatialForce: ...
    def __isub__(self, arg0: SpatialForce) -> SpatialForce: ...
    def __matmul__(self, *args, **kwargs): ...
    def __mul__(self, arg0: float) -> SpatialForce: ...
    def __neg__(self) -> SpatialForce: ...
    def __rmul__(self, arg0: float) -> SpatialForce: ...
    def __sub__(self, arg0: SpatialForce) -> SpatialForce: ...

class SpatialForce_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, tau: numpy.ndarray[object[3, 1]], f: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, F: numpy.ndarray[object[6, 1]]) -> None: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix_TAutoDiffXdU) -> SpatialForce_TAutoDiffXdU: ...
    def SetZero(self) -> SpatialForce_TAutoDiffXdU: ...
    @overload
    def Shift(self, offset: numpy.ndarray[object[3, 1]]) -> SpatialForce_TAutoDiffXdU: ...
    @overload
    def Shift(self) -> Any: ...
    @staticmethod
    def Zero() -> SpatialForce_TAutoDiffXdU: ...
    def dot(self, velocity: SpatialVelocity_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_coeffs(self) -> numpy.ndarray[object[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[object[3, 1]]: ...
    def translational(self) -> numpy.ndarray[object[3, 1]]: ...
    def __add__(self, arg0: SpatialForce_TAutoDiffXdU) -> SpatialForce_TAutoDiffXdU: ...
    def __copy__(self) -> SpatialForce_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialForce_TAutoDiffXdU: ...
    def __iadd__(self, arg0: SpatialForce_TAutoDiffXdU) -> SpatialForce_TAutoDiffXdU: ...
    def __imul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialForce_TAutoDiffXdU: ...
    def __isub__(self, arg0: SpatialForce_TAutoDiffXdU) -> SpatialForce_TAutoDiffXdU: ...
    def __matmul__(self, *args, **kwargs): ...
    def __mul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialForce_TAutoDiffXdU: ...
    def __neg__(self) -> SpatialForce_TAutoDiffXdU: ...
    def __rmul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialForce_TAutoDiffXdU: ...
    def __sub__(self, arg0: SpatialForce_TAutoDiffXdU) -> SpatialForce_TAutoDiffXdU: ...

class SpatialForce_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, tau: numpy.ndarray[object[3, 1]], f: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, F: numpy.ndarray[object[6, 1]]) -> None: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix_TExpressionU) -> SpatialForce_TExpressionU: ...
    def SetZero(self) -> SpatialForce_TExpressionU: ...
    @overload
    def Shift(self, offset: numpy.ndarray[object[3, 1]]) -> SpatialForce_TExpressionU: ...
    @overload
    def Shift(self) -> Any: ...
    @staticmethod
    def Zero() -> SpatialForce_TExpressionU: ...
    def dot(self, velocity: SpatialVelocity_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_coeffs(self) -> numpy.ndarray[object[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[object[3, 1]]: ...
    def translational(self) -> numpy.ndarray[object[3, 1]]: ...
    def __add__(self, arg0: SpatialForce_TExpressionU) -> SpatialForce_TExpressionU: ...
    def __copy__(self) -> SpatialForce_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialForce_TExpressionU: ...
    def __iadd__(self, arg0: SpatialForce_TExpressionU) -> SpatialForce_TExpressionU: ...
    def __imul__(self, arg0: pydrake.symbolic.Expression) -> SpatialForce_TExpressionU: ...
    def __isub__(self, arg0: SpatialForce_TExpressionU) -> SpatialForce_TExpressionU: ...
    def __matmul__(self, *args, **kwargs): ...
    def __mul__(self, arg0: pydrake.symbolic.Expression) -> SpatialForce_TExpressionU: ...
    def __neg__(self) -> SpatialForce_TExpressionU: ...
    def __rmul__(self, arg0: pydrake.symbolic.Expression) -> SpatialForce_TExpressionU: ...
    def __sub__(self, arg0: SpatialForce_TExpressionU) -> SpatialForce_TExpressionU: ...

class SpatialMomentum:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, h: numpy.ndarray[numpy.float64[3, 1]], l: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    @overload
    def __init__(self, L: numpy.ndarray[numpy.float64[6, 1]]) -> None: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix) -> SpatialMomentum: ...
    def SetZero(self) -> SpatialMomentum: ...
    def Shift(self, offset: numpy.ndarray[numpy.float64[3, 1]]) -> SpatialMomentum: ...
    @staticmethod
    def Zero() -> SpatialMomentum: ...
    def dot(self, velocity: SpatialVelocity) -> float: ...
    def get_coeffs(self) -> numpy.ndarray[numpy.float64[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def translational(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def __add__(self, arg0: SpatialMomentum) -> SpatialMomentum: ...
    def __copy__(self) -> SpatialMomentum: ...
    def __deepcopy__(self, arg0: dict) -> SpatialMomentum: ...
    def __iadd__(self, arg0: SpatialMomentum) -> SpatialMomentum: ...
    def __imul__(self, arg0: float) -> SpatialMomentum: ...
    def __isub__(self, arg0: SpatialMomentum) -> SpatialMomentum: ...
    def __matmul__(self, *args, **kwargs): ...
    def __mul__(self, arg0: float) -> SpatialMomentum: ...
    def __neg__(self) -> SpatialMomentum: ...
    def __rmul__(self, arg0: float) -> SpatialMomentum: ...
    def __sub__(self, arg0: SpatialMomentum) -> SpatialMomentum: ...

class SpatialMomentum_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, h: numpy.ndarray[object[3, 1]], l: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, L: numpy.ndarray[object[6, 1]]) -> None: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix_TAutoDiffXdU) -> SpatialMomentum_TAutoDiffXdU: ...
    def SetZero(self) -> SpatialMomentum_TAutoDiffXdU: ...
    def Shift(self, offset: numpy.ndarray[object[3, 1]]) -> SpatialMomentum_TAutoDiffXdU: ...
    @staticmethod
    def Zero() -> SpatialMomentum_TAutoDiffXdU: ...
    def dot(self, velocity: SpatialVelocity_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_coeffs(self) -> numpy.ndarray[object[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[object[3, 1]]: ...
    def translational(self) -> numpy.ndarray[object[3, 1]]: ...
    def __add__(self, arg0: SpatialMomentum_TAutoDiffXdU) -> SpatialMomentum_TAutoDiffXdU: ...
    def __copy__(self) -> SpatialMomentum_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialMomentum_TAutoDiffXdU: ...
    def __iadd__(self, arg0: SpatialMomentum_TAutoDiffXdU) -> SpatialMomentum_TAutoDiffXdU: ...
    def __imul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialMomentum_TAutoDiffXdU: ...
    def __isub__(self, arg0: SpatialMomentum_TAutoDiffXdU) -> SpatialMomentum_TAutoDiffXdU: ...
    def __matmul__(self, *args, **kwargs): ...
    def __mul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialMomentum_TAutoDiffXdU: ...
    def __neg__(self) -> SpatialMomentum_TAutoDiffXdU: ...
    def __rmul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialMomentum_TAutoDiffXdU: ...
    def __sub__(self, arg0: SpatialMomentum_TAutoDiffXdU) -> SpatialMomentum_TAutoDiffXdU: ...

class SpatialMomentum_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, h: numpy.ndarray[object[3, 1]], l: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, L: numpy.ndarray[object[6, 1]]) -> None: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix_TExpressionU) -> SpatialMomentum_TExpressionU: ...
    def SetZero(self) -> SpatialMomentum_TExpressionU: ...
    def Shift(self, offset: numpy.ndarray[object[3, 1]]) -> SpatialMomentum_TExpressionU: ...
    @staticmethod
    def Zero() -> SpatialMomentum_TExpressionU: ...
    def dot(self, velocity: SpatialVelocity_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_coeffs(self) -> numpy.ndarray[object[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[object[3, 1]]: ...
    def translational(self) -> numpy.ndarray[object[3, 1]]: ...
    def __add__(self, arg0: SpatialMomentum_TExpressionU) -> SpatialMomentum_TExpressionU: ...
    def __copy__(self) -> SpatialMomentum_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialMomentum_TExpressionU: ...
    def __iadd__(self, arg0: SpatialMomentum_TExpressionU) -> SpatialMomentum_TExpressionU: ...
    def __imul__(self, arg0: pydrake.symbolic.Expression) -> SpatialMomentum_TExpressionU: ...
    def __isub__(self, arg0: SpatialMomentum_TExpressionU) -> SpatialMomentum_TExpressionU: ...
    def __matmul__(self, *args, **kwargs): ...
    def __mul__(self, arg0: pydrake.symbolic.Expression) -> SpatialMomentum_TExpressionU: ...
    def __neg__(self) -> SpatialMomentum_TExpressionU: ...
    def __rmul__(self, arg0: pydrake.symbolic.Expression) -> SpatialMomentum_TExpressionU: ...
    def __sub__(self, arg0: SpatialMomentum_TExpressionU) -> SpatialMomentum_TExpressionU: ...

class SpatialVelocity:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, w: numpy.ndarray[numpy.float64[3, 1]], v: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    @overload
    def __init__(self, V: numpy.ndarray[numpy.float64[6, 1]]) -> None: ...
    def ComposeWithMovingFrameVelocity(self, position_of_moving_frame: numpy.ndarray[numpy.float64[3, 1]], velocity_of_moving_frame: SpatialVelocity) -> SpatialVelocity: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix) -> SpatialVelocity: ...
    def SetZero(self) -> SpatialVelocity: ...
    def Shift(self, offset: numpy.ndarray[numpy.float64[3, 1]]) -> SpatialVelocity: ...
    @staticmethod
    def Zero() -> SpatialVelocity: ...
    def dot(self, force: SpatialForce) -> float: ...
    def get_coeffs(self) -> numpy.ndarray[numpy.float64[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def translational(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def __add__(self, arg0: SpatialVelocity) -> SpatialVelocity: ...
    def __copy__(self) -> SpatialVelocity: ...
    def __deepcopy__(self, arg0: dict) -> SpatialVelocity: ...
    def __iadd__(self, arg0: SpatialVelocity) -> SpatialVelocity: ...
    def __imul__(self, arg0: float) -> SpatialVelocity: ...
    def __isub__(self, arg0: SpatialVelocity) -> SpatialVelocity: ...
    def __matmul__(self, *args, **kwargs): ...
    def __mul__(self, arg0: float) -> SpatialVelocity: ...
    def __neg__(self) -> SpatialVelocity: ...
    def __rmul__(self, arg0: float) -> SpatialVelocity: ...
    def __sub__(self, arg0: SpatialVelocity) -> SpatialVelocity: ...

class SpatialVelocity_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, w: numpy.ndarray[object[3, 1]], v: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, V: numpy.ndarray[object[6, 1]]) -> None: ...
    def ComposeWithMovingFrameVelocity(self, position_of_moving_frame: numpy.ndarray[object[3, 1]], velocity_of_moving_frame: SpatialVelocity_TAutoDiffXdU) -> SpatialVelocity_TAutoDiffXdU: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix_TAutoDiffXdU) -> SpatialVelocity_TAutoDiffXdU: ...
    def SetZero(self) -> SpatialVelocity_TAutoDiffXdU: ...
    def Shift(self, offset: numpy.ndarray[object[3, 1]]) -> SpatialVelocity_TAutoDiffXdU: ...
    @staticmethod
    def Zero() -> SpatialVelocity_TAutoDiffXdU: ...
    def dot(self, force: SpatialForce_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_coeffs(self) -> numpy.ndarray[object[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[object[3, 1]]: ...
    def translational(self) -> numpy.ndarray[object[3, 1]]: ...
    def __add__(self, arg0: SpatialVelocity_TAutoDiffXdU) -> SpatialVelocity_TAutoDiffXdU: ...
    def __copy__(self) -> SpatialVelocity_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialVelocity_TAutoDiffXdU: ...
    def __iadd__(self, arg0: SpatialVelocity_TAutoDiffXdU) -> SpatialVelocity_TAutoDiffXdU: ...
    def __imul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialVelocity_TAutoDiffXdU: ...
    def __isub__(self, arg0: SpatialVelocity_TAutoDiffXdU) -> SpatialVelocity_TAutoDiffXdU: ...
    def __matmul__(self, *args, **kwargs): ...
    def __mul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialVelocity_TAutoDiffXdU: ...
    def __neg__(self) -> SpatialVelocity_TAutoDiffXdU: ...
    def __rmul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialVelocity_TAutoDiffXdU: ...
    def __sub__(self, arg0: SpatialVelocity_TAutoDiffXdU) -> SpatialVelocity_TAutoDiffXdU: ...

class SpatialVelocity_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, w: numpy.ndarray[object[3, 1]], v: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, V: numpy.ndarray[object[6, 1]]) -> None: ...
    def ComposeWithMovingFrameVelocity(self, position_of_moving_frame: numpy.ndarray[object[3, 1]], velocity_of_moving_frame: SpatialVelocity_TExpressionU) -> SpatialVelocity_TExpressionU: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix_TExpressionU) -> SpatialVelocity_TExpressionU: ...
    def SetZero(self) -> SpatialVelocity_TExpressionU: ...
    def Shift(self, offset: numpy.ndarray[object[3, 1]]) -> SpatialVelocity_TExpressionU: ...
    @staticmethod
    def Zero() -> SpatialVelocity_TExpressionU: ...
    def dot(self, force: SpatialForce_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_coeffs(self) -> numpy.ndarray[object[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[object[3, 1]]: ...
    def translational(self) -> numpy.ndarray[object[3, 1]]: ...
    def __add__(self, arg0: SpatialVelocity_TExpressionU) -> SpatialVelocity_TExpressionU: ...
    def __copy__(self) -> SpatialVelocity_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialVelocity_TExpressionU: ...
    def __iadd__(self, arg0: SpatialVelocity_TExpressionU) -> SpatialVelocity_TExpressionU: ...
    def __imul__(self, arg0: pydrake.symbolic.Expression) -> SpatialVelocity_TExpressionU: ...
    def __isub__(self, arg0: SpatialVelocity_TExpressionU) -> SpatialVelocity_TExpressionU: ...
    def __matmul__(self, *args, **kwargs): ...
    def __mul__(self, arg0: pydrake.symbolic.Expression) -> SpatialVelocity_TExpressionU: ...
    def __neg__(self) -> SpatialVelocity_TExpressionU: ...
    def __rmul__(self, arg0: pydrake.symbolic.Expression) -> SpatialVelocity_TExpressionU: ...
    def __sub__(self, arg0: SpatialVelocity_TExpressionU) -> SpatialVelocity_TExpressionU: ...

class _TemporaryName_N5drake9multibody12SpatialForceIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, tau: numpy.ndarray[object[3, 1]], f: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, F: numpy.ndarray[object[6, 1]]) -> None: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix_TAutoDiffXdU) -> SpatialForce_TAutoDiffXdU: ...
    def SetZero(self) -> SpatialForce_TAutoDiffXdU: ...
    @overload
    def Shift(self, offset: numpy.ndarray[object[3, 1]]) -> SpatialForce_TAutoDiffXdU: ...
    @overload
    def Shift(self) -> Any: ...
    @staticmethod
    def Zero() -> SpatialForce_TAutoDiffXdU: ...
    def dot(self, velocity: SpatialVelocity_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_coeffs(self) -> numpy.ndarray[object[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[object[3, 1]]: ...
    def translational(self) -> numpy.ndarray[object[3, 1]]: ...
    def __add__(self, arg0: SpatialForce_TAutoDiffXdU) -> SpatialForce_TAutoDiffXdU: ...
    def __copy__(self) -> SpatialForce_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialForce_TAutoDiffXdU: ...
    def __iadd__(self, arg0: SpatialForce_TAutoDiffXdU) -> SpatialForce_TAutoDiffXdU: ...
    def __imul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialForce_TAutoDiffXdU: ...
    def __isub__(self, arg0: SpatialForce_TAutoDiffXdU) -> SpatialForce_TAutoDiffXdU: ...
    def __matmul__(self, *args, **kwargs): ...
    def __mul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialForce_TAutoDiffXdU: ...
    def __neg__(self) -> SpatialForce_TAutoDiffXdU: ...
    def __rmul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialForce_TAutoDiffXdU: ...
    def __sub__(self, arg0: SpatialForce_TAutoDiffXdU) -> SpatialForce_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody12SpatialForceINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, tau: numpy.ndarray[object[3, 1]], f: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, F: numpy.ndarray[object[6, 1]]) -> None: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix_TExpressionU) -> SpatialForce_TExpressionU: ...
    def SetZero(self) -> SpatialForce_TExpressionU: ...
    @overload
    def Shift(self, offset: numpy.ndarray[object[3, 1]]) -> SpatialForce_TExpressionU: ...
    @overload
    def Shift(self) -> Any: ...
    @staticmethod
    def Zero() -> SpatialForce_TExpressionU: ...
    def dot(self, velocity: SpatialVelocity_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_coeffs(self) -> numpy.ndarray[object[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[object[3, 1]]: ...
    def translational(self) -> numpy.ndarray[object[3, 1]]: ...
    def __add__(self, arg0: SpatialForce_TExpressionU) -> SpatialForce_TExpressionU: ...
    def __copy__(self) -> SpatialForce_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialForce_TExpressionU: ...
    def __iadd__(self, arg0: SpatialForce_TExpressionU) -> SpatialForce_TExpressionU: ...
    def __imul__(self, arg0: pydrake.symbolic.Expression) -> SpatialForce_TExpressionU: ...
    def __isub__(self, arg0: SpatialForce_TExpressionU) -> SpatialForce_TExpressionU: ...
    def __matmul__(self, *args, **kwargs): ...
    def __mul__(self, arg0: pydrake.symbolic.Expression) -> SpatialForce_TExpressionU: ...
    def __neg__(self) -> SpatialForce_TExpressionU: ...
    def __rmul__(self, arg0: pydrake.symbolic.Expression) -> SpatialForce_TExpressionU: ...
    def __sub__(self, arg0: SpatialForce_TExpressionU) -> SpatialForce_TExpressionU: ...

class _TemporaryName_N5drake9multibody15SpatialMomentumIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, h: numpy.ndarray[object[3, 1]], l: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, L: numpy.ndarray[object[6, 1]]) -> None: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix_TAutoDiffXdU) -> SpatialMomentum_TAutoDiffXdU: ...
    def SetZero(self) -> SpatialMomentum_TAutoDiffXdU: ...
    def Shift(self, offset: numpy.ndarray[object[3, 1]]) -> SpatialMomentum_TAutoDiffXdU: ...
    @staticmethod
    def Zero() -> SpatialMomentum_TAutoDiffXdU: ...
    def dot(self, velocity: SpatialVelocity_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_coeffs(self) -> numpy.ndarray[object[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[object[3, 1]]: ...
    def translational(self) -> numpy.ndarray[object[3, 1]]: ...
    def __add__(self, arg0: SpatialMomentum_TAutoDiffXdU) -> SpatialMomentum_TAutoDiffXdU: ...
    def __copy__(self) -> SpatialMomentum_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialMomentum_TAutoDiffXdU: ...
    def __iadd__(self, arg0: SpatialMomentum_TAutoDiffXdU) -> SpatialMomentum_TAutoDiffXdU: ...
    def __imul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialMomentum_TAutoDiffXdU: ...
    def __isub__(self, arg0: SpatialMomentum_TAutoDiffXdU) -> SpatialMomentum_TAutoDiffXdU: ...
    def __matmul__(self, *args, **kwargs): ...
    def __mul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialMomentum_TAutoDiffXdU: ...
    def __neg__(self) -> SpatialMomentum_TAutoDiffXdU: ...
    def __rmul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialMomentum_TAutoDiffXdU: ...
    def __sub__(self, arg0: SpatialMomentum_TAutoDiffXdU) -> SpatialMomentum_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody15SpatialMomentumINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, h: numpy.ndarray[object[3, 1]], l: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, L: numpy.ndarray[object[6, 1]]) -> None: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix_TExpressionU) -> SpatialMomentum_TExpressionU: ...
    def SetZero(self) -> SpatialMomentum_TExpressionU: ...
    def Shift(self, offset: numpy.ndarray[object[3, 1]]) -> SpatialMomentum_TExpressionU: ...
    @staticmethod
    def Zero() -> SpatialMomentum_TExpressionU: ...
    def dot(self, velocity: SpatialVelocity_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_coeffs(self) -> numpy.ndarray[object[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[object[3, 1]]: ...
    def translational(self) -> numpy.ndarray[object[3, 1]]: ...
    def __add__(self, arg0: SpatialMomentum_TExpressionU) -> SpatialMomentum_TExpressionU: ...
    def __copy__(self) -> SpatialMomentum_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialMomentum_TExpressionU: ...
    def __iadd__(self, arg0: SpatialMomentum_TExpressionU) -> SpatialMomentum_TExpressionU: ...
    def __imul__(self, arg0: pydrake.symbolic.Expression) -> SpatialMomentum_TExpressionU: ...
    def __isub__(self, arg0: SpatialMomentum_TExpressionU) -> SpatialMomentum_TExpressionU: ...
    def __matmul__(self, *args, **kwargs): ...
    def __mul__(self, arg0: pydrake.symbolic.Expression) -> SpatialMomentum_TExpressionU: ...
    def __neg__(self) -> SpatialMomentum_TExpressionU: ...
    def __rmul__(self, arg0: pydrake.symbolic.Expression) -> SpatialMomentum_TExpressionU: ...
    def __sub__(self, arg0: SpatialMomentum_TExpressionU) -> SpatialMomentum_TExpressionU: ...

class _TemporaryName_N5drake9multibody15SpatialVelocityIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, w: numpy.ndarray[object[3, 1]], v: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, V: numpy.ndarray[object[6, 1]]) -> None: ...
    def ComposeWithMovingFrameVelocity(self, position_of_moving_frame: numpy.ndarray[object[3, 1]], velocity_of_moving_frame: SpatialVelocity_TAutoDiffXdU) -> SpatialVelocity_TAutoDiffXdU: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix_TAutoDiffXdU) -> SpatialVelocity_TAutoDiffXdU: ...
    def SetZero(self) -> SpatialVelocity_TAutoDiffXdU: ...
    def Shift(self, offset: numpy.ndarray[object[3, 1]]) -> SpatialVelocity_TAutoDiffXdU: ...
    @staticmethod
    def Zero() -> SpatialVelocity_TAutoDiffXdU: ...
    def dot(self, force: SpatialForce_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def get_coeffs(self) -> numpy.ndarray[object[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[object[3, 1]]: ...
    def translational(self) -> numpy.ndarray[object[3, 1]]: ...
    def __add__(self, arg0: SpatialVelocity_TAutoDiffXdU) -> SpatialVelocity_TAutoDiffXdU: ...
    def __copy__(self) -> SpatialVelocity_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialVelocity_TAutoDiffXdU: ...
    def __iadd__(self, arg0: SpatialVelocity_TAutoDiffXdU) -> SpatialVelocity_TAutoDiffXdU: ...
    def __imul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialVelocity_TAutoDiffXdU: ...
    def __isub__(self, arg0: SpatialVelocity_TAutoDiffXdU) -> SpatialVelocity_TAutoDiffXdU: ...
    def __matmul__(self, *args, **kwargs): ...
    def __mul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialVelocity_TAutoDiffXdU: ...
    def __neg__(self) -> SpatialVelocity_TAutoDiffXdU: ...
    def __rmul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialVelocity_TAutoDiffXdU: ...
    def __sub__(self, arg0: SpatialVelocity_TAutoDiffXdU) -> SpatialVelocity_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody15SpatialVelocityINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, w: numpy.ndarray[object[3, 1]], v: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, V: numpy.ndarray[object[6, 1]]) -> None: ...
    def ComposeWithMovingFrameVelocity(self, position_of_moving_frame: numpy.ndarray[object[3, 1]], velocity_of_moving_frame: SpatialVelocity_TExpressionU) -> SpatialVelocity_TExpressionU: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix_TExpressionU) -> SpatialVelocity_TExpressionU: ...
    def SetZero(self) -> SpatialVelocity_TExpressionU: ...
    def Shift(self, offset: numpy.ndarray[object[3, 1]]) -> SpatialVelocity_TExpressionU: ...
    @staticmethod
    def Zero() -> SpatialVelocity_TExpressionU: ...
    def dot(self, force: SpatialForce_TExpressionU) -> pydrake.symbolic.Expression: ...
    def get_coeffs(self) -> numpy.ndarray[object[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[object[3, 1]]: ...
    def translational(self) -> numpy.ndarray[object[3, 1]]: ...
    def __add__(self, arg0: SpatialVelocity_TExpressionU) -> SpatialVelocity_TExpressionU: ...
    def __copy__(self) -> SpatialVelocity_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialVelocity_TExpressionU: ...
    def __iadd__(self, arg0: SpatialVelocity_TExpressionU) -> SpatialVelocity_TExpressionU: ...
    def __imul__(self, arg0: pydrake.symbolic.Expression) -> SpatialVelocity_TExpressionU: ...
    def __isub__(self, arg0: SpatialVelocity_TExpressionU) -> SpatialVelocity_TExpressionU: ...
    def __matmul__(self, *args, **kwargs): ...
    def __mul__(self, arg0: pydrake.symbolic.Expression) -> SpatialVelocity_TExpressionU: ...
    def __neg__(self) -> SpatialVelocity_TExpressionU: ...
    def __rmul__(self, arg0: pydrake.symbolic.Expression) -> SpatialVelocity_TExpressionU: ...
    def __sub__(self, arg0: SpatialVelocity_TExpressionU) -> SpatialVelocity_TExpressionU: ...

class _TemporaryName_N5drake9multibody19SpatialAccelerationIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, alpha: numpy.ndarray[object[3, 1]], a: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, A: numpy.ndarray[object[6, 1]]) -> None: ...
    def ComposeWithMovingFrameAcceleration(self, position_of_moving_frame: numpy.ndarray[object[3, 1]], angular_velocity_of_this_frame: numpy.ndarray[object[3, 1]], velocity_of_moving_frame: SpatialVelocity_TAutoDiffXdU, acceleration_of_moving_frame: SpatialAcceleration_TAutoDiffXdU) -> SpatialAcceleration_TAutoDiffXdU: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix_TAutoDiffXdU) -> SpatialAcceleration_TAutoDiffXdU: ...
    def SetZero(self) -> SpatialAcceleration_TAutoDiffXdU: ...
    def Shift(self, offset: numpy.ndarray[object[3, 1]], angular_velocity_of_this_frame: numpy.ndarray[object[3, 1]]) -> SpatialAcceleration_TAutoDiffXdU: ...
    def ShiftWithZeroAngularVelocity(self, offset: numpy.ndarray[object[3, 1]]) -> SpatialAcceleration_TAutoDiffXdU: ...
    @staticmethod
    def Zero() -> SpatialAcceleration_TAutoDiffXdU: ...
    def get_coeffs(self) -> numpy.ndarray[object[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[object[3, 1]]: ...
    def translational(self) -> numpy.ndarray[object[3, 1]]: ...
    def __add__(self, arg0: SpatialAcceleration_TAutoDiffXdU) -> SpatialAcceleration_TAutoDiffXdU: ...
    def __copy__(self) -> SpatialAcceleration_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialAcceleration_TAutoDiffXdU: ...
    def __iadd__(self, arg0: SpatialAcceleration_TAutoDiffXdU) -> SpatialAcceleration_TAutoDiffXdU: ...
    def __imul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialAcceleration_TAutoDiffXdU: ...
    def __isub__(self, arg0: SpatialAcceleration_TAutoDiffXdU) -> SpatialAcceleration_TAutoDiffXdU: ...
    def __mul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialAcceleration_TAutoDiffXdU: ...
    def __neg__(self) -> SpatialAcceleration_TAutoDiffXdU: ...
    def __rmul__(self, arg0: pydrake.autodiffutils.AutoDiffXd) -> SpatialAcceleration_TAutoDiffXdU: ...
    def __sub__(self, arg0: SpatialAcceleration_TAutoDiffXdU) -> SpatialAcceleration_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody19SpatialAccelerationINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, alpha: numpy.ndarray[object[3, 1]], a: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, A: numpy.ndarray[object[6, 1]]) -> None: ...
    def ComposeWithMovingFrameAcceleration(self, position_of_moving_frame: numpy.ndarray[object[3, 1]], angular_velocity_of_this_frame: numpy.ndarray[object[3, 1]], velocity_of_moving_frame: SpatialVelocity_TExpressionU, acceleration_of_moving_frame: SpatialAcceleration_TExpressionU) -> SpatialAcceleration_TExpressionU: ...
    def Rotate(self, R_FE: pydrake.math.RotationMatrix_TExpressionU) -> SpatialAcceleration_TExpressionU: ...
    def SetZero(self) -> SpatialAcceleration_TExpressionU: ...
    def Shift(self, offset: numpy.ndarray[object[3, 1]], angular_velocity_of_this_frame: numpy.ndarray[object[3, 1]]) -> SpatialAcceleration_TExpressionU: ...
    def ShiftWithZeroAngularVelocity(self, offset: numpy.ndarray[object[3, 1]]) -> SpatialAcceleration_TExpressionU: ...
    @staticmethod
    def Zero() -> SpatialAcceleration_TExpressionU: ...
    def get_coeffs(self) -> numpy.ndarray[object[6, 1]]: ...
    def rotational(self) -> numpy.ndarray[object[3, 1]]: ...
    def translational(self) -> numpy.ndarray[object[3, 1]]: ...
    def __add__(self, arg0: SpatialAcceleration_TExpressionU) -> SpatialAcceleration_TExpressionU: ...
    def __copy__(self) -> SpatialAcceleration_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> SpatialAcceleration_TExpressionU: ...
    def __iadd__(self, arg0: SpatialAcceleration_TExpressionU) -> SpatialAcceleration_TExpressionU: ...
    def __imul__(self, arg0: pydrake.symbolic.Expression) -> SpatialAcceleration_TExpressionU: ...
    def __isub__(self, arg0: SpatialAcceleration_TExpressionU) -> SpatialAcceleration_TExpressionU: ...
    def __mul__(self, arg0: pydrake.symbolic.Expression) -> SpatialAcceleration_TExpressionU: ...
    def __neg__(self) -> SpatialAcceleration_TExpressionU: ...
    def __rmul__(self, arg0: pydrake.symbolic.Expression) -> SpatialAcceleration_TExpressionU: ...
    def __sub__(self, arg0: SpatialAcceleration_TExpressionU) -> SpatialAcceleration_TExpressionU: ...
