import flags
import numpy
import pydrake.common.eigen_geometry
import pydrake.geometry
import pydrake.math
import pydrake.multibody.math
import pydrake.multibody.plant
import pydrake.multibody.tree
import pydrake.planning
import pydrake.solvers
import pydrake.systems.framework
from typing import Callable, ClassVar, overload

class AngleBetweenVectorsConstraint(pydrake.solvers.Constraint):
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, frameA: pydrake.multibody.tree.Frame, a_A: numpy.ndarray[numpy.float64[3, 1]], frameB: pydrake.multibody.tree.Frame, b_B: numpy.ndarray[numpy.float64[3, 1]], angle_lower: float, angle_upper: float, plant_context: pydrake.systems.framework.Context) -> None: ...
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU, frameA: pydrake.multibody.tree.Frame_TAutoDiffXdU, a_A: numpy.ndarray[numpy.float64[3, 1]], frameB: pydrake.multibody.tree.Frame_TAutoDiffXdU, b_B: numpy.ndarray[numpy.float64[3, 1]], angle_lower: float, angle_upper: float, plant_context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...

class AngleBetweenVectorsCost(pydrake.solvers.Cost):
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, frameA: pydrake.multibody.tree.Frame, a_A: numpy.ndarray[numpy.float64[3, 1]], frameB: pydrake.multibody.tree.Frame, b_B: numpy.ndarray[numpy.float64[3, 1]], c: float, plant_context: pydrake.systems.framework.Context) -> None: ...
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU, frameA: pydrake.multibody.tree.Frame_TAutoDiffXdU, a_A: numpy.ndarray[numpy.float64[3, 1]], frameB: pydrake.multibody.tree.Frame_TAutoDiffXdU, b_B: numpy.ndarray[numpy.float64[3, 1]], c: float, plant_context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...

class ComInPolyhedronConstraint(pydrake.solvers.Constraint):
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, model_instances: list[pydrake.multibody.tree.ModelInstanceIndex] | None, expressed_frame: pydrake.multibody.tree.Frame, A: numpy.ndarray[numpy.float64[m, 3], flags.f_contiguous], lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]], plant_context: pydrake.systems.framework.Context) -> None: ...
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU, model_instances: list[pydrake.multibody.tree.ModelInstanceIndex] | None, expressed_frame: pydrake.multibody.tree.Frame_TAutoDiffXdU, A: numpy.ndarray[numpy.float64[m, 3], flags.f_contiguous], lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]], plant_context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...

class ComPositionConstraint(pydrake.solvers.Constraint):
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, model_instances: list[pydrake.multibody.tree.ModelInstanceIndex] | None, expressed_frame: pydrake.multibody.tree.Frame, plant_context: pydrake.systems.framework.Context) -> None: ...
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU, model_instances: list[pydrake.multibody.tree.ModelInstanceIndex] | None, expressed_frame: pydrake.multibody.tree.Frame_TAutoDiffXdU, plant_context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...

class DifferentialInverseKinematicsController(pydrake.systems.framework.Diagram):
    def __init__(self, differential_inverse_kinematics: object, planar_rotation_dof_indices: list[int]) -> None: ...
    def differential_inverse_kinematics(self) -> DifferentialInverseKinematicsSystem: ...
    def get_mutable_differential_inverse_kinematics(self) -> DifferentialInverseKinematicsSystem: ...
    def set_initial_position(self, context: pydrake.systems.framework.Context, value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class DifferentialInverseKinematicsIntegrator(pydrake.systems.framework.LeafSystem):
    @overload
    def __init__(self, robot: pydrake.multibody.plant.MultibodyPlant, frame_A: pydrake.multibody.tree.Frame, frame_E: pydrake.multibody.tree.Frame, time_step: float, parameters: DifferentialInverseKinematicsParameters, robot_context: pydrake.systems.framework.Context = ..., log_only_when_result_state_changes: bool = ...) -> None: ...
    @overload
    def __init__(self, robot: pydrake.multibody.plant.MultibodyPlant, frame_E: pydrake.multibody.tree.Frame, time_step: float, parameters: DifferentialInverseKinematicsParameters, robot_context: pydrake.systems.framework.Context = ..., log_only_when_result_state_changes: bool = ...) -> None: ...
    def ForwardKinematics(self, context: pydrake.systems.framework.Context) -> pydrake.math.RigidTransform: ...
    def SetPositions(self, context: pydrake.systems.framework.Context, positions: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def get_mutable_parameters(self) -> DifferentialInverseKinematicsParameters: ...
    def get_parameters(self) -> DifferentialInverseKinematicsParameters: ...

class DifferentialInverseKinematicsParameters:
    def __init__(self, num_positions: int, num_velocities: int = ...) -> None: ...
    def get_end_effector_angular_speed_limit(self) -> float: ...
    def get_end_effector_translational_velocity_limits(self) -> tuple[numpy.ndarray[numpy.float64[3, 1]], numpy.ndarray[numpy.float64[3, 1]]] | None: ...
    def get_end_effector_velocity_flag(self) -> numpy.ndarray[bool[6, 1]]: ...
    def get_joint_acceleration_limits(self) -> tuple[numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[numpy.float64[m, 1]]] | None: ...
    def get_joint_centering_gain(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def get_joint_position_limits(self) -> tuple[numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[numpy.float64[m, 1]]] | None: ...
    def get_joint_velocity_limits(self) -> tuple[numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[numpy.float64[m, 1]]] | None: ...
    def get_maximum_scaling_to_report_stuck(self) -> float: ...
    def get_mutable_solver_options(self) -> pydrake.solvers.SolverOptions: ...
    def get_nominal_joint_position(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def get_num_positions(self) -> int: ...
    def get_num_velocities(self) -> int: ...
    def get_time_step(self) -> float: ...
    def set_end_effector_angular_speed_limit(self, speed: float) -> None: ...
    def set_end_effector_translational_velocity_limits(self, lower: numpy.ndarray[numpy.float64[3, 1]], upper: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_end_effector_velocity_flag(self, flag_E: numpy.ndarray[bool[6, 1]]) -> None: ...
    def set_joint_acceleration_limits(self, arg0: tuple[numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[numpy.float64[m, 1]]]) -> None: ...
    def set_joint_centering_gain(self, K: numpy.ndarray[numpy.float64[m, n]]) -> None: ...
    def set_joint_position_limits(self, arg0: tuple[numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[numpy.float64[m, 1]]]) -> None: ...
    def set_joint_velocity_limits(self, arg0: tuple[numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[numpy.float64[m, 1]]]) -> None: ...
    def set_maximum_scaling_to_report_stuck(self, scaling: float) -> None: ...
    def set_nominal_joint_position(self, arg0: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_time_step(self, dt: float) -> None: ...

class DifferentialInverseKinematicsResult:
    joint_velocities: numpy.ndarray[numpy.float64[m, 1]] | None
    status: DifferentialInverseKinematicsStatus
    def __init__(self, **kwargs) -> None: ...

class DifferentialInverseKinematicsStatus:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kNoSolutionFound: ClassVar[DifferentialInverseKinematicsStatus] = ...
    kSolutionFound: ClassVar[DifferentialInverseKinematicsStatus] = ...
    kStuck: ClassVar[DifferentialInverseKinematicsStatus] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class DifferentialInverseKinematicsSystem(pydrake.systems.framework.LeafSystem):
    class CartesianPositionLimitConstraint(DifferentialInverseKinematicsSystem.Ingredient):
        class Config:
            __fields__: ClassVar[tuple] = ...  # read-only
            p_TG_next_lower: numpy.ndarray[numpy.float64[3, 1]]
            p_TG_next_upper: numpy.ndarray[numpy.float64[3, 1]]
            def __init__(self, **kwargs) -> None: ...
            def __copy__(self) -> DifferentialInverseKinematicsSystem.CartesianPositionLimitConstraint.Config: ...
            def __deepcopy__(self, arg0: dict) -> DifferentialInverseKinematicsSystem.CartesianPositionLimitConstraint.Config: ...
        def __init__(self, config: DifferentialInverseKinematicsSystem.CartesianPositionLimitConstraint.Config) -> None: ...
        def GetConfig(self) -> DifferentialInverseKinematicsSystem.CartesianPositionLimitConstraint.Config: ...
        def SetConfig(self, config: DifferentialInverseKinematicsSystem.CartesianPositionLimitConstraint.Config) -> None: ...

    class CartesianVelocityLimitConstraint(DifferentialInverseKinematicsSystem.Ingredient):
        class Config:
            __fields__: ClassVar[tuple] = ...  # read-only
            V_next_TG_limit: numpy.ndarray[numpy.float64[6, 1]]
            def __init__(self, **kwargs) -> None: ...
            def __copy__(self) -> DifferentialInverseKinematicsSystem.CartesianVelocityLimitConstraint.Config: ...
            def __deepcopy__(self, arg0: dict) -> DifferentialInverseKinematicsSystem.CartesianVelocityLimitConstraint.Config: ...
        def __init__(self, config: DifferentialInverseKinematicsSystem.CartesianVelocityLimitConstraint.Config) -> None: ...
        def GetConfig(self) -> DifferentialInverseKinematicsSystem.CartesianVelocityLimitConstraint.Config: ...
        def SetConfig(self, config: DifferentialInverseKinematicsSystem.CartesianVelocityLimitConstraint.Config) -> None: ...

    class CollisionConstraint(DifferentialInverseKinematicsSystem.Ingredient):
        class Config:
            __fields__: ClassVar[tuple] = ...  # read-only
            influence_distance: float
            safety_distance: float
            def __init__(self, **kwargs) -> None: ...
            def __copy__(self) -> DifferentialInverseKinematicsSystem.CollisionConstraint.Config: ...
            def __deepcopy__(self, arg0: dict) -> DifferentialInverseKinematicsSystem.CollisionConstraint.Config: ...
        def __init__(self, config: DifferentialInverseKinematicsSystem.CollisionConstraint.Config) -> None: ...
        def GetConfig(self) -> DifferentialInverseKinematicsSystem.CollisionConstraint.Config: ...
        def SetConfig(self, config: DifferentialInverseKinematicsSystem.CollisionConstraint.Config) -> None: ...
        def SetSelectDataForCollisionConstraintFunction(self, select_data_for_collision_constraint: Callable[[pydrake.planning.DofMask, pydrake.planning.RobotClearance, numpy.ndarray[numpy.float64[m, 1]], numpy.ndarray[numpy.float64[m, n]]], None]) -> None: ...

    class Ingredient:
        def __init__(self, *args, **kwargs) -> None: ...

    class JointCenteringCost(DifferentialInverseKinematicsSystem.Ingredient):
        class Config:
            __fields__: ClassVar[tuple] = ...  # read-only
            cartesian_axis_masks: dict[str, numpy.ndarray[numpy.float64[6, 1]]]
            posture_gain: float
            def __init__(self, **kwargs) -> None: ...
            def __copy__(self) -> DifferentialInverseKinematicsSystem.JointCenteringCost.Config: ...
            def __deepcopy__(self, arg0: dict) -> DifferentialInverseKinematicsSystem.JointCenteringCost.Config: ...
        def __init__(self, config: DifferentialInverseKinematicsSystem.JointCenteringCost.Config) -> None: ...
        def GetConfig(self) -> DifferentialInverseKinematicsSystem.JointCenteringCost.Config: ...
        def SetConfig(self, config: DifferentialInverseKinematicsSystem.JointCenteringCost.Config) -> None: ...

    class JointVelocityLimitConstraint(DifferentialInverseKinematicsSystem.Ingredient):
        class Config:
            __fields__: ClassVar[tuple] = ...  # read-only
            influence_margin: float
            min_margin: float
            def __init__(self, **kwargs) -> None: ...
            def __copy__(self) -> DifferentialInverseKinematicsSystem.JointVelocityLimitConstraint.Config: ...
            def __deepcopy__(self, arg0: dict) -> DifferentialInverseKinematicsSystem.JointVelocityLimitConstraint.Config: ...
        def __init__(self, config: DifferentialInverseKinematicsSystem.JointVelocityLimitConstraint.Config, joint_limits: pydrake.planning.JointLimits) -> None: ...
        def GetConfig(self) -> DifferentialInverseKinematicsSystem.JointVelocityLimitConstraint.Config: ...
        def GetJointLimits(self) -> pydrake.planning.JointLimits: ...
        def SetConfig(self, config: DifferentialInverseKinematicsSystem.JointVelocityLimitConstraint.Config) -> None: ...
        def SetJointLimits(self, joint_limits: pydrake.planning.JointLimits) -> None: ...

    class LeastSquaresCost(DifferentialInverseKinematicsSystem.Ingredient):
        class Config:
            __fields__: ClassVar[tuple] = ...  # read-only
            cartesian_axis_masks: dict[str, numpy.ndarray[numpy.float64[6, 1]]]
            cartesian_qp_weight: float
            use_legacy_implementation: bool
            def __init__(self, **kwargs) -> None: ...
            def __copy__(self) -> DifferentialInverseKinematicsSystem.LeastSquaresCost.Config: ...
            def __deepcopy__(self, arg0: dict) -> DifferentialInverseKinematicsSystem.LeastSquaresCost.Config: ...
        def __init__(self, config: DifferentialInverseKinematicsSystem.LeastSquaresCost.Config) -> None: ...
        def GetConfig(self) -> DifferentialInverseKinematicsSystem.LeastSquaresCost.Config: ...
        def SetConfig(self, config: DifferentialInverseKinematicsSystem.LeastSquaresCost.Config) -> None: ...

    class Recipe:
        def __init__(self) -> None: ...
        def AddIngredient(self, ingredient: object) -> None: ...
        def ingredient(self, i: int) -> DifferentialInverseKinematicsSystem.Ingredient: ...
        def num_ingredients(self) -> int: ...
    def __init__(self, recipe: object, task_frame: str, collision_checker: object, active_dof: pydrake.planning.DofMask, time_step: float, K_VX: float, Vd_TG_limit: pydrake.multibody.math.SpatialVelocity) -> None: ...
    def K_VX(self) -> float: ...
    def Vd_TG_limit(self) -> pydrake.multibody.math.SpatialVelocity: ...
    def active_dof(self) -> pydrake.planning.DofMask: ...
    def collision_checker(self) -> pydrake.planning.CollisionChecker: ...
    def get_input_port_desired_cartesian_poses(self) -> pydrake.systems.framework.InputPort: ...
    def get_input_port_desired_cartesian_velocities(self) -> pydrake.systems.framework.InputPort: ...
    def get_input_port_nominal_posture(self) -> pydrake.systems.framework.InputPort: ...
    def get_input_port_position(self) -> pydrake.systems.framework.InputPort: ...
    def get_output_port_commanded_velocity(self) -> pydrake.systems.framework.OutputPort: ...
    def plant(self) -> pydrake.multibody.plant.MultibodyPlant: ...
    def recipe(self) -> DifferentialInverseKinematicsSystem.Recipe: ...
    def task_frame(self) -> pydrake.multibody.tree.Frame: ...
    def time_step(self) -> float: ...

class DistanceConstraint(pydrake.solvers.Constraint):
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, geometry_pair: tuple[pydrake.geometry.GeometryId], plant_context: pydrake.systems.framework.Context, distance_lower: float, distance_upper: float) -> None: ...

class GazeTargetConstraint(pydrake.solvers.Constraint):
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, frameA: pydrake.multibody.tree.Frame, p_AS: numpy.ndarray[numpy.float64[3, 1]], n_A: numpy.ndarray[numpy.float64[3, 1]], frameB: pydrake.multibody.tree.Frame, p_BT: numpy.ndarray[numpy.float64[3, 1]], cone_half_angle: float, plant_context: pydrake.systems.framework.Context) -> None: ...
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU, frameA: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_AS: numpy.ndarray[numpy.float64[3, 1]], n_A: numpy.ndarray[numpy.float64[3, 1]], frameB: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_BT: numpy.ndarray[numpy.float64[3, 1]], cone_half_angle: float, plant_context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...

class GlobalInverseKinematics:
    class Options:
        approach: pydrake.solvers.MixedIntegerRotationConstraintGenerator.Approach
        interval_binning: pydrake.solvers.IntervalBinning
        linear_constraint_only: bool
        num_intervals_per_half_axis: int
        def __init__(self) -> None: ...

    class Polytope3D:
        A: numpy.ndarray[numpy.float64[m, 3]]
        b: numpy.ndarray[numpy.float64[m, 1]]
        def __init__(self, A: numpy.ndarray[numpy.float64[m, 3], flags.f_contiguous], b: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, options: GlobalInverseKinematics.Options = ...) -> None: ...
    def AddJointLimitConstraint(self, body_index: pydrake.multibody.tree.BodyIndex, joint_lower_bound: float, joint_upper_bound: float, linear_constraint_approximation: bool = ...) -> None: ...
    def AddPostureCost(self, q_desired: numpy.ndarray[numpy.float64[m, 1]], body_position_cost: numpy.ndarray[numpy.float64[m, 1]], body_orientation_cost: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def AddWorldOrientationConstraint(self, body_index: pydrake.multibody.tree.BodyIndex, desired_orientation: pydrake.common.eigen_geometry.Quaternion, angle_tol: float) -> pydrake.solvers.BindingTLinearConstraintU: ...
    def AddWorldPositionConstraint(self, body_index: pydrake.multibody.tree.BodyIndex, p_BQ: numpy.ndarray[numpy.float64[3, 1]], box_lb_F: numpy.ndarray[numpy.float64[3, 1]], box_ub_F: numpy.ndarray[numpy.float64[3, 1]], X_WF: pydrake.math.RigidTransform = ...) -> pydrake.solvers.BindingTLinearConstraintU: ...
    def AddWorldRelativePositionConstraint(self, body_index_B: pydrake.multibody.tree.BodyIndex, p_BQ: numpy.ndarray[numpy.float64[3, 1]], body_index_A: pydrake.multibody.tree.BodyIndex, p_AP: numpy.ndarray[numpy.float64[3, 1]], box_lb_F: numpy.ndarray[numpy.float64[3, 1]], box_ub_F: numpy.ndarray[numpy.float64[3, 1]], X_WF: pydrake.math.RigidTransform = ...) -> pydrake.solvers.BindingTLinearConstraintU: ...
    def BodyPointInOneOfRegions(self, body_index: pydrake.multibody.tree.BodyIndex, p_BQ: numpy.ndarray[numpy.float64[3, 1]], region_vertices: list[numpy.ndarray[numpy.float64[3, n]]]) -> numpy.ndarray[object[m, 1]]: ...
    def BodySphereInOneOfPolytopes(self, body_index: pydrake.multibody.tree.BodyIndex, p_BQ: numpy.ndarray[numpy.float64[3, 1]], radius: float, polytopes: list[GlobalInverseKinematics.Polytope3D]) -> numpy.ndarray[object[m, 1]]: ...
    def ReconstructGeneralizedPositionSolution(self, result: pydrake.solvers.MathematicalProgramResult) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def SetInitialGuess(self, q: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def body_position(self, body_index: pydrake.multibody.tree.BodyIndex) -> numpy.ndarray[object[3, 1]]: ...
    def body_rotation_matrix(self, body_index: pydrake.multibody.tree.BodyIndex) -> numpy.ndarray[object[3, 3]]: ...
    def get_mutable_prog(self) -> pydrake.solvers.MathematicalProgram: ...
    def prog(self) -> pydrake.solvers.MathematicalProgram: ...

class InverseKinematics:
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, with_joint_limits: bool = ...) -> None: ...
    def AddAngleBetweenVectorsConstraint(self, frameA: pydrake.multibody.tree.Frame, na_A: numpy.ndarray[numpy.float64[3, 1]], frameB: pydrake.multibody.tree.Frame, nb_B: numpy.ndarray[numpy.float64[3, 1]], angle_lower: float, angle_upper: float) -> pydrake.solvers.BindingTConstraintU: ...
    def AddAngleBetweenVectorsCost(self, frameA: pydrake.multibody.tree.Frame, na_A: numpy.ndarray[numpy.float64[3, 1]], frameB: pydrake.multibody.tree.Frame, nb_B: numpy.ndarray[numpy.float64[3, 1]], c: float) -> pydrake.solvers.BindingTCostU: ...
    def AddDistanceConstraint(self, geometry_pair: tuple[pydrake.geometry.GeometryId], distance_lower: float, distance_upper: float) -> pydrake.solvers.BindingTConstraintU: ...
    def AddGazeTargetConstraint(self, frameA: pydrake.multibody.tree.Frame, p_AS: numpy.ndarray[numpy.float64[3, 1]], n_A: numpy.ndarray[numpy.float64[3, 1]], frameB: pydrake.multibody.tree.Frame, p_BT: numpy.ndarray[numpy.float64[3, 1]], cone_half_angle: float) -> pydrake.solvers.BindingTConstraintU: ...
    def AddMinimumDistanceLowerBoundConstraint(self, bound: float, influence_distance_offset: float = ...) -> pydrake.solvers.BindingTConstraintU: ...
    def AddMinimumDistanceUpperBoundConstraint(self, bound: float, influence_distance_offset: float) -> pydrake.solvers.BindingTConstraintU: ...
    def AddOrientationConstraint(self, frameAbar: pydrake.multibody.tree.Frame, R_AbarA: pydrake.math.RotationMatrix, frameBbar: pydrake.multibody.tree.Frame, R_BbarB: pydrake.math.RotationMatrix, theta_bound: float) -> pydrake.solvers.BindingTConstraintU: ...
    def AddOrientationCost(self, frameAbar: pydrake.multibody.tree.Frame, R_AbarA: pydrake.math.RotationMatrix, frameBbar: pydrake.multibody.tree.Frame, R_BbarB: pydrake.math.RotationMatrix, c: float) -> pydrake.solvers.BindingTCostU: ...
    def AddPointToLineDistanceConstraint(self, frame_point: pydrake.multibody.tree.Frame, p_B1P: numpy.ndarray[numpy.float64[3, 1]], frame_line: pydrake.multibody.tree.Frame, p_B2Q: numpy.ndarray[numpy.float64[3, 1]], n_B2: numpy.ndarray[numpy.float64[3, 1]], distance_lower: float, distance_upper: float) -> pydrake.solvers.BindingTConstraintU: ...
    def AddPointToPointDistanceConstraint(self, frame1: pydrake.multibody.tree.Frame, p_B1P1: numpy.ndarray[numpy.float64[3, 1]], frame2: pydrake.multibody.tree.Frame, p_B2P2: numpy.ndarray[numpy.float64[3, 1]], distance_lower: float, distance_upper: float) -> pydrake.solvers.BindingTConstraintU: ...
    def AddPolyhedronConstraint(self, frameF: pydrake.multibody.tree.Frame, frameG: pydrake.multibody.tree.Frame, p_GP: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous], A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], b: numpy.ndarray[numpy.float64[m, 1]]) -> pydrake.solvers.BindingTConstraintU: ...
    @overload
    def AddPositionConstraint(self, frameB: pydrake.multibody.tree.Frame, p_BQ: numpy.ndarray[numpy.float64[3, 1]], frameA: pydrake.multibody.tree.Frame, p_AQ_lower: numpy.ndarray[numpy.float64[3, 1]], p_AQ_upper: numpy.ndarray[numpy.float64[3, 1]]) -> pydrake.solvers.BindingTConstraintU: ...
    @overload
    def AddPositionConstraint(self, frameB: pydrake.multibody.tree.Frame, p_BQ: numpy.ndarray[numpy.float64[3, 1]], frameAbar: pydrake.multibody.tree.Frame, X_AbarA: pydrake.math.RigidTransform | None, p_AQ_lower: numpy.ndarray[numpy.float64[3, 1]], p_AQ_upper: numpy.ndarray[numpy.float64[3, 1]]) -> pydrake.solvers.BindingTConstraintU: ...
    def AddPositionCost(self, frameA: pydrake.multibody.tree.Frame, p_AP: numpy.ndarray[numpy.float64[3, 1]], frameB: pydrake.multibody.tree.Frame, p_BQ: numpy.ndarray[numpy.float64[3, 1]], C: numpy.ndarray[numpy.float64[3, 3], flags.f_contiguous]) -> pydrake.solvers.BindingTCostU: ...
    def context(self) -> pydrake.systems.framework.Context: ...
    def get_mutable_context(self) -> pydrake.systems.framework.Context: ...
    def get_mutable_prog(self) -> pydrake.solvers.MathematicalProgram: ...
    def prog(self) -> pydrake.solvers.MathematicalProgram: ...
    def q(self) -> numpy.ndarray[object[m, 1]]: ...

class MinimumDistanceLowerBoundConstraint(pydrake.solvers.Constraint):
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, bound: float, plant_context: pydrake.systems.framework.Context, penalty_function: Callable[[float, bool], tuple] = ..., influence_distance_offset: float = ...) -> None: ...
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU, bound: float, plant_context: pydrake.systems.framework.Context_TAutoDiffXdU, penalty_function: Callable[[float, bool], tuple] = ..., influence_distance_offset: float = ...) -> None: ...
    @overload
    def __init__(self, collision_checker: pydrake.planning.CollisionChecker, bound: float, collision_checker_context: pydrake.planning.CollisionCheckerContext, penalty_function: Callable[[float, bool], tuple] = ..., influence_distance_offset: float = ...) -> None: ...
    def distance_bound(self) -> float: ...
    def influence_distance(self) -> float: ...

class MinimumDistanceUpperBoundConstraint(pydrake.solvers.Constraint):
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, bound: float, plant_context: pydrake.systems.framework.Context, influence_distance_offset: float, penalty_function: Callable[[float, bool], tuple] = ...) -> None: ...
    def distance_bound(self) -> float: ...
    def influence_distance(self) -> float: ...

class OrientationConstraint(pydrake.solvers.Constraint):
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, frameAbar: pydrake.multibody.tree.Frame, R_AbarA: pydrake.math.RotationMatrix, frameBbar: pydrake.multibody.tree.Frame, R_BbarB: pydrake.math.RotationMatrix, theta_bound: float, plant_context: pydrake.systems.framework.Context) -> None: ...

class OrientationCost(pydrake.solvers.Cost):
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, frameAbar: pydrake.multibody.tree.Frame, R_AbarA: pydrake.math.RotationMatrix, frameBbar: pydrake.multibody.tree.Frame, R_BbarB: pydrake.math.RotationMatrix, c: float, plant_context: pydrake.systems.framework.Context) -> None: ...
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU, frameAbar: pydrake.multibody.tree.Frame_TAutoDiffXdU, R_AbarA: pydrake.math.RotationMatrix, frameBbar: pydrake.multibody.tree.Frame_TAutoDiffXdU, R_BbarB: pydrake.math.RotationMatrix, c: float, plant_context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...

class PointToLineDistanceConstraint(pydrake.solvers.Constraint):
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, frame_point: pydrake.multibody.tree.Frame, p_B1P: numpy.ndarray[numpy.float64[3, 1]], frame_line: pydrake.multibody.tree.Frame, p_B2Q: numpy.ndarray[numpy.float64[3, 1]], n_B2: numpy.ndarray[numpy.float64[3, 1]], distance_lower: float, distance_upper: float, plant_context: pydrake.systems.framework.Context) -> None: ...
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU, frame_point: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_B1P: numpy.ndarray[numpy.float64[3, 1]], frame_line: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_B2Q: numpy.ndarray[numpy.float64[3, 1]], n_B2: numpy.ndarray[numpy.float64[3, 1]], distance_lower: float, distance_upper: float, plant_context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...

class PointToPointDistanceConstraint(pydrake.solvers.Constraint):
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, frame1: pydrake.multibody.tree.Frame, p_B1P1: numpy.ndarray[numpy.float64[3, 1]], frame2: pydrake.multibody.tree.Frame, p_B2P2: numpy.ndarray[numpy.float64[3, 1]], distance_lower: float, distance_upper: float, plant_context: pydrake.systems.framework.Context) -> None: ...
    @overload
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU, frame1: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_B1P1: numpy.ndarray[numpy.float64[3, 1]], frame2: pydrake.multibody.tree.Frame_TAutoDiffXdU, p_B2P2: numpy.ndarray[numpy.float64[3, 1]], distance_lower: float, distance_upper: float, plant_context: pydrake.systems.framework.Context_TAutoDiffXdU) -> None: ...

class PolyhedronConstraint(pydrake.solvers.Constraint):
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, frameF: pydrake.multibody.tree.Frame, frameG: pydrake.multibody.tree.Frame, p_GP: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous], A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], b: numpy.ndarray[numpy.float64[m, 1]], plant_context: pydrake.systems.framework.Context) -> None: ...

class PositionConstraint(pydrake.solvers.Constraint):
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, frameA: pydrake.multibody.tree.Frame, p_AQ_lower: numpy.ndarray[numpy.float64[3, 1]], p_AQ_upper: numpy.ndarray[numpy.float64[3, 1]], frameB: pydrake.multibody.tree.Frame, p_BQ: numpy.ndarray[numpy.float64[3, 1]], plant_context: pydrake.systems.framework.Context) -> None: ...
    def UpdateLowerBound(self, new_lb: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def UpdateUpperBound(self, new_ub: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def set_bounds(self, new_lb: numpy.ndarray[numpy.float64[m, 1]], new_ub: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...

class PositionCost(pydrake.solvers.Cost):
    def __init__(self, plant: pydrake.multibody.plant.MultibodyPlant, frameA: pydrake.multibody.tree.Frame, p_AP: numpy.ndarray[numpy.float64[3, 1]], frameB: pydrake.multibody.tree.Frame, p_BQ: numpy.ndarray[numpy.float64[3, 1]], C: numpy.ndarray[numpy.float64[3, 3], flags.f_contiguous], plant_context: pydrake.systems.framework.Context) -> None: ...

class UnitQuaternionConstraint(pydrake.solvers.Constraint):
    def __init__(self) -> None: ...

def AddMultibodyPlantConstraints(plant: object, q: numpy.ndarray[object[m, 1]], prog: pydrake.solvers.MathematicalProgram, plant_context: pydrake.systems.framework.Context = ...) -> list[pydrake.solvers.BindingTConstraintU]: ...
@overload
def AddUnitQuaternionConstraintOnPlant(plant: pydrake.multibody.plant.MultibodyPlant, q_vars: numpy.ndarray[object[m, 1]], prog: pydrake.solvers.MathematicalProgram) -> list[pydrake.solvers.BindingTConstraintU]: ...
@overload
def AddUnitQuaternionConstraintOnPlant(plant: pydrake.multibody.plant.MultibodyPlant_TAutoDiffXdU, q_vars: numpy.ndarray[object[m, 1]], prog: pydrake.solvers.MathematicalProgram) -> list[pydrake.solvers.BindingTConstraintU]: ...
def DoDifferentialInverseKinematics(*args, **kwargs): ...
