import numpy
import pydrake.autodiffutils
import pydrake.systems.framework
from pydrake.common.cpp_template import DeformableBodyConfig_ as DeformableBodyConfig_, ForceDensityFieldBase_ as ForceDensityFieldBase_
from typing import ClassVar

class DeformableBodyConfig:
    def __init__(self) -> None: ...
    def mass_damping_coefficient(self) -> float: ...
    def mass_density(self) -> float: ...
    def material_model(self) -> MaterialModel: ...
    def poissons_ratio(self) -> float: ...
    def set_mass_damping_coefficient(self, mass_damping_coefficient: float) -> None: ...
    def set_mass_density(self, mass_density: float) -> None: ...
    def set_material_model(self, material_model: MaterialModel) -> None: ...
    def set_poissons_ratio(self, poissons_ratio: float) -> None: ...
    def set_stiffness_damping_coefficient(self, stiffness_damping_coefficient: float) -> None: ...
    def set_youngs_modulus(self, youngs_modulus: float) -> None: ...
    def stiffness_damping_coefficient(self) -> float: ...
    def youngs_modulus(self) -> float: ...
    def __copy__(self) -> DeformableBodyConfig: ...
    def __deepcopy__(self, arg0: dict) -> DeformableBodyConfig: ...

class DeformableBodyConfig_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def mass_damping_coefficient(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def mass_density(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def material_model(self) -> MaterialModel: ...
    def poissons_ratio(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def set_mass_damping_coefficient(self, mass_damping_coefficient: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def set_mass_density(self, mass_density: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def set_material_model(self, material_model: MaterialModel) -> None: ...
    def set_poissons_ratio(self, poissons_ratio: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def set_stiffness_damping_coefficient(self, stiffness_damping_coefficient: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def set_youngs_modulus(self, youngs_modulus: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def stiffness_damping_coefficient(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def youngs_modulus(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def __copy__(self) -> DeformableBodyConfig_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> DeformableBodyConfig_TAutoDiffXdU: ...

class ForceDensityFieldBase:
    def __init__(self, *args, **kwargs) -> None: ...
    def Clone(self) -> ForceDensityFieldBase: ...
    def EvaluateAt(self, context: pydrake.systems.framework.Context, p_WQ: numpy.ndarray[numpy.float64[3, 1]]) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def density_type(self) -> ForceDensityType: ...
    def __copy__(self) -> ForceDensityFieldBase: ...
    def __deepcopy__(self, arg0: dict) -> ForceDensityFieldBase: ...

class ForceDensityFieldBase_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Clone(self) -> ForceDensityFieldBase_TAutoDiffXdU: ...
    def EvaluateAt(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, p_WQ: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def density_type(self) -> ForceDensityType: ...
    def __copy__(self) -> ForceDensityFieldBase_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> ForceDensityFieldBase_TAutoDiffXdU: ...

class ForceDensityFieldBase_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Clone(self) -> ForceDensityFieldBase_TExpressionU: ...
    def EvaluateAt(self, context: pydrake.systems.framework.Context_TExpressionU, p_WQ: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def density_type(self) -> ForceDensityType: ...
    def __copy__(self) -> ForceDensityFieldBase_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> ForceDensityFieldBase_TExpressionU: ...

class ForceDensityType:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kPerCurrentVolume: ClassVar[ForceDensityType] = ...
    kPerReferenceVolume: ClassVar[ForceDensityType] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class MaterialModel:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kCorotated: ClassVar[MaterialModel] = ...
    kLinear: ClassVar[MaterialModel] = ...
    kLinearCorotated: ClassVar[MaterialModel] = ...
    kNeoHookean: ClassVar[MaterialModel] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class _TemporaryName_N5drake9multibody21ForceDensityFieldBaseIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Clone(self) -> ForceDensityFieldBase_TAutoDiffXdU: ...
    def EvaluateAt(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, p_WQ: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def density_type(self) -> ForceDensityType: ...
    def __copy__(self) -> ForceDensityFieldBase_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> ForceDensityFieldBase_TAutoDiffXdU: ...

class _TemporaryName_N5drake9multibody21ForceDensityFieldBaseINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Clone(self) -> ForceDensityFieldBase_TExpressionU: ...
    def EvaluateAt(self, context: pydrake.systems.framework.Context_TExpressionU, p_WQ: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def density_type(self) -> ForceDensityType: ...
    def __copy__(self) -> ForceDensityFieldBase_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> ForceDensityFieldBase_TExpressionU: ...

class _TemporaryName_N5drake9multibody3fem20DeformableBodyConfigIN5Eigen14AutoDiffScalarINS3_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def mass_damping_coefficient(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def mass_density(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def material_model(self) -> MaterialModel: ...
    def poissons_ratio(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def set_mass_damping_coefficient(self, mass_damping_coefficient: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def set_mass_density(self, mass_density: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def set_material_model(self, material_model: MaterialModel) -> None: ...
    def set_poissons_ratio(self, poissons_ratio: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def set_stiffness_damping_coefficient(self, stiffness_damping_coefficient: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def set_youngs_modulus(self, youngs_modulus: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def stiffness_damping_coefficient(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def youngs_modulus(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def __copy__(self) -> DeformableBodyConfig_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> DeformableBodyConfig_TAutoDiffXdU: ...
