import flags
import numpy
import pydrake.autodiffutils
import pydrake.common
import pydrake.common.eigen_geometry
import pydrake.symbolic
import pydrake.symbolic as _sym
from _typeshed import Incomplete
from pydrake.common.cpp_template import BsplineBasis_ as BsplineBasis_, RigidTransform_ as RigidTransform_, RollPitchYaw_ as RollPitchYaw_, RotationMatrix_ as RotationMatrix_
from typing import Any, Callable, ClassVar, overload

__getattr__: Callable

class BarycentricMesh:
    def __init__(self, arg0: list[set[float]]) -> None: ...
    def Eval(self, arg0: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], arg1: numpy.ndarray[numpy.float64[m, 1]]) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def EvalBarycentricWeights(self, arg0: numpy.ndarray[numpy.float64[m, 1]]) -> tuple[numpy.ndarray[numpy.int32[m, 1]], numpy.ndarray[numpy.float64[m, 1]]]: ...
    def MeshValuesFrom(self, arg0: Callable[[numpy.ndarray[numpy.float64[m, 1]]], numpy.ndarray[numpy.float64[m, 1]]]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def get_all_mesh_points(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def get_input_grid(self) -> list[set[float]]: ...
    def get_input_size(self) -> int: ...
    def get_mesh_point(self, arg0: int) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def get_num_interpolants(self) -> int: ...
    def get_num_mesh_points(self) -> int: ...

class BsplineBasis:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, order: int, knots: list[float]) -> None: ...
    @overload
    def __init__(self, order: int, num_basis_functions: int, type: KnotVectorType = ..., initial_parameter_value: float = ..., final_parameter_value: float = ...) -> None: ...
    @overload
    def __init__(self, other: BsplineBasis) -> None: ...
    @overload
    def ComputeActiveBasisFunctionIndices(self, parameter_interval) -> list[int]: ...
    @overload
    def ComputeActiveBasisFunctionIndices(self, parameter_value: float) -> list[int]: ...
    def EvaluateBasisFunctionI(self, i: int, parameter_value: float) -> float: ...
    def EvaluateCurve(self, control_points: list[numpy.ndarray[numpy.float64[m, 1]]], parameter_value: float) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def EvaluateLinearInControlPoints(self, parameter_value: float) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def FindContainingInterval(self, parameter_value: float) -> int: ...
    def degree(self) -> int: ...
    def final_parameter_value(self) -> float: ...
    def initial_parameter_value(self) -> float: ...
    def knots(self) -> list[float]: ...
    def num_basis_functions(self) -> int: ...
    def order(self) -> int: ...

class BsplineBasis_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, order: int, knots: list[pydrake.autodiffutils.AutoDiffXd]) -> None: ...
    @overload
    def __init__(self, order: int, num_basis_functions: int, type: KnotVectorType = ..., initial_parameter_value: pydrake.autodiffutils.AutoDiffXd = ..., final_parameter_value: pydrake.autodiffutils.AutoDiffXd = ...) -> None: ...
    @overload
    def __init__(self, other: BsplineBasis_TAutoDiffXdU) -> None: ...
    @overload
    def ComputeActiveBasisFunctionIndices(self, parameter_interval) -> list[int]: ...
    @overload
    def ComputeActiveBasisFunctionIndices(self, parameter_value: pydrake.autodiffutils.AutoDiffXd) -> list[int]: ...
    def EvaluateBasisFunctionI(self, i: int, parameter_value: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
    def EvaluateCurve(self, control_points: list[numpy.ndarray[object[m, 1]]], parameter_value: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, 1]]: ...
    def EvaluateLinearInControlPoints(self, parameter_value: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, 1]]: ...
    def FindContainingInterval(self, parameter_value: pydrake.autodiffutils.AutoDiffXd) -> int: ...
    def degree(self) -> int: ...
    def final_parameter_value(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def initial_parameter_value(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def knots(self) -> list[pydrake.autodiffutils.AutoDiffXd]: ...
    def num_basis_functions(self) -> int: ...
    def order(self) -> int: ...

class BsplineBasis_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, order: int, knots: list[pydrake.symbolic.Expression]) -> None: ...
    @overload
    def __init__(self, order: int, num_basis_functions: int, type: KnotVectorType = ..., initial_parameter_value: pydrake.symbolic.Expression = ..., final_parameter_value: pydrake.symbolic.Expression = ...) -> None: ...
    @overload
    def __init__(self, other: BsplineBasis_TExpressionU) -> None: ...
    @overload
    def ComputeActiveBasisFunctionIndices(self, parameter_interval) -> list[int]: ...
    @overload
    def ComputeActiveBasisFunctionIndices(self, parameter_value: pydrake.symbolic.Expression) -> list[int]: ...
    def EvaluateBasisFunctionI(self, i: int, parameter_value: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
    def EvaluateCurve(self, control_points: list[numpy.ndarray[object[m, 1]]], parameter_value: pydrake.symbolic.Expression) -> numpy.ndarray[object[m, 1]]: ...
    def EvaluateLinearInControlPoints(self, parameter_value: pydrake.symbolic.Expression) -> numpy.ndarray[object[m, 1]]: ...
    def FindContainingInterval(self, parameter_value: pydrake.symbolic.Expression) -> int: ...
    def degree(self) -> int: ...
    def final_parameter_value(self) -> pydrake.symbolic.Expression: ...
    def initial_parameter_value(self) -> pydrake.symbolic.Expression: ...
    def knots(self) -> list[pydrake.symbolic.Expression]: ...
    def num_basis_functions(self) -> int: ...
    def order(self) -> int: ...

class KnotVectorType:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kClampedUniform: ClassVar[KnotVectorType] = ...
    kUniform: ClassVar[KnotVectorType] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class NumericalGradientMethod:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kBackward: ClassVar[NumericalGradientMethod] = ...
    kCentral: ClassVar[NumericalGradientMethod] = ...
    kForward: ClassVar[NumericalGradientMethod] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class NumericalGradientOption:
    def __init__(self, method: NumericalGradientMethod, function_accuracy: float = ...) -> None: ...
    def NumericalGradientMethod(self) -> NumericalGradientMethod: ...
    def perturbation_size(self) -> float: ...

class RigidTransform:
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: RigidTransform) -> None: ...
    @overload
    def __init__(self, R: RotationMatrix, p: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    @overload
    def __init__(self, rpy: RollPitchYaw, p: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    @overload
    def __init__(self, quaternion: pydrake.common.eigen_geometry.Quaternion, p: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    @overload
    def __init__(self, theta_lambda: pydrake.common.eigen_geometry.AngleAxis, p: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    @overload
    def __init__(self, R: RotationMatrix) -> None: ...
    @overload
    def __init__(self, p: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    @overload
    def __init__(self, pose: pydrake.common.eigen_geometry.Isometry3) -> None: ...
    @overload
    def __init__(self, pose: numpy.ndarray[numpy.float64[m, n]]) -> None: ...
    def GetAsIsometry3(self) -> pydrake.common.eigen_geometry.Isometry3: ...
    def GetAsMatrix34(self) -> numpy.ndarray[numpy.float64[3, 4]]: ...
    def GetAsMatrix4(self) -> numpy.ndarray[numpy.float64[4, 4]]: ...
    def GetMaximumAbsoluteDifference(self, other: RigidTransform) -> float: ...
    def GetMaximumAbsoluteTranslationDifference(self, other: RigidTransform) -> float: ...
    @staticmethod
    def Identity() -> RigidTransform: ...
    def InvertAndCompose(self, other: RigidTransform) -> RigidTransform: ...
    def IsExactlyEqualTo(self, other: RigidTransform) -> bool: ...
    def IsExactlyIdentity(self) -> bool: ...
    def IsNearlyEqualTo(self, other: RigidTransform, tolerance: float) -> bool: ...
    @overload
    def IsNearlyIdentity(self, translation_tolerance: float) -> bool: ...
    @overload
    def IsNearlyIdentity(self) -> Any: ...
    @staticmethod
    def MakeUnchecked(pose: numpy.ndarray[numpy.float64[3, 4]]) -> RigidTransform: ...
    def SetFromIsometry3(self, pose: pydrake.common.eigen_geometry.Isometry3) -> None: ...
    def SetIdentity(self) -> RigidTransform: ...
    def cast𝓣AutoDiffXd𝓤(self) -> RigidTransform_TAutoDiffXdU: ...
    def cast𝓣Expression𝓤(self) -> RigidTransform_TExpressionU: ...
    def cast𝓣float𝓤(self) -> RigidTransform: ...
    def inverse(self) -> RigidTransform: ...
    def rotation(self) -> RotationMatrix: ...
    def set(self, R: RotationMatrix, p: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    @overload
    def set_rotation(self, R: RotationMatrix) -> None: ...
    @overload
    def set_rotation(self, rpy: RollPitchYaw) -> None: ...
    @overload
    def set_rotation(self, quaternion: pydrake.common.eigen_geometry.Quaternion) -> None: ...
    @overload
    def set_rotation(self, theta_lambda: pydrake.common.eigen_geometry.AngleAxis) -> None: ...
    def set_translation(self, p: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def translation(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def __copy__(self) -> RigidTransform: ...
    def __deepcopy__(self, arg0: dict) -> RigidTransform: ...

class RigidTransform_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: RigidTransform_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, R: RotationMatrix_TAutoDiffXdU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, rpy: RollPitchYaw_TAutoDiffXdU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, quaternion: pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, theta_lambda: pydrake.common.eigen_geometry.AngleAxis_TAutoDiffXdU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, R: RotationMatrix_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, pose: pydrake.common.eigen_geometry.Isometry3_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, pose: numpy.ndarray[object[m, n]]) -> None: ...
    def GetAsIsometry3(self) -> pydrake.common.eigen_geometry.Isometry3_TAutoDiffXdU: ...
    def GetAsMatrix34(self) -> numpy.ndarray[object[3, 4]]: ...
    def GetAsMatrix4(self) -> numpy.ndarray[object[4, 4]]: ...
    def GetMaximumAbsoluteDifference(self, other: RigidTransform_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def GetMaximumAbsoluteTranslationDifference(self, other: RigidTransform_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    @staticmethod
    def Identity() -> RigidTransform_TAutoDiffXdU: ...
    def InvertAndCompose(self, other: RigidTransform_TAutoDiffXdU) -> RigidTransform_TAutoDiffXdU: ...
    def IsExactlyEqualTo(self, other: RigidTransform_TAutoDiffXdU) -> bool: ...
    def IsExactlyIdentity(self) -> bool: ...
    def IsNearlyEqualTo(self, other: RigidTransform_TAutoDiffXdU, tolerance: float) -> bool: ...
    @overload
    def IsNearlyIdentity(self, translation_tolerance: float) -> bool: ...
    @overload
    def IsNearlyIdentity(self) -> Any: ...
    @staticmethod
    def MakeUnchecked(pose: numpy.ndarray[object[3, 4]]) -> RigidTransform_TAutoDiffXdU: ...
    def SetFromIsometry3(self, pose: pydrake.common.eigen_geometry.Isometry3_TAutoDiffXdU) -> None: ...
    def SetIdentity(self) -> RigidTransform_TAutoDiffXdU: ...
    def cast𝓣AutoDiffXd𝓤(self) -> RigidTransform_TAutoDiffXdU: ...
    def inverse(self) -> RigidTransform_TAutoDiffXdU: ...
    def rotation(self) -> RotationMatrix_TAutoDiffXdU: ...
    def set(self, R: RotationMatrix_TAutoDiffXdU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def set_rotation(self, R: RotationMatrix_TAutoDiffXdU) -> None: ...
    @overload
    def set_rotation(self, rpy: RollPitchYaw_TAutoDiffXdU) -> None: ...
    @overload
    def set_rotation(self, quaternion: pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU) -> None: ...
    @overload
    def set_rotation(self, theta_lambda: pydrake.common.eigen_geometry.AngleAxis_TAutoDiffXdU) -> None: ...
    def set_translation(self, p: numpy.ndarray[object[3, 1]]) -> None: ...
    def translation(self) -> numpy.ndarray[object[3, 1]]: ...
    def __copy__(self) -> RigidTransform_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> RigidTransform_TAutoDiffXdU: ...

class RigidTransform_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: RigidTransform_TExpressionU) -> None: ...
    @overload
    def __init__(self, R: RotationMatrix_TExpressionU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, rpy: RollPitchYaw_TExpressionU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, quaternion: pydrake.common.eigen_geometry.Quaternion_TExpressionU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, theta_lambda: pydrake.common.eigen_geometry.AngleAxis_TExpressionU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, R: RotationMatrix_TExpressionU) -> None: ...
    @overload
    def __init__(self, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, pose: pydrake.common.eigen_geometry.Isometry3_TExpressionU) -> None: ...
    @overload
    def __init__(self, pose: numpy.ndarray[object[m, n]]) -> None: ...
    def GetAsIsometry3(self) -> pydrake.common.eigen_geometry.Isometry3_TExpressionU: ...
    def GetAsMatrix34(self) -> numpy.ndarray[object[3, 4]]: ...
    def GetAsMatrix4(self) -> numpy.ndarray[object[4, 4]]: ...
    def GetMaximumAbsoluteDifference(self, other: RigidTransform_TExpressionU) -> pydrake.symbolic.Expression: ...
    def GetMaximumAbsoluteTranslationDifference(self, other: RigidTransform_TExpressionU) -> pydrake.symbolic.Expression: ...
    @staticmethod
    def Identity() -> RigidTransform_TExpressionU: ...
    def InvertAndCompose(self, other: RigidTransform_TExpressionU) -> RigidTransform_TExpressionU: ...
    def IsExactlyEqualTo(self, other: RigidTransform_TExpressionU) -> pydrake.symbolic.Formula: ...
    def IsExactlyIdentity(self) -> pydrake.symbolic.Formula: ...
    def IsNearlyEqualTo(self, other: RigidTransform_TExpressionU, tolerance: float) -> pydrake.symbolic.Formula: ...
    @overload
    def IsNearlyIdentity(self, translation_tolerance: float) -> pydrake.symbolic.Formula: ...
    @overload
    def IsNearlyIdentity(self) -> Any: ...
    @staticmethod
    def MakeUnchecked(pose: numpy.ndarray[object[3, 4]]) -> RigidTransform_TExpressionU: ...
    def SetFromIsometry3(self, pose: pydrake.common.eigen_geometry.Isometry3_TExpressionU) -> None: ...
    def SetIdentity(self) -> RigidTransform_TExpressionU: ...
    def cast𝓣Expression𝓤(self) -> RigidTransform_TExpressionU: ...
    def inverse(self) -> RigidTransform_TExpressionU: ...
    def rotation(self) -> RotationMatrix_TExpressionU: ...
    def set(self, R: RotationMatrix_TExpressionU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def set_rotation(self, R: RotationMatrix_TExpressionU) -> None: ...
    @overload
    def set_rotation(self, rpy: RollPitchYaw_TExpressionU) -> None: ...
    @overload
    def set_rotation(self, quaternion: pydrake.common.eigen_geometry.Quaternion_TExpressionU) -> None: ...
    @overload
    def set_rotation(self, theta_lambda: pydrake.common.eigen_geometry.AngleAxis_TExpressionU) -> None: ...
    def set_translation(self, p: numpy.ndarray[object[3, 1]]) -> None: ...
    def translation(self) -> numpy.ndarray[object[3, 1]]: ...
    def __copy__(self) -> RigidTransform_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> RigidTransform_TExpressionU: ...

class RollPitchYaw:
    @overload
    def __init__(self, other: RollPitchYaw) -> None: ...
    @overload
    def __init__(self, rpy: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    @overload
    def __init__(self, roll: float, pitch: float, yaw: float) -> None: ...
    @overload
    def __init__(self, R: RotationMatrix) -> None: ...
    @overload
    def __init__(self, quaternion: pydrake.common.eigen_geometry.Quaternion) -> None: ...
    @overload
    def __init__(self, matrix: numpy.ndarray[numpy.float64[3, 3]]) -> None: ...
    def CalcAngularVelocityInChildFromRpyDt(self, rpyDt: numpy.ndarray[numpy.float64[3, 1]]) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcAngularVelocityInParentFromRpyDt(self, rpyDt: numpy.ndarray[numpy.float64[3, 1]]) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcRotationMatrixDt(self, rpyDt: numpy.ndarray[numpy.float64[3, 1]]) -> numpy.ndarray[numpy.float64[3, 3]]: ...
    def CalcRpyDDtFromAngularAccelInChild(self, rpyDt: numpy.ndarray[numpy.float64[3, 1]], alpha_AD_D: numpy.ndarray[numpy.float64[3, 1]]) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcRpyDDtFromRpyDtAndAngularAccelInParent(self, rpyDt: numpy.ndarray[numpy.float64[3, 1]], alpha_AD_A: numpy.ndarray[numpy.float64[3, 1]]) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcRpyDtFromAngularVelocityInChild(self, w_AD_D: numpy.ndarray[numpy.float64[3, 1]]) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcRpyDtFromAngularVelocityInParent(self, w_AD_A: numpy.ndarray[numpy.float64[3, 1]]) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def ToQuaternion(self) -> pydrake.common.eigen_geometry.Quaternion: ...
    def ToRotationMatrix(self) -> RotationMatrix: ...
    def pitch_angle(self) -> float: ...
    def roll_angle(self) -> float: ...
    def vector(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def yaw_angle(self) -> float: ...
    def __copy__(self) -> RollPitchYaw: ...
    def __deepcopy__(self, arg0: dict) -> RollPitchYaw: ...

class RollPitchYaw_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, other: RollPitchYaw_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, rpy: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, roll: pydrake.autodiffutils.AutoDiffXd, pitch: pydrake.autodiffutils.AutoDiffXd, yaw: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    @overload
    def __init__(self, R: RotationMatrix_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, quaternion: pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, matrix: numpy.ndarray[object[3, 3]]) -> None: ...
    def CalcAngularVelocityInChildFromRpyDt(self, rpyDt: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcAngularVelocityInParentFromRpyDt(self, rpyDt: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcRotationMatrixDt(self, rpyDt: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 3]]: ...
    def CalcRpyDDtFromAngularAccelInChild(self, rpyDt: numpy.ndarray[object[3, 1]], alpha_AD_D: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcRpyDDtFromRpyDtAndAngularAccelInParent(self, rpyDt: numpy.ndarray[object[3, 1]], alpha_AD_A: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcRpyDtFromAngularVelocityInChild(self, w_AD_D: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcRpyDtFromAngularVelocityInParent(self, w_AD_A: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def ToQuaternion(self) -> pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU: ...
    def ToRotationMatrix(self) -> RotationMatrix_TAutoDiffXdU: ...
    def pitch_angle(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def roll_angle(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def vector(self) -> numpy.ndarray[object[3, 1]]: ...
    def yaw_angle(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def __copy__(self) -> RollPitchYaw_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> RollPitchYaw_TAutoDiffXdU: ...

class RollPitchYaw_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, other: RollPitchYaw_TExpressionU) -> None: ...
    @overload
    def __init__(self, rpy: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, roll: pydrake.symbolic.Expression, pitch: pydrake.symbolic.Expression, yaw: pydrake.symbolic.Expression) -> None: ...
    @overload
    def __init__(self, R: RotationMatrix_TExpressionU) -> None: ...
    @overload
    def __init__(self, quaternion: pydrake.common.eigen_geometry.Quaternion_TExpressionU) -> None: ...
    @overload
    def __init__(self, matrix: numpy.ndarray[object[3, 3]]) -> None: ...
    def CalcAngularVelocityInChildFromRpyDt(self, rpyDt: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcAngularVelocityInParentFromRpyDt(self, rpyDt: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcRotationMatrixDt(self, rpyDt: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 3]]: ...
    def CalcRpyDDtFromAngularAccelInChild(self, rpyDt: numpy.ndarray[object[3, 1]], alpha_AD_D: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcRpyDDtFromRpyDtAndAngularAccelInParent(self, rpyDt: numpy.ndarray[object[3, 1]], alpha_AD_A: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcRpyDtFromAngularVelocityInChild(self, w_AD_D: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcRpyDtFromAngularVelocityInParent(self, w_AD_A: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def ToQuaternion(self) -> pydrake.common.eigen_geometry.Quaternion_TExpressionU: ...
    def ToRotationMatrix(self) -> RotationMatrix_TExpressionU: ...
    def pitch_angle(self) -> pydrake.symbolic.Expression: ...
    def roll_angle(self) -> pydrake.symbolic.Expression: ...
    def vector(self) -> numpy.ndarray[object[3, 1]]: ...
    def yaw_angle(self) -> pydrake.symbolic.Expression: ...
    def __copy__(self) -> RollPitchYaw_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> RollPitchYaw_TExpressionU: ...

class RotationMatrix:
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def Identity() -> RotationMatrix: ...
    def InvertAndCompose(self, other: RotationMatrix) -> RotationMatrix: ...
    def IsExactlyIdentity(self) -> bool: ...
    def IsNearlyIdentity(self, tolerance: float = ...) -> bool: ...
    def IsValid(self) -> bool: ...
    @staticmethod
    def MakeFromOneVector(b_A: numpy.ndarray[numpy.float64[3, 1]], axis_index: int) -> RotationMatrix: ...
    @staticmethod
    def MakeUnchecked(R: numpy.ndarray[numpy.float64[3, 3]]) -> RotationMatrix: ...
    @staticmethod
    def MakeXRotation(theta: float) -> RotationMatrix: ...
    @staticmethod
    def MakeYRotation(theta: float) -> RotationMatrix: ...
    @staticmethod
    def MakeZRotation(theta: float) -> RotationMatrix: ...
    @staticmethod
    def ProjectToRotationMatrix(M: numpy.ndarray[numpy.float64[3, 3]]) -> RotationMatrix: ...
    def ToAngleAxis(self) -> pydrake.common.eigen_geometry.AngleAxis: ...
    def ToQuaternion(self) -> pydrake.common.eigen_geometry.Quaternion: ...
    def ToRollPitchYaw(self) -> RollPitchYaw: ...
    def cast𝓣AutoDiffXd𝓤(self) -> RotationMatrix_TAutoDiffXdU: ...
    def cast𝓣Expression𝓤(self) -> RotationMatrix_TExpressionU: ...
    def cast𝓣float𝓤(self) -> RotationMatrix: ...
    def col(self, index: int) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def inverse(self) -> RotationMatrix: ...
    def matrix(self) -> numpy.ndarray[numpy.float64[3, 3]]: ...
    def row(self, index: int) -> numpy.ndarray[numpy.float64[1, 3]]: ...
    def set(self, R: numpy.ndarray[numpy.float64[3, 3]]) -> None: ...
    def transpose(self) -> RotationMatrix: ...
    def __copy__(self) -> RotationMatrix: ...
    def __deepcopy__(self, arg0: dict) -> RotationMatrix: ...

class RotationMatrix_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def Identity() -> RotationMatrix_TAutoDiffXdU: ...
    def InvertAndCompose(self, other: RotationMatrix_TAutoDiffXdU) -> RotationMatrix_TAutoDiffXdU: ...
    def IsExactlyIdentity(self) -> bool: ...
    def IsNearlyIdentity(self, tolerance: float = ...) -> bool: ...
    def IsValid(self) -> bool: ...
    @staticmethod
    def MakeFromOneVector(b_A: numpy.ndarray[object[3, 1]], axis_index: int) -> RotationMatrix_TAutoDiffXdU: ...
    @staticmethod
    def MakeUnchecked(R: numpy.ndarray[object[3, 3]]) -> RotationMatrix_TAutoDiffXdU: ...
    @staticmethod
    def MakeXRotation(theta: pydrake.autodiffutils.AutoDiffXd) -> RotationMatrix_TAutoDiffXdU: ...
    @staticmethod
    def MakeYRotation(theta: pydrake.autodiffutils.AutoDiffXd) -> RotationMatrix_TAutoDiffXdU: ...
    @staticmethod
    def MakeZRotation(theta: pydrake.autodiffutils.AutoDiffXd) -> RotationMatrix_TAutoDiffXdU: ...
    @staticmethod
    def ProjectToRotationMatrix(M: numpy.ndarray[object[3, 3]]) -> RotationMatrix_TAutoDiffXdU: ...
    def ToAngleAxis(self) -> pydrake.common.eigen_geometry.AngleAxis_TAutoDiffXdU: ...
    def ToQuaternion(self) -> pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU: ...
    def ToRollPitchYaw(self) -> RollPitchYaw_TAutoDiffXdU: ...
    def cast𝓣AutoDiffXd𝓤(self) -> RotationMatrix_TAutoDiffXdU: ...
    def col(self, index: int) -> numpy.ndarray[object[3, 1]]: ...
    def inverse(self) -> RotationMatrix_TAutoDiffXdU: ...
    def matrix(self) -> numpy.ndarray[object[3, 3]]: ...
    def row(self, index: int) -> numpy.ndarray[object[1, 3]]: ...
    def set(self, R: numpy.ndarray[object[3, 3]]) -> None: ...
    def transpose(self) -> RotationMatrix_TAutoDiffXdU: ...
    def __copy__(self) -> RotationMatrix_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> RotationMatrix_TAutoDiffXdU: ...

class RotationMatrix_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def Identity() -> RotationMatrix_TExpressionU: ...
    def InvertAndCompose(self, other: RotationMatrix_TExpressionU) -> RotationMatrix_TExpressionU: ...
    def IsExactlyIdentity(self) -> pydrake.symbolic.Formula: ...
    def IsNearlyIdentity(self, tolerance: float = ...) -> pydrake.symbolic.Formula: ...
    def IsValid(self) -> pydrake.symbolic.Formula: ...
    @staticmethod
    def MakeFromOneVector(b_A: numpy.ndarray[object[3, 1]], axis_index: int) -> RotationMatrix_TExpressionU: ...
    @staticmethod
    def MakeUnchecked(R: numpy.ndarray[object[3, 3]]) -> RotationMatrix_TExpressionU: ...
    @staticmethod
    def MakeXRotation(theta: pydrake.symbolic.Expression) -> RotationMatrix_TExpressionU: ...
    @staticmethod
    def MakeYRotation(theta: pydrake.symbolic.Expression) -> RotationMatrix_TExpressionU: ...
    @staticmethod
    def MakeZRotation(theta: pydrake.symbolic.Expression) -> RotationMatrix_TExpressionU: ...
    @staticmethod
    def ProjectToRotationMatrix(M: numpy.ndarray[object[3, 3]]) -> RotationMatrix_TExpressionU: ...
    def ToAngleAxis(self) -> pydrake.common.eigen_geometry.AngleAxis_TExpressionU: ...
    def ToQuaternion(self) -> pydrake.common.eigen_geometry.Quaternion_TExpressionU: ...
    def ToRollPitchYaw(self) -> RollPitchYaw_TExpressionU: ...
    def cast𝓣Expression𝓤(self) -> RotationMatrix_TExpressionU: ...
    def col(self, index: int) -> numpy.ndarray[object[3, 1]]: ...
    def inverse(self) -> RotationMatrix_TExpressionU: ...
    def matrix(self) -> numpy.ndarray[object[3, 3]]: ...
    def row(self, index: int) -> numpy.ndarray[object[1, 3]]: ...
    def set(self, R: numpy.ndarray[object[3, 3]]) -> None: ...
    def transpose(self) -> RotationMatrix_TExpressionU: ...
    def __copy__(self) -> RotationMatrix_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> RotationMatrix_TExpressionU: ...

class _TemporaryName_N5drake4math12BsplineBasisIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, order: int, knots: list[pydrake.autodiffutils.AutoDiffXd]) -> None: ...
    @overload
    def __init__(self, order: int, num_basis_functions: int, type: KnotVectorType = ..., initial_parameter_value: pydrake.autodiffutils.AutoDiffXd = ..., final_parameter_value: pydrake.autodiffutils.AutoDiffXd = ...) -> None: ...
    @overload
    def __init__(self, other: BsplineBasis_TAutoDiffXdU) -> None: ...
    @overload
    def ComputeActiveBasisFunctionIndices(self, parameter_interval) -> list[int]: ...
    @overload
    def ComputeActiveBasisFunctionIndices(self, parameter_value: pydrake.autodiffutils.AutoDiffXd) -> list[int]: ...
    def EvaluateBasisFunctionI(self, i: int, parameter_value: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
    def EvaluateCurve(self, control_points: list[numpy.ndarray[object[m, 1]]], parameter_value: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, 1]]: ...
    def EvaluateLinearInControlPoints(self, parameter_value: pydrake.autodiffutils.AutoDiffXd) -> numpy.ndarray[object[m, 1]]: ...
    def FindContainingInterval(self, parameter_value: pydrake.autodiffutils.AutoDiffXd) -> int: ...
    def degree(self) -> int: ...
    def final_parameter_value(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def initial_parameter_value(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def knots(self) -> list[pydrake.autodiffutils.AutoDiffXd]: ...
    def num_basis_functions(self) -> int: ...
    def order(self) -> int: ...

class _TemporaryName_N5drake4math12BsplineBasisINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, order: int, knots: list[pydrake.symbolic.Expression]) -> None: ...
    @overload
    def __init__(self, order: int, num_basis_functions: int, type: KnotVectorType = ..., initial_parameter_value: pydrake.symbolic.Expression = ..., final_parameter_value: pydrake.symbolic.Expression = ...) -> None: ...
    @overload
    def __init__(self, other: BsplineBasis_TExpressionU) -> None: ...
    @overload
    def ComputeActiveBasisFunctionIndices(self, parameter_interval) -> list[int]: ...
    @overload
    def ComputeActiveBasisFunctionIndices(self, parameter_value: pydrake.symbolic.Expression) -> list[int]: ...
    def EvaluateBasisFunctionI(self, i: int, parameter_value: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
    def EvaluateCurve(self, control_points: list[numpy.ndarray[object[m, 1]]], parameter_value: pydrake.symbolic.Expression) -> numpy.ndarray[object[m, 1]]: ...
    def EvaluateLinearInControlPoints(self, parameter_value: pydrake.symbolic.Expression) -> numpy.ndarray[object[m, 1]]: ...
    def FindContainingInterval(self, parameter_value: pydrake.symbolic.Expression) -> int: ...
    def degree(self) -> int: ...
    def final_parameter_value(self) -> pydrake.symbolic.Expression: ...
    def initial_parameter_value(self) -> pydrake.symbolic.Expression: ...
    def knots(self) -> list[pydrake.symbolic.Expression]: ...
    def num_basis_functions(self) -> int: ...
    def order(self) -> int: ...

class _TemporaryName_N5drake4math12RollPitchYawIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, other: RollPitchYaw_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, rpy: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, roll: pydrake.autodiffutils.AutoDiffXd, pitch: pydrake.autodiffutils.AutoDiffXd, yaw: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    @overload
    def __init__(self, R: RotationMatrix_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, quaternion: pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, matrix: numpy.ndarray[object[3, 3]]) -> None: ...
    def CalcAngularVelocityInChildFromRpyDt(self, rpyDt: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcAngularVelocityInParentFromRpyDt(self, rpyDt: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcRotationMatrixDt(self, rpyDt: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 3]]: ...
    def CalcRpyDDtFromAngularAccelInChild(self, rpyDt: numpy.ndarray[object[3, 1]], alpha_AD_D: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcRpyDDtFromRpyDtAndAngularAccelInParent(self, rpyDt: numpy.ndarray[object[3, 1]], alpha_AD_A: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcRpyDtFromAngularVelocityInChild(self, w_AD_D: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcRpyDtFromAngularVelocityInParent(self, w_AD_A: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def ToQuaternion(self) -> pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU: ...
    def ToRotationMatrix(self) -> RotationMatrix_TAutoDiffXdU: ...
    def pitch_angle(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def roll_angle(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def vector(self) -> numpy.ndarray[object[3, 1]]: ...
    def yaw_angle(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def __copy__(self) -> RollPitchYaw_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> RollPitchYaw_TAutoDiffXdU: ...

class _TemporaryName_N5drake4math12RollPitchYawINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self, other: RollPitchYaw_TExpressionU) -> None: ...
    @overload
    def __init__(self, rpy: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, roll: pydrake.symbolic.Expression, pitch: pydrake.symbolic.Expression, yaw: pydrake.symbolic.Expression) -> None: ...
    @overload
    def __init__(self, R: RotationMatrix_TExpressionU) -> None: ...
    @overload
    def __init__(self, quaternion: pydrake.common.eigen_geometry.Quaternion_TExpressionU) -> None: ...
    @overload
    def __init__(self, matrix: numpy.ndarray[object[3, 3]]) -> None: ...
    def CalcAngularVelocityInChildFromRpyDt(self, rpyDt: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcAngularVelocityInParentFromRpyDt(self, rpyDt: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcRotationMatrixDt(self, rpyDt: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 3]]: ...
    def CalcRpyDDtFromAngularAccelInChild(self, rpyDt: numpy.ndarray[object[3, 1]], alpha_AD_D: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcRpyDDtFromRpyDtAndAngularAccelInParent(self, rpyDt: numpy.ndarray[object[3, 1]], alpha_AD_A: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcRpyDtFromAngularVelocityInChild(self, w_AD_D: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def CalcRpyDtFromAngularVelocityInParent(self, w_AD_A: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def ToQuaternion(self) -> pydrake.common.eigen_geometry.Quaternion_TExpressionU: ...
    def ToRotationMatrix(self) -> RotationMatrix_TExpressionU: ...
    def pitch_angle(self) -> pydrake.symbolic.Expression: ...
    def roll_angle(self) -> pydrake.symbolic.Expression: ...
    def vector(self) -> numpy.ndarray[object[3, 1]]: ...
    def yaw_angle(self) -> pydrake.symbolic.Expression: ...
    def __copy__(self) -> RollPitchYaw_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> RollPitchYaw_TExpressionU: ...

class _TemporaryName_N5drake4math14RigidTransformIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: RigidTransform_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, R: RotationMatrix_TAutoDiffXdU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, rpy: RollPitchYaw_TAutoDiffXdU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, quaternion: pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, theta_lambda: pydrake.common.eigen_geometry.AngleAxis_TAutoDiffXdU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, R: RotationMatrix_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, pose: pydrake.common.eigen_geometry.Isometry3_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, pose: numpy.ndarray[object[m, n]]) -> None: ...
    def GetAsIsometry3(self) -> pydrake.common.eigen_geometry.Isometry3_TAutoDiffXdU: ...
    def GetAsMatrix34(self) -> numpy.ndarray[object[3, 4]]: ...
    def GetAsMatrix4(self) -> numpy.ndarray[object[4, 4]]: ...
    def GetMaximumAbsoluteDifference(self, other: RigidTransform_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    def GetMaximumAbsoluteTranslationDifference(self, other: RigidTransform_TAutoDiffXdU) -> pydrake.autodiffutils.AutoDiffXd: ...
    @staticmethod
    def Identity() -> RigidTransform_TAutoDiffXdU: ...
    def InvertAndCompose(self, other: RigidTransform_TAutoDiffXdU) -> RigidTransform_TAutoDiffXdU: ...
    def IsExactlyEqualTo(self, other: RigidTransform_TAutoDiffXdU) -> bool: ...
    def IsExactlyIdentity(self) -> bool: ...
    def IsNearlyEqualTo(self, other: RigidTransform_TAutoDiffXdU, tolerance: float) -> bool: ...
    @overload
    def IsNearlyIdentity(self, translation_tolerance: float) -> bool: ...
    @overload
    def IsNearlyIdentity(self) -> Any: ...
    @staticmethod
    def MakeUnchecked(pose: numpy.ndarray[object[3, 4]]) -> RigidTransform_TAutoDiffXdU: ...
    def SetFromIsometry3(self, pose: pydrake.common.eigen_geometry.Isometry3_TAutoDiffXdU) -> None: ...
    def SetIdentity(self) -> RigidTransform_TAutoDiffXdU: ...
    def cast𝓣AutoDiffXd𝓤(self) -> RigidTransform_TAutoDiffXdU: ...
    def inverse(self) -> RigidTransform_TAutoDiffXdU: ...
    def rotation(self) -> RotationMatrix_TAutoDiffXdU: ...
    def set(self, R: RotationMatrix_TAutoDiffXdU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def set_rotation(self, R: RotationMatrix_TAutoDiffXdU) -> None: ...
    @overload
    def set_rotation(self, rpy: RollPitchYaw_TAutoDiffXdU) -> None: ...
    @overload
    def set_rotation(self, quaternion: pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU) -> None: ...
    @overload
    def set_rotation(self, theta_lambda: pydrake.common.eigen_geometry.AngleAxis_TAutoDiffXdU) -> None: ...
    def set_translation(self, p: numpy.ndarray[object[3, 1]]) -> None: ...
    def translation(self) -> numpy.ndarray[object[3, 1]]: ...
    def __copy__(self) -> RigidTransform_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> RigidTransform_TAutoDiffXdU: ...

class _TemporaryName_N5drake4math14RigidTransformINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: RigidTransform_TExpressionU) -> None: ...
    @overload
    def __init__(self, R: RotationMatrix_TExpressionU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, rpy: RollPitchYaw_TExpressionU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, quaternion: pydrake.common.eigen_geometry.Quaternion_TExpressionU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, theta_lambda: pydrake.common.eigen_geometry.AngleAxis_TExpressionU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, R: RotationMatrix_TExpressionU) -> None: ...
    @overload
    def __init__(self, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, pose: pydrake.common.eigen_geometry.Isometry3_TExpressionU) -> None: ...
    @overload
    def __init__(self, pose: numpy.ndarray[object[m, n]]) -> None: ...
    def GetAsIsometry3(self) -> pydrake.common.eigen_geometry.Isometry3_TExpressionU: ...
    def GetAsMatrix34(self) -> numpy.ndarray[object[3, 4]]: ...
    def GetAsMatrix4(self) -> numpy.ndarray[object[4, 4]]: ...
    def GetMaximumAbsoluteDifference(self, other: RigidTransform_TExpressionU) -> pydrake.symbolic.Expression: ...
    def GetMaximumAbsoluteTranslationDifference(self, other: RigidTransform_TExpressionU) -> pydrake.symbolic.Expression: ...
    @staticmethod
    def Identity() -> RigidTransform_TExpressionU: ...
    def InvertAndCompose(self, other: RigidTransform_TExpressionU) -> RigidTransform_TExpressionU: ...
    def IsExactlyEqualTo(self, other: RigidTransform_TExpressionU) -> pydrake.symbolic.Formula: ...
    def IsExactlyIdentity(self) -> pydrake.symbolic.Formula: ...
    def IsNearlyEqualTo(self, other: RigidTransform_TExpressionU, tolerance: float) -> pydrake.symbolic.Formula: ...
    @overload
    def IsNearlyIdentity(self, translation_tolerance: float) -> pydrake.symbolic.Formula: ...
    @overload
    def IsNearlyIdentity(self) -> Any: ...
    @staticmethod
    def MakeUnchecked(pose: numpy.ndarray[object[3, 4]]) -> RigidTransform_TExpressionU: ...
    def SetFromIsometry3(self, pose: pydrake.common.eigen_geometry.Isometry3_TExpressionU) -> None: ...
    def SetIdentity(self) -> RigidTransform_TExpressionU: ...
    def cast𝓣Expression𝓤(self) -> RigidTransform_TExpressionU: ...
    def inverse(self) -> RigidTransform_TExpressionU: ...
    def rotation(self) -> RotationMatrix_TExpressionU: ...
    def set(self, R: RotationMatrix_TExpressionU, p: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def set_rotation(self, R: RotationMatrix_TExpressionU) -> None: ...
    @overload
    def set_rotation(self, rpy: RollPitchYaw_TExpressionU) -> None: ...
    @overload
    def set_rotation(self, quaternion: pydrake.common.eigen_geometry.Quaternion_TExpressionU) -> None: ...
    @overload
    def set_rotation(self, theta_lambda: pydrake.common.eigen_geometry.AngleAxis_TExpressionU) -> None: ...
    def set_translation(self, p: numpy.ndarray[object[3, 1]]) -> None: ...
    def translation(self) -> numpy.ndarray[object[3, 1]]: ...
    def __copy__(self) -> RigidTransform_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> RigidTransform_TExpressionU: ...

class _TemporaryName_N5drake4math14RotationMatrixIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def Identity() -> RotationMatrix_TAutoDiffXdU: ...
    def InvertAndCompose(self, other: RotationMatrix_TAutoDiffXdU) -> RotationMatrix_TAutoDiffXdU: ...
    def IsExactlyIdentity(self) -> bool: ...
    def IsNearlyIdentity(self, tolerance: float = ...) -> bool: ...
    def IsValid(self) -> bool: ...
    @staticmethod
    def MakeFromOneVector(b_A: numpy.ndarray[object[3, 1]], axis_index: int) -> RotationMatrix_TAutoDiffXdU: ...
    @staticmethod
    def MakeUnchecked(R: numpy.ndarray[object[3, 3]]) -> RotationMatrix_TAutoDiffXdU: ...
    @staticmethod
    def MakeXRotation(theta: pydrake.autodiffutils.AutoDiffXd) -> RotationMatrix_TAutoDiffXdU: ...
    @staticmethod
    def MakeYRotation(theta: pydrake.autodiffutils.AutoDiffXd) -> RotationMatrix_TAutoDiffXdU: ...
    @staticmethod
    def MakeZRotation(theta: pydrake.autodiffutils.AutoDiffXd) -> RotationMatrix_TAutoDiffXdU: ...
    @staticmethod
    def ProjectToRotationMatrix(M: numpy.ndarray[object[3, 3]]) -> RotationMatrix_TAutoDiffXdU: ...
    def ToAngleAxis(self) -> pydrake.common.eigen_geometry.AngleAxis_TAutoDiffXdU: ...
    def ToQuaternion(self) -> pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU: ...
    def ToRollPitchYaw(self) -> RollPitchYaw_TAutoDiffXdU: ...
    def cast𝓣AutoDiffXd𝓤(self) -> RotationMatrix_TAutoDiffXdU: ...
    def col(self, index: int) -> numpy.ndarray[object[3, 1]]: ...
    def inverse(self) -> RotationMatrix_TAutoDiffXdU: ...
    def matrix(self) -> numpy.ndarray[object[3, 3]]: ...
    def row(self, index: int) -> numpy.ndarray[object[1, 3]]: ...
    def set(self, R: numpy.ndarray[object[3, 3]]) -> None: ...
    def transpose(self) -> RotationMatrix_TAutoDiffXdU: ...
    def __copy__(self) -> RotationMatrix_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> RotationMatrix_TAutoDiffXdU: ...

class _TemporaryName_N5drake4math14RotationMatrixINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def Identity() -> RotationMatrix_TExpressionU: ...
    def InvertAndCompose(self, other: RotationMatrix_TExpressionU) -> RotationMatrix_TExpressionU: ...
    def IsExactlyIdentity(self) -> pydrake.symbolic.Formula: ...
    def IsNearlyIdentity(self, tolerance: float = ...) -> pydrake.symbolic.Formula: ...
    def IsValid(self) -> pydrake.symbolic.Formula: ...
    @staticmethod
    def MakeFromOneVector(b_A: numpy.ndarray[object[3, 1]], axis_index: int) -> RotationMatrix_TExpressionU: ...
    @staticmethod
    def MakeUnchecked(R: numpy.ndarray[object[3, 3]]) -> RotationMatrix_TExpressionU: ...
    @staticmethod
    def MakeXRotation(theta: pydrake.symbolic.Expression) -> RotationMatrix_TExpressionU: ...
    @staticmethod
    def MakeYRotation(theta: pydrake.symbolic.Expression) -> RotationMatrix_TExpressionU: ...
    @staticmethod
    def MakeZRotation(theta: pydrake.symbolic.Expression) -> RotationMatrix_TExpressionU: ...
    @staticmethod
    def ProjectToRotationMatrix(M: numpy.ndarray[object[3, 3]]) -> RotationMatrix_TExpressionU: ...
    def ToAngleAxis(self) -> pydrake.common.eigen_geometry.AngleAxis_TExpressionU: ...
    def ToQuaternion(self) -> pydrake.common.eigen_geometry.Quaternion_TExpressionU: ...
    def ToRollPitchYaw(self) -> RollPitchYaw_TExpressionU: ...
    def cast𝓣Expression𝓤(self) -> RotationMatrix_TExpressionU: ...
    def col(self, index: int) -> numpy.ndarray[object[3, 1]]: ...
    def inverse(self) -> RotationMatrix_TExpressionU: ...
    def matrix(self) -> numpy.ndarray[object[3, 3]]: ...
    def row(self, index: int) -> numpy.ndarray[object[1, 3]]: ...
    def set(self, R: numpy.ndarray[object[3, 3]]) -> None: ...
    def transpose(self) -> RotationMatrix_TExpressionU: ...
    def __copy__(self) -> RotationMatrix_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> RotationMatrix_TExpressionU: ...

@overload
def AreQuaternionsEqualForOrientation(quat1: pydrake.common.eigen_geometry.Quaternion, quat2: pydrake.common.eigen_geometry.Quaternion, tolerance: float) -> bool: ...
@overload
def AreQuaternionsEqualForOrientation(quat1: pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU, quat2: pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU, tolerance: pydrake.autodiffutils.AutoDiffXd) -> bool: ...
@overload
def AreQuaternionsEqualForOrientation(quat1: pydrake.common.eigen_geometry.Quaternion_TExpressionU, quat2: pydrake.common.eigen_geometry.Quaternion_TExpressionU, tolerance: pydrake.symbolic.Expression) -> pydrake.symbolic.Formula: ...
def BalanceQuadraticForms(S: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], P: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> numpy.ndarray[numpy.float64[m, n]]: ...
def CalculateAngularVelocityExpressedInBFromQuaternionDt(quat_AB: pydrake.common.eigen_geometry.Quaternion, quatDt: numpy.ndarray[numpy.float64[4, 1]]) -> numpy.ndarray[numpy.float64[3, 1]]: ...
@overload
def CalculateQuaternionDtConstraintViolation(quat: pydrake.common.eigen_geometry.Quaternion, quatDt: numpy.ndarray[numpy.float64[4, 1]]) -> float: ...
@overload
def CalculateQuaternionDtConstraintViolation(quat: pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU, quatDt: numpy.ndarray[object[4, 1]]) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def CalculateQuaternionDtConstraintViolation(quat: pydrake.common.eigen_geometry.Quaternion_TExpressionU, quatDt: numpy.ndarray[object[4, 1]]) -> pydrake.symbolic.Expression: ...
def CalculateQuaternionDtFromAngularVelocityExpressedInB(quat_AB: pydrake.common.eigen_geometry.Quaternion, w_AB_B: numpy.ndarray[numpy.float64[3, 1]]) -> numpy.ndarray[numpy.float64[4, 1]]: ...
@overload
def ClosestQuaternion(quat1: pydrake.common.eigen_geometry.Quaternion, quat2: pydrake.common.eigen_geometry.Quaternion) -> pydrake.common.eigen_geometry.Quaternion: ...
@overload
def ClosestQuaternion(quat1: pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU, quat2: pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU) -> pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU: ...
@overload
def ClosestQuaternion(quat1: pydrake.common.eigen_geometry.Quaternion_TExpressionU, quat2: pydrake.common.eigen_geometry.Quaternion_TExpressionU) -> pydrake.common.eigen_geometry.Quaternion_TExpressionU: ...
def ComputeNumericalGradient(calc_func: Callable[[numpy.ndarray[numpy.float64[m, 1]]], numpy.ndarray[numpy.float64[m, 1]]], x: numpy.ndarray[numpy.float64[m, 1]], option: NumericalGradientOption = ...) -> numpy.ndarray[numpy.float64[m, n]]: ...
def ContinuousAlgebraicRiccatiEquation(A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], B: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], Q: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], R: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> numpy.ndarray[numpy.float64[m, n]]: ...
def DecomposePSDmatrixIntoXtransposeTimesX(Y: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], zero_tol: float, return_empty_if_not_psd: bool = ...) -> numpy.ndarray[numpy.float64[m, n]]: ...
def DecomposePositiveQuadraticForm(Q: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], b: numpy.ndarray[numpy.float64[m, 1]], c: float, tol: float = ...) -> tuple[numpy.ndarray[numpy.float64[m, n]], numpy.ndarray[numpy.float64[m, n]]]: ...
def DiscreteAlgebraicRiccatiEquation(A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], B: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], Q: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], R: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> numpy.ndarray[numpy.float64[m, n]]: ...
def ExtractPrincipalSubmatrix(matrix: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], indices: set[int]) -> numpy.ndarray[numpy.float64[m, n]]: ...
@overload
def IsBothQuaternionAndQuaternionDtOK(quat: pydrake.common.eigen_geometry.Quaternion, quatDt: numpy.ndarray[numpy.float64[4, 1]], tolerance: float) -> bool: ...
@overload
def IsBothQuaternionAndQuaternionDtOK(quat: pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU, quatDt: numpy.ndarray[object[4, 1]], tolerance: float) -> bool: ...
@overload
def IsBothQuaternionAndQuaternionDtOK(quat: pydrake.common.eigen_geometry.Quaternion_TExpressionU, quatDt: numpy.ndarray[object[4, 1]], tolerance: float) -> pydrake.symbolic.Formula: ...
def IsPositiveDefinite(matrix: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], tolerance: float = ...) -> bool: ...
@overload
def IsQuaternionValid(quat: pydrake.common.eigen_geometry.Quaternion, tolerance: float) -> bool: ...
@overload
def IsQuaternionValid(quat: pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU, tolerance: float) -> bool: ...
@overload
def IsQuaternionValid(quat: pydrake.common.eigen_geometry.Quaternion_TExpressionU, tolerance: float) -> pydrake.symbolic.Formula: ...
@overload
def IsSymmetric(matrix: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> bool: ...
@overload
def IsSymmetric(matrix: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], precision: float) -> bool: ...
def QuaternionToCanonicalForm(quat: pydrake.common.eigen_geometry.Quaternion) -> pydrake.common.eigen_geometry.Quaternion: ...
def RealContinuousLyapunovEquation(A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], Q: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> numpy.ndarray[numpy.float64[m, n]]: ...
def RealDiscreteLyapunovEquation(A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], Q: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> numpy.ndarray[numpy.float64[m, n]]: ...
@overload
def SoftOverMax(x: list[float], alpha: float = ...) -> float: ...
@overload
def SoftOverMax(x) -> Any: ...
@overload
def SoftOverMax(x: list[pydrake.autodiffutils.AutoDiffXd], alpha: float = ...) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def SoftOverMax(x) -> Any: ...
@overload
def SoftOverMin(x: list[float], alpha: float = ...) -> float: ...
@overload
def SoftOverMin(x) -> Any: ...
@overload
def SoftOverMin(x: list[pydrake.autodiffutils.AutoDiffXd], alpha: float = ...) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def SoftOverMin(x) -> Any: ...
@overload
def SoftUnderMax(x: list[float], alpha: float = ...) -> float: ...
@overload
def SoftUnderMax(x) -> Any: ...
@overload
def SoftUnderMax(x: list[pydrake.autodiffutils.AutoDiffXd], alpha: float = ...) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def SoftUnderMax(x) -> Any: ...
@overload
def SoftUnderMin(x: list[float], alpha: float = ...) -> float: ...
@overload
def SoftUnderMin(x) -> Any: ...
@overload
def SoftUnderMin(x: list[pydrake.autodiffutils.AutoDiffXd], alpha: float = ...) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def SoftUnderMin(x) -> Any: ...
def ToLowerTriangularColumnsFromMatrix(matrix: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> numpy.ndarray[numpy.float64[m, 1]]: ...
def ToSymmetricMatrixFromLowerTriangularColumns(lower_triangular_columns: numpy.ndarray[numpy.float64[m, 1]]) -> numpy.ndarray[numpy.float64[m, n]]: ...
def UniformlyRandomAngleAxis(generator: pydrake.common.RandomGenerator) -> pydrake.common.eigen_geometry.AngleAxis: ...
def UniformlyRandomQuaternion(generator: pydrake.common.RandomGenerator) -> pydrake.common.eigen_geometry.Quaternion: ...
def UniformlyRandomRPY(generator: pydrake.common.RandomGenerator) -> numpy.ndarray[numpy.float64[3, 1]]: ...
def UniformlyRandomRotationMatrix(generator: pydrake.common.RandomGenerator) -> RotationMatrix: ...
@overload
def VectorToSkewSymmetric(p: numpy.ndarray[numpy.float64[3, 1]]) -> numpy.ndarray[numpy.float64[3, 3]]: ...
@overload
def VectorToSkewSymmetric(p: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 3]]: ...
@overload
def VectorToSkewSymmetric(p: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 3]]: ...
@overload
def abs(arg0: float) -> float: ...
@overload
def abs(arg0: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def abs(arg0: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def acos(arg0: float) -> float: ...
@overload
def acos(arg0: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def acos(arg0: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def arccos(arg0: float) -> float: ...
@overload
def arccos(arg0: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def arccos(arg0: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def arcsin(arg0: float) -> float: ...
@overload
def arcsin(arg0: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def arcsin(arg0: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def arctan(arg0: float) -> float: ...
@overload
def arctan(arg0: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def arctan(arg0: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def arctan2(y: float, x: float) -> float: ...
@overload
def arctan2(y: pydrake.autodiffutils.AutoDiffXd, x: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def arctan2(y: pydrake.symbolic.Expression, x: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def asin(arg0: float) -> float: ...
@overload
def asin(arg0: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def asin(arg0: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def atan(arg0: float) -> float: ...
@overload
def atan(arg0: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def atan(arg0: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def atan2(y: float, x: float) -> float: ...
@overload
def atan2(y: pydrake.autodiffutils.AutoDiffXd, x: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def atan2(y: pydrake.symbolic.Expression, x: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def ceil(arg0: float) -> float: ...
@overload
def ceil(arg0: pydrake.autodiffutils.AutoDiffXd) -> float: ...
@overload
def ceil(arg0: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def cos(arg0: float) -> float: ...
@overload
def cos(arg0: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def cos(arg0: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def cosh(arg0: float) -> float: ...
@overload
def cosh(arg0: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def cosh(arg0: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def exp(arg0: float) -> float: ...
@overload
def exp(arg0: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def exp(arg0: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def floor(arg0: float) -> float: ...
@overload
def floor(arg0: pydrake.autodiffutils.AutoDiffXd) -> float: ...
@overload
def floor(arg0: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def inv(arg0: numpy.ndarray[numpy.float64[m, n]]) -> numpy.ndarray[numpy.float64[m, n]]: ...
@overload
def inv(arg0: numpy.ndarray[object[m, n]]) -> numpy.ndarray[object[m, n]]: ...
@overload
def inv(arg0: numpy.ndarray[object[m, n]]) -> numpy.ndarray[object[m, n]]: ...
@overload
def is_quaternion_in_canonical_form(quat: pydrake.common.eigen_geometry.Quaternion) -> bool: ...
@overload
def is_quaternion_in_canonical_form(quat: pydrake.common.eigen_geometry.Quaternion_TAutoDiffXdU) -> bool: ...
@overload
def is_quaternion_in_canonical_form(quat: pydrake.common.eigen_geometry.Quaternion_TExpressionU) -> pydrake.symbolic.Formula: ...
@overload
def isnan(x: float) -> bool: ...
@overload
def isnan(x: pydrake.autodiffutils.AutoDiffXd) -> bool: ...
@overload
def isnan(x: pydrake.symbolic.Expression) -> pydrake.symbolic.Formula: ...
@overload
def log(arg0: float) -> float: ...
@overload
def log(arg0: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def log(arg0: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
def matmul(arg0: numpy.ndarray[numpy.float64[m, n]], arg1: numpy.ndarray[numpy.float64[m, n]]) -> numpy.ndarray[numpy.float64[m, n]]: ...
@overload
def max(arg0: float, arg1: float) -> float: ...
@overload
def max(arg0: pydrake.autodiffutils.AutoDiffXd, arg1: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def max(arg0: pydrake.symbolic.Expression, arg1: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def min(arg0: float, arg1: float) -> float: ...
@overload
def min(arg0: pydrake.autodiffutils.AutoDiffXd, arg1: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def min(arg0: pydrake.symbolic.Expression, arg1: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def pow(arg0: float, arg1: float) -> float: ...
@overload
def pow(arg0: pydrake.autodiffutils.AutoDiffXd, arg1: float) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def pow(arg0: pydrake.symbolic.Expression, arg1: float) -> pydrake.symbolic.Expression: ...
@overload
def pow(arg0: pydrake.symbolic.Expression, arg1: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def sin(arg0: float) -> float: ...
@overload
def sin(arg0: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def sin(arg0: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def sinh(arg0: float) -> float: ...
@overload
def sinh(arg0: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def sinh(arg0: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def sqrt(arg0: float) -> float: ...
@overload
def sqrt(arg0: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def sqrt(arg0: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def tan(arg0: float) -> float: ...
@overload
def tan(arg0: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def tan(arg0: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def tanh(arg0: float) -> float: ...
@overload
def tanh(arg0: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def tanh(arg0: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
@overload
def wrap_to(value: float, low: float, high: float) -> float: ...
@overload
def wrap_to(value: pydrake.autodiffutils.AutoDiffXd, low: pydrake.autodiffutils.AutoDiffXd, high: pydrake.autodiffutils.AutoDiffXd) -> pydrake.autodiffutils.AutoDiffXd: ...
@overload
def wrap_to(value: pydrake.symbolic.Expression, low: pydrake.symbolic.Expression, high: pydrake.symbolic.Expression) -> pydrake.symbolic.Expression: ...
