import numpy
import pydrake.lcm
import pydrake.multibody.parsing
import pydrake.multibody.tree
import pydrake.systems.framework
import pydrake.systems.lcm
import pydrake.systems.primitives
import types
from typing import Callable, ClassVar, overload

ApplyDriverConfigs: Callable
PandaControlMode: types.SimpleNamespace
kIiwaArmNumJoints: int
kIiwaLcmStatusPeriod: float
kPandaArmNumJoints: int

class IiwaCommandReceiver(pydrake.systems.framework.LeafSystem):
    def __init__(self, num_joints: int = ..., control_mode: IiwaControlMode = ...) -> None: ...
    def get_commanded_position_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_commanded_torque_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_message_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_position_measured_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_time_output_port(self) -> pydrake.systems.framework.OutputPort: ...

class IiwaCommandSender(pydrake.systems.framework.LeafSystem):
    def __init__(self, num_joints: int = ..., control_mode: IiwaControlMode = ...) -> None: ...
    def get_position_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_time_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_torque_input_port(self) -> pydrake.systems.framework.InputPort: ...

class IiwaControlMode:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kPositionAndTorque: ClassVar[IiwaControlMode] = ...
    kPositionOnly: ClassVar[IiwaControlMode] = ...
    kTorqueOnly: ClassVar[IiwaControlMode] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class IiwaDriver:
    __fields__: ClassVar[tuple] = ...  # read-only
    arm_child_frame_name: str | None
    control_mode: str
    desired_kp_gains: numpy.ndarray[numpy.float64[m, 1]] | None
    ext_joint_filter_tau: float
    gripper_parent_frame_name: str | None
    hand_model_name: str
    lcm_bus: str
    lcm_status_period: float
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> IiwaDriver: ...
    def __deepcopy__(self, arg0: dict) -> IiwaDriver: ...

class IiwaStatusReceiver(pydrake.systems.framework.LeafSystem):
    def __init__(self, num_joints: int = ...) -> None: ...
    def get_position_commanded_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_position_measured_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_time_measured_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_torque_commanded_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_torque_external_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_torque_measured_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_velocity_estimated_output_port(self) -> pydrake.systems.framework.OutputPort: ...

class IiwaStatusSender(pydrake.systems.framework.LeafSystem):
    def __init__(self, num_joints: int = ...) -> None: ...
    def get_position_commanded_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_position_measured_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_time_measured_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_torque_commanded_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_torque_external_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_torque_measured_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_velocity_estimated_input_port(self) -> pydrake.systems.framework.InputPort: ...

class PandaCommandReceiver(pydrake.systems.framework.LeafSystem):
    def __init__(self, num_joints: int, control_mode: int) -> None: ...
    def LatchInitialPosition(self, context: pydrake.systems.framework.Context) -> None: ...
    def get_commanded_position_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_commanded_torque_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_commanded_velocity_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_message_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_position_measured_input_port(self) -> pydrake.systems.framework.InputPort: ...

class PandaCommandSender(pydrake.systems.framework.LeafSystem):
    def __init__(self, num_joints: int, control_mode: int) -> None: ...
    def get_position_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_torque_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_velocity_input_port(self) -> pydrake.systems.framework.InputPort: ...

class PandaStatusReceiver(pydrake.systems.framework.LeafSystem):
    def __init__(self, num_joints: int = ...) -> None: ...
    def get_acceleration_commanded_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_position_commanded_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_position_measured_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_torque_commanded_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_torque_external_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_torque_measured_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_velocity_commanded_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_velocity_measured_output_port(self) -> pydrake.systems.framework.OutputPort: ...

class PandaStatusSender(pydrake.systems.framework.LeafSystem):
    def __init__(self, num_joints: int = ...) -> None: ...
    def get_acceleration_commanded_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_position_commanded_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_position_measured_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_torque_commanded_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_torque_external_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_torque_measured_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_velocity_commanded_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_velocity_measured_input_port(self) -> pydrake.systems.framework.InputPort: ...

class SchunkWsgCommandReceiver(pydrake.systems.framework.LeafSystem):
    def __init__(self, initial_position: float = ..., initial_force: float = ...) -> None: ...
    def get_force_limit_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_position_output_port(self) -> pydrake.systems.framework.OutputPort: ...

class SchunkWsgCommandSender(pydrake.systems.framework.LeafSystem):
    def __init__(self, default_force_limit: float = ...) -> None: ...
    def get_command_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_force_limit_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_position_input_port(self) -> pydrake.systems.framework.InputPort: ...

class SchunkWsgController(pydrake.systems.framework.Diagram):
    def __init__(self, kp: float = ..., ki: float = ..., kd: float = ...) -> None: ...

class SchunkWsgDriver:
    __fields__: ClassVar[tuple] = ...  # read-only
    lcm_bus: str
    pid_gains: numpy.ndarray[numpy.float64[3, 1]]
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> SchunkWsgDriver: ...
    def __deepcopy__(self, arg0: dict) -> SchunkWsgDriver: ...

class SchunkWsgPositionController(pydrake.systems.framework.Diagram):
    def __init__(self, time_step: float = ..., kp_command: float = ..., kd_command: float = ..., kp_constraint: float = ..., kd_constraint: float = ..., default_force_limit: float = ...) -> None: ...
    def get_desired_position_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_force_limit_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_generalized_force_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_grip_force_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_state_input_port(self) -> pydrake.systems.framework.InputPort: ...

class SchunkWsgStatusReceiver(pydrake.systems.framework.LeafSystem):
    def __init__(self) -> None: ...
    def get_force_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_state_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_status_input_port(self) -> pydrake.systems.framework.InputPort: ...

class SchunkWsgStatusSender(pydrake.systems.framework.LeafSystem):
    def __init__(self) -> None: ...
    def get_force_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_state_input_port(self) -> pydrake.systems.framework.InputPort: ...

class SchunkWsgTrajectoryGenerator(pydrake.systems.framework.LeafSystem):
    def __init__(self, input_size: int, position_index: int, use_force_limit: bool = ...) -> None: ...
    def get_desired_position_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_force_limit_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_max_force_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_state_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def get_target_output_port(self) -> pydrake.systems.framework.OutputPort: ...

class SimIiwaDriver(pydrake.systems.framework.Diagram):
    def __init__(self, driver_config: IiwaDriver, controller_plant) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder, plant, iiwa_instance: pydrake.multibody.tree.ModelInstanceIndex, driver_config: IiwaDriver, controller_plant) -> pydrake.systems.framework.System: ...

class ZeroForceDriver:
    __fields__: ClassVar[tuple] = ...  # read-only
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> ZeroForceDriver: ...
    def __deepcopy__(self, arg0: dict) -> ZeroForceDriver: ...

@overload
def ApplyDriverConfig(driver_config: IiwaDriver, model_instance_name: str, sim_plant, models_from_directives: dict[str, pydrake.multibody.parsing.ModelInstanceInfo], lcms: pydrake.systems.lcm.LcmBuses, builder: pydrake.systems.framework.DiagramBuilder) -> None: ...
@overload
def ApplyDriverConfig(driver_config: SchunkWsgDriver, model_instance_name: str, sim_plant, models_from_directives: dict[str, pydrake.multibody.parsing.ModelInstanceInfo], lcms: pydrake.systems.lcm.LcmBuses, builder: pydrake.systems.framework.DiagramBuilder) -> None: ...
@overload
def ApplyDriverConfig(driver_config: ZeroForceDriver, model_instance_name: str, sim_plant, models_from_directives: dict[str, pydrake.multibody.parsing.ModelInstanceInfo], lcms: pydrake.systems.lcm.LcmBuses, builder: pydrake.systems.framework.DiagramBuilder) -> None: ...
def ApplyNamedPositionsAsDefaults(input: dict[str, dict[str, numpy.ndarray[numpy.float64[m, 1]]]], plant) -> None: ...
def BuildIiwaControl(builder: pydrake.systems.framework.DiagramBuilder, lcm: pydrake.lcm.DrakeLcmInterface, plant, iiwa_instance: pydrake.multibody.tree.ModelInstanceIndex, driver_config: IiwaDriver, controller_plant) -> None: ...
def BuildSchunkWsgControl(plant, wsg_instance: pydrake.multibody.tree.ModelInstanceIndex, lcm: pydrake.lcm.DrakeLcmInterface, builder: pydrake.systems.framework.DiagramBuilder, pid_gains: numpy.ndarray[numpy.float64[3, 1]] | None = ...) -> None: ...
def GetSchunkWsgOpenPosition() -> numpy.ndarray[numpy.float64[m, 1]]: ...
def MakeMultibodyForceToWsgForceSystem() -> pydrake.systems.framework.VectorSystem: ...
def MakeMultibodyStateToWsgStateSystem() -> pydrake.systems.primitives.MatrixGain: ...
def ParseIiwaControlMode(control_mode: str) -> IiwaControlMode: ...
def get_iiwa_max_joint_velocities() -> numpy.ndarray[numpy.float64[m, 1]]: ...
def position_enabled(control_mode: IiwaControlMode) -> bool: ...
def torque_enabled(control_mode: IiwaControlMode) -> bool: ...
