import flags
import numpy
import os
import pydrake.common
import pydrake.geometry
import pydrake.math
import pydrake.solvers
import pydrake.symbolic
import pydrake.systems.framework
from pydrake.common.cpp_template import CSpaceSeparatingPlane_ as CSpaceSeparatingPlane_
from typing import Any, ClassVar, overload

class AffineBall(ConvexSet):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, B: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], center: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def __init__(self, ellipsoid: Hyperellipsoid) -> None: ...
    def B(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def Clone(self) -> ConvexSet: ...
    @staticmethod
    def MakeAffineBallFromLineSegment(x_1: numpy.ndarray[numpy.float64[m, 1]], x_2: numpy.ndarray[numpy.float64[m, 1]], epsilon: float = ...) -> AffineBall: ...
    @staticmethod
    def MakeAxisAligned(radius: numpy.ndarray[numpy.float64[m, 1]], center: numpy.ndarray[numpy.float64[m, 1]]) -> AffineBall: ...
    @staticmethod
    def MakeHypersphere(radius: float, center: numpy.ndarray[numpy.float64[m, 1]]) -> AffineBall: ...
    @staticmethod
    def MakeUnitBall(dim: int) -> AffineBall: ...
    @staticmethod
    def MinimumVolumeCircumscribedEllipsoid(points: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], rank_tol: float = ...) -> AffineBall: ...
    def center(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def __copy__(self) -> ConvexSet: ...
    def __deepcopy__(self, arg0: dict) -> ConvexSet: ...

class AffineSubspace(ConvexSet):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, basis: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], translation: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def __init__(self, set: ConvexSet, tol: float = ...) -> None: ...
    def AffineDimension(self) -> int: ...
    def Clone(self) -> ConvexSet: ...
    def ContainedIn(self, other: AffineSubspace, tol: float = ...) -> bool: ...
    def IsNearlyEqualTo(self, other: AffineSubspace, tol: float = ...) -> bool: ...
    def OrthogonalComplementBasis(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def ToGlobalCoordinates(self, y: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def ToLocalCoordinates(self, x: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @overload
    def ToLocalCoordinates(self, x) -> Any: ...
    def basis(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def translation(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def __copy__(self) -> ConvexSet: ...
    def __deepcopy__(self, arg0: dict) -> ConvexSet: ...

class CIrisCollisionGeometry:
    def __init__(self, *args, **kwargs) -> None: ...
    def X_BG(self) -> pydrake.math.RigidTransform: ...
    def body_index(self, *args, **kwargs): ...
    def geometry(self) -> pydrake.geometry.Shape: ...
    def id(self) -> pydrake.geometry.GeometryId: ...
    def num_rationals(self) -> int: ...
    def type(self) -> CIrisGeometryType: ...

class CIrisGeometryType:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kCapsule: ClassVar[CIrisGeometryType] = ...
    kCylinder: ClassVar[CIrisGeometryType] = ...
    kPolytope: ClassVar[CIrisGeometryType] = ...
    kSphere: ClassVar[CIrisGeometryType] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class CSpaceSeparatingPlane:
    def __init__(self, *args, **kwargs) -> None: ...
    def __copy__(self) -> CSpaceSeparatingPlane: ...
    def __deepcopy__(self, arg0: dict) -> CSpaceSeparatingPlane: ...
    @property
    def a(self) -> numpy.ndarray[object[3, 1]]: ...
    @property
    def b(self) -> pydrake.symbolic.Polynomial: ...
    @property
    def decision_variables(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @property
    def expressed_body(self): ...
    @property
    def negative_side_geometry(self) -> CIrisCollisionGeometry: ...
    @property
    def plane_degree(self) -> int: ...
    @property
    def positive_side_geometry(self) -> CIrisCollisionGeometry: ...

class CSpaceSeparatingPlane_𝓣Variable𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def __copy__(self) -> CSpaceSeparatingPlane_TVariableU: ...
    def __deepcopy__(self, arg0: dict) -> CSpaceSeparatingPlane_TVariableU: ...
    @property
    def a(self) -> numpy.ndarray[object[3, 1]]: ...
    @property
    def b(self) -> pydrake.symbolic.Polynomial: ...
    @property
    def decision_variables(self) -> numpy.ndarray[object[m, 1]]: ...
    @property
    def expressed_body(self): ...
    @property
    def negative_side_geometry(self) -> CIrisCollisionGeometry: ...
    @property
    def plane_degree(self) -> int: ...
    @property
    def positive_side_geometry(self) -> CIrisCollisionGeometry: ...

class CartesianProduct(ConvexSet):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, sets: list[ConvexSet]) -> None: ...
    @overload
    def __init__(self, setA: ConvexSet, setB: ConvexSet) -> None: ...
    @overload
    def __init__(self, sets: list[ConvexSet], A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], b: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def __init__(self, query_object: pydrake.geometry.QueryObject, geometry_id: pydrake.geometry.GeometryId, reference_frame: pydrake.geometry.FrameId | None = ...) -> None: ...
    def A(self) -> numpy.ndarray[numpy.float64[m, n]] | None: ...
    def b(self) -> numpy.ndarray[numpy.float64[m, 1]] | None: ...
    def factor(self, index: int) -> ConvexSet: ...
    def num_factors(self) -> int: ...

class ConvexHull(ConvexSet):
    def __init__(self, sets: list[ConvexSet], remove_empty_sets: bool = ...) -> None: ...
    def element(self, index: int) -> ConvexSet: ...
    def empty_sets_removed(self) -> bool: ...
    def num_elements(self) -> int: ...
    def participating_sets(self) -> object: ...
    def sets(self) -> object: ...

class ConvexSet:
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def AddPointInNonnegativeScalingConstraints(self, prog: pydrake.solvers.MathematicalProgram, x: numpy.ndarray[object[m, 1]], t: pydrake.symbolic.Variable) -> list[pydrake.solvers.BindingTConstraintU]: ...
    @overload
    def AddPointInNonnegativeScalingConstraints(self, prog: pydrake.solvers.MathematicalProgram, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], b: numpy.ndarray[numpy.float64[m, 1]], c: numpy.ndarray[numpy.float64[m, 1]], d: float, x: numpy.ndarray[object[m, 1]], t: numpy.ndarray[object[m, 1]]) -> list[pydrake.solvers.BindingTConstraintU]: ...
    def AddPointInSetConstraints(self, prog: pydrake.solvers.MathematicalProgram, vars: numpy.ndarray[object[m, 1]]) -> tuple[numpy.ndarray[object[m, 1]], list[pydrake.solvers.BindingTConstraintU]]: ...
    def CalcVolume(self) -> float: ...
    def CalcVolumeViaSampling(self, generator: pydrake.common.RandomGenerator, desired_rel_accuracy: float = ..., max_num_samples: int = ...) -> SampledVolume: ...
    def Clone(self) -> ConvexSet: ...
    def IntersectsWith(self, other: ConvexSet) -> bool: ...
    def IsBounded(self, parallelism: pydrake.common.Parallelism = ...) -> bool: ...
    def IsEmpty(self) -> bool: ...
    def MaybeGetFeasiblePoint(self) -> numpy.ndarray[numpy.float64[m, 1]] | None: ...
    def MaybeGetPoint(self) -> numpy.ndarray[numpy.float64[m, 1]] | None: ...
    def PointInSet(self, x: numpy.ndarray[numpy.float64[m, 1]], tol: float = ...) -> bool: ...
    def Projection(self, points: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> tuple[list[float], numpy.ndarray[numpy.float64[m, n]]] | None: ...
    def ToShapeWithPose(self) -> tuple[pydrake.geometry.Shape, pydrake.math.RigidTransform]: ...
    @overload
    def ambient_dimension(self) -> int: ...
    @overload
    def ambient_dimension(self) -> Any: ...

class CspaceFreePolytope(CspaceFreePolytopeBase):
    class BilinearAlternationOptions:
        convergence_tol: float
        ellipsoid_scaling: float
        find_polytope_options: CspaceFreePolytope.FindPolytopeGivenLagrangianOptions
        max_iter: int
        def __init__(self) -> None: ...
        @property
        def find_lagrangian_options(self) -> CspaceFreePolytope.FindSeparationCertificateGivenPolytopeOptions: ...

    class BinarySearchOptions:
        convergence_tol: float
        max_iter: int
        scale_max: float
        scale_min: float
        def __init__(self) -> None: ...
        @property
        def find_lagrangian_options(self) -> CspaceFreePolytope.FindSeparationCertificateGivenPolytopeOptions: ...

    class EllipsoidMarginCost:
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        kGeometricMean: ClassVar[CspaceFreePolytope.EllipsoidMarginCost] = ...
        kSum: ClassVar[CspaceFreePolytope.EllipsoidMarginCost] = ...
        def __init__(self, value: int) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class FindPolytopeGivenLagrangianOptions:
        backoff_scale: float | None
        ellipsoid_margin_cost: CspaceFreePolytope.EllipsoidMarginCost
        ellipsoid_margin_epsilon: float
        s_inner_pts: numpy.ndarray[numpy.float64[m, n]] | None
        search_s_bounds_lagrangians: bool
        solver_id: pydrake.solvers.SolverId
        solver_options: pydrake.solvers.SolverOptions | None
        def __init__(self) -> None: ...

    class FindSeparationCertificateGivenPolytopeOptions(FindSeparationCertificateOptions):
        ignore_redundant_C: bool
        def __init__(self) -> None: ...

    class SearchResult:
        def __init__(self) -> None: ...
        def C(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
        def a(self) -> dict[int, numpy.ndarray[object[3, 1]]]: ...
        def b(self) -> dict[int, pydrake.symbolic.Polynomial]: ...
        def certified_polytope(self) -> HPolyhedron: ...
        def d(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
        def num_iter(self) -> int: ...

    class SeparatingPlaneLagrangians:
        def __init__(self, C_rows: int, s_size: int) -> None: ...
        def GetSolution(self, result: pydrake.solvers.MathematicalProgramResult) -> CspaceFreePolytope.SeparatingPlaneLagrangians: ...
        def polytope(self) -> numpy.ndarray[object[m, 1]]: ...
        def s_lower(self) -> numpy.ndarray[object[m, 1]]: ...
        def s_upper(self) -> numpy.ndarray[object[m, 1]]: ...

    class SeparationCertificate:
        negative_side_rational_lagrangians: list[CspaceFreePolytope.SeparatingPlaneLagrangians]
        positive_side_rational_lagrangians: list[CspaceFreePolytope.SeparatingPlaneLagrangians]
        def __init__(self, *args, **kwargs) -> None: ...
        def GetSolution(self, plane_index: int, a: numpy.ndarray[object[3, 1]], b: pydrake.symbolic.Polynomial, plane_decision_vars: numpy.ndarray[object[m, 1]], result: pydrake.solvers.MathematicalProgramResult) -> CspaceFreePolytope.SeparationCertificateResult: ...

    class SeparationCertificateProgram(SeparationCertificateProgramBase):
        def __init__(self) -> None: ...
        @property
        def certificate(self) -> CspaceFreePolytope.SeparationCertificate: ...
        @property
        def plane_index(self) -> int: ...

    class SeparationCertificateResult:
        def __init__(self, *args, **kwargs) -> None: ...
        @property
        def a(self) -> numpy.ndarray[object[3, 1]]: ...
        @property
        def b(self) -> pydrake.symbolic.Polynomial: ...
        @property
        def negative_side_rational_lagrangians(self) -> list[CspaceFreePolytope.SeparatingPlaneLagrangians]: ...
        @property
        def plane_decision_var_vals(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
        @property
        def plane_index(self) -> int: ...
        @property
        def positive_side_rational_lagrangians(self) -> list[CspaceFreePolytope.SeparatingPlaneLagrangians]: ...
        @property
        def result(self) -> pydrake.solvers.MathematicalProgramResult: ...
    def __init__(self, plant, scene_graph: pydrake.geometry.SceneGraph, plane_order: SeparatingPlaneOrder, q_star: numpy.ndarray[numpy.float64[m, 1]], options: CspaceFreePolytopeBase.Options = ...) -> None: ...
    def BinarySearch(self, ignored_collision_pairs: set[tuple[pydrake.geometry.GeometryId]], C: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], d: numpy.ndarray[numpy.float64[m, 1]], s_center: numpy.ndarray[numpy.float64[m, 1]], options: CspaceFreePolytope.BinarySearchOptions) -> CspaceFreePolytope.SearchResult | None: ...
    def FindSeparationCertificateGivenPolytope(self, C: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], d: numpy.ndarray[numpy.float64[m, 1]], ignored_collision_pairs: set[tuple[pydrake.geometry.GeometryId]], options: CspaceFreePolytope.FindSeparationCertificateGivenPolytopeOptions) -> tuple[bool, dict[tuple[pydrake.geometry.GeometryId], CspaceFreePolytope.SeparationCertificateResult]]: ...
    def MakeIsGeometrySeparableProgram(self, geometry_pair: tuple[pydrake.geometry.GeometryId], C: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], d: numpy.ndarray[numpy.float64[m, 1]]) -> CspaceFreePolytope.SeparationCertificateProgram: ...
    def SearchWithBilinearAlternation(self, ignored_collision_pairs: set[tuple[pydrake.geometry.GeometryId]], C_init: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], d_init: numpy.ndarray[numpy.float64[m, 1]], options: CspaceFreePolytope.BilinearAlternationOptions) -> list[CspaceFreePolytope.SearchResult]: ...
    def SolveSeparationCertificateProgram(self, certificate_program: CspaceFreePolytope.SeparationCertificateProgram, options: CspaceFreePolytope.FindSeparationCertificateGivenPolytopeOptions) -> CspaceFreePolytope.SeparationCertificateResult | None: ...

class CspaceFreePolytopeBase:
    class Options:
        with_cross_y: bool
        def __init__(self) -> None: ...
    def __init__(self, *args, **kwargs) -> None: ...
    def map_geometries_to_separating_planes(self) -> dict[tuple[pydrake.geometry.GeometryId], int]: ...
    def separating_planes(self) -> list[CSpaceSeparatingPlane_TVariableU]: ...
    def y_slack(self) -> numpy.ndarray[object[3, 1]]: ...

class FindSeparationCertificateOptions:
    parallelism: pydrake.common.Parallelism
    solver_id: pydrake.solvers.SolverId
    solver_options: pydrake.solvers.SolverOptions | None
    terminate_at_failure: bool
    verbose: bool
    def __init__(self) -> None: ...

class GcsGraphvizOptions:
    __fields__: ClassVar[tuple] = ...  # read-only
    precision: int
    scientific: bool
    show_costs: bool
    show_flows: bool
    show_slacks: bool
    show_vars: bool
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> GcsGraphvizOptions: ...
    def __deepcopy__(self, arg0: dict) -> GcsGraphvizOptions: ...

class GraphOfConvexSets:
    class Edge:
        def __init__(self, *args, **kwargs) -> None: ...
        @overload
        def AddConstraint(self, f: pydrake.symbolic.Formula, use_in_transcription: set[GraphOfConvexSets.Transcription] = ...) -> pydrake.solvers.BindingTConstraintU: ...
        @overload
        def AddConstraint(self, binding: pydrake.solvers.BindingTConstraintU, use_in_transcription: set[GraphOfConvexSets.Transcription] = ...) -> pydrake.solvers.BindingTConstraintU: ...
        @overload
        def AddCost(self, e: pydrake.symbolic.Expression, use_in_transcription: set[GraphOfConvexSets.Transcription] = ...) -> pydrake.solvers.BindingTCostU: ...
        @overload
        def AddCost(self, binding: pydrake.solvers.BindingTCostU, use_in_transcription: set[GraphOfConvexSets.Transcription] = ...) -> pydrake.solvers.BindingTCostU: ...
        def AddPhiConstraint(self, phi_value: bool) -> None: ...
        def ClearPhiConstraints(self) -> None: ...
        def GetConstraints(self, used_in_transcription: set[GraphOfConvexSets.Transcription] = ...) -> list[pydrake.solvers.BindingTConstraintU]: ...
        def GetCosts(self, used_in_transcription: set[GraphOfConvexSets.Transcription] = ...) -> list[pydrake.solvers.BindingTCostU]: ...
        @overload
        def GetSolutionCost(self, result: pydrake.solvers.MathematicalProgramResult) -> float | None: ...
        @overload
        def GetSolutionCost(self, result: pydrake.solvers.MathematicalProgramResult, cost: pydrake.solvers.BindingTCostU) -> float | None: ...
        def GetSolutionPhiXu(self, result: pydrake.solvers.MathematicalProgramResult) -> numpy.ndarray[numpy.float64[m, 1]] | None: ...
        def GetSolutionPhiXv(self, result: pydrake.solvers.MathematicalProgramResult) -> numpy.ndarray[numpy.float64[m, 1]] | None: ...
        def id(self) -> GraphOfConvexSets.EdgeId: ...
        def name(self) -> str: ...
        @overload
        def phi(self) -> pydrake.symbolic.Variable: ...
        @overload
        def phi(self) -> Any: ...
        def u(self) -> GraphOfConvexSets.Vertex: ...
        def v(self) -> GraphOfConvexSets.Vertex: ...
        @overload
        def xu(self) -> numpy.ndarray[object[m, 1]]: ...
        @overload
        def xu(self) -> Any: ...
        @overload
        def xv(self) -> numpy.ndarray[object[m, 1]]: ...
        @overload
        def xv(self) -> Any: ...

    class EdgeId:
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def get_new_id() -> GraphOfConvexSets.EdgeId: ...
        def get_value(self) -> int: ...
        def is_valid(self) -> bool: ...
        def __eq__(self, arg0: GraphOfConvexSets.EdgeId) -> bool: ...
        def __hash__(self) -> int: ...
        def __lt__(self, arg0: GraphOfConvexSets.EdgeId) -> bool: ...
        def __ne__(self, arg0: GraphOfConvexSets.EdgeId) -> bool: ...

    class Transcription:
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        kMIP: ClassVar[GraphOfConvexSets.Transcription] = ...
        kRelaxation: ClassVar[GraphOfConvexSets.Transcription] = ...
        kRestriction: ClassVar[GraphOfConvexSets.Transcription] = ...
        def __init__(self, value: int) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...

    class Vertex:
        def __init__(self, *args, **kwargs) -> None: ...
        @overload
        def AddConstraint(self, f: pydrake.symbolic.Formula, use_in_transcription: set[GraphOfConvexSets.Transcription] = ...) -> pydrake.solvers.BindingTConstraintU: ...
        @overload
        def AddConstraint(self, binding: pydrake.solvers.BindingTConstraintU, use_in_transcription: set[GraphOfConvexSets.Transcription] = ...) -> pydrake.solvers.BindingTConstraintU: ...
        @overload
        def AddCost(self, e: pydrake.symbolic.Expression, use_in_transcription: set[GraphOfConvexSets.Transcription] = ...) -> pydrake.solvers.BindingTCostU: ...
        @overload
        def AddCost(self, binding: pydrake.solvers.BindingTCostU, use_in_transcription: set[GraphOfConvexSets.Transcription] = ...) -> pydrake.solvers.BindingTCostU: ...
        def GetConstraints(self, used_in_transcription: set[GraphOfConvexSets.Transcription] = ...) -> list[pydrake.solvers.BindingTConstraintU]: ...
        def GetCosts(self, used_in_transcription: set[GraphOfConvexSets.Transcription] = ...) -> list[pydrake.solvers.BindingTCostU]: ...
        def GetSolution(self, result: pydrake.solvers.MathematicalProgramResult) -> numpy.ndarray[numpy.float64[m, 1]] | None: ...
        @overload
        def GetSolutionCost(self, result: pydrake.solvers.MathematicalProgramResult) -> float | None: ...
        @overload
        def GetSolutionCost(self, result: pydrake.solvers.MathematicalProgramResult, cost: pydrake.solvers.BindingTCostU) -> float | None: ...
        def ambient_dimension(self) -> int: ...
        def id(self) -> GraphOfConvexSets.VertexId: ...
        def incoming_edges(self, *args, **kwargs): ...
        def name(self) -> str: ...
        def outgoing_edges(self, *args, **kwargs): ...
        def set(self) -> ConvexSet: ...
        def x(self) -> numpy.ndarray[object[m, 1]]: ...

    class VertexId:
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def get_new_id() -> GraphOfConvexSets.VertexId: ...
        def get_value(self) -> int: ...
        def is_valid(self) -> bool: ...
        def __eq__(self, arg0: GraphOfConvexSets.VertexId) -> bool: ...
        def __hash__(self) -> int: ...
        def __lt__(self, arg0: GraphOfConvexSets.VertexId) -> bool: ...
        def __ne__(self, arg0: GraphOfConvexSets.VertexId) -> bool: ...
    def __init__(self) -> None: ...
    def AddEdge(self, u: GraphOfConvexSets.Vertex, v: GraphOfConvexSets.Vertex, name: str = ...) -> GraphOfConvexSets.Edge: ...
    def AddEdgeFromTemplate(self, u: GraphOfConvexSets.Vertex, v: GraphOfConvexSets.Vertex, template_edge: GraphOfConvexSets.Edge) -> GraphOfConvexSets.Edge: ...
    def AddVertex(self, set: ConvexSet, name: str = ...) -> GraphOfConvexSets.Vertex: ...
    def AddVertexFromTemplate(self, template_vertex: GraphOfConvexSets.Vertex) -> GraphOfConvexSets.Vertex: ...
    def ClearAllPhiConstraints(self) -> None: ...
    def Clone(self) -> GraphOfConvexSets: ...
    def Edges(self) -> list[GraphOfConvexSets.Edge]: ...
    def GetEdgeByName(self, name: str) -> GraphOfConvexSets.Edge: ...
    @overload
    def GetGraphvizString(self, result: pydrake.solvers.MathematicalProgramResult = ..., options: GcsGraphvizOptions = ..., active_path: list[GraphOfConvexSets.Edge] = ...) -> str: ...
    @overload
    def GetGraphvizString(self, result: pydrake.solvers.MathematicalProgramResult = ..., show_slacks: bool = ..., show_vars: bool = ..., show_flows: bool = ..., show_costs: bool = ..., scientific: bool = ..., precision: int = ..., active_path: list[GraphOfConvexSets.Edge] = ...) -> str: ...
    def GetMutableEdgeByName(self, name: str) -> GraphOfConvexSets.Edge: ...
    def GetMutableVertexByName(self, name: str) -> GraphOfConvexSets.Vertex: ...
    def GetSolutionPath(self, source: GraphOfConvexSets.Vertex, target: GraphOfConvexSets.Vertex, result: pydrake.solvers.MathematicalProgramResult, tolerance: float = ...) -> list[GraphOfConvexSets.Edge]: ...
    def GetVertexByName(self, name: str) -> GraphOfConvexSets.Vertex: ...
    @overload
    def IsValid(self, v: GraphOfConvexSets.Vertex) -> bool: ...
    @overload
    def IsValid(self, e: GraphOfConvexSets.Edge) -> bool: ...
    def RemoveEdge(self, edge: GraphOfConvexSets.Edge) -> None: ...
    def RemoveVertex(self, vertex: GraphOfConvexSets.Vertex) -> None: ...
    def SamplePaths(self, source: GraphOfConvexSets.Vertex, target: GraphOfConvexSets.Vertex, flows: dict[GraphOfConvexSets.Edge, float], options: GraphOfConvexSetsOptions) -> list[list[GraphOfConvexSets.Edge]]: ...
    def SolveConvexRestriction(self, active_edges: list[GraphOfConvexSets.Edge], options: GraphOfConvexSetsOptions = ..., initial_guess: pydrake.solvers.MathematicalProgramResult = ...) -> pydrake.solvers.MathematicalProgramResult: ...
    def SolveShortestPath(self, source: GraphOfConvexSets.Vertex, target: GraphOfConvexSets.Vertex, options: GraphOfConvexSetsOptions = ...) -> pydrake.solvers.MathematicalProgramResult: ...
    def Vertices(self) -> list[GraphOfConvexSets.Vertex]: ...
    def num_edges(self) -> int: ...
    def num_vertices(self) -> int: ...
    def __copy__(self) -> GraphOfConvexSets: ...
    def __deepcopy__(self, arg0: dict) -> GraphOfConvexSets: ...

class GraphOfConvexSetsOptions:
    convex_relaxation: bool | None
    flow_tolerance: float
    max_rounded_paths: int | None
    max_rounding_trials: int
    parallelism: pydrake.common.Parallelism
    preprocessing: bool | None
    preprocessing_solver: pydrake.solvers.SolverInterface
    preprocessing_solver_options: pydrake.solvers.SolverOptions | None
    restriction_solver: pydrake.solvers.SolverInterface
    restriction_solver_options: pydrake.solvers.SolverOptions | None
    rounding_seed: int
    solver: pydrake.solvers.SolverInterface
    solver_options: pydrake.solvers.SolverOptions
    def __init__(self) -> None: ...

class HPolyhedron(ConvexSet):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], b: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def __init__(self, query_object: pydrake.geometry.QueryObject, geometry_id: pydrake.geometry.GeometryId, reference_frame: pydrake.geometry.FrameId | None = ...) -> None: ...
    @overload
    def __init__(self, vpoly: VPolytope, tol: float = ...) -> None: ...
    @overload
    def __init__(self, prog: pydrake.solvers.MathematicalProgram) -> None: ...
    def A(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    def CartesianPower(self, n: int) -> HPolyhedron: ...
    def CartesianProduct(self, other: HPolyhedron) -> HPolyhedron: ...
    def ChebyshevCenter(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def ContainedIn(self, other: HPolyhedron, tol: float = ...) -> bool: ...
    def FindRedundant(self, tol: float = ...) -> set[int]: ...
    def Intersection(self, other: HPolyhedron, check_for_redundancy: bool = ..., tol: float = ...) -> HPolyhedron: ...
    @staticmethod
    def MakeBox(lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]]) -> HPolyhedron: ...
    @staticmethod
    def MakeL1Ball(dim: int) -> HPolyhedron: ...
    @staticmethod
    def MakeUnitBox(dim: int) -> HPolyhedron: ...
    def MaximumVolumeInscribedAffineTransformation(self, circumbody: HPolyhedron, check_bounded: bool = ...) -> HPolyhedron: ...
    def MaximumVolumeInscribedEllipsoid(self) -> Hyperellipsoid: ...
    def PontryaginDifference(self, other: HPolyhedron) -> HPolyhedron: ...
    def ReduceInequalities(self, tol: float = ...) -> HPolyhedron: ...
    def Scale(self, scale: float, center: numpy.ndarray[numpy.float64[m, 1]] | None = ...) -> HPolyhedron: ...
    def SimplifyByIncrementalFaceTranslation(self, min_volume_ratio: float = ..., do_affine_transformation: bool = ..., max_iterations: int = ..., points_to_contain: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] = ..., intersecting_polytopes: list[HPolyhedron] = ..., keep_whole_intersection: bool = ..., intersection_padding: float = ..., random_seed: int = ...) -> HPolyhedron: ...
    @overload
    def UniformSample(self, generator: pydrake.common.RandomGenerator, previous_sample: numpy.ndarray[numpy.float64[m, 1]], mixing_steps: int = ..., subspace: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] | None = ..., tol: float = ...) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @overload
    def UniformSample(self, generator: pydrake.common.RandomGenerator, mixing_steps: int = ..., subspace: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous] | None = ..., tol: float = ...) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def b(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class Hyperellipsoid(ConvexSet):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, A: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], center: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def __init__(self, query_object: pydrake.geometry.QueryObject, geometry_id: pydrake.geometry.GeometryId, reference_frame: pydrake.geometry.FrameId | None = ...) -> None: ...
    @overload
    def __init__(self, ellipsoid: AffineBall) -> None: ...
    def A(self) -> numpy.ndarray[numpy.float64[m, n]]: ...
    @staticmethod
    def MakeAxisAligned(radius: numpy.ndarray[numpy.float64[m, 1]], center: numpy.ndarray[numpy.float64[m, 1]]) -> Hyperellipsoid: ...
    @staticmethod
    def MakeHypersphere(radius: float, center: numpy.ndarray[numpy.float64[m, 1]]) -> Hyperellipsoid: ...
    @staticmethod
    def MakeUnitBall(dim: int) -> Hyperellipsoid: ...
    def MinimumUniformScalingToTouch(self, other: ConvexSet) -> tuple[float, numpy.ndarray[numpy.float64[m, 1]]]: ...
    @staticmethod
    def MinimumVolumeCircumscribedEllipsoid(points: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], rank_tol: float = ...) -> Hyperellipsoid: ...
    def center(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class Hyperrectangle(ConvexSet):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def Center(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def MakeHPolyhedron(self) -> HPolyhedron: ...
    @staticmethod
    def MaybeCalcAxisAlignedBoundingBox(set: ConvexSet) -> Hyperrectangle | None: ...
    def MaybeGetIntersection(self, arg0: Hyperrectangle) -> Hyperrectangle | None: ...
    def UniformSample(self, generator: pydrake.common.RandomGenerator) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def lb(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def ub(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class ImplicitGraphOfConvexSets:
    def __init__(self) -> None: ...
    def ExpandRecursively(self, start: GraphOfConvexSets.Vertex, max_successor_calls: int = ...) -> None: ...
    def Successors(self, v: GraphOfConvexSets.Vertex) -> list[GraphOfConvexSets.Edge]: ...
    def gcs(self) -> GraphOfConvexSets: ...
    def mutable_gcs(self) -> GraphOfConvexSets: ...

class ImplicitGraphOfConvexSetsFromExplicit(ImplicitGraphOfConvexSets):
    def __init__(self, gcs: GraphOfConvexSets) -> None: ...
    def ImplicitVertexFromExplicit(self, v_explicit: GraphOfConvexSets.Vertex) -> GraphOfConvexSets.Vertex: ...

class Intersection(ConvexSet):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, sets: list[ConvexSet]) -> None: ...
    @overload
    def __init__(self, setA: ConvexSet, setB: ConvexSet) -> None: ...
    def element(self, index: int) -> ConvexSet: ...
    def num_elements(self) -> int: ...

class IrisOptions:
    bounding_region: HPolyhedron | None
    configuration_obstacles: object
    configuration_space_margin: float
    iteration_limit: int
    mixing_steps: int
    num_additional_constraint_infeasible_samples: int
    num_collision_infeasible_samples: int
    prog_with_additional_constraints: pydrake.solvers.MathematicalProgram
    random_seed: int
    relative_termination_threshold: float
    require_sample_point_is_contained: bool
    solver_options: pydrake.solvers.SolverOptions | None
    starting_ellipse: Hyperellipsoid | None
    termination_threshold: float
    verify_domain_boundedness: bool
    def __init__(self, **kwargs) -> None: ...

class MinkowskiSum(ConvexSet):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, sets: list[ConvexSet]) -> None: ...
    @overload
    def __init__(self, setA: ConvexSet, setB: ConvexSet) -> None: ...
    @overload
    def __init__(self, query_object: pydrake.geometry.QueryObject, geometry_id: pydrake.geometry.GeometryId, reference_frame: pydrake.geometry.FrameId | None = ...) -> None: ...
    def num_terms(self) -> int: ...
    def term(self, index: int) -> ConvexSet: ...

class PlaneSide:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kNegative: ClassVar[PlaneSide] = ...
    kPositive: ClassVar[PlaneSide] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class Point(ConvexSet):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def __init__(self, query_object: pydrake.geometry.QueryObject, geometry_id: pydrake.geometry.GeometryId, reference_frame: pydrake.geometry.FrameId | None = ..., maximum_allowable_radius: float = ...) -> None: ...
    def set_x(self, x: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def x(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class SampledVolume:
    num_samples: int
    rel_accuracy: float
    volume: float
    def __init__(self, *args, **kwargs) -> None: ...

class SeparatingPlaneOrder:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kAffine: ClassVar[SeparatingPlaneOrder] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SeparationCertificateProgramBase:
    def __init__(self, *args, **kwargs) -> None: ...
    def prog(self) -> pydrake.solvers.MathematicalProgram: ...
    @property
    def plane_index(self) -> int: ...

class SeparationCertificateResultBase:
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def a(self) -> numpy.ndarray[object[3, 1]]: ...
    @property
    def b(self) -> pydrake.symbolic.Polynomial: ...
    @property
    def plane_decision_var_vals(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    @property
    def result(self) -> pydrake.solvers.MathematicalProgramResult: ...

class Spectrahedron(ConvexSet):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, prog: pydrake.solvers.MathematicalProgram) -> None: ...

class VPolytope(ConvexSet):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, vertices: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous]) -> None: ...
    @overload
    def __init__(self, H: HPolyhedron, tol: float = ...) -> None: ...
    @overload
    def __init__(self, query_object: pydrake.geometry.QueryObject, geometry_id: pydrake.geometry.GeometryId, reference_frame: pydrake.geometry.FrameId | None = ...) -> None: ...
    def GetMinimalRepresentation(self, tol: float = ...) -> VPolytope: ...
    @staticmethod
    def MakeBox(lb: numpy.ndarray[numpy.float64[m, 1]], ub: numpy.ndarray[numpy.float64[m, 1]]) -> VPolytope: ...
    @staticmethod
    def MakeUnitBox(dim: int) -> VPolytope: ...
    def ToShapeConvex(self, convex_label: str = ...) -> pydrake.geometry.Convex: ...
    def WriteObj(self, filename: os.PathLike) -> None: ...
    def vertices(self) -> numpy.ndarray[numpy.float64[m, n]]: ...

class _TemporaryName_N5drake8geometry12optimization21CSpaceSeparatingPlaneINS_8symbolic8VariableEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def __copy__(self) -> CSpaceSeparatingPlane_TVariableU: ...
    def __deepcopy__(self, arg0: dict) -> CSpaceSeparatingPlane_TVariableU: ...
    @property
    def a(self) -> numpy.ndarray[object[3, 1]]: ...
    @property
    def b(self) -> pydrake.symbolic.Polynomial: ...
    @property
    def decision_variables(self) -> numpy.ndarray[object[m, 1]]: ...
    @property
    def expressed_body(self): ...
    @property
    def negative_side_geometry(self) -> CIrisCollisionGeometry: ...
    @property
    def plane_degree(self) -> int: ...
    @property
    def positive_side_geometry(self) -> CIrisCollisionGeometry: ...

def CheckIfSatisfiesConvexityRadius(convex_set: ConvexSet, continuous_revolute_joints: list[int]) -> bool: ...
def ComputePairwiseIntersections(convex_sets_A: list[ConvexSet], convex_sets_B: list[ConvexSet], continuous_revolute_joints: list[int], preprocess_bbox: bool = ..., parallelism: pydrake.common.Parallelism = ...) -> tuple[list[tuple[int, int]], list[numpy.ndarray[numpy.float64[m, 1]]]]: ...
def Iris(obstacles: list[ConvexSet], sample: numpy.ndarray[numpy.float64[m, 1]], domain: HPolyhedron, options: IrisOptions = ...) -> HPolyhedron: ...
def IrisNp(plant, context: pydrake.systems.framework.Context, options: IrisOptions = ...) -> HPolyhedron: ...
def LoadIrisRegionsYamlFile(filename: os.PathLike, child_name: str | None = ...) -> dict[str, HPolyhedron]: ...
def MakeIrisObstacles(query_object: pydrake.geometry.QueryObject, reference_frame: pydrake.geometry.FrameId | None = ...) -> list[ConvexSet]: ...
@overload
def PartitionConvexSet(convex_set: ConvexSet, continuous_revolute_joints: list[int], epsilon: float = ...) -> list[ConvexSet]: ...
@overload
def PartitionConvexSet(convex_sets: list[ConvexSet], continuous_revolute_joints: list[int], epsilon: float = ...) -> list[ConvexSet]: ...
def SaveIrisRegionsYamlFile(filename: os.PathLike, regions: dict[str, HPolyhedron], child_name: str | None = ...) -> None: ...
