import flags
import numpy
import os
import pydrake.autodiffutils
import pydrake.common
import pydrake.lcm
import pydrake.math
import pydrake.symbolic
import pydrake.systems.framework
from . import all as all, optimization as optimization
from _typeshed import Incomplete
from pydrake.common.cpp_template import ContactSurface_ as ContactSurface_, DrakeVisualizer_ as DrakeVisualizer_, FramePoseVector_ as FramePoseVector_, GeometryConfigurationVector_ as GeometryConfigurationVector_, MeshcatPointCloudVisualizer_ as MeshcatPointCloudVisualizer_, MeshcatVisualizer_ as MeshcatVisualizer_, PenetrationAsPointPair_ as PenetrationAsPointPair_, Plane_ as Plane_, PolygonSurfaceMeshFieldLinear_ as PolygonSurfaceMeshFieldLinear_, PolygonSurfaceMesh_ as PolygonSurfaceMesh_, QueryObject_ as QueryObject_, SceneGraphInspector_ as SceneGraphInspector_, SceneGraph_ as SceneGraph_, SignedDistancePair_ as SignedDistancePair_, SignedDistanceToPoint_ as SignedDistanceToPoint_, TriangleSurfaceMeshFieldLinear_ as TriangleSurfaceMeshFieldLinear_, TriangleSurfaceMesh_ as TriangleSurfaceMesh_, VolumeMesh_ as VolumeMesh_
from typing import Any, Callable, ClassVar, overload

StartMeshcat: Callable
kHasRenderEngineGl: bool
kHasRenderEngineGltfClient: bool
kHasRenderEngineVtk: bool

class Aabb:
    def __init__(self, p_HoBo: numpy.ndarray[numpy.float64[3, 1]], half_width: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def CalcVolume(self) -> float: ...
    def Equal(self, other: Aabb) -> bool: ...
    @overload
    @staticmethod
    def HasOverlap(a_G: Aabb, b_H: Aabb, X_GH: pydrake.math.RigidTransform) -> bool: ...
    @overload
    @staticmethod
    def HasOverlap(aabb_G: Aabb, obb_H: Obb, X_GH: pydrake.math.RigidTransform) -> bool: ...
    @overload
    @staticmethod
    def HasOverlap(bv_H: Aabb, hs_C: HalfSpace, X_CH: pydrake.math.RigidTransform) -> bool: ...
    @overload
    @staticmethod
    def HasOverlap(bv_H: Aabb, plane_P: Plane, X_PH: pydrake.math.RigidTransform) -> bool: ...
    def center(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def half_width(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def lower(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def pose(self) -> pydrake.math.RigidTransform: ...
    def upper(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def __copy__(self) -> Aabb: ...
    def __deepcopy__(self, arg0: dict) -> Aabb: ...

class Box(Shape):
    def __init__(self, width: float, depth: float, height: float) -> None: ...
    def depth(self) -> float: ...
    def height(self) -> float: ...
    def size(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def width(self) -> float: ...

class Capsule(Shape):
    @overload
    def __init__(self, radius: float, length: float) -> None: ...
    @overload
    def __init__(self, measures: numpy.ndarray[numpy.float64[2, 1]]) -> None: ...
    def length(self) -> float: ...
    def radius(self) -> float: ...

class ClippingRange:
    @overload
    def __init__(self, other: ClippingRange) -> None: ...
    @overload
    def __init__(self, near: float, far: float) -> None: ...
    def far(self) -> float: ...
    def near(self) -> float: ...

class CollisionFilterDeclaration:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, scope: CollisionFilterScope) -> None: ...
    def AllowBetween(self, set_A: GeometrySet, set_B: GeometrySet) -> CollisionFilterDeclaration: ...
    def AllowWithin(self, geometry_set: GeometrySet) -> CollisionFilterDeclaration: ...
    def ExcludeBetween(self, set_A: GeometrySet, set_B: GeometrySet) -> CollisionFilterDeclaration: ...
    def ExcludeWithin(self, geometry_set: GeometrySet) -> CollisionFilterDeclaration: ...

class CollisionFilterManager:
    def __init__(self, *args, **kwargs) -> None: ...
    def Apply(self, declaration: CollisionFilterDeclaration) -> None: ...
    def ApplyTransient(self, declaration: CollisionFilterDeclaration) -> FilterId: ...
    def IsActive(self, filter_id: FilterId) -> bool: ...
    def RemoveDeclaration(self, filter_id: FilterId) -> bool: ...
    def has_transient_history(self) -> bool: ...

class CollisionFilterScope:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kAll: ClassVar[CollisionFilterScope] = ...
    kOmitDeformable: ClassVar[CollisionFilterScope] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class ColorRenderCamera:
    @overload
    def __init__(self, other: ColorRenderCamera) -> None: ...
    @overload
    def __init__(self, core: RenderCameraCore, show_window: bool = ...) -> None: ...
    def core(self) -> RenderCameraCore: ...
    def show_window(self) -> bool: ...
    def __copy__(self) -> ColorRenderCamera: ...
    def __deepcopy__(self, arg0: dict) -> ColorRenderCamera: ...

class ContactSurface:
    def __init__(self, *args, **kwargs) -> None: ...
    def Equal(self, surface: ContactSurface) -> bool: ...
    def EvaluateGradE_M_W(self, index: int) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def EvaluateGradE_N_W(self, index: int) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def HasGradE_M(self) -> bool: ...
    def HasGradE_N(self) -> bool: ...
    def area(self, face_index: int) -> float: ...
    @overload
    def centroid(self, face_index: int) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    @overload
    def centroid(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def face_normal(self, face_index: int) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def id_M(self) -> GeometryId: ...
    def id_N(self) -> GeometryId: ...
    def is_triangle(self) -> bool: ...
    def num_faces(self) -> int: ...
    def num_vertices(self) -> int: ...
    def poly_e_MN(self) -> PolygonSurfaceMeshFieldLinear: ...
    def poly_mesh_W(self) -> PolygonSurfaceMesh: ...
    def representation(self) -> HydroelasticContactRepresentation: ...
    def total_area(self) -> float: ...
    def tri_e_MN(self) -> TriangleSurfaceMeshFieldLinear: ...
    def tri_mesh_W(self) -> TriangleSurfaceMesh: ...
    def __copy__(self) -> ContactSurface: ...
    def __deepcopy__(self, arg0: dict) -> ContactSurface: ...

class ContactSurface_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Equal(self, surface: ContactSurface_TAutoDiffXdU) -> bool: ...
    def EvaluateGradE_M_W(self, index: int) -> numpy.ndarray[object[3, 1]]: ...
    def EvaluateGradE_N_W(self, index: int) -> numpy.ndarray[object[3, 1]]: ...
    def HasGradE_M(self) -> bool: ...
    def HasGradE_N(self) -> bool: ...
    def area(self, face_index: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    @overload
    def centroid(self, face_index: int) -> numpy.ndarray[object[3, 1]]: ...
    @overload
    def centroid(self) -> numpy.ndarray[object[3, 1]]: ...
    def face_normal(self, face_index: int) -> numpy.ndarray[object[3, 1]]: ...
    def id_M(self) -> GeometryId: ...
    def id_N(self) -> GeometryId: ...
    def is_triangle(self) -> bool: ...
    def num_faces(self) -> int: ...
    def num_vertices(self) -> int: ...
    def poly_e_MN(self) -> PolygonSurfaceMeshFieldLinear_TAutoDiffXdcAutoDiffXdU: ...
    def poly_mesh_W(self) -> PolygonSurfaceMesh_TAutoDiffXdU: ...
    def representation(self) -> HydroelasticContactRepresentation: ...
    def total_area(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def tri_e_MN(self) -> TriangleSurfaceMeshFieldLinear_TAutoDiffXdcAutoDiffXdU: ...
    def tri_mesh_W(self) -> TriangleSurfaceMesh_TAutoDiffXdU: ...
    def __copy__(self) -> ContactSurface_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> ContactSurface_TAutoDiffXdU: ...

class Convex(Shape):
    @overload
    def __init__(self, filename: os.PathLike, scale: float = ...) -> None: ...
    @overload
    def __init__(self, filename: os.PathLike, scale3: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    @overload
    def __init__(self, mesh_data: InMemoryMesh, scale: float = ...) -> None: ...
    def GetConvexHull(self) -> PolygonSurfaceMesh: ...
    @overload
    def extension(self) -> str: ...
    @overload
    def extension(self) -> Any: ...
    def scale(self) -> float: ...
    def scale3(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def source(self) -> MeshSource: ...

class Cylinder(Shape):
    @overload
    def __init__(self, radius: float, length: float) -> None: ...
    @overload
    def __init__(self, measures: numpy.ndarray[numpy.float64[2, 1]]) -> None: ...
    def length(self) -> float: ...
    def radius(self) -> float: ...

class DefaultProximityProperties:
    __fields__: ClassVar[tuple] = ...  # read-only
    compliance_type: Incomplete
    dynamic_friction: float | None
    hunt_crossley_dissipation: float | None
    hydroelastic_modulus: float | None
    margin: float | None
    point_stiffness: float | None
    relaxation_time: float | None
    resolution_hint: float | None
    slab_thickness: float | None
    static_friction: float | None
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> DefaultProximityProperties: ...
    def __deepcopy__(self, arg0: dict) -> DefaultProximityProperties: ...

class DepthRange:
    @overload
    def __init__(self, other: DepthRange) -> None: ...
    @overload
    def __init__(self, min_in: float, min_out: float) -> None: ...
    def max_depth(self) -> float: ...
    def min_depth(self) -> float: ...
    def __copy__(self) -> DepthRange: ...
    def __deepcopy__(self, arg0: dict) -> DepthRange: ...

class DepthRenderCamera:
    @overload
    def __init__(self, other: DepthRenderCamera) -> None: ...
    @overload
    def __init__(self, core: RenderCameraCore, depth_range: DepthRange) -> None: ...
    def core(self) -> RenderCameraCore: ...
    def depth_range(self) -> DepthRange: ...
    def __copy__(self) -> DepthRenderCamera: ...
    def __deepcopy__(self, arg0: dict) -> DepthRenderCamera: ...

class DrakeVisualizer(pydrake.systems.framework.LeafSystem):
    def __init__(self, lcm: pydrake.lcm.DrakeLcmInterface = ..., params: DrakeVisualizerParams = ...) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder, scene_graph: SceneGraph, lcm: pydrake.lcm.DrakeLcmInterface = ..., params: DrakeVisualizerParams = ...) -> DrakeVisualizer: ...
    @staticmethod
    def DispatchLoadMessage(scene_graph: SceneGraph, lcm: pydrake.lcm.DrakeLcmInterface, params: DrakeVisualizerParams = ...) -> None: ...
    def query_object_input_port(self) -> pydrake.systems.framework.InputPort: ...

class DrakeVisualizerParams:
    __fields__: ClassVar[tuple] = ...  # read-only
    default_color: Rgba
    publish_period: float
    role: Role
    show_hydroelastic: bool
    use_role_channel_suffix: bool
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> DrakeVisualizerParams: ...
    def __deepcopy__(self, arg0: dict) -> DrakeVisualizerParams: ...

class DrakeVisualizer_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, lcm: pydrake.lcm.DrakeLcmInterface = ..., params: DrakeVisualizerParams = ...) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder_TAutoDiffXdU, scene_graph: SceneGraph_TAutoDiffXdU, lcm: pydrake.lcm.DrakeLcmInterface = ..., params: DrakeVisualizerParams = ...) -> DrakeVisualizer_TAutoDiffXdU: ...
    @staticmethod
    def DispatchLoadMessage(scene_graph: SceneGraph_TAutoDiffXdU, lcm: pydrake.lcm.DrakeLcmInterface, params: DrakeVisualizerParams = ...) -> None: ...
    def query_object_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...

class Ellipsoid(Shape):
    @overload
    def __init__(self, a: float, b: float, c: float) -> None: ...
    @overload
    def __init__(self, measures: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def a(self) -> float: ...
    def b(self) -> float: ...
    def c(self) -> float: ...

class EnvironmentMap:
    __fields__: ClassVar[tuple] = ...  # read-only
    skybox: bool
    texture: NullTexture | EquirectangularMap
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> EnvironmentMap: ...
    def __deepcopy__(self, arg0: dict) -> EnvironmentMap: ...

class EquirectangularMap:
    __fields__: ClassVar[tuple] = ...  # read-only
    path: str
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> EquirectangularMap: ...
    def __deepcopy__(self, arg0: dict) -> EquirectangularMap: ...

class FilterId:
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def get_new_id() -> FilterId: ...
    def get_value(self) -> int: ...
    def is_valid(self) -> bool: ...
    def __eq__(self, arg0: FilterId) -> bool: ...
    def __hash__(self) -> int: ...
    def __lt__(self, arg0: FilterId) -> bool: ...
    def __ne__(self, arg0: FilterId) -> bool: ...

class FrameId:
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def get_new_id() -> FrameId: ...
    def get_value(self) -> int: ...
    def is_valid(self) -> bool: ...
    def __eq__(self, arg0: FrameId) -> bool: ...
    def __hash__(self) -> int: ...
    def __lt__(self, arg0: FrameId) -> bool: ...
    def __ne__(self, arg0: FrameId) -> bool: ...

class FramePoseVector:
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    def has_id(self, id: FrameId) -> bool: ...
    @overload
    def ids(self) -> list[FrameId]: ...
    @overload
    def ids(self) -> Any: ...
    def set_value(self, id: FrameId, value: pydrake.math.RigidTransform) -> None: ...
    def size(self) -> int: ...
    def value(self, id: FrameId) -> pydrake.math.RigidTransform: ...

class FramePoseVector_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    def has_id(self, id: FrameId) -> bool: ...
    @overload
    def ids(self) -> list[FrameId]: ...
    @overload
    def ids(self) -> Any: ...
    def set_value(self, id: FrameId, value: pydrake.math.RigidTransform_TAutoDiffXdU) -> None: ...
    def size(self) -> int: ...
    def value(self, id: FrameId) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...

class FramePoseVector_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    def has_id(self, id: FrameId) -> bool: ...
    @overload
    def ids(self) -> list[FrameId]: ...
    @overload
    def ids(self) -> Any: ...
    def set_value(self, id: FrameId, value: pydrake.math.RigidTransform_TExpressionU) -> None: ...
    def size(self) -> int: ...
    def value(self, id: FrameId) -> pydrake.math.RigidTransform_TExpressionU: ...

class GeometryConfigurationVector:
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    def has_id(self, id: GeometryId) -> bool: ...
    @overload
    def ids(self) -> list[GeometryId]: ...
    @overload
    def ids(self) -> Any: ...
    def set_value(self, id: GeometryId, value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def size(self) -> int: ...
    def value(self, id: GeometryId) -> numpy.ndarray[numpy.float64[m, 1]]: ...

class GeometryConfigurationVector_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    def has_id(self, id: GeometryId) -> bool: ...
    @overload
    def ids(self) -> list[GeometryId]: ...
    @overload
    def ids(self) -> Any: ...
    def set_value(self, id: GeometryId, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def size(self) -> int: ...
    def value(self, id: GeometryId) -> numpy.ndarray[object[m, 1]]: ...

class GeometryConfigurationVector_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    def has_id(self, id: GeometryId) -> bool: ...
    @overload
    def ids(self) -> list[GeometryId]: ...
    @overload
    def ids(self) -> Any: ...
    def set_value(self, id: GeometryId, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def size(self) -> int: ...
    def value(self, id: GeometryId) -> numpy.ndarray[object[m, 1]]: ...

class GeometryFrame:
    def __init__(self, frame_name: str, frame_group_id: int = ...) -> None: ...
    def frame_group(self) -> int: ...
    def id(self) -> FrameId: ...
    def name(self) -> str: ...
    def __copy__(self) -> GeometryFrame: ...
    def __deepcopy__(self, arg0: dict) -> GeometryFrame: ...

class GeometryId:
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def get_new_id() -> GeometryId: ...
    def get_value(self) -> int: ...
    def is_valid(self) -> bool: ...
    def __eq__(self, arg0: GeometryId) -> bool: ...
    def __hash__(self) -> int: ...
    def __lt__(self, arg0: GeometryId) -> bool: ...
    def __ne__(self, arg0: GeometryId) -> bool: ...

class GeometryInstance:
    def __init__(self, X_PG: pydrake.math.RigidTransform, shape: Shape, name: str) -> None: ...
    def id(self) -> GeometryId: ...
    def illustration_properties(self) -> IllustrationProperties: ...
    def mutable_illustration_properties(self) -> IllustrationProperties: ...
    def mutable_perception_properties(self) -> PerceptionProperties: ...
    def mutable_proximity_properties(self) -> ProximityProperties: ...
    def name(self) -> str: ...
    def perception_properties(self) -> PerceptionProperties: ...
    def pose(self) -> pydrake.math.RigidTransform: ...
    def proximity_properties(self) -> ProximityProperties: ...
    def set_illustration_properties(self, properties: IllustrationProperties) -> None: ...
    def set_name(self, arg0: str) -> None: ...
    def set_perception_properties(self, properties: PerceptionProperties) -> None: ...
    def set_pose(self, X_PG: pydrake.math.RigidTransform) -> None: ...
    def set_proximity_properties(self, properties: ProximityProperties) -> None: ...
    def shape(self) -> Shape: ...
    def __copy__(self) -> GeometryInstance: ...
    def __deepcopy__(self, arg0: dict) -> GeometryInstance: ...

class GeometryProperties:
    def __init__(self, *args, **kwargs) -> None: ...
    def AddProperty(self, group_name: str, name: str, value: object) -> None: ...
    def GetGroupNames(self) -> set[str]: ...
    def GetPropertiesInGroup(self, group_name: str) -> dict: ...
    def GetProperty(self, group_name: str, name: str) -> object: ...
    def GetPropertyOrDefault(self, group_name: str, name: str, default_value: object) -> object: ...
    def HasGroup(self, group_name: str) -> bool: ...
    def HasProperty(self, group_name: str, name: str) -> bool: ...
    def RemoveProperty(self, group_name: str, name: str) -> bool: ...
    def UpdateProperty(self, group_name: str, name: str, value: object) -> None: ...
    @staticmethod
    def default_group_name() -> str: ...
    def num_groups(self) -> int: ...

class GeometrySet:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, geometry_id: GeometryId) -> None: ...
    @overload
    def __init__(self, frame_id: FrameId) -> None: ...
    @overload
    def __init__(self, geometry_ids: list[GeometryId]) -> None: ...
    @overload
    def __init__(self, frame_ids: list[FrameId]) -> None: ...
    @overload
    def __init__(self, geometry_ids: list[GeometryId], frame_ids: list[FrameId]) -> None: ...
    @overload
    def Add(self, geometry_id: GeometryId) -> None: ...
    @overload
    def Add(self, frame_id: FrameId) -> None: ...
    @overload
    def Add(self, geometry_ids: list[GeometryId]) -> None: ...
    @overload
    def Add(self, frame_ids: list[FrameId]) -> None: ...
    @overload
    def Add(self, geometry_ids: list[GeometryId], frame_ids: list[FrameId]) -> None: ...

class GeometryVersion:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GeometryVersion) -> None: ...
    def IsSameAs(self, other: GeometryVersion, role: Role) -> bool: ...
    def __copy__(self) -> GeometryVersion: ...
    def __deepcopy__(self, arg0: dict) -> GeometryVersion: ...

class GltfExtension:
    __fields__: ClassVar[tuple] = ...  # read-only
    warn_unimplemented: bool
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> GltfExtension: ...
    def __deepcopy__(self, arg0: dict) -> GltfExtension: ...

class HalfSpace(Shape):
    def __init__(self) -> None: ...
    @staticmethod
    def MakePose(Hz_dir_F: numpy.ndarray[numpy.float64[3, 1]], p_FB: numpy.ndarray[numpy.float64[3, 1]]) -> pydrake.math.RigidTransform: ...

class HydroelasticContactRepresentation:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kPolygon: ClassVar[HydroelasticContactRepresentation] = ...
    kTriangle: ClassVar[HydroelasticContactRepresentation] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class IllustrationProperties(GeometryProperties):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GeometryProperties) -> None: ...
    def __copy__(self) -> IllustrationProperties: ...
    def __deepcopy__(self, arg0: dict) -> IllustrationProperties: ...

class InMemoryMesh:
    mesh_file: pydrake.common.MemoryFile
    supporting_files: dict[str, os.PathLike | pydrake.common.MemoryFile]
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> InMemoryMesh: ...
    def __deepcopy__(self, arg0: dict) -> InMemoryMesh: ...

class LightParameter:
    __fields__: ClassVar[tuple] = ...  # read-only
    attenuation_values: numpy.ndarray[numpy.float64[3, 1]]
    color: Rgba
    cone_angle: float
    direction: numpy.ndarray[numpy.float64[3, 1]]
    frame: str
    intensity: float
    position: numpy.ndarray[numpy.float64[3, 1]]
    type: str
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> LightParameter: ...
    def __deepcopy__(self, arg0: dict) -> LightParameter: ...

class Mesh(Shape):
    @overload
    def __init__(self, filename: os.PathLike, scale: float = ...) -> None: ...
    @overload
    def __init__(self, filename: os.PathLike, scale3: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    @overload
    def __init__(self, mesh_data: InMemoryMesh, scale: float = ...) -> None: ...
    def GetConvexHull(self) -> PolygonSurfaceMesh: ...
    @overload
    def extension(self) -> str: ...
    @overload
    def extension(self) -> Any: ...
    def scale(self) -> float: ...
    def scale3(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def source(self) -> MeshSource: ...

class MeshSource:
    def __init__(self, path: os.PathLike) -> None: ...
    def description(self) -> str: ...
    @overload
    def extension(self) -> str: ...
    @overload
    def extension(self) -> Any: ...
    def in_memory(self) -> InMemoryMesh: ...
    def is_in_memory(self) -> bool: ...
    def is_path(self) -> bool: ...
    def path(self) -> os.PathLike: ...
    def __copy__(self) -> MeshSource: ...
    def __deepcopy__(self, arg0: dict) -> MeshSource: ...

class Meshcat:
    class Gamepad:
        __fields__: ClassVar[tuple] = ...  # read-only
        axes: Incomplete
        button_values: list[float]
        index: int | None
        def __init__(self, **kwargs) -> None: ...
        def __copy__(self) -> Meshcat.Gamepad: ...
        def __deepcopy__(self, arg0: dict) -> Meshcat.Gamepad: ...

    class OrthographicCamera:
        __fields__: ClassVar[tuple] = ...  # read-only
        bottom: float
        far: float
        left: float
        near: float
        right: float
        top: float
        zoom: float
        def __init__(self, **kwargs) -> None: ...
        def __copy__(self) -> Meshcat.OrthographicCamera: ...
        def __deepcopy__(self, arg0: dict) -> Meshcat.OrthographicCamera: ...

    class PerspectiveCamera:
        __fields__: ClassVar[tuple] = ...  # read-only
        aspect: float
        far: float
        fov: float
        near: float
        zoom: float
        def __init__(self, **kwargs) -> None: ...
        def __copy__(self) -> Meshcat.PerspectiveCamera: ...
        def __deepcopy__(self, arg0: dict) -> Meshcat.PerspectiveCamera: ...

    class SideOfFaceToRender:
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        kBackSide: ClassVar[Meshcat.SideOfFaceToRender] = ...
        kDoubleSide: ClassVar[Meshcat.SideOfFaceToRender] = ...
        kFrontSide: ClassVar[Meshcat.SideOfFaceToRender] = ...
        def __init__(self, value: int) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    @overload
    def __init__(self, port: int | None = ...) -> None: ...
    @overload
    def __init__(self, params: MeshcatParams) -> None: ...
    def AddButton(self, name: str, keycode: str = ...) -> None: ...
    def AddSlider(self, name: str, min: float, max: float, step: float, value: float, decrement_keycode: str = ..., increment_keycode: str = ...) -> float: ...
    def Delete(self, path: str = ...) -> None: ...
    def DeleteAddedControls(self) -> None: ...
    def DeleteButton(self, name: str, strict: bool = ...) -> bool: ...
    def DeleteRecording(self) -> None: ...
    def DeleteSlider(self, name: str, strict: bool = ...) -> bool: ...
    def Flush(self) -> None: ...
    def GetButtonClicks(self, name: str) -> int: ...
    def GetButtonNames(self) -> list[str]: ...
    def GetGamepad(self) -> Meshcat.Gamepad: ...
    def GetNumActiveConnections(self) -> int: ...
    def GetRealtimeRate(self) -> float: ...
    def GetSliderNames(self) -> list[str]: ...
    def GetSliderValue(self, name: str) -> float: ...
    def GetTrackedCameraPose(self) -> pydrake.math.RigidTransform | None: ...
    def HasPath(self, path: str) -> bool: ...
    def PlotSurface(self, path: str, X: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], Y: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], Z: numpy.ndarray[numpy.float64[m, n], flags.f_contiguous], rgba: Rgba = ..., wireframe: bool = ..., wireframe_line_width: float = ...) -> None: ...
    def PublishRecording(self) -> None: ...
    def ResetRenderMode(self) -> None: ...
    def Set2dRenderMode(self, X_WC: pydrake.math.RigidTransform = ..., xmin: float = ..., xmax: float = ..., ymin: float = ..., ymax: float = ...) -> None: ...
    @overload
    def SetAnimation(self, animation: MeshcatAnimation) -> None: ...
    @overload
    def SetAnimation(self) -> Any: ...
    @overload
    def SetCamera(self, camera: Meshcat.PerspectiveCamera, path: str = ...) -> None: ...
    @overload
    def SetCamera(self, camera: Meshcat.OrthographicCamera, path: str = ...) -> None: ...
    def SetCameraPose(self, camera_in_world: numpy.ndarray[numpy.float64[3, 1]], target_in_world: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def SetCameraTarget(self, target_in_world: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def SetEnvironmentMap(self, image_path: os.PathLike) -> None: ...
    def SetLine(self, path: str, vertices: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous], line_width: float = ..., rgba: Rgba = ...) -> None: ...
    def SetLineSegments(self, path: str, start: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous], end: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous], line_width: float = ..., rgba: Rgba = ...) -> None: ...
    @overload
    def SetObject(self, path: str, shape: Shape, rgba: Rgba = ...) -> None: ...
    @overload
    def SetObject(self, path: str, cloud, point_size: float = ..., rgba: Rgba = ...) -> None: ...
    @overload
    def SetObject(self, path: str, mesh: TriangleSurfaceMesh, rgba: Rgba = ..., wireframe: bool = ..., wireframe_line_width: float = ..., side: Meshcat.SideOfFaceToRender = ...) -> None: ...
    @overload
    def SetProperty(self, path: str, property: str, value: bool, time_in_recording: float | None = ...) -> None: ...
    @overload
    def SetProperty(self, path: str, property: str, value: float, time_in_recording: float | None = ...) -> None: ...
    @overload
    def SetProperty(self, path: str, property: str, value: list[float], time_in_recording: float | None = ...) -> None: ...
    def SetRealtimeRate(self, rate: float) -> None: ...
    def SetSimulationTime(self, sim_time: float) -> None: ...
    def SetSliderValue(self, name: str, value: float) -> float: ...
    def SetTransform(self, path: str, X_ParentPath: pydrake.math.RigidTransform, time_in_recording: float | None = ...) -> None: ...
    def SetTriangleColorMesh(self, path: str, vertices: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous], faces: numpy.ndarray[numpy.int32[3, n], flags.f_contiguous], colors: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous], wireframe: bool = ..., wireframe_line_width: float = ..., side: Meshcat.SideOfFaceToRender = ...) -> None: ...
    def SetTriangleMesh(self, path: str, vertices: numpy.ndarray[numpy.float64[3, n], flags.f_contiguous], faces: numpy.ndarray[numpy.int32[3, n], flags.f_contiguous], rgba: Rgba = ..., wireframe: bool = ..., wireframe_line_width: float = ..., side: Meshcat.SideOfFaceToRender = ...) -> None: ...
    def StartRecording(self, frames_per_second: float = ..., set_visualizations_while_recording: bool = ...) -> None: ...
    def StaticHtml(self) -> str: ...
    def StaticZip(self) -> bytes: ...
    def StopRecording(self) -> None: ...
    def get_mutable_recording(self) -> MeshcatAnimation: ...
    def port(self) -> int: ...
    def web_url(self) -> str: ...
    def ws_url(self) -> str: ...

class MeshcatAnimation:
    class LoopMode:
        __members__: ClassVar[dict] = ...  # read-only
        __entries: ClassVar[dict] = ...
        kLoopOnce: ClassVar[MeshcatAnimation.LoopMode] = ...
        kLoopPingPong: ClassVar[MeshcatAnimation.LoopMode] = ...
        kLoopRepeat: ClassVar[MeshcatAnimation.LoopMode] = ...
        def __init__(self, value: int) -> None: ...
        def __eq__(self, other: object) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> int: ...
        def __int__(self) -> int: ...
        def __ne__(self, other: object) -> bool: ...
        @property
        def name(self) -> str: ...
        @property
        def value(self) -> int: ...
    def __init__(self, frames_per_second: float = ...) -> None: ...
    @overload
    def SetProperty(self, frame: int, path: str, property: str, value: bool) -> None: ...
    @overload
    def SetProperty(self, frame: int, path: str, property: str, value: float) -> None: ...
    @overload
    def SetProperty(self, frame: int, path: str, property: str, value: list[float]) -> None: ...
    def SetTransform(self, frame: int, path: str, X_ParentPath: pydrake.math.RigidTransform) -> None: ...
    def autoplay(self) -> bool: ...
    def clamp_when_finished(self) -> bool: ...
    def frame(self, time_from_start: float) -> int: ...
    def frames_per_second(self) -> float: ...
    def loop_mode(self) -> MeshcatAnimation.LoopMode: ...
    def repetitions(self) -> int: ...
    def set_autoplay(self, play: bool) -> None: ...
    def set_clamp_when_finished(self, clamp: bool) -> None: ...
    def set_loop_mode(self, mode: MeshcatAnimation.LoopMode) -> None: ...
    def set_repetitions(self, repetitions: int) -> None: ...
    def set_start_time(self, time: float) -> None: ...
    def start_time(self) -> float: ...

class MeshcatCone(Shape):
    @overload
    def __init__(self, height: float, a: float = ..., b: float = ...) -> None: ...
    @overload
    def __init__(self, measures: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def a(self) -> float: ...
    def b(self) -> float: ...
    def height(self) -> float: ...

class MeshcatParams:
    class PropertyTuple:
        __fields__: ClassVar[tuple] = ...  # read-only
        path: str
        property: str
        value: list[float] | str | bool | float
        def __init__(self, **kwargs) -> None: ...
        def __copy__(self) -> MeshcatParams.PropertyTuple: ...
        def __deepcopy__(self, arg0: dict) -> MeshcatParams.PropertyTuple: ...
    __fields__: ClassVar[tuple] = ...  # read-only
    host: str
    initial_properties: list[MeshcatParams.PropertyTuple]
    port: int | None
    realtime_rate_period: float
    show_stats_plot: bool
    web_url_pattern: str
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> MeshcatParams: ...
    def __deepcopy__(self, arg0: dict) -> MeshcatParams: ...

class MeshcatPointCloudVisualizer(pydrake.systems.framework.LeafSystem):
    def __init__(self, meshcat: Meshcat, path: str, publish_period: float = ...) -> None: ...
    @overload
    def Delete(self) -> None: ...
    @overload
    def Delete(self, path) -> Any: ...
    def cloud_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def pose_input_port(self) -> pydrake.systems.framework.InputPort: ...
    def set_default_rgba(self, arg0: Rgba) -> None: ...
    def set_point_size(self, arg0: float) -> None: ...

class MeshcatPointCloudVisualizer_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, meshcat: Meshcat, path: str, publish_period: float = ...) -> None: ...
    @overload
    def Delete(self) -> None: ...
    @overload
    def Delete(self, path) -> Any: ...
    def cloud_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def pose_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def set_default_rgba(self, arg0: Rgba) -> None: ...
    def set_point_size(self, arg0: float) -> None: ...

class MeshcatVisualizer(pydrake.systems.framework.LeafSystem):
    def __init__(self, meshcat: Meshcat, params: MeshcatVisualizerParams = ...) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder, scene_graph: SceneGraph, meshcat: Meshcat, params: MeshcatVisualizerParams = ...) -> MeshcatVisualizer: ...
    @overload
    def Delete(self) -> None: ...
    @overload
    def Delete(self, std) -> Any: ...
    def DeleteRecording(self) -> None: ...
    def PublishRecording(self) -> None: ...
    def StartRecording(self, set_transforms_while_recording: bool = ...) -> MeshcatAnimation: ...
    def StopRecording(self) -> None: ...
    def get_mutable_recording(self) -> MeshcatAnimation: ...
    def query_object_input_port(self) -> pydrake.systems.framework.InputPort: ...

class MeshcatVisualizerParams:
    __fields__: ClassVar[tuple] = ...  # read-only
    default_color: Rgba
    delete_on_initialization_event: bool
    enable_alpha_slider: bool
    include_unspecified_accepting: bool
    initial_alpha_slider_value: float
    prefix: str
    publish_period: float
    role: Role
    show_hydroelastic: bool
    visible_by_default: bool
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> MeshcatVisualizerParams: ...
    def __deepcopy__(self, arg0: dict) -> MeshcatVisualizerParams: ...

class MeshcatVisualizer_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, meshcat: Meshcat, params: MeshcatVisualizerParams = ...) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder_TAutoDiffXdU, scene_graph: SceneGraph_TAutoDiffXdU, meshcat: Meshcat, params: MeshcatVisualizerParams = ...) -> MeshcatVisualizer_TAutoDiffXdU: ...
    @overload
    def Delete(self) -> None: ...
    @overload
    def Delete(self, std) -> Any: ...
    def DeleteRecording(self) -> None: ...
    def PublishRecording(self) -> None: ...
    def StartRecording(self, set_transforms_while_recording: bool = ...) -> MeshcatAnimation: ...
    def StopRecording(self) -> None: ...
    def get_mutable_recording(self) -> MeshcatAnimation: ...
    def query_object_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...

class NullTexture:
    __fields__: ClassVar[tuple] = ...  # read-only
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> NullTexture: ...
    def __deepcopy__(self, arg0: dict) -> NullTexture: ...

class Obb:
    def __init__(self, X_HB: pydrake.math.RigidTransform, half_width: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def CalcVolume(self) -> float: ...
    def Equal(self, other: Obb) -> bool: ...
    @overload
    @staticmethod
    def HasOverlap(a_G: Obb, b_H: Obb, X_GH: pydrake.math.RigidTransform) -> bool: ...
    @overload
    @staticmethod
    def HasOverlap(obb_G: Obb, aabb_H: Aabb, X_GH: pydrake.math.RigidTransform) -> bool: ...
    @overload
    @staticmethod
    def HasOverlap(bv_H: Obb, hs_C: HalfSpace, X_CH: pydrake.math.RigidTransform) -> bool: ...
    @overload
    @staticmethod
    def HasOverlap(bv_H: Obb, plane_P: Plane, X_PH: pydrake.math.RigidTransform) -> bool: ...
    def center(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def half_width(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def pose(self) -> pydrake.math.RigidTransform: ...
    def __copy__(self) -> Obb: ...
    def __deepcopy__(self, arg0: dict) -> Obb: ...

class PenetrationAsPointPair:
    depth: float
    id_A: GeometryId
    id_B: GeometryId
    nhat_BA_W: numpy.ndarray[numpy.float64[3, 1]]
    p_WCa: numpy.ndarray[numpy.float64[3, 1]]
    p_WCb: numpy.ndarray[numpy.float64[3, 1]]
    def __init__(self, **kwargs) -> None: ...

class PenetrationAsPointPair_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    depth: pydrake.autodiffutils.AutoDiffXd
    id_A: GeometryId
    id_B: GeometryId
    nhat_BA_W: numpy.ndarray[object[3, 1]]
    p_WCa: numpy.ndarray[object[3, 1]]
    p_WCb: numpy.ndarray[object[3, 1]]
    def __init__(self, **kwargs) -> None: ...

class PenetrationAsPointPair_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    depth: pydrake.symbolic.Expression
    id_A: GeometryId
    id_B: GeometryId
    nhat_BA_W: numpy.ndarray[object[3, 1]]
    p_WCa: numpy.ndarray[object[3, 1]]
    p_WCb: numpy.ndarray[object[3, 1]]
    def __init__(self, **kwargs) -> None: ...

class PerceptionProperties(GeometryProperties):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GeometryProperties) -> None: ...
    def __copy__(self) -> PerceptionProperties: ...
    def __deepcopy__(self, arg0: dict) -> PerceptionProperties: ...

class Plane:
    def __init__(self, normal: numpy.ndarray[numpy.float64[3, 1]], point_on_plane: numpy.ndarray[numpy.float64[3, 1]], already_normalized: bool = ...) -> None: ...
    def BoxOverlaps(self, half_width: numpy.ndarray[numpy.float64[3, 1]], box_center_in_plane: numpy.ndarray[numpy.float64[3, 1]], box_orientation_in_plane: pydrake.math.RotationMatrix) -> bool: ...
    def CalcHeight(self, point: numpy.ndarray[numpy.float64[3, 1]]) -> float: ...
    def reference_point(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def unit_normal(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def __copy__(self) -> Plane: ...
    def __deepcopy__(self, arg0: dict) -> Plane: ...

class Plane_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, normal: numpy.ndarray[object[3, 1]], point_on_plane: numpy.ndarray[object[3, 1]], already_normalized: bool = ...) -> None: ...
    def BoxOverlaps(self, half_width: numpy.ndarray[numpy.float64[3, 1]], box_center_in_plane: numpy.ndarray[numpy.float64[3, 1]], box_orientation_in_plane: pydrake.math.RotationMatrix) -> bool: ...
    def CalcHeight(self, point: numpy.ndarray[object[3, 1]]) -> pydrake.autodiffutils.AutoDiffXd: ...
    def reference_point(self) -> numpy.ndarray[object[3, 1]]: ...
    def unit_normal(self) -> numpy.ndarray[object[3, 1]]: ...
    def __copy__(self) -> Plane_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> Plane_TAutoDiffXdU: ...

class PolygonSurfaceMesh:
    def __init__(self) -> None: ...
    def CalcBoundingBox(self) -> tuple[numpy.ndarray[numpy.float64[3, 1]], numpy.ndarray[numpy.float64[3, 1]]]: ...
    def Equal(self, mesh: PolygonSurfaceMesh) -> bool: ...
    def area(self, f: int) -> float: ...
    def centroid(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def element(self, e: int) -> SurfacePolygon: ...
    def element_centroid(self, e: int) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def face_data(self) -> list[int]: ...
    def face_normal(self, f: int) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def num_elements(self) -> int: ...
    def num_faces(self) -> int: ...
    def num_vertices(self) -> int: ...
    def total_area(self) -> float: ...
    def vertex(self, v: int) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def __copy__(self) -> PolygonSurfaceMesh: ...
    def __deepcopy__(self, arg0: dict) -> PolygonSurfaceMesh: ...

class PolygonSurfaceMeshFieldLinear:
    def __init__(self, *args, **kwargs) -> None: ...
    def EvaluateAtVertex(self, v: int) -> float: ...
    def EvaluateCartesian(self, e: int, p_MQ: numpy.ndarray[numpy.float64[3, 1]]) -> float: ...
    def EvaluateGradient(self, e: int) -> numpy.ndarray[numpy.float64[3, 1]]: ...

class PolygonSurfaceMeshFieldLinear_𝓣AutoDiffXd𝓬AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def EvaluateAtVertex(self, v: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    def EvaluateCartesian(self, e: int, p_MQ: numpy.ndarray[object[3, 1]]) -> pydrake.autodiffutils.AutoDiffXd: ...
    def EvaluateGradient(self, e: int) -> numpy.ndarray[object[3, 1]]: ...

class PolygonSurfaceMesh_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def CalcBoundingBox(self) -> tuple[numpy.ndarray[object[3, 1]], numpy.ndarray[object[3, 1]]]: ...
    def Equal(self, mesh: PolygonSurfaceMesh_TAutoDiffXdU) -> bool: ...
    def area(self, f: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    def centroid(self) -> numpy.ndarray[object[3, 1]]: ...
    def element(self, e: int) -> SurfacePolygon: ...
    def element_centroid(self, e: int) -> numpy.ndarray[object[3, 1]]: ...
    def face_data(self) -> list[int]: ...
    def face_normal(self, f: int) -> numpy.ndarray[object[3, 1]]: ...
    def num_elements(self) -> int: ...
    def num_faces(self) -> int: ...
    def num_vertices(self) -> int: ...
    def total_area(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def vertex(self, v: int) -> numpy.ndarray[object[3, 1]]: ...
    def __copy__(self) -> PolygonSurfaceMesh_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> PolygonSurfaceMesh_TAutoDiffXdU: ...

class ProximityProperties(GeometryProperties):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GeometryProperties) -> None: ...
    def __copy__(self) -> ProximityProperties: ...
    def __deepcopy__(self, arg0: dict) -> ProximityProperties: ...

class QueryObject:
    def __init__(self) -> None: ...
    def ComputeAabbInWorld(self, geometry_id: GeometryId) -> Aabb | None: ...
    def ComputeContactSurfaces(self, representation: HydroelasticContactRepresentation) -> list[ContactSurface]: ...
    def ComputeContactSurfacesWithFallback(self, representation: HydroelasticContactRepresentation) -> tuple[list[ContactSurface], list[PenetrationAsPointPair]]: ...
    def ComputeObbInWorld(self, geometry_id: GeometryId) -> Obb | None: ...
    def ComputePointPairPenetration(self) -> list[PenetrationAsPointPair]: ...
    def ComputeSignedDistancePairClosestPoints(self, geometry_id_A: GeometryId, geometry_id_B: GeometryId) -> SignedDistancePair: ...
    def ComputeSignedDistancePairwiseClosestPoints(self, max_distance: float = ...) -> list[SignedDistancePair]: ...
    def ComputeSignedDistanceToPoint(self, p_WQ: numpy.ndarray[numpy.float64[3, 1]], threshold: float = ...) -> list[SignedDistanceToPoint]: ...
    def FindCollisionCandidates(self) -> list[tuple[GeometryId]]: ...
    def GetConfigurationsInWorld(self, deformable_geometry_id: GeometryId) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def GetPoseInParent(self, frame_id: FrameId) -> pydrake.math.RigidTransform: ...
    @overload
    def GetPoseInWorld(self, frame_id: FrameId) -> pydrake.math.RigidTransform: ...
    @overload
    def GetPoseInWorld(self, geometry_id: GeometryId) -> pydrake.math.RigidTransform: ...
    def HasCollisions(self) -> bool: ...
    def RenderColorImage(self, *args, **kwargs): ...
    def RenderDepthImage(self, *args, **kwargs): ...
    def RenderLabelImage(self, *args, **kwargs): ...
    def inspector(self) -> SceneGraphInspector: ...

class QueryObject_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def ComputeAabbInWorld(self, geometry_id: GeometryId) -> Aabb | None: ...
    def ComputeContactSurfaces(self, representation: HydroelasticContactRepresentation) -> list[ContactSurface_TAutoDiffXdU]: ...
    def ComputeContactSurfacesWithFallback(self, representation: HydroelasticContactRepresentation) -> tuple[list[ContactSurface_TAutoDiffXdU], list[PenetrationAsPointPair_TAutoDiffXdU]]: ...
    def ComputeObbInWorld(self, geometry_id: GeometryId) -> Obb | None: ...
    def ComputePointPairPenetration(self) -> list[PenetrationAsPointPair_TAutoDiffXdU]: ...
    def ComputeSignedDistancePairClosestPoints(self, geometry_id_A: GeometryId, geometry_id_B: GeometryId) -> SignedDistancePair_TAutoDiffXdU: ...
    def ComputeSignedDistancePairwiseClosestPoints(self, max_distance: float = ...) -> list[SignedDistancePair_TAutoDiffXdU]: ...
    def ComputeSignedDistanceToPoint(self, p_WQ: numpy.ndarray[object[3, 1]], threshold: float = ...) -> list[SignedDistanceToPoint_TAutoDiffXdU]: ...
    def FindCollisionCandidates(self) -> list[tuple[GeometryId]]: ...
    def GetConfigurationsInWorld(self, deformable_geometry_id: GeometryId) -> numpy.ndarray[object[m, 1]]: ...
    def GetPoseInParent(self, frame_id: FrameId) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    @overload
    def GetPoseInWorld(self, frame_id: FrameId) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    @overload
    def GetPoseInWorld(self, geometry_id: GeometryId) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def HasCollisions(self) -> bool: ...
    def RenderColorImage(self, *args, **kwargs): ...
    def RenderDepthImage(self, *args, **kwargs): ...
    def RenderLabelImage(self, *args, **kwargs): ...
    def inspector(self) -> SceneGraphInspector_TAutoDiffXdU: ...

class QueryObject_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def ComputeAabbInWorld(self, geometry_id: GeometryId) -> Aabb | None: ...
    def ComputeObbInWorld(self, geometry_id: GeometryId) -> Obb | None: ...
    def ComputePointPairPenetration(self) -> list[PenetrationAsPointPair_TExpressionU]: ...
    def ComputeSignedDistancePairClosestPoints(self, geometry_id_A: GeometryId, geometry_id_B: GeometryId) -> SignedDistancePair_TExpressionU: ...
    def ComputeSignedDistancePairwiseClosestPoints(self, max_distance: float = ...) -> list[SignedDistancePair_TExpressionU]: ...
    def ComputeSignedDistanceToPoint(self, p_WQ: numpy.ndarray[object[3, 1]], threshold: float = ...) -> list[SignedDistanceToPoint_TExpressionU]: ...
    def FindCollisionCandidates(self) -> list[tuple[GeometryId]]: ...
    def GetConfigurationsInWorld(self, deformable_geometry_id: GeometryId) -> numpy.ndarray[object[m, 1]]: ...
    def GetPoseInParent(self, frame_id: FrameId) -> pydrake.math.RigidTransform_TExpressionU: ...
    @overload
    def GetPoseInWorld(self, frame_id: FrameId) -> pydrake.math.RigidTransform_TExpressionU: ...
    @overload
    def GetPoseInWorld(self, geometry_id: GeometryId) -> pydrake.math.RigidTransform_TExpressionU: ...
    def HasCollisions(self) -> bool: ...
    def RenderColorImage(self, *args, **kwargs): ...
    def RenderDepthImage(self, *args, **kwargs): ...
    def RenderLabelImage(self, *args, **kwargs): ...
    def inspector(self) -> SceneGraphInspector_TExpressionU: ...

class RenderCameraCore:
    @overload
    def __init__(self, other: RenderCameraCore) -> None: ...
    @overload
    def __init__(self, renderer_name: str, intrinsics, clipping: ClippingRange, X_BS: pydrake.math.RigidTransform) -> None: ...
    def clipping(self) -> ClippingRange: ...
    def intrinsics(self, *args, **kwargs): ...
    def renderer_name(self) -> str: ...
    def sensor_pose_in_camera_body(self) -> pydrake.math.RigidTransform: ...
    def __copy__(self) -> RenderCameraCore: ...
    def __deepcopy__(self, arg0: dict) -> RenderCameraCore: ...

class RenderEngine:
    def __init__(self) -> None: ...
    def Clone(self) -> RenderEngine: ...
    def GetParameterYaml(self) -> str: ...
    def GetRenderLabelOrThrow(self, properties: PerceptionProperties) -> RenderLabel: ...
    def RegisterVisual(self, id: GeometryId, shape: Shape, properties: PerceptionProperties, X_WG: pydrake.math.RigidTransform, needs_updates: bool = ...) -> bool: ...
    def RemoveGeometry(self, id: GeometryId) -> bool: ...
    def RenderColorImage(self, camera: ColorRenderCamera, color_image_out) -> None: ...
    def RenderDepthImage(self, camera: DepthRenderCamera, depth_image_out) -> None: ...
    def RenderLabelImage(self, camera: ColorRenderCamera, label_image_out) -> None: ...
    def SetDefaultLightPosition(self, X_DL: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    @overload
    @staticmethod
    def ThrowIfInvalid(intrinsics, image, image_type: str) -> None: ...
    @overload
    @staticmethod
    def ThrowIfInvalid(intrinsics, image, image_type: str) -> None: ...
    @overload
    @staticmethod
    def ThrowIfInvalid(intrinsics, image, image_type: str) -> None: ...
    def UpdateViewpoint(self, X_WR: pydrake.math.RigidTransform) -> None: ...
    def default_render_label(self) -> RenderLabel: ...
    def has_geometry(self, id: GeometryId) -> bool: ...

class RenderEngineGlParams:
    __fields__: ClassVar[tuple] = ...  # read-only
    default_clear_color: Rgba
    default_diffuse: Rgba
    lights: list[LightParameter]
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> RenderEngineGlParams: ...
    def __deepcopy__(self, arg0: dict) -> RenderEngineGlParams: ...

class RenderEngineGltfClientParams:
    __fields__: ClassVar[tuple] = ...  # read-only
    base_url: str
    cleanup: bool
    render_endpoint: str
    verbose: bool
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> RenderEngineGltfClientParams: ...
    def __deepcopy__(self, arg0: dict) -> RenderEngineGltfClientParams: ...

class RenderEngineVtkParams:
    __fields__: ClassVar[tuple] = ...  # read-only
    backend: str
    cast_shadows: bool
    default_clear_color: numpy.ndarray[numpy.float64[3, 1]]
    default_diffuse: numpy.ndarray[numpy.float64[4, 1]] | None
    environment_map: EnvironmentMap | None
    exposure: float | None
    force_to_pbr: bool
    gltf_extensions: dict[str, GltfExtension]
    lights: list[LightParameter]
    shadow_map_size: int
    ssao: SsaoParameter | None
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> RenderEngineVtkParams: ...
    def __deepcopy__(self, arg0: dict) -> RenderEngineVtkParams: ...

class RenderLabel:
    kDoNotRender: ClassVar[RenderLabel] = ...
    kDontCare: ClassVar[RenderLabel] = ...
    kEmpty: ClassVar[RenderLabel] = ...
    kMaxUnreserved: ClassVar[int] = ...
    kUnspecified: ClassVar[RenderLabel] = ...
    def __init__(self, value: int) -> None: ...
    def is_reserved(self) -> bool: ...
    @overload
    def __eq__(self, arg0: RenderLabel) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    @overload
    def __eq__(self, arg0: int) -> bool: ...
    def __int__(self) -> int: ...
    @overload
    def __ne__(self, arg0: RenderLabel) -> bool: ...
    @overload
    def __ne__(self, arg0: int) -> bool: ...
    @overload
    def __ne__(self, arg0: int) -> bool: ...

class Rgba:
    __fields__: ClassVar[tuple] = ...  # read-only
    rgba: numpy.ndarray[numpy.float64[4, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, r: float, g: float, b: float, a: float = ...) -> None: ...
    def a(self) -> float: ...
    def b(self) -> float: ...
    def g(self) -> float: ...
    def r(self) -> float: ...
    def scale_rgb(self, scale: float) -> Rgba: ...
    @overload
    def set(self, r: float, g: float, b: float, a: float = ...) -> None: ...
    @overload
    def set(self, rgba: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def update(self, r: float | None = ..., g: float | None = ..., b: float | None = ..., a: float | None = ...) -> None: ...
    def __copy__(self) -> Rgba: ...
    def __deepcopy__(self, arg0: dict) -> Rgba: ...
    def __eq__(self, arg0: Rgba) -> bool: ...
    def __mul__(self, arg0: Rgba) -> Rgba: ...
    def __ne__(self, arg0: Rgba) -> bool: ...

class Role:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kIllustration: ClassVar[Role] = ...
    kPerception: ClassVar[Role] = ...
    kProximity: ClassVar[Role] = ...
    kUnassigned: ClassVar[Role] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __ge__(self, other: object) -> bool: ...
    def __gt__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __le__(self, other: object) -> bool: ...
    def __lt__(self, other: object) -> bool: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class RoleAssign:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kNew: ClassVar[RoleAssign] = ...
    kReplace: ClassVar[RoleAssign] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class SceneGraph(pydrake.systems.framework.LeafSystem):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, config: SceneGraphConfig) -> None: ...
    def AddRenderer(self, name: str, renderer: RenderEngine) -> None: ...
    @overload
    def AssignRole(self, source_id: SourceId, geometry_id: GeometryId, properties: ProximityProperties, assign: RoleAssign = ...) -> None: ...
    @overload
    def AssignRole(self, context: pydrake.systems.framework.Context, source_id: SourceId, geometry_id: GeometryId, properties: ProximityProperties, assign: RoleAssign = ...) -> None: ...
    @overload
    def AssignRole(self, SourceId, GeometryId, ProximityProperties) -> Any: ...
    @overload
    def ChangeShape(self, source_id: SourceId, geometry_id: GeometryId, shape: Shape, X_FG: pydrake.math.RigidTransform | None = ...) -> None: ...
    @overload
    def ChangeShape(self, context: pydrake.systems.framework.Context, source_id: SourceId, geometry_id: GeometryId, shape: Shape, X_FG: pydrake.math.RigidTransform | None = ...) -> None: ...
    @overload
    def ChangeShape(self) -> Any: ...
    def GetRendererParameterYaml(self, name: str) -> str: ...
    def GetRendererTypeName(self, name: str) -> str: ...
    @overload
    def HasRenderer(self, name: str) -> bool: ...
    @overload
    def HasRenderer(self, context: pydrake.systems.framework.Context, name: str) -> bool: ...
    @overload
    def HasRenderer(self) -> Any: ...
    def RegisterAnchoredGeometry(self, source_id: SourceId, geometry: GeometryInstance) -> GeometryId: ...
    def RegisterDeformableGeometry(self, source_id: SourceId, frame_id: FrameId, geometry: GeometryInstance, resolution_hint: float) -> GeometryId: ...
    @overload
    def RegisterFrame(self, source_id: SourceId, frame: GeometryFrame) -> FrameId: ...
    @overload
    def RegisterFrame(self, source_id: SourceId, parent_id: FrameId, frame: GeometryFrame) -> FrameId: ...
    def RegisterGeometry(self, source_id: SourceId, frame_id: FrameId, geometry: GeometryInstance) -> GeometryId: ...
    def RegisterSource(self, name: str = ...) -> SourceId: ...
    def RemoveGeometry(self, source_id: SourceId, geometry_id: GeometryId) -> None: ...
    def RemoveRenderer(self, name: str) -> None: ...
    @overload
    def RemoveRole(self, source_id: SourceId, frame_id: FrameId, role: Role) -> int: ...
    @overload
    def RemoveRole(self, context: pydrake.systems.framework.Context, source_id: SourceId, frame_id: FrameId, role: Role) -> int: ...
    @overload
    def RemoveRole(self, SourceId, FrameId, Role) -> Any: ...
    def RenameFrame(self, frame_id: FrameId, name: str) -> None: ...
    def RenameGeometry(self, geometry_id: GeometryId, name: str) -> None: ...
    @overload
    def RendererCount(self) -> int: ...
    @overload
    def RendererCount(self, context: pydrake.systems.framework.Context) -> int: ...
    @overload
    def RendererCount(self) -> Any: ...
    @overload
    def collision_filter_manager(self, context: pydrake.systems.framework.Context) -> CollisionFilterManager: ...
    @overload
    def collision_filter_manager(self) -> CollisionFilterManager: ...
    @overload
    def get_config(self) -> SceneGraphConfig: ...
    @overload
    def get_config(self, arg0: pydrake.systems.framework.Context) -> SceneGraphConfig: ...
    def get_query_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_source_configuration_port(self, arg0: SourceId) -> pydrake.systems.framework.InputPort: ...
    def get_source_pose_port(self, arg0: SourceId) -> pydrake.systems.framework.InputPort: ...
    def model_inspector(self) -> SceneGraphInspector: ...
    def set_config(self, config: SceneGraphConfig) -> None: ...
    @staticmethod
    def world_frame_id() -> FrameId: ...

class SceneGraphConfig:
    __fields__: ClassVar[tuple] = ...  # read-only
    default_proximity_properties: DefaultProximityProperties
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> SceneGraphConfig: ...
    def __deepcopy__(self, arg0: dict) -> SceneGraphConfig: ...

class SceneGraphInspector:
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def BelongsToSource(self, frame_id: FrameId, source_id: SourceId) -> bool: ...
    @overload
    def BelongsToSource(self, geometry_id: GeometryId, source_id: SourceId) -> bool: ...
    def CloneGeometryInstance(self, geometry_id: GeometryId) -> GeometryInstance: ...
    def CollisionFiltered(self, geometry_id1: GeometryId, geometry_id2: GeometryId) -> bool: ...
    def FramesForSource(self, source_id: SourceId) -> set[FrameId]: ...
    def GetAllDeformableGeometryIds(self) -> list[GeometryId]: ...
    def GetAllFrameIds(self) -> list[FrameId]: ...
    def GetAllGeometryIds(self, role: Role | None = ...) -> list[GeometryId]: ...
    def GetAllSourceIds(self) -> list[SourceId]: ...
    def GetCollisionCandidates(self) -> set[tuple[GeometryId, GeometryId]]: ...
    def GetConvexHull(self, geometry_id: GeometryId) -> PolygonSurfaceMesh: ...
    def GetFrameGroup(self, frame_id: FrameId) -> int: ...
    def GetFrameId(self, geometry_id: GeometryId) -> FrameId: ...
    def GetGeometries(self, frame_id: FrameId, role: Role | None = ...) -> list[GeometryId]: ...
    def GetGeometryIdByName(self, frame_id: FrameId, role: Role, name: str) -> GeometryId: ...
    def GetGeometryIds(self, geometry_set: GeometrySet, role: Role | None = ...) -> set[GeometryId]: ...
    def GetIllustrationProperties(self, geometry_id: GeometryId) -> IllustrationProperties: ...
    @overload
    def GetName(self, source_id: SourceId) -> str: ...
    @overload
    def GetName(self, frame_id: FrameId) -> str: ...
    @overload
    def GetName(self, geometry_id: GeometryId) -> str: ...
    def GetObbInGeometryFrame(self, geometry_id: GeometryId) -> Obb | None: ...
    @overload
    def GetOwningSourceName(self, frame_id: FrameId) -> str: ...
    @overload
    def GetOwningSourceName(self, geometry_id: GeometryId) -> str: ...
    def GetPerceptionProperties(self, geometry_id: GeometryId) -> PerceptionProperties: ...
    def GetPoseInFrame(self, geometry_id: GeometryId) -> pydrake.math.RigidTransform: ...
    def GetProperties(self, geometry_id: GeometryId, role: Role) -> GeometryProperties: ...
    def GetProximityProperties(self, geometry_id: GeometryId) -> ProximityProperties: ...
    def GetReferenceMesh(self, geometry_id: GeometryId) -> VolumeMesh: ...
    def GetShape(self, geometry_id: GeometryId) -> Shape: ...
    def IsDeformableGeometry(self, geometry_id: GeometryId) -> bool: ...
    def NumAnchoredGeometries(self) -> int: ...
    def NumDeformableGeometriesWithRole(self, role: Role) -> int: ...
    def NumDynamicGeometries(self) -> int: ...
    def NumFramesForSource(self, source_id: SourceId) -> int: ...
    def NumGeometriesForFrame(self, frame_id: FrameId) -> int: ...
    def NumGeometriesForFrameWithRole(self, frame_id: FrameId, role: Role) -> int: ...
    def NumGeometriesWithRole(self, role: Role) -> int: ...
    def SourceIsRegistered(self, source_id: SourceId) -> bool: ...
    def geometry_version(self) -> GeometryVersion: ...
    @overload
    def maybe_get_hydroelastic_mesh(self, geometry_id: GeometryId) -> None | TriangleSurfaceMesh | VolumeMesh: ...
    @overload
    def maybe_get_hydroelastic_mesh(self, id) -> Any: ...
    def num_frames(self) -> int: ...
    def num_geometries(self) -> int: ...
    def num_sources(self) -> int: ...
    def world_frame_id(self) -> FrameId: ...

class SceneGraphInspector_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def BelongsToSource(self, frame_id: FrameId, source_id: SourceId) -> bool: ...
    @overload
    def BelongsToSource(self, geometry_id: GeometryId, source_id: SourceId) -> bool: ...
    def CloneGeometryInstance(self, geometry_id: GeometryId) -> GeometryInstance: ...
    def CollisionFiltered(self, geometry_id1: GeometryId, geometry_id2: GeometryId) -> bool: ...
    def FramesForSource(self, source_id: SourceId) -> set[FrameId]: ...
    def GetAllDeformableGeometryIds(self) -> list[GeometryId]: ...
    def GetAllFrameIds(self) -> list[FrameId]: ...
    def GetAllGeometryIds(self, role: Role | None = ...) -> list[GeometryId]: ...
    def GetAllSourceIds(self) -> list[SourceId]: ...
    def GetCollisionCandidates(self) -> set[tuple[GeometryId, GeometryId]]: ...
    def GetConvexHull(self, geometry_id: GeometryId) -> PolygonSurfaceMesh: ...
    def GetFrameGroup(self, frame_id: FrameId) -> int: ...
    def GetFrameId(self, geometry_id: GeometryId) -> FrameId: ...
    def GetGeometries(self, frame_id: FrameId, role: Role | None = ...) -> list[GeometryId]: ...
    def GetGeometryIdByName(self, frame_id: FrameId, role: Role, name: str) -> GeometryId: ...
    def GetGeometryIds(self, geometry_set: GeometrySet, role: Role | None = ...) -> set[GeometryId]: ...
    def GetIllustrationProperties(self, geometry_id: GeometryId) -> IllustrationProperties: ...
    @overload
    def GetName(self, source_id: SourceId) -> str: ...
    @overload
    def GetName(self, frame_id: FrameId) -> str: ...
    @overload
    def GetName(self, geometry_id: GeometryId) -> str: ...
    def GetObbInGeometryFrame(self, geometry_id: GeometryId) -> Obb | None: ...
    @overload
    def GetOwningSourceName(self, frame_id: FrameId) -> str: ...
    @overload
    def GetOwningSourceName(self, geometry_id: GeometryId) -> str: ...
    def GetPerceptionProperties(self, geometry_id: GeometryId) -> PerceptionProperties: ...
    def GetPoseInFrame(self, geometry_id: GeometryId) -> pydrake.math.RigidTransform: ...
    def GetProperties(self, geometry_id: GeometryId, role: Role) -> GeometryProperties: ...
    def GetProximityProperties(self, geometry_id: GeometryId) -> ProximityProperties: ...
    def GetReferenceMesh(self, geometry_id: GeometryId) -> VolumeMesh: ...
    def GetShape(self, geometry_id: GeometryId) -> Shape: ...
    def IsDeformableGeometry(self, geometry_id: GeometryId) -> bool: ...
    def NumAnchoredGeometries(self) -> int: ...
    def NumDeformableGeometriesWithRole(self, role: Role) -> int: ...
    def NumDynamicGeometries(self) -> int: ...
    def NumFramesForSource(self, source_id: SourceId) -> int: ...
    def NumGeometriesForFrame(self, frame_id: FrameId) -> int: ...
    def NumGeometriesForFrameWithRole(self, frame_id: FrameId, role: Role) -> int: ...
    def NumGeometriesWithRole(self, role: Role) -> int: ...
    def SourceIsRegistered(self, source_id: SourceId) -> bool: ...
    def geometry_version(self) -> GeometryVersion: ...
    @overload
    def maybe_get_hydroelastic_mesh(self, geometry_id: GeometryId) -> None | TriangleSurfaceMesh | VolumeMesh: ...
    @overload
    def maybe_get_hydroelastic_mesh(self, id) -> Any: ...
    def num_frames(self) -> int: ...
    def num_geometries(self) -> int: ...
    def num_sources(self) -> int: ...
    def world_frame_id(self) -> FrameId: ...

class SceneGraphInspector_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def BelongsToSource(self, frame_id: FrameId, source_id: SourceId) -> bool: ...
    @overload
    def BelongsToSource(self, geometry_id: GeometryId, source_id: SourceId) -> bool: ...
    def CloneGeometryInstance(self, geometry_id: GeometryId) -> GeometryInstance: ...
    def CollisionFiltered(self, geometry_id1: GeometryId, geometry_id2: GeometryId) -> bool: ...
    def FramesForSource(self, source_id: SourceId) -> set[FrameId]: ...
    def GetAllDeformableGeometryIds(self) -> list[GeometryId]: ...
    def GetAllFrameIds(self) -> list[FrameId]: ...
    def GetAllGeometryIds(self, role: Role | None = ...) -> list[GeometryId]: ...
    def GetAllSourceIds(self) -> list[SourceId]: ...
    def GetCollisionCandidates(self) -> set[tuple[GeometryId, GeometryId]]: ...
    def GetConvexHull(self, geometry_id: GeometryId) -> PolygonSurfaceMesh: ...
    def GetFrameGroup(self, frame_id: FrameId) -> int: ...
    def GetFrameId(self, geometry_id: GeometryId) -> FrameId: ...
    def GetGeometries(self, frame_id: FrameId, role: Role | None = ...) -> list[GeometryId]: ...
    def GetGeometryIdByName(self, frame_id: FrameId, role: Role, name: str) -> GeometryId: ...
    def GetGeometryIds(self, geometry_set: GeometrySet, role: Role | None = ...) -> set[GeometryId]: ...
    def GetIllustrationProperties(self, geometry_id: GeometryId) -> IllustrationProperties: ...
    @overload
    def GetName(self, source_id: SourceId) -> str: ...
    @overload
    def GetName(self, frame_id: FrameId) -> str: ...
    @overload
    def GetName(self, geometry_id: GeometryId) -> str: ...
    def GetObbInGeometryFrame(self, geometry_id: GeometryId) -> Obb | None: ...
    @overload
    def GetOwningSourceName(self, frame_id: FrameId) -> str: ...
    @overload
    def GetOwningSourceName(self, geometry_id: GeometryId) -> str: ...
    def GetPerceptionProperties(self, geometry_id: GeometryId) -> PerceptionProperties: ...
    def GetPoseInFrame(self, geometry_id: GeometryId) -> pydrake.math.RigidTransform: ...
    def GetProperties(self, geometry_id: GeometryId, role: Role) -> GeometryProperties: ...
    def GetProximityProperties(self, geometry_id: GeometryId) -> ProximityProperties: ...
    def GetReferenceMesh(self, geometry_id: GeometryId) -> VolumeMesh: ...
    def GetShape(self, geometry_id: GeometryId) -> Shape: ...
    def IsDeformableGeometry(self, geometry_id: GeometryId) -> bool: ...
    def NumAnchoredGeometries(self) -> int: ...
    def NumDeformableGeometriesWithRole(self, role: Role) -> int: ...
    def NumDynamicGeometries(self) -> int: ...
    def NumFramesForSource(self, source_id: SourceId) -> int: ...
    def NumGeometriesForFrame(self, frame_id: FrameId) -> int: ...
    def NumGeometriesForFrameWithRole(self, frame_id: FrameId, role: Role) -> int: ...
    def NumGeometriesWithRole(self, role: Role) -> int: ...
    def SourceIsRegistered(self, source_id: SourceId) -> bool: ...
    def geometry_version(self) -> GeometryVersion: ...
    @overload
    def maybe_get_hydroelastic_mesh(self, geometry_id: GeometryId) -> None | TriangleSurfaceMesh | VolumeMesh: ...
    @overload
    def maybe_get_hydroelastic_mesh(self, id) -> Any: ...
    def num_frames(self) -> int: ...
    def num_geometries(self) -> int: ...
    def num_sources(self) -> int: ...
    def world_frame_id(self) -> FrameId: ...

class SceneGraph_𝓣AutoDiffXd𝓤(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, config: SceneGraphConfig) -> None: ...
    def AddRenderer(self, name: str, renderer: RenderEngine) -> None: ...
    @overload
    def AssignRole(self, source_id: SourceId, geometry_id: GeometryId, properties: ProximityProperties, assign: RoleAssign = ...) -> None: ...
    @overload
    def AssignRole(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, source_id: SourceId, geometry_id: GeometryId, properties: ProximityProperties, assign: RoleAssign = ...) -> None: ...
    @overload
    def AssignRole(self, SourceId, GeometryId, ProximityProperties) -> Any: ...
    @overload
    def ChangeShape(self, source_id: SourceId, geometry_id: GeometryId, shape: Shape, X_FG: pydrake.math.RigidTransform | None = ...) -> None: ...
    @overload
    def ChangeShape(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, source_id: SourceId, geometry_id: GeometryId, shape: Shape, X_FG: pydrake.math.RigidTransform | None = ...) -> None: ...
    @overload
    def ChangeShape(self) -> Any: ...
    def GetRendererParameterYaml(self, name: str) -> str: ...
    def GetRendererTypeName(self, name: str) -> str: ...
    @overload
    def HasRenderer(self, name: str) -> bool: ...
    @overload
    def HasRenderer(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, name: str) -> bool: ...
    @overload
    def HasRenderer(self) -> Any: ...
    def RegisterAnchoredGeometry(self, source_id: SourceId, geometry: GeometryInstance) -> GeometryId: ...
    def RegisterDeformableGeometry(self, source_id: SourceId, frame_id: FrameId, geometry: GeometryInstance, resolution_hint: float) -> GeometryId: ...
    @overload
    def RegisterFrame(self, source_id: SourceId, frame: GeometryFrame) -> FrameId: ...
    @overload
    def RegisterFrame(self, source_id: SourceId, parent_id: FrameId, frame: GeometryFrame) -> FrameId: ...
    def RegisterGeometry(self, source_id: SourceId, frame_id: FrameId, geometry: GeometryInstance) -> GeometryId: ...
    def RegisterSource(self, name: str = ...) -> SourceId: ...
    def RemoveGeometry(self, source_id: SourceId, geometry_id: GeometryId) -> None: ...
    def RemoveRenderer(self, name: str) -> None: ...
    @overload
    def RemoveRole(self, source_id: SourceId, frame_id: FrameId, role: Role) -> int: ...
    @overload
    def RemoveRole(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, source_id: SourceId, frame_id: FrameId, role: Role) -> int: ...
    @overload
    def RemoveRole(self, SourceId, FrameId, Role) -> Any: ...
    def RenameFrame(self, frame_id: FrameId, name: str) -> None: ...
    def RenameGeometry(self, geometry_id: GeometryId, name: str) -> None: ...
    @overload
    def RendererCount(self) -> int: ...
    @overload
    def RendererCount(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> int: ...
    @overload
    def RendererCount(self) -> Any: ...
    @overload
    def collision_filter_manager(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> CollisionFilterManager: ...
    @overload
    def collision_filter_manager(self) -> CollisionFilterManager: ...
    @overload
    def get_config(self) -> SceneGraphConfig: ...
    @overload
    def get_config(self, arg0: pydrake.systems.framework.Context_TAutoDiffXdU) -> SceneGraphConfig: ...
    def get_query_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_source_configuration_port(self, arg0: SourceId) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_source_pose_port(self, arg0: SourceId) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def model_inspector(self) -> SceneGraphInspector_TAutoDiffXdU: ...
    def set_config(self, config: SceneGraphConfig) -> None: ...
    @staticmethod
    def world_frame_id() -> FrameId: ...

class SceneGraph_𝓣Expression𝓤(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, config: SceneGraphConfig) -> None: ...
    def AddRenderer(self, name: str, renderer: RenderEngine) -> None: ...
    @overload
    def AssignRole(self, source_id: SourceId, geometry_id: GeometryId, properties: ProximityProperties, assign: RoleAssign = ...) -> None: ...
    @overload
    def AssignRole(self, context: pydrake.systems.framework.Context_TExpressionU, source_id: SourceId, geometry_id: GeometryId, properties: ProximityProperties, assign: RoleAssign = ...) -> None: ...
    @overload
    def AssignRole(self, SourceId, GeometryId, ProximityProperties) -> Any: ...
    @overload
    def ChangeShape(self, source_id: SourceId, geometry_id: GeometryId, shape: Shape, X_FG: pydrake.math.RigidTransform | None = ...) -> None: ...
    @overload
    def ChangeShape(self, context: pydrake.systems.framework.Context_TExpressionU, source_id: SourceId, geometry_id: GeometryId, shape: Shape, X_FG: pydrake.math.RigidTransform | None = ...) -> None: ...
    @overload
    def ChangeShape(self) -> Any: ...
    def GetRendererParameterYaml(self, name: str) -> str: ...
    def GetRendererTypeName(self, name: str) -> str: ...
    @overload
    def HasRenderer(self, name: str) -> bool: ...
    @overload
    def HasRenderer(self, context: pydrake.systems.framework.Context_TExpressionU, name: str) -> bool: ...
    @overload
    def HasRenderer(self) -> Any: ...
    def RegisterAnchoredGeometry(self, source_id: SourceId, geometry: GeometryInstance) -> GeometryId: ...
    def RegisterDeformableGeometry(self, source_id: SourceId, frame_id: FrameId, geometry: GeometryInstance, resolution_hint: float) -> GeometryId: ...
    @overload
    def RegisterFrame(self, source_id: SourceId, frame: GeometryFrame) -> FrameId: ...
    @overload
    def RegisterFrame(self, source_id: SourceId, parent_id: FrameId, frame: GeometryFrame) -> FrameId: ...
    def RegisterGeometry(self, source_id: SourceId, frame_id: FrameId, geometry: GeometryInstance) -> GeometryId: ...
    def RegisterSource(self, name: str = ...) -> SourceId: ...
    def RemoveGeometry(self, source_id: SourceId, geometry_id: GeometryId) -> None: ...
    def RemoveRenderer(self, name: str) -> None: ...
    @overload
    def RemoveRole(self, source_id: SourceId, frame_id: FrameId, role: Role) -> int: ...
    @overload
    def RemoveRole(self, context: pydrake.systems.framework.Context_TExpressionU, source_id: SourceId, frame_id: FrameId, role: Role) -> int: ...
    @overload
    def RemoveRole(self, SourceId, FrameId, Role) -> Any: ...
    def RenameFrame(self, frame_id: FrameId, name: str) -> None: ...
    def RenameGeometry(self, geometry_id: GeometryId, name: str) -> None: ...
    @overload
    def RendererCount(self) -> int: ...
    @overload
    def RendererCount(self, context: pydrake.systems.framework.Context_TExpressionU) -> int: ...
    @overload
    def RendererCount(self) -> Any: ...
    @overload
    def collision_filter_manager(self, context: pydrake.systems.framework.Context_TExpressionU) -> CollisionFilterManager: ...
    @overload
    def collision_filter_manager(self) -> CollisionFilterManager: ...
    @overload
    def get_config(self) -> SceneGraphConfig: ...
    @overload
    def get_config(self, arg0: pydrake.systems.framework.Context_TExpressionU) -> SceneGraphConfig: ...
    def get_query_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_source_configuration_port(self, arg0: SourceId) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_source_pose_port(self, arg0: SourceId) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def model_inspector(self) -> SceneGraphInspector_TExpressionU: ...
    def set_config(self, config: SceneGraphConfig) -> None: ...
    @staticmethod
    def world_frame_id() -> FrameId: ...

class Shape:
    def __init__(self, *args, **kwargs) -> None: ...
    def Clone(self) -> Shape: ...
    def __copy__(self) -> Shape: ...
    def __deepcopy__(self, arg0: dict) -> Shape: ...

class SignedDistancePair:
    distance: float
    id_A: GeometryId
    id_B: GeometryId
    nhat_BA_W: numpy.ndarray[numpy.float64[3, 1]]
    p_ACa: numpy.ndarray[numpy.float64[3, 1]]
    p_BCb: numpy.ndarray[numpy.float64[3, 1]]
    def __init__(self, **kwargs) -> None: ...

class SignedDistancePair_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    distance: pydrake.autodiffutils.AutoDiffXd
    id_A: GeometryId
    id_B: GeometryId
    nhat_BA_W: numpy.ndarray[object[3, 1]]
    p_ACa: numpy.ndarray[object[3, 1]]
    p_BCb: numpy.ndarray[object[3, 1]]
    def __init__(self, **kwargs) -> None: ...

class SignedDistancePair_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    distance: pydrake.symbolic.Expression
    id_A: GeometryId
    id_B: GeometryId
    nhat_BA_W: numpy.ndarray[object[3, 1]]
    p_ACa: numpy.ndarray[object[3, 1]]
    p_BCb: numpy.ndarray[object[3, 1]]
    def __init__(self, **kwargs) -> None: ...

class SignedDistanceToPoint:
    distance: float
    grad_W: numpy.ndarray[numpy.float64[3, 1]]
    id_G: GeometryId
    p_GN: numpy.ndarray[numpy.float64[3, 1]]
    def __init__(self, **kwargs) -> None: ...

class SignedDistanceToPoint_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    distance: pydrake.autodiffutils.AutoDiffXd
    grad_W: numpy.ndarray[object[3, 1]]
    id_G: GeometryId
    p_GN: numpy.ndarray[object[3, 1]]
    def __init__(self, **kwargs) -> None: ...

class SignedDistanceToPoint_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    distance: pydrake.symbolic.Expression
    grad_W: numpy.ndarray[object[3, 1]]
    id_G: GeometryId
    p_GN: numpy.ndarray[object[3, 1]]
    def __init__(self, **kwargs) -> None: ...

class SourceId:
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def get_new_id() -> SourceId: ...
    def get_value(self) -> int: ...
    def is_valid(self) -> bool: ...
    def __eq__(self, arg0: SourceId) -> bool: ...
    def __hash__(self) -> int: ...
    def __lt__(self, arg0: SourceId) -> bool: ...
    def __ne__(self, arg0: SourceId) -> bool: ...

class Sphere(Shape):
    def __init__(self, radius: float) -> None: ...
    def radius(self) -> float: ...

class SsaoParameter:
    __fields__: ClassVar[tuple] = ...  # read-only
    bias: float
    blur: bool
    intensity_scale: float
    intensity_shift: float
    radius: float
    sample_count: int
    def __init__(self, **kwargs) -> None: ...
    def __copy__(self) -> SsaoParameter: ...
    def __deepcopy__(self, arg0: dict) -> SsaoParameter: ...

class SurfacePolygon:
    def __init__(self, *args, **kwargs) -> None: ...
    def num_vertices(self) -> int: ...
    def vertex(self, i: int) -> int: ...

class SurfaceTriangle:
    def __init__(self, v0: int, v1: int, v2: int) -> None: ...
    def num_vertices(self) -> int: ...
    def vertex(self, i: int) -> int: ...
    def __copy__(self) -> SurfaceTriangle: ...
    def __deepcopy__(self, arg0: dict) -> SurfaceTriangle: ...

class TriangleSurfaceMesh:
    def __init__(self, triangles: list[SurfaceTriangle], vertices: list[numpy.ndarray[numpy.float64[3, 1]]]) -> None: ...
    def CalcBarycentric(self, p_MQ: numpy.ndarray[numpy.float64[3, 1]], t: int) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def CalcBoundingBox(self) -> tuple[numpy.ndarray[numpy.float64[3, 1]], numpy.ndarray[numpy.float64[3, 1]]]: ...
    def CalcCartesianFromBarycentric(self, element_index: int, b_Q: numpy.ndarray[numpy.float64[3, 1]]) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def Equal(self, mesh: TriangleSurfaceMesh) -> bool: ...
    def area(self, t: int) -> float: ...
    def centroid(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def element(self, e: int) -> SurfaceTriangle: ...
    def element_centroid(self, t: int) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def face_normal(self, t: int) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def num_elements(self) -> int: ...
    def num_triangles(self) -> int: ...
    def num_vertices(self) -> int: ...
    def total_area(self) -> float: ...
    def triangles(self) -> list[SurfaceTriangle]: ...
    def vertex(self, v: int) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def vertices(self) -> list[numpy.ndarray[numpy.float64[3, 1]]]: ...

class TriangleSurfaceMeshFieldLinear:
    def __init__(self, *args, **kwargs) -> None: ...
    def Evaluate(self, e: int, b: numpy.ndarray[numpy.float64[3, 1]]) -> float: ...
    def EvaluateAtVertex(self, v: int) -> float: ...
    def EvaluateCartesian(self, e: int, p_MQ: numpy.ndarray[numpy.float64[3, 1]]) -> float: ...

class TriangleSurfaceMeshFieldLinear_𝓣AutoDiffXd𝓬AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Evaluate(self, e: int, b: numpy.ndarray[object[3, 1]]) -> pydrake.autodiffutils.AutoDiffXd: ...
    def EvaluateAtVertex(self, v: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    def EvaluateCartesian(self, e: int, p_MQ: numpy.ndarray[object[3, 1]]) -> pydrake.autodiffutils.AutoDiffXd: ...

class TriangleSurfaceMesh_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, triangles: list[SurfaceTriangle], vertices: list[numpy.ndarray[object[3, 1]]]) -> None: ...
    def CalcBarycentric(self, p_MQ: numpy.ndarray[object[3, 1]], t: int) -> numpy.ndarray[object[3, 1]]: ...
    def CalcBoundingBox(self) -> tuple[numpy.ndarray[object[3, 1]], numpy.ndarray[object[3, 1]]]: ...
    def CalcCartesianFromBarycentric(self, element_index: int, b_Q: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def Equal(self, mesh: TriangleSurfaceMesh_TAutoDiffXdU) -> bool: ...
    def area(self, t: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    def centroid(self) -> numpy.ndarray[object[3, 1]]: ...
    def element(self, e: int) -> SurfaceTriangle: ...
    def element_centroid(self, t: int) -> numpy.ndarray[object[3, 1]]: ...
    def face_normal(self, t: int) -> numpy.ndarray[object[3, 1]]: ...
    def num_elements(self) -> int: ...
    def num_triangles(self) -> int: ...
    def num_vertices(self) -> int: ...
    def total_area(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def triangles(self) -> list[SurfaceTriangle]: ...
    def vertex(self, v: int) -> numpy.ndarray[object[3, 1]]: ...
    def vertices(self) -> list[numpy.ndarray[object[3, 1]]]: ...

class VolumeElement:
    def __init__(self, v0: int, v1: int, v2: int, v3: int) -> None: ...
    def num_vertices(self) -> int: ...
    def vertex(self, i: int) -> int: ...
    def __copy__(self) -> VolumeElement: ...
    def __deepcopy__(self, arg0: dict) -> VolumeElement: ...

class VolumeMesh:
    def __init__(self, elements: list[VolumeElement], vertices: list[numpy.ndarray[numpy.float64[3, 1]]]) -> None: ...
    def CalcBarycentric(self, p_MQ: numpy.ndarray[numpy.float64[3, 1]], e: int) -> numpy.ndarray[numpy.float64[4, 1]]: ...
    def CalcTetrahedronVolume(self, e: int) -> float: ...
    def CalcVolume(self) -> float: ...
    def Equal(self, mesh: VolumeMesh, vertex_tolerance: float = ...) -> bool: ...
    def edge_vector(self, e: int, a: int, b: int) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def element(self, e: int) -> VolumeElement: ...
    def inward_normal(self, e: int, f: int) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def num_elements(self) -> int: ...
    def num_vertices(self) -> int: ...
    def tetrahedra(self) -> list[VolumeElement]: ...
    def vertex(self, v: int) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def vertices(self) -> list[numpy.ndarray[numpy.float64[3, 1]]]: ...

class VolumeMesh_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, elements: list[VolumeElement], vertices: list[numpy.ndarray[object[3, 1]]]) -> None: ...
    def CalcBarycentric(self, p_MQ: numpy.ndarray[object[3, 1]], e: int) -> numpy.ndarray[object[4, 1]]: ...
    def CalcTetrahedronVolume(self, e: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    def CalcVolume(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def Equal(self, mesh: VolumeMesh_TAutoDiffXdU, vertex_tolerance: float = ...) -> bool: ...
    def edge_vector(self, e: int, a: int, b: int) -> numpy.ndarray[object[3, 1]]: ...
    def element(self, e: int) -> VolumeElement: ...
    def inward_normal(self, e: int, f: int) -> numpy.ndarray[object[3, 1]]: ...
    def num_elements(self) -> int: ...
    def num_vertices(self) -> int: ...
    def tetrahedra(self) -> list[VolumeElement]: ...
    def vertex(self, v: int) -> numpy.ndarray[object[3, 1]]: ...
    def vertices(self) -> list[numpy.ndarray[object[3, 1]]]: ...

class _TemporaryName_N5drake8geometry10SceneGraphIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, config: SceneGraphConfig) -> None: ...
    def AddRenderer(self, name: str, renderer: RenderEngine) -> None: ...
    @overload
    def AssignRole(self, source_id: SourceId, geometry_id: GeometryId, properties: ProximityProperties, assign: RoleAssign = ...) -> None: ...
    @overload
    def AssignRole(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, source_id: SourceId, geometry_id: GeometryId, properties: ProximityProperties, assign: RoleAssign = ...) -> None: ...
    @overload
    def AssignRole(self, SourceId, GeometryId, ProximityProperties) -> Any: ...
    @overload
    def ChangeShape(self, source_id: SourceId, geometry_id: GeometryId, shape: Shape, X_FG: pydrake.math.RigidTransform | None = ...) -> None: ...
    @overload
    def ChangeShape(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, source_id: SourceId, geometry_id: GeometryId, shape: Shape, X_FG: pydrake.math.RigidTransform | None = ...) -> None: ...
    @overload
    def ChangeShape(self) -> Any: ...
    def GetRendererParameterYaml(self, name: str) -> str: ...
    def GetRendererTypeName(self, name: str) -> str: ...
    @overload
    def HasRenderer(self, name: str) -> bool: ...
    @overload
    def HasRenderer(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, name: str) -> bool: ...
    @overload
    def HasRenderer(self) -> Any: ...
    def RegisterAnchoredGeometry(self, source_id: SourceId, geometry: GeometryInstance) -> GeometryId: ...
    def RegisterDeformableGeometry(self, source_id: SourceId, frame_id: FrameId, geometry: GeometryInstance, resolution_hint: float) -> GeometryId: ...
    @overload
    def RegisterFrame(self, source_id: SourceId, frame: GeometryFrame) -> FrameId: ...
    @overload
    def RegisterFrame(self, source_id: SourceId, parent_id: FrameId, frame: GeometryFrame) -> FrameId: ...
    def RegisterGeometry(self, source_id: SourceId, frame_id: FrameId, geometry: GeometryInstance) -> GeometryId: ...
    def RegisterSource(self, name: str = ...) -> SourceId: ...
    def RemoveGeometry(self, source_id: SourceId, geometry_id: GeometryId) -> None: ...
    def RemoveRenderer(self, name: str) -> None: ...
    @overload
    def RemoveRole(self, source_id: SourceId, frame_id: FrameId, role: Role) -> int: ...
    @overload
    def RemoveRole(self, context: pydrake.systems.framework.Context_TAutoDiffXdU, source_id: SourceId, frame_id: FrameId, role: Role) -> int: ...
    @overload
    def RemoveRole(self, SourceId, FrameId, Role) -> Any: ...
    def RenameFrame(self, frame_id: FrameId, name: str) -> None: ...
    def RenameGeometry(self, geometry_id: GeometryId, name: str) -> None: ...
    @overload
    def RendererCount(self) -> int: ...
    @overload
    def RendererCount(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> int: ...
    @overload
    def RendererCount(self) -> Any: ...
    @overload
    def collision_filter_manager(self, context: pydrake.systems.framework.Context_TAutoDiffXdU) -> CollisionFilterManager: ...
    @overload
    def collision_filter_manager(self) -> CollisionFilterManager: ...
    @overload
    def get_config(self) -> SceneGraphConfig: ...
    @overload
    def get_config(self, arg0: pydrake.systems.framework.Context_TAutoDiffXdU) -> SceneGraphConfig: ...
    def get_query_output_port(self) -> pydrake.systems.framework.OutputPort_TAutoDiffXdU: ...
    def get_source_configuration_port(self, arg0: SourceId) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def get_source_pose_port(self, arg0: SourceId) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def model_inspector(self) -> SceneGraphInspector_TAutoDiffXdU: ...
    def set_config(self, config: SceneGraphConfig) -> None: ...
    @staticmethod
    def world_frame_id() -> FrameId: ...

class _TemporaryName_N5drake8geometry10SceneGraphINS_8symbolic10ExpressionEEE(pydrake.systems.framework.LeafSystem_TExpressionU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, config: SceneGraphConfig) -> None: ...
    def AddRenderer(self, name: str, renderer: RenderEngine) -> None: ...
    @overload
    def AssignRole(self, source_id: SourceId, geometry_id: GeometryId, properties: ProximityProperties, assign: RoleAssign = ...) -> None: ...
    @overload
    def AssignRole(self, context: pydrake.systems.framework.Context_TExpressionU, source_id: SourceId, geometry_id: GeometryId, properties: ProximityProperties, assign: RoleAssign = ...) -> None: ...
    @overload
    def AssignRole(self, SourceId, GeometryId, ProximityProperties) -> Any: ...
    @overload
    def ChangeShape(self, source_id: SourceId, geometry_id: GeometryId, shape: Shape, X_FG: pydrake.math.RigidTransform | None = ...) -> None: ...
    @overload
    def ChangeShape(self, context: pydrake.systems.framework.Context_TExpressionU, source_id: SourceId, geometry_id: GeometryId, shape: Shape, X_FG: pydrake.math.RigidTransform | None = ...) -> None: ...
    @overload
    def ChangeShape(self) -> Any: ...
    def GetRendererParameterYaml(self, name: str) -> str: ...
    def GetRendererTypeName(self, name: str) -> str: ...
    @overload
    def HasRenderer(self, name: str) -> bool: ...
    @overload
    def HasRenderer(self, context: pydrake.systems.framework.Context_TExpressionU, name: str) -> bool: ...
    @overload
    def HasRenderer(self) -> Any: ...
    def RegisterAnchoredGeometry(self, source_id: SourceId, geometry: GeometryInstance) -> GeometryId: ...
    def RegisterDeformableGeometry(self, source_id: SourceId, frame_id: FrameId, geometry: GeometryInstance, resolution_hint: float) -> GeometryId: ...
    @overload
    def RegisterFrame(self, source_id: SourceId, frame: GeometryFrame) -> FrameId: ...
    @overload
    def RegisterFrame(self, source_id: SourceId, parent_id: FrameId, frame: GeometryFrame) -> FrameId: ...
    def RegisterGeometry(self, source_id: SourceId, frame_id: FrameId, geometry: GeometryInstance) -> GeometryId: ...
    def RegisterSource(self, name: str = ...) -> SourceId: ...
    def RemoveGeometry(self, source_id: SourceId, geometry_id: GeometryId) -> None: ...
    def RemoveRenderer(self, name: str) -> None: ...
    @overload
    def RemoveRole(self, source_id: SourceId, frame_id: FrameId, role: Role) -> int: ...
    @overload
    def RemoveRole(self, context: pydrake.systems.framework.Context_TExpressionU, source_id: SourceId, frame_id: FrameId, role: Role) -> int: ...
    @overload
    def RemoveRole(self, SourceId, FrameId, Role) -> Any: ...
    def RenameFrame(self, frame_id: FrameId, name: str) -> None: ...
    def RenameGeometry(self, geometry_id: GeometryId, name: str) -> None: ...
    @overload
    def RendererCount(self) -> int: ...
    @overload
    def RendererCount(self, context: pydrake.systems.framework.Context_TExpressionU) -> int: ...
    @overload
    def RendererCount(self) -> Any: ...
    @overload
    def collision_filter_manager(self, context: pydrake.systems.framework.Context_TExpressionU) -> CollisionFilterManager: ...
    @overload
    def collision_filter_manager(self) -> CollisionFilterManager: ...
    @overload
    def get_config(self) -> SceneGraphConfig: ...
    @overload
    def get_config(self, arg0: pydrake.systems.framework.Context_TExpressionU) -> SceneGraphConfig: ...
    def get_query_output_port(self) -> pydrake.systems.framework.OutputPort_TExpressionU: ...
    def get_source_configuration_port(self, arg0: SourceId) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def get_source_pose_port(self, arg0: SourceId) -> pydrake.systems.framework.InputPort_TExpressionU: ...
    def model_inspector(self) -> SceneGraphInspector_TExpressionU: ...
    def set_config(self, config: SceneGraphConfig) -> None: ...
    @staticmethod
    def world_frame_id() -> FrameId: ...

class _TemporaryName_N5drake8geometry10VolumeMeshIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, elements: list[VolumeElement], vertices: list[numpy.ndarray[object[3, 1]]]) -> None: ...
    def CalcBarycentric(self, p_MQ: numpy.ndarray[object[3, 1]], e: int) -> numpy.ndarray[object[4, 1]]: ...
    def CalcTetrahedronVolume(self, e: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    def CalcVolume(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def Equal(self, mesh: VolumeMesh_TAutoDiffXdU, vertex_tolerance: float = ...) -> bool: ...
    def edge_vector(self, e: int, a: int, b: int) -> numpy.ndarray[object[3, 1]]: ...
    def element(self, e: int) -> VolumeElement: ...
    def inward_normal(self, e: int, f: int) -> numpy.ndarray[object[3, 1]]: ...
    def num_elements(self) -> int: ...
    def num_vertices(self) -> int: ...
    def tetrahedra(self) -> list[VolumeElement]: ...
    def vertex(self, v: int) -> numpy.ndarray[object[3, 1]]: ...
    def vertices(self) -> list[numpy.ndarray[object[3, 1]]]: ...

class _TemporaryName_N5drake8geometry11QueryObjectIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def ComputeAabbInWorld(self, geometry_id: GeometryId) -> Aabb | None: ...
    def ComputeContactSurfaces(self, representation: HydroelasticContactRepresentation) -> list[ContactSurface_TAutoDiffXdU]: ...
    def ComputeContactSurfacesWithFallback(self, representation: HydroelasticContactRepresentation) -> tuple[list[ContactSurface_TAutoDiffXdU], list[PenetrationAsPointPair_TAutoDiffXdU]]: ...
    def ComputeObbInWorld(self, geometry_id: GeometryId) -> Obb | None: ...
    def ComputePointPairPenetration(self) -> list[PenetrationAsPointPair_TAutoDiffXdU]: ...
    def ComputeSignedDistancePairClosestPoints(self, geometry_id_A: GeometryId, geometry_id_B: GeometryId) -> SignedDistancePair_TAutoDiffXdU: ...
    def ComputeSignedDistancePairwiseClosestPoints(self, max_distance: float = ...) -> list[SignedDistancePair_TAutoDiffXdU]: ...
    def ComputeSignedDistanceToPoint(self, p_WQ: numpy.ndarray[object[3, 1]], threshold: float = ...) -> list[SignedDistanceToPoint_TAutoDiffXdU]: ...
    def FindCollisionCandidates(self) -> list[tuple[GeometryId]]: ...
    def GetConfigurationsInWorld(self, deformable_geometry_id: GeometryId) -> numpy.ndarray[object[m, 1]]: ...
    def GetPoseInParent(self, frame_id: FrameId) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    @overload
    def GetPoseInWorld(self, frame_id: FrameId) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    @overload
    def GetPoseInWorld(self, geometry_id: GeometryId) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...
    def HasCollisions(self) -> bool: ...
    def RenderColorImage(self, *args, **kwargs): ...
    def RenderDepthImage(self, *args, **kwargs): ...
    def RenderLabelImage(self, *args, **kwargs): ...
    def inspector(self) -> SceneGraphInspector_TAutoDiffXdU: ...

class _TemporaryName_N5drake8geometry11QueryObjectINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def ComputeAabbInWorld(self, geometry_id: GeometryId) -> Aabb | None: ...
    def ComputeObbInWorld(self, geometry_id: GeometryId) -> Obb | None: ...
    def ComputePointPairPenetration(self) -> list[PenetrationAsPointPair_TExpressionU]: ...
    def ComputeSignedDistancePairClosestPoints(self, geometry_id_A: GeometryId, geometry_id_B: GeometryId) -> SignedDistancePair_TExpressionU: ...
    def ComputeSignedDistancePairwiseClosestPoints(self, max_distance: float = ...) -> list[SignedDistancePair_TExpressionU]: ...
    def ComputeSignedDistanceToPoint(self, p_WQ: numpy.ndarray[object[3, 1]], threshold: float = ...) -> list[SignedDistanceToPoint_TExpressionU]: ...
    def FindCollisionCandidates(self) -> list[tuple[GeometryId]]: ...
    def GetConfigurationsInWorld(self, deformable_geometry_id: GeometryId) -> numpy.ndarray[object[m, 1]]: ...
    def GetPoseInParent(self, frame_id: FrameId) -> pydrake.math.RigidTransform_TExpressionU: ...
    @overload
    def GetPoseInWorld(self, frame_id: FrameId) -> pydrake.math.RigidTransform_TExpressionU: ...
    @overload
    def GetPoseInWorld(self, geometry_id: GeometryId) -> pydrake.math.RigidTransform_TExpressionU: ...
    def HasCollisions(self) -> bool: ...
    def RenderColorImage(self, *args, **kwargs): ...
    def RenderDepthImage(self, *args, **kwargs): ...
    def RenderLabelImage(self, *args, **kwargs): ...
    def inspector(self) -> SceneGraphInspector_TExpressionU: ...

class _TemporaryName_N5drake8geometry14ContactSurfaceIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Equal(self, surface: ContactSurface_TAutoDiffXdU) -> bool: ...
    def EvaluateGradE_M_W(self, index: int) -> numpy.ndarray[object[3, 1]]: ...
    def EvaluateGradE_N_W(self, index: int) -> numpy.ndarray[object[3, 1]]: ...
    def HasGradE_M(self) -> bool: ...
    def HasGradE_N(self) -> bool: ...
    def area(self, face_index: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    @overload
    def centroid(self, face_index: int) -> numpy.ndarray[object[3, 1]]: ...
    @overload
    def centroid(self) -> numpy.ndarray[object[3, 1]]: ...
    def face_normal(self, face_index: int) -> numpy.ndarray[object[3, 1]]: ...
    def id_M(self) -> GeometryId: ...
    def id_N(self) -> GeometryId: ...
    def is_triangle(self) -> bool: ...
    def num_faces(self) -> int: ...
    def num_vertices(self) -> int: ...
    def poly_e_MN(self) -> PolygonSurfaceMeshFieldLinear_TAutoDiffXdcAutoDiffXdU: ...
    def poly_mesh_W(self) -> PolygonSurfaceMesh_TAutoDiffXdU: ...
    def representation(self) -> HydroelasticContactRepresentation: ...
    def total_area(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def tri_e_MN(self) -> TriangleSurfaceMeshFieldLinear_TAutoDiffXdcAutoDiffXdU: ...
    def tri_mesh_W(self) -> TriangleSurfaceMesh_TAutoDiffXdU: ...
    def __copy__(self) -> ContactSurface_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> ContactSurface_TAutoDiffXdU: ...

class _TemporaryName_N5drake8geometry15DrakeVisualizerIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, lcm: pydrake.lcm.DrakeLcmInterface = ..., params: DrakeVisualizerParams = ...) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder_TAutoDiffXdU, scene_graph: SceneGraph_TAutoDiffXdU, lcm: pydrake.lcm.DrakeLcmInterface = ..., params: DrakeVisualizerParams = ...) -> DrakeVisualizer_TAutoDiffXdU: ...
    @staticmethod
    def DispatchLoadMessage(scene_graph: SceneGraph_TAutoDiffXdU, lcm: pydrake.lcm.DrakeLcmInterface, params: DrakeVisualizerParams = ...) -> None: ...
    def query_object_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...

class _TemporaryName_N5drake8geometry15MeshFieldLinearIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEENS0_18PolygonSurfaceMeshIS6_EEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def EvaluateAtVertex(self, v: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    def EvaluateCartesian(self, e: int, p_MQ: numpy.ndarray[object[3, 1]]) -> pydrake.autodiffutils.AutoDiffXd: ...
    def EvaluateGradient(self, e: int) -> numpy.ndarray[object[3, 1]]: ...

class _TemporaryName_N5drake8geometry15MeshFieldLinearIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEENS0_19TriangleSurfaceMeshIS6_EEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    def Evaluate(self, e: int, b: numpy.ndarray[object[3, 1]]) -> pydrake.autodiffutils.AutoDiffXd: ...
    def EvaluateAtVertex(self, v: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    def EvaluateCartesian(self, e: int, p_MQ: numpy.ndarray[object[3, 1]]) -> pydrake.autodiffutils.AutoDiffXd: ...

class _TemporaryName_N5drake8geometry16KinematicsVectorINS0_10GeometryIdEN5Eigen6MatrixINS3_14AutoDiffScalarINS4_IdLin1ELi1ELi0ELin1ELi1EEEEELin1ELi1ELi0ELin1ELi1EEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    def has_id(self, id: GeometryId) -> bool: ...
    @overload
    def ids(self) -> list[GeometryId]: ...
    @overload
    def ids(self) -> Any: ...
    def set_value(self, id: GeometryId, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def size(self) -> int: ...
    def value(self, id: GeometryId) -> numpy.ndarray[object[m, 1]]: ...

class _TemporaryName_N5drake8geometry16KinematicsVectorINS0_10GeometryIdEN5Eigen6MatrixINS_8symbolic10ExpressionELin1ELi1ELi0ELin1ELi1EEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    def has_id(self, id: GeometryId) -> bool: ...
    @overload
    def ids(self) -> list[GeometryId]: ...
    @overload
    def ids(self) -> Any: ...
    def set_value(self, id: GeometryId, value: numpy.ndarray[object[m, 1]]) -> None: ...
    def size(self) -> int: ...
    def value(self, id: GeometryId) -> numpy.ndarray[object[m, 1]]: ...

class _TemporaryName_N5drake8geometry16KinematicsVectorINS_10IdentifierINS0_8FrameTagEEENS_4math14RigidTransformIN5Eigen14AutoDiffScalarINS7_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    def has_id(self, id: FrameId) -> bool: ...
    @overload
    def ids(self) -> list[FrameId]: ...
    @overload
    def ids(self) -> Any: ...
    def set_value(self, id: FrameId, value: pydrake.math.RigidTransform_TAutoDiffXdU) -> None: ...
    def size(self) -> int: ...
    def value(self, id: FrameId) -> pydrake.math.RigidTransform_TAutoDiffXdU: ...

class _TemporaryName_N5drake8geometry16KinematicsVectorINS_10IdentifierINS0_8FrameTagEEENS_4math14RigidTransformINS_8symbolic10ExpressionEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def clear(self) -> None: ...
    def has_id(self, id: FrameId) -> bool: ...
    @overload
    def ids(self) -> list[FrameId]: ...
    @overload
    def ids(self) -> Any: ...
    def set_value(self, id: FrameId, value: pydrake.math.RigidTransform_TExpressionU) -> None: ...
    def size(self) -> int: ...
    def value(self, id: FrameId) -> pydrake.math.RigidTransform_TExpressionU: ...

class _TemporaryName_N5drake8geometry17MeshcatVisualizerIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, meshcat: Meshcat, params: MeshcatVisualizerParams = ...) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder_TAutoDiffXdU, scene_graph: SceneGraph_TAutoDiffXdU, meshcat: Meshcat, params: MeshcatVisualizerParams = ...) -> MeshcatVisualizer_TAutoDiffXdU: ...
    @overload
    def Delete(self) -> None: ...
    @overload
    def Delete(self, std) -> Any: ...
    def DeleteRecording(self) -> None: ...
    def PublishRecording(self) -> None: ...
    def StartRecording(self, set_transforms_while_recording: bool = ...) -> MeshcatAnimation: ...
    def StopRecording(self) -> None: ...
    def get_mutable_recording(self) -> MeshcatAnimation: ...
    def query_object_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...

class _TemporaryName_N5drake8geometry18PolygonSurfaceMeshIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self) -> None: ...
    def CalcBoundingBox(self) -> tuple[numpy.ndarray[object[3, 1]], numpy.ndarray[object[3, 1]]]: ...
    def Equal(self, mesh: PolygonSurfaceMesh_TAutoDiffXdU) -> bool: ...
    def area(self, f: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    def centroid(self) -> numpy.ndarray[object[3, 1]]: ...
    def element(self, e: int) -> SurfacePolygon: ...
    def element_centroid(self, e: int) -> numpy.ndarray[object[3, 1]]: ...
    def face_data(self) -> list[int]: ...
    def face_normal(self, f: int) -> numpy.ndarray[object[3, 1]]: ...
    def num_elements(self) -> int: ...
    def num_faces(self) -> int: ...
    def num_vertices(self) -> int: ...
    def total_area(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def vertex(self, v: int) -> numpy.ndarray[object[3, 1]]: ...
    def __copy__(self) -> PolygonSurfaceMesh_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> PolygonSurfaceMesh_TAutoDiffXdU: ...

class _TemporaryName_N5drake8geometry18SignedDistancePairIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    distance: pydrake.autodiffutils.AutoDiffXd
    id_A: GeometryId
    id_B: GeometryId
    nhat_BA_W: numpy.ndarray[object[3, 1]]
    p_ACa: numpy.ndarray[object[3, 1]]
    p_BCb: numpy.ndarray[object[3, 1]]
    def __init__(self, **kwargs) -> None: ...

class _TemporaryName_N5drake8geometry18SignedDistancePairINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    distance: pydrake.symbolic.Expression
    id_A: GeometryId
    id_B: GeometryId
    nhat_BA_W: numpy.ndarray[object[3, 1]]
    p_ACa: numpy.ndarray[object[3, 1]]
    p_BCb: numpy.ndarray[object[3, 1]]
    def __init__(self, **kwargs) -> None: ...

class _TemporaryName_N5drake8geometry19SceneGraphInspectorIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def BelongsToSource(self, frame_id: FrameId, source_id: SourceId) -> bool: ...
    @overload
    def BelongsToSource(self, geometry_id: GeometryId, source_id: SourceId) -> bool: ...
    def CloneGeometryInstance(self, geometry_id: GeometryId) -> GeometryInstance: ...
    def CollisionFiltered(self, geometry_id1: GeometryId, geometry_id2: GeometryId) -> bool: ...
    def FramesForSource(self, source_id: SourceId) -> set[FrameId]: ...
    def GetAllDeformableGeometryIds(self) -> list[GeometryId]: ...
    def GetAllFrameIds(self) -> list[FrameId]: ...
    def GetAllGeometryIds(self, role: Role | None = ...) -> list[GeometryId]: ...
    def GetAllSourceIds(self) -> list[SourceId]: ...
    def GetCollisionCandidates(self) -> set[tuple[GeometryId, GeometryId]]: ...
    def GetConvexHull(self, geometry_id: GeometryId) -> PolygonSurfaceMesh: ...
    def GetFrameGroup(self, frame_id: FrameId) -> int: ...
    def GetFrameId(self, geometry_id: GeometryId) -> FrameId: ...
    def GetGeometries(self, frame_id: FrameId, role: Role | None = ...) -> list[GeometryId]: ...
    def GetGeometryIdByName(self, frame_id: FrameId, role: Role, name: str) -> GeometryId: ...
    def GetGeometryIds(self, geometry_set: GeometrySet, role: Role | None = ...) -> set[GeometryId]: ...
    def GetIllustrationProperties(self, geometry_id: GeometryId) -> IllustrationProperties: ...
    @overload
    def GetName(self, source_id: SourceId) -> str: ...
    @overload
    def GetName(self, frame_id: FrameId) -> str: ...
    @overload
    def GetName(self, geometry_id: GeometryId) -> str: ...
    def GetObbInGeometryFrame(self, geometry_id: GeometryId) -> Obb | None: ...
    @overload
    def GetOwningSourceName(self, frame_id: FrameId) -> str: ...
    @overload
    def GetOwningSourceName(self, geometry_id: GeometryId) -> str: ...
    def GetPerceptionProperties(self, geometry_id: GeometryId) -> PerceptionProperties: ...
    def GetPoseInFrame(self, geometry_id: GeometryId) -> pydrake.math.RigidTransform: ...
    def GetProperties(self, geometry_id: GeometryId, role: Role) -> GeometryProperties: ...
    def GetProximityProperties(self, geometry_id: GeometryId) -> ProximityProperties: ...
    def GetReferenceMesh(self, geometry_id: GeometryId) -> VolumeMesh: ...
    def GetShape(self, geometry_id: GeometryId) -> Shape: ...
    def IsDeformableGeometry(self, geometry_id: GeometryId) -> bool: ...
    def NumAnchoredGeometries(self) -> int: ...
    def NumDeformableGeometriesWithRole(self, role: Role) -> int: ...
    def NumDynamicGeometries(self) -> int: ...
    def NumFramesForSource(self, source_id: SourceId) -> int: ...
    def NumGeometriesForFrame(self, frame_id: FrameId) -> int: ...
    def NumGeometriesForFrameWithRole(self, frame_id: FrameId, role: Role) -> int: ...
    def NumGeometriesWithRole(self, role: Role) -> int: ...
    def SourceIsRegistered(self, source_id: SourceId) -> bool: ...
    def geometry_version(self) -> GeometryVersion: ...
    @overload
    def maybe_get_hydroelastic_mesh(self, geometry_id: GeometryId) -> None | TriangleSurfaceMesh | VolumeMesh: ...
    @overload
    def maybe_get_hydroelastic_mesh(self, id) -> Any: ...
    def num_frames(self) -> int: ...
    def num_geometries(self) -> int: ...
    def num_sources(self) -> int: ...
    def world_frame_id(self) -> FrameId: ...

class _TemporaryName_N5drake8geometry19SceneGraphInspectorINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def BelongsToSource(self, frame_id: FrameId, source_id: SourceId) -> bool: ...
    @overload
    def BelongsToSource(self, geometry_id: GeometryId, source_id: SourceId) -> bool: ...
    def CloneGeometryInstance(self, geometry_id: GeometryId) -> GeometryInstance: ...
    def CollisionFiltered(self, geometry_id1: GeometryId, geometry_id2: GeometryId) -> bool: ...
    def FramesForSource(self, source_id: SourceId) -> set[FrameId]: ...
    def GetAllDeformableGeometryIds(self) -> list[GeometryId]: ...
    def GetAllFrameIds(self) -> list[FrameId]: ...
    def GetAllGeometryIds(self, role: Role | None = ...) -> list[GeometryId]: ...
    def GetAllSourceIds(self) -> list[SourceId]: ...
    def GetCollisionCandidates(self) -> set[tuple[GeometryId, GeometryId]]: ...
    def GetConvexHull(self, geometry_id: GeometryId) -> PolygonSurfaceMesh: ...
    def GetFrameGroup(self, frame_id: FrameId) -> int: ...
    def GetFrameId(self, geometry_id: GeometryId) -> FrameId: ...
    def GetGeometries(self, frame_id: FrameId, role: Role | None = ...) -> list[GeometryId]: ...
    def GetGeometryIdByName(self, frame_id: FrameId, role: Role, name: str) -> GeometryId: ...
    def GetGeometryIds(self, geometry_set: GeometrySet, role: Role | None = ...) -> set[GeometryId]: ...
    def GetIllustrationProperties(self, geometry_id: GeometryId) -> IllustrationProperties: ...
    @overload
    def GetName(self, source_id: SourceId) -> str: ...
    @overload
    def GetName(self, frame_id: FrameId) -> str: ...
    @overload
    def GetName(self, geometry_id: GeometryId) -> str: ...
    def GetObbInGeometryFrame(self, geometry_id: GeometryId) -> Obb | None: ...
    @overload
    def GetOwningSourceName(self, frame_id: FrameId) -> str: ...
    @overload
    def GetOwningSourceName(self, geometry_id: GeometryId) -> str: ...
    def GetPerceptionProperties(self, geometry_id: GeometryId) -> PerceptionProperties: ...
    def GetPoseInFrame(self, geometry_id: GeometryId) -> pydrake.math.RigidTransform: ...
    def GetProperties(self, geometry_id: GeometryId, role: Role) -> GeometryProperties: ...
    def GetProximityProperties(self, geometry_id: GeometryId) -> ProximityProperties: ...
    def GetReferenceMesh(self, geometry_id: GeometryId) -> VolumeMesh: ...
    def GetShape(self, geometry_id: GeometryId) -> Shape: ...
    def IsDeformableGeometry(self, geometry_id: GeometryId) -> bool: ...
    def NumAnchoredGeometries(self) -> int: ...
    def NumDeformableGeometriesWithRole(self, role: Role) -> int: ...
    def NumDynamicGeometries(self) -> int: ...
    def NumFramesForSource(self, source_id: SourceId) -> int: ...
    def NumGeometriesForFrame(self, frame_id: FrameId) -> int: ...
    def NumGeometriesForFrameWithRole(self, frame_id: FrameId, role: Role) -> int: ...
    def NumGeometriesWithRole(self, role: Role) -> int: ...
    def SourceIsRegistered(self, source_id: SourceId) -> bool: ...
    def geometry_version(self) -> GeometryVersion: ...
    @overload
    def maybe_get_hydroelastic_mesh(self, geometry_id: GeometryId) -> None | TriangleSurfaceMesh | VolumeMesh: ...
    @overload
    def maybe_get_hydroelastic_mesh(self, id) -> Any: ...
    def num_frames(self) -> int: ...
    def num_geometries(self) -> int: ...
    def num_sources(self) -> int: ...
    def world_frame_id(self) -> FrameId: ...

class _TemporaryName_N5drake8geometry19TriangleSurfaceMeshIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, triangles: list[SurfaceTriangle], vertices: list[numpy.ndarray[object[3, 1]]]) -> None: ...
    def CalcBarycentric(self, p_MQ: numpy.ndarray[object[3, 1]], t: int) -> numpy.ndarray[object[3, 1]]: ...
    def CalcBoundingBox(self) -> tuple[numpy.ndarray[object[3, 1]], numpy.ndarray[object[3, 1]]]: ...
    def CalcCartesianFromBarycentric(self, element_index: int, b_Q: numpy.ndarray[object[3, 1]]) -> numpy.ndarray[object[3, 1]]: ...
    def Equal(self, mesh: TriangleSurfaceMesh_TAutoDiffXdU) -> bool: ...
    def area(self, t: int) -> pydrake.autodiffutils.AutoDiffXd: ...
    def centroid(self) -> numpy.ndarray[object[3, 1]]: ...
    def element(self, e: int) -> SurfaceTriangle: ...
    def element_centroid(self, t: int) -> numpy.ndarray[object[3, 1]]: ...
    def face_normal(self, t: int) -> numpy.ndarray[object[3, 1]]: ...
    def num_elements(self) -> int: ...
    def num_triangles(self) -> int: ...
    def num_vertices(self) -> int: ...
    def total_area(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def triangles(self) -> list[SurfaceTriangle]: ...
    def vertex(self, v: int) -> numpy.ndarray[object[3, 1]]: ...
    def vertices(self) -> list[numpy.ndarray[object[3, 1]]]: ...

class _TemporaryName_N5drake8geometry21SignedDistanceToPointIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    distance: pydrake.autodiffutils.AutoDiffXd
    grad_W: numpy.ndarray[object[3, 1]]
    id_G: GeometryId
    p_GN: numpy.ndarray[object[3, 1]]
    def __init__(self, **kwargs) -> None: ...

class _TemporaryName_N5drake8geometry21SignedDistanceToPointINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    distance: pydrake.symbolic.Expression
    grad_W: numpy.ndarray[object[3, 1]]
    id_G: GeometryId
    p_GN: numpy.ndarray[object[3, 1]]
    def __init__(self, **kwargs) -> None: ...

class _TemporaryName_N5drake8geometry22PenetrationAsPointPairIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    depth: pydrake.autodiffutils.AutoDiffXd
    id_A: GeometryId
    id_B: GeometryId
    nhat_BA_W: numpy.ndarray[object[3, 1]]
    p_WCa: numpy.ndarray[object[3, 1]]
    p_WCb: numpy.ndarray[object[3, 1]]
    def __init__(self, **kwargs) -> None: ...

class _TemporaryName_N5drake8geometry22PenetrationAsPointPairINS_8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    depth: pydrake.symbolic.Expression
    id_A: GeometryId
    id_B: GeometryId
    nhat_BA_W: numpy.ndarray[object[3, 1]]
    p_WCa: numpy.ndarray[object[3, 1]]
    p_WCb: numpy.ndarray[object[3, 1]]
    def __init__(self, **kwargs) -> None: ...

class _TemporaryName_N5drake8geometry27MeshcatPointCloudVisualizerIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE(pydrake.systems.framework.LeafSystem_TAutoDiffXdU):
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, meshcat: Meshcat, path: str, publish_period: float = ...) -> None: ...
    @overload
    def Delete(self) -> None: ...
    @overload
    def Delete(self, path) -> Any: ...
    def cloud_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def pose_input_port(self) -> pydrake.systems.framework.InputPort_TAutoDiffXdU: ...
    def set_default_rgba(self, arg0: Rgba) -> None: ...
    def set_point_size(self, arg0: float) -> None: ...

class _TemporaryName_N5drake8geometry5PlaneIN5Eigen14AutoDiffScalarINS2_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    def __init__(self, normal: numpy.ndarray[object[3, 1]], point_on_plane: numpy.ndarray[object[3, 1]], already_normalized: bool = ...) -> None: ...
    def BoxOverlaps(self, half_width: numpy.ndarray[numpy.float64[3, 1]], box_center_in_plane: numpy.ndarray[numpy.float64[3, 1]], box_orientation_in_plane: pydrake.math.RotationMatrix) -> bool: ...
    def CalcHeight(self, point: numpy.ndarray[object[3, 1]]) -> pydrake.autodiffutils.AutoDiffXd: ...
    def reference_point(self) -> numpy.ndarray[object[3, 1]]: ...
    def unit_normal(self) -> numpy.ndarray[object[3, 1]]: ...
    def __copy__(self) -> Plane_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> Plane_TAutoDiffXdU: ...

def AddCompliantHydroelasticProperties(resolution_hint: float, hydroelastic_modulus: float, properties: ProximityProperties) -> None: ...
def AddCompliantHydroelasticPropertiesForHalfSpace(slab_thickness: float, hydroelastic_modulus: float, properties: ProximityProperties) -> None: ...
@overload
def AddContactMaterial(dissipation: float | None, point_stiffness: float | None, friction, properties: ProximityProperties) -> None: ...
@overload
def AddContactMaterial() -> Any: ...
@overload
def AddContactMaterial(properties: ProximityProperties, dissipation: float | None = ..., point_stiffness: float | None = ..., friction=...) -> None: ...
@overload
def AddContactMaterial() -> Any: ...
def AddRigidHydroelasticProperties(resolution_hint: float, properties: ProximityProperties) -> None: ...
def CalcObb(shape: Shape) -> Obb | None: ...
def CalcVolume(shape: Shape) -> float: ...
def ComputeAabbForTriangleMesh(mesh_M: TriangleSurfaceMesh, vertices: set[int]) -> Aabb: ...
def ComputeAabbForVolumeMesh(mesh_M: VolumeMesh, vertices: set[int]) -> Aabb: ...
def ComputeObbForTriangleMesh(mesh_M: TriangleSurfaceMesh, vertices: set[int]) -> Obb: ...
def ComputeObbForVolumeMesh(mesh_M: VolumeMesh, vertices: set[int]) -> Obb: ...
@overload
def ConvertVolumeToSurfaceMesh(volume: VolumeMesh) -> TriangleSurfaceMesh: ...
@overload
def ConvertVolumeToSurfaceMesh(volume: VolumeMesh_TAutoDiffXdU) -> TriangleSurfaceMesh_TAutoDiffXdU: ...
def MakePhongIllustrationProperties(diffuse: numpy.ndarray[numpy.float64[4, 1]]) -> IllustrationProperties: ...
def MakeRenderEngineGl(params: RenderEngineGlParams = ...) -> RenderEngine: ...
@overload
def MakeRenderEngineGltfClient(params: RenderEngineGltfClientParams = ...) -> RenderEngine: ...
@overload
def MakeRenderEngineGltfClient(params) -> Any: ...
@overload
def MakeRenderEngineGltfClient() -> Any: ...
def MakeRenderEngineVtk(params: RenderEngineVtkParams) -> RenderEngine: ...
@overload
def ReadObjToTriangleSurfaceMesh(filename: os.PathLike, scale: float = ...) -> TriangleSurfaceMesh: ...
@overload
def ReadObjToTriangleSurfaceMesh(filename: os.PathLike, scale3: numpy.ndarray[numpy.float64[3, 1]]) -> TriangleSurfaceMesh: ...
def RefineVolumeMesh(mesh: VolumeMesh) -> VolumeMesh: ...
def RefineVolumeMeshIntoVtkFileContents(mesh_source: MeshSource) -> str: ...
