import numpy
import pydrake.geometry
import pydrake.systems.framework
import pydrake.systems.primitives
from typing import overload

class AcrobotGeometry(pydrake.systems.framework.LeafSystem):
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder, acrobot_state_port: pydrake.systems.framework.OutputPort, acrobot_params: AcrobotParams, scene_graph: pydrake.geometry.SceneGraph) -> AcrobotGeometry: ...
    @overload
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder, acrobot_state_port: pydrake.systems.framework.OutputPort, scene_graph: pydrake.geometry.SceneGraph) -> AcrobotGeometry: ...

class AcrobotInput(pydrake.systems.framework.BasicVector):
    def __init__(self) -> None: ...
    def set_tau(self, arg0: float) -> None: ...
    def tau(self) -> float: ...

class AcrobotParams(pydrake.systems.framework.BasicVector):
    def __init__(self) -> None: ...
    def Ic1(self) -> float: ...
    def Ic2(self) -> float: ...
    def b1(self) -> float: ...
    def b2(self) -> float: ...
    def gravity(self) -> float: ...
    def l1(self) -> float: ...
    def lc1(self) -> float: ...
    def lc2(self) -> float: ...
    def m1(self) -> float: ...
    def m2(self) -> float: ...
    def set_Ic1(self, arg0: float) -> None: ...
    def set_Ic2(self, arg0: float) -> None: ...
    def set_b1(self, arg0: float) -> None: ...
    def set_b2(self, arg0: float) -> None: ...
    def set_gravity(self, arg0: float) -> None: ...
    def set_l1(self, arg0: float) -> None: ...
    def set_lc1(self, arg0: float) -> None: ...
    def set_lc2(self, arg0: float) -> None: ...
    def set_m1(self, arg0: float) -> None: ...
    def set_m2(self, arg0: float) -> None: ...

class AcrobotPlant(pydrake.systems.framework.LeafSystem):
    def __init__(self) -> None: ...
    def DynamicsBiasTerm(self, arg0: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[2, 1]]: ...
    def MassMatrix(self, arg0: pydrake.systems.framework.Context) -> numpy.ndarray[numpy.float64[2, 2]]: ...
    def SetMitAcrobotParameters(self, arg0: AcrobotParams) -> None: ...
    def get_mutable_parameters(self, context: pydrake.systems.framework.Context) -> AcrobotParams: ...
    @staticmethod
    def get_mutable_state(context: pydrake.systems.framework.Context) -> AcrobotState: ...
    def get_parameters(self, context: pydrake.systems.framework.Context) -> AcrobotParams: ...
    @staticmethod
    def get_state(context: pydrake.systems.framework.Context) -> AcrobotState: ...

class AcrobotSpongController(pydrake.systems.framework.LeafSystem):
    def __init__(self) -> None: ...
    def get_mutable_parameters(self, context: pydrake.systems.framework.Context) -> SpongControllerParams: ...
    def get_parameters(self, context: pydrake.systems.framework.Context) -> SpongControllerParams: ...

class AcrobotState(pydrake.systems.framework.BasicVector):
    def __init__(self) -> None: ...
    def set_theta1(self, arg0: float) -> None: ...
    def set_theta1dot(self, arg0: float) -> None: ...
    def set_theta2(self, arg0: float) -> None: ...
    def set_theta2dot(self, arg0: float) -> None: ...
    def theta1(self) -> float: ...
    def theta1dot(self) -> float: ...
    def theta2(self) -> float: ...
    def theta2dot(self) -> float: ...

class AcrobotWEncoder(pydrake.systems.framework.Diagram):
    def __init__(self, acrobot_state_as_second_output: bool = ...) -> None: ...
    def acrobot_plant(self) -> AcrobotPlant: ...
    def get_mutable_acrobot_state(self, context: pydrake.systems.framework.Context) -> AcrobotState: ...

class CompassGait(pydrake.systems.framework.LeafSystem):
    def __init__(self) -> None: ...
    def get_floating_base_state_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_minimal_state_output_port(self) -> pydrake.systems.framework.OutputPort: ...

class CompassGaitContinuousState(pydrake.systems.framework.BasicVector):
    def __init__(self) -> None: ...
    def set_stance(self, arg0: float) -> None: ...
    def set_stancedot(self, arg0: float) -> None: ...
    def set_swing(self, arg0: float) -> None: ...
    def set_swingdot(self, arg0: float) -> None: ...
    def stance(self) -> float: ...
    def stancedot(self) -> float: ...
    def swing(self) -> float: ...
    def swingdot(self) -> float: ...

class CompassGaitGeometry(pydrake.systems.framework.LeafSystem):
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder, floating_base_state_port: pydrake.systems.framework.OutputPort, compass_gait_params: CompassGaitParams, scene_graph: pydrake.geometry.SceneGraph) -> CompassGaitGeometry: ...
    @overload
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder, floating_base_state_port: pydrake.systems.framework.OutputPort, scene_graph: pydrake.geometry.SceneGraph) -> CompassGaitGeometry: ...

class CompassGaitParams(pydrake.systems.framework.BasicVector):
    def __init__(self) -> None: ...
    def center_of_mass_leg(self) -> float: ...
    def gravity(self) -> float: ...
    def length_leg(self) -> float: ...
    def mass_hip(self) -> float: ...
    def mass_leg(self) -> float: ...
    def set_center_of_mass_leg(self, arg0: float) -> None: ...
    def set_gravity(self, arg0: float) -> None: ...
    def set_length_leg(self, arg0: float) -> None: ...
    def set_mass_hip(self, arg0: float) -> None: ...
    def set_mass_leg(self, arg0: float) -> None: ...
    def set_slope(self, arg0: float) -> None: ...
    def slope(self) -> float: ...

class PendulumGeometry(pydrake.systems.framework.LeafSystem):
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder, pendulum_state_port: pydrake.systems.framework.OutputPort, scene_graph: pydrake.geometry.SceneGraph) -> PendulumGeometry: ...

class PendulumInput(pydrake.systems.framework.BasicVector):
    def __init__(self) -> None: ...
    def set_tau(self, tau: float) -> None: ...
    def tau(self) -> float: ...
    def with_tau(self, tau: float) -> PendulumInput: ...

class PendulumParams(pydrake.systems.framework.BasicVector):
    def __init__(self) -> None: ...
    def damping(self) -> float: ...
    def gravity(self) -> float: ...
    def length(self) -> float: ...
    def mass(self) -> float: ...
    def set_damping(self, damping: float) -> None: ...
    def set_gravity(self, gravity: float) -> None: ...
    def set_length(self, length: float) -> None: ...
    def set_mass(self, mass: float) -> None: ...
    def with_damping(self, damping: float) -> PendulumParams: ...
    def with_gravity(self, gravity: float) -> PendulumParams: ...
    def with_length(self, length: float) -> PendulumParams: ...
    def with_mass(self, mass: float) -> PendulumParams: ...

class PendulumPlant(pydrake.systems.framework.LeafSystem):
    def __init__(self) -> None: ...
    def get_mutable_parameters(self, context: pydrake.systems.framework.Context) -> PendulumParams: ...
    @staticmethod
    def get_mutable_state(context: pydrake.systems.framework.Context) -> PendulumState: ...
    def get_parameters(self, context: pydrake.systems.framework.Context) -> PendulumParams: ...
    @staticmethod
    def get_state(context: pydrake.systems.framework.Context) -> PendulumState: ...
    def get_state_output_port(self) -> pydrake.systems.framework.OutputPort: ...

class PendulumState(pydrake.systems.framework.BasicVector):
    def __init__(self) -> None: ...
    def set_theta(self, theta: float) -> None: ...
    def set_thetadot(self, thetadot: float) -> None: ...
    def theta(self) -> float: ...
    def thetadot(self) -> float: ...
    def with_theta(self, theta: float) -> PendulumState: ...
    def with_thetadot(self, thetadot: float) -> PendulumState: ...

class QuadrotorGeometry(pydrake.systems.framework.LeafSystem):
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder, quadrotor_state_port: pydrake.systems.framework.OutputPort, scene_graph: pydrake.geometry.SceneGraph) -> QuadrotorGeometry: ...
    def get_frame_id(self) -> pydrake.geometry.FrameId: ...

class QuadrotorPlant(pydrake.systems.framework.LeafSystem):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, m_arg: float, L_arg: float, I_arg: numpy.ndarray[numpy.float64[3, 3]], kF_arg: float, kM_arg: float) -> None: ...
    def force_constant(self) -> float: ...
    def g(self) -> float: ...
    def inertia(self) -> numpy.ndarray[numpy.float64[3, 3]]: ...
    def length(self) -> float: ...
    def m(self) -> float: ...
    def moment_constant(self) -> float: ...

class RimlessWheel(pydrake.systems.framework.LeafSystem):
    def __init__(self) -> None: ...
    @staticmethod
    def calc_alpha(params: RimlessWheelParams) -> float: ...
    def get_floating_base_state_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_minimal_state_output_port(self) -> pydrake.systems.framework.OutputPort: ...

class RimlessWheelContinuousState(pydrake.systems.framework.BasicVector):
    def __init__(self) -> None: ...
    def set_theta(self, arg0: float) -> None: ...
    def set_thetadot(self, arg0: float) -> None: ...
    def theta(self) -> float: ...
    def thetadot(self) -> float: ...

class RimlessWheelGeometry(pydrake.systems.framework.LeafSystem):
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder, floating_base_state_port: pydrake.systems.framework.OutputPort, rimless_wheel_params: RimlessWheelParams, scene_graph: pydrake.geometry.SceneGraph) -> RimlessWheelGeometry: ...
    @overload
    @staticmethod
    def AddToBuilder(builder: pydrake.systems.framework.DiagramBuilder, floating_base_state_port: pydrake.systems.framework.OutputPort, scene_graph: pydrake.geometry.SceneGraph) -> RimlessWheelGeometry: ...

class RimlessWheelParams(pydrake.systems.framework.BasicVector):
    def __init__(self) -> None: ...
    def gravity(self) -> float: ...
    def length(self) -> float: ...
    def mass(self) -> float: ...
    def number_of_spokes(self) -> float: ...
    def set_gravity(self, arg0: float) -> None: ...
    def set_length(self, arg0: float) -> None: ...
    def set_mass(self, arg0: float) -> None: ...
    def set_number_of_spokes(self, arg0: float) -> None: ...
    def set_slope(self, arg0: float) -> None: ...
    def slope(self) -> float: ...

class SpongControllerParams(pydrake.systems.framework.BasicVector):
    def __init__(self) -> None: ...
    def balancing_threshold(self) -> float: ...
    def k_d(self) -> float: ...
    def k_e(self) -> float: ...
    def k_p(self) -> float: ...
    def set_balancing_threshold(self, arg0: float) -> None: ...
    def set_k_d(self, arg0: float) -> None: ...
    def set_k_e(self, arg0: float) -> None: ...
    def set_k_p(self, arg0: float) -> None: ...

class VanDerPolOscillator(pydrake.systems.framework.LeafSystem):
    def __init__(self) -> None: ...
    @staticmethod
    def CalcLimitCycle() -> numpy.ndarray[numpy.float64[2, n]]: ...
    def get_full_state_output_port(self) -> pydrake.systems.framework.OutputPort: ...
    def get_position_output_port(self) -> pydrake.systems.framework.OutputPort: ...

def StabilizingLQRController(quadrotor_plant: QuadrotorPlant, nominal_position: numpy.ndarray[numpy.float64[3, 1]]) -> pydrake.systems.primitives.AffineSystem: ...
