import numpy
import pydrake.common
import pydrake.math
import pydrake.symbolic
from pydrake.common.cpp_template import DeterministicVector as DeterministicVector, GaussianVector as GaussianVector, UniformVector as UniformVector
from typing import ClassVar, overload

class Deterministic(Distribution):
    __fields__: ClassVar[tuple] = ...  # read-only
    value: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: Deterministic) -> None: ...
    @overload
    def __init__(self, value: float) -> None: ...
    def __copy__(self) -> Deterministic: ...
    def __deepcopy__(self, arg0: dict) -> Deterministic: ...

class DeterministicVectorX(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    value: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: DeterministicVectorTNoneU) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> DeterministicVectorTNoneU: ...
    def __deepcopy__(self, arg0: dict) -> DeterministicVectorTNoneU: ...

class DeterministicVector𝓣1𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    value: numpy.ndarray[numpy.float64[1, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: DeterministicVectorT1U) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[1, 1]]) -> None: ...
    def __copy__(self) -> DeterministicVectorT1U: ...
    def __deepcopy__(self, arg0: dict) -> DeterministicVectorT1U: ...

class DeterministicVector𝓣2𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    value: numpy.ndarray[numpy.float64[2, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: DeterministicVectorT2U) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[2, 1]]) -> None: ...
    def __copy__(self) -> DeterministicVectorT2U: ...
    def __deepcopy__(self, arg0: dict) -> DeterministicVectorT2U: ...

class DeterministicVector𝓣3𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    value: numpy.ndarray[numpy.float64[3, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: DeterministicVectorT3U) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def __copy__(self) -> DeterministicVectorT3U: ...
    def __deepcopy__(self, arg0: dict) -> DeterministicVectorT3U: ...

class DeterministicVector𝓣4𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    value: numpy.ndarray[numpy.float64[4, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: DeterministicVectorT4U) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[4, 1]]) -> None: ...
    def __copy__(self) -> DeterministicVectorT4U: ...
    def __deepcopy__(self, arg0: dict) -> DeterministicVectorT4U: ...

class DeterministicVector𝓣5𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    value: numpy.ndarray[numpy.float64[5, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: DeterministicVectorT5U) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[5, 1]]) -> None: ...
    def __copy__(self) -> DeterministicVectorT5U: ...
    def __deepcopy__(self, arg0: dict) -> DeterministicVectorT5U: ...

class DeterministicVector𝓣6𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    value: numpy.ndarray[numpy.float64[6, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: DeterministicVectorT6U) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[6, 1]]) -> None: ...
    def __copy__(self) -> DeterministicVectorT6U: ...
    def __deepcopy__(self, arg0: dict) -> DeterministicVectorT6U: ...

class DeterministicVector𝓣None𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    value: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: DeterministicVectorTNoneU) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> DeterministicVectorTNoneU: ...
    def __deepcopy__(self, arg0: dict) -> DeterministicVectorTNoneU: ...

class Distribution:
    def __init__(self, *args, **kwargs) -> None: ...
    def Mean(self) -> float: ...
    def Sample(self, generator: pydrake.common.RandomGenerator) -> float: ...
    def ToSymbolic(self) -> pydrake.symbolic.Expression: ...

class DistributionVector:
    def __init__(self, *args, **kwargs) -> None: ...
    def Mean(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def Sample(self, generator: pydrake.common.RandomGenerator) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def ToSymbolic(self) -> numpy.ndarray[object[m, 1]]: ...

class Gaussian(Distribution):
    __fields__: ClassVar[tuple] = ...  # read-only
    mean: float
    stddev: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: Gaussian) -> None: ...
    @overload
    def __init__(self, mean: float, stddev: float) -> None: ...
    def __copy__(self) -> Gaussian: ...
    def __deepcopy__(self, arg0: dict) -> Gaussian: ...

class GaussianVectorX(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    mean: numpy.ndarray[numpy.float64[m, 1]]
    stddev: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GaussianVectorTNoneU) -> None: ...
    @overload
    def __init__(self, mean: numpy.ndarray[numpy.float64[m, 1]], stddev: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> GaussianVectorTNoneU: ...
    def __deepcopy__(self, arg0: dict) -> GaussianVectorTNoneU: ...

class GaussianVector𝓣1𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    mean: numpy.ndarray[numpy.float64[1, 1]]
    stddev: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GaussianVectorT1U) -> None: ...
    @overload
    def __init__(self, mean: numpy.ndarray[numpy.float64[1, 1]], stddev: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> GaussianVectorT1U: ...
    def __deepcopy__(self, arg0: dict) -> GaussianVectorT1U: ...

class GaussianVector𝓣2𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    mean: numpy.ndarray[numpy.float64[2, 1]]
    stddev: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GaussianVectorT2U) -> None: ...
    @overload
    def __init__(self, mean: numpy.ndarray[numpy.float64[2, 1]], stddev: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> GaussianVectorT2U: ...
    def __deepcopy__(self, arg0: dict) -> GaussianVectorT2U: ...

class GaussianVector𝓣3𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    mean: numpy.ndarray[numpy.float64[3, 1]]
    stddev: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GaussianVectorT3U) -> None: ...
    @overload
    def __init__(self, mean: numpy.ndarray[numpy.float64[3, 1]], stddev: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> GaussianVectorT3U: ...
    def __deepcopy__(self, arg0: dict) -> GaussianVectorT3U: ...

class GaussianVector𝓣4𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    mean: numpy.ndarray[numpy.float64[4, 1]]
    stddev: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GaussianVectorT4U) -> None: ...
    @overload
    def __init__(self, mean: numpy.ndarray[numpy.float64[4, 1]], stddev: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> GaussianVectorT4U: ...
    def __deepcopy__(self, arg0: dict) -> GaussianVectorT4U: ...

class GaussianVector𝓣5𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    mean: numpy.ndarray[numpy.float64[5, 1]]
    stddev: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GaussianVectorT5U) -> None: ...
    @overload
    def __init__(self, mean: numpy.ndarray[numpy.float64[5, 1]], stddev: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> GaussianVectorT5U: ...
    def __deepcopy__(self, arg0: dict) -> GaussianVectorT5U: ...

class GaussianVector𝓣6𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    mean: numpy.ndarray[numpy.float64[6, 1]]
    stddev: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GaussianVectorT6U) -> None: ...
    @overload
    def __init__(self, mean: numpy.ndarray[numpy.float64[6, 1]], stddev: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> GaussianVectorT6U: ...
    def __deepcopy__(self, arg0: dict) -> GaussianVectorT6U: ...

class GaussianVector𝓣None𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    mean: numpy.ndarray[numpy.float64[m, 1]]
    stddev: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GaussianVectorTNoneU) -> None: ...
    @overload
    def __init__(self, mean: numpy.ndarray[numpy.float64[m, 1]], stddev: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> GaussianVectorTNoneU: ...
    def __deepcopy__(self, arg0: dict) -> GaussianVectorTNoneU: ...

class Rotation:
    class AngleAxis:
        __fields__: ClassVar[tuple] = ...  # read-only
        angle_deg: float | Deterministic | Gaussian | Uniform | UniformDiscrete
        axis: numpy.ndarray[numpy.float64[3, 1]] | DeterministicVectorT3U | GaussianVectorT3U | UniformVectorT3U | _InvalidVariantSelectionDeterministic | _InvalidVariantSelectionGaussian | _InvalidVariantSelectionUniform
        @overload
        def __init__(self, other: Rotation.AngleAxis) -> None: ...
        @overload
        def __init__(self, **kwargs) -> None: ...
        def __copy__(self) -> Rotation.AngleAxis: ...
        def __deepcopy__(self, arg0: dict) -> Rotation.AngleAxis: ...

    class Identity:
        __fields__: ClassVar[tuple] = ...  # read-only
        @overload
        def __init__(self, other: Rotation.Identity) -> None: ...
        @overload
        def __init__(self, **kwargs) -> None: ...
        def __copy__(self) -> Rotation.Identity: ...
        def __deepcopy__(self, arg0: dict) -> Rotation.Identity: ...

    class Rpy:
        __fields__: ClassVar[tuple] = ...  # read-only
        deg: numpy.ndarray[numpy.float64[3, 1]] | DeterministicVectorT3U | GaussianVectorT3U | UniformVectorT3U | _InvalidVariantSelectionDeterministic | _InvalidVariantSelectionGaussian | _InvalidVariantSelectionUniform
        @overload
        def __init__(self, other: Rotation.Rpy) -> None: ...
        @overload
        def __init__(self, **kwargs) -> None: ...
        def __copy__(self) -> Rotation.Rpy: ...
        def __deepcopy__(self, arg0: dict) -> Rotation.Rpy: ...

    class Uniform:
        __fields__: ClassVar[tuple] = ...  # read-only
        @overload
        def __init__(self, other: Rotation.Uniform) -> None: ...
        @overload
        def __init__(self, **kwargs) -> None: ...
        def __copy__(self) -> Rotation.Uniform: ...
        def __deepcopy__(self, arg0: dict) -> Rotation.Uniform: ...
    __fields__: ClassVar[tuple] = ...  # read-only
    value: Rotation.Identity | Rotation.Rpy | Rotation.AngleAxis | Rotation.Uniform
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: Rotation) -> None: ...
    @overload
    def __init__(self, arg0: pydrake.math.RotationMatrix) -> None: ...
    @overload
    def __init__(self, arg0: pydrake.math.RollPitchYaw) -> None: ...
    @overload
    def __init__(self, **kwargs) -> None: ...
    def GetDeterministicValue(self) -> pydrake.math.RotationMatrix: ...
    def IsDeterministic(self) -> bool: ...
    def ToSymbolic(self) -> pydrake.math.RotationMatrix_TExpressionU: ...
    def set_rpy_deg(self, rpy_deg: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def __copy__(self) -> Rotation: ...
    def __deepcopy__(self, arg0: dict) -> Rotation: ...
    def __getattr__(self, arg0: str) -> object: ...
    def __setattr__(self, arg0: str, arg1: object) -> None: ...

class Transform:
    __fields__: ClassVar[tuple] = ...  # read-only
    base_frame: str | None
    rotation: Rotation
    translation: numpy.ndarray[numpy.float64[3, 1]] | DeterministicVectorT3U | GaussianVectorT3U | UniformVectorT3U | _InvalidVariantSelectionDeterministic | _InvalidVariantSelectionGaussian | _InvalidVariantSelectionUniform
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: Transform) -> None: ...
    @overload
    def __init__(self, arg0: pydrake.math.RigidTransform) -> None: ...
    @overload
    def __init__(self, **kwargs) -> None: ...
    def GetDeterministicValue(self) -> pydrake.math.RigidTransform: ...
    def IsDeterministic(self) -> bool: ...
    def Mean(self) -> pydrake.math.RigidTransform: ...
    def Sample(self, generator: pydrake.common.RandomGenerator) -> pydrake.math.RigidTransform: ...
    def ToSymbolic(self) -> pydrake.math.RigidTransform_TExpressionU: ...
    def set_rotation_rpy_deg(self, rpy_deg: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def __copy__(self) -> Transform: ...
    def __deepcopy__(self, arg0: dict) -> Transform: ...

class Uniform(Distribution):
    __fields__: ClassVar[tuple] = ...  # read-only
    max: float
    min: float
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: Uniform) -> None: ...
    @overload
    def __init__(self, min: float, max: float) -> None: ...
    def __copy__(self) -> Uniform: ...
    def __deepcopy__(self, arg0: dict) -> Uniform: ...

class UniformDiscrete(Distribution):
    __fields__: ClassVar[tuple] = ...  # read-only
    values: list[float]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: UniformDiscrete) -> None: ...
    @overload
    def __init__(self, values: list[float]) -> None: ...
    def __copy__(self) -> UniformDiscrete: ...
    def __deepcopy__(self, arg0: dict) -> UniformDiscrete: ...

class UniformVectorX(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    max: numpy.ndarray[numpy.float64[m, 1]]
    min: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: UniformVectorTNoneU) -> None: ...
    @overload
    def __init__(self, min: numpy.ndarray[numpy.float64[m, 1]], max: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> UniformVectorTNoneU: ...
    def __deepcopy__(self, arg0: dict) -> UniformVectorTNoneU: ...

class UniformVector𝓣1𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    max: numpy.ndarray[numpy.float64[1, 1]]
    min: numpy.ndarray[numpy.float64[1, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: UniformVectorT1U) -> None: ...
    @overload
    def __init__(self, min: numpy.ndarray[numpy.float64[1, 1]], max: numpy.ndarray[numpy.float64[1, 1]]) -> None: ...
    def __copy__(self) -> UniformVectorT1U: ...
    def __deepcopy__(self, arg0: dict) -> UniformVectorT1U: ...

class UniformVector𝓣2𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    max: numpy.ndarray[numpy.float64[2, 1]]
    min: numpy.ndarray[numpy.float64[2, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: UniformVectorT2U) -> None: ...
    @overload
    def __init__(self, min: numpy.ndarray[numpy.float64[2, 1]], max: numpy.ndarray[numpy.float64[2, 1]]) -> None: ...
    def __copy__(self) -> UniformVectorT2U: ...
    def __deepcopy__(self, arg0: dict) -> UniformVectorT2U: ...

class UniformVector𝓣3𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    max: numpy.ndarray[numpy.float64[3, 1]]
    min: numpy.ndarray[numpy.float64[3, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: UniformVectorT3U) -> None: ...
    @overload
    def __init__(self, min: numpy.ndarray[numpy.float64[3, 1]], max: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def __copy__(self) -> UniformVectorT3U: ...
    def __deepcopy__(self, arg0: dict) -> UniformVectorT3U: ...

class UniformVector𝓣4𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    max: numpy.ndarray[numpy.float64[4, 1]]
    min: numpy.ndarray[numpy.float64[4, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: UniformVectorT4U) -> None: ...
    @overload
    def __init__(self, min: numpy.ndarray[numpy.float64[4, 1]], max: numpy.ndarray[numpy.float64[4, 1]]) -> None: ...
    def __copy__(self) -> UniformVectorT4U: ...
    def __deepcopy__(self, arg0: dict) -> UniformVectorT4U: ...

class UniformVector𝓣5𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    max: numpy.ndarray[numpy.float64[5, 1]]
    min: numpy.ndarray[numpy.float64[5, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: UniformVectorT5U) -> None: ...
    @overload
    def __init__(self, min: numpy.ndarray[numpy.float64[5, 1]], max: numpy.ndarray[numpy.float64[5, 1]]) -> None: ...
    def __copy__(self) -> UniformVectorT5U: ...
    def __deepcopy__(self, arg0: dict) -> UniformVectorT5U: ...

class UniformVector𝓣6𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    max: numpy.ndarray[numpy.float64[6, 1]]
    min: numpy.ndarray[numpy.float64[6, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: UniformVectorT6U) -> None: ...
    @overload
    def __init__(self, min: numpy.ndarray[numpy.float64[6, 1]], max: numpy.ndarray[numpy.float64[6, 1]]) -> None: ...
    def __copy__(self) -> UniformVectorT6U: ...
    def __deepcopy__(self, arg0: dict) -> UniformVectorT6U: ...

class UniformVector𝓣None𝓤(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    max: numpy.ndarray[numpy.float64[m, 1]]
    min: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: UniformVectorTNoneU) -> None: ...
    @overload
    def __init__(self, min: numpy.ndarray[numpy.float64[m, 1]], max: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> UniformVectorTNoneU: ...
    def __deepcopy__(self, arg0: dict) -> UniformVectorTNoneU: ...

class _InvalidVariantSelectionDeterministic:
    def __init__(self, *args, **kwargs) -> None: ...

class _InvalidVariantSelectionGaussian:
    def __init__(self, *args, **kwargs) -> None: ...

class _InvalidVariantSelectionUniform:
    def __init__(self, *args, **kwargs) -> None: ...

class _TemporaryName_N5drake6schema13UniformVectorILi1EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    max: numpy.ndarray[numpy.float64[1, 1]]
    min: numpy.ndarray[numpy.float64[1, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: UniformVectorT1U) -> None: ...
    @overload
    def __init__(self, min: numpy.ndarray[numpy.float64[1, 1]], max: numpy.ndarray[numpy.float64[1, 1]]) -> None: ...
    def __copy__(self) -> UniformVectorT1U: ...
    def __deepcopy__(self, arg0: dict) -> UniformVectorT1U: ...

class _TemporaryName_N5drake6schema13UniformVectorILi2EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    max: numpy.ndarray[numpy.float64[2, 1]]
    min: numpy.ndarray[numpy.float64[2, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: UniformVectorT2U) -> None: ...
    @overload
    def __init__(self, min: numpy.ndarray[numpy.float64[2, 1]], max: numpy.ndarray[numpy.float64[2, 1]]) -> None: ...
    def __copy__(self) -> UniformVectorT2U: ...
    def __deepcopy__(self, arg0: dict) -> UniformVectorT2U: ...

class _TemporaryName_N5drake6schema13UniformVectorILi3EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    max: numpy.ndarray[numpy.float64[3, 1]]
    min: numpy.ndarray[numpy.float64[3, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: UniformVectorT3U) -> None: ...
    @overload
    def __init__(self, min: numpy.ndarray[numpy.float64[3, 1]], max: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def __copy__(self) -> UniformVectorT3U: ...
    def __deepcopy__(self, arg0: dict) -> UniformVectorT3U: ...

class _TemporaryName_N5drake6schema13UniformVectorILi4EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    max: numpy.ndarray[numpy.float64[4, 1]]
    min: numpy.ndarray[numpy.float64[4, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: UniformVectorT4U) -> None: ...
    @overload
    def __init__(self, min: numpy.ndarray[numpy.float64[4, 1]], max: numpy.ndarray[numpy.float64[4, 1]]) -> None: ...
    def __copy__(self) -> UniformVectorT4U: ...
    def __deepcopy__(self, arg0: dict) -> UniformVectorT4U: ...

class _TemporaryName_N5drake6schema13UniformVectorILi5EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    max: numpy.ndarray[numpy.float64[5, 1]]
    min: numpy.ndarray[numpy.float64[5, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: UniformVectorT5U) -> None: ...
    @overload
    def __init__(self, min: numpy.ndarray[numpy.float64[5, 1]], max: numpy.ndarray[numpy.float64[5, 1]]) -> None: ...
    def __copy__(self) -> UniformVectorT5U: ...
    def __deepcopy__(self, arg0: dict) -> UniformVectorT5U: ...

class _TemporaryName_N5drake6schema13UniformVectorILi6EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    max: numpy.ndarray[numpy.float64[6, 1]]
    min: numpy.ndarray[numpy.float64[6, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: UniformVectorT6U) -> None: ...
    @overload
    def __init__(self, min: numpy.ndarray[numpy.float64[6, 1]], max: numpy.ndarray[numpy.float64[6, 1]]) -> None: ...
    def __copy__(self) -> UniformVectorT6U: ...
    def __deepcopy__(self, arg0: dict) -> UniformVectorT6U: ...

class _TemporaryName_N5drake6schema13UniformVectorILin1EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    max: numpy.ndarray[numpy.float64[m, 1]]
    min: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: UniformVectorTNoneU) -> None: ...
    @overload
    def __init__(self, min: numpy.ndarray[numpy.float64[m, 1]], max: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> UniformVectorTNoneU: ...
    def __deepcopy__(self, arg0: dict) -> UniformVectorTNoneU: ...

class _TemporaryName_N5drake6schema14GaussianVectorILi1EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    mean: numpy.ndarray[numpy.float64[1, 1]]
    stddev: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GaussianVectorT1U) -> None: ...
    @overload
    def __init__(self, mean: numpy.ndarray[numpy.float64[1, 1]], stddev: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> GaussianVectorT1U: ...
    def __deepcopy__(self, arg0: dict) -> GaussianVectorT1U: ...

class _TemporaryName_N5drake6schema14GaussianVectorILi2EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    mean: numpy.ndarray[numpy.float64[2, 1]]
    stddev: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GaussianVectorT2U) -> None: ...
    @overload
    def __init__(self, mean: numpy.ndarray[numpy.float64[2, 1]], stddev: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> GaussianVectorT2U: ...
    def __deepcopy__(self, arg0: dict) -> GaussianVectorT2U: ...

class _TemporaryName_N5drake6schema14GaussianVectorILi3EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    mean: numpy.ndarray[numpy.float64[3, 1]]
    stddev: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GaussianVectorT3U) -> None: ...
    @overload
    def __init__(self, mean: numpy.ndarray[numpy.float64[3, 1]], stddev: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> GaussianVectorT3U: ...
    def __deepcopy__(self, arg0: dict) -> GaussianVectorT3U: ...

class _TemporaryName_N5drake6schema14GaussianVectorILi4EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    mean: numpy.ndarray[numpy.float64[4, 1]]
    stddev: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GaussianVectorT4U) -> None: ...
    @overload
    def __init__(self, mean: numpy.ndarray[numpy.float64[4, 1]], stddev: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> GaussianVectorT4U: ...
    def __deepcopy__(self, arg0: dict) -> GaussianVectorT4U: ...

class _TemporaryName_N5drake6schema14GaussianVectorILi5EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    mean: numpy.ndarray[numpy.float64[5, 1]]
    stddev: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GaussianVectorT5U) -> None: ...
    @overload
    def __init__(self, mean: numpy.ndarray[numpy.float64[5, 1]], stddev: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> GaussianVectorT5U: ...
    def __deepcopy__(self, arg0: dict) -> GaussianVectorT5U: ...

class _TemporaryName_N5drake6schema14GaussianVectorILi6EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    mean: numpy.ndarray[numpy.float64[6, 1]]
    stddev: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GaussianVectorT6U) -> None: ...
    @overload
    def __init__(self, mean: numpy.ndarray[numpy.float64[6, 1]], stddev: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> GaussianVectorT6U: ...
    def __deepcopy__(self, arg0: dict) -> GaussianVectorT6U: ...

class _TemporaryName_N5drake6schema14GaussianVectorILin1EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    mean: numpy.ndarray[numpy.float64[m, 1]]
    stddev: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: GaussianVectorTNoneU) -> None: ...
    @overload
    def __init__(self, mean: numpy.ndarray[numpy.float64[m, 1]], stddev: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> GaussianVectorTNoneU: ...
    def __deepcopy__(self, arg0: dict) -> GaussianVectorTNoneU: ...

class _TemporaryName_N5drake6schema19DeterministicVectorILi1EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    value: numpy.ndarray[numpy.float64[1, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: DeterministicVectorT1U) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[1, 1]]) -> None: ...
    def __copy__(self) -> DeterministicVectorT1U: ...
    def __deepcopy__(self, arg0: dict) -> DeterministicVectorT1U: ...

class _TemporaryName_N5drake6schema19DeterministicVectorILi2EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    value: numpy.ndarray[numpy.float64[2, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: DeterministicVectorT2U) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[2, 1]]) -> None: ...
    def __copy__(self) -> DeterministicVectorT2U: ...
    def __deepcopy__(self, arg0: dict) -> DeterministicVectorT2U: ...

class _TemporaryName_N5drake6schema19DeterministicVectorILi3EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    value: numpy.ndarray[numpy.float64[3, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: DeterministicVectorT3U) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def __copy__(self) -> DeterministicVectorT3U: ...
    def __deepcopy__(self, arg0: dict) -> DeterministicVectorT3U: ...

class _TemporaryName_N5drake6schema19DeterministicVectorILi4EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    value: numpy.ndarray[numpy.float64[4, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: DeterministicVectorT4U) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[4, 1]]) -> None: ...
    def __copy__(self) -> DeterministicVectorT4U: ...
    def __deepcopy__(self, arg0: dict) -> DeterministicVectorT4U: ...

class _TemporaryName_N5drake6schema19DeterministicVectorILi5EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    value: numpy.ndarray[numpy.float64[5, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: DeterministicVectorT5U) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[5, 1]]) -> None: ...
    def __copy__(self) -> DeterministicVectorT5U: ...
    def __deepcopy__(self, arg0: dict) -> DeterministicVectorT5U: ...

class _TemporaryName_N5drake6schema19DeterministicVectorILi6EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    value: numpy.ndarray[numpy.float64[6, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: DeterministicVectorT6U) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[6, 1]]) -> None: ...
    def __copy__(self) -> DeterministicVectorT6U: ...
    def __deepcopy__(self, arg0: dict) -> DeterministicVectorT6U: ...

class _TemporaryName_N5drake6schema19DeterministicVectorILin1EEE(DistributionVector):
    __fields__: ClassVar[tuple] = ...  # read-only
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    value: numpy.ndarray[numpy.float64[m, 1]]
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: DeterministicVectorTNoneU) -> None: ...
    @overload
    def __init__(self, value: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    def __copy__(self) -> DeterministicVectorTNoneU: ...
    def __deepcopy__(self, arg0: dict) -> DeterministicVectorTNoneU: ...

@overload
def GetDeterministicValue(var: float | Deterministic | Gaussian | Uniform | UniformDiscrete) -> float: ...
@overload
def GetDeterministicValue(vec: numpy.ndarray[numpy.float64[m, 1]] | DeterministicVectorTNoneU | GaussianVectorTNoneU | UniformVectorTNoneU | Deterministic | Gaussian | Uniform) -> numpy.ndarray[numpy.float64[m, 1]]: ...
@overload
def GetDeterministicValue(vec: numpy.ndarray[numpy.float64[1, 1]] | DeterministicVectorT1U | GaussianVectorT1U | UniformVectorT1U | Deterministic | Gaussian | Uniform) -> numpy.ndarray[numpy.float64[m, 1]]: ...
@overload
def GetDeterministicValue(vec: numpy.ndarray[numpy.float64[2, 1]] | DeterministicVectorT2U | GaussianVectorT2U | UniformVectorT2U | _InvalidVariantSelectionDeterministic | _InvalidVariantSelectionGaussian | _InvalidVariantSelectionUniform) -> numpy.ndarray[numpy.float64[m, 1]]: ...
@overload
def GetDeterministicValue(vec: numpy.ndarray[numpy.float64[3, 1]] | DeterministicVectorT3U | GaussianVectorT3U | UniformVectorT3U | _InvalidVariantSelectionDeterministic | _InvalidVariantSelectionGaussian | _InvalidVariantSelectionUniform) -> numpy.ndarray[numpy.float64[m, 1]]: ...
@overload
def GetDeterministicValue(vec: numpy.ndarray[numpy.float64[4, 1]] | DeterministicVectorT4U | GaussianVectorT4U | UniformVectorT4U | _InvalidVariantSelectionDeterministic | _InvalidVariantSelectionGaussian | _InvalidVariantSelectionUniform) -> numpy.ndarray[numpy.float64[m, 1]]: ...
@overload
def GetDeterministicValue(vec: numpy.ndarray[numpy.float64[5, 1]] | DeterministicVectorT5U | GaussianVectorT5U | UniformVectorT5U | _InvalidVariantSelectionDeterministic | _InvalidVariantSelectionGaussian | _InvalidVariantSelectionUniform) -> numpy.ndarray[numpy.float64[m, 1]]: ...
@overload
def GetDeterministicValue(vec: numpy.ndarray[numpy.float64[6, 1]] | DeterministicVectorT6U | GaussianVectorT6U | UniformVectorT6U | _InvalidVariantSelectionDeterministic | _InvalidVariantSelectionGaussian | _InvalidVariantSelectionUniform) -> numpy.ndarray[numpy.float64[m, 1]]: ...
@overload
def IsDeterministic(var: float | Deterministic | Gaussian | Uniform | UniformDiscrete) -> bool: ...
@overload
def IsDeterministic(vec: numpy.ndarray[numpy.float64[m, 1]] | DeterministicVectorTNoneU | GaussianVectorTNoneU | UniformVectorTNoneU | Deterministic | Gaussian | Uniform) -> bool: ...
def Mean(var: float | Deterministic | Gaussian | Uniform | UniformDiscrete) -> float: ...
def Sample(var: float | Deterministic | Gaussian | Uniform | UniformDiscrete, generator: pydrake.common.RandomGenerator) -> float: ...
def ToDistribution(var: float | Deterministic | Gaussian | Uniform | UniformDiscrete) -> Distribution: ...
@overload
def ToDistributionVector(vec: numpy.ndarray[numpy.float64[m, 1]] | DeterministicVectorTNoneU | GaussianVectorTNoneU | UniformVectorTNoneU | Deterministic | Gaussian | Uniform) -> DistributionVector: ...
@overload
def ToDistributionVector(vec: numpy.ndarray[numpy.float64[1, 1]] | DeterministicVectorT1U | GaussianVectorT1U | UniformVectorT1U | Deterministic | Gaussian | Uniform) -> DistributionVector: ...
@overload
def ToDistributionVector(vec: numpy.ndarray[numpy.float64[2, 1]] | DeterministicVectorT2U | GaussianVectorT2U | UniformVectorT2U | _InvalidVariantSelectionDeterministic | _InvalidVariantSelectionGaussian | _InvalidVariantSelectionUniform) -> DistributionVector: ...
@overload
def ToDistributionVector(vec: numpy.ndarray[numpy.float64[3, 1]] | DeterministicVectorT3U | GaussianVectorT3U | UniformVectorT3U | _InvalidVariantSelectionDeterministic | _InvalidVariantSelectionGaussian | _InvalidVariantSelectionUniform) -> DistributionVector: ...
@overload
def ToDistributionVector(vec: numpy.ndarray[numpy.float64[4, 1]] | DeterministicVectorT4U | GaussianVectorT4U | UniformVectorT4U | _InvalidVariantSelectionDeterministic | _InvalidVariantSelectionGaussian | _InvalidVariantSelectionUniform) -> DistributionVector: ...
@overload
def ToDistributionVector(vec: numpy.ndarray[numpy.float64[5, 1]] | DeterministicVectorT5U | GaussianVectorT5U | UniformVectorT5U | _InvalidVariantSelectionDeterministic | _InvalidVariantSelectionGaussian | _InvalidVariantSelectionUniform) -> DistributionVector: ...
@overload
def ToDistributionVector(vec: numpy.ndarray[numpy.float64[6, 1]] | DeterministicVectorT6U | GaussianVectorT6U | UniformVectorT6U | _InvalidVariantSelectionDeterministic | _InvalidVariantSelectionGaussian | _InvalidVariantSelectionUniform) -> DistributionVector: ...
def ToSymbolic(var: float | Deterministic | Gaussian | Uniform | UniformDiscrete) -> pydrake.symbolic.Expression: ...
