import numpy
import pydrake.autodiffutils
import pydrake.symbolic
from _typeshed import Incomplete
from pydrake.common.cpp_template import AngleAxis_ as AngleAxis_, Isometry3_ as Isometry3_, Quaternion_ as Quaternion_
from typing import Callable, ClassVar, overload

__getattr__: Callable

class AngleAxis:
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, angle: float, axis: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    @overload
    def __init__(self, quaternion: Quaternion) -> None: ...
    @overload
    def __init__(self, rotation: numpy.ndarray[numpy.float64[3, 3]]) -> None: ...
    @overload
    def __init__(self, other: AngleAxis) -> None: ...
    @staticmethod
    def Identity() -> AngleAxis: ...
    def angle(self) -> float: ...
    def axis(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def cast𝓣AutoDiffXd𝓤(self, *args, **kwargs): ...
    def cast𝓣Expression𝓤(self, *args, **kwargs): ...
    def cast𝓣float𝓤(self) -> AngleAxis: ...
    def inverse(self) -> AngleAxis: ...
    def multiply(self, other: AngleAxis) -> Quaternion: ...
    def quaternion(self) -> Quaternion: ...
    def rotation(self) -> numpy.ndarray[numpy.float64[3, 3]]: ...
    def set_angle(self, angle: float) -> None: ...
    def set_axis(self, axis: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def set_quaternion(self, q: Quaternion) -> None: ...
    def set_rotation(self, rotation: numpy.ndarray[numpy.float64[3, 3]]) -> None: ...
    def __copy__(self) -> AngleAxis: ...
    def __deepcopy__(self, arg0: dict) -> AngleAxis: ...
    def __matmul__(self, *args, **kwargs): ...

class AngleAxis_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, angle: pydrake.autodiffutils.AutoDiffXd, axis: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, quaternion: Quaternion_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, rotation: numpy.ndarray[object[3, 3]]) -> None: ...
    @overload
    def __init__(self, other: AngleAxis_TAutoDiffXdU) -> None: ...
    @staticmethod
    def Identity() -> AngleAxis_TAutoDiffXdU: ...
    def angle(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def axis(self) -> numpy.ndarray[object[3, 1]]: ...
    def cast𝓣AutoDiffXd𝓤(self) -> AngleAxis_TAutoDiffXdU: ...
    def inverse(self) -> AngleAxis_TAutoDiffXdU: ...
    def multiply(self, other: AngleAxis_TAutoDiffXdU) -> Quaternion_TAutoDiffXdU: ...
    def quaternion(self) -> Quaternion_TAutoDiffXdU: ...
    def rotation(self) -> numpy.ndarray[object[3, 3]]: ...
    def set_angle(self, angle: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def set_axis(self, axis: numpy.ndarray[object[3, 1]]) -> None: ...
    def set_quaternion(self, q: Quaternion_TAutoDiffXdU) -> None: ...
    def set_rotation(self, rotation: numpy.ndarray[object[3, 3]]) -> None: ...
    def __copy__(self) -> AngleAxis_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> AngleAxis_TAutoDiffXdU: ...
    def __matmul__(self, *args, **kwargs): ...

class AngleAxis_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, angle: pydrake.symbolic.Expression, axis: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, quaternion: Quaternion_TExpressionU) -> None: ...
    @overload
    def __init__(self, rotation: numpy.ndarray[object[3, 3]]) -> None: ...
    @overload
    def __init__(self, other: AngleAxis_TExpressionU) -> None: ...
    @staticmethod
    def Identity() -> AngleAxis_TExpressionU: ...
    def angle(self) -> pydrake.symbolic.Expression: ...
    def axis(self) -> numpy.ndarray[object[3, 1]]: ...
    def cast𝓣Expression𝓤(self) -> AngleAxis_TExpressionU: ...
    def inverse(self) -> AngleAxis_TExpressionU: ...
    def multiply(self, other: AngleAxis_TExpressionU) -> Quaternion_TExpressionU: ...
    def quaternion(self) -> Quaternion_TExpressionU: ...
    def rotation(self) -> numpy.ndarray[object[3, 3]]: ...
    def set_angle(self, angle: pydrake.symbolic.Expression) -> None: ...
    def set_axis(self, axis: numpy.ndarray[object[3, 1]]) -> None: ...
    def set_quaternion(self, q: Quaternion_TExpressionU) -> None: ...
    def set_rotation(self, rotation: numpy.ndarray[object[3, 3]]) -> None: ...
    def __copy__(self) -> AngleAxis_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> AngleAxis_TExpressionU: ...
    def __matmul__(self, *args, **kwargs): ...

class Isometry3:
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, matrix: numpy.ndarray[numpy.float64[4, 4]]) -> None: ...
    @overload
    def __init__(self, rotation: numpy.ndarray[numpy.float64[3, 3]], translation: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    @overload
    def __init__(self, other: Isometry3) -> None: ...
    @staticmethod
    def Identity() -> Isometry3: ...
    def cast𝓣AutoDiffXd𝓤(self, *args, **kwargs): ...
    def cast𝓣Expression𝓤(self, *args, **kwargs): ...
    def cast𝓣float𝓤(self) -> Isometry3: ...
    def inverse(self) -> Isometry3: ...
    def matrix(self) -> numpy.ndarray[numpy.float64[4, 4]]: ...
    def quaternion(self, *args, **kwargs): ...
    def rotation(self) -> numpy.ndarray[numpy.float64[3, 3]]: ...
    def set_matrix(self, arg0: numpy.ndarray[numpy.float64[4, 4]]) -> None: ...
    def set_quaternion(self, *args, **kwargs): ...
    def set_rotation(self, arg0: numpy.ndarray[numpy.float64[3, 3]]) -> None: ...
    def set_translation(self, arg0: numpy.ndarray[numpy.float64[3, 1]]) -> None: ...
    def translation(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def __copy__(self) -> Isometry3: ...
    def __deepcopy__(self, arg0: dict) -> Isometry3: ...

class Isometry3_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, matrix: numpy.ndarray[object[4, 4]]) -> None: ...
    @overload
    def __init__(self, rotation: numpy.ndarray[object[3, 3]], translation: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, other: Isometry3_TAutoDiffXdU) -> None: ...
    @staticmethod
    def Identity() -> Isometry3_TAutoDiffXdU: ...
    def cast𝓣AutoDiffXd𝓤(self) -> Isometry3_TAutoDiffXdU: ...
    def inverse(self) -> Isometry3_TAutoDiffXdU: ...
    def matrix(self) -> numpy.ndarray[object[4, 4]]: ...
    def quaternion(self, *args, **kwargs): ...
    def rotation(self) -> numpy.ndarray[object[3, 3]]: ...
    def set_matrix(self, arg0: numpy.ndarray[object[4, 4]]) -> None: ...
    def set_quaternion(self, *args, **kwargs): ...
    def set_rotation(self, arg0: numpy.ndarray[object[3, 3]]) -> None: ...
    def set_translation(self, arg0: numpy.ndarray[object[3, 1]]) -> None: ...
    def translation(self) -> numpy.ndarray[object[3, 1]]: ...
    def __copy__(self) -> Isometry3_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> Isometry3_TAutoDiffXdU: ...

class Isometry3_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, matrix: numpy.ndarray[object[4, 4]]) -> None: ...
    @overload
    def __init__(self, rotation: numpy.ndarray[object[3, 3]], translation: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, other: Isometry3_TExpressionU) -> None: ...
    @staticmethod
    def Identity() -> Isometry3_TExpressionU: ...
    def cast𝓣Expression𝓤(self) -> Isometry3_TExpressionU: ...
    def inverse(self) -> Isometry3_TExpressionU: ...
    def matrix(self) -> numpy.ndarray[object[4, 4]]: ...
    def quaternion(self, *args, **kwargs): ...
    def rotation(self) -> numpy.ndarray[object[3, 3]]: ...
    def set_matrix(self, arg0: numpy.ndarray[object[4, 4]]) -> None: ...
    def set_quaternion(self, *args, **kwargs): ...
    def set_rotation(self, arg0: numpy.ndarray[object[3, 3]]) -> None: ...
    def set_translation(self, arg0: numpy.ndarray[object[3, 1]]) -> None: ...
    def translation(self) -> numpy.ndarray[object[3, 1]]: ...
    def __copy__(self) -> Isometry3_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> Isometry3_TExpressionU: ...

class Quaternion:
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, wxyz: numpy.ndarray[numpy.float64[4, 1]]) -> None: ...
    @overload
    def __init__(self, w: float, x: float, y: float, z: float) -> None: ...
    @overload
    def __init__(self, rotation: numpy.ndarray[numpy.float64[3, 3]]) -> None: ...
    @overload
    def __init__(self, other: Quaternion) -> None: ...
    @staticmethod
    def Identity() -> Quaternion: ...
    def cast𝓣AutoDiffXd𝓤(self, *args, **kwargs): ...
    def cast𝓣Expression𝓤(self, *args, **kwargs): ...
    def cast𝓣float𝓤(self) -> Quaternion: ...
    def conjugate(self) -> Quaternion: ...
    def inverse(self) -> Quaternion: ...
    def rotation(self) -> numpy.ndarray[numpy.float64[3, 3]]: ...
    def set_rotation(self, arg0: numpy.ndarray[numpy.float64[3, 3]]) -> None: ...
    @overload
    def set_wxyz(self, wxyz: numpy.ndarray[numpy.float64[4, 1]]) -> None: ...
    @overload
    def set_wxyz(self, w: float, x: float, y: float, z: float) -> None: ...
    def slerp(self, t: float, other: Quaternion) -> Quaternion: ...
    def w(self) -> float: ...
    def wxyz(self) -> numpy.ndarray[numpy.float64[4, 1]]: ...
    def x(self) -> float: ...
    def xyz(self) -> numpy.ndarray[numpy.float64[3, 1]]: ...
    def y(self) -> float: ...
    def z(self) -> float: ...
    def __copy__(self) -> Quaternion: ...
    def __deepcopy__(self, arg0: dict) -> Quaternion: ...

class Quaternion_𝓣AutoDiffXd𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, wxyz: numpy.ndarray[object[4, 1]]) -> None: ...
    @overload
    def __init__(self, w: pydrake.autodiffutils.AutoDiffXd, x: pydrake.autodiffutils.AutoDiffXd, y: pydrake.autodiffutils.AutoDiffXd, z: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    @overload
    def __init__(self, rotation: numpy.ndarray[object[3, 3]]) -> None: ...
    @overload
    def __init__(self, other: Quaternion_TAutoDiffXdU) -> None: ...
    @staticmethod
    def Identity() -> Quaternion_TAutoDiffXdU: ...
    def cast𝓣AutoDiffXd𝓤(self) -> Quaternion_TAutoDiffXdU: ...
    def conjugate(self) -> Quaternion_TAutoDiffXdU: ...
    def inverse(self) -> Quaternion_TAutoDiffXdU: ...
    def rotation(self) -> numpy.ndarray[object[3, 3]]: ...
    def set_rotation(self, arg0: numpy.ndarray[object[3, 3]]) -> None: ...
    @overload
    def set_wxyz(self, wxyz: numpy.ndarray[object[4, 1]]) -> None: ...
    @overload
    def set_wxyz(self, w: pydrake.autodiffutils.AutoDiffXd, x: pydrake.autodiffutils.AutoDiffXd, y: pydrake.autodiffutils.AutoDiffXd, z: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def slerp(self, t: float, other: Quaternion_TAutoDiffXdU) -> Quaternion_TAutoDiffXdU: ...
    def w(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def wxyz(self) -> numpy.ndarray[object[4, 1]]: ...
    def x(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def xyz(self) -> numpy.ndarray[object[3, 1]]: ...
    def y(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def z(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def __copy__(self) -> Quaternion_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> Quaternion_TAutoDiffXdU: ...

class Quaternion_𝓣Expression𝓤:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, wxyz: numpy.ndarray[object[4, 1]]) -> None: ...
    @overload
    def __init__(self, w: pydrake.symbolic.Expression, x: pydrake.symbolic.Expression, y: pydrake.symbolic.Expression, z: pydrake.symbolic.Expression) -> None: ...
    @overload
    def __init__(self, rotation: numpy.ndarray[object[3, 3]]) -> None: ...
    @overload
    def __init__(self, other: Quaternion_TExpressionU) -> None: ...
    @staticmethod
    def Identity() -> Quaternion_TExpressionU: ...
    def cast𝓣Expression𝓤(self) -> Quaternion_TExpressionU: ...
    def conjugate(self) -> Quaternion_TExpressionU: ...
    def inverse(self) -> Quaternion_TExpressionU: ...
    def rotation(self) -> numpy.ndarray[object[3, 3]]: ...
    def set_rotation(self, arg0: numpy.ndarray[object[3, 3]]) -> None: ...
    @overload
    def set_wxyz(self, wxyz: numpy.ndarray[object[4, 1]]) -> None: ...
    @overload
    def set_wxyz(self, w: pydrake.symbolic.Expression, x: pydrake.symbolic.Expression, y: pydrake.symbolic.Expression, z: pydrake.symbolic.Expression) -> None: ...
    def slerp(self, t: float, other: Quaternion_TExpressionU) -> Quaternion_TExpressionU: ...
    def w(self) -> pydrake.symbolic.Expression: ...
    def wxyz(self) -> numpy.ndarray[object[4, 1]]: ...
    def x(self) -> pydrake.symbolic.Expression: ...
    def xyz(self) -> numpy.ndarray[object[3, 1]]: ...
    def y(self) -> pydrake.symbolic.Expression: ...
    def z(self) -> pydrake.symbolic.Expression: ...
    def __copy__(self) -> Quaternion_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> Quaternion_TExpressionU: ...

class _TemporaryName_N5Eigen10QuaternionIN5drake8symbolic10ExpressionELi0EEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, wxyz: numpy.ndarray[object[4, 1]]) -> None: ...
    @overload
    def __init__(self, w: pydrake.symbolic.Expression, x: pydrake.symbolic.Expression, y: pydrake.symbolic.Expression, z: pydrake.symbolic.Expression) -> None: ...
    @overload
    def __init__(self, rotation: numpy.ndarray[object[3, 3]]) -> None: ...
    @overload
    def __init__(self, other: Quaternion_TExpressionU) -> None: ...
    @staticmethod
    def Identity() -> Quaternion_TExpressionU: ...
    def cast𝓣Expression𝓤(self) -> Quaternion_TExpressionU: ...
    def conjugate(self) -> Quaternion_TExpressionU: ...
    def inverse(self) -> Quaternion_TExpressionU: ...
    def rotation(self) -> numpy.ndarray[object[3, 3]]: ...
    def set_rotation(self, arg0: numpy.ndarray[object[3, 3]]) -> None: ...
    @overload
    def set_wxyz(self, wxyz: numpy.ndarray[object[4, 1]]) -> None: ...
    @overload
    def set_wxyz(self, w: pydrake.symbolic.Expression, x: pydrake.symbolic.Expression, y: pydrake.symbolic.Expression, z: pydrake.symbolic.Expression) -> None: ...
    def slerp(self, t: float, other: Quaternion_TExpressionU) -> Quaternion_TExpressionU: ...
    def w(self) -> pydrake.symbolic.Expression: ...
    def wxyz(self) -> numpy.ndarray[object[4, 1]]: ...
    def x(self) -> pydrake.symbolic.Expression: ...
    def xyz(self) -> numpy.ndarray[object[3, 1]]: ...
    def y(self) -> pydrake.symbolic.Expression: ...
    def z(self) -> pydrake.symbolic.Expression: ...
    def __copy__(self) -> Quaternion_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> Quaternion_TExpressionU: ...

class _TemporaryName_N5Eigen10QuaternionINS_14AutoDiffScalarINS_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEELi0EEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, wxyz: numpy.ndarray[object[4, 1]]) -> None: ...
    @overload
    def __init__(self, w: pydrake.autodiffutils.AutoDiffXd, x: pydrake.autodiffutils.AutoDiffXd, y: pydrake.autodiffutils.AutoDiffXd, z: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    @overload
    def __init__(self, rotation: numpy.ndarray[object[3, 3]]) -> None: ...
    @overload
    def __init__(self, other: Quaternion_TAutoDiffXdU) -> None: ...
    @staticmethod
    def Identity() -> Quaternion_TAutoDiffXdU: ...
    def cast𝓣AutoDiffXd𝓤(self) -> Quaternion_TAutoDiffXdU: ...
    def conjugate(self) -> Quaternion_TAutoDiffXdU: ...
    def inverse(self) -> Quaternion_TAutoDiffXdU: ...
    def rotation(self) -> numpy.ndarray[object[3, 3]]: ...
    def set_rotation(self, arg0: numpy.ndarray[object[3, 3]]) -> None: ...
    @overload
    def set_wxyz(self, wxyz: numpy.ndarray[object[4, 1]]) -> None: ...
    @overload
    def set_wxyz(self, w: pydrake.autodiffutils.AutoDiffXd, x: pydrake.autodiffutils.AutoDiffXd, y: pydrake.autodiffutils.AutoDiffXd, z: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def slerp(self, t: float, other: Quaternion_TAutoDiffXdU) -> Quaternion_TAutoDiffXdU: ...
    def w(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def wxyz(self) -> numpy.ndarray[object[4, 1]]: ...
    def x(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def xyz(self) -> numpy.ndarray[object[3, 1]]: ...
    def y(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def z(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def __copy__(self) -> Quaternion_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> Quaternion_TAutoDiffXdU: ...

class _TemporaryName_N5Eigen9AngleAxisIN5drake8symbolic10ExpressionEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, angle: pydrake.symbolic.Expression, axis: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, quaternion: Quaternion_TExpressionU) -> None: ...
    @overload
    def __init__(self, rotation: numpy.ndarray[object[3, 3]]) -> None: ...
    @overload
    def __init__(self, other: AngleAxis_TExpressionU) -> None: ...
    @staticmethod
    def Identity() -> AngleAxis_TExpressionU: ...
    def angle(self) -> pydrake.symbolic.Expression: ...
    def axis(self) -> numpy.ndarray[object[3, 1]]: ...
    def cast𝓣Expression𝓤(self) -> AngleAxis_TExpressionU: ...
    def inverse(self) -> AngleAxis_TExpressionU: ...
    def multiply(self, other: AngleAxis_TExpressionU) -> Quaternion_TExpressionU: ...
    def quaternion(self) -> Quaternion_TExpressionU: ...
    def rotation(self) -> numpy.ndarray[object[3, 3]]: ...
    def set_angle(self, angle: pydrake.symbolic.Expression) -> None: ...
    def set_axis(self, axis: numpy.ndarray[object[3, 1]]) -> None: ...
    def set_quaternion(self, q: Quaternion_TExpressionU) -> None: ...
    def set_rotation(self, rotation: numpy.ndarray[object[3, 3]]) -> None: ...
    def __copy__(self) -> AngleAxis_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> AngleAxis_TExpressionU: ...
    def __matmul__(self, *args, **kwargs): ...

class _TemporaryName_N5Eigen9AngleAxisINS_14AutoDiffScalarINS_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEEEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, angle: pydrake.autodiffutils.AutoDiffXd, axis: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, quaternion: Quaternion_TAutoDiffXdU) -> None: ...
    @overload
    def __init__(self, rotation: numpy.ndarray[object[3, 3]]) -> None: ...
    @overload
    def __init__(self, other: AngleAxis_TAutoDiffXdU) -> None: ...
    @staticmethod
    def Identity() -> AngleAxis_TAutoDiffXdU: ...
    def angle(self) -> pydrake.autodiffutils.AutoDiffXd: ...
    def axis(self) -> numpy.ndarray[object[3, 1]]: ...
    def cast𝓣AutoDiffXd𝓤(self) -> AngleAxis_TAutoDiffXdU: ...
    def inverse(self) -> AngleAxis_TAutoDiffXdU: ...
    def multiply(self, other: AngleAxis_TAutoDiffXdU) -> Quaternion_TAutoDiffXdU: ...
    def quaternion(self) -> Quaternion_TAutoDiffXdU: ...
    def rotation(self) -> numpy.ndarray[object[3, 3]]: ...
    def set_angle(self, angle: pydrake.autodiffutils.AutoDiffXd) -> None: ...
    def set_axis(self, axis: numpy.ndarray[object[3, 1]]) -> None: ...
    def set_quaternion(self, q: Quaternion_TAutoDiffXdU) -> None: ...
    def set_rotation(self, rotation: numpy.ndarray[object[3, 3]]) -> None: ...
    def __copy__(self) -> AngleAxis_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> AngleAxis_TAutoDiffXdU: ...
    def __matmul__(self, *args, **kwargs): ...

class _TemporaryName_N5Eigen9TransformIN5drake8symbolic10ExpressionELi3ELi1ELi0EEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, matrix: numpy.ndarray[object[4, 4]]) -> None: ...
    @overload
    def __init__(self, rotation: numpy.ndarray[object[3, 3]], translation: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, other: Isometry3_TExpressionU) -> None: ...
    @staticmethod
    def Identity() -> Isometry3_TExpressionU: ...
    def cast𝓣Expression𝓤(self) -> Isometry3_TExpressionU: ...
    def inverse(self) -> Isometry3_TExpressionU: ...
    def matrix(self) -> numpy.ndarray[object[4, 4]]: ...
    def quaternion(self, *args, **kwargs): ...
    def rotation(self) -> numpy.ndarray[object[3, 3]]: ...
    def set_matrix(self, arg0: numpy.ndarray[object[4, 4]]) -> None: ...
    def set_quaternion(self, *args, **kwargs): ...
    def set_rotation(self, arg0: numpy.ndarray[object[3, 3]]) -> None: ...
    def set_translation(self, arg0: numpy.ndarray[object[3, 1]]) -> None: ...
    def translation(self) -> numpy.ndarray[object[3, 1]]: ...
    def __copy__(self) -> Isometry3_TExpressionU: ...
    def __deepcopy__(self, arg0: dict) -> Isometry3_TExpressionU: ...

class _TemporaryName_N5Eigen9TransformINS_14AutoDiffScalarINS_6MatrixIdLin1ELi1ELi0ELin1ELi1EEEEELi3ELi1ELi0EEE:
    _original_name: ClassVar[str] = ...
    _original_qualname: ClassVar[str] = ...
    multiply: ClassVar[Callable] = ...
    __matmul__: ClassVar[Callable] = ...
    cast: Incomplete
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, matrix: numpy.ndarray[object[4, 4]]) -> None: ...
    @overload
    def __init__(self, rotation: numpy.ndarray[object[3, 3]], translation: numpy.ndarray[object[3, 1]]) -> None: ...
    @overload
    def __init__(self, other: Isometry3_TAutoDiffXdU) -> None: ...
    @staticmethod
    def Identity() -> Isometry3_TAutoDiffXdU: ...
    def cast𝓣AutoDiffXd𝓤(self) -> Isometry3_TAutoDiffXdU: ...
    def inverse(self) -> Isometry3_TAutoDiffXdU: ...
    def matrix(self) -> numpy.ndarray[object[4, 4]]: ...
    def quaternion(self, *args, **kwargs): ...
    def rotation(self) -> numpy.ndarray[object[3, 3]]: ...
    def set_matrix(self, arg0: numpy.ndarray[object[4, 4]]) -> None: ...
    def set_quaternion(self, *args, **kwargs): ...
    def set_rotation(self, arg0: numpy.ndarray[object[3, 3]]) -> None: ...
    def set_translation(self, arg0: numpy.ndarray[object[3, 1]]) -> None: ...
    def translation(self) -> numpy.ndarray[object[3, 1]]: ...
    def __copy__(self) -> Isometry3_TAutoDiffXdU: ...
    def __deepcopy__(self, arg0: dict) -> Isometry3_TAutoDiffXdU: ...
