import numpy
import os
import pydrake.autodiffutils
from . import eigen_geometry as eigen_geometry, schema as schema, value as value
from typing import Any, Callable, ClassVar, overload

configure_logging: Callable
kDrakeAssertIsArmed: bool
pretty_class_name: Callable
use_native_cpp_logging: Callable

class MemoryFile:
    __fields__: ClassVar[tuple] = ...  # read-only
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, contents: str, extension: str, filename_hint: str) -> None: ...
    @staticmethod
    def Make(path: os.PathLike) -> MemoryFile: ...
    def contents(self) -> bytes: ...
    @overload
    def extension(self) -> str: ...
    @overload
    def extension(self, aspassedtotheconstructor) -> Any: ...
    def filename_hint(self) -> str: ...
    def sha256(self) -> Sha256: ...
    def __copy__(self) -> MemoryFile: ...
    def __deepcopy__(self, arg0: dict) -> MemoryFile: ...
    def __setattr__(self, arg0: str, arg1: object) -> None: ...

class Parallelism:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, parallelize: bool) -> None: ...
    @overload
    def __init__(self, num_threads: int) -> None: ...
    @staticmethod
    def Max() -> Parallelism: ...
    def num_threads(self) -> int: ...
    def __copy__(self) -> Parallelism: ...
    def __deepcopy__(self, arg0: dict) -> Parallelism: ...

class RandomDistribution:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kExponential: ClassVar[RandomDistribution] = ...
    kGaussian: ClassVar[RandomDistribution] = ...
    kUniform: ClassVar[RandomDistribution] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class RandomGenerator:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, seed: int) -> None: ...
    def __call__(self) -> int: ...

class Sha256:
    def __init__(self) -> None: ...
    @staticmethod
    def Checksum(arg0: str) -> Sha256: ...
    @staticmethod
    def Parse(arg0: str) -> Sha256 | None: ...
    def to_string(self) -> str: ...
    def __copy__(self) -> Sha256: ...
    def __deepcopy__(self, arg0: dict) -> Sha256: ...
    def __eq__(self, arg0: Sha256) -> bool: ...
    def __lt__(self, arg0: Sha256) -> bool: ...
    def __ne__(self, arg0: Sha256) -> bool: ...

class ToleranceType:
    __members__: ClassVar[dict] = ...  # read-only
    __entries: ClassVar[dict] = ...
    kAbsolute: ClassVar[ToleranceType] = ...
    kRelative: ClassVar[ToleranceType] = ...
    def __init__(self, value: int) -> None: ...
    def __eq__(self, other: object) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __ne__(self, other: object) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def value(self) -> int: ...

class _MangledName:
    UNICODE_COMMA: ClassVar[str] = ...
    UNICODE_LEFT_BRACKET: ClassVar[str] = ...
    UNICODE_PERIOD: ClassVar[str] = ...
    UNICODE_RIGHT_BRACKET: ClassVar[str] = ...
    demangle: ClassVar[Callable] = ...
    mangle: ClassVar[Callable] = ...
    module_getattr: ClassVar[Callable] = ...

@overload
def CalcProbabilityDensity(distribution: RandomDistribution, x: numpy.ndarray[numpy.float64[m, 1]]) -> float: ...
@overload
def CalcProbabilityDensity(distribution: RandomDistribution, x: numpy.ndarray[object[m, 1]]) -> pydrake.autodiffutils.AutoDiffXd: ...
def FindResourceOrThrow(resource_path: str) -> str: ...
def GetDrakePath() -> object: ...
def temp_directory() -> str: ...
def trigger_an_assertion_failure() -> None: ...
