import numpy
from typing import Any, Callable, overload

InitializeAutoDiffTuple: Callable

class AutoDiffXd:
    @overload
    def __init__(self, value: float) -> None: ...
    @overload
    def __init__(self, value: float, derivatives: numpy.ndarray[numpy.float64[m, 1]]) -> None: ...
    @overload
    def __init__(self, value: float, size: int, offset: int) -> None: ...
    def abs(self) -> AutoDiffXd: ...
    def acos(self) -> AutoDiffXd: ...
    def arccos(self, *args, **kwargs): ...
    def arcsin(self, *args, **kwargs): ...
    def arctan(self) -> AutoDiffXd: ...
    def arctan2(self, *args, **kwargs): ...
    def asin(self) -> AutoDiffXd: ...
    def atan(self) -> AutoDiffXd: ...
    @overload
    def atan2(self, x: AutoDiffXd) -> AutoDiffXd: ...
    @overload
    def atan2(self, y, x) -> Any: ...
    def ceil(self) -> float: ...
    def cos(self) -> AutoDiffXd: ...
    def cosh(self) -> AutoDiffXd: ...
    def derivatives(self) -> numpy.ndarray[numpy.float64[m, 1]]: ...
    def exp(self) -> AutoDiffXd: ...
    def floor(self) -> float: ...
    def log(self) -> AutoDiffXd: ...
    def max(self, arg0: AutoDiffXd) -> AutoDiffXd: ...
    def min(self, arg0: AutoDiffXd) -> AutoDiffXd: ...
    def pow(self, arg0: float) -> AutoDiffXd: ...
    def sin(self) -> AutoDiffXd: ...
    def sinh(self) -> AutoDiffXd: ...
    def sqrt(self) -> AutoDiffXd: ...
    def tan(self) -> AutoDiffXd: ...
    def tanh(self) -> AutoDiffXd: ...
    def value(self) -> float: ...
    @overload
    def __abs__(self) -> AutoDiffXd: ...
    @overload
    def __abs__(self) -> AutoDiffXd: ...
    @overload
    def __add__(self, arg0: AutoDiffXd) -> AutoDiffXd: ...
    @overload
    def __add__(self, arg0: float) -> AutoDiffXd: ...
    def __ceil__(self) -> float: ...
    def __copy__(self) -> AutoDiffXd: ...
    def __deepcopy__(self, arg0: dict) -> AutoDiffXd: ...
    @overload
    def __eq__(self, arg0: AutoDiffXd) -> bool: ...
    @overload
    def __eq__(self, arg0: float) -> bool: ...
    def __floor__(self) -> float: ...
    @overload
    def __ge__(self, arg0: AutoDiffXd) -> bool: ...
    @overload
    def __ge__(self, arg0: float) -> bool: ...
    @overload
    def __gt__(self, arg0: AutoDiffXd) -> bool: ...
    @overload
    def __gt__(self, arg0: float) -> bool: ...
    @overload
    def __le__(self, arg0: AutoDiffXd) -> bool: ...
    @overload
    def __le__(self, arg0: float) -> bool: ...
    @overload
    def __lt__(self, arg0: AutoDiffXd) -> bool: ...
    @overload
    def __lt__(self, arg0: float) -> bool: ...
    @overload
    def __mul__(self, arg0: AutoDiffXd) -> AutoDiffXd: ...
    @overload
    def __mul__(self, arg0: float) -> AutoDiffXd: ...
    @overload
    def __ne__(self, arg0: AutoDiffXd) -> bool: ...
    @overload
    def __ne__(self, arg0: float) -> bool: ...
    def __neg__(self) -> AutoDiffXd: ...
    def __pow__(self, arg0: float) -> AutoDiffXd: ...
    def __radd__(self, arg0: float) -> AutoDiffXd: ...
    def __rmul__(self, arg0: float) -> AutoDiffXd: ...
    def __rsub__(self, arg0: float) -> AutoDiffXd: ...
    def __rtruediv__(self, arg0: float) -> AutoDiffXd: ...
    @overload
    def __sub__(self, arg0: AutoDiffXd) -> AutoDiffXd: ...
    @overload
    def __sub__(self, arg0: float) -> AutoDiffXd: ...
    @overload
    def __truediv__(self, arg0: AutoDiffXd) -> AutoDiffXd: ...
    @overload
    def __truediv__(self, arg0: float) -> AutoDiffXd: ...

def ExtractGradient(auto_diff_matrix: numpy.ndarray[object[m, n]]) -> numpy.ndarray[numpy.float64[m, n]]: ...
@overload
def ExtractValue(auto_diff_matrix: numpy.ndarray[object[m, n]]) -> numpy.ndarray[numpy.float64[m, n]]: ...
@overload
def ExtractValue() -> Any: ...
@overload
def InitializeAutoDiff(value: numpy.ndarray[numpy.float64[m, n]], num_derivatives: int | None = ..., deriv_num_start: int | None = ...) -> numpy.ndarray[object[m, n]]: ...
@overload
def InitializeAutoDiff(value: numpy.ndarray[numpy.float64[m, n]], gradient: numpy.ndarray[numpy.float64[m, n]]) -> numpy.ndarray[object[m, n]]: ...
