"""LCM type definitions
This file automatically generated by lcm.
DO NOT MODIFY BY HAND!!!!
"""


from io import BytesIO
import struct

class lcmt_scope(object):
    """ The message type for LcmScopeSystem. """

    __slots__ = ["utime", "size", "value"]

    __typenames__ = ["int64_t", "int32_t", "double"]

    __dimensions__ = [None, None, ["size"]]

    def __init__(self):
        self.utime = 0
        """
        The timestamp in microseconds.
        LCM Type: int64_t
        """

        self.size = 0
        """
        The scoped value.
        LCM Type: int32_t
        """

        self.value = []
        """ LCM Type: double[size] """

    def encode(self):
        buf = BytesIO()
        buf.write(lcmt_scope._get_packed_fingerprint())
        self._encode_one(buf)
        return buf.getvalue()

    def _encode_one(self, buf):
        buf.write(struct.pack(">qi", self.utime, self.size))
        buf.write(struct.pack('>%dd' % self.size, *self.value[:self.size]))

    @staticmethod
    def decode(data: bytes):
        if hasattr(data, 'read'):
            buf = data
        else:
            buf = BytesIO(data)
        if buf.read(8) != lcmt_scope._get_packed_fingerprint():
            raise ValueError("Decode error")
        return lcmt_scope._decode_one(buf)

    @staticmethod
    def _decode_one(buf):
        self = lcmt_scope()
        self.utime, self.size = struct.unpack(">qi", buf.read(12))
        self.value = struct.unpack('>%dd' % self.size, buf.read(self.size * 8))
        return self

    @staticmethod
    def _get_hash_recursive(parents):
        if lcmt_scope in parents: return 0
        tmphash = (0x4806c9b395a3fbef) & 0xffffffffffffffff
        tmphash  = (((tmphash<<1)&0xffffffffffffffff) + (tmphash>>63)) & 0xffffffffffffffff
        return tmphash
    _packed_fingerprint = None

    @staticmethod
    def _get_packed_fingerprint():
        if lcmt_scope._packed_fingerprint is None:
            lcmt_scope._packed_fingerprint = struct.pack(">Q", lcmt_scope._get_hash_recursive([]))
        return lcmt_scope._packed_fingerprint

    def get_hash(self):
        """Get the LCM hash of the struct"""
        return struct.unpack(">Q", lcmt_scope._get_packed_fingerprint())[0]

