"""LCM type definitions
This file automatically generated by lcm.
DO NOT MODIFY BY HAND!!!!
"""


from io import BytesIO
import struct

class lcmt_robot_state(object):

    __slots__ = ["utime", "num_joints", "joint_name", "joint_position"]

    __typenames__ = ["int64_t", "int16_t", "string", "float"]

    __dimensions__ = [None, None, ["num_joints"], ["num_joints"]]

    def __init__(self):
        self.utime = 0
        """ LCM Type: int64_t """
        self.num_joints = 0
        """ LCM Type: int16_t """
        self.joint_name = []
        """ LCM Type: string[num_joints] """
        self.joint_position = []
        """ LCM Type: float[num_joints] """

    def encode(self):
        buf = BytesIO()
        buf.write(lcmt_robot_state._get_packed_fingerprint())
        self._encode_one(buf)
        return buf.getvalue()

    def _encode_one(self, buf):
        buf.write(struct.pack(">qh", self.utime, self.num_joints))
        for i0 in range(self.num_joints):
            __joint_name_encoded = self.joint_name[i0].encode('utf-8')
            buf.write(struct.pack('>I', len(__joint_name_encoded)+1))
            buf.write(__joint_name_encoded)
            buf.write(b"\0")
        buf.write(struct.pack('>%df' % self.num_joints, *self.joint_position[:self.num_joints]))

    @staticmethod
    def decode(data: bytes):
        if hasattr(data, 'read'):
            buf = data
        else:
            buf = BytesIO(data)
        if buf.read(8) != lcmt_robot_state._get_packed_fingerprint():
            raise ValueError("Decode error")
        return lcmt_robot_state._decode_one(buf)

    @staticmethod
    def _decode_one(buf):
        self = lcmt_robot_state()
        self.utime, self.num_joints = struct.unpack(">qh", buf.read(10))
        self.joint_name = []
        for i0 in range(self.num_joints):
            __joint_name_len = struct.unpack('>I', buf.read(4))[0]
            self.joint_name.append(buf.read(__joint_name_len)[:-1].decode('utf-8', 'replace'))
        self.joint_position = struct.unpack('>%df' % self.num_joints, buf.read(self.num_joints * 4))
        return self

    @staticmethod
    def _get_hash_recursive(parents):
        if lcmt_robot_state in parents: return 0
        tmphash = (0xc267d8b916ac5eac) & 0xffffffffffffffff
        tmphash  = (((tmphash<<1)&0xffffffffffffffff) + (tmphash>>63)) & 0xffffffffffffffff
        return tmphash
    _packed_fingerprint = None

    @staticmethod
    def _get_packed_fingerprint():
        if lcmt_robot_state._packed_fingerprint is None:
            lcmt_robot_state._packed_fingerprint = struct.pack(">Q", lcmt_robot_state._get_hash_recursive([]))
        return lcmt_robot_state._packed_fingerprint

    def get_hash(self):
        """Get the LCM hash of the struct"""
        return struct.unpack(">Q", lcmt_robot_state._get_packed_fingerprint())[0]

