"""LCM type definitions
This file automatically generated by lcm.
DO NOT MODIFY BY HAND!!!!
"""


from io import BytesIO
import struct

class lcmt_point_cloud_field(object):
    """
    Describes one field (i.e., channel) within an lcmt_point_cloud.
    
    Modeled after PCL and ROS conventions:
    https://pointclouds.org/documentation/structpcl_1_1_p_c_l_point_field.html
    https://docs.ros.org/en/api/sensor_msgs/html/msg/PointField.html
    http://wiki.ros.org/pcl/Overview#Common_PointCloud2_field_names
    
    """

    __slots__ = ["name", "byte_offset", "datatype", "count"]

    __typenames__ = ["string", "int32_t", "int8_t", "int32_t"]

    __dimensions__ = [None, None, None, None]

    INT8 = 1
    """ Allowed values for datatype. """
    UINT8 = 2
    INT16 = 3
    UINT16 = 4
    INT32 = 5
    UINT32 = 6
    FLOAT32 = 7
    FLOAT64 = 8

    def __init__(self):
        self.name = ""
        """
        Field name.
        LCM Type: string
        """

        self.byte_offset = 0
        """
        Location of this field after the start of each point's data.
        LCM Type: int32_t
        """

        self.datatype = 0
        """
        Element type, per the constants shown below.
        LCM Type: int8_t
        """

        self.count = 0
        """
        Number of elements per field.
        LCM Type: int32_t
        """


    def encode(self):
        buf = BytesIO()
        buf.write(lcmt_point_cloud_field._get_packed_fingerprint())
        self._encode_one(buf)
        return buf.getvalue()

    def _encode_one(self, buf):
        __name_encoded = self.name.encode('utf-8')
        buf.write(struct.pack('>I', len(__name_encoded)+1))
        buf.write(__name_encoded)
        buf.write(b"\0")
        buf.write(struct.pack(">ibi", self.byte_offset, self.datatype, self.count))

    @staticmethod
    def decode(data: bytes):
        if hasattr(data, 'read'):
            buf = data
        else:
            buf = BytesIO(data)
        if buf.read(8) != lcmt_point_cloud_field._get_packed_fingerprint():
            raise ValueError("Decode error")
        return lcmt_point_cloud_field._decode_one(buf)

    @staticmethod
    def _decode_one(buf):
        self = lcmt_point_cloud_field()
        __name_len = struct.unpack('>I', buf.read(4))[0]
        self.name = buf.read(__name_len)[:-1].decode('utf-8', 'replace')
        self.byte_offset, self.datatype, self.count = struct.unpack(">ibi", buf.read(9))
        return self

    @staticmethod
    def _get_hash_recursive(parents):
        if lcmt_point_cloud_field in parents: return 0
        tmphash = (0xe93146ac7d998d9f) & 0xffffffffffffffff
        tmphash  = (((tmphash<<1)&0xffffffffffffffff) + (tmphash>>63)) & 0xffffffffffffffff
        return tmphash
    _packed_fingerprint = None

    @staticmethod
    def _get_packed_fingerprint():
        if lcmt_point_cloud_field._packed_fingerprint is None:
            lcmt_point_cloud_field._packed_fingerprint = struct.pack(">Q", lcmt_point_cloud_field._get_hash_recursive([]))
        return lcmt_point_cloud_field._packed_fingerprint

    def get_hash(self):
        """Get the LCM hash of the struct"""
        return struct.unpack(">Q", lcmt_point_cloud_field._get_packed_fingerprint())[0]

