"""LCM type definitions
This file automatically generated by lcm.
DO NOT MODIFY BY HAND!!!!
"""


from io import BytesIO
import struct

class lcmt_point(object):
    """ A representation of a 3D point. """

    __slots__ = ["x", "y", "z"]

    __typenames__ = ["double", "double", "double"]

    __dimensions__ = [None, None, None]

    def __init__(self):
        self.x = 0.0
        """ LCM Type: double """
        self.y = 0.0
        """ LCM Type: double """
        self.z = 0.0
        """ LCM Type: double """

    def encode(self):
        buf = BytesIO()
        buf.write(lcmt_point._get_packed_fingerprint())
        self._encode_one(buf)
        return buf.getvalue()

    def _encode_one(self, buf):
        buf.write(struct.pack(">ddd", self.x, self.y, self.z))

    @staticmethod
    def decode(data: bytes):
        if hasattr(data, 'read'):
            buf = data
        else:
            buf = BytesIO(data)
        if buf.read(8) != lcmt_point._get_packed_fingerprint():
            raise ValueError("Decode error")
        return lcmt_point._decode_one(buf)

    @staticmethod
    def _decode_one(buf):
        self = lcmt_point()
        self.x, self.y, self.z = struct.unpack(">ddd", buf.read(24))
        return self

    @staticmethod
    def _get_hash_recursive(parents):
        if lcmt_point in parents: return 0
        tmphash = (0x573f2fdd2f76508f) & 0xffffffffffffffff
        tmphash  = (((tmphash<<1)&0xffffffffffffffff) + (tmphash>>63)) & 0xffffffffffffffff
        return tmphash
    _packed_fingerprint = None

    @staticmethod
    def _get_packed_fingerprint():
        if lcmt_point._packed_fingerprint is None:
            lcmt_point._packed_fingerprint = struct.pack(">Q", lcmt_point._get_hash_recursive([]))
        return lcmt_point._packed_fingerprint

    def get_hash(self):
        """Get the LCM hash of the struct"""
        return struct.unpack(">Q", lcmt_point._get_packed_fingerprint())[0]

