"""LCM type definitions
This file automatically generated by lcm.
DO NOT MODIFY BY HAND!!!!
"""


from io import BytesIO
import struct

class lcmt_planar_plant_state(object):
    """
    The current status of the entire planar-gripper/brick MBP.  All angular
    positions/velocities are expressed in radians and radians/second.
    """

    __slots__ = ["utime", "num_states", "plant_state"]

    __typenames__ = ["int64_t", "int32_t", "double"]

    __dimensions__ = [None, None, ["num_states"]]

    def __init__(self):
        self.utime = 0
        """
        in microseconds
        LCM Type: int64_t
        """

        self.num_states = 0
        """ LCM Type: int32_t """
        self.plant_state = []
        """ LCM Type: double[num_states] """

    def encode(self):
        buf = BytesIO()
        buf.write(lcmt_planar_plant_state._get_packed_fingerprint())
        self._encode_one(buf)
        return buf.getvalue()

    def _encode_one(self, buf):
        buf.write(struct.pack(">qi", self.utime, self.num_states))
        buf.write(struct.pack('>%dd' % self.num_states, *self.plant_state[:self.num_states]))

    @staticmethod
    def decode(data: bytes):
        if hasattr(data, 'read'):
            buf = data
        else:
            buf = BytesIO(data)
        if buf.read(8) != lcmt_planar_plant_state._get_packed_fingerprint():
            raise ValueError("Decode error")
        return lcmt_planar_plant_state._decode_one(buf)

    @staticmethod
    def _decode_one(buf):
        self = lcmt_planar_plant_state()
        self.utime, self.num_states = struct.unpack(">qi", buf.read(12))
        self.plant_state = struct.unpack('>%dd' % self.num_states, buf.read(self.num_states * 8))
        return self

    @staticmethod
    def _get_hash_recursive(parents):
        if lcmt_planar_plant_state in parents: return 0
        tmphash = (0x19a54319a489b0a5) & 0xffffffffffffffff
        tmphash  = (((tmphash<<1)&0xffffffffffffffff) + (tmphash>>63)) & 0xffffffffffffffff
        return tmphash
    _packed_fingerprint = None

    @staticmethod
    def _get_packed_fingerprint():
        if lcmt_planar_plant_state._packed_fingerprint is None:
            lcmt_planar_plant_state._packed_fingerprint = struct.pack(">Q", lcmt_planar_plant_state._get_hash_recursive([]))
        return lcmt_planar_plant_state._packed_fingerprint

    def get_hash(self):
        """Get the LCM hash of the struct"""
        return struct.unpack(">Q", lcmt_planar_plant_state._get_packed_fingerprint())[0]

