"""LCM type definitions
This file automatically generated by lcm.
DO NOT MODIFY BY HAND!!!!
"""


from io import BytesIO
import struct

class lcmt_planar_manipuland_status(object):

    __slots__ = ["utime", "position", "theta", "velocity", "thetadot"]

    __typenames__ = ["int64_t", "double", "double", "double", "double"]

    __dimensions__ = [None, [2], None, [2], None]

    def __init__(self):
        self.utime = 0
        """
        The timestamp in microseconds
        LCM Type: int64_t
        """

        self.position = [ 0.0 for dim0 in range(2) ]
        """
        The translational position of the manipuland.
        LCM Type: double[2]
        """

        self.theta = 0.0
        """
        The angle of the manipuland.
        LCM Type: double
        """

        self.velocity = [ 0.0 for dim0 in range(2) ]
        """
        The translational velocity of the manipuland.
        LCM Type: double[2]
        """

        self.thetadot = 0.0
        """
        The angular velocity of the manipuland.
        LCM Type: double
        """


    def encode(self):
        buf = BytesIO()
        buf.write(lcmt_planar_manipuland_status._get_packed_fingerprint())
        self._encode_one(buf)
        return buf.getvalue()

    def _encode_one(self, buf):
        buf.write(struct.pack(">q", self.utime))
        buf.write(struct.pack('>2d', *self.position[:2]))
        buf.write(struct.pack(">d", self.theta))
        buf.write(struct.pack('>2d', *self.velocity[:2]))
        buf.write(struct.pack(">d", self.thetadot))

    @staticmethod
    def decode(data: bytes):
        if hasattr(data, 'read'):
            buf = data
        else:
            buf = BytesIO(data)
        if buf.read(8) != lcmt_planar_manipuland_status._get_packed_fingerprint():
            raise ValueError("Decode error")
        return lcmt_planar_manipuland_status._decode_one(buf)

    @staticmethod
    def _decode_one(buf):
        self = lcmt_planar_manipuland_status()
        self.utime = struct.unpack(">q", buf.read(8))[0]
        self.position = struct.unpack('>2d', buf.read(16))
        self.theta = struct.unpack(">d", buf.read(8))[0]
        self.velocity = struct.unpack('>2d', buf.read(16))
        self.thetadot = struct.unpack(">d", buf.read(8))[0]
        return self

    @staticmethod
    def _get_hash_recursive(parents):
        if lcmt_planar_manipuland_status in parents: return 0
        tmphash = (0xd2ae3532484f4461) & 0xffffffffffffffff
        tmphash  = (((tmphash<<1)&0xffffffffffffffff) + (tmphash>>63)) & 0xffffffffffffffff
        return tmphash
    _packed_fingerprint = None

    @staticmethod
    def _get_packed_fingerprint():
        if lcmt_planar_manipuland_status._packed_fingerprint is None:
            lcmt_planar_manipuland_status._packed_fingerprint = struct.pack(">Q", lcmt_planar_manipuland_status._get_hash_recursive([]))
        return lcmt_planar_manipuland_status._packed_fingerprint

    def get_hash(self):
        """Get the LCM hash of the struct"""
        return struct.unpack(">Q", lcmt_planar_manipuland_status._get_packed_fingerprint())[0]

