"""LCM type definitions
This file automatically generated by lcm.
DO NOT MODIFY BY HAND!!!!
"""


from io import BytesIO
import struct

import drake

class lcmt_planar_gripper_finger_face_assignments(object):
    """
    Communicates the finger-face assignments for each finger.
    of the planar-gripper.
    """

    __slots__ = ["utime", "num_fingers", "finger_face_assignments"]

    __typenames__ = ["int64_t", "int32_t", "drake.lcmt_planar_gripper_finger_face_assignment"]

    __dimensions__ = [None, None, ["num_fingers"]]

    def __init__(self):
        self.utime = 0
        """
        in microseconds
        LCM Type: int64_t
        """

        self.num_fingers = 0
        """ LCM Type: int32_t """
        self.finger_face_assignments = []
        """ LCM Type: drake.lcmt_planar_gripper_finger_face_assignment[num_fingers] """

    def encode(self):
        buf = BytesIO()
        buf.write(lcmt_planar_gripper_finger_face_assignments._get_packed_fingerprint())
        self._encode_one(buf)
        return buf.getvalue()

    def _encode_one(self, buf):
        buf.write(struct.pack(">qi", self.utime, self.num_fingers))
        for i0 in range(self.num_fingers):
            assert self.finger_face_assignments[i0]._get_packed_fingerprint() == drake.lcmt_planar_gripper_finger_face_assignment._get_packed_fingerprint()
            self.finger_face_assignments[i0]._encode_one(buf)

    @staticmethod
    def decode(data: bytes):
        if hasattr(data, 'read'):
            buf = data
        else:
            buf = BytesIO(data)
        if buf.read(8) != lcmt_planar_gripper_finger_face_assignments._get_packed_fingerprint():
            raise ValueError("Decode error")
        return lcmt_planar_gripper_finger_face_assignments._decode_one(buf)

    @staticmethod
    def _decode_one(buf):
        self = lcmt_planar_gripper_finger_face_assignments()
        self.utime, self.num_fingers = struct.unpack(">qi", buf.read(12))
        self.finger_face_assignments = []
        for i0 in range(self.num_fingers):
            self.finger_face_assignments.append(drake.lcmt_planar_gripper_finger_face_assignment._decode_one(buf))
        return self

    @staticmethod
    def _get_hash_recursive(parents):
        if lcmt_planar_gripper_finger_face_assignments in parents: return 0
        newparents = parents + [lcmt_planar_gripper_finger_face_assignments]
        tmphash = (0x777a098ee2c75e9c+ drake.lcmt_planar_gripper_finger_face_assignment._get_hash_recursive(newparents)) & 0xffffffffffffffff
        tmphash  = (((tmphash<<1)&0xffffffffffffffff) + (tmphash>>63)) & 0xffffffffffffffff
        return tmphash
    _packed_fingerprint = None

    @staticmethod
    def _get_packed_fingerprint():
        if lcmt_planar_gripper_finger_face_assignments._packed_fingerprint is None:
            lcmt_planar_gripper_finger_face_assignments._packed_fingerprint = struct.pack(">Q", lcmt_planar_gripper_finger_face_assignments._get_hash_recursive([]))
        return lcmt_planar_gripper_finger_face_assignments._packed_fingerprint

    def get_hash(self):
        """Get the LCM hash of the struct"""
        return struct.unpack(">Q", lcmt_planar_gripper_finger_face_assignments._get_packed_fingerprint())[0]

