"""LCM type definitions
This file automatically generated by lcm.
DO NOT MODIFY BY HAND!!!!
"""


from io import BytesIO
import struct

class lcmt_planar_gripper_finger_face_assignment(object):
    """ Communicates the finger-face assignment info for a specified finger. """

    __slots__ = ["utime", "finger_name", "brick_face_name", "p_BoBq_B", "is_in_contact"]

    __typenames__ = ["int64_t", "string", "string", "double", "boolean"]

    __dimensions__ = [None, None, None, [2], None]

    def __init__(self):
        self.utime = 0
        """
        in microseconds
        LCM Type: int64_t
        """

        self.finger_name = ""
        """
        Finger name: {finger1, finger2, finger3}
        LCM Type: string
        """

        self.brick_face_name = ""
        """
        Brick face name: {PosY, NegY, PosZ, NegZ}
        LCM Type: string
        """

        self.p_BoBq_B = [ 0.0 for dim0 in range(2) ]
        """
        The contact point if in contact, or the proximity witness point if not in
        contact. It is position vector from the brick's body B's origin (Bo) to a
        point Bq (a point of B), expressed in B's frame.
        LCM Type: double[2]
        """

        self.is_in_contact = False
        """
        {y-coordinate, z-coordinate}
        A boolean that indicates whether this finger is in contact with the
        specified brick face. If true, the finger is in contact and p_BoBq_B
        indicates the actual contact point. If false, the finger is not in contact
        and p_BoBq_B indicates the witness point to a proximity query.
        LCM Type: boolean
        """


    def encode(self):
        buf = BytesIO()
        buf.write(lcmt_planar_gripper_finger_face_assignment._get_packed_fingerprint())
        self._encode_one(buf)
        return buf.getvalue()

    def _encode_one(self, buf):
        buf.write(struct.pack(">q", self.utime))
        __finger_name_encoded = self.finger_name.encode('utf-8')
        buf.write(struct.pack('>I', len(__finger_name_encoded)+1))
        buf.write(__finger_name_encoded)
        buf.write(b"\0")
        __brick_face_name_encoded = self.brick_face_name.encode('utf-8')
        buf.write(struct.pack('>I', len(__brick_face_name_encoded)+1))
        buf.write(__brick_face_name_encoded)
        buf.write(b"\0")
        buf.write(struct.pack('>2d', *self.p_BoBq_B[:2]))
        buf.write(struct.pack(">b", self.is_in_contact))

    @staticmethod
    def decode(data: bytes):
        if hasattr(data, 'read'):
            buf = data
        else:
            buf = BytesIO(data)
        if buf.read(8) != lcmt_planar_gripper_finger_face_assignment._get_packed_fingerprint():
            raise ValueError("Decode error")
        return lcmt_planar_gripper_finger_face_assignment._decode_one(buf)

    @staticmethod
    def _decode_one(buf):
        self = lcmt_planar_gripper_finger_face_assignment()
        self.utime = struct.unpack(">q", buf.read(8))[0]
        __finger_name_len = struct.unpack('>I', buf.read(4))[0]
        self.finger_name = buf.read(__finger_name_len)[:-1].decode('utf-8', 'replace')
        __brick_face_name_len = struct.unpack('>I', buf.read(4))[0]
        self.brick_face_name = buf.read(__brick_face_name_len)[:-1].decode('utf-8', 'replace')
        self.p_BoBq_B = struct.unpack('>2d', buf.read(16))
        self.is_in_contact = bool(struct.unpack('b', buf.read(1))[0])
        return self

    @staticmethod
    def _get_hash_recursive(parents):
        if lcmt_planar_gripper_finger_face_assignment in parents: return 0
        tmphash = (0xc4fe83a1c182b84d) & 0xffffffffffffffff
        tmphash  = (((tmphash<<1)&0xffffffffffffffff) + (tmphash>>63)) & 0xffffffffffffffff
        return tmphash
    _packed_fingerprint = None

    @staticmethod
    def _get_packed_fingerprint():
        if lcmt_planar_gripper_finger_face_assignment._packed_fingerprint is None:
            lcmt_planar_gripper_finger_face_assignment._packed_fingerprint = struct.pack(">Q", lcmt_planar_gripper_finger_face_assignment._get_hash_recursive([]))
        return lcmt_planar_gripper_finger_face_assignment._packed_fingerprint

    def get_hash(self):
        """Get the LCM hash of the struct"""
        return struct.unpack(">Q", lcmt_planar_gripper_finger_face_assignment._get_packed_fingerprint())[0]

