"""LCM type definitions
This file automatically generated by lcm.
DO NOT MODIFY BY HAND!!!!
"""


from io import BytesIO
import struct

import drake

class lcmt_planar_gripper_command(object):
    """
    Commands a single set of joint states for the planar gripper.  All angular
    positions/velocities are expressed in radians and radians/second.
    """

    __slots__ = ["utime", "num_fingers", "finger_command"]

    __typenames__ = ["int64_t", "int8_t", "drake.lcmt_planar_gripper_finger_command"]

    __dimensions__ = [None, None, ["num_fingers"]]

    def __init__(self):
        self.utime = 0
        """
        The timestamp in microseconds.
        LCM Type: int64_t
        """

        self.num_fingers = 0
        """
        The planar gripper consists of N fingers, each finger consists of two
        actuated joints.
        LCM Type: int8_t
        """

        self.finger_command = []
        """ LCM Type: drake.lcmt_planar_gripper_finger_command[num_fingers] """

    def encode(self):
        buf = BytesIO()
        buf.write(lcmt_planar_gripper_command._get_packed_fingerprint())
        self._encode_one(buf)
        return buf.getvalue()

    def _encode_one(self, buf):
        buf.write(struct.pack(">qb", self.utime, self.num_fingers))
        for i0 in range(self.num_fingers):
            assert self.finger_command[i0]._get_packed_fingerprint() == drake.lcmt_planar_gripper_finger_command._get_packed_fingerprint()
            self.finger_command[i0]._encode_one(buf)

    @staticmethod
    def decode(data: bytes):
        if hasattr(data, 'read'):
            buf = data
        else:
            buf = BytesIO(data)
        if buf.read(8) != lcmt_planar_gripper_command._get_packed_fingerprint():
            raise ValueError("Decode error")
        return lcmt_planar_gripper_command._decode_one(buf)

    @staticmethod
    def _decode_one(buf):
        self = lcmt_planar_gripper_command()
        self.utime, self.num_fingers = struct.unpack(">qb", buf.read(9))
        self.finger_command = []
        for i0 in range(self.num_fingers):
            self.finger_command.append(drake.lcmt_planar_gripper_finger_command._decode_one(buf))
        return self

    @staticmethod
    def _get_hash_recursive(parents):
        if lcmt_planar_gripper_command in parents: return 0
        newparents = parents + [lcmt_planar_gripper_command]
        tmphash = (0x80648ae0ef17d580+ drake.lcmt_planar_gripper_finger_command._get_hash_recursive(newparents)) & 0xffffffffffffffff
        tmphash  = (((tmphash<<1)&0xffffffffffffffff) + (tmphash>>63)) & 0xffffffffffffffff
        return tmphash
    _packed_fingerprint = None

    @staticmethod
    def _get_packed_fingerprint():
        if lcmt_planar_gripper_command._packed_fingerprint is None:
            lcmt_planar_gripper_command._packed_fingerprint = struct.pack(">Q", lcmt_planar_gripper_command._get_hash_recursive([]))
        return lcmt_planar_gripper_command._packed_fingerprint

    def get_hash(self):
        """Get the LCM hash of the struct"""
        return struct.unpack(">Q", lcmt_planar_gripper_command._get_packed_fingerprint())[0]

