"""LCM type definitions
This file automatically generated by lcm.
DO NOT MODIFY BY HAND!!!!
"""


from io import BytesIO
import struct

class lcmt_panda_command(object):
    """
    Commands the desired state of a Franka Panda arm.
    
    The Franka Control Interface provides a number of possible modes to control
    the arm, as described in
    
    https://frankaemika.github.io/docs/libfranka.html#realtime-commands
    
    The expected control mode is given by the control_mode_expected, below.
    
    The num_joint_{position,velocity,torque} size must not have multiple
    different non-zero values.  Each one must be set to either the actual
    number of joints (e.g., 7) or else zero.
    """

    __slots__ = ["utime", "num_joint_position", "joint_position", "num_joint_velocity", "joint_velocity", "num_joint_torque", "joint_torque", "control_mode_expected"]

    __typenames__ = ["int64_t", "int32_t", "double", "int32_t", "double", "int32_t", "double", "int8_t"]

    __dimensions__ = [None, None, ["num_joint_position"], None, ["num_joint_velocity"], None, ["num_joint_torque"], None]

    def __init__(self):
        self.utime = 0
        """
        The timestamp in microseconds.
        LCM Type: int64_t
        """

        self.num_joint_position = 0
        """
        The commanded joint positions in radians.
        
        These values must be provided if the CONTROL_MODE_POSITION bit is set
        within control_mode_expected.
        LCM Type: int32_t
        """

        self.joint_position = []
        """ LCM Type: double[num_joint_position] """
        self.num_joint_velocity = 0
        """
        The commanded joint velocities in radians per second.
        
        These values must be provided if the CONTROL_MODE_VELOCITY bit is set
        within control_mode_expected.
        LCM Type: int32_t
        """

        self.joint_velocity = []
        """ LCM Type: double[num_joint_velocity] """
        self.num_joint_torque = 0
        """
        The commanded joint torques.
        
        These values must be provided if the CONTROL_MODE_TORQUE bit is set
        within control_mode_expected.
        LCM Type: int32_t
        """

        self.joint_torque = []
        """ LCM Type: double[num_joint_torque] """
        self.control_mode_expected = 0
        """
        Describes how the controller expects the driver to be configured.  See
        the values for control_mode in lcmt_panda_status.
        LCM Type: int8_t
        """


    def encode(self):
        buf = BytesIO()
        buf.write(lcmt_panda_command._get_packed_fingerprint())
        self._encode_one(buf)
        return buf.getvalue()

    def _encode_one(self, buf):
        buf.write(struct.pack(">qi", self.utime, self.num_joint_position))
        buf.write(struct.pack('>%dd' % self.num_joint_position, *self.joint_position[:self.num_joint_position]))
        buf.write(struct.pack(">i", self.num_joint_velocity))
        buf.write(struct.pack('>%dd' % self.num_joint_velocity, *self.joint_velocity[:self.num_joint_velocity]))
        buf.write(struct.pack(">i", self.num_joint_torque))
        buf.write(struct.pack('>%dd' % self.num_joint_torque, *self.joint_torque[:self.num_joint_torque]))
        buf.write(struct.pack(">b", self.control_mode_expected))

    @staticmethod
    def decode(data: bytes):
        if hasattr(data, 'read'):
            buf = data
        else:
            buf = BytesIO(data)
        if buf.read(8) != lcmt_panda_command._get_packed_fingerprint():
            raise ValueError("Decode error")
        return lcmt_panda_command._decode_one(buf)

    @staticmethod
    def _decode_one(buf):
        self = lcmt_panda_command()
        self.utime, self.num_joint_position = struct.unpack(">qi", buf.read(12))
        self.joint_position = struct.unpack('>%dd' % self.num_joint_position, buf.read(self.num_joint_position * 8))
        self.num_joint_velocity = struct.unpack(">i", buf.read(4))[0]
        self.joint_velocity = struct.unpack('>%dd' % self.num_joint_velocity, buf.read(self.num_joint_velocity * 8))
        self.num_joint_torque = struct.unpack(">i", buf.read(4))[0]
        self.joint_torque = struct.unpack('>%dd' % self.num_joint_torque, buf.read(self.num_joint_torque * 8))
        self.control_mode_expected = struct.unpack(">b", buf.read(1))[0]
        return self

    @staticmethod
    def _get_hash_recursive(parents):
        if lcmt_panda_command in parents: return 0
        tmphash = (0x7346fbbb8026ace8) & 0xffffffffffffffff
        tmphash  = (((tmphash<<1)&0xffffffffffffffff) + (tmphash>>63)) & 0xffffffffffffffff
        return tmphash
    _packed_fingerprint = None

    @staticmethod
    def _get_packed_fingerprint():
        if lcmt_panda_command._packed_fingerprint is None:
            lcmt_panda_command._packed_fingerprint = struct.pack(">Q", lcmt_panda_command._get_hash_recursive([]))
        return lcmt_panda_command._packed_fingerprint

    def get_hash(self):
        """Get the LCM hash of the struct"""
        return struct.unpack(">Q", lcmt_panda_command._get_packed_fingerprint())[0]

