"""LCM type definitions
This file automatically generated by lcm.
DO NOT MODIFY BY HAND!!!!
"""


from io import BytesIO
import struct

class lcmt_jaco_command(object):
    """
    Commands a single set of joint states for the arm.  All angular
    positions/velocities are expressed in radians and radians/second.
    """

    __slots__ = ["utime", "num_joints", "joint_position", "joint_velocity", "num_fingers", "finger_position", "finger_velocity"]

    __typenames__ = ["int64_t", "int32_t", "double", "double", "int32_t", "double", "double"]

    __dimensions__ = [None, None, ["num_joints"], ["num_joints"], None, ["num_fingers"], ["num_fingers"]]

    def __init__(self):
        self.utime = 0
        """
        The timestamp in microseconds.
        LCM Type: int64_t
        """

        self.num_joints = 0
        """ LCM Type: int32_t """
        self.joint_position = []
        """ LCM Type: double[num_joints] """
        self.joint_velocity = []
        """ LCM Type: double[num_joints] """
        self.num_fingers = 0
        """ LCM Type: int32_t """
        self.finger_position = []
        """ LCM Type: double[num_fingers] """
        self.finger_velocity = []
        """ LCM Type: double[num_fingers] """

    def encode(self):
        buf = BytesIO()
        buf.write(lcmt_jaco_command._get_packed_fingerprint())
        self._encode_one(buf)
        return buf.getvalue()

    def _encode_one(self, buf):
        buf.write(struct.pack(">qi", self.utime, self.num_joints))
        buf.write(struct.pack('>%dd' % self.num_joints, *self.joint_position[:self.num_joints]))
        buf.write(struct.pack('>%dd' % self.num_joints, *self.joint_velocity[:self.num_joints]))
        buf.write(struct.pack(">i", self.num_fingers))
        buf.write(struct.pack('>%dd' % self.num_fingers, *self.finger_position[:self.num_fingers]))
        buf.write(struct.pack('>%dd' % self.num_fingers, *self.finger_velocity[:self.num_fingers]))

    @staticmethod
    def decode(data: bytes):
        if hasattr(data, 'read'):
            buf = data
        else:
            buf = BytesIO(data)
        if buf.read(8) != lcmt_jaco_command._get_packed_fingerprint():
            raise ValueError("Decode error")
        return lcmt_jaco_command._decode_one(buf)

    @staticmethod
    def _decode_one(buf):
        self = lcmt_jaco_command()
        self.utime, self.num_joints = struct.unpack(">qi", buf.read(12))
        self.joint_position = struct.unpack('>%dd' % self.num_joints, buf.read(self.num_joints * 8))
        self.joint_velocity = struct.unpack('>%dd' % self.num_joints, buf.read(self.num_joints * 8))
        self.num_fingers = struct.unpack(">i", buf.read(4))[0]
        self.finger_position = struct.unpack('>%dd' % self.num_fingers, buf.read(self.num_fingers * 8))
        self.finger_velocity = struct.unpack('>%dd' % self.num_fingers, buf.read(self.num_fingers * 8))
        return self

    @staticmethod
    def _get_hash_recursive(parents):
        if lcmt_jaco_command in parents: return 0
        tmphash = (0x4a39790e1f27e20b) & 0xffffffffffffffff
        tmphash  = (((tmphash<<1)&0xffffffffffffffff) + (tmphash>>63)) & 0xffffffffffffffff
        return tmphash
    _packed_fingerprint = None

    @staticmethod
    def _get_packed_fingerprint():
        if lcmt_jaco_command._packed_fingerprint is None:
            lcmt_jaco_command._packed_fingerprint = struct.pack(">Q", lcmt_jaco_command._get_hash_recursive([]))
        return lcmt_jaco_command._packed_fingerprint

    def get_hash(self):
        """Get the LCM hash of the struct"""
        return struct.unpack(">Q", lcmt_jaco_command._get_packed_fingerprint())[0]

