"""LCM type definitions
This file automatically generated by lcm.
DO NOT MODIFY BY HAND!!!!
"""


from io import BytesIO
import struct

class lcmt_iiwa_command(object):
    """ Commands a single set of joint states for the arm. """

    __slots__ = ["utime", "num_joints", "joint_position", "num_torques", "joint_torque"]

    __typenames__ = ["int64_t", "int32_t", "double", "int32_t", "double"]

    __dimensions__ = [None, None, ["num_joints"], None, ["num_torques"]]

    def __init__(self):
        self.utime = 0
        """
        The timestamp in microseconds.
        LCM Type: int64_t
        """

        self.num_joints = 0
        """
        The reference joint positions. They must be sent when the arm is in
        position control mode, but must be of size zero in torque control mode.
        LCM Type: int32_t
        """

        self.joint_position = []
        """ LCM Type: double[num_joints] """
        self.num_torques = 0
        """
        TODO(eric.cousineau): The above name should really be num_position(s).
        However, this may be moot if we transition to more homogeneous middleware
        message types and translation layers.
        The reference joint torques. They should only be sent when the arm is in
        torque control mode. When only positions are being sent, num_torques
        should be set to zero.
        LCM Type: int32_t
        """

        self.joint_torque = []
        """ LCM Type: double[num_torques] """

    def encode(self):
        buf = BytesIO()
        buf.write(lcmt_iiwa_command._get_packed_fingerprint())
        self._encode_one(buf)
        return buf.getvalue()

    def _encode_one(self, buf):
        buf.write(struct.pack(">qi", self.utime, self.num_joints))
        buf.write(struct.pack('>%dd' % self.num_joints, *self.joint_position[:self.num_joints]))
        buf.write(struct.pack(">i", self.num_torques))
        buf.write(struct.pack('>%dd' % self.num_torques, *self.joint_torque[:self.num_torques]))

    @staticmethod
    def decode(data: bytes):
        if hasattr(data, 'read'):
            buf = data
        else:
            buf = BytesIO(data)
        if buf.read(8) != lcmt_iiwa_command._get_packed_fingerprint():
            raise ValueError("Decode error")
        return lcmt_iiwa_command._decode_one(buf)

    @staticmethod
    def _decode_one(buf):
        self = lcmt_iiwa_command()
        self.utime, self.num_joints = struct.unpack(">qi", buf.read(12))
        self.joint_position = struct.unpack('>%dd' % self.num_joints, buf.read(self.num_joints * 8))
        self.num_torques = struct.unpack(">i", buf.read(4))[0]
        self.joint_torque = struct.unpack('>%dd' % self.num_torques, buf.read(self.num_torques * 8))
        return self

    @staticmethod
    def _get_hash_recursive(parents):
        if lcmt_iiwa_command in parents: return 0
        tmphash = (0x6ee3e3b9c640a99a) & 0xffffffffffffffff
        tmphash  = (((tmphash<<1)&0xffffffffffffffff) + (tmphash>>63)) & 0xffffffffffffffff
        return tmphash
    _packed_fingerprint = None

    @staticmethod
    def _get_packed_fingerprint():
        if lcmt_iiwa_command._packed_fingerprint is None:
            lcmt_iiwa_command._packed_fingerprint = struct.pack(">Q", lcmt_iiwa_command._get_hash_recursive([]))
        return lcmt_iiwa_command._packed_fingerprint

    def get_hash(self):
        """Get the LCM hash of the struct"""
        return struct.unpack(">Q", lcmt_iiwa_command._get_packed_fingerprint())[0]

