"""LCM type definitions
This file automatically generated by lcm.
DO NOT MODIFY BY HAND!!!!
"""


from io import BytesIO
import struct

class lcmt_header(object):
    """
    This holds timestamp and a particular coordinate frame.
    This follows ROS's convention except the timestamp since
    utime has been widely used in Drake LCM.
    """

    __slots__ = ["seq", "utime", "frame_name"]

    __typenames__ = ["int32_t", "int64_t", "string"]

    __dimensions__ = [None, None, None]

    def __init__(self):
        self.seq = 0
        """
        Sequence ID: consecutively increasing ID.
        LCM Type: int32_t
        """

        self.utime = 0
        """
        Timestamp in microseconds.
        LCM Type: int64_t
        """

        self.frame_name = ""
        """
        The name of a frame this data is associated with.
        LCM Type: string
        """


    def encode(self):
        buf = BytesIO()
        buf.write(lcmt_header._get_packed_fingerprint())
        self._encode_one(buf)
        return buf.getvalue()

    def _encode_one(self, buf):
        buf.write(struct.pack(">iq", self.seq, self.utime))
        __frame_name_encoded = self.frame_name.encode('utf-8')
        buf.write(struct.pack('>I', len(__frame_name_encoded)+1))
        buf.write(__frame_name_encoded)
        buf.write(b"\0")

    @staticmethod
    def decode(data: bytes):
        if hasattr(data, 'read'):
            buf = data
        else:
            buf = BytesIO(data)
        if buf.read(8) != lcmt_header._get_packed_fingerprint():
            raise ValueError("Decode error")
        return lcmt_header._decode_one(buf)

    @staticmethod
    def _decode_one(buf):
        self = lcmt_header()
        self.seq, self.utime = struct.unpack(">iq", buf.read(12))
        __frame_name_len = struct.unpack('>I', buf.read(4))[0]
        self.frame_name = buf.read(__frame_name_len)[:-1].decode('utf-8', 'replace')
        return self

    @staticmethod
    def _get_hash_recursive(parents):
        if lcmt_header in parents: return 0
        tmphash = (0x9272c333198c72a) & 0xffffffffffffffff
        tmphash  = (((tmphash<<1)&0xffffffffffffffff) + (tmphash>>63)) & 0xffffffffffffffff
        return tmphash
    _packed_fingerprint = None

    @staticmethod
    def _get_packed_fingerprint():
        if lcmt_header._packed_fingerprint is None:
            lcmt_header._packed_fingerprint = struct.pack(">Q", lcmt_header._get_hash_recursive([]))
        return lcmt_header._packed_fingerprint

    def get_hash(self):
        """Get the LCM hash of the struct"""
        return struct.unpack(">Q", lcmt_header._get_packed_fingerprint())[0]

