"""LCM type definitions
This file automatically generated by lcm.
DO NOT MODIFY BY HAND!!!!
"""


from io import BytesIO
import struct

class lcmt_call_python_data(object):
    """
    Generic data structure to wrap Python data types, for use with CallPython.
    For historical reasons, interface is modeled on mxArray (see
    https://www.mathworks.com/help/matlab/matlab_external/matlab-data.html).
    """

    __slots__ = ["data_type", "shape_type", "rows", "cols", "num_bytes", "data"]

    __typenames__ = ["int8_t", "int8_t", "int32_t", "int32_t", "int32_t", "byte"]

    __dimensions__ = [None, None, None, None, None, ["num_bytes"]]

    REMOTE_VARIABLE_REFERENCE = 0
    """ For data_type. """
    DOUBLE = 1
    CHAR = 2
    LOGICAL = 3
    INT = 4
    MATRIX = 0
    """ For shape_type. """
    VECTOR = 1
    SCALAR = 2

    def __init__(self):
        self.data_type = 0
        """ LCM Type: int8_t """
        self.shape_type = 0
        """ LCM Type: int8_t """
        self.rows = 0
        """ LCM Type: int32_t """
        self.cols = 0
        """ LCM Type: int32_t """
        self.num_bytes = 0
        """ LCM Type: int32_t """
        self.data = b""
        """ LCM Type: byte[num_bytes] """

    def encode(self):
        buf = BytesIO()
        buf.write(lcmt_call_python_data._get_packed_fingerprint())
        self._encode_one(buf)
        return buf.getvalue()

    def _encode_one(self, buf):
        buf.write(struct.pack(">bbiii", self.data_type, self.shape_type, self.rows, self.cols, self.num_bytes))
        buf.write(bytearray(self.data[:self.num_bytes]))

    @staticmethod
    def decode(data: bytes):
        if hasattr(data, 'read'):
            buf = data
        else:
            buf = BytesIO(data)
        if buf.read(8) != lcmt_call_python_data._get_packed_fingerprint():
            raise ValueError("Decode error")
        return lcmt_call_python_data._decode_one(buf)

    @staticmethod
    def _decode_one(buf):
        self = lcmt_call_python_data()
        self.data_type, self.shape_type, self.rows, self.cols, self.num_bytes = struct.unpack(">bbiii", buf.read(14))
        self.data = buf.read(self.num_bytes)
        return self

    @staticmethod
    def _get_hash_recursive(parents):
        if lcmt_call_python_data in parents: return 0
        tmphash = (0xba5185e6611ca4e8) & 0xffffffffffffffff
        tmphash  = (((tmphash<<1)&0xffffffffffffffff) + (tmphash>>63)) & 0xffffffffffffffff
        return tmphash
    _packed_fingerprint = None

    @staticmethod
    def _get_packed_fingerprint():
        if lcmt_call_python_data._packed_fingerprint is None:
            lcmt_call_python_data._packed_fingerprint = struct.pack(">Q", lcmt_call_python_data._get_hash_recursive([]))
        return lcmt_call_python_data._packed_fingerprint

    def get_hash(self):
        """Get the LCM hash of the struct"""
        return struct.unpack(">Q", lcmt_call_python_data._get_packed_fingerprint())[0]

