"""LCM type definitions
This file automatically generated by lcm.
DO NOT MODIFY BY HAND!!!!
"""


from io import BytesIO
import struct

import drake

class lcmt_call_python(object):
    """
    Message to support asynchronous remote procedure calls to a Python
    client. For historical reasons, interface is modeled on mexCallMATLAB
    (see https://www.mathworks.com/help/matlab/apiref/mexcallmatlab.html) but
    with output arguments assigned in the remote client workspace due to the
    asynchronous nature of the protocol.
    """

    __slots__ = ["function_name", "lhs", "num_rhs", "rhs"]

    __typenames__ = ["string", "int64_t", "int32_t", "drake.lcmt_call_python_data"]

    __dimensions__ = [None, None, None, ["num_rhs"]]

    def __init__(self):
        self.function_name = ""
        """
        Any expression that resolves to a callable Python object.
        LCM Type: string
        """

        self.lhs = 0
        """
        Unique id for variable held in the client workspace.
        LCM Type: int64_t
        """

        self.num_rhs = 0
        """
        Input argument data.
        LCM Type: int32_t
        """

        self.rhs = []
        """ LCM Type: drake.lcmt_call_python_data[num_rhs] """

    def encode(self):
        buf = BytesIO()
        buf.write(lcmt_call_python._get_packed_fingerprint())
        self._encode_one(buf)
        return buf.getvalue()

    def _encode_one(self, buf):
        __function_name_encoded = self.function_name.encode('utf-8')
        buf.write(struct.pack('>I', len(__function_name_encoded)+1))
        buf.write(__function_name_encoded)
        buf.write(b"\0")
        buf.write(struct.pack(">qi", self.lhs, self.num_rhs))
        for i0 in range(self.num_rhs):
            assert self.rhs[i0]._get_packed_fingerprint() == drake.lcmt_call_python_data._get_packed_fingerprint()
            self.rhs[i0]._encode_one(buf)

    @staticmethod
    def decode(data: bytes):
        if hasattr(data, 'read'):
            buf = data
        else:
            buf = BytesIO(data)
        if buf.read(8) != lcmt_call_python._get_packed_fingerprint():
            raise ValueError("Decode error")
        return lcmt_call_python._decode_one(buf)

    @staticmethod
    def _decode_one(buf):
        self = lcmt_call_python()
        __function_name_len = struct.unpack('>I', buf.read(4))[0]
        self.function_name = buf.read(__function_name_len)[:-1].decode('utf-8', 'replace')
        self.lhs, self.num_rhs = struct.unpack(">qi", buf.read(12))
        self.rhs = []
        for i0 in range(self.num_rhs):
            self.rhs.append(drake.lcmt_call_python_data._decode_one(buf))
        return self

    @staticmethod
    def _get_hash_recursive(parents):
        if lcmt_call_python in parents: return 0
        newparents = parents + [lcmt_call_python]
        tmphash = (0x30b0ddcf5c354914+ drake.lcmt_call_python_data._get_hash_recursive(newparents)) & 0xffffffffffffffff
        tmphash  = (((tmphash<<1)&0xffffffffffffffff) + (tmphash>>63)) & 0xffffffffffffffff
        return tmphash
    _packed_fingerprint = None

    @staticmethod
    def _get_packed_fingerprint():
        if lcmt_call_python._packed_fingerprint is None:
            lcmt_call_python._packed_fingerprint = struct.pack(">Q", lcmt_call_python._get_hash_recursive([]))
        return lcmt_call_python._packed_fingerprint

    def get_hash(self):
        """Get the LCM hash of the struct"""
        return struct.unpack(">Q", lcmt_call_python._get_packed_fingerprint())[0]

