/*
 * Decompiled with CFR 0.152.
 */
package drake;

import drake.lcmt_header;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import lcm.lcm.LCMDataInputStream;
import lcm.lcm.LCMEncodable;

public final class lcmt_image
implements LCMEncodable {
    public lcmt_header header;
    public int width;
    public int height;
    public int row_stride;
    public int size;
    public byte[] data;
    public boolean bigendian;
    public byte pixel_format;
    public byte channel_type;
    public byte compression_method;
    public static final long LCM_FINGERPRINT = lcmt_image._hashRecursive(new ArrayList());
    public static final long LCM_FINGERPRINT_BASE = -3717184912201837164L;
    public static final byte PIXEL_FORMAT_GRAY = 0;
    public static final byte PIXEL_FORMAT_RGB = 1;
    public static final byte PIXEL_FORMAT_BGR = 2;
    public static final byte PIXEL_FORMAT_RGBA = 3;
    public static final byte PIXEL_FORMAT_BGRA = 4;
    public static final byte PIXEL_FORMAT_DEPTH = 5;
    public static final byte PIXEL_FORMAT_LABEL = 6;
    public static final byte PIXEL_FORMAT_MASK = 7;
    public static final byte PIXEL_FORMAT_DISPARITY = 8;
    public static final byte PIXEL_FORMAT_BAYER_BGGR = 9;
    public static final byte PIXEL_FORMAT_BAYER_RGGB = 10;
    public static final byte PIXEL_FORMAT_BAYER_GBRG = 11;
    public static final byte PIXEL_FORMAT_BAYER_GRBG = 12;
    public static final byte PIXEL_FORMAT_INVALID = -1;
    public static final byte CHANNEL_TYPE_INT8 = 0;
    public static final byte CHANNEL_TYPE_UINT8 = 1;
    public static final byte CHANNEL_TYPE_INT16 = 2;
    public static final byte CHANNEL_TYPE_UINT16 = 3;
    public static final byte CHANNEL_TYPE_INT32 = 4;
    public static final byte CHANNEL_TYPE_UINT32 = 5;
    public static final byte CHANNEL_TYPE_FLOAT32 = 6;
    public static final byte CHANNEL_TYPE_FLOAT64 = 7;
    public static final byte CHANNEL_TYPE_INVALID = -1;
    public static final byte COMPRESSION_METHOD_NOT_COMPRESSED = 0;
    public static final byte COMPRESSION_METHOD_ZLIB = 1;
    public static final byte COMPRESSION_METHOD_JPEG = 2;
    public static final byte COMPRESSION_METHOD_PNG = 3;
    public static final byte COMPRESSION_METHOD_INVALID = -1;

    public lcmt_image() {
    }

    public static long _hashRecursive(ArrayList<Class<?>> classes) {
        if (classes.contains(lcmt_image.class)) {
            return 0L;
        }
        classes.add(lcmt_image.class);
        long hash = -3717184912201837164L + lcmt_header._hashRecursive(classes);
        classes.remove(classes.size() - 1);
        return (hash << 1) + (hash >> 63 & 1L);
    }

    public void encode(DataOutput outs) throws IOException {
        outs.writeLong(LCM_FINGERPRINT);
        this._encodeRecursive(outs);
    }

    public void _encodeRecursive(DataOutput outs) throws IOException {
        this.header._encodeRecursive(outs);
        outs.writeInt(this.width);
        outs.writeInt(this.height);
        outs.writeInt(this.row_stride);
        outs.writeInt(this.size);
        if (this.size > 0) {
            outs.write(this.data, 0, this.size);
        }
        outs.writeByte(this.bigendian ? 1 : 0);
        outs.writeByte(this.pixel_format);
        outs.writeByte(this.channel_type);
        outs.writeByte(this.compression_method);
    }

    public lcmt_image(byte[] data) throws IOException {
        this((DataInput)new LCMDataInputStream(data));
    }

    public lcmt_image(DataInput ins) throws IOException {
        if (ins.readLong() != LCM_FINGERPRINT) {
            throw new IOException("LCM Decode error: bad fingerprint");
        }
        this._decodeRecursive(ins);
    }

    public static lcmt_image _decodeRecursiveFactory(DataInput ins) throws IOException {
        lcmt_image o = new lcmt_image();
        o._decodeRecursive(ins);
        return o;
    }

    public void _decodeRecursive(DataInput ins) throws IOException {
        this.header = lcmt_header._decodeRecursiveFactory(ins);
        this.width = ins.readInt();
        this.height = ins.readInt();
        this.row_stride = ins.readInt();
        this.size = ins.readInt();
        this.data = new byte[this.size];
        ins.readFully(this.data, 0, this.size);
        this.bigendian = ins.readByte() != 0;
        this.pixel_format = ins.readByte();
        this.channel_type = ins.readByte();
        this.compression_method = ins.readByte();
    }

    public lcmt_image copy() {
        lcmt_image outobj = new lcmt_image();
        outobj.header = this.header.copy();
        outobj.width = this.width;
        outobj.height = this.height;
        outobj.row_stride = this.row_stride;
        outobj.size = this.size;
        outobj.data = new byte[this.size];
        if (this.size > 0) {
            System.arraycopy(this.data, 0, outobj.data, 0, this.size);
        }
        outobj.bigendian = this.bigendian;
        outobj.pixel_format = this.pixel_format;
        outobj.channel_type = this.channel_type;
        outobj.compression_method = this.compression_method;
        return outobj;
    }
}

