/*
 * Decompiled with CFR 0.152.
 */
package drake;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import lcm.lcm.LCMDataInputStream;
import lcm.lcm.LCMEncodable;

public final class lcmt_iiwa_command
implements LCMEncodable {
    public long utime;
    public int num_joints;
    public double[] joint_position;
    public int num_torques;
    public double[] joint_torque;
    public static final long LCM_FINGERPRINT = lcmt_iiwa_command._hashRecursive(new ArrayList());
    public static final long LCM_FINGERPRINT_BASE = 7990480550919973274L;

    public lcmt_iiwa_command() {
    }

    public static long _hashRecursive(ArrayList<Class<?>> classes) {
        if (classes.contains(lcmt_iiwa_command.class)) {
            return 0L;
        }
        classes.add(lcmt_iiwa_command.class);
        long hash = 7990480550919973274L;
        classes.remove(classes.size() - 1);
        return (hash << 1) + (hash >> 63 & 1L);
    }

    public void encode(DataOutput outs) throws IOException {
        outs.writeLong(LCM_FINGERPRINT);
        this._encodeRecursive(outs);
    }

    public void _encodeRecursive(DataOutput outs) throws IOException {
        int a;
        outs.writeLong(this.utime);
        outs.writeInt(this.num_joints);
        for (a = 0; a < this.num_joints; ++a) {
            outs.writeDouble(this.joint_position[a]);
        }
        outs.writeInt(this.num_torques);
        for (a = 0; a < this.num_torques; ++a) {
            outs.writeDouble(this.joint_torque[a]);
        }
    }

    public lcmt_iiwa_command(byte[] data) throws IOException {
        this((DataInput)new LCMDataInputStream(data));
    }

    public lcmt_iiwa_command(DataInput ins) throws IOException {
        if (ins.readLong() != LCM_FINGERPRINT) {
            throw new IOException("LCM Decode error: bad fingerprint");
        }
        this._decodeRecursive(ins);
    }

    public static lcmt_iiwa_command _decodeRecursiveFactory(DataInput ins) throws IOException {
        lcmt_iiwa_command o = new lcmt_iiwa_command();
        o._decodeRecursive(ins);
        return o;
    }

    public void _decodeRecursive(DataInput ins) throws IOException {
        int a;
        this.utime = ins.readLong();
        this.num_joints = ins.readInt();
        this.joint_position = new double[this.num_joints];
        for (a = 0; a < this.num_joints; ++a) {
            this.joint_position[a] = ins.readDouble();
        }
        this.num_torques = ins.readInt();
        this.joint_torque = new double[this.num_torques];
        for (a = 0; a < this.num_torques; ++a) {
            this.joint_torque[a] = ins.readDouble();
        }
    }

    public lcmt_iiwa_command copy() {
        lcmt_iiwa_command outobj = new lcmt_iiwa_command();
        outobj.utime = this.utime;
        outobj.num_joints = this.num_joints;
        outobj.joint_position = new double[this.num_joints];
        if (this.num_joints > 0) {
            System.arraycopy(this.joint_position, 0, outobj.joint_position, 0, this.num_joints);
        }
        outobj.num_torques = this.num_torques;
        outobj.joint_torque = new double[this.num_torques];
        if (this.num_torques > 0) {
            System.arraycopy(this.joint_torque, 0, outobj.joint_torque, 0, this.num_torques);
        }
        return outobj;
    }
}

